Ext.define('componentDashboard.view.virtual.VirtualMemoryGrid', {
	extend: 'utilities.CustomGrid',
	alias:'widget.virtualmemorygrid',
	jsonData : null,
	cls:'gridSkin',
	hideHeaders:true,
	id:'memorygrid',
	initComponent:function()
	{
		jsonData = this.jsonData;
		if(!Ext.isEmpty(jsonData))
		{
			var storeFields = [];
			var columns=new Array();
			var custom_unit;
			for(var i=0; i<2; i++)
			{
				var measureCol=new Object();
				if(i==0)
				{
					custom_unit= jsonData[i].unit;
					measureCol.dataIndex = "measure";
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						if(!Ext.isEmpty(record.get('measure'))){
							var mes = record.get(('measure'));
							return (mes+custom_unit);
						}
					}
				}
				else
				{
					custom_unit= jsonData[i].unit;
					measureCol.dataIndex = "currentMesValue";
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						if(!Ext.isEmpty(record.get('currentMesValue'))){
							return record.get(('currentMesValue'));
						}
					}
				}
				storeFields.push(measureCol.dataIndex);
				columns.push(measureCol);
			}
			
			var gridStore = Ext.create('Ext.data.Store',{
				fields : storeFields,

				proxy: {
					type: 'memory',
					reader: {
						type: 'json',
						root:'0'
					}
				},
				data:jsonData
			});
			this.store = gridStore;
			this.columns=columns;
		}
		else
		{
			this.columns=[];
		}
		
		this.callParent();
	}

});
