Ext.define('componentDashboard.view.virtual.VirtualSystemLowerPanel', {
	extend: 'utilities.ScrollPanel',
	alias:'widget.virtualsystemlowerpanel',
	layout : {
		type:'vbox',
		align:'stretch',
		defaultMargins:10
	},
	//bodyCls: 'virtual-tab-upper-Background',
	jsonData:null,
	items : [],
	
	setData:function(){
		var jsonData=this.jsonData;
		var me=this;
		var toppanelitems=new Array();
		var middlepanelitems=new Array();
		var bottompanelitems=new Array();
		
		var healthchart;
		if(!Ext.isEmpty(jsonData) && typeof jsonData.errorMsg === "undefined")
		{
			var selectedsub;
			if(typeof jsonData.subsystemCombo.selected !== "undefined")
			{
				selectedsub = jsonData.subsystemCombo.selected;
			}
			if(selectedsub.indexOf("Overview") > -1)
			{
				var colwidth = 1/4;
				if(typeof(jsonData.LowerPanel.PieGraph) !== "undefined")
				{
					toppanelitems.push(this.piegraph(jsonData.LowerPanel.PieGraph,colwidth));
				}
				if(typeof(jsonData.LowerPanel.DialChart) !== "undefined")
				{
					for(var i=0;i<jsonData.LowerPanel.DialChart.length;i++)
						toppanelitems.push(this.dialcharts(jsonData.LowerPanel.DialChart[i],colwidth));
				}
				if(!Ext.isEmpty(jsonData.LowerPanel.Health))
				{
					if(typeof(jsonData.LowerPanel.Health.errorMsg)==="undefined"){
						var htmlstring = this.returnChartHTML(jsonData.LowerPanel.Health);
						if(valueFusion)
						{
							healthchart={
												xtype : 'panel',
												border:true,
												cls:'datapanel',
												margin:'0 0 0 0',
												//style:{'border':'1px solid #c3c3c3'},
												html : htmlstring,
												//cls : 'header-image',
												title : jsonData.LowerPanel.Health.title,
												flex:1,
												height: 186,
												maxWidth :300,
												//minWidth :300,
												minHeight:180
									}
						}
						else
						{
							
								var errHtml = '<center><div style="margin:12% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div >No measures available</div></div></center>';

								var temp='<div style="display:inline-block;"><div style="text-align:center;font-weight:bold;font-size:12px;">'+jsonData.LowerPanel.Health.title+'</div></div>';

								healthchart = new Ext.Panel ({
								layout: 'fit',
								height:250,
								frame:true,
								flex:.33,
								title:jsonData.LowerPanel.Health.title,
								id:'panelIdNewID',
								html :temp,
								cls:'optionalListPanel',
								listeners:{
									'afterrender' : function(c) {
										var formdata = jsonData.LowerPanel.Health;
										
										if(Ext.isEmpty(formdata.dataXML.DataSet))
										{
											Ext.getCmp('panelIdNewID').update(errHtml);
										}
										else
										{
											formdata['showLegend']=false;
											formdata['title']=jsonData.LowerPanel.Health.title;
											formdata['fromPage']='insideView';
											formdata['tick'] = false;
											formdata['barMarginFrom'] = 'insideview';
											formdata['isMax'] = false;
											var barChart = {};
											barChart = jQuery.extend(true, {}, createBar(c.body.id,215,300), barChart);
											barChart.setData(formdata,'','','bar');
											barChart.drawChart();
										}
									}
								}
							});
						}
						middlepanelitems.push(healthchart);
					}
					else{
						middlepanelitems.push(this.errorPanel(jsonData.LowerPanel.Health.errorMsg, jsonData.LowerPanel.Health.title));
					}
				
					//middlepanelitems.push(this.piegraph(jsonData.Health,1/3));
				}
				if(!Ext.isEmpty(jsonData.LowerPanel.KeyPerf))
				{
					var diskTable;
					var fieldsArray = new Array();
					var columnsArray = new Array();
					for(var i=0 ; i<jsonData.LowerPanel.KeyPerf.keyheaders.length ; i++)
					{
						var data = new Object();
						if(i==0)
						{
							data.text = jsonData.LowerPanel.KeyPerf.keyheaders[i].name;
							data.dataIndex = "value"+i;
							data.menuDisabled = true;
							data.renderer = function(value,metaData,record,rowIndex,colIndex)
							{
								var mes = record.get('value0');
								var state = "state_"+record.raw.state;
								var link = record.raw.URL;
								//link = link.replace(/(egDashBoardLayers)/,'egMonDashboard');
								var ret ='<div class="'+state+'"style="margin-top:1px"</div><div style="margin-left:20px" class = "zoneuser-left"><a href="'+link+'">'+mes+'</a></div>';
								return ret;
							}
						}
						else
						{
							data.text = jsonData.LowerPanel.KeyPerf.keyheaders[i].name;
							data.dataIndex = "value"+i;
							data.menuDisabled = true;
							data.align='right';
						}
						columnsArray.push(data);		
						fieldsArray.push(data.dataIndex);	
					}
					
					var gridStore = Ext.create('Ext.data.Store', {
					    fields : fieldsArray,
					    proxy: {
					    	type: 'memory',
					         reader: {
					             type: 'json',
					             root: '0'
					         }
					     },
					     data :jsonData.LowerPanel.KeyPerf.items
					 });
					
					var custtitle = '<b>'+jsonData.LowerPanel.KeyPerf.title+'</b>';
					diskTable = {
							xtype :'customgrid',
							flex:1,
							margin:'0 0 0 10',
							store : gridStore,
							title: custtitle,
							titleAlign:'left',
							forceFit:true,
							columns: columnsArray,
							cls:'gridSkin horizontal-scroll',
							
					 	};
					middlepanelitems.push(diskTable);
				}
				else
				{
					diskTable = this.errorPanelNoTitle(jsonData.LowerPanel.KeyPerf.errorMsg);
					middlepanelitems.push(diskTable);
				}
					//middlepanelitems.push(this.returnDiskGrid(jsonData.KeyPerf,2/3));
				if(!Ext.isEmpty(jsonData.LowerPanel.Graph))
				{
					for(var i=0;i<jsonData.LowerPanel.Graph.length;i++)
						bottompanelitems.push(this.dialchartsAll(jsonData.LowerPanel.Graph[i],1/3,"VirtualSystemTabGraph"+i));
				}
				
			var topPanel = {
					xtype : 'panel',
					cls:'datapanel',
					layout : 'hbox',
					//style:{'border':'1px solid #c3c3c3'},
					//align: 'center',
					flex:1,
					border: true,
					//columnWidth: colwidth,
					//bodyCls: 'virtual-tab-upper-Background',
					//cls : 'header-image event-header-align',
					items : toppanelitems
			};
			var middlePanel = {
					xtype : 'panel',
					//style:{'border':'1px solid red'},
					layout : {type:'hbox',align:'stretch'},
					border:true,
					//bodyCls: 'virtual-tab-upper-Background',
					//cls : 'header-image event-header-align',
					items : middlepanelitems
			};
			var bottomPanel = {
					xtype : 'panel',
					layout : 'column',
					border:true,
					//style:{'border':'1px solid red'},
					//bodyCls: 'virtual-tab-upper-Background history-mask',
					//cls : 'header-image event-header-align',
					flex:.33,
					id:'VirtualSystemTabInner123',
					items : bottompanelitems
			};
			me.add(topPanel);
			me.add(middlePanel);
			me.add(bottomPanel);
			
			me.doLayout();
		}
		else if(jsonData.errorMsg !=="undefined")
		{
			var lowerPanel;
			var graphItems = new Array();
			for(var i=0;i<jsonData.LowerPanel.Graph.length;i++)
			{
				graphItems.push(this.dialchartsAll(jsonData.LowerPanel.Graph[i],1/3,"VirtualSystemTabGraph"+i));
			}
			lowerPanel={
					xtype: 'panel',
					cls:'datapanel',
					layout: {type:'column'},
					defaults:{columnWidth:.33},
					border:true,
					//style:{'border':'1px solid red'},
					items: graphItems,
					cls:'componentnetworkseperator',
					flex:1,
					height:280,
					//width:300,
					//autoScroll:true,
					//bodyCls: 'virtual-tab-upper-Background history-mask',
					id:'VirtualSystemTabInner',
					border:true
					
			};
			me.add(lowerPanel);
			me.doLayout();
		}
		
	}
	else
	{
		var msg = jsonData.errorMsg;
		var nodata={
				xtype:'panel',
				layout:'fit',
				border:false,
				html : '<div style="text-align:center;padding:38px; top:100px; height:155px" class="system-error-bg"><br><img class="iconInformation" border="0"/><div class="list-empty-text system-error-bg">'+msg+'</div></div>'
		}
		me.add(nodata);
		me.doLayout();
	}
	},

	dialcharts:function(dialchart,width){
		if(typeof dialchart.errorMsg === "undefined")
		{
			var chartPanel = "";
			if(!Ext.isEmpty(dialchart.chartInx))
			{
				
				if(valueFusion)
				{
					chartPanel = {
						id:dialchart.chartInx,
						xtype : 'container',
						cls:'fancy_border',
						border:true,
						//style:{'border':'1px solid red'},
						html : '<center><div><b>'+dialchart.title+'</b></div></br><div id="'+dialchart.divId+'"  style="height:100%;"></div></center>',
						columnWidth : width,
						//title : dialchart.title,
						height: 180,
						padding:'10 0 0 0',
						flex:.23,
						type:'fusion',
						//minWidth :240,
						fcObj:dialchart,
						clickUrl:dialchart.layerPageUrl,
						listeners:{
							'afterrender': function(thisFC2Obj)
							{
								if  ( FusionCharts( thisFC2Obj.fcObj.fcId ) )
										FusionCharts( thisFC2Obj.fcObj.fcId ).dispose();
								var myChart = new FusionCharts( thisFC2Obj.fcObj.movie,thisFC2Obj.fcObj.fcId, thisFC2Obj.fcObj.ChartWidth, thisFC2Obj.ChartHeight,"0","1");
								myChart.setXMLData(thisFC2Obj.fcObj.dataXML);
								myChart.setTransparent(true);
								myChart.render(thisFC2Obj.fcObj.divId);
							}
						}
					 }
				}
				else
				{
					chartPanel = {
						id:dialchart.chartInx,
						xtype : 'container',
						cls:'componentnetworkseperator',
						border:true,
						//style:{'border':'1px solid red'},
						html : '<center><div><b>'+dialchart.title+'</b></div></br><div id="'+dialchart.divId+'"  style="height:100%;"></div></center>',
						columnWidth : width,
						//title : dialchart.title,
						height: 180,
						//padding:'10 10 10 10',
						flex:.23,
						//type:'fusion',
						width :242,
						fcObj:dialchart,
						clickUrl:dialchart.layerPageUrl,
						listeners:{
							'afterrender': function(thisFC2Obj)
							{
								var jsonData = thisFC2Obj.fcObj.chartXML;
								jsonData['useHtml'] = true;
								getHighChartsGuage(thisFC2Obj.id,jsonData,'InsideViewDashboard');
							}
						}
					}
				}
			}
			else
			{
				
				var htmlstring=this.returnChartHTML(dialchart);
				chartPanel = {
						xtype : 'panel',
						cls:'componentnetworkseperator',
						border:false,
						//layout:'fit',
						//html : '<center><div><b>'+dialchart.title+'</b></div><div>'+htmlstring+'</div></center>',
						//cls : 'virtual-tab-system-header history-tab-header header-image',
						//bodyCls:'virtual-tab-upper-Background',
						html:'<div style="margin:auto;padding:3px;display:inline-block;"><div style="text-align:center;"  class="font_bold12">'+dialchart.title+'</b></div><center><div style="text-align:center;margin:15% 0 auto 0;height:113px" class="system-error-bg"><center><div style="margin:5% 0 auto 0" class="iconInformation"></div></center><div class="list-empty-text system-error-bg">No Measure Available</div></div></center>',
						columnWidth : width,
						//title : dialchart.title,
						type:'flash',
						height: 180,
						minWidth :240
					}
			}
			return chartPanel;
		}
		else
		{
			
			//return this.errorPanel(dialchart.errorMsg, dialchart.title,width);
			var config={
				xtype : 'panel',
				cls:'componentnetworkseperator',
				height: 150,
				//style:{'border':'1px solid #c3c3c3'},
				border : false,
				//margin:'6 10 0 0',
				width:'25%',
			//	padding:10,
				//html : '<div><b>'+dialchart.title+'</b></div><center><div style="text-align:center;margin:15% 0 auto 0;height:113px" class="system-error-bg"><center><div style="margin:5% 0 auto 0" class="iconInformation"></div></center><div class="list-empty-text system-error-bg">No Measure Available</div></div></center>'
				html:'<div style="margin:10px auto;padding:3px;display:inline-block;"><div style="text-align:center;"  class="font_bold12">'+dialchart.title+'</b></div><center><div style="text-align:center;margin:23% 0 auto 0;height:113px" class="system-error-bg"><center><div style="margin:15% 0 auto 0" class="iconInformation"></div></center><div class="list-empty-text system-error-bg">No Measure Available</div></div></center>',
			};
			if(!Ext.isEmpty(width)){
				config.columnWidth=0.33;
			}
			return Ext.create('Ext.panel.Panel',config);
		}
	},
	dialchartsAll:function(dialchart,width,id){
		var errMsg = '<center><div style="margin:12% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div >No measures available</div></div></center>';
		if(typeof(dialchart.errorMsg)==="undefined"){
			var digitalPanel = "";
			if(!Ext.isEmpty(dialchart.Url))
			{
				if ( !Ext.isEmpty( dialchart.chartOption ) && dialchart.chartOption=='highcharts')
				{
					var isAxisTimeReq = false;
					var legendPos = "bottom";
					var imgId = dialchart.grpId;
					var graphUrl = dialchart.Url;
					var panTitle=dialchart.title;
					imgDiv = '<div class="component-list-left-font" style="width:100%">'+dialchart.title+'</div><center><div id="'+imgId+'"/></div></center>';
					graphUrl = graphUrl+"&isSmall=true";
					var bigGrpUrl=dialchart.fullViewUrl;
					var containerId = imgId;
					var sparObj = Ext.getCmp(containerId);
					if (!Ext.isEmpty(sparObj))
					{
						sparObj.destroy();
					}
					var widthValue =$(window).width();
					var hideTool = ( !Ext.isEmpty(graphUrl) && graphUrl.indexOf("/final/images") > -1 )?true:false;
					digitalPanel = {
						id:containerId,
						xtype : 'panel',
						title: panTitle,
						cls:'datapanel optionalListPanel',
						border:true,
						//style:{'border':'1px solid '},
						border:false,
						html:imgDiv,
						bodyPadding:'10',
						//margin: "5 10 5 0",
						//height: 250,
						minWidth:( (widthValue/3) -43),
						height:250,
						columnWidth:.33,
						//padding:10,
						margin: "10 8 10 8",
						//columnWidth :0,
						listeners:{
							'afterrender': function(v){
								//var widthValue =$(window).width();
								widthValue = ( (widthValue/3) -75);
								
								if(graphUrl.indexOf("/final/images") > -1)
								{
									//graphUrl = graphUrl.substring(0,graphUrl.indexOf("&isSmall"));
									Ext.getCmp(containerId).update(errMsg);
									
								}
								else
									bigHighChart(graphUrl,v.body.id,212,widthValue,bigGrpUrl,isAxisTimeReq,legendPos,'upper','true');
								
							}
						},
						clickUrl:bigGrpUrl,
						tools:[{
									xtype:'button',
									//cls:'iconMaximize',
									iconCls:'iconMaximize',
									style:{'background':'none'},
									clickUrl:bigGrpUrl,
									//hidden:hideTool,
									border:false,
									
									listeners:{
									'afterrender':function(thisObj){
										
										thisObj.el.on('click',function(){
											componentDashboard.app.getController("VirtualController").displayBigGraph(thisObj.clickUrl,"Measuregraph");
											
										});
									}
								}
							}]
						
					}
				}
				else
				{
					digitalPanel = {
						xtype : 'panel',
						cls:'fancy_border',
						border:true,
						html : '<div align="center" style="width:100%;height:100%;" class="systemTab-bg"><img id="'+id+'" src = "'+dialchart.Url +'" onload="virtualsystemgraphload(\''+id+'\');"/></div>',
						columnWidth : width,
						title : dialchart.title,
						height: 250,
						type:'fusion',
						//minWidth :240,
						width:'32%',
						clickUrl:dialchart.fullViewUrl,
						listeners:{
							render:function(thisObj){
								thisObj.el.on('click',function(){
									if ( !Ext.isEmpty( thisObj.clickUrl ) && thisObj.clickUrl.indexOf('DashboardTimelineMeasures')>-1)
									{
										componentDashboard.app.getController("VirtualController").displayBigGraph(thisObj,"Measuregraph")
									}
								});
							}
						}
					}
				}
			}
			else if(!Ext.isEmpty(dialchart.dataXML))
			{
				if(valueFusion)
				{
					digitalPanel = {
						id:dialchart.chartInx,
						xtype : 'panel',
						cls:'datapanel optionalListPanel',
						border:true,
						//style:{'border':'1px solid #c3c3c3'},
						html : '<center><div><b>'+dialchart.title+'</b></div></center><br/><div id="'+dialchart.divId+'" style="height:100%;"></div>',
						//cls : 'datapanel',
						//columnWidth : width,
						//title : dialchart.title,
						height: 225,
						margin: "5 10 5 0",
						type:'fusion',
						//minWidth :240,
						//width:'32%',
						fcObj:dialchart,
						clickUrl:dialchart.ddGraphUrlLarge,
						listeners:{
							'afterrender': function(thisFC2Obj)
							{
								if  ( FusionCharts( thisFC2Obj.fcObj.fcId ) )
										FusionCharts( thisFC2Obj.fcObj.fcId ).dispose();
								var myChart = new FusionCharts( thisFC2Obj.fcObj.movie,thisFC2Obj.fcObj.fcId, thisFC2Obj.fcObj.GraphWidth, thisFC2Obj.GraphHeight,"0","1");
								myChart.setXMLData(thisFC2Obj.fcObj.dataXML);
								myChart.setTransparent(true);
								myChart.render(thisFC2Obj.fcObj.divId);
							}
						}
					}
				}
				else
				{
					var widthValue =$(window).width();
					var errHtml = '<center><div style="margin:12% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div >No measures available</div></div></center>';
					
					
					digitalPanel = {
						id:dialchart.chartInx,
						xtype : 'panel',
						cls:'datapanel optionalListPanel',
						autoScroll:true,
						border:true,
						frame:false,
						title : dialchart.title,
						height: 250,
						margin: "10 8 10 8",
						columnWidth:.33,
						fcObj:dialchart,
						minWidth:( (widthValue/3) -43),
						clickUrl:dialchart.ddGraphUrlLarge,
						tools:[{
									xtype:'button',
									//cls:'iconMaximize',
									iconCls:'iconMaximize',
									style:{'background':'none'},
									border:false,
									toolfcObj:dialchart,
									clickUrl:dialchart.ddGraphUrlLarge,
									listeners:{
									'afterrender':function(thisObj){
										thisObj.el.on('click',function(){
											var dataUrl =thisObj.toolfcObj.maxViewId;
											var splitValue = dataUrl.split('^eg^');
											
											
											showFullviewVMTab(splitValue[0],event,splitValue[1]);
										});
									}
								}
							}],
						items: [{
								html : '<div id="'+dialchart.divId+'" style="height:100%;"></div>'
						}],
						listeners:{
							'afterrender': function(thisFC2Obj)
							{
								if(!Ext.isEmpty(thisFC2Obj.fcObj.dataXML.DataSet))
								{
									var panelWidth = ( $( window ).width() / 3 ) - 100;
									
									var height =thisFC2Obj.fcObj.dataXML.chartHeight ;
									var width =thisFC2Obj.fcObj.dataXML.GraphWidth ;
								
									var formdata =thisFC2Obj.fcObj.dataXML;
									formdata['showLegend']=false;
									formdata['fromPage']='insideView';
									formdata['barMarginFrom'] = 'insideview';
									formdata['isMax'] = false;
									var barChart = {};
									//barChart = jQuery.extend(true, {}, createBar(thisFC2Obj.fcObj.divId,height,260), barChart);
									barChart = jQuery.extend(true, {}, createBar(thisFC2Obj.fcObj.divId,height,panelWidth), barChart);
									barChart.setData(formdata,'','','bar');
									barChart.drawChart();
								}
								else
								{
									Ext.getCmp(dialchart.chartInx).update(errHtml);
								}
							}
						}
					}
				}

			}
			return digitalPanel;
		}
		else{
			//return this.errorPanel(dialchart.errorMsg, dialchart.title);
			return this.errorPanelNew(dialchart.errorMsg, dialchart.title,dialchart);
		}
	},
	errorPanelNew:function(errorMsg,titles,dialchart){
		var widthValue =$(window).width();
	    var config={
			xtype:'panel',
			id:dialchart.chartInx,
			cls:'datapanel optionalListPanel',
			height: 250,
			style:{'border':'1px solid #c3c3c3'},
			border : false,
			minWidth:( (widthValue/3) -43),
			margin: "10 10 10 10",
			//width:'32%',
			padding:10,
			title : titles,
			html : '<div><b></b></div><center><div style="text-align:center;margin:15% 0 auto 0;height:250px" class="system-error-bg"><center><div style="margin:5% 0 auto 0" class="iconInformation"></div></center><div class="list-empty-text system-error-bg">'+errorMsg+'</div></div></center>',
			clickUrl:dialchart.ddGraphUrlLarge,
			tools:[{
					xtype:'button',
					//cls:'iconMaximize',
					iconCls:'iconMaximize',
					style:{'background':'none'},
					border:false,
					toolfcObj:dialchart,
					clickUrl:dialchart.ddGraphUrlLarge,
					listeners:{
					'afterrender':function(thisObj){
						thisObj.el.on('click',function(){
							var dataUrl =thisObj.toolfcObj.maxViewId;
							var splitValue = dataUrl.split('^eg^');
							showFullviewVMTab(splitValue[0],event,splitValue[1]);
						});
					}
				}
			}],
		};
		//if(!Ext.isEmpty(columnWidth)){
		//	config.columnWidth=0.33;
		//}
		return Ext.create('Ext.panel.Panel',config);
	},
	errorPanel:function(errorMsg,titles,columnWidth){
		var widthValue =$(window).width();
	    var config={
			cls:'datapanel optionalListPanel',
			height: 250,
			//style:{'border':'1px solid #c3c3c3'},
			border : true,
			bodyPadding:'10',
			minWidth:( (widthValue/3) -43),
			margin: "10 10 10 10",
			//width:'32%',
			padding:0,
			//title : titles,			
			html : '<div style="text-align:center"><b>'+titles+'</b></div><center><div style="text-align:center;margin:15% 0 auto 0;height:250px" class="system-error-bg"><center><div style="margin:5% 0 auto 0" class="iconInformation"></div></center><div class="list-empty-text system-error-bg">'+errorMsg+'</div></div></center>'
		};
		if(!Ext.isEmpty(columnWidth)){
			config.columnWidth=0.33;
		}
		return Ext.create('Ext.panel.Panel',config);
	},
	piegraph : function(jsonData,columnWid){
		if(typeof(jsonData.errorMsg)==='undefined'){
		/*var htmlstring = this.returnChartHTML(jsonData);
		var chartPanel = {
				xtype : 'panel',
				border:false,
				layout:'fit',
				html : htmlstring,
				cls : 'history-tab-header-image history-tab-header header-image',
				bodyCls:'virtual-tab-upper-Background',
				title : jsonData.title,
				type:'flash',
				columnWidth : columnWid,
				height: 180,
				minWidth :240
			}*/
			var chartPanel="";
			if(!Ext.isEmpty(jsonData.chartInx))
			{
			
				if(valueFusion)
				{
					chartPanel = {
						xtype : 'container',
						border:false,
						height: 150,
						minWidth :240,
						width:240,
						cls:'fancy_border',
						//layout:'vbox',
						items:[
							{
								xtype:'container',
								html:'<div style="border:0px solid red;text-align:center;margin-top:10px"><b>'+jsonData.title+'</b></div>'
							},
							{
								xtype:'panel',
								//id:jsonData.chartInx,
								height: 150,
								id:jsonData.divId,
								//html : '<center><div id="'+jsonData.divId+'" ></div></center>',
								fcObj:jsonData,
								minWidth :240,
								style:{'border':'0px solid red','padding':'10px'},
								listeners:{
									'afterrender': function(thisFC2Obj)
									{
										if  ( FusionCharts( thisFC2Obj.fcObj.fcId ) )
												FusionCharts( thisFC2Obj.fcObj.fcId ).dispose();
										var myChart = new FusionCharts( thisFC2Obj.fcObj.movie,thisFC2Obj.fcObj.fcId, thisFC2Obj.fcObj.GraphWidth, thisFC2Obj.GraphHeight,"0","1");
										myChart.setXMLData(thisFC2Obj.fcObj.dataXML);
										myChart.setTransparent(true);
										myChart.render(thisFC2Obj.fcObj.divId);
									}
								}
							}
						]
					}
				}
				else
				{
					
					chartPanel = {
						xtype : 'container',
						border:true,
						height: 180,
						minWidth :240,
						width:240,
						cls:'componentnetworkseperator',
						//layout:'vbox',
						items:[{
								xtype:'panel',
								//html:'<div style="border:0px solid red;text-align:center;margin-top:10px"><b>'+jsonData.title+'</b></div>',
								//id:jsonData.chartInx,
								//html:"222222222",
								height: 150,
								id:jsonData.divId,
								fcObj:jsonData,
								minWidth :240,
								style:{'border':'0px solid red'},
								listeners:{
									'render' : function(thisFC2Obj) {
										var jsonResult=thisFC2Obj.fcObj.dataXML;
										
										jsonResult['title']=jsonData.title;
										jsonResult['unit']='%';
										var pieChart = {};
										pieChart = jQuery.extend(true, {}, createBar(thisFC2Obj.id,150,250), pieChart);
										pieChart.setData(jsonResult,'','','pie');
										pieChart.drawChart();
									}
								}
							}]
						}
					}
					
						/*chartPanel = {
							id:jsonData.chartInx,
							xtype : 'panel',
							border:false,
							html : '<center><div><b>'+jsonData.title+'</b></div><div id="'+jsonData.divId+'" ></div></center>',
							columnWidth : columnWid,
							//title : jsonData.title,
							height: 180,
							type:'fusion',
							minWidth :240,
							fcObj:jsonData,
							listeners:{
								'afterrender': function(thisFC2Obj)
								{
									if  ( FusionCharts( thisFC2Obj.fcObj.fcId ) )
											FusionCharts( thisFC2Obj.fcObj.fcId ).dispose();
									var myChart = new FusionCharts( thisFC2Obj.fcObj.movie,thisFC2Obj.fcObj.fcId, thisFC2Obj.fcObj.GraphWidth, thisFC2Obj.GraphHeight,"0","1");
									myChart.setXMLData(thisFC2Obj.fcObj.dataXML);
									myChart.setTransparent(true);
									myChart.render(thisFC2Obj.fcObj.divId);
								}
							}
						}*/
					
				}
			return chartPanel;
		}
		else{
			//return this.errorPanel(jsonData.errorMsg, jsonData.title);
			return Ext.create('Ext.panel.Panel',{
				border:false,
				html : '<div style="text-align:center;padding:38px; top:100px; height:155px" class="system-error-bg"><div><b>'+jsonData.title+'</b></div><br><img class="iconInformation" border="0"/><br/><div class="list-empty-text system-error-bg">'+jsonData.errorMsg+'</div></div>'
			});
		}
	},
	returnChartHTML :function(jsonData){
		var htmlstring = '<div style=" width:100%; height:100%;" class="systemTab-bg">'
			+'<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="" id="objTagBottomId" flashVars="&dataXML='+ jsonData.dataXML +'&chartWidth= "90%"&chartHeight=""  align="center" valign="middle" id="StackedColumn3D" >'
			+'<param name="movie" value="/final/FusionCharts/swf/'+jsonData.GraphFile+'" />'
			+'<param name="FlashVars" value="&dataXML='+ jsonData.dataXML +'&chartWidth= "90%" &chartHeight= "90%"/>'
			+'<param name="quality" value="high" />'
			+'<param name="WMode" value="Transparent"/>'
			+'<embed wmode="transparent" src="/final/FusionCharts/swf/'+jsonData.GraphFile+'" flashVars="&dataXML='+jsonData.dataXML+'&chartWidth="90%"&chartHeight="90%" quality="high" width="90%" align="center" valign="middle" name="'+ jsonData.GraphFile +'" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer"/>'
		+'</object>'
			+'</div>';
		return  htmlstring;
		
	}

});