Ext.state.Manager.setProvider(
new Ext.state.CookieProvider({
expires: new Date(new Date().getTime()+(1000*60*60*24*30)) //30 days from now
}));
Ext.QuickTips.init();
Ext.define('componentDashboard.view.virtual.VirtualTabInsideview', {
	extend: 'Ext.tab.Panel',
	alias:'widget.virtualtabinsideview',
	border:false,
	cls: 'tablayout',
	layout : 'fit',
	margin:'0 0 10 0',
	id:'virtualtabinsideview',
	stateEvents: ['tabchange'],
	activeTab: 0,
	//style:{'border':'1px solid red'},
	stateful:true,
	
	items:[{
		xtype:'measuresdata',
		id:'md1',
		scroll:true,
		autoScroll:true,
		title:'Measures',
	
	},{
		xtype:'virtualsystemtab',
		id:'s1',
		scroll:true,
		autoScroll:true,
		title:'System',
		
	},{
		xtype:'networktab',
		id:'n1',
		scroll:true,
		autoScroll:true,
		title:'Network',
		
	}],
	listeners: { 
		'tabchange': function(tabObj,tab){
			//alert(tabObj.getActiveTab().id);
			var tab = Ext.getCmp(tabObj.getActiveTab().id);
			this.setActiveTab(tab);
			Ext.state.Manager.set(tab, tabObj.getActiveTab().id);
		},
		'beforerender':function(thisObj){
			Ext.state.Manager.get('active_tab', thisObj.activeTab);
			//var tab = Ext.getCmp(thisObj.getActiveTab().id);
			//this.setActiveTab(tab);
			//Ext.state.Manager.set(tab, thisObj.getActiveTab().id);
		}
	},
	initComponent:function()
	{
		this.callParent();
	}
	
});