Ext.define('componentDashboard.view.virtual.insideUpperPanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.insideupperpanel',
	requires:['componentDashboard.model.virtualOutsideUpperCombo','componentDashboard.model.componentVirtualCombo','utilities.ScrollCombo'],
	layout : {
		type : 'hbox',
		align: 'stretch'
	},
	jsonData : null,
	baseCls:'appDashboardsTopPanel',
	//style:{'border':'1px solid yellow'},
	//bodyCls:'virtual-tab-upper-Background top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
	border:true,
	height:130,
	initComponent : function(){
		var jsonData = this.jsonData;
		var subsystemcomboStore=Ext.create('Ext.data.Store',{
		model:'componentDashboard.model.componentVirtualCombo',
		proxy: {
				type: 'memory',
			    reader: {
			            type: 'json',
			            root:'subSystemComboValues'
			        }
			    },
			    data:jsonData
			});
			var viewcomboStore=Ext.create('Ext.data.Store',{
				model:'componentDashboard.model.virtualOutsideUpperCombo',
			    proxy: {
			        type: 'memory',
			        reader: {
			            type: 'json',
			            root:'viewComboOptions'
			        }
			    },
			    data:jsonData
			});
			var leftPanel={
					xtype: 'panel',
					layout: {
						type:'vbox',
						align:'stretch',
						pack:'center',
						defaultMargins:10
					},
					border: false,
					align: 'center',
					width:300,
					items:[{
						xtype:'scrollcombo',
						store:subsystemcomboStore,
						emptyText:jsonData.subSystemComboValues[0].value,
			    	    fieldLabel:jsonData.screenLabels.SubsystemComboTitle,
			    	    editable:false,
			    	    valueField:'value',
			    	    displayField:'valueText',
			    	    itemId:'SubsystemCombo',
			    	    cls:'dropdown',
			    	    value:jsonData.selectedSubsystem.selected
					},
					{
						xtype:'scrollcombo',
						store:viewcomboStore,
						emptyText:jsonData.viewComboOptions[0].value,
			    	    fieldLabel:jsonData.screenLabels.ViewComboTitle,
			    	    editable:false,
			    	    valueField:'value',
			    	    displayField:'name',
			    	    cls:'dropdown',
			    	    value:jsonData.viewComboSelected

					}]
			};
			var rightPanel;
			var gridItems = new Array();
			gridItems.push(this.returnGrid(jsonData.upperGrid));
			
			//var vmdetailsTitle='<div class="title">'+jsonData.title+'</div>';
			rightPanel={
					xtype: 'panel',
					//title:jsonData.title,
					//cls:'frameset',
					id:'dd',
					layout: 'fit',
					border: false,
					flex:1,
					//html:vmdetailsTitle,
					margin: "10 10 10 10",
					items:gridItems
					};
			
			var blankLine = this.returnBlankLine(180);
			this.items=[leftPanel,blankLine,rightPanel];

			this.callParent();
	 },
	 returnGrid : function(jsonData)
		{
			
			var gridStore = Ext.create('Ext.data.Store',{
				fields : ['measure','value'],

				proxy: {
					type: 'memory',
					reader: {
						type: 'json',
						root:'upperGridInfo'
					}
				},
				data:jsonData
			});
			
			var gridHeader='<b>'+jsonData.title+'</b>';
			var outGrid={
					xtype:'customgrid',
					title:gridHeader,
					cls:'gridSkin customHeader',
					titleAlign: 'left',
					padding:0,
					margin:5,
					bodyPadding:0,
					hideHeaders:true,
					border: false,
					store:gridStore,
					viewConfig: {
						emptyText: '<center><div style="margin:0.5% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div >No details found</div></div></center>',
						deferEmptyText: false,
					},
					height:200,
					forceFit: true,
					columns:[{
						dataIndex:'measure'
					},
					{
						dataIndex:'value'
					}]
			};
			
					
			return outGrid;
		},
		returnBlankLine : function(heights){
			var empty =  {
				xtype:'panel',
				cls:'blankline',
				height:heights,
				width:1
			}
			return empty;
		}
});