Ext.define('componentDashboard.view.virtual.virtualOutsideGraphPanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.virtualoutsidegraphpanel',
	layout :{
		type:'vbox',
		align:'stretch'
	},
	margin:'0',
	jsonData : null,
	//cls:'datapanel',
	//style:{'border':'1px solid #c3c3c3'},
	//bodyCls:'virtual-tab-upper-Background top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
	border:true,
	//style:{'border':'1px solid red'},
	initComponent : function(){
	jsonData=this.jsonData;
	if(!Ext.isEmpty(jsonData))
	{
		//this.title = jsonData.screenLabels.OutsidechartLabels.ChartHeader;
		if(typeof jsonData.upperGaugeChartData !== "undefined")
		{
			var graphItems = new Array();
			var graphLength = jsonData.upperGaugeChartData.length;
			var columnWid = 1/graphLength;
			for(var i=0;i<graphLength;i++)
			{
				graphItems.push(this.returnGraph(jsonData.upperGaugeChartData[i],columnWid));
			}
			var graphPanel={
					//xtype:'panel',
					cls:'datapanel',
					title:'<span style="font-size:12px">'+jsonData.screenLabels.OutsidechartLabels.ChartHeader+'</span>',
					border:false,
					margin:'3 3 10 3',
					//style:{'border':'1px solid #c3c3c3'},
					//bodyCls:'virtual-tab-upper-Background',
					//layout:'column',
					layout: {type:'hbox',align:'stretch'},
					columnWidth:columnWid,
					items:graphItems,
					height:100,
					flex:1
			};
			
			var measures = new Array(); 
			try
			{
				var custom_length = jsonData.outsideBottomGridArray.length;
				for(var i=0;i<custom_length;i++)
				{
					measures.push(this.returndiv(jsonData.outsideBottomGridArray[i]));
				}
				var belowPanel={
						xtype:'scrollpanel',
						cls:'datapanel',
						title:'<span style="font-size:12px">'+jsonData.screenLabels.OutsidechartLabels.LowerPanelHeader+'</span>',
						padding:0,
						margin:'0 3 10 3',
						bodyPadding:10,
						//style:{'border':'1px solid #c3c3c3'},
						border:true,
						html:[measures],
						flex:1,
						//bodyCls:'virtual-tab-upper-Background'
				};
				var blankLine = this.returnBlankLine(1400);
				this.items=[graphPanel,belowPanel];				
			}
			catch (e)
			{
				var img = jsonData.NoDataAvailable.imageURL;
				var msg = jsonData.NoDataAvailable.errorMessage;
				var errPanel = {
						xtype:'panel',
						margin: "0 10 10 10",
						height:200,
						border:false,
						forcefit: true,
						bodyCls:'virtual-tab-upper-Background',
						html:'<center><div class="iconInformation" style="margin:6% 0 auto 0"></div><div>'+msg+'</div></center>'
					 }
				this.items=[graphPanel,errPanel]; 
			}
			
		}
		else
		{
			var img = jsonData.NoDataAvailable.imageURL;
			var msg = jsonData.NoDataAvailable.errorMessage;
			var errPanel = {
					xtype:'panel',
					margin: "0 10 10 10",
					height:200,
					border:false,
					forcefit: true,
					bodyCls:'virtual-tab-upper-Background',
					html:'<center><div class="iconInformation" style="margin:10% 0 auto 0"></div><div>'+msg+'</div></center>'
				 }
			this.items=[errPanel]; 
		}
	}
	else
	{
		var errPanel = {
				xtype:'errorpanel'
		}
		this.items=[errPanel];
	}
	this.callParent();
},
	returnGraph:function(jsonData,columnWid)
	{
		var graphPanel;
		var imgSrc = jsonData.URL;
		var imgId = jsonData.ifmId;
		var imgHeight = jsonData.height;
		var layerURl = jsonData.layerUrl;
		var errHtml = '<center><div style="margin:12% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div >No measures available</div></div></center>';
		
		var title = '';		//'<b>'+jsonData.LabelForGraph+'</b>';
		if(valueFusion)
		{
		graphPanel={
				xtype: 'container',
				border: true,
				layout:{
					type:'vbox',
					align:'stretch'
				},
				margin: "4 4 4 4",
				columnWidth: columnWid,
				items : [{
					xtype : 'label',
					html : title
				},{
					xtype : 'container',
					height: 200,
					margin:'4 0 0 0',
					html:'<iframe frameBorder="0" ALLOWTRANSPARENCY="true" scrolling="no" width="100%" height="100%"  src="'+imgSrc+'"/></iframe>'
				}]
			};
			return graphPanel;
		}
		else
		{
		
			chartPanel = {
				id:imgId,
				xtype : 'panel',
				border:false,
				padding:5,
				cls:'componentnetworkseperator rajuHeader',
				margin:'0 0 5 0',
				//layout:'fit',
				flex : 1,
				clickUrl:layerURl,
				height:190,
				//width:185,
				listeners:{
					afterRender:function(panel){
						Ext.Ajax.request({
						url:imgSrc,
						success : function(response){
							
							try{
									var formdata = Ext.decode(response.responseText);
									var jsonData = formdata.chartXML;
								
									jsonData['useHtml'] = false;
									var strSkinclr = ( strSkin == 'Dark' )?'#c6c6c6':'#333333';
									jsonData['strSkinclr'] = strSkinclr;
									var Dial_Fullview = jsonData['Dial_Fullview'];
									var methodName = jsonData['METHOD_NAME'];
									var params = jsonData['PARAMS'];
									var ttip = (Ext.isEmpty(jsonData['ttitle']))?'':jsonData['ttitle'];
							
									getHighChartsGuage(imgId,jsonData,'virtualTabUpperPanel');
									if(Dial_Fullview != '' && Dial_Fullview!= undefined && Dial_Fullview=='true')
									{
										panel.addDocked({
											xtype: 'toolbar',
											dock: 'top',
											width: '100%',
											items: [
												{
												xtype: 'container',
												//margin:'0 0 0 0',
												width:"90%",
												style:{'text-align':'center'},
												html:'<span class="f12-bold" style = "display:block;">'+ttip+'</span>'
											},
											'->',{
												text:'',
												cls:'iconMaximize',
												tooltip:ttip,
												handler : function()
												{
													showMaximizedView(params);
												}
											}]
										});
									}
								}catch(err){
									Ext.getCmp(imgId).update(response.responseText);
								}
							},
						});
					}
				}
			}
			return chartPanel;
		}
	},
	returndiv:function(jsonData)
	{
		var custom_measure = jsonData.measure+jsonData.unit;
		var custom_measvalue = jsonData.currentMesValue;
		var state = "state_"+jsonData.stateValue;
		var link = jsonData.link;
		var divtoreturn = '<div style="float:left;width:370px;"><table width="100%" style="float:left;"><tr><td width="70%"><div style="float:left;" class="'+state+'"></div><a href="'+link+'"><div style="float:left;padding-left: 5px;">  '+custom_measure+'</div></a></td><td width="30%" style="padding:10px;">'+custom_measvalue+'</table></tr></td></div>';
		return divtoreturn;
	},
	returnBlankLine : function(widths){
		var empty =  {
			xtype:'panel',
			height:1,
			width:widths,
			//flex : .1,
			style:'border-left: 1px solid #ABACAE;border-right: 1px solid #FAFAFA;'
		}
		return empty;
	}
});