Ext.define('componentDashboard.view.virtual.virtualOutsideUpperPanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.virtualoutsideupperpanel',
	requires:['componentDashboard.model.virtualOutsideUpperCombo','componentDashboard.model.componentVirtualCombo'],
	layout : {
		type : 'hbox',
		align: 'stretch'
	},
	baseCls:'appDashboardsTopPanel',
	//style:{'border':'1px solid red'},
	 jsonData : null,
	 //bodyCls:'virtual-tab-upper-Background top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
	 border:true,
	//style:{'border':'1px solid blue'},
	 height:150,
	 
	 initComponent : function(){
			var jsonData = this.jsonData;
			var subsystemcomboStore=Ext.create('Ext.data.Store',{
				model:'componentDashboard.model.componentVirtualCombo',
			    proxy: {
			        type: 'memory',
			        reader: {
			            type: 'json',
			            root:'subSystemComboValues'
			        }
			    },
			    data:jsonData
			});
			var viewcomboStore=Ext.create('Ext.data.Store',{
				model:'componentDashboard.model.virtualOutsideUpperCombo',
			    proxy: {
			        type: 'memory',
			        reader: {
			            type: 'json',
			            root:'viewComboOptions'
			        }
			    },
			    data:jsonData
			});
			var leftPanel={
					xtype: 'panel',
					border: false,
					layout: {
						type:'vbox',
						align:'stretch',
						pack:'center',
						defaultMargins:10
					},
					align: 'center',
					//bodyCls: 'virtual-tab-upper-Background top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					width:330,
					items:[{
						xtype:'scrollcombo',
						store:subsystemcomboStore,
						emptyText:jsonData.subSystemComboValues[0].value,
			    	    fieldLabel:jsonData.screenLabels.SubsystemComboTitle,
			    	    editable:false,
			    	    valueField:'value',
			    	    displayField:'valueText',
			    	    itemId:'SubsystemCombo',
			    	    cls:'dropdown',
			    	    value:jsonData.selectedSubsystem.selected,
						width:200
					},
					{
						xtype:'scrollcombo',
						store:viewcomboStore,
						emptyText:jsonData.viewComboOptions[0].value,
			    	    fieldLabel:jsonData.screenLabels.ViewComboTitle,
			    	    editable:false,
			    	    valueField:'value',
			    	    displayField:'name',
			    	    cls:'dropdown',
			    	    value:jsonData.viewComboSelected,
						width:200

					}]
			};
			var rightPanel;
			var gridItems = new Array();
			gridItems.push(this.returnGrid(jsonData.upperGrid));
			
			rightPanel={
					xtype: 'panel',
					border: false,
					layout: 'fit',
					//bodyCls: 'virtual-tab-upper-Background top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					flex:.60,
					margin: "10 10 10 10",
					items:gridItems
					};
			var blankLine = this.returnBlankLine(180);
			//this.items=[leftPanel,blankLine,rightPanel];
			this.items=[leftPanel,blankLine,rightPanel];
			this.callParent();
	 },
	 returnGrid : function(jsonData)
		{
			var gridStore = Ext.create('Ext.data.Store',{
				fields : ['measure','value'],

				proxy: {
					type: 'memory',
					reader: {
						type: 'json',
						root:'upperGridInfo'
					}
				},
				data:jsonData
			});
			
			var gridTitle = '<b>'+jsonData.title+'</b>';
			var outGrid={
					xtype:'customgrid',
					cls:'gridSkin horizontal-scroll customHeader',
					title:gridTitle,
					titleAlign: 'left',
					border: false,
					forceFit: false,
					margin:5,
					hideHeaders:true,
					store:gridStore,
					viewConfig: {
						emptyText: '<center><div style="margin:1% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div >No details found</div></div></center>',
						deferEmptyText: false,
					},
					height:200,
					//forceFit: true,
					columns:[{
						dataIndex:'measure',
						flex:.45,
						
					},
					{
						dataIndex:'value',
						flex:.45
					}]
			};
			return outGrid;
		},
		returnBlankLine : function(heights){
			var empty =  {
				xtype:'panel',
				height:heights,
				width:1,
				//style:'border-left: 1px solid #ABACAE;border-right: 1px solid #FAFAFA;'
				//style:'border: 1px solid violet;'
			}
			return empty;
		}
});