Ext.define('componentDashboard.view.virtual.virtualUpperPanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.virtualupperpanel',
	requires:['componentDashboard.model.componentVirtualCombo','utilities.ScrollCombo'],
	layout : {
		type : 'hbox',
		align: 'stretch'
	},
	 jsonData : null,
	baseCls:'appDashboardsTopPanel',
	//style:{'border':'1px solid blue'},
	 //bodyCls:'virtual-tab-upper-Background top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
	 border:true,
	 height:150,
	 
	 initComponent : function(){
			var jsonData = this.jsonData;	
			var subsystemcomboStore=Ext.create('Ext.data.Store',{
				model:'componentDashboard.model.componentVirtualCombo',
			    proxy: {
			        type: 'memory',
			        reader: {
			            type: 'json',
			            root:'subSystemComboValues'
			        }
			    },
			    data:jsonData
			});
			var viewcomboStore=Ext.create('Ext.data.Store',{
				model:'componentDashboard.model.componentVirtualCombo',
			    proxy: {
			        type: 'memory',
			        reader: {
			            type: 'json',
			            root:'viewComboOptions'
			        }
			    },
			    data:jsonData
			});
			
			var leftPanel={
					xtype: 'panel',
					border: false,
					layout: {
						type:'vbox',
						align:'stretch',
						pack:'center',
						defaultMargins:10
					},
					align: 'center',
					width:300,
					items:[{
						xtype:'scrollcombo',
						store:subsystemcomboStore,
						emptyText:jsonData.subSystemComboValues[0].value,
			    	    fieldLabel:jsonData.screenLabels.SubsystemComboTitle,
			    	    editable:false,
			    	    valueField:'value',
			    	    displayField:'valueText',
			    	    itemId:'SubsystemCombo',
			    	    cls:'dropdown',
			    	    value:jsonData.selectedSubsystem.selected
					},
					{
						xtype:'scrollcombo',
						store:viewcomboStore,
						emptyText:jsonData.viewComboOptions[0].value,
			    	    fieldLabel:jsonData.screenLabels.ViewComboTitle,
			    	    editable:false,
			    	    valueField:'value',
			    	    displayField:'valueText',
			    	    cls:'dropdown',
			    	    value:jsonData.viewComboSelected

					}]
			};
			var rightPanel;
			var type = jsonData.selectedSubsystem.selected;
				var chartItems = new Array();
				var chartLength = jsonData.upperGaugeChartData.length;
				var columnWid = 1/3;
				
				//case for memory and disk
				if(typeof(jsonData.pieChartInfo)!=='undefined')
				{
					var chartPanel;
					var imgSrc = jsonData.pieChartInfo.URL;
					if(typeof(jsonData.pieChartInfo.Message)!=='undefined')
					{
						
						var custTitle = jsonData.pieChartInfo.legendLabel;
						if(custTitle.indexOf('MB') > -1)
						{
							if(custTitle.indexOf('space') > -1)
							{
								var pieTitle = '<div style="text-align:center;"><div data-qtip="'+jsonData.pieChartInfo.legendLabel+'" class="f12-bold">Disk Space (MB)</div></div>';
							}
							else
							{
								var pieTitle = '<div style="text-align:center;"><div data-qtip="'+jsonData.pieChartInfo.legendLabel+'" class="f12-bold">Memory (MB)</div></div>';
							}
						}
						else
						{
							var pieTitle = '<div style="text-align:center;"><div data-qtip="'+jsonData.pieChartInfo.legendLabel+'" class="f12-bold">Disk Space (GB)</div></div>';
						}
						
						var msg = jsonData.pieChartInfo.Message;
						chartPanel = {
								xtype : 'panel',
								cls:'componentnetworkseperator',
								border:false,
								layout:'auto',
								//padding:'15 5 5 5',
								flex : 1,
								html : '<center><div style="margin:0.9% 0 auto 0;text-align: center;" class="f12-bold">'+pieTitle+'</div><div style="margin:15% 0 auto 0" class="iconInformation"></div><div class="f12-normal">'+msg+'</div></center>'
								/*columnWidth: columnWid		*/
						};
					}
					else
					{
						if(!valueFusion)
						{
							var errHtml = '<center><div style="margin:12% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div >No measures available</div></div></center>';
							chartPanel = {
										xtype : 'container',
										border:false,
										cls:'componentnetworkseperator',
										padding:5,
										margin:'0 0 5 0',
										flex : 1,
										width:500,
										height:140,
										id:'pieId',
										html:'',
										//html:'<iframe frameBorder="0" scrolling="no" align="middle"  width="100%" height="100%" src="'+imgSrc+'"/></iframe>',
										/*html:'<div class="iconInformation"></div><br/><div>'+jsonData.pieChartInfo.Message+'</div>',*/
										columnWidth: columnWid,
										width:100,
										listeners:{
											afterRender:function(thisObj){
											//		ids = v.body.id
												Ext.Ajax.request({
														url:imgSrc,
														success : function(response) {
														//	try
														//	{
																
																var formdata = Ext.decode(response.responseText);
																var titleColor = ( strSkin == 'Dark' )?'#9b9fa1':'#333333';
																
																var titleValue = formdata.pieChartData.title;
																
																//if(formdata.pieChartData.title == 'Total memory (MB),Free memory (MB)')
																if(titleValue.indexOf('MB') > -1)
																{
																	if(titleValue.indexOf('space') > -1)
																	{
																		var pieTitle = '<div style="text-align:center;"><div data-qtip="'+formdata.pieChartData.title+'" class="f12-bold" style="color:'+titleColor+';">Disk Space (MB)</div></div>';
																	}
																	else
																	{
																		var pieTitle = '<div style="text-align:center;"><div data-qtip="'+formdata.pieChartData.title+'" class="f12-bold" style="color:'+titleColor+';">Memory (MB)</div></div>';
																	}
																}
																else
																{
																	
																	var pieTitle = '<div style="text-align:center;"><div data-qtip="'+formdata.pieChartData.title+'" class="f12-bold" style="color:'+titleColor+';">Disk Space (GB)</div></div>';
																}

																//thisObj.setTitle(pieTitle);
																
																formdata['title'] =pieTitle;
																formdata['useHtml']=true;
																var pieChart = {};
																pieChart = jQuery.extend(true, {}, createBar(thisObj.id,140,200), pieChart);
																pieChart.setData(formdata,'','','pie');
																pieChart.drawChart();
														//	}
														//	catch (err)
														//	{
															//	Ext.getCmp('pieId').update(errHtml);
														//	}
															
														},
														
												});
											}
										}
								};
						}
						else
						{
							chartPanel = {
										xtype : 'container',
										border:false,
										cls:'componentnetworkseperator',
										padding:5,
										margin:'0 0 5 0',
										flex : 1,
										width:339,
										height:128,
										id:'pieId',
										html:'<iframe frameBorder="0" scrolling="no" align="middle"  width="100%" height="100%" src="'+imgSrc+'"/></iframe>',
										/*html:'<div class="iconInformation"></div><br/><div>'+jsonData.pieChartInfo.Message+'</div>',*/
										columnWidth: columnWid
								};
						}
					}
					chartItems.push(chartPanel);
				}
				for(var i=0;i<chartLength;i++){
					chartItems.push(this.returnChart(jsonData.upperGaugeChartData[i],columnWid));
				}
			rightPanel={
					xtype: 'panel',
					border: false,
					layout: {type:'hbox',align:'stretch'},
					flex:1,
					//style:{'border':'1px solid red'},
					margin: "0 0 0 10",
					items:chartItems
					};
			var blankLine = this.returnBlankLine(180);
			this.items = [leftPanel,blankLine,rightPanel];
			//this.items = [blankLine,rightPanel];
			this.callParent();
	 },
	 returnChart : function(jsonData,columnWid){
			var chartPanel;
			var imgSrc = jsonData.URL;
			var imgId = jsonData.ifmId;
			var imgHeight = jsonData.height;
			var layerURl = jsonData.layerUrl;
			var errHtml = '<center><div style="margin:12% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div >No measures available</div></div></center>';
			if( valueFusion )
			{
				chartPanel = {
							id:imgId,
							xtype : 'container',
							border:false,
							padding:5,
							layout:'fit',
							flex : 1,
							clickUrl:layerURl,
							//html:'<iframe frameBorder="0" scrolling="no" width="100%" height="100%" <img style="align:middle;" src="'+imgSrc+'"/></iframe>',
							html:'<iframe src="'+imgSrc+'" scrolling="no" frameborder="0" marginheight="0" marginwidth="0"  align="bottom" ALLOWTRANSPARENCY="true" style="align:bottom;height:'+imgHeight+'px;width:240px"></iframe>',
							//*,columnWidth: columnWid*/		
					}
				return chartPanel;
			}
			else
			{
				chartPanel = {
					id:imgId,
					xtype : 'panel',
					border:false,
					padding:5,
					cls:'componentnetworkseperator',
					margin:'0 0 5 0',
					layout:'fit',
					flex : 1,
					clickUrl:layerURl,
					html:'',
					height:imgHeight,
					width:240,
					listeners:{
						afterRender:function(panel){
							Ext.Ajax.request({
							url:imgSrc,
							success : function(response) {
								try{
										var formdata = Ext.decode(response.responseText);
										var jsonData = formdata.chartXML;
										jsonData['useHtml'] = false;
										var strSkinclr = ( strSkin == 'Dark' )?'#c6c6c6':'#333333';
										jsonData['strSkinclr'] = strSkinclr;
										var Dial_Fullview = jsonData['Dial_Fullview'];
										var methodName = jsonData['METHOD_NAME'];
										var params = jsonData['PARAMS'];
										var ttip = ( Ext.isEmpty( jsonData['ttitle'] ) )?'':jsonData['ttitle'];
										getHighChartsGuage(imgId,jsonData,'virtualTabUpperPanel');
										if(Dial_Fullview != '' && Dial_Fullview!= undefined && Dial_Fullview=='true')
										{
											panel.addDocked({
												xtype: 'toolbar',
												dock: 'top',
												width:'100%',
												items: [{
														xtype: 'container',
														//margin:'0 0 0 0',
														width:"95%",
														style:{'text-align':'center'},
														html:'<span style="display:block !important;" class="font_bold12">'+ttip+'</span>'
													},
													'->',{
													text:'',
													cls:'iconMaximize',
													tooltip:ttip,
													handler:function()
													{
														showMaximizedView(params);
													}
												}]
											});
										}
										else
										{
											panel.addDocked({
												xtype: 'toolbar',
												dock: 'top',
												items: [{
													xtype: 'container',
													//margin:'0 0 0 0',
													width:"100%",
													style:{"text-align":"center"},
													html:'<span style="display:block !important;" class="font_bold12">'+ttip+'</span>'
												}]
											});
										}
									}catch(err){
										
										Ext.getCmp(imgId).update(response.responseText);
									}
								},
							});
						}
					}
					//html:'<iframe frameBorder="0" scrolling="no" width="100%" height="100%" <img style="align:middle;" src="'+imgSrc+'"/></iframe>',
					//html:'<div style="width:240px;margin:0px auto"><iframe src="'+imgSrc+'" scrolling="no" frameborder="0" marginheight="0" marginwidth="0"  align="bottom" ALLOWTRANSPARENCY="true" style="align:bottom;height:'+imgHeight+'px;width:240px;margin:0px auto"></iframe></div>',
					/*,columnWidth: columnWid*/		
				}
				return chartPanel;
			}
		},
		returnBlankLine : function(heights){
			var empty =  {
				xtype:'panel',
				height:heights,
				
				width:1,
				//flex : .1,
				//style:'border-left: 1px solid #ABACAE;border-right: 1px solid #FAFAFA;'
			}
			return empty;
		}
});

