Ext.define('componentsList.controller.Main', {
	extend: 'Ext.app.Controller',
	views:['componentsList.view.Main','componentsList.view.ComponentsListPanel','componentsList.view.ListComponent','componentsList.view.ConfigWindow'],
	refs:[{
		ref:'main',
		selector:'main'
	},{
		ref:'componentsListPanel',
		selector:'componentslistpanel'
	},{
		ref:'componentsListForm',
		selector:'componentslistpanel form'
	},{
		ref:'searchStateCombo',
		selector:'componentslistpanel form combo[action=searchState]'
	},{
		ref:'searchTypeCombo',
		selector:'componentslistpanel form combo[action=searchType]'
	},{
		ref:'nickNameField',
		selector:'componentslistpanel form textfield[action=nickname]'
	},{
		ref:'searchTypeField',
		selector:'componentslistpanel form textfield[action=searchtypefield]'
	},{
		ref:'submitSearch',
		selector:'componentslistpanel form button[action=submit]'
	},{
		ref:'searchComponentCheck',
		selector:'componentslistpanel form checkbox'
	},{
		ref:'treePanel',
		selector:'componentstreepanel treepanel'
	},{
		ref:'commonPanel',
		selector:'generalMeasuresGridPanel[id="perPanel"]'
	},{
    	ref:'configWindowRadio',
    	selector:'configwindow > form > radio'
    },{
    	ref:'configWindow',
    	selector:'configwindow'
    },{
    	ref:'measuresAndAnalysis',
    	selector:'measureandanalysis'
    },{
    	ref:'configWindowForm',
    	selector:'configwindow > form'
    }],
	refreshFlag:false,
	init: function() {
		setInterval("execute()",refreshFrequency);
		this.control({
			'componentslistpanel':{
				resize: function(panel, width, height, oldWidth, oldHeight, eOpts ){
					panel.doLayout();
				}
			},
			'componentslistpanel form textfield[action=nickname]' : {
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						this.SubmitButtonClicked();
					}
				}
			},
			'componentslistpanel form textfield[action=searchtypefield]':{
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						this.SubmitButtonClicked();
					}
				}
			},
			'componentslistpanel form combo[action=searchState]':{
				select: function(){
					this.SubmitButtonClicked();
				}
			},
			'componentslistpanel form combo[action=searchType]':{
				select: function(){
					this.SubmitButtonClicked();
				}
			},
			'componentslistpanel > header > button[action=back]':{
				click:this.backButtonHandler
			},
			'componentslistpanel form button[action=submit]':{
				click: this.SubmitButtonClicked
			},
			'generalMeasuresGridPanel combo[id="filterByCombo"]':{
				'select':this.compFilterByComboOnChange
			},
			'generalMeasuresGridPanel combo[id="subFilterCombo"]':{
				change:this.compSubFilterComboOnChange
			},
			'generalMeasuresGridPanel combo[id="componentTypCombo"]':{
				change:this.componentTypeComboOnChange
			},
			'generalMeasuresGridPanel combo[id="sortByCombo"]':{
				'select':this.componentsmeasureComboChange
			},
			'generalMeasuresGridPanel textfield[id="nickName"]':{
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						this.compSubmitButtonClicked();
					}
				}
			},
			'dashboardgeneralmeasuresgrid':{
				sortchange : this.getSortDetails,
				render : this.retainColumnSort
			},
			'componentslistpanel > header > button[action="configsetting"]':{
				scope : this,
				click : this.openConfigWindow
			},
			'configwindow':{
				'render': this.itemset,
				 'close':this.refreshcall
			},
			'configwindow > form > combo':{
				'select':this.combo
			},
			'configwindow > form > radiogroup':{
				'change':this.radio
			},
			'configwindow > toolbar > button[action="submit"]':{
				click:this.buttonclick
			},
			'componentslistpanel form checkbox':{
				change: function(){
					var checkedValue=this.getSearchComponentCheck().getValue();
					var treeCollapsed=true;//!this.getComponentsTreePanel().getCollapsed();
					var url="../servlet/com.eg.EgMonitorController?from=componentList&monCmd=componentList&action=search&searchStateString="+this.getSearchStateCombo().getValue()+"&searchNameString="+this.getNickNameField().getValue()+"&selTypeString="+this.getSearchTypeCombo().getValue()+"&searchTypeString="+this.getSearchTypeField().getValue()+"&treeOpen="+treeCollapsed;
					if(checkedValue===true){
						url+="&searchIndComps=on";
					}
					if(this.getComponentsListPanel().aggregate)				// Kaliraj
						url += '&menuName=agg';
					else if(this.getComponentsListPanel().network)				
						url += '&menuName=network';
					url = url+"&componentListRefresh=yes";
					this.showResult(url);
					//document.location=url;
				}
			}
		});
	},
	openConfigWindow : function(button){
		var VWidth = Ext.Element.getViewportWidth( );
		try
		{
			var backButtonExist = Ext.getCmp('back').hidden;
			//var popUparrowaxis = '350px';
			var popUparrowaxis = '406px';
			if(backButtonExist != undefined && backButtonExist != null && !backButtonExist)
				popUparrowaxis = '346px';				
				//popUparrowaxis = '292px';				
		}
		catch (e)
		{
			//popUparrowaxis = '350px';
			popUparrowaxis = '406px';
		}
		
		if(this.getConfigWindow())
			this.getConfigWindow().destroy();

		if(!this.getConfigWindow())
		{
			var win=Ext.create('componentsList.view.ConfigWindow');
			win.show();

			container = Ext.create('Ext.container.Container',{
				padding:'10px 10px 0px 10px',
				floating:true,
				frame:true,
				width:510,
				hidden:true,
				//height:500,
				floatable:true,
				//id:'configMod',
				cls:'configMode_popup',
				items:[
					{
						xtype:'container',
						cls:'alarmTooltipArrow1',
						style:{'top':'-17px','left':popUparrowaxis}
					},
					{
						xtype:'container',
						margin:'-4px 0px 0px 4px',
						html:'<div class="settingsfont" style="float:left;color:#f7f7f7;text-transform:uppercase;margin-top: -5px;">Settings</div><div style="text-align:right;float:right;margin-top:-7px;"><div class="iconClose3"></div></div>',
					},
						win
				]
			});
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
				   top:40,
					left: VWidth -615
				}
			});

			container.showAt(VWidth -615,5000);
			Ext.select('.iconClose3').on('click',function(){
					Ext.create('Ext.fx.Anim', {
						target: container,
						duration: 500,
						from: {
						left: VWidth -615,
							top:40
						},
						to: {
						   top:-500,
						left: VWidth -615
						},
						callback: function(){
							container.hide();
							componentsList.app.getController("Main").metricRefresh();
						}
					});
			},this);

			Ext.getBody().on('click',function(event){
					var tarid = event.target.id;
					if(tarid != undefined && tarid != null && ((tarid.toLowerCase().indexOf("gridview") != -1) || (tarid.toLowerCase().indexOf("componentslistpanel") != -1) || (tarid.toLowerCase().indexOf("toolbar") != -1) || (tarid.toLowerCase().indexOf("filter") != -1) || (tarid.toLowerCase().indexOf("listbutid") != -1)))
					{
						container.hide();
					}
			});
		}
		else if(container.isHidden())
		{
			var win=this.getConfigWindow();
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
					top:40,
					left: VWidth -615
				}
			});
			container.showAt(VWidth -615,5000);
		}
		else
		{
			container.hide();
			componentsList.app.getController("Main").metricRefresh();
		}
	},
	compFilterByComboOnChange:function(combo){
		var userName=requestParams.userName;
		
		//var hostType=combo.getValue();
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=this.getCommonPanel().itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
		}

		url=url+"&filterBy="+filterByComboVal+'&parentZone='+requestParams.parentZone;

		if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
			url=url+"&timeline="+timeline;
		var subFilterComboObj = Ext.getCmp('subFilterCombo');
		var isOthers=false;

		if(filterByComboVal=='Component' || filterByComboVal=='System' ||  filterByComboVal=='Network')
		{
			subFilterComboObj.hide();
			isOthers = true;
		}
		else
		{
			//subFilterComboObj.show();
		}

		sortState="";
		DirProperty="";
		
		if(isOthers)
		{
			this.getCommonPanel().loadTab(url,'','','','','','componentList');
			Refurl=url;
		}
		else
		{
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					subFilterComboObj.getStore().loadRawData(jsonData.subFilterOptions);
					subFilterComboObj.setValue(jsonData.pageParams.selectedSubFilterOption);
					subFilterComboObj.setFieldLabel(jsonData.pageParams.subFilterLabel);
					subFilterComboObj.show();
				}
			});
		}
	},
	
	compSubFilterComboOnChange:function(combo){
		var userName=requestParams.userName;
		
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}
		
		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=this.getCommonPanel().itemId;
		
		sortState="";
		DirProperty="";

		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+'&parentZone='+requestParams.parentZone;
			var url = url;
			Refurl=url;
			this.getCommonPanel().loadTab(url,'','','','','','componentList');
		}
		else if(itemIdVal=='components' || itemIdVal=='Components' )
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+'&parentZone='+requestParams.parentZone;
			if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
				url=url+"&timeline="+encodeURIComponent(timeline);
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('componentTypCombo');
					componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
				}
			});
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal);
			if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
				url=url+"&timeline="+encodeURIComponent(timeline);
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('componentTypCombo');
					componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
				}
			});
		}
	},
	componentTypeComboOnChange:function(combo)
	{
		var treeFlag_SBD=requestParams.treeFlag_SBD;
		var outsideService_SBD=requestParams.outsideService_SBD;
		var titleText_SBD = requestParams.titleText_SBD;
		var selectNode_SBD = requestParams.selectNode_SBD;
		var isEmulTrans_SBD = requestParams.isEmulTrans_SBD;
		var serviceState_SBD = requestParams.serviceState_SBD;
		var serviceName = requestParams.serviceName;
		var serviceState = requestParams.serviceState;
		var isServiceBusiDash = requestParams.isServiceBusiDash;

		var userName=requestParams.userName;
		var stateName=requestParams.stateName;
		stateName=(stateName==null || stateName==undefined || stateName=='null')?"":stateName;
		var fromPageView=requestParams.fromPageView;
		var componentTypeVal=combo.getValue();
			compListType=componentTypeVal;
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined)
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined)
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=this.getCommonPanel().itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
		}

		//url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentType="+encodeURIComponent(componentTypeVal)+"&componentNameSearch="+nickNameVal+"&fromPageView="+fromPageView;

		url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURI(subFilterComboVal)+"&componentType="+encodeURI(componentTypeVal)+"&componentNameSearch=&fromPageView="+fromPageView+"&userName="+encodeURI(userName)+"&selectedState="+stateName+'&fromHomepage='+requestParams.isfromHomepage+'&parentZone='+requestParams.parentZone;
		sortState="";
		DirProperty="";
		if(!Ext.isEmpty(requestParams.isServiceBusiDetails) && requestParams.isServiceBusiDetails!=undefined && requestParams.isServiceBusiDetails!=null)
			url = url +"&isServiceBusiViewMetrics="+requestParams.isServiceBusiDetails + '&treeFlag_SBD='+treeFlag_SBD+'&outsideService_SBD='+outsideService_SBD+'&titleText_SBD='+titleText_SBD+'&selectNode_SBD='+selectNode_SBD+'&serviceFromZone='+serviceName+'&isEmulTrans_SBD='+isEmulTrans_SBD+'&serviceName='+serviceName+'&serviceState_SBD='+serviceState_SBD+'&isServiceBusiDash='+isServiceBusiDash;

		if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
			url=url+"&timeline="+encodeURIComponent(timeline);
		Refurl=url;
		this.getCommonPanel().loadTab(url,'','','','','','componentList');
	},
	compSubmitButtonClicked:function()
	{
		var fromPageView=requestParams.fromPageView;
		var userName=requestParams.userName;
		var stateName=requestParams.stateName;
		stateName=(stateName==null || stateName==undefined || stateName=='null')?"":stateName;
		if(stateName==null || stateName==undefined || stateName=='')
		{
			stateName = requestParams.selectedState;
		}
		stateName=(stateName==null || stateName==undefined || stateName=='null')?"":stateName;
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined)
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}
		var sortByComboVal="";
		if(Ext.getCmp('sortByCombo')!=null && Ext.getCmp('sortByCombo')!=undefined && Ext.getCmp('sortByCombo').getValue()!=null && Ext.getCmp('sortByCombo').getValue()!='null')
		{
			sortByComboVal = Ext.getCmp('sortByCombo').getValue();
		}
		var url="";
		var itemIdVal=this.getCommonPanel().itemId;

		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&viewPageTitle="+encodeURIComponent(requestParams.viewPageTitle);
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentType="+encodeURIComponent(componentTypeVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&fromPageView="+fromPageView+"&userName="+encodeURIComponent(userName)+"&selectedState="+stateName+"&viewPageTitle="+encodeURIComponent(requestParams.viewPageTitle);
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentType="+encodeURIComponent(componentTypeVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&fromPageView="+fromPageView+"&userName="+encodeURIComponent(userName)+"&selectedState="+stateName+"&viewPageTitle="+encodeURIComponent(requestParams.viewPageTitle);
		}

		if(!Ext.isEmpty(isServiceBusiViewMetrics) && isServiceBusiViewMetrics!=null && isServiceBusiViewMetrics!=undefined && (isServiceBusiViewMetrics=='true'||isServiceBusiViewMetrics==true))
			url = url +"&isServiceBusiViewMetrics="+isServiceBusiViewMetrics;

		if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
			url=url+"&timeline="+encodeURIComponent(timeline);
		var url = url+'&parentZone='+requestParams.parentZone;
		Refurl=url;
		this.getCommonPanel().loadTab(url,'','','','','','componentList');
	},
	loadMetricsView:function(in_url,title_val,pId,title)
	{
		var mainPanel = Ext.getCmp('componentslistpanel');
		if(mainPanel!=null && mainPanel!=undefined && mainPanel.items!=null && mainPanel.items!=undefined)
		{
			var resultItems=mainPanel.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				resultItems[item].destroy();
			}
		}

		var myMask = null;
		if(!Ext.isEmpty(mainPanel))
		{
			myMask = new Ext.LoadMask(mainPanel, {msg:"Please wait..."});
			myMask.show();
		}

		var listButIdObj=Ext.getCmp('listButId');
		var GridButIdObj=Ext.getCmp('GridButId');

		if(GridButIdObj!=null && GridButIdObj!=undefined)
		{
			GridButIdObj.removeCls('iconCompGridviewSelect');
			GridButIdObj.removeCls('iconCompGridview');

			GridButIdObj.addCls('iconCompGridviewSelect');
		}
		
		if(listButIdObj!=null && listButIdObj!=undefined)
		{
			listButIdObj.removeCls('iconCompListviewSelect');
			listButIdObj.removeCls('iconCompListview');
			listButIdObj.addCls('iconCompListview');
		}

		if(!Ext.isEmpty(requestParams.isServiceBusiDetails) && requestParams.isServiceBusiDetails!=undefined && requestParams.isServiceBusiDetails!=null)
		{
			in_url = in_url + '&isServiceBusiViewMetrics='+requestParams.isServiceBusiDetails;
		}
		in_url = in_url +'&parentZone='+requestParams.parentZone;
		//Refurl="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
		Refurl=in_url;
		var tempURL1="&selectNode_SBD="+encodeURIComponent(requestParams.selectNode_SBD,"UTF-8")+"&treeFlag_SBD="+requestParams.treeFlag_SBD+"&outsideService_SBD="+requestParams.outsideService_SBD+"&titleText_SBD="+requestParams.titleText_SBD+"&isEmulTrans_SBD="+requestParams.isEmulTrans_SBD+"&serviceState_SBD="+requestParams.serviceState_SBD+"&isServiceBusiDash="+requestParams.isServiceBusiDash+"&serviceName="+requestParams.serviceName;

		Refurl=Refurl+tempURL1;
		Refid=pId;
		Reftext=title_val;
		if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
			mainPanel.setTitle(title);
		else if(Reftext == "Components")
			mainPanel.setTitle("Components in all states");
		else
			mainPanel.setTitle(Reftext);
		mainPanel.header.addClass("panelTitle");
		mainPanel.add({
			xtype:'generalMeasuresGridPanel',
			cls:'gridHeadercenter',
			itemId:Refid,
			margin:0,
			padding:0,
			frame:false,
			border:false,
			layout:{type:'vbox',align:'stretch'},
			flex:1,
			screenLabelPath:"monitor.Dashboard",
			url:Refurl,
			listeners: {
				'afterrender': function (obj) {
					this.loadTab(obj.url,'','','','','','componentList');
					myMask.hide();
				}
			}
		});
	},
	loadComponentList:function(url)
	{
		var me = Ext.getCmp('componentslistpanel');
		var url = url;
		if(!Ext.isEmpty(requestParams.isAggregate) && (requestParams.isAggregate == 'agg' || requestParams.isAggregate == 'Agg'))
		{
			url += '&menuName=agg';
			me.aggregate = true;
		}
		else if(!Ext.isEmpty(requestParams.isNetwork) && (requestParams.isNetwork == 'network' || requestParams.isNetwork == 'network'))
		{
			url += '&menuName=network';
			me.network = true;
		}

		var mainPanel = Ext.getCmp('componentslistpanel');
		var resultItems=mainPanel.items.items;
		for(var item=resultItems.length-1; item>-1 ; item--)
		{
			//commonpanel.destroy(resultItems[item]);
			resultItems[item].destroy();
		}

		Ext.Ajax.request({
		url : url,
		//method : 'POST',
		success : function(response, opts)
		{
			var jsonText = response.responseText;
			if(!Ext.isEmpty(jsonText))
			{
				var jsonData = Ext.decode(jsonText);
				// Prem newly added
				if(!Ext.isEmpty(jsonData.HiddenFields.menuName) && jsonData.HiddenFields.menuName == 'agg')
					me.aggregate = true;
				else if(!Ext.isEmpty(jsonData.HiddenFields.menuName) && jsonData.HiddenFields.menuName == 'network')
					me.network = true;
				// Prem newly added
				if(jsonData.ListLabels["ListTitle"] != undefined)
					me.setTitle(jsonData.ListLabels["ListTitle"] ? jsonData.ListLabels["ListTitle"] : "");
				else
					me.setTitle(jsonData.ScreenLabels["Title"] ? jsonData.ScreenLabels["Title"] : "");

				if(!Ext.isEmpty(jsonData.SearchLabels))
				{
					var searchPanel= Ext.create('Ext.form.Panel',{
						header:false,
						border:true,
						cls:'formOuter',
						layout:{
							type:'vbox',
							align:'stretch'
						},
						autoHeight:true,
						items : [{
							xtype:'panel',
							layout:{
								type: 'column'
							},
							header:false,
							border:false,
							frame:false,
							defaults:{
								margin:0,
								padding:'10px 10px 10px 10px',
								labelSeparator:''
							},
							items:[{
								xtype:'scrollcombo',
								labelAlign:'top',
								columnWidth:'.17',
								id:'searchState',
								minWidth:100,
								maxWidth:250,
								store: Ext.create('Ext.data.Store',{
									fields:['value','name'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'searchStateString'
										}
									},
									data:jsonData.SearchLabels.searchStateString
								}),
								fieldLabel: jsonData.SearchLabels["searchStateLabel"] ? jsonData.SearchLabels["searchStateLabel"] : "",
								displayField:'name',
								cls:'dropdown',
								valueField:'value',
								value: jsonData.SearchLabels.searchStateStringSelected ? jsonData.SearchLabels.searchStateStringSelected : jsonData.SearchLabels.searchStateString[0].value,
								editable:false,
								action:'searchState'
							}, {
								xtype: 'textfield',
								labelAlign:'top',
								columnWidth:'.17',
								minWidth:150,
								maxWidth:300,
								id:'nickName',
								cls :'textbox',
								//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
								//padding:10,
								fieldLabel: jsonData.SearchLabels["searchNameLabel"] ? jsonData.SearchLabels["searchNameLabel"] : "",
								value: jsonData.SearchLabels["searchNameString"] ? jsonData.SearchLabels["searchNameString"] : "",
								action:'nickname'
							},{
								xtype:'scrollcombo',
								//padding:10,
								id:'Type',
								labelAlign:'top',
								columnWidth:'.17',
								minWidth:100,
								maxWidth:250,
								store: Ext.create('Ext.data.Store',{
									fields:['value','name'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'selTypeString'
										}
									},
									data:jsonData.SearchLabels.selTypeString
								}),
								fieldLabel: jsonData.SearchLabels["searchTypeLabel"] ? jsonData.SearchLabels["searchTypeLabel"] : "",
								displayField:'name',
								valueField:'value',
								value: jsonData.SearchLabels.selTypeStringSelected ? jsonData.SearchLabels.selTypeStringSelected : jsonData.SearchLabels.selTypeString[0].value,
								editable:false,
								cls:'dropdown',
								action:'searchType'
							},{
								xtype: 'textfield',
								id:'searchType',
								labelAlign:'top',
								columnWidth:'.17',
								minWidth:150,
								maxWidth:300,
								cls: 'textbox',
								//cls : 'component-list-right-panel-header-right',
								//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
								//padding:10,
								fieldLabel: jsonData.SearchLabels["typeLabel"] ? jsonData.SearchLabels["typeLabel"] : "",
								value: jsonData.SearchLabels["typeString"] ? jsonData.SearchLabels["typeString"] : "",
								action:'searchtypefield'
							},{
								xtype:'checkbox',
								//padding:10,
								id:'searchComp',
								margin:'20px 0px 0px 0px',
								columnWidth:'.13',
								minWidth:150,
								maxWidth:250,
								cls:'components-checkbox-field checkbt',
								boxLabel  : jsonData.SearchLabels["searchIndComps"] ? jsonData.SearchLabels["searchIndComps"] : "",
								checked: requestParams.searchIndComps==='on' ||  requestParams.searchIndComps==='checked' ? true : false
							},{
								xtype:'button',
								//cls : 'button20 submit-button',
								cls : 'button20',
								margin:'31 0 0 0',
								//padding:10,
								minWidth:80,
								maxWidth:120,
								text:jsonData.SearchLabels["submitBtnText"] ? jsonData.SearchLabels["submitBtnText"] : "",
								action:'submit'
							}]
						}]
					});
					me.add(searchPanel);
				}

				if(jsonData["error"])
				{
					var searchNoList = Ext.create('utilities.ErrorPanel',{
						style:{'border':'0px solid orange'},
						errorMsg : '<div style="text-align:center;valign:middle;margin:15% auto;"><img src="/final/images/spacer.gif" class="iconInformation" /><div class="list-empty-text">'+jsonData["error"]+'</div></div>'
					});
					me.add({
						xtype:'panel',
						id:'errorpanelId',
						border:false,
						frame:false,
						layout:'fit',
						margin:'10 10 10 10',
						flex:1,
						width:'100%',
						items: searchNoList
					});
				}
				else
				{
					//var listPanelContents = Ext.create('utilities.CommonPanel', {
					var listPanelContents = Ext.create('Ext.panel.Panel', {
								suspendLayout:true,
								id:'commonpanel',
								//title: jsonData.ListLabels["ListTitle"] ? jsonData.ListLabels["ListTitle"] : "hi",      // Display the current Component State
								padding: 0,
								//cls : 'list-panel-contents components-list-panel component-list-panel-content',
								//bodyCls:'bottom-left-radius',
								autoScroll:true,
								scroll:true,
								cls:'outerpanel',
								frame:true,
								layout:{
									type:'fit',
									align:'stretch',
								},
								border:true,
								flex:1,
								margin:'10 10 10 10',
								dockedItems:[{
									xtype : 'toolbar',
									id:'titleTool',
									//height : 30,
									cls : 'component-list-right-panel-header component-list-right-panel-header-right',
									layout : 'hbox',
									margin:0,
									padding:0,
									flex : 1,
									items:[{
										xtype : 'label',
										text : jsonData.ListLabels["ComponentTypeTitle"] ? jsonData.ListLabels["ComponentTypeTitle"] : "",
										width :200,
										padding:'2px 5px 2px 10px'
									},{
										xtype:'label',
										width:2,
										height:22,
										padding:0,
										cls:'service_header',
										style:'left:200px !important;'
									},{
										xtype : 'label',
										text : jsonData.ListLabels["AvaliableListTitle"] ? jsonData.ListLabels["AvaliableListTitle"] : "",
										padding:'2px 5px 2px 6px',
										flex:1
									}]
								}],

								/*handlePercentWidthsAfterScroll:function(){
									//for the inner div
									$('.jspPane').css({
										'width': '100%'
									});
									$('.jspPane > .x-box-inner').css({
										'width': '100%'
									});

									//for the presentation div
									$('.jspPane > .x-box-inner > div').css({
										'width': '100%'
									});

									$('.jspPane .list-component').css({
										'width': '100%'
									});
									//body
									$('.jspPane .list-component > div').css({
										'width': '100%'
									});
									//presentation
									$('.jspPane .list-component > div > div').css({
										'width': '100%'
									});
									$('.jspPane .list-component > div > div > div').css({
										'width': '100%'
									});
									$('.jspPane .component-list-right').each(function() {
										var wd=$(this).outerWidth(true);
										wd+=0;
										$(this).css({
											'width':wd+'px'
										});
										var rightPanel=$(this).find('.x-panel-body');
										rightPanel.css({
											'width':wd+'px'
										});
										var rightPanels=rightPanel.find('.x-panel-header');
										$(rightPanels).each(function(){
											var wt=$(this).outerWidth(true);
											wt+=0;
											$(this).css({
												'width':wt+'px'
											});
										});
									});
								}*/
					});
					Ext.suspendLayouts();
					var componentTypeArray = jsonData.ListLabels["ComponentList"];  //To Display the Component
					/*for(var componentTypeCounter = 0 ; componentTypeCounter < componentTypeArray.length; componentTypeCounter++){
							var listComponent = Ext.create('componentsList.view.ListComponent',{
								id:'listcomponent'+componentTypeCounter,
								rootComponent :componentTypeArray[componentTypeCounter],
								skin:jsonData.ListLabels["MonitorSkin"]
							});
							listPanelContents.add(listComponent);
						}*/
						var finalCompData ='';
						for(var componentTypeCounter = 0 ; componentTypeCounter < componentTypeArray.length; componentTypeCounter++)
						{
							var leftData="";
							leftData = "<table class='table-list-layout' style='width:100%'><tr><td style='width:203px;text-align:center;"+stylefrLight+"'>";
							var strShowImg = componentTypeArray[componentTypeCounter]["showImg"];
							var typeState = componentTypeArray[componentTypeCounter]["TypeState"];
							if(!Ext.isEmpty(strShowImg))
							{
								leftData=leftData+'<div style="margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;" align="left"><div style="position:relative;top:0px;left:0px;border:0px solid red;"><img src="'+componentTypeArray[componentTypeCounter]["type"]+'"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+typeState+'"></div></div></div><div style="margin:0px auto 5px auto;width:190px;" data-qclass="yellowTip" class="component-list-left-font" data-qtip="'+componentTypeArray[componentTypeCounter].title+'">'+componentTypeArray[componentTypeCounter].name+'</div>';
							}
							else
							{
								leftData=leftData+'<div data-qclass="yellowTip" style="margin:0px auto 5px auto;width:190px;" class="component-list-left-font" data-qtip="'+componentTypeArray[componentTypeCounter].title+'">'+componentTypeArray[componentTypeCounter].name+'</div>';
							}
							leftData = leftData+"</td><td>"
							var rightComponentItems = componentTypeArray[componentTypeCounter]["children"];
							var temp="";
							temp="<div>";
							var contComp=0;
							for (var subElementsCount = 0; subElementsCount < rightComponentItems.length; subElementsCount++)
							{
								var innerItem = rightComponentItems[subElementsCount];
								if(!Ext.isEmpty(innerItem["configChange"]) || !Ext.isEmpty(innerItem["MaintenanceTime"]) || (!Ext.isEmpty(innerItem["configChange"]) && !Ext.isEmpty(innerItem["MaintenanceTime"]))){
									//var widthOfName = getWidthOfText(innerItem["name"],"LucidaGrandeRegular","11px") + 15;
									var widthOfName = getWidthOfText(innerItem["name"],"f11-normal") + 15;
									if(widthOfName > 160)
										widthOfName = 160;
									var widthOfNameC = widthOfName + 35;
									if(widthOfNameC > 200){
										widthOfNameC = 200;
										widthOfName = 160;
									}
								}else{
									widthOfName = 200;
									widthOfNameC = 200;
								}

								temp=temp+"<div style='width:240px;float:left;border:0px solid red'>";

									temp=temp+'<div style="float:left;display:inline-block;border:0px solid violet;width:'+widthOfNameC+'px"><div class="serviceSegmentComponentName"><img style="position:relative;" src="/final/images/clear.png" class="'+ innerItem["stateName"]+ '"/><a style="width:90%;padding-left:0px" class="component-list-right-link" data-qclass="yellowTip" href="javascript:void(0)" onclick=\'javascript:componentListToDashboard("'+ innerItem["link"] + '","' + innerItem["name"]+ '")\' data-qtip="'+ innerItem["title"]+ '" ><div id="innernId" style="overflow:hidden;text-overflow:ellipsis;width:'+widthOfName+'px;border:0px solid yellow">'+ innerItem["name"] + '</div></a></div></div>';

									if(!Ext.isEmpty(innerItem["MaintenanceTime"]))
									{
										temp=temp+'<div style="float:left;margin-top:2px;margin-right:6px"><div class="iconMaintenance" data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="'+innerItem["MaintenanceTime"]+'"></div></div>';
									}

									if(!Ext.isEmpty(innerItem["configChange"]))
									{
										var confighref = '/final/monitor/EgConfigChange.jsp?componentName='+innerItem["configChange"];
										//temp=temp+'<div style="float:left;margin-top:2px;"><a href="/final/monitor/EgConfigChange.jsp?componentName='+innerItem["configChange"]+'"> <div class="iconConfigUser handSymbol"  data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="Configuration"></div></a></div>';
										temp=temp+'<div style="float:left;margin-top:2px;" id="configchange"><a href="javascript:void(0)" > <div onclick="configPop(\''+confighref+'\')" onmouseover="javascript:void(0)" class="iconConfigUser handSymbol"  data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="Configuration"></div></a></div>';
									}
								temp=temp+"</div>";
							}
							temp=temp+"</div>";
							leftData = leftData+temp+"</td></tr></table>";
							finalCompData += leftData;
						}
					Ext.resumeLayouts(true);
					listPanelContents.update(finalCompData);
					me.add(listPanelContents);
				}
				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}
				if(window.parent.globalsearch==true)
				{
					if(searchPanel!=null && !Ext.isEmpty(searchPanel))
					{
						searchPanel.hide();
						me.getHeader().hide();
						//listPanelContents.setTitle('Search Results For   \" '+window.parent.serverSearchval+'\"');
						if(listPanelContents!=null && listPanelContents!=undefined)
						{
							 listPanelContents.setTitle(jsonData.ScreenLabels["searchResultText"]+'  \"'+window.parent.serverSearchval+'\"');
						}
					}
				}
				else if(searchPanel!=null && !Ext.isEmpty(searchPanel))
				{
					var action=jsonData.action;
					if(action!=null && action!=undefined && action!="" && (action=='componentType' || action=='componentTypeState'))
					{
						searchPanel.hide();
					}
					else
					{
						searchPanel.show();
						
					}
					me.getHeader().show();
				}
			}
		}
		//failure : function(){alert("failure");}
		});
	},
	SubmitButtonClicked : function(){

		var treeCollapsed=false;//!this.getComponentsTreePanel().getCollapsed();

		url="../servlet/com.eg.EgMonitorController?from=componentList&monCmd=componentList&action=search&searchStateString="+this.getSearchStateCombo().getValue()+"&searchNameString="+this.getNickNameField().getValue()+"&selTypeString="+encodeURI(this.getSearchTypeCombo().getValue())+"&searchTypeString="+this.getSearchTypeField().getValue()+"&searchIndComps=on&treeOpen="+treeCollapsed;

		if(!Ext.isEmpty(isServiceBusiViewMetrics) && isServiceBusiViewMetrics!=null && isServiceBusiViewMetrics!=undefined && (isServiceBusiViewMetrics=='true'||isServiceBusiViewMetrics==true))
		{
			url = url + '&isServiceBusiViewMetrics='+isServiceBusiViewMetrics;
		}
		// Prem newly added
		if(this.getComponentsListPanel().aggregate)
			url += '&menuName=agg';
		else if(this.getComponentsListPanel().network)
			url += '&menuName=network';
		var checkedValue=this.getSearchComponentCheck().getValue();
		if(checkedValue===true){
			url+="&searchIndComps=on";
		}
		url = url+"&componentListRefresh=yes";

		if(requestParams.manyComponentTypes!=undefined && requestParams.manyComponentTypes!=null && requestParams.manyComponentTypes!="")
			url = url+"&manyComponentTypes="+encodeURI(requestParams.manyComponentTypes)+"&manyComponentTitle="+encodeURI(requestParams.manyComponentTitle);

		this.showResult(url);
		//document.location=url;
	},
	showResult:function(url)
	{
		//if(requestParams.action != null && requestParams.action =="component")
			//requestParams.componenetSearchUrl = url;
		compRefUrl=url;
		var errorpanelId = Ext.getCmp('errorpanelId');
		if(errorpanelId==null || errorpanelId==undefined )
		{
			var commonpanel = Ext.getCmp('commonpanel');
			var myMask = null;
			if(!Ext.isEmpty(commonpanel))
			{
				myMask = new Ext.LoadMask(commonpanel, {msg:"Please wait..."});
				myMask.show();
			}

			Ext.Ajax.request({
				url : url,
				timeout:300000,
				success : function(response, opts){
					//var jsonText = response.responseText;
					//var jsonData = Ext.decode(jsonText);

					var jsonText = null;
					jsonText = response.responseText;
					var jsonData = null;
					jsonData = Ext.decode(jsonText);

					delete jsonText;
					Ext.destroy(jsonText);

					var mainPanel = Ext.getCmp('componentslistpanel');
					mainPanel.setTitle(jsonData.ListLabels["ListTitle"] ? jsonData.ListLabels["ListTitle"] : "Components in  all states");
					commonpanel = Ext.getCmp('commonpanel');

					//commonpanel.removeAll();
					var resultItems=commonpanel.items.items;
					for(var item=resultItems.length-1; item>-1 ; item--)
					{
						//commonpanel.destroy(resultItems[item]);
						resultItems[item].destroy();
					}
					//commonpanel.setTitle(jsonData.ListLabels["ListTitle"] ? jsonData.ListLabels["ListTitle"] : "");
					var titleTool = Ext.getCmp('titleTool');
					commonpanel.update("");
					if(jsonData["error"])
					{
						titleTool.hide();
						//commonpanel.getHeader().hide();

						var searchNoList = Ext.create('utilities.ErrorPanel',{
						style:{'border':'0px solid orange'},
						errorMsg : '<div style="text-align:center;valign:middle;margin:15% auto;"><img src="/final/images/clear.png" class="iconInformation" /><br/><div class="list-empty-text">'+jsonData["error"]+'</div></div>'
						});
						commonpanel.add({
							xtype:'panel',
							border:false,
							frame:false,
							layout:'fit',
							flex:1,
							width:'100%',
							items: searchNoList
						});
					}
					else
					{
						titleTool.show();
						//commonpanel.getHeader().show();
						var componentTypeArray = jsonData.ListLabels["ComponentList"];  //To Display the Component
						Ext.suspendLayouts();
						/*for(var componentTypeCounter = 0 ; componentTypeCounter < componentTypeArray.length; componentTypeCounter++){
								var listComponent = Ext.create('componentsList.view.ListComponent',{
									rootComponent :componentTypeArray[componentTypeCounter]
								});
								commonpanel.add(listComponent);
							}*/
						var finalCompData ='';
						for(var componentTypeCounter = 0 ; componentTypeCounter < componentTypeArray.length; componentTypeCounter++)
						{
							var leftData="";
							leftData = "<table class='table-list-layout' style='width:100%'><tr><td style='width:203px;text-align:center;"+stylefrLight+"'>";
							var strShowImg = componentTypeArray[componentTypeCounter]["showImg"];
							var typeState = componentTypeArray[componentTypeCounter]["TypeState"];
							if(!Ext.isEmpty(strShowImg))
							{
								leftData=leftData+'<div style="margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;" align="left"><div style="position:relative;top:0px;left:0px;border:0px solid red;"><img src="'+componentTypeArray[componentTypeCounter]["type"]+'"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+typeState+'"></div></div></div><div style="margin:0px auto 5px auto;width:190px;" data-qclass="yellowTip" class="component-list-left-font" data-qtip="'+componentTypeArray[componentTypeCounter].title+'">'+componentTypeArray[componentTypeCounter].name+'</div>';
							}
							else
							{
								leftData=leftData+'<div data-qclass="yellowTip" style="margin:0px auto 5px auto;width:190px;" class="component-list-left-font" data-qtip="'+componentTypeArray[componentTypeCounter].title+'">'+componentTypeArray[componentTypeCounter].name+'</div>';
							}
							leftData = leftData+"</td><td>"
							var rightComponentItems = componentTypeArray[componentTypeCounter]["children"];
							var temp="";
							temp="<div>";
							var contComp=0;
							for (var subElementsCount = 0; subElementsCount < rightComponentItems.length; subElementsCount++)
							{
								var innerItem = rightComponentItems[subElementsCount];
								if(!Ext.isEmpty(innerItem["configChange"]) || !Ext.isEmpty(innerItem["MaintenanceTime"]) || (!Ext.isEmpty(innerItem["configChange"]) && !Ext.isEmpty(innerItem["MaintenanceTime"]))){
									var widthOfName = getWidthOfText(innerItem["name"],"f11-normal") + 15;
									if(widthOfName > 160)
										widthOfName = 160;
									var widthOfNameC = widthOfName + 35;
									if(widthOfNameC > 200){
										widthOfNameC = 200;
										widthOfName = 160;
									}
								}else{
									widthOfName = 200;
									widthOfNameC = 200;
								}
								temp=temp+"<div style='width:240px;float:left;border:0px solid red'>";

									temp=temp+'<div style="float:left;display:inline-block;width:'+widthOfNameC+'px"><div class="serviceSegmentComponentName"><img style="position:relative;" src="/final/images/clear.png" class="'+ innerItem["stateName"]+ '"/><a style="width:90%;padding-left:0px" class="component-list-right-link" data-qclass="yellowTip" href="javascript:void(0)" onclick=\'javascript:componentListToDashboard("'+ innerItem["link"] + '","' + innerItem["name"]+ '")\' data-qtip="'+ innerItem["title"]+ '" ><div style="overflow:hidden;text-overflow:ellipsis;width:'+widthOfName+'px;">'+ innerItem["name"] + '</div></a></div></div>';

									if(!Ext.isEmpty(innerItem["MaintenanceTime"]))
									{
										temp=temp+'<div style="float:left;margin-top:2px;margin-right:6px"><div class="iconMaintenance" data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="'+innerItem["MaintenanceTime"]+'"></div></div>';
									}

									if(!Ext.isEmpty(innerItem["configChange"]))
									{
										temp=temp+'<div style="float:left;margin-top:2px;"><a href="/final/monitor/EgConfigChange.jsp?componentName='+innerItem["configChange"]+'"> <div class="iconConfigUser handSymbol"  data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="Configuration"></div></a></div>';
									}
								temp=temp+"</div>";
							}
							temp=temp+"</div>";
							leftData = leftData+temp+"</td></tr></table>";
							finalCompData += leftData;
						}
						commonpanel.update(finalCompData);
						Ext.resumeLayouts(true);
					}
					mainPanel.add(commonpanel);
					myMask.hide();
					commonpanel = null;
					delete commonpanel;

					mainPanel = null;
					delete mainPanel;

					//jsonData = null;
					delete jsonData;
					Ext.destroy(jsonData);
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
	},
	backButtonHandler:function(btn){
		var treeSession=requestParams.treeSession;
		var isServiceBusiDash=requestParams.isServiceBusiDash;
		var isServiceBusiDetails=requestParams.isServiceBusiDetails;
		var treeFlag_SBD = requestParams.treeFlag_SBD;
		var outsideService_SBD = requestParams.outsideService_SBD;
		var titleText_SBD=requestParams.titleText_SBD;
		var selectNode_SBD = requestParams.selectNode_SBD ;
		var isEmulTrans_SBD= requestParams.isEmulTrans_SBD;
		var serviceState_SBD= requestParams.serviceState_SBD;
		var serviceName= requestParams.serviceName;
		var treeComeFrom=requestParams.treeComeFrom;
		var egQuickLaunch=requestParams.egQuickLaunch;
		var fromPageView=requestParams.fromPageView;
		var subFilter=requestParams.subFilter;
		var fromHomepage=requestParams.isfromHomepage;
		
		//var selectedState=requestParams.selectedState;
		var backButtonFunction="";
		treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
		if(fromPageView!=null && fromPageView=='simulator')
		{
			var treeTitle = requestParams.treeTitle;
			var ltest = requestParams.ltest;
			var monitorsBy = requestParams.monitorsBy;
			var isLogonType = requestParams.isLogonType;
			if(isLogonType!=null && isLogonType!=undefined && isLogonType!="" && isLogonType=='true')
			{
				document.location="/final/monitor/comparisonDashboard.jsp?treeTitle="+treeTitle+"&isFromMenu=true&isLogonType=true";
			}
			else
			{
				document.location="/final/monitor/comparisonDashboard.jsp?treeTitle="+treeTitle+"&monitorsBy="+monitorsBy+"&ltest="+ltest+"&isFromMenu=true";
			}
		}
		else if(fromPageView!=null && fromPageView=='zoneDashboard')
		{
			document.location='/final/monitor/zoneDash.jsp?&selectNode='+encodeURIComponent('Zone^'+subFilter)+'&selectedParam='+subFilter+'&currentTab=details&zoneName='+subFilter+'&openNode=null&treeFlag=false&fromHomepage='+requestParams.isfromHomepage+"&parentZone="+requestParams.parentZone+'&fromPageView='+fromPageView+'&filterBy=zone&subFilter='+subFilter+'&viewId=components&viewPageTitle=Components&viewTreeTitle=Component&componentType=';
		}
		else if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh=="true")
		{
			if(fromHealth!=null && fromHealth!=undefined && fromHealth!="" && fromHealth=='true')
			{
				document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard&healthView=yes';
			}
			else
			{
				window.history.go(-2);
			}
		}
		else
		{
			if(requestParams.manyComponentTypes!=undefined && requestParams.manyComponentTypes!=null && requestParams.manyComponentTypes!="")
			{
				document.location='/final/monitor/EgCitrixDashCloud.jsp?activeView=homePage';
			}
			else if(fromPage!=null && fromPage=='MyDashboard')
			{
				document.location=myDashboardBackUrl;
			}
			else if(requestParams.from=='ZoneDashboard')
			{
				if(!Ext.isEmpty(requestParams.iszoneName) && requestParams.iszoneName!='' && requestParams.iszoneName!='null')
				{
					document.location='/final/monitor/zoneDash.jsp?&selectNode='+encodeURIComponent('Zone^'+requestParams.iszoneName)+'&selectedParam='+requestParams.iszoneName+'&currentTab=details&zoneName='+requestParams.iszoneName+'&iszoneName='+requestParams.iszoneName+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.isfromHomepage+"&parentZone="+requestParams.parentZone+'&fromPageView='+fromPageView+'&parentZone='+requestParams.parentZone;
				}
				else
				{
					if(fromHealth!=null && fromHealth!=undefined && fromHealth!="" && fromHealth=='true')
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard&healthView=yes';
					}
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
					}
				}
				//window.history.go(-2);
			}
			else if(requestParams.from=='MainDashboard')
			{
				//window.history.go(-2);
				if (isServiceBusiDash=='true')
				{
					document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true&isFromMenu=true';
				}
				else if (isServiceBusiDetails=='true')
				{
					var serBusiDetailsUrl = '/final/monitor/serviceBusinessDetailsMain.jsp?treeFlag='+treeFlag_SBD+'&outsideService='+outsideService_SBD+'&titleText='+titleText_SBD+'&selectNode='+selectNode_SBD+'&serviceFromZone='+serviceName+'&isEmulTrans='+isEmulTrans_SBD+'&serviceName='+serviceName+'&serviceState='+serviceState_SBD+'&isServiceBusiDash='+isServiceBusiDash;
					if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
						serBusiDetailsUrl = serBusiDetailsUrl + "&com.eg.CSRF_NONCE="+csrfToken;
					document.location = serBusiDetailsUrl;
					//window.history.go(-2);
				}
				else
				{
					if(fromHealth!=null && fromHealth!=undefined && fromHealth!="" && fromHealth=='true')
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard&healthView=yes';
					}
					else if(requestParams.isfromHomepage!=null && requestParams.isfromHomepage!=undefined && requestParams.isfromHomepage=='true')
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
					}
					else if(treeSession != null && treeSession != '' )
					{
						document.location = treeSession;
					}
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
					}
				}
			}
			else
			{
				if (egQuickLaunch=='true')
				{
					if(fromHealth!=null && fromHealth!=undefined && fromHealth!="" && fromHealth=='true')
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard&healthView=yes';
					}
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
					}
				}
				else
				{
					if(fromHealth!=null && fromHealth!=undefined && fromHealth!="" && fromHealth=='true')
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard&healthView=yes';
					}
					else
					{
						//service and segment tree back button
						if(fromPageView!=null && (fromPageView=='Zone' || fromPageView=='ZoneMap' || fromPageView=='HomeZone'))
						{
							if(fromHomepage!=null && fromHomepage!=undefined && fromHomepage!="" && fromHomepage=='true')
							{
								document.location='/final/monitor/zoneDash.jsp?&selectNode='+encodeURIComponent('Zone^'+subFilter)+'&selectedParam='+subFilter+'&currentTab=details&zoneName='+subFilter+'&iszoneName='+subFilter+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+fromHomepage+'&fromPageView='+fromPageView+'&parentZone='+requestParams.parentZone;
							}
							else
							{
								document.location='/final/monitor/zoneDash.jsp?&selectNode='+encodeURIComponent('Zone^'+subFilter)+'&selectedParam='+subFilter+'&currentTab=details&zoneName='+subFilter+'&iszoneName='+subFilter+'&aggregateTab=false&openNode=null&treeFlag=false&fromPageView='+fromPageView;
							}
							
														
							//&fromHomepage='+requestParams.isfromHomepage+"&parentZone="+requestParams.parentZone;
						}
						else if(fromPageView!=null && fromPageView=='Home')
						{
							document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
						}
						else if(!Ext.isEmpty(treeSession) && treeSession!=null && treeSession!=undefined && treeSession.indexOf('isServiceBusiViewMetrics')!=-1)
						{
							var serBusiDetailsUrl = '/final/monitor/serviceBusinessDetailsMain.jsp?treeFlag='+treeFlag_SBD+'&outsideService='+outsideService_SBD+'&titleText='+titleText_SBD+'&selectNode='+selectNode_SBD+'&serviceFromZone='+serviceName+'&isEmulTrans='+isEmulTrans_SBD+'&serviceName='+serviceName+'&serviceState='+serviceState_SBD+'&isServiceBusiDash='+isServiceBusiDash;
							if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
								serBusiDetailsUrl = serBusiDetailsUrl + "&com.eg.CSRF_NONCE="+csrfToken;
							document.location = serBusiDetailsUrl;
						}
						else if(!Ext.isEmpty(treeSession) && treeSession!=null && treeSession!=undefined && treeSession.indexOf('isServiceBusiDash')!=-1)
						{
							var serBusiDetailsUrl = "";
							if(selectNode_SBD != "null")
							{
								serBusiDetailsUrl = '/final/monitor/serviceBusinessDetailsMain.jsp?treeFlag='+treeFlag_SBD+'&outsideService='+outsideService_SBD+'&titleText='+titleText_SBD+'&selectNode='+selectNode_SBD+'&serviceFromZone='+serviceName+'&isEmulTrans='+isEmulTrans_SBD+'&serviceName='+serviceName+'&serviceState='+serviceState_SBD+'&isServiceBusiDash='+isServiceBusiDash;
							}
							else
							{
								serBusiDetailsUrl = "/final/monitor/servicesBusinessDashMain.jsp?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true&showLegend=true&isServiceBusiDash=true";
							}
							document.location = serBusiDetailsUrl;
						}
						else
						{
							window.history.go(-1);
						}
					}
				}
			}
		}
	},
	metricRefresh:function()
	{
		var listButIdObj=Ext.getCmp('listButId');
		var GridButIdObj=Ext.getCmp('GridButId');

		if(GridButIdObj!=null && GridButIdObj!=undefined)
		{
			GridButIdObj.removeCls('iconCompGridviewSelect');
			GridButIdObj.removeCls('iconCompGridview');

			GridButIdObj.addCls('iconCompGridviewSelect');
		}
		
		if(listButIdObj!=null && listButIdObj!=undefined)
		{
			listButIdObj.removeCls('iconCompListviewSelect');
			listButIdObj.removeCls('iconCompListview');
			listButIdObj.addCls('iconCompListview');
		}

		if(Refurl!=null)
		{
			var tabUrl1=Refurl;
		}
		if(Refid=='system' || Refid=='component' || Refid=='components' || Refid=='network')
		{
			var curViewPort=  Ext.getCmp('componentslistpanel');
			//curViewPort.removeAll();
			var resultItems=curViewPort.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				//commonpanel.destroy(resultItems[item]);
				resultItems[item].destroy();
			}
			//curViewPort.setTitle(Reftext);
			//curViewPort.header.addClass("panelTitle");
			curViewPort.add({
				xtype:'generalMeasuresGridPanel',
				//title:Reftext,
				cls:'gridHeadercenter',
				itemId:Refid,
				margin:0,
				padding:0,
				frame:false,
				border:false,
				layout:{type:'vbox',align:'stretch'},
				flex:1,
				screenLabelPath:"monitor.Dashboard",
				url:tabUrl1,
				listeners: {
					'afterrender': function (obj) {
						this.loadTab(obj.url,Reftot,RefpageVal,'','','','componentList');
						//this.loadTab(obj.url);
					}
				}
			});
		}
		else
		{
			var titlesys="Systems";
			var itemIdforsysandcom="system";
			var curViewPort=  Ext.getCmp('componentslistpanel');
			//curViewPort.removeAll();
			var resultItems=curViewPort.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				//commonpanel.destroy(resultItems[item]);
				resultItems[item].destroy();
			}
			if(tabUrl1.indexOf("treeTitle=System") > -1)
			{
				titlesys="Systems";
				itemIdforsysandcom="system";
			}
			else if(tabUrl1.indexOf("treeTitle=Component") > -1)
			{
				titlesys='Components';
				itemIdforsysandcom="components";
			}
			else
			{
				titlesys="Systems";
				itemIdforsysandcom="system";
			}

			curViewPort.setTitle(titlesys);
			curViewPort.header.addClass("panelTitle");
			curViewPort.add({
				xtype:'generalMeasuresGridPanel',
				//title:titlesys,
				cls:'gridHeadercenter',
				itemId:itemIdforsysandcom,
				margin:0,
				padding:0,
				frame:false,
				border:false,
				layout:{type:'vbox',align:'stretch'},
				flex:1,
				screenLabelPath:"monitor.Dashboard",
				url:tabUrl1,
				listeners: {
					'afterrender': function (obj)
					{
						this.loadTab(obj.url,Reftot,RefpageVal,'','','','componentList');
						//this.loadTab(obj.url);
					}
				}
			});
		}
	},
	refresh:function(refreshURLParam){
		//var treePanel=this.getComponentsTreePanel();
		var treeCollapsed=false;//!treePanel.getCollapsed();
		var refreshURL = "../servlet/com.eg.EgMonitorController?";
		var strCType="";
		var strAction="search";
		var strFrom="componentList";
		var strStateName="";
		var strserviceName = '';
		var strSiteName='';
		var strSegmentName='';
		var strZoneName='';
		var struserName='';
		var strFromPageView='';
		var strselectedState='';
		if(!Ext.isEmpty(refreshURLParam) && refreshURLParam!="")
		{
			var urlParams = "";
			var direct=true;
			if(refreshURLParam.indexOf("?")>-1)
			{
				urlParams = refreshURLParam.split("?");
				direct=false;
			}
			else
			{
				urlParams = refreshURLParam;
			}

			if(!Ext.isEmpty(urlParams))
			{
				var attParams = null;

				if(direct)
				{
					attParams = urlParams.split("&");
				}
				else
				{
					if(!Ext.isEmpty(urlParams[1]))
						attParams = urlParams[1].split("&");
					else if(!Ext.isEmpty(urlParams[0]))
						attParams = urlParams[0].split("&");
				}

				if(!Ext.isEmpty(attParams))
				{
					for(var f = 0 ; f < attParams.length; f++)
					{
						if(!Ext.isEmpty(attParams[f]))
						{
							var onlyParams = attParams[f].split("=");
							if((!Ext.isEmpty(onlyParams)) && onlyParams[0]=='componentType')
							{
								strCType=onlyParams[1];
							}
							if((!Ext.isEmpty(onlyParams)) && onlyParams[0]=='action')
							{
								strAction=onlyParams[1];
							}
							if((!Ext.isEmpty(onlyParams)) && onlyParams[0]=='stateName')
							{
								strStateName=onlyParams[1];
							}
							if((!Ext.isEmpty(onlyParams)) && onlyParams[0]=='service')
							{
								strserviceName=onlyParams[1];
							}
							if((!Ext.isEmpty(onlyParams)) && onlyParams[0]=='site')
							{
								strSiteName=onlyParams[1];
							}
							if((!Ext.isEmpty(onlyParams)) && onlyParams[0]=='segment')
							{
								strSegmentName=onlyParams[1];
							}
							if((!Ext.isEmpty(onlyParams)) && onlyParams[0]=='zoneName')
							{
								strZoneName=onlyParams[1];
							}
							if((!Ext.isEmpty(onlyParams)) && onlyParams[0]=='userName')
							{
								struserName=onlyParams[1];
							}
							if((!Ext.isEmpty(onlyParams)) && onlyParams[0]=='fromPageView')
							{
								strFromPageView=onlyParams[1];
							}
							if((!Ext.isEmpty(onlyParams)) && onlyParams[0]=='selectedState')
							{
								strselectedState=onlyParams[1];
							}
						}
					}
				}
			}
		}

		var stateComboValue=null;
		if(!Ext.isEmpty(this.getSearchStateCombo()))
		{
			stateComboValue=this.getSearchStateCombo().getValue();
			if(strAction!=null && strAction!=undefined && strAction=='globalsearch')
			{
				strAction="globalsearch";
			}
			else
			{
				strAction="search";
			}
		}
		else
		{
			if(!Ext.isEmpty(strStateName))
			{
				stateComboValue=strStateName;
			}
			else
			{
				stateComboValue="";
			}
		}

		var nickName=null;
		if(!Ext.isEmpty(this.getNickNameField()))
		{
			nickName=this.getNickNameField().getValue();
			if(strAction!=null && strAction!=undefined && strAction=='globalsearch')
			{
				strAction="globalsearch";
			}
			else
			{
				strAction="search";
			}
		}
		else
		{
			nickName="";
		}

		var selType=null;
		if(!Ext.isEmpty(this.getSearchTypeCombo()))
		{
			selType=this.getSearchTypeCombo().getValue();
			if(strAction!=null && strAction!=undefined && strAction=='globalsearch')
			{
				strAction="globalsearch";
			}
			else
			{
				strAction="search";
			}
		}
		else
		{
			if(!Ext.isEmpty(strCType))
			{
				selType=strCType;
			}
			else
			{
				selType="";
			}
		}

		var searchType=null;
		if(!Ext.isEmpty(this.getSearchTypeField()))
		{
			searchType=this.getSearchTypeField().getValue();
			if(strAction!=null && strAction!=undefined && strAction=='globalsearch')
			{
				strAction="globalsearch";
			}
			else
			{
				strAction="search";
			}
		}
		else
		{
			if(!Ext.isEmpty(strAction))
			{
				searchType=strAction;
			}
			else
			{
				searchType="";
			}
		}

		if(requestParams.action==='search')
		{
			if(this.getComponentsListPanel().aggregate)
			{
				refreshURL = "../servlet/com.eg.EgMonitorController?from="+strFrom+"&monCmd=componentList&action=search&searchStateString="+stateComboValue+"&searchNameString="+nickName+"&selTypeString="+selType+"&searchTypeString="+searchType+"&treeOpen="+treeCollapsed+"&refresh=true&menuName=agg";
			}
			else if(this.getComponentsListPanel().network)
			{
				refreshURL = "../servlet/com.eg.EgMonitorController?from="+strFrom+"&monCmd=componentList&action=search&searchStateString="+stateComboValue+"&searchNameString="+nickName+"&selTypeString="+selType+"&searchTypeString="+searchType+"&treeOpen="+treeCollapsed+"&refresh=true&menuName=network";
			}
			else
			{
				refreshURL = "../servlet/com.eg.EgMonitorController?from="+strFrom+"&monCmd=componentList&action=search&searchStateString="+stateComboValue+"&searchNameString="+nickName+"&selTypeString="+selType+"&searchTypeString="+searchType+"&treeOpen="+treeCollapsed+"&refresh=true";
			}
		}
		else
		{
			if(this.getComponentsListPanel().aggregate)
			{
				//document.location=refreshURL+"&treeOpen="+treeCollapsed+"&refresh=true&menuName=agg";
				refreshURL="../servlet/com.eg.EgMonitorController?from="+strFrom+"&monCmd=componentList&action="+strAction+"&searchStateString="+stateComboValue+"&searchNameString="+nickName+"&selTypeString="+selType+"&searchTypeString="+searchType+"&treeOpen="+treeCollapsed+"&refresh=true&menuName=agg";
			}
			else if(this.getComponentsListPanel().network)
			{
				//document.location=refreshURL+"&treeOpen="+treeCollapsed+"&refresh=true&menuName=network";
				refreshURL="../servlet/com.eg.EgMonitorController?from="+strFrom+"&monCmd=componentList&action="+strAction+"&searchStateString="+stateComboValue+"&searchNameString="+nickName+"&selTypeString="+selType+"&searchTypeString="+searchType+"&treeOpen="+treeCollapsed+"&refresh=true&menuName=network";
			}
			else
			{
				if(strAction!=null && strAction=='search')
				{
					var action=requestParams.action;
					action=(action==null || action==undefined ||action=='null')?"":action;
					var componentType=requestParams.componentType;
					componentType=(componentType==null || componentType==undefined ||componentType=='null')?"":componentType;
					var fromPageView=requestParams.fromPageView;
					fromPageView=(fromPageView==null || fromPageView==undefined ||fromPageView=='null')?"":fromPageView;
					var subFilter=requestParams.subFilter;
					subFilter=(subFilter==null || subFilter==undefined ||subFilter=='null')?"":subFilter;
					var userName=requestParams.userName;
					userName=(userName==null || userName==undefined ||userName=='null')?"":userName;
					var selectedState=requestParams.selectedState;
					selectedState=(selectedState==null || selectedState==undefined ||selectedState=='null')?"":selectedState;
					
					if(subFilter!=null && subFilter!=undefined && subFilter!="" && componentType!=null && componentType!=undefined && componentType!="")
					{
						refreshURL="../servlet/com.eg.EgMonitorController?from="+strFrom+"&monCmd=componentList&action="+action+"&searchStateString="+stateComboValue+"&searchNameString="+nickName+"&selTypeString="+selType+"&searchTypeString="+searchType+"&treeOpen="+treeCollapsed+"&partOf=yes&componentType="+componentType+"&fromPageView="+fromPageView+"&zoneName="+subFilter+"&userName="+userName+"&stateName="+selectedState+"&selectedState="+selectedState;
					}
					else if(componentType!=null && componentType!=undefined && componentType!="")
					{
						refreshURL="../servlet/com.eg.EgMonitorController?from="+strFrom+"&monCmd=componentList&action="+action+"&searchStateString="+stateComboValue+"&searchNameString="+nickName+"&selTypeString="+selType+"&searchTypeString="+searchType+"&treeOpen="+treeCollapsed+"&componentType="+componentType+"&fromPageView="+fromPageView+"&userName="+userName+"&stateName="+selectedState+"&selectedState="+selectedState;
					}
					else if((componentType==null && componentType==undefined && componentType=="") ||(  strAction!=null && strAction=='search'))
					{
						if((stateComboValue!=null && stateComboValue!=undefined) || (nickName!=null && nickName!=undefined) || (selType!=null && selType!=undefined) || (searchType!=null && searchType!=undefined))
						{
							refreshURL="../servlet/com.eg.EgMonitorController?from="+strFrom+"&monCmd=componentList&action="+strAction+"&searchStateString="+stateComboValue+"&searchNameString="+nickName+"&selTypeString="+selType+"&searchTypeString="+searchType+"&treeOpen="+treeCollapsed;
						}
						else
						{
							refreshURL="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=componentList&action=component&isFromMenu=true";
						}
						
					}
					
				}
				else
				{
					if(strZoneName!=null && strZoneName!=undefined && strZoneName!="")
					{
						refreshURL="../servlet/com.eg.EgMonitorController?from="+strFrom+"&monCmd=componentList&action="+strAction+"&searchStateString="+stateComboValue+"&searchNameString="+nickName+"&selTypeString="+selType+"&searchTypeString="+searchType+"&treeOpen="+treeCollapsed+"&partOf=yes";
					}
					else
					{
						refreshURL="../servlet/com.eg.EgMonitorController?from="+strFrom+"&monCmd=componentList&action="+strAction+"&searchStateString="+stateComboValue+"&searchNameString="+nickName+"&selTypeString="+selType+"&searchTypeString="+searchType+"&treeOpen="+treeCollapsed;
					}
				}
				//document.location=refreshURL+"&treeOpen="+treeCollapsed+"&refresh=true";
			}
		}

		var checkedValue=true;
		if(!Ext.isEmpty(this.getSearchComponentCheck()))
		{
			checkedValue=this.getSearchComponentCheck().getValue();
		}

		if(checkedValue===true){
			refreshURL+="&searchIndComps=on";
		}

		refreshURL = refreshURL+"&componentListRefresh=yes";

		if((!Ext.isEmpty(strStateName)) && strStateName!="")
		{
			refreshURL = refreshURL+"&stateName="+strStateName;
		}
		if((!Ext.isEmpty(strCType)) && strCType!="")
		{
			refreshURL = refreshURL+"&componentType="+strCType;
		}

		if(fromHealth!=null && fromHealth!=undefined && fromHealth!="")
		{
			refreshURL = refreshURL+"&fromHealth="+fromHealth;
		}
		
		if((!Ext.isEmpty(strserviceName)) && strserviceName!="")
		{
			refreshURL = refreshURL+"&service="+strserviceName;
		}
		if((!Ext.isEmpty(strSiteName)) && strSiteName!="")
		{
			refreshURL = refreshURL+"&site="+strSiteName;
		}
		if((!Ext.isEmpty(strSegmentName)) && strSegmentName!="")
		{
			refreshURL = refreshURL+"&segment="+strSegmentName;
		}
		if((!Ext.isEmpty(strZoneName)) && strZoneName!="")
		{
			refreshURL = refreshURL+"&zoneName="+strZoneName;
		}
		if((!Ext.isEmpty(struserName)) && struserName!="")
		{
			refreshURL = refreshURL+"&userName="+struserName;
		}
		if((!Ext.isEmpty(strFromPageView)) && strFromPageView!="")
		{
			refreshURL = refreshURL+"&fromPageView="+strFromPageView;
		}
		if((!Ext.isEmpty(strselectedState)) && strselectedState!="")
		{
			refreshURL = refreshURL+"&selectedState="+strselectedState;
		}
		
		if(!Ext.isEmpty(requestParams) && requestParams.fromPageView == "UserView")
		{
			var referurl= Ext.getCmp('componentslistpanel').url;
			if(referurl!=null && referurl!=undefined && referurl!="")
				this.updateRefresh(referurl);
		}
		else if(compRefUrl!=null && compRefUrl!=undefined && compRefUrl!="")
		{
			this.updateRefresh(compRefUrl);
		}
		else
		{
			this.updateRefresh(refreshURL);
		}
		
	},
	updateRefresh:function(url)
	{
		var myMask="";
		var commonpanel = Ext.getCmp('commonpanel');
		if(!Ext.isEmpty(commonpanel))
		{
			myMask = new Ext.LoadMask(commonpanel, {msg:"Please wait..."});
		}

		if(!Ext.isEmpty(myMask))
		{
			myMask.show();
		}

		Ext.Ajax.request({
			url : url,
			scope:this,
			timeout:300000,
			success : function(response, opts){

				var jsonText = null;
				jsonText = response.responseText;
				var jsonData = null;
				jsonData = Ext.decode(jsonText);
				//jsonText = null;
				delete jsonText;
				Ext.destroy(jsonText);

				if(!Ext.isEmpty(jsonData.HiddenFields.menuName) && jsonData.HiddenFields.menuName == 'agg')
					componentsList.app.aggregate = true;
				else if(!Ext.isEmpty(jsonData.HiddenFields.menuName) && jsonData.HiddenFields.menuName == 'network')
					componentsList.app.network = true;
				

				var backButton = Ext.getCmp('back');

				if(!Ext.isEmpty(backButton))
				{
					backButton.setText(jsonData.ScreenLabels["backButtonText"]);
				}

				backButton = null;
				delete backButton;

				var mainPanel = Ext.getCmp('componentslistpanel');
				if(jsonData.ListLabels["ListTitle"] != undefined && jsonData.ListLabels["ListTitle"] != null)
					mainPanel.setTitle(jsonData.ListLabels["ListTitle"] ? jsonData.ListLabels["ListTitle"] : "");
				else
					mainPanel.setTitle(jsonData.ScreenLabels["Title"] ? jsonData.ScreenLabels["Title"] : "");

				var stateCombo = Ext.getCmp('searchState');
				if(!Ext.isEmpty(stateCombo))
				{
					stateCombo.getStore().loadRawData(jsonData.SearchLabels.searchStateString);
					stateCombo.value = jsonData.SearchLabels.searchStateStringSelected ? jsonData.SearchLabels.searchStateStringSelected : jsonData.SearchLabels.searchStateString[0].value;
				}

				stateCombo = null;
				delete stateCombo;

				var searchNickName = Ext.getCmp('nickName');
				if(!Ext.isEmpty(searchNickName))
				{
					searchNickName.value = jsonData.SearchLabels["searchNameString"] ? jsonData.SearchLabels["searchNameString"] : "";
				}

				searchNickName = null;
				delete searchNickName;

				var Type = Ext.getCmp('Type');
				if(!Ext.isEmpty(Type))
				{
					Type.getStore().loadRawData(jsonData.SearchLabels.selTypeString);
					Type.value = jsonData.SearchLabels.selTypeStringSelected ? jsonData.SearchLabels.selTypeStringSelected : jsonData.SearchLabels.selTypeString[0].value;
				}

				Type = null;
				delete Type;

				var searchType = Ext.getCmp('searchType');
				if(!Ext.isEmpty(searchType))
				{
					searchType.value = jsonData.SearchLabels["typeString"] ? jsonData.SearchLabels["typeString"] : "";
				}

				searchType = null;
				delete searchType;

				var searchComp = Ext.getCmp('searchComp');
				if(!Ext.isEmpty(searchComp))
				{
					searchComp.boxLabel  = jsonData.SearchLabels["searchIndComps"] ? jsonData.SearchLabels["searchIndComps"] : "";
				}

				searchComp = null;
				delete searchComp;
				//searchComp.checked = requestParams.searchIndComps==='on' ||  requestParams.searchIndComps==='checked' ? true : false;
				commonpanel = Ext.getCmp('commonpanel');
				if(!Ext.isEmpty(commonpanel))
				{
					var titleTool = Ext.getCmp('titleTool');
					//commonpanel.removeAll();
					var resultItems=commonpanel.items.items;
					for(var item=resultItems.length-1; item>-1 ; item--)
					{
						resultItems[item].destroy();
					}
					//commonpanel.update("");
					//commonpanel.setTitle(jsonData.ListLabels["ListTitle"] ? jsonData.ListLabels["ListTitle"] : "");
					if(jsonData["error"])
					{
						titleTool.hide();
						var searchNoList = Ext.create('utilities.ErrorPanel',{
						style:{'border':'0px solid orange'},
						errorMsg : '<div style="text-align:center;valign:middle;margin:15% auto;"><img src="/final/images/clear.png" class="iconInformation" /><br/><div class="list-empty-text">'+jsonData["error"]+'</div></div>'
						});
						commonpanel.add({
							xtype:'panel',
							border:false,
							layout:'fit',
							flex:1,
							width:'100%',
							items: searchNoList
						});
					}
					else
					{
						titleTool.show();
						var componentTypeArray = jsonData.ListLabels["ComponentList"];  //To Display the Component
						Ext.suspendLayouts();
						/*for(var componentTypeCounter = 0 ; componentTypeCounter < componentTypeArray.length; componentTypeCounter++){
								var listComponent = Ext.create('componentsList.view.ListComponent',{
									rootComponent :componentTypeArray[componentTypeCounter]
								});
								commonpanel.add(listComponent);
						}*/
						var finalCompData ='';
						for(var componentTypeCounter = 0 ; componentTypeCounter < componentTypeArray.length; componentTypeCounter++)
						{
							var leftData="";
							leftData = "<table class='table-list-layout' style='width:100%'><tr><td style='width:203px;text-align:center;"+stylefrLight+"'>";
							var strShowImg = componentTypeArray[componentTypeCounter]["showImg"];
							var typeState = componentTypeArray[componentTypeCounter]["TypeState"];
							if(!Ext.isEmpty(strShowImg))
							{
								leftData=leftData+'<div style="margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;" align="left"><div style="position:relative;top:0px;left:0px;border:0px solid red;"><img src="'+componentTypeArray[componentTypeCounter]["type"]+'"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+typeState+'"></div></div></div><div style="margin:0px auto 5px auto;width:190px;" data-qclass="yellowTip" class="component-list-left-font" data-qtip="'+componentTypeArray[componentTypeCounter].title+'">'+componentTypeArray[componentTypeCounter].name+'</div>';
							}
							else
							{
								leftData=leftData+'<div data-qclass="yellowTip" style="margin:0px auto 5px auto;width:190px;" class="component-list-left-font" data-qtip="'+componentTypeArray[componentTypeCounter].title+'">'+componentTypeArray[componentTypeCounter].name+'</div>';
							}
							leftData = leftData+"</td><td>"
							var rightComponentItems = componentTypeArray[componentTypeCounter]["children"];
							var temp="";
							temp="<div>";
							var contComp=0;
							for (var subElementsCount = 0; subElementsCount < rightComponentItems.length; subElementsCount++)
							{
								var innerItem = rightComponentItems[subElementsCount];
								if(!Ext.isEmpty(innerItem["configChange"]) || !Ext.isEmpty(innerItem["MaintenanceTime"]) || (!Ext.isEmpty(innerItem["configChange"]) && !Ext.isEmpty(innerItem["MaintenanceTime"]))){
									var widthOfName = getWidthOfText(innerItem["name"],"f11-normal") + 15;
									if(widthOfName > 160)
										widthOfName = 160;
									var widthOfNameC = widthOfName + 35;
									if(widthOfNameC > 200){
										widthOfNameC = 200;
										widthOfName = 160;
									}
								}else{
									widthOfName = 200;
									widthOfNameC = 200;
								}
								temp=temp+"<div style='width:240px;float:left;border:0px solid red'>";

									temp=temp+'<div style="float:left;display:inline-block;width:'+widthOfNameC+'px"><div class="serviceSegmentComponentName"><img style="position:relative;" src="/final/images/clear.png" class="'+ innerItem["stateName"]+ '"/><a style="width:90%;padding-left:0px" class="component-list-right-link" data-qclass="yellowTip" href="javascript:void(0)" onclick=\'javascript:componentListToDashboard("'+ innerItem["link"] + '","' + innerItem["name"]+ '")\' data-qtip="'+ innerItem["title"]+ '" ><div style="overflow:hidden;text-overflow:ellipsis;width:'+widthOfName+'px;">'+ innerItem["name"] + '</div></a></div></div>';

									if(!Ext.isEmpty(innerItem["MaintenanceTime"]))
									{
										temp=temp+'<div style="float:left;margin-top:2px;margin-right:6px"><div class="iconMaintenance" data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="'+innerItem["MaintenanceTime"]+'"></div></div>';
									}

									if(!Ext.isEmpty(innerItem["configChange"]))
									{
										var confighref = '/final/monitor/EgConfigChange.jsp?componentName='+innerItem["configChange"];
										//temp=temp+'<div style="float:left;margin-top:2px;"><a href="/final/monitor/EgConfigChange.jsp?componentName='+innerItem["configChange"]+'"> <div class="iconConfigUser handSymbol"  data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="Configuration"></div></a></div>';
										temp=temp+'<div style="float:left;margin-top:2px;" id="configchange"><a href="javascript:void(0)" > <div onclick="configPop(\''+confighref+'\')" onmouseover="javascript:void(0)" class="iconConfigUser handSymbol"  data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="Configuration"></div></a></div>';
									}
								temp=temp+"</div>";
							}
							temp=temp+"</div>";
							leftData = leftData+temp+"</td></tr></table>";
							finalCompData += leftData;
						}
						commonpanel.update(finalCompData);
						Ext.resumeLayouts(true);
					}
					mainPanel.add(commonpanel);
					myMask.hide();
					titleTool = null;
					delete titleTool;

					commonpanel = null;
					delete commonpanel;

					mainPanel = null;
					delete mainPanel;
				}
				//jsonData = null;
				delete jsonData;
				Ext.destroy(jsonData);

				var listButIdObj=Ext.getCmp('listButId');
				var GridButIdObj=Ext.getCmp('GridButId');

				if(GridButIdObj!=null && GridButIdObj!=undefined)
				{
					GridButIdObj.removeCls('iconCompGridviewSelect');
					GridButIdObj.removeCls('iconCompGridview');

					GridButIdObj.addCls('iconCompGridview');
				}
				
				if(listButIdObj!=null && listButIdObj!=undefined)
				{
					listButIdObj.removeCls('iconCompListviewSelect');
					listButIdObj.removeCls('iconCompListview');
					listButIdObj.addCls('iconCompListviewSelect');
				}

			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	componentListToDashboard:function(dashboardUrl, selectedComponent){
		//var treePanel=this.getComponentsTreePanel();
		var treeCollapsed=true;//!treePanel.getCollapsed();
		var isAggregate = requestParams.isAggregate;
		var isNetwork = requestParams.isNetwork;
		var isServiceBusiDash = requestParams.isServiceBusiDash;
		var isServiceBusiDetails = requestParams.isServiceBusiDetails;
		var treeFlag_SBD = requestParams.treeFlag_SBD;
		var outsideService_SBD = requestParams.outsideService_SBD;
		var titleText_SBD = requestParams.titleText_SBD;
		var selectNode_SBD = requestParams.selectNode_SBD;
		var isEmulTrans_SBD = requestParams.isEmulTrans_SBD;
		var serviceState_SBD = requestParams.serviceState_SBD;
		var serviceName= requestParams.serviceName;
		var stateName= requestParams.stateName;
		var from= requestParams.from;
		
		dashboardUrl = dashboardUrl+"&ComponentTree="+treeCollapsed+"&selected="+selectedComponent+"&PagesComesfrom="+PagesComesfrom+"&actionFrom="+requestParams.action+"&componentType="+componentType+"&isAggregate="+isAggregate+"&isNetwork="+isNetwork+"&isServiceBusiDash="+isServiceBusiDash+"&isServiceBusiDetails="+isServiceBusiDetails+"&treeFlag_SBD="+treeFlag_SBD+"&outsideService_SBD="+outsideService_SBD+"&titleText_SBD="+titleText_SBD+"&selectNode_SBD="+selectNode_SBD+"&isEmulTrans_SBD="+isEmulTrans_SBD+"&serviceState_SBD="+serviceState_SBD+"&serviceName="+serviceName+"&compState="+stateName+"&fromUserView="+from+"&fromHealth="+fromHealth;
		if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
			dashboardUrl = dashboardUrl + "&com.eg.CSRF_NONCE="+csrfToken;
		document.location = dashboardUrl;
		},
	itemset:function(window,e){
			var itemIdVal=this.getCommonPanel().itemId;
			window.add(window.setData("","",itemIdVal));
		},
			
	combo:function(combo,newvalue,opt){
		var itemIdVal=this.getCommonPanel().itemId;
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
		var testfun='';
		//if(descMeasureUnit=='Yes')
		testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		var name=combo.getName();
		var val=combo.getValue();
		var componentType;
		
		if(selectedTab=='Component' || selectedTab=='Aggregate')
			componentType=this.getConfigWindowForm().getForm().getValues()['serviceComp'];
		
		if(name=='serviceComp')
		{
			this.getConfigWindow().setData(selectedTab,perform,itemIdVal,componentType,"","","",descMeasureUnit,testfun,"", name, val);
		}
		if(name=='compLayer')
		{
			var compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			this.getConfigWindow().setData(selectedTab,perform,itemIdVal,componentType,compname,"","",descMeasureUnit,testfun,"", name, val);
		}
		else if(name=='serviceTest')
		{
			var compname;
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			else
				compname='';
			var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			this.getConfigWindow().setData(selectedTab,perform,itemIdVal,componentType,compname,testName,"",descMeasureUnit,testfun,"", name, val);
		}
		else if(name=='serviceMeasure')
		{
			var compname;
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			else
				compname='';
			var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			var measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
			var dispName=newvalue[0].data.name;
			this.getConfigWindow().setData(selectedTab,perform,itemIdVal,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName, name, val);
		}
		else{}
	},

	radio:function(radio,newvalue,oldvalue,opts){
		var itemIdVal=this.getCommonPanel().itemId;
		var name='';
		var componentType='';
		var compname='';
		var testName='';
		var measureName='';
		var dispName='';
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit='';
		var testfun='';
		if(perform=='Add' || perform=='Modify')
		{
			//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
			//if(descMeasureUnit=='Yes')
			testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		}
		if(radio.getName()=='Does the Test have Descriptors ?'||radio.getName()=='Function')
		{
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			if(selectedTab=='Component' || selectedTab=='Aggregate')
				componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
				testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
				measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
				dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
				name=radio.name;
		}
		if(radio.getName() !='Function')
		{
			this.getConfigWindow().setData(selectedTab,perform,itemIdVal,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
		}
	},

	buttonclick:function(button,e,opts)
	{
		var itemIdVal=this.getCommonPanel().itemId;
		var flag=false;
		var me=this;
		var url='/final/monitor/serviceDashboardConfigP.jsp';
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var params='selectType=Update';
		var json=this.getConfigWindow().jsonData.Window.fields;
		var labels=this.getConfigWindow().jsonData.Window.screenlabels[0];
		for(var i=0;i<json.length;i++)
		{
			if(json[i].type=='combo')
			{
				var name=json[i].name;
				if(this.getConfigWindowForm().getForm().findField(name).getValue()==-1)
				{
					Ext.Msg.show({
							title:'ALERT',
							cls:'msgtextalign',
							msg:labels[name],
							buttons: Ext.Msg.OK
					});
					flag=true;
					break;
				}
				else
				{
					if(name=='serviceTest')
						name='testName';
					params+='&'+name+'='+json[i].selected;
				}
			}
			else
			{
				if(json[i].type=='textfield')
				{
					var dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
					flag=true;

					// Changes For ?,',- and Numbers charcters Support - Starts Here
					while(true){
						if(dispName.indexOf("?") != -1)
							dispName = dispName.replace('?','qqsstt');
						if(dispName.indexOf("'") != -1)
							dispName = dispName.replace("'","sinCour");
						if(dispName.indexOf("-") != -1)
							dispName = dispName.replace("-","minSym");

						if(dispName.indexOf("?") == -1 && dispName.indexOf("'") == -1 && dispName.indexOf("'") == -1)
							break;
					}

					if(dispName.length<1){					
						Ext.Msg.show({
							title:'ALERT',
							cls:'msgtextalign',
							msg: 'Please enter display name',
							buttons: Ext.Msg.OK
						});
					}
					//else if(this.hasNumbers(dispName))
					//	Ext.Msg.alert("","Number not allowed");
					else if(this.hasSpecialCharacters(dispName))
					{
						if(this.hasNumbers(dispName))
						{
							params+='&'+json[i].name+'='+dispName;
							flag=false;
						}
						else
						{
							Ext.Msg.show({
								title:'ALERT',
								cls:'msgtextalign',
								msg: 'Please enter display name',
								buttons: Ext.Msg.OK
							});
						}
					}
					else
					{
						params+='&'+json[i].name+'='+dispName;
						flag=false;
					}

					// Changes For ?,',- and Numbers charcters Support - Ends Here
				}
				else
				{
					if(json[i].selected=='Component')
						json[i].selected='Application';
					params+='&'+json[i].name+'='+json[i].selected;
				}
			}
		}
		
		var selectfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		if(perform=='Modify')
			params+='&selectedfunc='+selectfun;

		if(flag==false)
		{
			Ext.Ajax.request({
				url: url,
				params:params,
				method : 'POST',
				scope:this,
				timeout:300000,
				success: function(response){
					var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
					var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
					var dispName="";
					var measureName=-1;
					var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
					var compname='';
					var componentType='';
					var descMeasureUnit='';
					var testfun='';
					if(perform=='Add')
					{
						descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
						//if(descMeasureUnit=='Yes')
						testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
						compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
						Ext.Msg.show({
							title:'STATUS',
							cls:'msgtextalign',
							msg:'Measure Added Successfully',
							buttons: Ext.Msg.OK
						});
					}
					else if(perform=='Delete')
					{
						Ext.Msg.show({
							title:'STATUS',
							cls:'msgtextalign',
							msg:'Measure Deleted Successfully',
							buttons: Ext.Msg.OK
						});
					}
					else (perform=='Modify')
					{
						testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
						Ext.Msg.show({
							title:'STATUS',
							cls:'msgtextalign',
							msg:'Measure Modified Successfully',
							buttons: Ext.Msg.OK
						});
					}
					if(selectedTab=='Component' || selectedTab=='Aggregate')
						componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
					this.getConfigWindow().setData(selectedTab,perform,itemIdVal,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		if(flag==false)
		{
			Ext.Function.defer(function(){
				me.setValues(flag);
			},350);
		}
	},
	setValues:function(flag){
		if(flag==false)
		{
			var json1=this.getConfigWindow().jsonData.Window.fields;
			var f=false;
			for(var i=0;i<json1.length;i++)
			{
				if(json1[i].type=='combo')
				{
					if(json1[i].selected!='Not Applicable!')
							f=true;
					if(!f && (this.getConfigWindowForm().getForm().getValues()['perform']=='Delete' || this.getConfigWindowForm().getForm().getValues()['perform']=='Modify'))
						this.getConfigWindowForm().getForm().findField(json1[i].name).setValue(-1);
				}
				f=false;
			}
		}
	},
	hasNumbers:function(t)
	{
		var regex = /\d/g;
		return regex.test(t);
	},
	hasSpecialCharacters:function(t)
	{
		var charAr = t.split('');
		if(charAr != null && charAr != undefined && charAr.length > 0)
		{
			for(var p=0;p<charAr.length;p++)
			{
				var c = charAr[p];
				if(!(c ==' ' || c ==')' || c =='(' || c =='_' || c.match(/^[-'a-z\u4e00-\u9eff]{1,20}$/i)))
					return true;
			}
			return false;
		}
	},
});