Ext.define('componentsList.view.ComponentsTreePanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.componentstreepanel',
	layout : 'fit',
	bodyCls:'top-left-radius bottom-left-radius',
	url : null,
	nodeId:null,
	treePanelTitle : null,
	initComponent : function(){
		var me = this;
				
		Ext.Ajax.request({
			url : me.url,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				jsonData["expanded"] = true;
				jsonData["cls"] = "list-tree-root-expand-collapse";
				var treePanelStore = Ext.create('Ext.data.TreeStore', {
					root : jsonData
				});
				var treeTitle='<a href="'+jsonData.link+'">'+jsonData.text+'</a>';
				if(!Ext.isEmpty(jsonData.iconCls)){
					treeTitle='<div class="'+jsonData.iconCls+'">&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp<span  class="tree-title">'+treeTitle+'</span></div>';						//  Kaliraj
				}
				var treePanel = Ext.create('StatefulTreePanel',{
					store : treePanelStore,
					cls:'tree-panel-holder',
					bodyCls:'tree-panel',
					border : false,
					stateId:'components-tree-panel-stateId',
					title : treeTitle,
					rootVisible : true							// Prem
				});
				me.add(treePanel);
			}
		});
		this.callParent();
	}
});
