Ext.define('componentsList.view.Main', {
	extend: 'Ext.panel.Panel',
//	extend: 'utilities.OuterPanel',
	requires : ['Ext.layout.container.Border','componentsList.view.ComponentsListPanel','utilities.ScrollCombo','utilities.CommonPanel','componentsList.view.Paging','componentsList.view.ConfigWindow'],
	alias:'widget.main',
//	bodyCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius components-main-panel',
	//border:true,
	frame:true,
	cls:'outerpanel sapheader',
	margin:"8 8 0 8",
	padding:"0",
	bodyPadding:"0",
	id:'main',
	layout: {
		type: 'border'
	},

	initComponent : function() {
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
		var contentPanel={
			xtype:'componentslistpanel',
			//bodyCls:'bottom-right-radius',
			region:'center',
			mask: mask,
			url : componentListPanelDefaultURL,
			view:requestParams.view,
			viewId:requestParams.viewId,
			viewPageTitle:requestParams.viewPageTitle,
			viewTreeTitle:requestParams.viewTreeTitle,
		};

		this.items = [contentPanel];
		this.callParent();
	}
});

/*  Script for automatic scroll options start here   */

var divCount = 2;
var gettingComponentDivId=0;
var scrolldelay, divArray;

function getDivArray(){
	divArray = Ext.getCmp('commonpanel').items.items;
	if(!Ext.isEmpty(divArray) && divArray!=null && divArray!=undefined)
		divArrayLength = divArray[0].getHeight();
}

function pageScroll(){
	var pane=Ext.getCmp('commonpanel');
	if(!Ext.isEmpty(pane))
	{
		if (divArray == null || divArray == undefined)
		{
			getDivArray();
		}
		var getMainBody = pane.body;
		var divHeight=0;
		for (i=1;i<=divCount;i++ )
		{
			if(!Ext.isEmpty(divArray) && divArray!=null && divArray!=undefined)
				divHeight+=divArray[gettingComponentDivId].getHeight();
			gettingComponentDivId++;
		}
		getMainBody.scrollBy(0,divHeight);
		scrolldelay = setTimeout('pageScroll()', 3000);
		if($('#commonpanel-body').scrollTop()+$('#commonpanel-body').innerHeight() >= $('#commonpanel-body')[0].scrollHeight)
		{
			gettingComponentDivId=0;
			if (window.parent.tvModePlayAction!=undefined && window.parent.tvModePlayAction=='pause')
			{
				stopScroll();
				setTimeout('startTvModePlayAction()',3000);
			}
			else
			{
				clearTimeout(scrolldelay);
				scrolldelay=setTimeout('beforeContinueScroll()',3000);
			}
		}
	}
}

function startTvModePlayAction(){
	jumpScroll();
	window.parent.startTvModePlayAction();
}

function beforeContinueScroll(){
	var pane=Ext.getCmp('commonpanel');
	if (!Ext.isEmpty(pane))
	{
		$('#commonpanel-body').scrollTop(0);
		scrolldelay = setTimeout('pageScroll()',3000);
	}
}

function stopScroll(){
	clearTimeout(scrolldelay);
}

function jumpScroll(){
	var pane=Ext.getCmp('commonpanel');
	if (!Ext.isEmpty(pane))
	{
		clearTimeout(scrolldelay);
		gettingComponentDivId=0;
		$('#commonpanel-body').scrollTop(0); // horizontal and vertical scroll targets
	}
}

	scrolldelay = null;
	delete scrolldelay;


/*  Script for automatic scroll options  end here   */

