Ext.define('currentEvents.controller.DetailedDiagnosis',{
	extend : 'Ext.app.Controller',
	refs : [{
			ref : 'descriptionCombo',
			selector : 'main combo[itemId= "infolist"]'
	},{
		ref : 'measurementCombo',
		selector : 'main combo[itemId= "measurelist"]'
	},{
		ref : 'timelineCombo',
		selector : 'main combo[itemId= "timeline"]'
	},{
		ref : 'fromHrCombo',
		selector : 'main combo[itemId= "fromHr"]'
	},{
		ref : 'fromMinCombo',
		selector : 'main combo[itemId= "fromMin"]'
	},{
		ref : 'toHrCombo',
		selector : 'main combo[itemId= "toHr"]'
	},{
		ref : 'toMinCombo',
		selector : 'main combo[itemId= "toMin"]'
	},{
		ref : 'fromDate',
		selector : 'main datefield[itemId= "fromdate"]'
	},{
		ref : 'toDate',
		selector : 'main datefield[itemId= "todate"]'
	},{
		ref : 'detailedDiagnosisPanel',
		selector : 'main'
	}],
	
	init : function(){
		this.control({
				'main combo[itemId= "timeline"]' : {
					select : this.showDetailedDiagnosis
				},
					'main button[action="submit"]' : {
						click : this.showDetailedDiagnosis
				},
					'main toolbar button[action="analysis"]' : {
						click : this.showAnalysis
					},
					'main toolbar button[action="save"]' : {
						click : this.savePDF
				},
					'main toolbar button[action="csv"]' : {
						click : this.showCSV
				},
					'main toolbar button[action="print"]' : {
						click : this.printDiagnosis
				}
		});
	},
	
	getAllFieldValues : function(){
		var jsonData = this.getDetailedDiagnosisPanel().jsonData;
		var filtersObject = new Object();
		filtersObject.measurement = this.getMeasurementCombo().getValue();
		filtersObject.measurementText = this.getMeasurementCombo().getValue();
		filtersObject.timeline = this.getTimelineCombo().getValue(); 
		var fromDate = this.getFromDate().getValue();
		if(!Ext.isEmpty(fromDate)){
			filtersObject.fromDate=Ext.Date.format(fromDate,'m/d/Y');
		  }
		var toDate = this.getToDate().getValue();
		if(!Ext.isEmpty(toDate)){
			filtersObject.toDate=Ext.Date.format(toDate,'m/d/Y');
		  }
		
		  var currentDate = new Date();
		  var currentHrs = currentDate.getHours();
		  var currentMin = currentDate.getMinutes();
		  currentDate = Ext.Date.format(currentDate,'m/d/Y');
		 
		filtersObject.fromHr = this.getFromHrCombo().getValue();
		filtersObject.fromMin = this.getFromMinCombo().getValue();
		filtersObject.toHr = this.getToHrCombo().getValue();
		filtersObject.toMin = this.getToMinCombo().getValue();
		if(filtersObject.timeline=="Any" && (currentDate < filtersObject.fromDate || currentDate < filtersObject.toDate)){
			Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorCurrentDate);
			  return;
		}else if(filtersObject.timeline =="Any" && (currentDate == filtersObject.fromDate || currentDate == filtersObject.toDate)&&
				(currentHrs < filtersObject.fromHr || currentHrs < filtersObject.toHr)){
			Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorCurrentDate);
			  return;
		}else if(filtersObject.timeline =="Any" && (currentDate == filtersObject.fromDate || currentDate == filtersObject.toDate)&&
				(currentHrs == filtersObject.fromHr || currentHrs == filtersObject.toHr) && (currentMin < filtersObject.fromMin || currentMin < filtersObject.toMin)){
			Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorCurrentDate);
			  return;
		}
		if(filtersObject.timeline=="Any" && filtersObject.fromDate > filtersObject.toDate){
			  Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorDate);
			  return;
		}
		 if(filtersObject.timeline=="Any" && filtersObject.fromDate == filtersObject.toDate){
			  if(filtersObject.fromHr > filtersObject.toHr){
				  Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorDate);
				  return;
			  }
		 }
		 if(filtersObject.timeline=="Any" && filtersObject.fromDate == filtersObject.toDate){
			  if(filtersObject.fromHr == filtersObject.toHr){
				  if(filtersObject.fromMin >= filtersObject.toMin){
				  Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorDate);
				  return;
				  }
			  }
		 }
		return filtersObject;
	},
	showDetailedDiagnosis : function(){
		var jsonData = this.getDetailedDiagnosisPanel().jsonData;
		var filtersObject = this.getAllFieldValues();
		if(!Ext.isEmpty(filtersObject)){
		var dignosisLink = ddUrl;
		
			//dignosisLink+="&timeline="+filtersObject.timeline;
			dignosisLink = dignosisLink.replace(/(measure=)[^\&]+/, '$1' + filtersObject.measurement);
			dignosisLink = dignosisLink.replace(/(timeline=)[^\&]+/, '$1' + filtersObject.timeline);
			dignosisLink = dignosisLink.replace(/(starttime=)[^\&]+/, '$1' + filtersObject.fromDate);
			dignosisLink = dignosisLink.replace(/(endtime=)[^\&]+/, '$1' + filtersObject.toDate);
			dignosisLink = dignosisLink.replace(/(starthr=)[^\&]+/, '$1' + filtersObject.fromHr);
			dignosisLink = dignosisLink.replace(/(endhr=)[^\&]+/, '$1' + filtersObject.toHr);
			dignosisLink = dignosisLink.replace(/(startmin=)[^\&]+/, '$1' + filtersObject.fromMin);
			dignosisLink = dignosisLink.replace(/(endmin=)[^\&]+/, '$1' + filtersObject.toMin);
			dignosisLink = dignosisLink.replace(/(comeFrom=)[^\&]+/, '$1' + filtersObject.comeFrom);
		
			Ext.Ajax.request({
			url : dignosisLink,
			scope : this,
			success : function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData)){
				this.getDetailedDiagnosisPanel().removeAll();
				this.getDetailedDiagnosisPanel().createDiagnosisUI(jsonData);
				}
			}
			
		});
	 }
	},
	showAnalysis : function(){
		var jsonData = this.getDetailedDiagnosisPanel().jsonData;
		if(!Ext.isEmpty(jsonData.errorMsg) && Ext.isEmpty(jsonData.gridInfo)){
			Ext.Msg.alert('Error',jsonData.errorMsg);
			return;
		}
		var filtersObject = this.getAllFieldValues();
		var url = ddUrl;
		url=url.substring(url.indexOf("?")+1,url.length);	
		if(Ext.isEmpty(jsonData.hiddenFields.hqstring)){
			jsonData.hiddenFields.hqstring = "site";
		}
		url = url.replace(/(measure=)[^\&]+/, '$1' + filtersObject.measurement);
		url = url.replace(/(starttime=)[^\&]+/, '$1' + filtersObject.fromDate);
		url = url.replace(/(endtime=)[^\&]+/, '$1' + filtersObject.toDate);
		url = url.replace(/(starthr=)[^\&]+/, '$1' + filtersObject.fromHr);
		url = url.replace(/(endhr=)[^\&]+/, '$1' + filtersObject.toHr);
		url = url.replace(/(startmin=)[^\&]+/, '$1' + filtersObject.fromMin);
		url = url.replace(/(endmin=)[^\&]+/, '$1' + filtersObject.toMin);
		url = url.replace(/(comeFrom=)[^\&]+/, '$1' + filtersObject.comeFrom);
		if(url!=null){
		window.openWindow("/final/monitor/egDetailDiagnosis.jsp?"+url+"&from=0&fromPage=alarm&comeFrom="+jsonData.hiddenFields.comeFrom+"&timeline="+filtersObject.timeline+"&filterdate=All&isSubmit=true&newWindow=true",jsonData.pageTitle+""+filtersObject.measurement,"width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
		}
	},
	printDiagnosis : function(){
		var jsonData = this.getDetailedDiagnosisPanel().jsonData;
		if(!Ext.isEmpty(jsonData.errorMsg) && Ext.isEmpty(jsonData.gridInfo)){
			Ext.Msg.alert('Error',jsonData.errorMsg);
			return;
		}
		var filtersObject = this.getAllFieldValues();
		var url = ddUrl;
		url=url.substring(url.indexOf("?")+1,url.length);	
		url = url.replace(/(measure=)[^\&]+/, '$1' + filtersObject.measurement);
		url = url.replace("measure", "s_mes");
		url = url.replace("info", "s_info");
		url = url.replace("test", "s_test");
		url = url.replace("port", "s_port");
		url = url.replace("host", "s_host");
		url = url.replace("site", "s_site");
		
		window.openWindow("/final/monitor/Egprintdata.jsp?isDDdata=yes&"+url+"&messwills_val="+jsonData.hiddenFields.messwills_val+"&messwills=1&"+"strValue=Process_ID%252CUtil%252CProcess_details&proceed="+jsonData.hiddenFields.proceed+"&layer=null&s_end_min="+filtersObject.toMin+"&s_st_min="+filtersObject.fromMin+"&s_st_hr="+filtersObject.fromHr+"&s_en_hr="+filtersObject.toHr+"&isVM="+jsonData.hiddenFields.isVM,jsonData.hiddenFields.detailedDiagnosis,"width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
		
	},
	savePDF : function(){
		var jsonData = this.getDetailedDiagnosisPanel().jsonData;
		if(!Ext.isEmpty(jsonData.errorMsg) && Ext.isEmpty(jsonData.gridInfo)){
			Ext.Msg.alert('Error',jsonData.errorMsg);
			return;
		}
		var blankPage = "";
		if(location.protocol=="https:") blankPage="/final/blank.html";
		//var win=parent.openWindow(blankPage,"SaveWindow","width=400,height=150,left=300,top=200,scrollbars=no,resizable=no");
		var win=parent.open(blankPage,"SaveWindow","width=400,height=150,left=300,top=200,scrollbars=no,resizable=no");
		win.document.write("<html>");
		win.document.write("<title>Downloading</title>");
		win.document.write("<frameset rows= '0%,0%,*' frameborter='NO' border='0' framespacing='0'>");
		win.document.write("<frame src='/final/servlet/com.eg.EgPdfDownloadC' frameborder=0 noresize scrolling=no name='Data'>");
		win.document.write("<frame src='/final/reporter/ErSaveStatus.jsp?from=egDiagnosis' frameborder=0 noresize scrolling=auto>");
		win.document.write("<frame src='" + blankPage + "' frameborder=0 noresize scrolling=auto name='statusPanel'>");
		win.document.write("</frameset>");
		win.document.write("</html>");
		win.frames[2].document.open("text/html","replace");
		win.frames[2].document.write('<html><head>');
		win.frames[2].document.write('<link rel="stylesheet" href="/final/monitor/eg_styles/monstyle_<%=monitor_Skin%>.css" />');
		win.frames[2].document.write('</head><body id="eg_morelight"><br><br><h4 align="center" style="font-family: Verdana,Arial; font-size: 15px; color: #000000;"><img src="/final/reporter/images/load_round.gif"><br><br>Downloading! Please wait...</h4></body></html>');
		win.frames[2].document.close();
	},
	showCSV : function(){
		var jsonData = this.getDetailedDiagnosisPanel().jsonData;
		if(!Ext.isEmpty(jsonData.errorMsg) && Ext.isEmpty(jsonData.gridInfo)){
			Ext.Msg.alert('Error',jsonData.errorMsg);
			return;
		}
		window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?fromDD=true","CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
	}
});