Ext.define('currentEvents.controller.Main', {
    extend: 'Ext.app.Controller',
    views:['currentEvents.view.Main'],
    refs:[{
    		ref : 'main',
    		selector : 'main'
    },{
    	ref : 'measureGraphFilters',
		selector : 'measuregraphfilters'
    }],
    init: function() {
    	this.control({
    	'main': {
    			render : function(panel) {
    				Ext.Ajax.request({
    					url : pageToShow=="graph"?url:ddUrl,
    					method : 'POST',
    					scope : this,
    					success : function(response, opts) {
    						var jsonText = response.responseText;
    						var jsonData = Ext.decode(jsonText);
    						if(pageToShow=="graph")
    							panel.createGraphUI(jsonData);
    						else if(pageToShow=="diagnosis")
  							{
      							panel.createDiagnosisUI(jsonData);
  							}
    					}
    				});
    			}
    		}
    	});
    }
});