Ext.define('currentEvents.controller.MeasureGraph', {
	extend: 'Ext.app.Controller',
	views:['currentEvents.view.MeasureGraphFilters'],
	stores:['currentEvents.store.Measures'],
	refs:[{
		ref:'measureGraphFilters',
		selector:'eventsmeasuregraphfilters'
	},{
		ref:'dataRangeMin',
		selector:'eventsmeasuregraphfilters panel textfield[action=datarangeMin]'
	},{
		ref:'dataRangeMax',
		selector:'eventsmeasuregraphfilters panel textfield[action=datarangeMax]'
	},{
		ref:'lookupEnabled',
		selector:'eventsmeasuregraphfilters panel checkbox[action=lookback]'
	},{
		ref:'intervalValue',
		selector:'eventsmeasuregraphfilters panel combo[action=er_interval]'
	},{
		ref:'timesValue',
		selector:'eventsmeasuregraphfilters panel combo[action=er_integrate]'
	},{
		ref:'otherTimesValue',
		selector:'eventsmeasuregraphfilters panel combo[action=er_otherTime]'
	},{
		ref:'measuresValue',
		//selector:'eventsmeasuregraphfilters panel combo[action=measurelist]'
		selector:'eventsmeasuregraphfilters panel multiselectfield[action=measurelist]'
	},{
		ref:'timelineValue',
		selector:'main panel slider[action=timelinechange]'
	},{
		ref:'startHourValue',
		selector:'eventsmeasuregraphfilters panel combo[action=starthr]'
	},{
		ref:'endHourValue',
		selector:'eventsmeasuregraphfilters panel combo[action=endhr]'
	},{
		ref:'startTimeValue',
		selector:'eventsmeasuregraphfilters panel datefield[action=FromDate]'
	},{
		ref:'endTimeValue',
		selector:'eventsmeasuregraphfilters panel datefield[action=todate]'
	},{
		ref : 'main',
		selector : 'main'
	}],
	moreFiltersWindow: null,
	graphMode:"3D",	
	init: function() {
		me=this;
		this.control({
			'main panel image[action=graphFilters]':{
				click: function(image){
					if(!this.getMeasureGraphFilters()){
						/*var tpl = new Ext.XTemplate('<div style="float:left;margin:4px 0px 0px 4px"><b>Default Settings</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="close"></div></div>');
						me.moreFiltersWindow = new Ext.Container({
							cls:'configMode_popup',
							width: 500,
							padding:5,
							id: 'configMod',
							//html:tpl.apply(),
							items:[
								{
									xtype:'container',
									cls:'configMode_popupArrow',
									style:{'top':'-14px','left':'380px'}
								},
								{
									xtype:'container',
									html:tpl.apply(),
									style:{'top':'0px','margin':'2px'}
								},
								{
									xtype:'panel',
									id: 'more-filter-options-panel',
									parent: me
								}
							],
							renderTo:'historyMain',
							listeners:{
								render:function(){
									if(Ext.get('close')){
									Ext.get('close').on('click',function(){
										 Ext.get('configMod').animate({duration: 500,to: {y: -350}});
										 
									});
								}}
							}
						});
*/



						var win=Ext.create('currentEvents.view.MeasureGraphFilters',{
							width:570,
							height:370
						});
						win.createItems(this.getMain().data);
						win.show();
						win.setPosition(image.x+35-win.getWidth(),image.y+35);
					}
					else if(this.getMeasureGraphFilters().isHidden()){
						var win=this.getMeasureGraphFilters();
						win.show();
						win.setPosition(image.x+20-win.getWidth(),image.y+30);
					}
					else{
						this.getMeasureGraphFilters().hide();
					}
				}				
			},
			'eventsmeasuregraphfilters panel multislider':{
				changecomplete: function(slider, newValue, thumb, eOpts){
					if(thumb.index===0){
						this.getDataRangeMin().setValue(newValue);
					}
					if(thumb.index===1){
						this.getDataRangeMax().setValue(newValue);
					}
				}
			},
			'eventsmeasuregraphfilters toolbar button[action=closewindow]':{
				click: function(){
					this.getMeasureGraphFilters().close();
				}
			},
			'main panel image[action=save]': {
				click: function(){
					var graphUrl = url;
					graphUrl=graphUrl.substring(graphUrl.indexOf("?")+1,graphUrl.length);					
					graphUrl=this.appendToURL(graphUrl);
					if(graphUrl!=-1){
						if(this.getLookupEnabled()!=null && this.getLookupEnabled().getValue()==true)
						{
							window.location.href="/final/servlet/com.egurkha.LookBackTimelineMeasures?saveToFile=true&"+(graphUrl+"&gformat=graph");
						}
						else
						{
							window.location.href="/final/servlet/com.egurkha.TimelineMeasures?saveToFile=true&"+(graphUrl+"&gformat=graph");
						}	
					}									
				}
			},
			'main panel label[action=mode]':{
				click: function(label) {
					this.graphMode=label.text;
					this.submitFilters(true);							
				}				
			},
			'eventsmeasuregraphfilters toolbar button[action=data]':{
				click: function(){
					var graphUrl = url;
					var lback=this.getLookupEnabled().getValue();
					graphUrl=graphUrl.substring(graphUrl.indexOf("?")+1,graphUrl.length);	
					graphUrl=this.appendToURL(graphUrl);
					if(graphUrl!=-1){
						if(lback!=null && lback==true)
						{
							window.openWindow("/final/servlet/com.egurkha.LookBackTimelineMeasures?" + (graphUrl+"&gformat=report"), "TimelineMeasures","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
						}
						else
						{
							window.openWindow("/final/servlet/com.egurkha.TimelineMeasures?" + (graphUrl+"&gformat=report"), "TimelineMeasures","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
						}	
					}
					this.getMeasureGraphFilters().close();
				}
			},
			'main panel image[action=print]':{
				click: function(){	
					GraphUrl = url;
					GraphUrl=GraphUrl.substring(GraphUrl.indexOf("?")+1,GraphUrl.length);
					GraphUrl=this.appendToURL(GraphUrl);
					if(GraphUrl!=-1){
						window.openWindow("EgPrintGraph.jsp?"+ (GraphUrl+"&graph_type=measuregraph"),"PrintGraph","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes");	
					}
					this.getMeasureGraphFilters().close();
				}
			},
			'eventsmeasuregraphfilters panel checkbox[action=lookback]':{
				change: function(){
					var checkedValue=this.getLookupEnabled().getValue();
					if(checkedValue===true){
						this.getIntervalValue().enable();
						this.getTimesValue().enable();
						this.getOtherTimesValue().enable();
					}
					else{
						this.getIntervalValue().disable();
						this.getTimesValue().disable();
						this.getOtherTimesValue().disable();
					}
				},
				render: function(){
					var checkedValue=this.getLookupEnabled().getValue();
					if(checkedValue===true){
						this.getIntervalValue().enable();
						this.getTimesValue().enable();
						this.getOtherTimesValue().enable();
					}
					if(this.getIntervalValue().getValue()==="180"){
						this.getTimesValue().hide();
						this.getOtherTimesValue().show();
					}else{
						this.getTimesValue().show();
						this.getOtherTimesValue().hide();
					}
				}
			},
			'eventsmeasuregraphfilters toolbar button[action=graph]':{
				click: function(){
					this.submitFilters(true);					
				}
			},
			'eventsmeasuregraphfilters panel combo[action=er_interval]':{
				select: function( combo, records, eOpts ){
					if(combo.getValue()=="180"){
						this.getTimesValue().hide();
						this.getOtherTimesValue().show();
					}else{
						this.getTimesValue().show();
						this.getOtherTimesValue().hide();
					}
				}
			}
		});
	},
	submitFilters: function(graphBtnClicked){
		var graphUrl = url;
		graphUrl=this.appendToURL(graphUrl);
		
		if(graphUrl!=-1){
			graphUrl+="&gformat=graph";
			var wholeViewport = document.getElementsByTagName("body")[0];
	    	if(!Ext.isEmpty(Ext.get(wholeViewport))){
				mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
				mask.show(graphUrl);
			}
			Ext.Ajax.request({
				url : graphUrl,
				method : 'POST',
				scope:this,
				success : function(response, opts){				
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					this.getMain().removeAll();
					this.getMain().createGraphUI(jsonData,graphUrl);
					if(graphBtnClicked===true){
						this.getMeasureGraphFilters().close();
					}
					mask.hide();
				},
				failure : function(){alert("failure");}
			});
		}		
	},
	appendToURL: function(url){		
		if(Ext.isEmpty(this.getMeasureGraphFilters())){
			var win=Ext.create('currentEvents.view.MeasureGraphFilters');
			win.createItems(this.getMain().data);
		}
		var measureVal=this.getMeasuresValue().getValue();
		if(measureVal==""){
			Ext.Msg.alert("Error",this.getMain().data.MeasureErrormsg);
			return -1;
		}
		
		var measure="";
		for(var z=0;z<measureVal.length; z++){
			if(z!=measureVal.length-1){
				measure+=measureVal[z]+",";
			}else{
				measure+=measureVal[z];
			}
		}			
		url = url.replace(/(measure=)[^\&]+/, '$1' + measure);
		
		var rangeval=this.getMain().data.HiddenFields.rangeval;
		if(rangeval!=null && (rangeval=='RANGE' || rangeval=='Range'))
		{
			if(!Ext.isEmpty(this.getDataRangeMin()) && !Ext.isEmpty(this.getDataRangeMax()) && this.getLookupEnabled().getValue()!==true){
				var min=this.getDataRangeMin().getValue();
				var max=this.getDataRangeMax().getValue();
				if(parseFloat(min) > parseFloat(max))
				{
					Ext.Msg.alert("Error",this.getMain().data.DataRangeError);
					return -1;
				}
				if(measure!=null && !(measure.indexOf(",")>-1))
				{
					url+="&minrange="+min+"&maxrange="+max;											
				}else{
					url = url.replace(/(showRange=)[^\&]+/, '$1' + "");
				}					
			}
			else if(measure!=null && (measure.indexOf(",")>-1)){
				url = url.replace(/(showRange=)[^\&]+/, '$1' + "");
			}
		}
		
		var starttime=Ext.Date.format(this.getStartTimeValue().getValue(),'m/d/Y');
		var endtime=Ext.Date.format(this.getEndTimeValue().getValue(),'m/d/Y');
		var currTime=Ext.Date.format(new Date(),'m/d/Y');
		if(starttime > currTime || endtime > currTime){
			Ext.Msg.alert("Error",this.getMain().data.CurrentDateError);
			return -1;
		}
		else if(starttime > endtime){			
			Ext.Msg.alert("Error",this.getMain().data.DateErrormsg);
			return -1;
		}
		else if(starttime === endtime){
			if(this.getStartHourValue().getValue() >= this.getEndHourValue().getValue()){
				Ext.Msg.alert("Error",this.getMain().data.DateErrormsg);
				return -1;
			}
		}
		var interval=this.getIntervalValue().getValue();
		if(this.getLookupEnabled().getValue()===true){
			url+='&l_back=true';
			if(interval=="180"){
				url+='&otherTimeline=true';
				otherInterval=this.getOtherTimesValue().getValue();
				var otherTime = otherInterval.substring(0,otherInterval.indexOf(" "));
				otherTimeInterval = otherInterval.substring(otherInterval.indexOf(" ")+1);
				if(otherTimeInterval!=null && otherTimeInterval === 'hrs' && otherTime!=null)
				{
					otherTimeInterval = otherTime * 60;
					url+='&otherTimeInterval=' + otherTimeInterval;
				}
			}
			else{
				url+='&l_times='+this.getTimesValue().getValue();
			}
		}
		else{
			url+='&l_back=false';
		}
		url = url.replace(/(starttime=)[^\&]+/, '$1' + starttime);	
		url = url.replace(/(endtime=)[^\&]+/, '$1' + endtime);
		url = url.replace(/(starthr=)[^\&]+/, '$1' + this.getStartHourValue().getValue());
		url = url.replace(/(endhr=)[^\&]+/, '$1' + this.getEndHourValue().getValue());
		url+='&l_interval='+interval;
		/*
		if(!Ext.isEmpty(this.getDataRangeMin()) && !Ext.isEmpty(this.getDataRangeMax())){
			if(this.getDataRangeMin().getValue()!="" && this.getDataRangeMax().getValue()!="" && this.getLookupEnabled().getValue()!==true){
				if(parseFloat(this.getDataRangeMin().getValue()) > parseFloat(this.getDataRangeMax().getValue())){
					Ext.Msg.alert("Error",this.getMeasureGraph().data.DataRangeError);
					return -1;
				}
				url+='&minrange='+this.getDataRangeMin().getValue()+'&maxrange='+this.getDataRangeMax().getValue();			
			}
		}	*/		
		
		url = url.replace(/(gtype=)[^\&]+/, '$1' + this.getMain().data.HiddenFields.gtype);		
		url = url.replace(/(mode=)[^\&]+/, '$1' + this.graphMode);
		return url;
	}
});