Ext.define('currentEvents.view.DetailedDiagnosisGrid',{
	extend : 'utilities.CustomGrid',
	alias : 'widget.diagnosisgrid',
	//forceFit:true,
	layout:'fit',
	flex:1,
	jsonData:null,
	itemId : 'diagnosisgrid',
	
	initComponent : function() {
    	var jsonData=this.jsonData;
    	if(!Ext.isEmpty(jsonData.gridInfo)){
    	var title = jsonData.gridInfo.gridHeader;
    	this.title=title;
    	var storeFields = [];
		var columns=new Array();
		for(var i=0; i< jsonData.gridInfo.headers.length; i++){
			var recMeasureCol=jsonData.gridInfo.headers[i];
			var measureCol=new Object();
				measureCol.text=recMeasureCol.text;
				if(i==0){
					measureCol.dataIndex="time";
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						var time;
						if(!Ext.isEmpty(record.get('time'))){
							 time = record.get('time');
							 return time;
						}
					};
				}else{
					measureCol.dataIndex= (i-1)+"col";
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						if(!Ext.isEmpty(record.get((colIndex-1)+'col'))){
							return record.get((colIndex-1)+'col');
						}
					};
				}
			
				storeFields.push(measureCol.dataIndex);
				columns.push(measureCol);
		}
		var groupField = "";
		if(!Ext.isEmpty(jsonData.gridInfo.grouping) && jsonData.gridInfo.grouping==true){
			groupField = "time";
		}
			var gridStore = Ext.create('Ext.data.Store',{
				fields : storeFields,
	            groupField :groupField,
			    proxy: {
			        type: 'memory',
			        reader: {
			            type: 'json',
			            root:'gridInfo.data'
			        }
			    },
			    data:jsonData
			});
            this.store = gridStore;
            this.features =[{ftype:'grouping',collapsible:false}];
            
			this.columns=columns;
			this.callParent();
    		}
    	}
});