Ext.define('currentEvents.view.Main', {
	extend: 'Ext.panel.Panel',
	//extend : 'utilities.OuterPanel',
	requires : [],
	alias:'widget.main',
	store: 'currentEvents.store.Measures',
	requires : ['currentEvents.view.MeasureGraphFilters','currentEvents.view.DetailedDiagnosisGrid', 'utilities.ScrollCombo', 'utilities.OuterPanel','utilities.CommonPanel','Ext.ux.form.MultiSelect'],
	url:null,
	items : [],
	data:null,
	mask:null,
	graphInfoStore:null,
	timelineData:null,
	//cls:'measure-graph-panel',
	layout : 'fit',
	
	initComponent : function() {
		this.callParent();
	},
	createGraphUI : function(jsonData,graphUrl){
		var me=this;
		me.data=jsonData;		
		var chartOption = jsonData.chartOption;
		chartOption = (graphUrl =="" || graphUrl == undefined)?chartOption:this.chartType(jsonData,graphUrl);
		var isHighChart = (chartOption.indexOf("highchart") > -1)?true:false;
		var labelText,timelineObj,timelineVal;
		for(var i=0; i< jsonData.FormFields.length; i++){
			if(jsonData.FormFields[i].name=="mode"){		
				if(isHighChart)
				{
					labelText="";
				}
				else
				{
				if(jsonData.FormFields[i].selectvalue=="2D"){
					labelText="3D";
				}else{
					labelText="2D";
					}
				}
			}			
		}
		if (isglobalsearchType == 'graph')
		{
			var graphPanel= Ext.create('utilities.CommonPanel',{
			height:'100%',
			width:'100%',
			layout: {type:'vbox'},
			border:false,
			margin:0,
			frame:false,
			id:'historyMain'
			});
		}
		else
		{
			var graphPanel= Ext.create('utilities.OuterPanel',{
				height:'100%',
				width:'100%',
				layout: {type:'vbox'},
				border:false,
				id:'historyMain',
				//cls:'graph-panel',
				title:'Measure Graph',
				//dockedItems:[{
				//	xtype:'toolbar',
					tools:[{
						xtype:'label',
						text: labelText,
						cls:'mode-field',
						action:'mode',
						listeners : {
							render : function(c) {
								c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							}
						}
					},{
						xtype:'tbseparator'
					},{
						xtype:'image',
						cls:'iconSave',
						action:'save',
						//tooltip: 'SAVE',
						hidden:isHighChart,
						listeners : {
						afterrender: function () {
                        Ext.create('Ext.tip.ToolTip', {
                            target: this.id,
                            anchor: 'top',
                            cls: 'yellowTip',
                            trackMouse: true,
                            html: 'save'
                        });
                    },
							render : function(c) {
								c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							}
						}
					},{
						xtype:'tbseparator',
						hidden:isHighChart
					},{
						xtype:'image',
						cls:'iconPrinter',
						action:'print',
						//tooltip: 'PRINT',
						hidden:isHighChart,
						listeners : {
						 afterrender: function () {
                        Ext.create('Ext.tip.ToolTip', {
                            target: this.id,
                            anchor: 'top',
                            cls: 'yellowTip',
                            trackMouse: true,
                            html: 'print'
                        });
                    },
							render : function(c) {
								c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							}
						}
					},{
						xtype:'tbseparator',
						hidden:isHighChart
					},{
						xtype:'image',
						cls:'iconSettings',
						action:'graphFilters',						
						//tooltip:'SETTINGS',
						
						listeners : {
						 afterrender: function () {
                        Ext.create('Ext.tip.ToolTip', {
                            target: this.id,
                            anchor: 'top',
                            cls: 'yellowTip',
                            trackMouse: true,
                            html: 'Settings'
                        });
                    },
							render : function(c) {
								c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							}
						}
					}]
			});
		}
		if(!Ext.isEmpty(jsonData.error)){
			var noMeasure = Ext.create('ErrorPanel',{
				errorMsg : '<div style="text-align:center;"><img src="/final/images/clear.png" class="list-empty" /><br/><div class="list-empty-text">'+jsonData.error+'</div></div>'
			});
			graphPanel.add({
				xtype:'panel',
				border:false,
				layout:'fit',
				flex:1,
				width:'100%',
				items: noMeasure
			});			
		}		
		else{			
			if(!Ext.isEmpty(jsonData.MultipleGraphsUrl)){
				for(var j=0 ; j < jsonData.MultipleGraphsUrl.length; j++){
					if(chartOption !=null && chartOption.indexOf("highchart") > -1)
					{
						var isAxisTimeReq = true;
						var legendPos = "right";
						var url = jsonData.MultipleGraphsUrl[j].Graphs;
						var imgdiv = '<div id="eventHighChart"'+j+'" style="border 1px solid red;"></div>';
						var panelID = "eventHighChart"+j;
						graphPanel.add({
							xtype : 'container',
							minHeight:400,
							padding: '0 0 0 10',
							width:'100%',
							id: panelID,
							html : imgdiv

							/*xtype:'image',
							padding: '0 0 0 30', 
							height:320,
							src: jsonData.MultipleGraphsUrl[j].Graphs*/
						});
						loadEventHSChart(url,panelID,400,900,'',isAxisTimeReq,legendPos);
					}
					else
					{
						graphPanel.add({
						xtype:'image',
						padding: '0 0 0 30',
						style:{'border':'2px solid blue'},
						height:320,
						src: jsonData.MultipleGraphsUrl[j].Graphs
					});
					}
					if(!Ext.isEmpty(jsonData.GridData.MultipleMeasureGridData[j].MeasureGridData)){
						me.graphInfoStore=Ext.create('currentEvents.store.Measures',{
							data:jsonData.GridData.MultipleMeasureGridData[j].MeasureGridData
						});

						var graph={
								xtype:'grid',
								header:false,
								autoHeight:true,
								scroll:false,
								autoScroll:false,
								width:'100%',
								cls:'gridSkin',
								margin:30,
								store: me.graphInfoStore,
								columns:[{
									header:jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureLabel,
									dataIndex:'MeasuresDisplay',
									flex : 1
								},{
									header:jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureAvgLabel,
									dataIndex:'MeasureAvgDisplay',
									flex : 1
								},{
									header:jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureMaxLabel,
									dataIndex:'MeasureMaxDisplay',
									flex : 1
								},{
									header:jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureMinLabel,
									dataIndex:'MeasureMinDisplay',
									flex : 1
								}]
						};
						graphPanel.add(graph);
					}
				}
				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}
			}
			else{				
				if(chartOption !=null && chartOption.indexOf("highchart") > -1)
				{
					var isAxisTimeReq = true;
					var legendPos = "right";
					var imgdiv = '<div id="eventHighChartDiv" width="100%" style="border 1px solid red;"></div>';
					graphPanel.add({
						xtype : 'container',
						minHeight:400,
						padding: '0 0 0 10',
						width:'100%',
						id: 'eventHighChartDiv',
						html : imgdiv

					});
					var divId ="eventHighChartDiv";
					var url = jsonData.GraphUrl;
					loadEventHSChart(url,'eventHighChartDiv',400,900,'',isAxisTimeReq,legendPos);
						if(!Ext.isEmpty(jsonData.GridData.MeasureGridData)){
						me.graphInfoStore=Ext.create('currentEvents.store.Measures',{
							data:jsonData.GridData.MeasureGridData
						});

						var graph={
								xtype:'grid',
								header:false,
								autoHeight:true,
								scroll:false,
								autoScroll:false,
								width:'100%',
								cls:'gridSkin',
								margin:30,
								store: me.graphInfoStore,
								columns:[{
									header:jsonData.GridData.MeasureGridColumns.MeasureLabel,
									dataIndex:'MeasuresDisplay',
									flex : 1,
									renderer:function(value,metaData,record,rowIndex){
										if(!Ext.isEmpty(jsonData.GridData.MeasureGridData[rowIndex].MeasuresDisplayUnit)){
											var returnValue =value + " " + jsonData.GridData.MeasureGridData[rowIndex].MeasuresDisplayUnit;
											return returnValue;
										}
										else{
											return value;
										}
									}
								},{
									header:jsonData.GridData.MeasureGridColumns.MeasureAvgLabel,
									dataIndex:'MeasureAvgDisplay',
									flex : 1
								},{
									header:jsonData.GridData.MeasureGridColumns.MeasureMaxLabel,
									dataIndex:'MeasureMaxDisplay',
									flex : 1
								},{
									header:jsonData.GridData.MeasureGridColumns.MeasureMinLabel,
									dataIndex:'MeasureMinDisplay',
									flex : 1
								}]
						};
						graphPanel.add(graph);
					}
					if(!Ext.isEmpty(me.mask)){
						me.mask.hide();
					}
				}
				else
				{
				graphPanel.add({
					xtype:'image',
					style:{'border':'2px solid red'},
					padding: '20 0 0 30',
					autoHeight:true,
					src: jsonData.GraphUrl,
					listeners:{						
						afterrender: function(img){
							img.el.on({
								load: function (evt, ele, opts) {
									if(!Ext.isEmpty(jsonData.GridData.MeasureGridData)){
										me.graphInfoStore=Ext.create('currentEvents.store.Measures',{
											data:jsonData.GridData.MeasureGridData
										});

										var graph={
												xtype:'grid',
												header:false,
												autoHeight:true,
												scroll:false,
												autoScroll:false,
												flex:1,
												width:'100%',
												cls:'gridSkin',
												margin:30,
												store: me.graphInfoStore,
												columns:[{
													header:jsonData.GridData.MeasureGridColumns.MeasureLabel,
													dataIndex:'MeasuresDisplay',
													flex : 1,
													renderer:function(value,metaData,record,rowIndex){
														if(!Ext.isEmpty(jsonData.GridData.MeasureGridData[rowIndex].MeasuresDisplayUnit)){
															var returnValue =value + " " + jsonData.GridData.MeasureGridData[rowIndex].MeasuresDisplayUnit;
															return returnValue;
														}
														else{
															return value;
														}
													}
												},{
													header:jsonData.GridData.MeasureGridColumns.MeasureAvgLabel,
													dataIndex:'MeasureAvgDisplay',
													flex : 1
												},{
													header:jsonData.GridData.MeasureGridColumns.MeasureMaxLabel,
													dataIndex:'MeasureMaxDisplay',
													flex : 1
												},{
													header:jsonData.GridData.MeasureGridColumns.MeasureMinLabel,
													dataIndex:'MeasureMinDisplay',
													flex : 1
												}]
										};
										graphPanel.add(graph);
									}
									if(!Ext.isEmpty(me.mask)){
										me.mask.hide();
									}
								}
							});
						}
					}
				});
			}			
		}
		}
		me.add(graphPanel);
	},
	createDiagnosisUI : function(jsonData){
		this.jsonData = jsonData;
		this.removeAll();
		var me=this;
		var items=[];
		var upperPanel = "";
		var gridPanel = "";
		var errorPanel = "";
		var toolbar = "";
		upperPanel = this.createDiagnosisUpperPanel(jsonData);
		var toolbardd = this.createToolbarItems(jsonData);
		items.push(upperPanel);
		if(!Ext.isEmpty(jsonData.errorMsg) && Ext.isEmpty(jsonData.gridInfo)){
			errorPanel = this.createErrorPanel(jsonData);
			items.push(errorPanel);
		}else{
			gridPanel = this.createGridPanel(jsonData);
			items.push(gridPanel);
		}
		if (isglobalsearchType =='dd')
		{
			var diagnosisPanel = {
				xtype : 'commonPanel',
				margin:0,
				frame:false,
				layout : {
					type : 'vbox',
					align : 'stretch'
				},
				items : items
			}
		}
		else
		{
			var diagnosisPanel = {
				xtype : 'outerPanel',
				margin:0,
				title:'Diagnosis',
				layout : {
					type : 'vbox',
					align : 'stretch'
				},
				tools:[toolbardd],
				items : items
			}
		}
		this.add(diagnosisPanel);
		this.doLayout();
	},
	createToolbarItems : function(jsonData){
		var showSave = false;
		if(!Ext.isEmpty(jsonData.errorMsg) && Ext.isEmpty(jsonData.gridInfo)){
			showSave =true;
		}
		var toolbardd = '';
		var chartOption = jsonData.chartOption;
		if(chartOption != "" && chartOption != undefined)
		{
			if(chartOption.indexOf("highchart") > -1)
			{
				toolbardd = {
						xtype : 'toolbar',
						docked : 'bottom',
						ui:'footer',
						items : ['->',{
								xtype:'button',
								cls:'iconPerformanceAnalysis', // diagnosis-toolbar-button',
								action:'analysis',
								margin:'0px 1px 0px 3px',
								tooltip: jsonData.hiddenFields.analysis,
								hidden : showSave,
								style:{'background-color':'transparent','border':'0px'}
						},{
        xtype: 'tbseparator'
    },{
							xtype:'button',
							cls:'iconCsv',// diagnosis-toolbar-button',
							action:'csv',
							margin:'0px 1px 0px 3px',
							tooltip: jsonData.hiddenFields.csv,
							style:{'background-color':'transparent','border':'0px'}
						}]
				}
			}
		}
		else
		{
			toolbardd = {
					xtype : 'toolbar',
					docked : 'bottom',
					ui:'footer',
					items : ['->',
					{
						xtype:'button',
						cls:'iconPerformanceAnalysis',// diagnosis-toolbar-button',
						action:'analysis',
						margin:'0px 1px 0px 3px',
						tooltip: jsonData.hiddenFields.analysis,
						hidden : showSave,
						style:{'background-color':'transparent','border':'0px'}
					},{
        xtype: 'tbseparator'
    },{
						xtype:'button',
						cls:'iconPdf',// diagnosis-toolbar-button',
						action:'save',
						margin:'0px 1px 0px 3px',
						tooltip:  jsonData.hiddenFields.pdf,
						style:{'background-color':'transparent','border':'0px'}
					},{
        xtype: 'tbseparator'
    },{
						xtype:'button',
						cls:'iconCsv', // diagnosis-toolbar-button',
						action:'csv',
						margin:'0px 1px 0px 3px',
						tooltip: jsonData.hiddenFields.csv,
						style:{'background-color':'transparent','border':'0px'}
					},{
						xtype: 'tbseparator'
					},{
						xtype:'button',
						cls:'iconPrinter', // diagnosis-toolbar-button',
						action:'print',
						margin:'0px 1px 0px 3px',
						tooltip: jsonData.hiddenFields.print,
						style:{'background-color':'transparent','border':'0px'}
					}]
			}
		}
		return toolbardd;
	},
	createDiagnosisUpperPanel : function(jsonData){
		//var toolbardd = this.createToolbarItems(jsonData);
		var itemsArray = this.createFilters(jsonData);
		var upperPanel ={
				xtype : 'panel',
				layout:'column',
				margin : 5,
				items : itemsArray,
				//dockedItems :[toolbardd]
	}
		return upperPanel;
	},
	createGridPanel : function(jsonData){
		var tableViewPnl =null;
		if(isComesFromMyDashboard)
		{
			tableViewPnl = {
				xtype:'panel',
				//cls:'panelwithoutheader',
				//extend:'ScrollPanel',
				cls:'datapanel borderDD',			
				//title:'Lists the hop-by-hop connectivity and delay',
				title:jsonData.hiddenFields.title,
				scroll:true,
				autoScroll:false,
				margin:'0 10 10 10',
				frame:true,
				border:true,
				bodyPadding:0,
				padding:0,
				flex:0.9,
				layout:{
					type:'anchor',
					align:'stretch'
				},
				id:'tablePanel',
				listeners:{
					resize:{
						fn:function(width,height)
						{
							var me=this;
							var width = Ext.getBody().getViewSize().width - 160;
							var height = Ext.getBody().getViewSize().height - 250;
							//alert(width+"----"+height);
							me.setSize(width, height);
						}
					}
				},
				html:jsonData.tableData
			};
		}
		else
		{
			tableViewPnl = {
				xtype : 'diagnosisgrid',
				jsonData : jsonData,
				forceFit:true,
				margin:10,
				flex:1,
				//bodyCls:'bottom-left-radius bottom-right-radius',
				cls : 'gridSkin'
			};
		
		}
		return tableViewPnl;
	},
	createErrorPanel : function(jsonData){
	    	var errorPanel = {
					xtype : 'errorpanel',
					//cls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					//bodyCls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					height : '50%',
					width : '100%',
					border : true,
					cls:'block1',
					frame:true,
					autoScroll:true,
					margin : 5,
					errorMsg:'<table width="100%" height="300px"><tr><td align="center" valign="middle"><div class="iconInformation"></div>'+ jsonData.errorMsg+'</td></tr></table>',
					//errorMsg : '<img src="' + jsonData.errorImage + '"/><br/><b>' + jsonData.errorMsg + '</b>',
					flex : 1
	    					
	    	}
	    	return errorPanel;
	},
	createFilters:function(jsonData){
		var itemsArray=new Array();
		var cnt=0;
		var currentRow=0;
		for(var i=0;i<jsonData.filters.length;i++){
			var filter=jsonData.filters[i];
			if(filter.type=='nextLine'){
				if(cnt!=0){
					var columnWidth=1/cnt;
					//to calculate column widths
					for(var j=0;j<cnt;j++){
						if(Ext.isEmpty(itemsArray[currentRow+j].width)){
							itemsArray[currentRow+j].columnWidth=columnWidth;
						}
					}
					currentRow=currentRow+cnt;
					cnt=0;
				}
			}else{
				var item=this.createFilterItem(filter);
				if(!Ext.isEmpty(item)){
					itemsArray.push(item);
					cnt++;
				}
			}
		}
		return itemsArray;
	},
	
	createFilterItem:function(filter){
		var item=null;
		if(Ext.isEmpty(filter.type)){
			filter.type="label"
		}
		if(filter.id=="timeline"){
			this.timeLine = filter.selectedValue;
		}
		switch(filter.type){
			case "label":   item={
								xtype:'displayfield',
								value:filter.value,
								fieldLabel:filter.name,
								labelSeparator:'',
								margin:5,
								width:200,
								labelAlign:'top',
								cls : 'display-field'
							};
							break;
			case "combo": 	item=this.createCombo(filter);
							break;
			case "date": item={
								xtype:'datefield',
								cls : 'datepicker',// detailed-diagnosis-datefield',
								labelSeparator:'',
								margin:5,
								labelAlign:'top',
								fieldLabel:filter.name,
								format:mgr_dateFormat,
								value:filter.selectedValue,
								itemId:filter.id,
								//columnWidth:0.1,
								//minWidth:135,
								//maxWidth:135,
								width:120,
								labelWidth:30,
								editable : false
							};
							if(filter.id=="todate"){
								item.labelWidth=15;
							}
							if(filter.id=="fromdate"){
								item.width=120;
								//item.minWidth=120;
							//	item.maxWidth=120;
							}
							if(this.timeLine!="Any"){
								item.disabled = true;
							}
							break;
			case "button":
						 item={
							xtype:'button',
							text:filter.text,
							action : 'submit',
							cls : 'button20',
							margin :'25 5 5 5'
						 };
				break;
		}
		return item;
	},
	
	createCombo:function(filter){
		var isVisible = false;
		var comboStore = Ext.create('Ext.data.Store',{
			fields:['value','name'],
			proxy:{
				type: 'memory',
				reader: {
	            	type: 'json',
	            	root:'options'
	        	}
			},
			data:filter
		});
			
			try
			{
				if(filter.isHidden != undefined && filter.isHidden != null && (filter.isHidden == 'true' || filter.isHidden == true))
					isVisible = true;
				if(filter.hidden != undefined && filter.hidden != null && (filter.hidden == 'true' || filter.hidden == true))
					isVisible = true;
			}
			catch (e)
			{
				isVisible=false;
			}

			var item={
					xtype:'scrollcombo',
					editable : false,
					store:comboStore,
					cls : 'dropdown',// detailed-diagnosis-combo',
					displayField:'name',
					labelSeparator:'',
					margin:5,
					labelAlign:'top',
					valueField:'value',
					trigerAction:'all',
					fieldLabel:filter.name,
					value:filter.selectedValue,
					itemId:filter.id,
					hidden:isVisible
			};
			
			switch(filter.id){
			case "measurelist":
			case "infolist":    //item.margin='0 30 0 0';
								//item.minWidth=330;
								item.width=200;
								//item.maxWidth=330;
								item.cls='dropdown';// detailed-diagnosis-combo-measures';
								//item.columnWidth = 1;
				break;
			case "timeline":  //item.columnWidth=0.2;
							  item.width=100;
				break;
			case "fromHr":
			case "toHr":
							  //  item.columnWidth=0.1;
				                item.labelWidth=15;
								item.width=60;
				               // item.minWidth=78;
								//item.maxWidth=78;
								if(this.timeLine !="Any"){
									item.disabled = true;
								}
				break;
			case "fromMin":
			case "toMin":
				 			//item.columnWidth=0.1;
				 			item.labelWidth=25;
							item.width=60;
				 			//item.minWidth=78;
							//item.maxWidth=78;
							if(this.timeLine !="Any"){
								item.disabled = true;
							}
				break;
			}
			return item;
	},
	queryString:function (url) {
		var times = new Array();
		if(url != "" && url != undefined)
		{
			var stTime ="starttime";
			var endTime ="endtime";
			var stHr ="starthr";
			var endHr ="endhr";
			var ft;
			var query_string = url.split("?");
			var params = query_string[1].split("&");
			for (i = 0; i < params.length; i++) {
				ft = params[i].split("=");
				if (ft[0] == stTime || ft[0] == endTime || ft[0] == stHr || ft[0] == endHr) {
					times[i] =ft[0]+"="+ft[1];
					
				}
				

			}
		}
		return times;
	},
	chartType:function(jsonData,graphUrl)
	{
		var times = this.queryString(graphUrl);
		
		var HIGH_CHART = "highcharts";
		var EASY_CHART = "easychart";
		var chartTimeline = jsonData.chartTimeline;
		var iniChartOption = jsonData.iniChartOption;
		var stDateObj = '';
		var endDateObj = '';
		var stHr = '';
		var endHr = '';
		for(var i=0;i<times.length;i++)
		{
			var tmpValue = times[i];
			if(tmpValue == '' || tmpValue ==undefined) 
				continue;
			if(tmpValue.indexOf("starttime") > -1)
				stDateObj = tmpValue.substring(tmpValue.indexOf("=")+1);
			if(tmpValue.indexOf("endtime") > -1)
				endDateObj = tmpValue.substring(tmpValue.indexOf("=")+1);
			if(tmpValue.indexOf("starthr") > -1)
				stHr = tmpValue.substring(tmpValue.indexOf("=")+1);
			if(tmpValue.indexOf("endhr") > -1)
				endHr = tmpValue.substring(tmpValue.indexOf("=")+1);
			
		}
		var opcArray = new Array();
		var chartOpt = iniChartOption;
		
		if(iniChartOption != null || iniChartOption != "" )
		{
			chartTimeline = (chartTimeline != null && chartTimeline != "")?chartTimeline:"1 hour";
			var ctline = chartTimeline;
			ctline = ctline.substring(ctline.indexOf(" "));
			ctline = ctline.trim();
			if(ctline != null && ctline == "")
			{
				ctline = ((ctline.indexOf("ho") > -1)?"hours":((ctline.indexOf("day") > -1)?"days":(ctline.indexOf("we") > -1)?"weeks":"months"));
			}
			var strtdt = Ext.Date.dateFormat(stDateObj, 'm/d/Y');
			var enddt = Ext.Date.dateFormat(endDateObj,'m/d/Y');

			strtdt = (strtdt == "")?stDateObj:strtdt;
			enddt = (enddt == "")?endDateObj:enddt;
			stHr = (stHr.length == 1)?"0"+stHr:stHr;
			endHr = (endHr.length == 1)?"0"+endHr:endHr;
			
			var tmp_s_start_time = strtdt+" "+stHr+":00:00";
			var tmp_s_end_time = enddt+" "+endHr+":00:00";
			var ctline = chartTimeline.substring(chartTimeline.indexOf(" ")+1);
			

			var durVal  = chartTimeline.substring(0,chartTimeline.indexOf(" "));
			var durUnit = chartTimeline.substring(chartTimeline.indexOf(" ")+1);
			var tline = getDateInfoDifference(tmp_s_start_time,tmp_s_end_time,ctline);
			var duraVal = parseInt(durVal);
			var durationVal = parseInt(tline);
			chartOpt = (durationVal <= duraVal)?"highcharts":"graph";
		}
		
		opcArray = new Array();
	

		return chartOpt;
	}
	

});
