Ext.define('currentEvents.view.MeasureGraphFilters', {
	extend: 'Ext.window.Window',
	alias:'widget.eventsmeasuregraphfilters',
	header:true,
	resizable: false,
	//closeAction:'hide',
	closable:true,
	title:'Settings',
	layout:{
		type: 'vbox',
		align: 'stretch'
	},
	jsonData:null,
	//cls:'measure-graph-panel',
	initComponent : function(){
		this.callParent();
	},
	createItems : function(jsonData){
		if(!Ext.isEmpty(jsonData.FormFields) && jsonData.FormFields.length>0){
			var filterPanelLeft = this.createPanelLeft(jsonData);		

			var rightTopPanel = this.createPanelRightTop(jsonData);
			var rightMiddlePanel = this.createPanelRightMiddle(jsonData);
			var rightBottomPanel = this.createPanelRightBottom(jsonData);
/*
			var filterPanelRight = ('ScrollPanel',{
				flex:1,
				//bodyCls:'top-right-radius',
				cls:'filter-top-right-panel',
				autoScroll:true,
				height:'100%',
				layout:{
					type: 'vbox',
					align: 'stretch'
				},
				items:[rightTopPanel,rightMiddlePanel,rightBottomPanel]
			});
			*/
			var seperation=('Ext.resizer.Splitter',{
					height: 2,
					margin: '2px 0px 0px 0px',
					draggable: false,
					style: {
						'cursor': 'default'
					}
			});
			var topPanel = ('Ext.panel.Panel',{
				layout:'vbox',
				header:false,
				border:false,
				items:[filterPanelLeft,seperation,rightTopPanel,seperation,rightMiddlePanel,seperation,rightBottomPanel]
			});

			//var buttonPanel = this.createButtonPanel(jsonData);
			var buttonArray = this.createButtonPanel(jsonData);
			
			this.addDocked({
				xtype: 'toolbar',
				dock: 'bottom',
				margin:0,
				height:30,
				// baseCls:'graph-toolbar',
				items: buttonArray
			});
			this.add(topPanel);
			this.doLayout();
		}
	},

	createPanelLeft : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.name=="measurelist" || filterData.name=="infolist" ||  filterData.type=="label"){
				switch(filterData.type){
				case "combo": 
					filterComp=this.createCombo(filterData);
					break;
				case "label": 
					filterComp=this.createLabel(filterData);
					break;
				}
			}
			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}

		var leftPanel = {
				xtype : 'panel',
				layout:'hbox',
				items  : filterArray
		}	
		return leftPanel;
	},

	createPanelRightTop : function(jsonData) {	
		var rightTopPanel = Ext.create('Ext.panel.Panel',{
			xtype : 'panel',
			layout:'hbox',
			border:false
		});
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.type=="slider"){
				filterComp={
						xtype:'slider',
						margin:'5 5 5 10',
						width:200,
						values: [filterData.minvalue ? filterData.minvalue : 0,filterData.maxvalue ? filterData.maxvalue : 10000],
						increment: 200,
						minValue: 0,
						labelSeparator:'',
						maxValue: 10000,
						constrainThumbs: false,					
						fieldLabel: filterData.Label,
						labelAlign:'top',
						animation: true,
						tipText: function (t) {
							return Ext.String.format('{0}', t.value)
						},
						action:'datarangeSlider'
				};	
				rightTopPanel.add(filterComp);
				rightTopPanel.add({
					xtype: 'textfield',
					margin:'25 5 5 10',
					minWidth:50,
					maxWidth:100,
					cls: 'textbox',
					action:'datarangeMin',
					readOnly:true,
					value:filterData.minvalue ? filterData.minvalue : ""
				},{
					xtype: 'textfield',
					margin:'25 5 5 10',
					minWidth:50,
					maxWidth:100,
					cls: 'textbox',
					action:'datarangeMax',
					readOnly:true,
					value:filterData.maxvalue ? filterData.maxvalue : ""
				});
			}
		}			
		return rightTopPanel;
	},

	createPanelRightMiddle : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.name=="starthr" || filterData.name=="endhr" || filterData.name=="FromDate" || filterData.name=="todate"){
				switch(filterData.type){
				case "combo": 
					filterComp=this.createCombo(filterData);
					break;
				case "date": 
					filterComp=this.createDateField(filterData);
					break;					
				}
			}

			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}		

		var rightMiddlePanel = {
				xtype : 'panel',
				layout:'hbox',
				flex:1,
				border:false,
				items  : filterArray
		}	
		return rightMiddlePanel;
	},

	createPanelRightBottom : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.name=="er_interval" || filterData.name=="er_integrate" || filterData.name=="er_otherTime" || filterData.name=="er_history" ){
				switch(filterData.type){
				case "combo":
					filterComp=this.createCombo(filterData);
					break;
				case "checkbox": 
					filterComp=this.createCheckbox(filterData);
					break;					
				}
			}

			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}

		var rightBottomPanel = {
				xtype : 'panel',
				layout:'hbox',
				width:500,
				height:100,
				border:false,
				items  : filterArray
		}	
		return rightBottomPanel;
	},
	createButtonPanel : function(jsonData) {	
		var filterArray=new Array();
		filterArray.push('->');
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.type=="button"){					
				filterComp=this.createButton(filterData);					
			}
			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}
		
		return filterArray;
	},

	createCombo:function(comboData){
		if(comboData.name!="timeline" && comboData.name!="mode"){
			var comboStore = Ext.create('Ext.data.Store',{
				fields:['name','value'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'items'
					}
				},
				data:comboData
			});

			var compCombo={
					xtype:'scrollcombo',
					editable : false,
					store:comboStore,				
					cls : 'dropdown',
					labelSeparator : '',
					labelAlign : 'top',
					displayField:'name',
					valueField:'value',
					margin:'5 5 5 10',
					labelWidth:80,
					fieldLabel:comboData.Label,
					value:comboData.selectvalue ? comboData.selectvalue : comboData.items[0].value,
					itemId:comboData.name,
					action:comboData.name
			};
			if(!Ext.isEmpty(comboData.name))
			{
				if(comboData.name=='measurelist')
				{
					compCombo={
						xtype:"multiselectfield",
						fieldLabel:comboData.Label,
						allowBlank:false,
						labelAlign:"top",
						labelSeparator:'',
						labelStyle:'position:absolute;top:-5px',
						margin:'5 10 0 10',
						autoScroll:false,
						scroll:false,
						width:230,
						height:103,
						store:comboStore,
						value:comboData.selectvalue ? comboData.selectvalue : comboData.items[0].value,
						displayField:"name",
						valueField:"value",
						listConfig: {simpleSelect: true},
						//queryMode:"local",
						itemId:comboData.name,
						action:comboData.name
					};
				}
			}
			if(comboData.name=="starthr" || comboData.name=="endhr"){
				compCombo.labelWidth=20;
				compCombo.width=75;
				compCombo.defaultListConfig={
						minWidth: 55,
						margin:'5 5 5 10',
						labelSeparator :'',
						labelAlign : 'top',
						loadingHeight: 55
				};
			}
			if(comboData.name=="er_interval" || comboData.name=="er_integrate"){
				compCombo.disabled=true;
				compCombo.width=140;
			}
			if(comboData.name=="er_otherTime"){
				compCombo.width=95;
				compCombo.disabled=true;
				compCombo.hidden=true;
			}
			if(comboData.name=="measurelist"){
				compCombo.multiSelect=true;
				if(comboData.selectvalue.indexOf(",")>-1){
					var values=comboData.selectvalue.split(',');
					compCombo.value=values;
				}								
			}
			return compCombo;	
		}		
	},
	createDateField:function(fieldData){
		var dateField={
				xtype:'datefield',
				cls : 'datepicker',
				fieldLabel:fieldData.Label,
				format:mgr_dateFormat,
				value:(fieldData.selectedValue),
				labelWidth:50,
				labelSeparator : '',
				labelAlign : 'top',
				editable:false,
				margin:'5 5 5 10',
				width:210,
				itemId:fieldData.name,
				action:fieldData.name
		}	

		if(fieldData.name=="FromDate"){
			dateField.labelWidth=35;
			dateField.width=110;
		}else if(fieldData.name=="todate"){
			dateField.labelWidth=20;
			dateField.width=110
		}
		
		return dateField;
	},

	createLabel:function(labelData){
		var label={
				xtype:'label',
				html:'<b>'+labelData.Label+"</b> <br/><br/>"+labelData.value,
				cls:'lookup-field',
				margin:'0 5 5 10',
		}		
		return label;
	},

	createButton:function(buttonData){
		var button={
				xtype:'button',
				text: buttonData.text,
				name: buttonData.name,
				cls : 'button20',
				action: buttonData.name
		}	
		
		return button;
	},

	createCheckbox:function(boxData){
		var checkbox={
				xtype:'checkbox',
				margin:'20 5 5 10',
				cls:'lookup-field checkbt',
				boxLabel  : boxData.Label,
				boxLabelAlign:'before',
				action:'lookback',
				checked:boxData.checked
		}		
		return checkbox;
	}

});