Ext.Loader.setConfig		({
	enabled: true,
	disableCaching: false,
	paths: {
        "Ext.ux": "/final/scripts/ux",
		"utilities": "/final/scripts/utilities"
    }
});
Ext.define('DashboardGeneralMeasuresGrid', {
	extend: 'utilities.CustomGrid',
	alias:'widget.dashboardgeneralmeasuresgrid',
	border:false,
	scroll:true,
	bodyCls:'general-dashboard-grid',
	plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
	emptyText: 'No data to Display',
	afterRender:function(grid){
		this.callParent();
		//handled the logic if dynamic columns are less that the total width
		var totalWidth=this.getWidth();
		var totalColumnsWidth=0;
		for(var col=0;col<this.columns.length;col++){
			//var colWidth=this.columns[col].getWidth();
			//totalColumnsWidth+=colWidth;
			var colNameObj=this.columns[col];
			var colWidth=0;
			try
			{
				if(colNameObj!=null && colNameObj!=undefined)
				{
					colWidth = this.columns[col].getWidth();
				}
			}
			catch (e)
			{
				colWidth=0;
			}
			
			totalColumnsWidth+=colWidth;
		}

		if(totalColumnsWidth<totalWidth){
			for(var col=0;col<this.columns.length;col++){
				this.columns[col].flex=1;

			}
			this.doLayout();
		}
	}
});
