Ext.define('eGBTMBase.controller.Main',{
	extend:'Ext.app.Controller',
	views:['OverView','SummaryView','HotSpotView','SqlCallsView','ErrorDetailsView','SQLQuerywindow','ExternalDetailsView','SapDetailsWindow','HttpDetailsWindow','WebserviceDetailsWindow','JmsDetailsWindow','ErrorDetailsWindow','OtherPointCutWindow','EjbDetailsWindow','NoSQLDetailWindow'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'summaryview', ref:'summaryview'},
		{selector:'hotspotview', ref:'hotspotview'},
		{selector:'sqlcallsview', ref:'sqlcallsview'},
		{selector:'errordetailsview', ref:'errordetailsview'},
		{selector:'externaldetailsview', ref:'externaldetailsview'}
	],
	requires : ['eGBTMBase.view.SQLQuerywindow','eGBTMBase.view.SapDetailsWindow','eGBTMBase.view.HttpDetailsWindow','eGBTMBase.view.WebserviceDetailsWindow','eGBTMBase.view.JmsDetailsWindow','eGBTMBase.view.ErrorDetailsWindow','eGBTMBase.view.OtherPointCutWindow','eGBTMBase.view.EjbDetailsWindow','eGBTMBase.view.NoSQLDetailWindow'],
	init:function(){
		appController = this;
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			//'sqlquerywindow button[id=drillManage]':
			//{
				//'click': this.drillDownButtonOnClick
			//},
			'main treepanel[id="TreeViewPanel"]':
			{
				'itemclick':this.loadPage
			}
		});
	},
	loadPage: function(view,record,item,index,event)
	{
		var selectedNode = record.data.id;

		if(selectedNode == 'summary')
			this.SummaryButtonOnClick();
		else if(selectedNode == 'Callgraph')
			this.CallGraphButtonOnClick();
		else if(selectedNode == 'hotspot')
			this.hotSpotButtonOnClick();
		else if(selectedNode == 'sqlcalls')
			this.sqlCallsButtonOnClick();
		else if(selectedNode == 'errordetails')
			this.errorDetailButtonOnClick();
		else if(selectedNode == 'externaldetails')
			this.externalDetailsButtonOnClick()
	},
	afterMainRender: function()
	{
		this.nextWindowTitleSet();
		var treePanel = Ext.getCmp('TreeViewPanel');
		var record = treePanel.getStore().getNodeById('Callgraph');

		if(redirectPage == 'HTTP' || redirectPage == 'WEBSERVICE' || redirectPage == 'JMS' || redirectPage == 'SAP JCO' || redirectPage == 'RMI' || redirectPage == 'EMAIL' || redirectPage == 'LDAP' || redirectPage == 'EJB' || redirectPage == 'RUNTIME' || redirectPage == 'REDIS' || redirectPage == 'EHCACHE')
		{
			this.externalDetailsButtonOnClick();
			record = treePanel.getStore().getNodeById('externaldetails');
			treePanel.getSelectionModel().select(record);
		}
		else if(redirectPage =='SQL' || redirectPage =='MONGODB')
		{
			this.sqlCallsButtonOnClick();
			record = treePanel.getStore().getNodeById('sqlcalls');
			treePanel.getSelectionModel().select(record);
		}
		else if(redirectPage =='ERROR')
		{
			this.errorDetailButtonOnClick();
			record = treePanel.getStore().getNodeById('errordetails');
			treePanel.getSelectionModel().select(record);
		}
		else
		{
			this.CallGraphButtonOnClick();
			treePanel.getSelectionModel().select(record);
		}

	},
	showRediswindow:function (modalWindowGridData)
	{
	 var grid = Ext.create('Ext.grid.Panel', {
			cls:'gridSkin',
			margin: 0,
			frame:false,
			border:true,
			autoScroll:true,
			flex:1,
			scroll : true,
			id: 'IntermediateDetailsTable',
			height:158,
			padding:0,
			store:new Ext.data.Store(
			{
				fields: ['dataOne','dataTwo'],
				data: modalWindowGridData
			}),
			tdAttrs:{
				style:{
					'vertical-align':'middle !important'
				}
			},
			viewConfig: {
				deferEmptyText: true,
				forceFit:true,
			},
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: true,
					resizable: true
				},
				items: [
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"DataBase Name"+"</span>",
						dataIndex: 'dataOne',
						flex:1,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							}

					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Command"+"</span>",
						dataIndex: 'dataTwo',
						flex:3,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							}
					}
				],
			}
		 
		}).show();
		return grid;
	},
	redisCommandWindow:function(modalWindowGridData)
	{
		var viewSize =  Ext.getBody().getViewSize();
		Ext.create('Ext.window.Window', {
			title: 'List of Commands executed ',
			ui:'newPopupWindow withBorderShadow newplainHeader',
			height: 200,
			width: 400,
			bodyPadding:10,
			padding:0,
			margin:0,
			ghost:false,
			layout: 'fit',
			items: 
				[appController.showRediswindow(modalWindowGridData)]
			
		}).show();
	},
	showModalwindow:function (modalWindowGridData)
	{
	 var grid = Ext.create('Ext.grid.Panel', {
			cls:'gridSkin',
			margin: 0,
			frame:false,
			border:true,
			//style:  data.paper.skin  === "Light" ?  '{"border": "red 1px solid !important"}' : '{"border":" #c5c5c5 1px solid !important"}',
			autoScroll:true,
			flex:1,
			scroll : true,
			id: 'IntermediateDetailsTable',
			height:158,
			padding:0,
			store:new Ext.data.Store(
			{
				fields: ['userExperience','callType','target','startTime','executionTime','connectedNodeOrder'],
				data: modalWindowGridData
			}),
			tdAttrs:{
				style:{
					'vertical-align':'middle !important'
				}
			},
			viewConfig: {
				deferEmptyText: true,
				forceFit:true,
			},
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: true,
					resizable: true
				},
				items: [
					{
						text: "",
						dataIndex: 'userExperience',
						renderer: function(value, metadata,record){
								return '<div><img src="../images/clear.png" class="btm_rum_dd_icons_'+value+'"  data-qtip="'+value.charAt(0).toUpperCase() + value.slice(1)+'" /></div>' ;
							},
						width: 32
					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Call Type"+"</span>",
						dataIndex: 'callType',
						flex:1,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							}

					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Target"+"</span>",
						dataIndex: 'target',
						flex:2,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							}
					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Start time"+"</span>",
						dataIndex: 'startTime',
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							},
						flex:2
					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Execution time"+"<span style='text-transform:none'> ("+"ms"+")</span></span>",
						dataIndex: 'executionTime',
						//width: 90,
						flex:1,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							}

					}
				],
			},
			listeners: {
				"itemclick": function ( grid, record, item,index, eOpts )
				{
					var row = grid.getStore().getAt(index);
					if (row.data.connectedNodeOrder != 'None') {
                  
						appController.drillDownButtonOnClick(row.data.connectedNodeOrder);
                    }
				},
				"viewready": function (grid) {
					var view = grid.view;
				}
			}
		 
		}).show();
		return grid;
	},
	jmsIMWWindow:function(modalWindowGridData)
	{
		var viewSize =  Ext.getBody().getViewSize();
		Ext.create('Ext.window.Window', {
			title: 'Select a call to drill down',
			//cls:'btmnewWindow',
			ui:'newPopupWindow withBorderShadow newplainHeader',
			height: 200,
			width: 700,
			bodyPadding:10,
			padding:0,
			margin:0,
			ghost:false,
			layout: 'fit',
			items: 
				[appController.showModalwindow(modalWindowGridData)]
			
		}).show();
	},
	SummaryButtonOnClick: function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		loader.show();
		closeExistingPopups();
		var centerContentPane = Ext.getCmp('centerContentPane');
		var urlToGo = 'EgBTMSummary.jsp?buttonClicked=Summary&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&timeString='+timeString+'&testName='+testName;
		if(threadRequest.length>0 && threadRequest == 'asyncThread')
			urlToGo = 'EgBTMSummary.jsp?buttonClicked=Summary&EG_GUID='+guidString+'&asyncGuid='+asyncGuid+'&nodeOrder='+nodeOrder+'&isAsyncThread=asyncThread'+'&timeString='+timeString+'&testName='+testName;

		Ext.getCmp('centerContentPane').setAutoScroll(true);
		Ext.Ajax.request(
		{
			url: urlToGo,
			method:'POST',
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					centerContentPane.removeAll();
					centerContentPane.setTitle(lbl_Summary);
					centerContentPane.getHeader().show();
					Ext.getCmp('sqlCallsViewNumber').hide();
					Ext.getCmp('sqlCallsViewNumbersep').hide();
					var summaryDataPresence = publicJSON['SummaryDataPresence'];
					if (summaryDataPresence == 'yes')
					{
						centerContentPane.add({xtype : 'summaryview'});
						Ext.getCmp("overviewTable").getStore().loadRawData(publicJSON.gridData);
						Ext.getCmp('totalProcessTimeLookup').update(publicJSON['totalProcessTimeLookupData']);
						Ext.getCmp('urlLookup').update(publicJSON['urlLookupData']);
						Ext.getCmp('componentLookup').update(publicJSON['componentLookupData']);
						Ext.getCmp('javaExecTime').update(publicJSON['javaExecTimeData']);
						Ext.getCmp('externalExecTime').update(publicJSON['externalExecTimeData']);

						var pieChartData= publicJSON['pieDatarootJson'];

						$('#pieauto').highcharts(pieChartData);
						$(".highcharts-legend-item path").attr('stroke-width', 10);

						if(threadRequest.length>0 && threadRequest == 'asyncThread')
							window.parent.setTitle(publicJSON.title , 'AsyncWindow#'+asyncGuid);
						else
							window.parent.setTitle(publicJSON.title , id);
					}
					else
					{
						var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+lbl_NoDataSummary+'</span></td></tr></table>';

						var comp = Ext.create('Ext.container.Container', {
							flex : 1,
							margin: '2 10 10 5',
							cls:'btmAppDashboardsTopPanel',
							autoScroll:true,
							border:true,
							layout:
							{
								type: 'fit',
								pack: 'center',
								align: 'stretch'
							},
							html: table,
						});
						centerContentPane.add(comp);
					}
					loader.hide();
				}
			}
		});
	},
	CallGraphButtonOnClick: function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		loader.show();
		closeExistingPopups();
		var centerContentPane = Ext.getCmp('centerContentPane');
		centerContentPane.removeAll();
		centerContentPane.setTitle(lbl_CallGraph);
		centerContentPane.getHeader().hide();
		Ext.getCmp('centerContentPane').setAutoScroll(false);
		var link = '/final/monitor/eGBTMTrace.jsp?EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&currentWindowId='+encodeURIComponent(prevWindowId)+'&testName='+testName;
		centerContentPane.add({
				xtype: 'component',
				margin: 0,
				padding:0,
				flex:1,
				bodyPadding:0,
				id: 'SelectViewPanel',
				autoEl: {
					tag: 'iframe',
					frameborder: '0',
					height: '100%',
					width: '100%',
					autoScroll: true,
					scroll: true,
					src: link
				}
		});
		loader.hide();
	},
	hotSpotButtonOnClick: function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		loader.show();
		closeExistingPopups();
		var centerContentPane = Ext.getCmp('centerContentPane');
		Ext.getCmp('centerContentPane').setAutoScroll(true);
		Ext.Ajax.request(
		{
			url: 'EgBTMSummary.jsp?buttonClicked=HotSpot&nodeOrder='+nodeOrder+'&EG_GUID='+guidString+'&testName='+testName,
			method:'POST',
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					centerContentPane.removeAll();
					centerContentPane.setTitle(lbl_HotSpot);
					centerContentPane.getHeader().show();
					Ext.getCmp('sqlCallsViewNumber').hide();
					Ext.getCmp('sqlCallsViewNumbersep').hide();
					var hotSpotPresence = publicJSON['hotSpotPresence'];
					var url = publicJSON['url'];
					var nickname = publicJSON['nickName'];
					var compName = publicJSON['compName'];
					if (hotSpotPresence == 'yes')
					{
						centerContentPane.add({xtype : 'hotspotview'});
						Ext.getCmp("hotSpotTable").getStore().loadRawData(publicJSON.gridData);
					}
					else if(hotSpotPresence == 'no')
					{
						var table = ""
						if(url != undefined)
						{
							table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+noHotSpot+' '+url+' '+on+' '+nickname+'  '+'('+compName+')'+'</span></td></tr></table>';
							
						}else
						{
							table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+noHotSpot+' '+thisTransaction+'!'+'</span></td></tr></table>';
						}
						var comp = Ext.create('Ext.container.Container', {
							flex : 1,
							margin: '2 10 10 5',
							cls:'btmAppDashboardsTopPanel',
							autoScroll:true,
							border:true,
							layout:
							{
								type: 'fit',
								pack: 'center',
								align: 'stretch'
							},
							html: table,
						});
						centerContentPane.add(comp);
					}
					loader.hide();
				}
			}
		});
	},
	errorDetailButtonOnClick: function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		loader.show();
		closeExistingPopups();
		var urlToGo= 'EgBTMSummary.jsp?buttonClicked=ErrorDetails&nodeOrder='+nodeOrder+'&EG_GUID='+guidString+'&requestType='+requestType+'&testName='+testName;
		var centerContentPane = Ext.getCmp('centerContentPane');
		centerContentPane.removeAll();
		Ext.getCmp('centerContentPane').setAutoScroll(true);
		Ext.Ajax.request(
		{
			url: urlToGo,
			method:'POST',
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );

					centerContentPane.removeAll();
					//centerContentPane.setTitle(lbl_ErrorDetails);
					//centerContentPane.getHeader().show();
					Ext.getCmp('sqlCallsViewNumber').hide();
					Ext.getCmp('sqlCallsViewNumbersep').hide();
					var errorPresence = publicJSON['errorPresence'];
					var url = publicJSON['url'];
					var nickname = publicJSON['nickName'];
					var compName = publicJSON['compName'];
					if(errorPresence == 'yes')
					{
						var errorData = publicJSON['errorData'];
						var errorDataCount = publicJSON['errorDataCount'];

						centerContentPane.add({xtype : 'errordetailsview'});
						Ext.getCmp('resultTexts').update(errorData);

						centerContentPane.setTitle(lbl_SingleErrorDetails);
						if(errorDataCount > 1){
							var TempMoreErrorDetails = lbl_MoreErrorDetails.replace('#n', errorDataCount);
							centerContentPane.setTitle(TempMoreErrorDetails);
						}
						centerContentPane.getHeader().show();
					}
					else
					{
						centerContentPane.setTitle(lbl_ErrorDetails);
						centerContentPane.getHeader().show();
						var table = ""
						if(url != undefined)
						{
							table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+noErrorDetail+' '+url+' '+on+' '+nickname+'  '+'('+compName+')'+'</span></td></tr></table>';
							
						}else
						{
							table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+noErrorDetail+' '+thisTransaction+'!'+'</span></td></tr></table>';
						}
						var comp = Ext.create('Ext.container.Container', {
							flex : 1,
							margin: '2 10 10 5',
							cls:'btmAppDashboardsTopPanel',
							autoScroll:false,
							border:true,
							layout:
							{
								type: 'fit',
								pack: 'center',
								align: 'stretch'
							},
							html: table,
						});
						centerContentPane.add(comp);
					}
					loader.hide();
				}
			}
		});
	},
	sqlCallsButtonOnClick: function()
	{
		var loader = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		loader.show();
		closeExistingPopups();
		var urlToGo= 'EgBTMSummary.jsp?buttonClicked=SQLCalls&nodeOrder='+nodeOrder+'&EG_GUID='+guidString+'&requestType='+requestType+'&testName='+testName;
		if(threadRequest.length>0 && threadRequest == 'asyncThread')
			urlToGo= 'EgBTMSummary.jsp?buttonClicked=SQLCalls&nodeOrder='+nodeOrder+'&EG_GUID='+guidString+'&requestType='+requestType+'&isAsyncThread=asyncThread&testName='+testName;
		var centerContentPane = Ext.getCmp('centerContentPane');
		Ext.getCmp('centerContentPane').setAutoScroll(true);

		Ext.Ajax.request(
		{
			url: urlToGo,
			method:'POST',
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					centerContentPane.removeAll();
					Ext.getCmp('sqlCallsViewNumber').show();
					Ext.getCmp('sqlCallsViewNumbersep').show();
					var antiPatternLabel = publicJSON['AntiPatternLabel'];
					var antiPatternCount = publicJSON['AntiPatternCount'];
					var sqlCount = publicJSON['TotalSqlCalls'];
					var fastSqlCount = publicJSON['FastSQLCount'];
					//var fastSqlExecTime = publicJSON['FastSQLTime'];
					var totalExecutionTime = publicJSON['totalExecutionTime'];
					var tempTotSqlCount = 0;
					var totalSqlCalls = 0;

					if (fastSqlCount != null && fastSqlCount != undefined)
						tempTotSqlCount = sqlCount+fastSqlCount;
					else
						tempTotSqlCount = sqlCount;

					if(sqlCount > 1)
						totalSqlCalls = sqlCount+'&nbsp;'+"out of"+'&nbsp;'+tempTotSqlCount+'&nbsp'+lbl_SlowSqlQueries+' : &nbsp'+lbl_TotalTime+'&nbsp:&nbsp'+totalExecutionTime+'&nbsp'+lbl_ms;
					else
						totalSqlCalls = sqlCount+'&nbsp;'+"out of"+'&nbsp;'+tempTotSqlCount+'&nbsp'+lbl_SlowSqlQuery+' : &nbsp'+lbl_TotalTime+'&nbsp:&nbsp'+totalExecutionTime+'&nbsp'+lbl_ms;

					var csvName ="Slow SQL Queries for "+targetHost;

					var title = lbl_SQlCalls;
					var probInfo = "";
					if (antiPatternLabel != null)
					{
						if(antiPatternLabel == 'N+1')
							probInfo = "<img style='margin-top:4px;display:block;float:left;' src='data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==' class='x-tree-icon x-tree-icon-leaf iconExclamationSmall'>  <span style='font-size:11px;font-weight:500;'>N+1 query problem detected</span>";
						else if(antiPatternLabel == 'error' && antiPatternCount!=null)
						{
							if(antiPatternCount>1)
								probInfo = "<img style='margin-top:4px;display:block;float:left;' src='data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==' class='x-tree-icon x-tree-icon-leaf iconExclamationSmall'>  <span style='font-size:11px;font-weight:500;'>"+multipleQueryProblem+"</span>";
							else if(antiPatternCount==1)
								probInfo = "<img style='margin-top:4px;display:block;float:left;' src='data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==' class='x-tree-icon x-tree-icon-leaf iconExclamationSmall'>  <span style='font-size:11px;font-weight:500;'>"+queryProblem+"</span>";
						}
					}
					var borStyle = "1px solid #e3e3e3 !important";
					if(strSkin == "Dark")
						borStyle = "1px solid #525252 !important";				

					centerContentPane.add({
						id : "sqlSubPanelId",
						xtype:'panel',
						height:35,
						margin:'0 10 0 0',
						title:probInfo,
						style:{'border-top':borStyle},
						tools:[{
								xtype:'container',
								id:'sqlCallsViewInfo'
							}
						],
					});
					centerContentPane.setTitle(title);

					if(sqlCount != null && sqlCount != undefined)
					{
						Ext.getCmp('sqlCallsViewNumber').update("<a href='/final/servlet/egurkha.reporter.SaveInCSVFormat?customizedCSVName="+csvName+"'><image src='/final/images/spacer.gif' class='iconCsv' data-qtip='"+lbl_DownloadCsv+"' data-qclass='yellowTip' valign='middle' style='margin-top:-5px;margin-left:5px;'/></a>");
						Ext.getCmp('sqlCallsViewInfo').update('<div style="float:right;background:none !important;border:none !important;font-weight:500;" class="btmSqlQueryDetailsBox">'+totalSqlCalls+'</div>');
					}
					centerContentPane.getHeader().show();
					var sqlPresence = publicJSON['SQlPresence'];
					var url = publicJSON['url'];
					var nickname = publicJSON['nickName'];
					var compName = publicJSON['compName'];
					if (sqlPresence == 'yes')
					{
						centerContentPane.add({xtype : 'sqlcallsview'});
						Ext.getCmp("sqlCallsTable").antiPatternLabel=antiPatternLabel;
						Ext.getCmp("sqlCallsTable").getStore().loadRawData(publicJSON.gridData);
						Ext.getCmp('sqlCallsTable').getView().getSelectionModel().select(0);
					}
					else if(sqlPresence == 'fast')
					{
						var displayName = "";
						if (fastSqlCount > 1)
						{
							displayName = lbl_sqlQueries;
						}
						else
						{
							displayName = lbl_sqlQuery;
						}
						var sqlExecCutoffTime=publicJSON['sqlExecCutoffTime'];
						if(sqlExecCutoffTime==undefined || sqlExecCutoffTime==null || Ext.isEmpty(sqlExecCutoffTime) || sqlExecCutoffTime=='')
							sqlExecCutoffTime=='10';
						var lbl_fastQueryInfo=lbl_fastQueryInfo1+' '+sqlExecCutoffTime+lbl_fastQueryInfo2;
						var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center"  valign="middle"><table align="center" valign="top"><tr><td align="center" class="linebottomright" style="border-bottom:0px;padding-right:20px"><span class="font_normal18" style="line-height:200%;font-size:20px">'+fastSqlCount+'</span><br><span class="font_normal13">'+displayName+'</span></td><td align="center" style="padding-left:20px"><span class="font_normal18" style="line-height:200%;font-size:20px">'+totalExecutionTime+'<span class="font_normal11">ms</span></span><br><span class="font_normal13">'+lbl_TotalTime+'</span></td></tr></table><div style="text-align:center; margin-top:15px">'+lbl_fastQueryInfo+'</div></td></tr></table>';
						//table=table+'<div style="text-align:center">'+lbl_fastQueryInfo+'</div>';

						Ext.getCmp('sqlSubPanelId').hide();
						Ext.getCmp('sqlCallsViewNumbersep').hide();
						var comp = Ext.create('Ext.container.Container', {
							flex : 1,
							margin: '2 10 10 5',
							cls:'btmAppDashboardsTopPanel',
							autoScroll:true,
							border:true,
							layout:
							{
								type: 'fit',
								pack: 'center',
								align: 'stretch'
							},
							html: table,
						});
						centerContentPane.add(comp);
					}
					else if(sqlPresence == 'no')
					{
						centerContentPane.setTitle(lbl_SQlCalls);
						Ext.getCmp('sqlSubPanelId').hide();
						Ext.getCmp('sqlCallsViewNumbersep').hide();
						var table = ""
						if(url != undefined)
						{
							table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+noSqlCalls+' '+url+' '+on+' '+nickname+'  '+'('+compName+')'+'</span></td></tr></table>';
							
						}else
						{
							table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+noSqlCalls+' '+thisTransaction+'!'+'</span></td></tr></table>';
						}
						var comp = Ext.create('Ext.container.Container', {
							flex : 1,
							margin: '2 10 10 5',
							cls:'btmAppDashboardsTopPanel',
							autoScroll:true,
							border:true,
							layout:
							{
								type: 'fit',
								pack: 'center',
								align: 'stretch'
							},
							html: table,
						});
						centerContentPane.add(comp);
					}
					loader.hide();
				}
			}
		});
	},
	drillDownButtonOnClick: function(connectedNodeOrder)
	{
		//var nextNodeOrder = nodeOrder+'.'+nodeCount;
		var url = 'eGBTMBase.jsp?EG_GUID='+guidString+'&testName='+testName+'&nodeOrder='+connectedNodeOrder+'&timeString='+timeString;
		window.parent.baseStackTrace(url , guidString+"#"+connectedNodeOrder , prevWindowId);
	},
	nextWindowTitleSet: function()
	{
		var urlToGo = 'EgBTMSummary.jsp?buttonClicked=Summary&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&testName='+testName;
		if(threadRequest.length>0 && threadRequest == 'asyncThread')
			urlToGo = 'EgBTMSummary.jsp?buttonClicked=Summary&EG_GUID='+guidString+'&asyncGuid='+asyncGuid+'&nodeOrder='+nodeOrder+'&isAsyncThread=asyncThread&testName='+testName;
		Ext.Ajax.request(
		{
			url: urlToGo,
			method:'POST',
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					var summaryDataPresence = publicJSON['SummaryDataPresence'];
					if (summaryDataPresence == 'yes')
					{
						if(threadRequest.length>0 && threadRequest == 'asyncThread')
							window.parent.setTitle(publicJSON.title , 'AsyncWindow#'+asyncGuid);
						else
							window.parent.setTitle(publicJSON.title , id);
					}
				}
			}
		});
	},
	callGraphMethodHighlight: function(row)
	{
		var treePanel = Ext.getCmp('TreeViewPanel');
		var record = treePanel.getStore().getNodeById('Callgraph');
		treePanel.getSelectionModel().select(record);
		var records = Ext.getCmp('hotSpotTable').getStore().getAt(row);
		var mname = records.get('MethodDetail');
		var loader = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		loader.show();
		var centerContentPane = Ext.getCmp('centerContentPane');
		centerContentPane.removeAll();
		centerContentPane.setTitle(lbl_CallGraph);
		centerContentPane.getHeader().hide();
		Ext.getCmp('centerContentPane').setAutoScroll(false);
		mname=this.filterEncode(mname);
		var link = '/final/monitor/eGBTMTrace.jsp?EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&mname='+encodeURI(mname)+'&testName='+testName;
		centerContentPane.add({
				xtype: 'component',
				margin: 0,
				padding:0,
				flex:1,
				bodyPadding:0,
				id: 'SelectViewPanel',
				autoEl: {
					tag: 'iframe',
					frameborder: '0',
					height: '100%',
					width: '100%',
					src: link
				}
		});
		loader.hide();
	},
	externalDetailsButtonOnClick: function()
	{
		var me = this;
		var loader = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		loader.show();
		closeExistingPopups();
		var urlToGo= 'EgBTMSummary.jsp?buttonClicked=ExternalDetails&nodeOrder='+nodeOrder+'&EG_GUID='+guidString+'&requestType='+requestType+'&testName='+testName;
		if(threadRequest.length>0 && threadRequest == 'asyncThread')
			urlToGo= 'EgBTMSummary.jsp?buttonClicked=ExternalDetails&nodeOrder='+nodeOrder+'&EG_GUID='+guidString+'&requestType='+requestType+'&isAsyncThread=asyncThread&testName='+testName;
		var centerContentPane = Ext.getCmp('centerContentPane');
		centerContentPane.removeAll();
		Ext.getCmp('centerContentPane').setAutoScroll(false);
		Ext.Ajax.request(
		{
			url: urlToGo,
			method:'POST',
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					centerContentPane.setTitle(lbl_ExternalDetails);
					centerContentPane.getHeader().show();
					Ext.getCmp('sqlCallsViewNumber').hide();
					Ext.getCmp('sqlCallsViewNumbersep').hide();
					var externalDetailsPresence = publicJSON['externalDetailsPresence'];
					var url = publicJSON['url'];
					var nickname = publicJSON['nickName'];
					var compName = publicJSON['compName'];
					if(externalDetailsPresence == 'yes')
					{
						var titleLists = new Array();
						var itemsArray	=  new Array();
						var storeMap = new Ext.util.HashMap();

						for(key in publicJSON.gridData)
						{
							if(publicJSON.gridData[key][0].Type != undefined)
							{
								if(titleLists.indexOf(publicJSON.gridData[key][0].Type) == -1)
								{
									itemsArray.push(me.getGridPanel(publicJSON.gridData[key]));
									titleLists.push(publicJSON.gridData[key][0].Type);
								}
								else
								{
									storeMap.add(publicJSON.gridData[key][0].Type+'_'+key,publicJSON.gridData[key]);
								}
							}
						}

						Ext.suspendLayouts();
						centerContentPane.add({
							xtype : 'externaldetailsview',
							margin : '0 0 0 0',
							border:false,
							scroll:false,
							autoScroll:false,
							layout:{
								type: 'fit',
							},
							flex : 1,
							items:[
							{
								xtype:'panel',
								scroll:true,
								margin:'0 10 10 5',
								autoScroll:true,
								border:true,
								cls:'externalDetailsOuterBox',
								bodyPadding:'5 0 5 0',
								items:itemsArray
							}
							]
						});
						storeMap.each(function(key, value, length){
							var tempGridId = key.substring(0,key.indexOf('_'));
							Ext.getCmp(tempGridId).getStore().loadRawData(storeMap.get(key),true);
						});
						Ext.resumeLayouts(true);
					}
					else if(externalDetailsPresence == 'no')
					{
						var table = ""
						if(url != undefined)
						{
							table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+noRemoteDetails+' '+url+' '+on+' '+nickname+'  '+'('+compName+')'+'</span></td></tr></table>';

						}else
						{
							table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+noRemoteDetails+' '+thisTransaction+'!'+'</span></td></tr></table>';
						}
						var comp = Ext.create('Ext.container.Container', {
							flex : 1,
							margin: '2 10 10 5',
							cls:'btmAppDashboardsTopPanel',
							autoScroll:true,
							border:true,
							layout:
							{
								type: 'fit',
								pack: 'center',
								align: 'stretch'
							},
							html: table,
						});

						centerContentPane.add(comp);
					}
				}
			}
		});
		loader.hide();
	},
	getGridPanel : function(gridArray)
	{
		var fieldstoStore =  new Array();
		var mainColumnsObjArray	=  new Array();

		var gridTitle = "";
		var allow = true;

		for (var key in gridArray)
		{
			var columnObj = gridArray[key];
			var warningText="";
			for (var key1 in columnObj)
			{
				if(allow)
				{
					gridTitle = columnObj[key1];
					allow = false;
				}
				if(key1 == 'Type'){
					warningText=columnObj[key1];
				}
				fieldstoStore.push(key1);
				if(key1 != 'PercentValue')
				{
					if(key1 == 'Warning')
					{
						mainColumnsObjArray.push({
							header: "<img style='display:block;float:left;' src='data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==' class='x-tree-icon x-tree-icon-leaf iconExclamationSmall'>",
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { var toolTipValue ; 
							if (value == "-") {
							toolTipValue  = "Potential AntiPattern" ;
							}else {
								toolTipValue="Potential N+1 query problem detected";
								}  metaData.tdAttr = 'data-qtip="'+toolTipValue+'"  data-qclass="yellowTip"'; return value; },
							width:40,
						});
					}
					else
						if(key1 == 'Type')
					{
						// Add - grid title
						gridTitle=columnObj[key1];
						allow = false;
						mainColumnsObjArray.push({
							header: key1,
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"  data-qclass="yellowTip"'; return value; },
							width:90,
						});
					}
					else if(key1 == 'Count')
					{
						mainColumnsObjArray.push({
							header: key1,
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"  data-qclass="yellowTip"'; return value; },
							width:90,
						});
					}
					else if(key1 == 'Totaltime')
					{
						mainColumnsObjArray.push({
							header:'<label style="text-transform:none;white-space:normal;word-wrap: break-word">'+'TOTAL TIME (ms)'+'</label>',
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"  data-qclass="yellowTip"'; return value; },
							width:90,
						});
					}
					else if(key1 == 'AvgTime')
					{
						mainColumnsObjArray.push({
							header: '<label style="text-transform:none;white-space:normal;word-wrap: break-word">'+'AVERAGE TIME (ms)'+'</label>',
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"  data-qclass="yellowTip"'; return value; },
							width:80,
						});
					}
					else if(key1 == '% Time')
					{
						mainColumnsObjArray.push({
							header: key1,
							sortable:true,
							dataIndex: key1,
							minWidth:80,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"  data-qclass="yellowTip"'; return value; },
							flex:1,
						});
					}
					else if(key1 == 'Method')
					{
						mainColumnsObjArray.push({
							header: key1,
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"  data-qclass="yellowTip"'; return value; },
							minWidth:70,
							flex:1,

						});
					}
					else if(key1 == 'Operation')
					{
						mainColumnsObjArray.push({
							header: key1,
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"   data-qclass="yellowTip"'; return value; },
							width: 150,

						});
					}else if(key1 == 'Redis Command')
					{
						mainColumnsObjArray.push({
							header: 'Command',
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"   data-qclass="yellowTip"'; return value; },
							width: 150,

						});
					}else if(key1 == 'Total <br> Execution <br> Time (MS)')
					{
						mainColumnsObjArray.push({
							header: key1,
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"   data-qclass="yellowTip"'; return value; },
							width: 60,

						});
					}else if(key1 == 'Avg <br> Execution <br> Time (MS)')
					{
						mainColumnsObjArray.push({
							header: key1,
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"   data-qclass="yellowTip"'; return value; },
							width: 60,

						});
					}else if(key1 == 'DB URL')
					{
						mainColumnsObjArray.push({
							header: key1,
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"   data-qclass="yellowTip"'; return value; },
							width: 90,

						});
					}else if(key1 == 'DB Name')
					{
						mainColumnsObjArray.push({
							header: key1,
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"   data-qclass="yellowTip"'; return value; },
							width: 70,

						});
					}else if(key1 == 'Redis Count')
					{
						mainColumnsObjArray.push({
							header: 'Count',
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"   data-qclass="yellowTip"'; return value; },
							width: 70,

						});
					}else if(key1 == 'Status_code')
					{
						mainColumnsObjArray.push({
							header: '<label style="text-transform:none;white-space:normal;word-wrap: break-word">'+'STATUS CODE '+'</label>',
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"  data-qclass="yellowTip"'; return value; },
							width:80,
						});
					}
					else
					{
						mainColumnsObjArray.push({
							header: key1,
							sortable:true,
							dataIndex: key1,
							renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"  data-qclass="yellowTip"'; return value; },
							flex:4,
						});
					}
				}
			}
		}

		var gridOuterContainer = Ext.widget('panel',{
			ui: 'externalDetailsGridOuter',
			border:true,
			layout: {
				type: 'vbox',
				pack: 'left',
				align: 'stretch'
			},
			padding:'10 10 5 10',
			width:'100%',
			items:[
			{
				xtype:'container',
				html:'<div class="externalDetailsGridOuterHeaderText">'+gridTitle+'</div>'
			},
			{
				xtype: 'grid',
				store:new Ext.data.Store({
					fields: fieldstoStore,
					data: gridArray
				}),
				sortableColumns:true,
				columns:mainColumnsObjArray,
				id: gridTitle,
				viewConfig: {
					stripeRows : true
				},
				margin:'4 10 10 10',
				cls:'btmGridSkin',
				autoScroll:true,
				scroll : true,
				flex : 1
//				listeners: {
//					"viewready": function (grid) {
//						var view = grid.view;
//						grid.mon(view, {
//							uievent: function (type, view, cell, recordIndex, cellIndex, e) {
//								grid.cellIndex = cellIndex;
//								grid.recordIndex = recordIndex;
//							}
//						});
//
//						grid.tip = Ext.create('Ext.tip.ToolTip', {
//							target: view.el,
//							delegate: '.x-grid-cell',
//							trackMouse: true,
//							maxWidth: 500,
//							minWidth: 100,
//							cls:'yellowTip para',
//							style:{'word-wrap':'break-word'},
//							renderTo: Ext.getBody(),
//							listeners: {
//								beforeshow: function updateTipBody(tip) {
//									if (!Ext.isEmpty(grid.cellIndex) && grid.cellIndex != -1) {
//										header = grid.headerCt.getGridColumns()[grid.cellIndex];
//										var temp = grid.getStore().getAt(grid.recordIndex).get(header.dataIndex);
//										if(!Ext.isEmpty(temp))
//										{
//											var type = grid.getStore().getAt(grid.recordIndex).get('Type');
//											if(grid.cellIndex == 3 && type != 'SAP JCO')
//											{
//												tip.update(grid.getStore().getAt(grid.recordIndex).get('PercentValue')+' %');
//											}
//											else
//											{
//												tip.update(grid.getStore().getAt(grid.recordIndex).get(header.dataIndex)+"");
//											}
//										}
//										else
//										{
//											return false;
//										}
//									}
//									else
//									{
//										return false;
//									}
//								}
//							}
//						});
//					}
//				}
			}]

		});
		return gridOuterContainer;
	},
	filterEncode: function(text)
	{
		//['%;()=]
		var filterEncodeChar = ['[',']','(',')','=','%','\'','&',';'];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|per|','|squot|','|ampsnd|','|scol|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return text;
	}
});




















function showSapDiv(nodeIndex, type, nextNodeCount,x,y)
{
	closeExistingPopups();
	Ext.widget('sapdetailswindow').showAt([x,y]);
	nodeCount = nextNodeCount;
	var urlToGo= 'EgBTMSummary.jsp?buttonClicked=HttpWebJms&index='+nodeIndex+'&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&type='+type+'&requestType='+requestType+'&nodeCount='+nodeCount+'&testName='+testName;
	Ext.Ajax.request(
	{
		url: urlToGo,
		method:'POST',
		success: function(response)
		{
			if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
			{
				//Ext.getCmp('sapData').setHeight(150);
				//Ext.getCmp('sapData').setWidth(480);
				var jsonTexts = response.responseText;
				var jsonText = jsonTexts.substring(0,jsonTexts.indexOf("#$#"));
				if(jsonText != null && jsonText.length>0)
				{
					var sapDataToLoad = jsonText.split("*&*");
					Ext.getCmp('jcoFunction').setValue(sapDataToLoad[0]);
					Ext.getCmp('ashost').setValue(sapDataToLoad[1]);
					Ext.getCmp('systemId').setValue(sapDataToLoad[2]);
					Ext.getCmp('systemNo').setValue(sapDataToLoad[3]);
					Ext.getCmp('userName').setValue(sapDataToLoad[4]);
					Ext.getCmp('client').setValue(sapDataToLoad[5]);
				}
				else
				{
					Ext.getCmp('sapData').removeAll();
					var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+'No '+type+' calls found'+'</span></td></tr></table>';

					var comp = Ext.create('Ext.Component', {
						html: table,
					});
					Ext.getCmp('sapData').add(comp);
				}
			}
		}
	});
}

function showAsyncDiv(asynGuid)
{
	closeExistingPopups();
	var url = 'eGBTMBase.jsp?EG_GUID='+guidString+'&testName='+testName+'&asyncGUID='+asynGuid+'&threadRequest=asyncThread&nodeOrder='+nodeOrder+'&timeString='+timeString;
	window.parent.baseStackTrace(url, "AsyncWindow#"+asynGuid , prevWindowId);
}

function framebodyClickCall(currentWindowId)
{
	window.parent.setFocusToWindow(currentWindowId);
}

function callGraphTitleSet(title)
{
	var centerContentPane = Ext.getCmp('centerContentPane');
	centerContentPane.getHeader().hide();
}

function UrlFrame(url,evt)
{

	/*var url = decodeURIComponent(urldata);
	var xmlhttp=GetXmlHttpObject();

	if(xmlhttp==null)
		return;

	xmlhttp.onreadystatechange=function()
	{
		if(xmlhttp.readyState==4)
		{
			if(xmlhttp.status == 200)
			{
				try
				{
					var iframeDoc = window.parent.opener.document;
					var iFrameId = iframeDoc.getElementById('main');
					iFrameId.src=url;
					window.parent.close();
				}
				catch (error)
				{
					window.open(url);
				}
			}
		}
	}
	xmlhttp.open('POST',url, true);
	xmlhttp.setRequestHeader("Content-Type","text/html;charset=UTF-8");

	if(window.parent.opener!=null){
		window.parent.opener.focus();
	}

	xmlhttp.send(null);*/
	window.location.href = url;
	/*Ext.Ajax.request({
		url:url,
		success:function(respons)
		{
			var response = respons.responseText;
			var jsonData = Ext.decode(response);
			var gridData = jsonData.tableData;
			var divId = window.document.getElementById("alarmsListDiv");
			if(gridData!="NO_DATA")
				divId.innerHTML = gridData;
			else
			{
				var errortext = '<div class="containerShadow"><table border=\"0\" width=\"100%\" height=\"100%\" bordercolor=\"green\"><tr><td width=\"100%\" colspan=\"15\" height=\"100%\" align=\"right\"><div class=\"iconClose3\" onclick=\"closeDiv()\"></div></td></tr><tr><td align=\"center\" id=\"eg_errorsmall\" width=\"100%\" colspan=\"15\" height=\"100%\" style=\"padding:10px 0 10px 0\"><center><div class=\"iconExclamation\"></div></center><div class=\"commonErrorMsgText\"> No alarms Found </div></td></tr></table></div>';
				divId.innerHTML = errortext;
			}
			divId.style.visibility='visible';
			divId.style.display='block';
			divId.style.position="fixed";
			divId.style.zindex="10000";
			var scrWidth=screen.width/4;
			var scrHeight=screen.height/4;

			//alert("scrHeight----------"+scrHeight);
			divId.style.left=(scrWidth-30) + "px";
			divId.style.top=(scrHeight-65) + "px";

		}
	});*/
}

function GetXmlHttpObject()
{
	var xmlHttp=null;
	try
	{
		// Firefox, Opera 8.0+, Safari
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{
		// Internet Explorer
		try
		{
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");
		}
	}
	return xmlHttp;
}


function gotoTopology(url){
		window.location = url;
	}
function showHttpDiv(nodeIndex, type, nextNodeCount,x,y)
{
	closeExistingPopups();
	Ext.widget('httpDetailsWindow').showAt([x,y]);
	nodeCount = nextNodeCount;
	var urlToGo= 'EgBTMSummary.jsp?buttonClicked=HttpWebJms&index='+nodeIndex+'&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&type='+type+'&requestType='+requestType+'&nodeCount='+nodeCount+'&testName='+testName;
	Ext.Ajax.request(
	{
		url: urlToGo,
		method:'POST',
		success: function(response)
		{
			if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
			{
				var jsonTexts = response.responseText;
				var jsonText = jsonTexts.substring(0,jsonTexts.indexOf("#$#"));
				if(jsonText != null && jsonText.length>0)
				{
					var drillDownPresent = jsonTexts.substring(jsonTexts.indexOf("#$#")+3,jsonTexts.indexOf("&^&"));
					var connectedNodeOrder = jsonTexts.substring(jsonTexts.indexOf("&^&")+3);
					connectedNodeOrder = connectedNodeOrder.trim();
					var dataOne = jsonText.substring(0,jsonText.indexOf('*&*'));
					var dataTwo = jsonText.substring(jsonText.indexOf('*&*')+3,jsonText.indexOf('*$*'));
					var dataThree = jsonText.substring(jsonText.indexOf('*$*')+3,jsonText.indexOf('*#*'));
					var dataFour = jsonText.substring(jsonText.indexOf('*#*')+3);
					if(type == 'http')
					{
						Ext.getCmp('url').setValue(dataOne);
						Ext.getCmp('ipAndPort').setValue(dataThree);
						Ext.getCmp('methodOrOperation').setValue(dataTwo);
						Ext.getCmp('urlStatusCode').setValue(dataFour);

						if(drillDownPresent.indexOf("Yes") != -1)
						{
							Ext.getCmp('httpData').setTitle(lbl_HttpCallDetails+"<a href='javascript:void(0)'  onclick='appController.drillDownButtonOnClick(\""+connectedNodeOrder+"\");')><div class='httpCallDetailsLink' >"+lbl_DrillDown+"</div></a>");
						}
					}
				}
				else
				{
					Ext.getCmp('httpData').removeAll();
					var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+'No '+type+' calls found'+'</span></td></tr></table>';

					var comp = Ext.create('Ext.Component', {
						html: table,
					});
					Ext.getCmp('httpData').add(comp);
				}
			}
		}
	});
}

function showRedisDiv(nodeIndex, type, nextNodeCount,x,y)
{
	closeExistingPopups();
	Ext.widget('noSQLDetailWindow').showAt([x,y]);
	nodeCount = nextNodeCount;
	var urlToGo= 'EgBTMSummary.jsp?buttonClicked=HttpWebJms&index='+nodeIndex+'&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&type='+type+'&requestType='+requestType+'&nodeCount='+nodeCount+'&testName='+testName;
	Ext.Ajax.request(
	{
		url: urlToGo,
		method:'POST',
		success: function(response)
		{
			if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
			{

				var jsonTexts = response.responseText;
				var jsonText = jsonTexts.substring(0,jsonTexts.indexOf("#$#"));
				if(jsonText != null && jsonText.length>0)
				{
					var drillDownPresent = jsonTexts.substring(jsonTexts.indexOf("#$#")+3,jsonTexts.indexOf("&^&"));
					var dataTwo = jsonText.substring(jsonText.indexOf('*&*')+3,jsonText.indexOf('*$*'));
					var dataThree = jsonText.substring(jsonText.indexOf('*$*')+3,jsonText.indexOf('*^*'));
					var dataFour = jsonText.substring(jsonText.indexOf('*^*')+3);
					if(type == 'redis')
					{
						if(drillDownPresent.indexOf("Yes") != -1)
						{
							var data = jsonText.substring(0,jsonText.indexOf('*&*'));
							publicJSON = Ext.decode( data );
							var dataOne = publicJSON['redisData'];
							Ext.getCmp('command').setValue("<a href='javascript:void(0)'  onclick='appController.redisCommandWindow("+JSON.stringify(dataOne)+");')><div class='httpCallDetailsLink' >"+"Click here to see all commands"+"</div></a>");
							Ext.getCmp('dbName').hide();
						}else
						{
							var dataOne = jsonText.substring(0,jsonText.indexOf('*&*'));
							Ext.getCmp('command').setValue(dataOne);
							Ext.getCmp('dbName').setValue(dataThree);
						}
						
						Ext.getCmp('ipPort').setValue(dataTwo);
						Ext.getCmp('responseTime').setValue(dataFour);
					}else
					{
						Ext.getCmp('noSQLData').removeAll();
						var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+'No '+type+' calls found'+'</span></td></tr></table>';

						var comp = Ext.create('Ext.Component', {
							html: table,
						});
						Ext.getCmp('noSQLData').add(comp);
					}
				}
					
			}
		}

	});

}

function showWebserviceDiv(nodeIndex, type, nextNodeCount,x,y)
{
	closeExistingPopups();
	Ext.widget('webserviceDetailsWindow').showAt([x,y]);
	nodeCount = nextNodeCount;
	var urlToGo= 'EgBTMSummary.jsp?buttonClicked=HttpWebJms&index='+nodeIndex+'&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&type='+type+'&requestType='+requestType+'&nodeCount='+nodeCount+'&testName='+testName;
	Ext.Ajax.request(
	{
		url: urlToGo,
		method:'POST',
		success: function(response)
		{
			if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
			{
				var jsonTexts = response.responseText;
				var jsonText = jsonTexts.substring(0,jsonTexts.indexOf("#$#"));
				if(jsonText != null && jsonText.length>0)
				{
					var drillDownPresent = jsonTexts.substring(jsonTexts.indexOf("#$#")+3,jsonTexts.indexOf("&^&"));
					var connectedNodeOrder = jsonTexts.substring(jsonTexts.indexOf("&^&")+3);
					connectedNodeOrder = connectedNodeOrder.trim();
					var dataOne = jsonText.substring(0,jsonText.indexOf('*&*'));
					var dataTwo = jsonText.substring(jsonText.indexOf('*&*')+3,jsonText.indexOf('*$*'));
					var dataThree = jsonText.substring(jsonText.indexOf('*$*')+3);
					if(type == 'webservice')
					{
						Ext.getCmp('webServiceUrl').setValue('<div style="overflow:hidden;text-overflow:ellipsis;" '+"data-qclass='yellowTip' data-qtip='"+dataOne+"'  >"+dataOne+"</div>");
						Ext.getCmp('webServiceOperation').setValue('<div style="overflow:hidden;text-overflow:ellipsis;" '+"data-qclass='yellowTip' data-qtip='"+dataTwo+"'  >"+dataTwo+"</div>");
						Ext.getCmp('statusCode').setValue('<div style="overflow:hidden;text-overflow:ellipsis;" '+"data-qclass='yellowTip' data-qtip='"+dataThree+"'  >"+dataThree+"</div>");
						if(drillDownPresent.indexOf("Yes") != -1)
						{
							Ext.getCmp('webserviceData').setTitle(lbl_WebServiceCallDetails+"<a href='javascript:void(0)'  onclick='appController.drillDownButtonOnClick(\""+connectedNodeOrder+"\");')><div class='httpCallDetailsLink' >"+lbl_DrillDown+"</div></a>");
						}
					}
				}
				else
				{
					Ext.getCmp('webserviceData').removeAll();
					var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+'No '+type+' calls found'+'</span></td></tr></table>';

					var comp = Ext.create('Ext.Component', {
						html: table,
					});
					Ext.getCmp('webserviceData').add(comp);
				}
			}
		}
	});
}

function showJmsDiv(nodeIndex, type, nextNodeCount,x,y)
{
	closeExistingPopups();
	Ext.widget('jmsDetailsWindow').showAt([x,y]);
	//var newX = x + Ext.getCmp('jmsData').getHeight();
	//var newY = y + ((Ext.getCmp('jmsData').getWidth()/2)+420);
	//Ext.widget('jmsDetailsWindow').showAt([newX,newY]);
	nodeCount = nextNodeCount;
	var urlToGo= 'EgBTMSummary.jsp?buttonClicked=HttpWebJms&index='+nodeIndex+'&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&type='+type+'&requestType='+requestType+'&nodeCount='+nodeCount+'&testName='+testName;
	Ext.Ajax.request(
	{
		url: urlToGo,
		method:'POST',
		success: function(response)
		{
			if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
			{
				var jsonTexts = response.responseText;
				var jsonText = jsonTexts.substring(0,jsonTexts.indexOf("#$#"));
				if(jsonText != null && jsonText.length>0)
				{
					var drillDownPresent = jsonTexts.substring(jsonTexts.indexOf("#$#")+3,jsonTexts.indexOf("&^&"));
					var state = jsonTexts.substring(jsonTexts.indexOf("&^&")+3);
					var dataOne = jsonText.substring(0,jsonText.indexOf('*&*'));
					var dataTwo = jsonText.substring(jsonText.indexOf('*&*')+3,jsonText.indexOf('*$*'));
					var dataThree = jsonText.substring(jsonText.indexOf('*$*')+3);
					var connectedNodeOrder = jsonTexts.substring(jsonTexts.indexOf("&^&")+3);

					connectedNodeOrder = connectedNodeOrder.trim();
					var errorPresence = "";
					var externalDetailsPresence="";
					if(jsonTexts.indexOf('***') > -1)
					{
						connectedNodeOrder = jsonTexts.substring(jsonTexts.indexOf("&^&")+3,jsonTexts.indexOf('***'));
						errorPresence = jsonTexts.substring(jsonTexts.indexOf('***')+3);
						publicJSON = Ext.decode( errorPresence );
						 externalDetailsPresence = publicJSON['jmsData'];
					}

					if(type == 'jms')
					{
						Ext.getCmp('jmsProvider').setValue(dataOne);
						Ext.getCmp('jmsTopicQueue').setValue(dataTwo);
						Ext.getCmp('jmsDetails').setValue(dataThree);
						if(drillDownPresent.indexOf("Yes") != -1)
						{
							if(jsonTexts.indexOf('***') > -1)
								Ext.getCmp('jmsData').setTitle(lbl_JmsCallDetails+"<a href='javascript:void(0)'  onclick='appController.jmsIMWWindow("+JSON.stringify(externalDetailsPresence)+");')><div class='httpCallDetailsLink' >"+lbl_DrillDown+"</div></a>");
							else
								Ext.getCmp('jmsData').setTitle(lbl_JmsCallDetails+"<a href='javascript:void(0)'  onclick='appController.drillDownButtonOnClick(\""+connectedNodeOrder+"\");')><div class='httpCallDetailsLink' >"+lbl_DrillDown+"</div></a>");
						}
					}
				}
				else
				{
					Ext.getCmp('jmsData').removeAll();
					var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+'No '+type+' calls found'+'</span></td></tr></table>';

					var comp = Ext.create('Ext.Component', {
						html: table,
					});
					Ext.getCmp('jmsData').add(comp);
				}
			}
		}
	});
}

function showEjbDiv(nodeIndex, type, nextNodeCount,x,y)
{
	closeExistingPopups();
	Ext.widget('EjbDetailsWindow').showAt([x,y]);
	nodeCount = nextNodeCount;
	var urlToGo= 'EgBTMSummary.jsp?buttonClicked=HttpWebJms&index='+nodeIndex+'&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&type='+type+'&requestType='+requestType+'&nodeCount='+nodeCount+'&testName='+testName;

	Ext.Ajax.request(
	{
		url: urlToGo,
		method:'POST',
		success: function(response)
		{
			if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
			{
				var jsonTexts = response.responseText;
				var jsonText = jsonTexts.substring(0,jsonTexts.indexOf("#$#"));
				if(jsonText != null && jsonText.length>0)
				{
					var state = jsonTexts.substring(jsonTexts.indexOf("&^&")+3);
					var dataOne = jsonText.substring(0,jsonText.indexOf('*&*'));
					var dataTwo = jsonText.substring(jsonText.indexOf('*&*')+3);
					if(type == 'ejb')
					{
						Ext.getCmp('ejbProtocolWithHost').setValue(dataOne);
						Ext.getCmp('ejbMethod').setValue(dataTwo);
					}
				}
				else
				{
					Ext.getCmp('ejbData').removeAll();
					var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+'No '+type+' calls found'+'</span></td></tr></table>';

					var comp = Ext.create('Ext.Component', {
						html: table,
					});
					Ext.getCmp('ejbData').add(comp);
				}
			}
		}
	});
}

function showOtherPointCutDiv(nodeIndex, type, nextNodeCount,x,y)
{
	closeExistingPopups();
	Ext.widget('OtherPointCutWindow').showAt([x,y]);
	nodeCount = nextNodeCount;
	var urlToGo= 'EgBTMSummary.jsp?buttonClicked=HttpWebJms&index='+nodeIndex+'&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&type='+type+'&requestType='+requestType+'&nodeCount='+nodeCount+'&testName='+testName;

	Ext.Ajax.request(
	{
		url: urlToGo,
		method:'POST',
		success: function(response)
		{
			if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
			{
				var jsonTexts = response.responseText;
				var jsonText = jsonTexts.substring(0,jsonTexts.indexOf("#$#"));
				if(jsonText != null && jsonText.length>0)
				{
					var drillDownPresent = jsonTexts.substring(jsonTexts.indexOf("#$#")+3,jsonTexts.indexOf("&^&"));
					var state = jsonTexts.substring(jsonTexts.indexOf("&^&")+3);
					var dataOne = jsonText.substring(0,jsonText.indexOf('*&*'));
					var dataTwo = jsonText.substring(jsonText.indexOf('*&*')+3);
					if (dataTwo.indexOf(':') > -1)
					{
						dataTwo = dataTwo.substring(0,dataTwo.indexOf(':')); // used to remove colon btw RMI protocol and RMI URL
					}
					if(type == 'rmi')
					{
						Ext.getCmp('otherDetailsData').setTitle(lbl_RmiCallDetails);
						//Ext.getCmp('otherDetailsData').setWidth(400);
						//Ext.getCmp('otherDetailsId1').setFieldStyle('labelWidth: 60;');
						Ext.getCmp('otherDetailsId1').setFieldLabel(lbl_Details);
						//Ext.getCmp('otherDetailsId1').setWidth(60);
						Ext.getCmp('otherDetailsId1').setValue(dataOne);
						//Ext.getCmp('otherDetailsId2').setFieldStyle('labelWidth: 60;');
						Ext.getCmp('otherDetailsId2').setFieldLabel(lbl_RmiProtocol);
						Ext.getCmp('otherDetailsId2').setValue(dataTwo);
					}
					else if(type == 'email'){
						Ext.getCmp('otherDetailsData').setTitle(lbl_EmailCallDetails);
						//Ext.getCmp('otherDetailsId1').setFieldStyle('labelWidth: 60;');
						Ext.getCmp('otherDetailsId1').setFieldLabel(lbl_Method);
						Ext.getCmp('otherDetailsId1').setValue(dataOne);
						//Ext.getCmp('otherDetailsId2').setFieldStyle('labelWidth: 100;');
						Ext.getCmp('otherDetailsId2').setFieldLabel(lbl_ExecutionTime);
						Ext.getCmp('otherDetailsId2').setValue(dataTwo);
					}
					else if(type == 'ldap'){
						Ext.getCmp('otherDetailsData').setTitle(lbl_LdapCallDetails);
						//Ext.getCmp('otherDetailsId1').setFieldStyle('labelWidth:60px;margin-right:5px;');
						//Ext.getCmp('otherDetailsId1').setFieldStyle('width:60px;margin-right:5px;');
						Ext.getCmp('otherDetailsId1').setFieldLabel(lbl_Method);
						Ext.getCmp('otherDetailsId1').setValue(dataOne);
						//Ext.getCmp('otherDetailsId2').setFieldStyle('labelWidth: 100;');
						Ext.getCmp('otherDetailsId2').setFieldLabel(lbl_ExecutionTime);
						Ext.getCmp('otherDetailsId2').setValue(dataTwo);
					}
					else if(type == 'runtime'){
						Ext.getCmp('otherDetailsData').setTitle(lbl_RuntimeCallDetails);
						//Ext.getCmp('otherDetailsId1').setFieldStyle('labelWidth: 100;');
						Ext.getCmp('otherDetailsId1').setFieldLabel(lbl_RuntimeCommandUsed);
						Ext.getCmp('otherDetailsId1').setValue(dataOne);
						//Ext.getCmp('otherDetailsId2').setFieldStyle('labelWidth: 100;');
						Ext.getCmp('otherDetailsId2').setFieldLabel(lbl_ExecutionTime);
						Ext.getCmp('otherDetailsId2').setValue(dataTwo);
					}
				}
				else
				{
					Ext.getCmp('otherDetailsData').removeAll();
					var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+'No '+type+' calls found'+'</span></td></tr></table>';

					var comp = Ext.create('Ext.Component', {
						html: table,
					});
					Ext.getCmp('otherDetailsData').add(comp);
				}
			}
		}
	});
}

function showErrorDiv(sqlIndex, subCompType, x, y)
{

	closeExistingPopups();
	Ext.widget('errorDetailsWindow').showAt([x,y]);
	var urlToGo= 'EgBTMSummary.jsp?buttonClicked=ErrorDetails&index='+sqlIndex+'&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&requestType='+requestType+'&testName='+testName;
	Ext.Ajax.request(
	{
		url: urlToGo,
		method:'POST',
		success: function(response)
		{
			if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );

				if(subCompType == 'exception')
				{
					var errorPresence = publicJSON['errorPresence'];
					var url = publicJSON['url'];
					var nickname = publicJSON['nickName'];
					var compName = publicJSON['compName'];
					if(errorPresence == 'yes')
					{
						var errorData = publicJSON['errorData'];
						Ext.getCmp('exceptionContainer').update(errorData);
					}
					else
					{
						var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+'No errors captured found for '+url+' on '+nickname+'  '+'('+compName+')'+'</span></td></tr></table>';
						var comp = Ext.create('Ext.Component', {
							html: table,
						});
						Ext.getCmp('errorData').add(comp);
					}
				}
			}
		}
	});
}
function showQueryDiv(sqlIndex, subCompType, x, y)
{

	closeExistingPopups();
	Ext.widget('sqlquerywindow').showAt([x,y]);
	var urlToGo= 'EgBTMSummary.jsp?buttonClicked=SQLCalls&index='+sqlIndex+'&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&requestType='+requestType+'&testName='+testName;
	if(threadRequest == 'asyncThread')
		urlToGo= 'EgBTMSummary.jsp?buttonClicked=SQLCalls&index='+sqlIndex+'&EG_GUID='+guidString+'&nodeOrder='+nodeOrder+'&requestType='+requestType+'&isAsyncThread=asyncThread&testName='+testName;

	Ext.Ajax.request(
	{
		url: urlToGo,
		method:'POST',
		success: function(response)
		{
			if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );

				if(subCompType == 'sql' || subCompType == 'mongodb')
				{
					var sqlPresence = publicJSON['SQlPresence'];
					if(sqlPresence == 'yes')
					{
						var title = publicJSON['dbdetail'];
						var charLen = publicJSON['charCount'];
						var titleString = '';
						var ipIndex =  title.indexOf('^*');
						if(ipIndex > -1 )
						{
							var ipStr = title.substring(0,ipIndex);
							if(ipStr.length > charLen)
							{
								ipStr = ipStr.substring(0,charLen-3);
								ipStr = ipStr.concat("...");
							}
							var remainingStr = title.substring(ipIndex+2);
							titleString = ipStr+remainingStr;
						}
						title = title.replace('^*','');
						
						Ext.getCmp('sqlQueryGridTitle').update('<div style="font-size:11px;font-weight:bold;overflow:hidden;text-overflow:ellipsis;" '+"data-qclass='yellowTip' data-qtip='"+title+"'  >"+titleString+"</div>");
						Ext.getCmp("sqlCallTable").getStore().loadRawData(publicJSON.gridData);
						Ext.getCmp('sqlCallTable').getView().getSelectionModel().select(0);
						Ext.getCmp('singleQueryTextField').update(publicJSON.gridData[0].Query_Details);
					}
					else
					{
						Ext.getCmp('previewData').removeAll();
						var table = '<table align="center" valign="middle" height="100%" width="100%" border="0px"><tr><td align="center" ><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"/><br/><span class="font_Normal11">'+lbl_NoDataSql+'</span></td></tr></table>';
						var comp = Ext.create('Ext.Component', {
							html: table,
						});
						Ext.getCmp('previewData').add(comp);
					}
				}
			}
		}
	});
}


function closeExistingPopups()
{

	if(Ext.getCmp('httpData') != null)
	{
		//Ext.get('main').doLayout();
		Ext.getCmp('httpData').close();
	}
	else if(Ext.getCmp('webserviceData') != null)
	{
		//Ext.get('main').doLayout();
		Ext.getCmp('webserviceData').close();
	}
	else if(Ext.getCmp('jmsData') != null)
	{
		//Ext.get('main').doLayout();
		Ext.getCmp('jmsData').close();
	}
	else if(Ext.getCmp('previewData') != null)
	{
		//Ext.get('main').doLayout();
		Ext.getCmp('previewData').close();
	}
	else if(Ext.getCmp('sapData') != null)
	{
		//Ext.get('main').doLayout();
		Ext.getCmp('sapData').close();
	}
	else if(Ext.getCmp('errorData') != null)
	{
		Ext.getCmp('errorData').close();
	}
	else if(Ext.getCmp('otherDetailsData') != null)
	{
		Ext.getCmp('otherDetailsData').close();
	}
	else if(Ext.getCmp('ejbData') != null)
	{
		Ext.getCmp('ejbData').close();
	}else if(Ext.getCmp('noSQLData') != null)
	{
		Ext.getCmp('noSQLData').close();
	}
}