Ext.define('eGBTMBase.view.HotSpotView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.hotspotview',
	layout: 'fit',
	flex : 1,
	cls:'outerpanel',
	items: [
		{
			xtype: 'grid',
			cls:'btmGridSkin',
			margin: '2 10 10 5',
			autoScroll:true,
			scroll : true,
			id: 'hotSpotTable',
			style:{'background':'none !important'},
			flex : 1,
			store:new Ext.data.Store(
			{
				fields: ['MethodDetail','Count','Duration','Percentage','Progress'],
				data: []
			}),
			viewConfig: {
				forceFit: true,
				stripeRows : true,
				deferEmptyText: true
			},
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: true
				},
				items: [
					{
						text: lbl_MethodDetails,
						dataIndex: 'MethodDetail',
						flex:4,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							 metaData.tdAttr = 'data-qtip="'+value+'" data-qclass="yellowTip para"';
							return '<div style="width:auto;text-overflow: ellipsis;white-space: nowrap;overflow: hidden;" onclick="javascript:appController.callGraphMethodHighlight('+row+')" >'+value+'</div>';
						}
					},
					{
						text: lbl_Count,
						dataIndex: 'Count',
						renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; },
						width:65
					},
					{
						text: "<label style='white-space:normal;word-wrap: break-word'>"+lbl_Duration+"<span style='text-transform:none'> ("+lbl_ms+")</span></label>",
						dataIndex: 'Duration',
						renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; },
						width:130
					},
					{
						text: '% of time',
						dataIndex: 'Progress',
						width:100,
						hidden: true,
						renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; }
					},
					{
						text: lbl_TimePercentage,
						dataIndex: 'Percentage',
						minWidth:80,
						flex:1,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var percent = record.raw.Percentage;
							metaData.tdAttr = 'data-qtip="'+percent+'&nbsp;%"';
							return '<div class="btmGraphBg" ><div class="btmGraph" align="center" height="14" style="position:absolute;top:0px;left:0px;text-align:center;width:'+percent+'%;height:14px;margin-left:0px;border:0px solid red;" ></div> <span style="position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;" class="btmGraphValue" >'+percent+'&nbsp;%</span> </div>';
						}
					}
				]
			}
//			listeners: {
//				"viewready": function (grid) {
//					var view = grid.view;
//					// record the current cellIndex
//					grid.mon(view, {
//						uievent: function (type, view, cell, recordIndex, cellIndex, e) {
//							grid.cellIndex = cellIndex;
//							grid.recordIndex = recordIndex;
//						}
//					});
//
//					grid.tip = Ext.create('Ext.tip.ToolTip', {
//						target: view.el,
//						delegate: '.x-grid-cell',
//						trackMouse: true,
//						maxWidth: 500,
//						minWidth: 100,
//						cls:'yellowTip para',
//						style:{'word-wrap':'break-word'},
//						renderTo: Ext.getBody(),
//						listeners: {
//							beforeshow: function updateTipBody(tip) {
//								if (!Ext.isEmpty(grid.cellIndex) && grid.cellIndex != -1) {
//									header = grid.headerCt.getGridColumns()[grid.cellIndex];
//									var temp = grid.getStore().getAt(grid.recordIndex).get(header.dataIndex);
//									if(!Ext.isEmpty(temp))
//									{
//										if(grid.cellIndex == 4)
//											tip.update(grid.getStore().getAt(grid.recordIndex).get(header.dataIndex)+' %');
//										else
//											tip.update(grid.getStore().getAt(grid.recordIndex).get(header.dataIndex)+"");
//									}
//									else
//									{
//										return false;
//									}
//								}
//								else
//								{
//									return false;
//								}
//							}
//						}
//					});
//				}
//			}
		}
	]
});



