Ext.define('eGBTMBase.view.HttpDetailsWindow',{
	extend:'Ext.tip.ToolTip',
	alias:'widget.httpDetailsWindow',
	border:false,
	id: 'httpData',
	title: lbl_HttpCallDetails,
	closeAction: 'destroy',
	ui:'btmToolTipUi',
	closable:'true',
	height: 140,
	autoHide:false,
	anchor:'bottom',
	draggable:false,
	anchorToTarget:'true',
	bodyPadding:'8 8 8 8',
	width: 480,
	frame:false,
	shadow:false,
	renderTo:'centerContentPane',
	padding:0,
	border:true,
	autoScroll:true,
	minWidth:400,
	maxWidth:600,
	layout:'auto',
	items : [
		{
			xtype:'container',
			id: 'httpDetailsPopup',
			layout:'column',
			margin:0,
			border:true,
			listeners:{
				afterrender:function(c){
					c.items.items.forEach(function(ele){
						Ext.defer(function(){
								document.getElementById(ele.getInputId()).setAttribute('data-qclass','yellowTip para')
								document.getElementById(ele.getInputId()).setAttribute("data-qtip",""+ele.value+"")
								},100);
					});
				}
			},
			items:[
				{
					xtype: 'displayfield',
					id: 'url',
					border:false,
					labelWidth: 70,
					labelSeparator:' :',
					width:450,
					fieldLabel: lbl_HttpUrl,
					toolTip: lbl_HttpUrl,
					value: ''
				},
				{
					xtype: 'displayfield',
					id: 'urlStatusCode',
					labelSeparator:' :',
					labelWidth: 80,
					border:false,
					width:260,
					fieldLabel: lbl_StatusCode,
					toolTip: lbl_StatusCode,
					value: ''
				},
				{
					xtype: 'displayfield',
					id: 'methodOrOperation',
					labelWidth: 56,
					labelSeparator:' :',
					border:false,
					width:170,
					fieldLabel: lbl_Method,
					toolTip: lbl_Method,
					value: ''
				},
				{
					xtype: 'displayfield',
					id: 'ipAndPort',
					labelSeparator:' :',
					labelWidth: 100,
					border:false,
					width:260,
					fieldLabel: lbl_ExecutionTime,
					toolTip: lbl_ExecutionTime,
					value: ''
				}
			]
		}
	],
	listeners: {
		"close": function (panel, eOpts ) {
			window.parent.setFocusToWindow(prevWindowId);
		}
	}
});