var store = Ext.create('Ext.data.TreeStore', {
	root: {
		expanded: true,
		children: [
			{ leaf: true, text: lbl_Summary, id: 'summary', "iconCls":"btmSummary"},
			{ leaf: true, text: lbl_CallGraph, id: 'Callgraph', "iconCls":"btmCallGraph"},
			{ leaf: true, text: lbl_HotSpot, id: 'hotspot', "iconCls":"btmHotSpots"},
			{ leaf: true, text: lbl_SQlCalls, id: 'sqlcalls', "iconCls":"btmSqlCalls"},
			{ leaf: true, text: lbl_ErrorDetails, id: 'errordetails', "iconCls":"btmErrorDetails"},
			{ leaf: true, text: lbl_ExternalDetails, id: 'externaldetails', "iconCls":"btmExtDetails"}
		]
	}
});

Ext.define('eGBTMBase.view.OverView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.main',
	layout: {type:'border',align:'stretch'},
	padding:0,
	autoScroll:false,
	scroll : false,
	margin:0,
	cls:'btmMainpanel',
	items: [
		{
			region:'west',
			//split: true,
			collapseMode :'mini',
			xtype:'panel',
			layout:'fit',
			collapsible: true,
			scroll:false,
			split: true,
			header: false,
			collapsed:false,
			splitterResize:false,
			collapseMode :'mini',
			margin:0,
			items:[
			{
				xtype:'treepanel',
				id : 'TreeViewPanel',
				flex:1,
				autoScroll:true,
				cls:'btmTreePanel removeTreeLeftBorder',
				margin:'10 3 10 10',
				padding:0,
				bodyPadding:0,
				style:{'background':'none !important'},
				frame:true,
				width:170,
				layout:{type:'vbox',align:'stretch'},
				rootVisible: false,
				lines: false,
				autoShow: true,
				useArrows: false,
				hideCollapseTool: true,
				header: false,
				store: store,
				listeners:{
					"collapse":function(){
						if (Ext.get('summaryView') != null || Ext.get('summaryView') != undefined)
						{
							var getDisplayFieldWidth = Ext.get('summaryLookupHolder').getWidth();
							var gettingValueField = Ext.get('centerContentPane').down('.btmDisplayFieldURLValueEllipsis');
							var gettingValueField2 = Ext.get('centerContentPane').down('.btmDisplayFieldCompValueEllipsis');
							gettingValueField.setWidth(getDisplayFieldWidth-40);
							gettingValueField2.setWidth(getDisplayFieldWidth-110);

						}
						this.doLayout();
					},
					"expand":function(){
						if (Ext.get('summaryView') != null || Ext.get('summaryView') != undefined)
						{

							var getDisplayFieldWidth = Ext.get('summaryLookupHolder').getWidth();
							var gettingValueField = Ext.get('centerContentPane').down('.btmDisplayFieldURLValueEllipsis');
							var gettingValueField2 = Ext.get('centerContentPane').down('.btmDisplayFieldCompValueEllipsis');
							gettingValueField.setWidth(getDisplayFieldWidth-40);
							gettingValueField2.setWidth(getDisplayFieldWidth-110);
						}
						this.doLayout();
					}
				}
			}]
		},
		{
			region: 'center',
			flex: 4,
			frame:false,
			margin:'10 0 0 0',
			cls:'btmDatapanel',
			style:{'background':'none !important','border':'none'},
			padding:0,
			bodyPadding:'5 0 0 0',
			layout:{
				type: 'vbox',
				align:'stretch'
			},
			autoScroll: true,
			id : 'centerContentPane',
			tools:[
				{
					xtype:'tbseparator',
					hidden:true,
					id:'sqlCallsViewNumbersep',
				},{
					xtype:'container',
					hidden:true,
					id:'sqlCallsViewNumber',
				}
			],
			items:[]
		}
	]
});
