Ext.define('eGBTMBase.view.SQLQuerywindow',{
	extend:'Ext.tip.ToolTip',
	alias:'widget.sqlquerywindow',
	border:false,
	id: 'previewData',
	title: lbl_SqlQueryDetails,
	closeAction: 'destroy',
	hidden: true,
	ui:'btmToolTipUi',
	closable:'true',
	height: 260,
	autoHide:false,
	anchor:'bottom',
	draggable:false,
	anchorToTarget:'true',
	bodyPadding:'8 8 8 8',
	width: 560,
	frame:false,
	shadow:false,
	renderTo:'centerContentPane',
	padding:0,
	border:true,
	autoScroll:true,
	minWidth:400,
	maxWidth:600,
	layout:'fit',
	items : [
		{
			xtype: 'container',
			id: 'sqlCallTableHolder',
			cls:'btmTooltipInnerBorder',
			margin:0,
			border:true,
			layout:
			{
				type: 'vbox',
				align: 'stretch'
			},
			items: [
				{
					xtype:'container',
					id: 'sqlQueryGridTitle',
					height:30,
					padding:'8 8 8 8'
				},
				{
					xtype: 'grid',
					cls:'btmGridSkin headerBgNone',
					style:{'background':'none !important'},
					margin :'0 10 10 10',
					autoScroll:false,
					scroll : false,
					id: 'sqlCallTable',
					layout: 'fit',
					//height:46,
					header:false,
					forceFit: true,
					store:new Ext.data.Store(
					{
						fields: ['Query_Type','Query_Details','Execution_Time','Progress','Error'],
						data: []
					}),
					viewConfig: {
						deferEmptyText: true
					},
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: true
						},
						items: [
							{
								text: lbl_QueryType,
								dataIndex: 'Query_Type',
								renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; },
								width:85
							},
							{
								text: lbl_QueryDetails,
								dataIndex: 'Query_Details',
								renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; },
								hidden: true,
								flex:1
							},
							{
								text: "<label style='white-space:normal;word-wrap: break-word'>"+lbl_ExecuteTime+"</label>",
								renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; },
								dataIndex: 'Execution_Time',
								width:90
							},
							{
								text: lbl_TimePercentage,
								dataIndex: 'Progress',
								minWidth:100,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									var percent = record.raw.Progress;
									//return '<div class="btmGraphBg"><div class="btmGraph" align="left" height="14" style="float:left;width:'+percent+'%;height:14px;margin-left:0px;border:0px solid red;" ><label style="margin-left:13px;position:relative">'+percent+'&nbsp;%</label></div></div>';
									 metaData.tdAttr = 'data-qtip="'+percent+'%"';
									return '<div class="btmGraphBg"><div class="btmGraph" align="center" height="14" style="position:absolute;top:0px;left:0px;text-align:center;width:'+percent+'%;height:14px;margin-left:0px;border:0px solid red;" ></div> <span style="position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;" class="btmGraphValue" >'+percent+'&nbsp;%</span></div>';
								}
							},
							{
								text: lbl_Error,
								dataIndex: 'Error',
								minWidth:90,
								flex:1
							}
						]
					}
//					listeners: {
//						"viewready": function (grid) {
//							var view = grid.view;
//
//							// record the current cellIndex
//							grid.mon(view, {
//								uievent: function (type, view, cell, recordIndex, cellIndex, e) {
//									grid.cellIndex = cellIndex;
//									grid.recordIndex = recordIndex;
//								}
//							});
//
//							grid.tip = Ext.create('Ext.tip.ToolTip', {
//								target: view.el,
//								delegate: '.x-grid-cell',
//								trackMouse: true,
//								renderTo: Ext.getBody(),
//								listeners: {
//									beforeshow: function updateTipBody(tip) {
//										if (!Ext.isEmpty(grid.cellIndex) && grid.cellIndex != -1) {
//											header = grid.headerCt.getGridColumns()[grid.cellIndex];
//											var temp = grid.getStore().getAt(grid.recordIndex).get(header.dataIndex);
//											if(temp != null && temp != '')
//											{
//												tip.update(grid.getStore().getAt(grid.recordIndex).get(header.dataIndex));
//											}
//											else
//											{
//												return false;
//											}
//										}
//									}
//								}
//							});
//						}
//					}
				},
				{
					xtype: 'panel',
					id: 'singleQueryTextField',
					title: 'Query',
					cls: 'btmDatapanel queryHeader',
					flex: 1,
					width: '98%',
					autoScroll: true,
					margin : '0 10 10 10',
					bodyPadding: '5 5 2 10',
					html: 'Query details to load'
				}
			]
		}
	],
	listeners: {
		"close": function (panel, eOpts ) {
			window.parent.setFocusToWindow(prevWindowId);
		}
	}
});