Ext.define('eGBTMBase.view.SqlCallsView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.sqlcallsview',
	layout: 'fit',
	border:false,
	flex : 1,
	layout:
	{
		type: 'vbox',
		align:'stretch',
	},
	cls:'outerpanel',
	items: [
		{
			xtype: 'grid',
			cls:'btmGridSkin',
			margin: '2 10 6 5',
			frame:true,
			autoScroll:true,
			flex:1,
			scroll : true,
			border:true,
			style:{'background':'none !important'},
			id: 'sqlCallsTable',
			height:158,
			padding:0,
			store:new Ext.data.Store(
			{
				fields: ['Warning','Query_Type','Query_Details',
					{'name':'Count','sortType': 'asFloat'},
					{'name':'Avg_Execution_Time','sortType': 'asFloat'},
					{'name':'Total_Execution_Time','sortType': 'asFloat'},
					{'name':'Progress','sortType': 'asFloat'},
					'Error','ErrorWin', 'Database_Details'],
				data: []
			}),
			tdAttrs:{
				style:{
					'vertical-align':'middle !important'
				}
			},
			viewConfig: {
				deferEmptyText: true,
				forceFit:true,
			},
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					// draggable - for rearrange columns
					draggable: true,
					resizable: true
				},
				items: [
					{
						
						text: "<img data-qclass='yellowTip' data-qtip='Anti-pattern detected' style='display:block;float:left;' src='data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==' class='x-tree-icon x-tree-icon-leaf iconExclamationSmall'>",
						dataIndex: 'Warning',
						width:40,
						renderer : function(value, metaData ,record) {
							var toolTipValue ; 
							if(this.antiPatternLabel == 'N+1')
								toolTipValue = "N+1 query problem detected";
							else if(this.antiPatternLabel == 'error')
								toolTipValue = "Multiple query problem detected";

							metaData.tdAttr = "<span style='white-space:nowrap;' data-qclass='yellowTip' data-qtip='"+toolTipValue+"'";
							return value; 
						}
					},
					{
						text: "<label style='white-space:normal;word-wrap: break-word'>"+lbl_QueryType+"</label>",
						dataIndex: 'Query_Type',
						width:70,
						renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; }
					},
					{
						text: "<label style='white-space:normal;word-wrap: break-word'>"+lbl_QueryDetails+"</label>",
						dataIndex: 'Query_Details',
						renderer : function(value, metaData ,record) { return value; },
						flex:2
					},
					{
						text: "<label style='white-space:normal;word-wrap: break-word'>"+lbl_Count+"<span style='text-transform:none'></span></label>",
						dataIndex: 'Count',
						renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; },
						width: 90
					},
					{
						text: "<label style='white-space:normal;word-wrap: break-word'>"+lbl_AvgExecuteTime+"<span style='text-transform:none'> ("+lbl_ms+")</span></label>",
						dataIndex: 'Avg_Execution_Time',
						renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; },
						width: 90
					},
										{
						text: "<label style='white-space:normal;word-wrap: break-word'>"+lbl_TotalExecuteTime+"<span style='text-transform:none'> ("+lbl_ms+")</span></label>",
						dataIndex: 'Total_Execution_Time',
						renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; },
						width: 90
					},
					{
						text: "<label style='white-space:normal;word-wrap: break-word'>"+lbl_TimePercentage+"</label>",
						dataIndex: 'Progress',
						minWidth:80,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var percent = record.raw.Progress;
							 metaData.tdAttr = 'data-qtip="'+percent+'&nbsp;%"';
							return '<div class="btmGraphBg"><div class="btmGraph" align="center" height="14" style="position:absolute;top:0px;left:0px;text-align:center;width:'+percent+'%;height:14px;margin-left:0px;border:0px solid red;" ></div> <span style="position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;" class="btmGraphValue" >'+percent+'&nbsp;%</span> </div>';
						}
					},
					{
						text: "<label style='white-space:normal;word-wrap: break-word'>"+lbl_Error+"</label>",
						dataIndex: 'Error',
						//renderer : function(value, metaData ,record) { metaData.tdAttr = 'data-qtip="'+value+'"'; return value; },
						renderer : function(value, metaData ,record) { 
							var tmp_data= record.data.Error;

							if(tmp_data!='-')
							{
								var error_Len=tmp_data.length;
								if(error_Len>20)
								{
									record.createNewWin = true;
									metaData.style = 'text-decoration:underline';
									metaData.tdCls = 'mouse';
								}
								else
									metaData.tdAttr = 'data-qtip="'+tmp_data+'"';
							}
							return tmp_data; 
						},
						width:70
					},
					{
						text:  "<label style='white-space:normal;word-wrap: break-word'>"+lbl_DatabaseDetails+"</label>",
						dataIndex: 'Database_Details',
						renderer : function(value, metaData ,record) { return value; },
						flex:1
					}
				],
			},
			listeners: {
				cellclick : function(view, cell, cellIndex, record, row, rowIndex, e)
				{
					var pos_x    = e.getX();
					var pos_y    = e.getPageY();
					var resonWindowCmp = Ext.getCmp('reasonWindow');
					if(!Ext.isEmpty(resonWindowCmp))
						resonWindowCmp.destroy();
					var newWin=record.createNewWin
					if((!Ext.isEmpty(newWin) || newWin!=undefined) && newWin==true)
					{
						if(cellIndex==7)
						{
							var err_win_data= record.data.ErrorWin;
							if(err_win_data!='-')
							{
								var err_Win=Ext.create('Ext.window.Window', {
									title: 'ERROR',
									id:'reasonWindow',
									height: 200,
									width: 600,
									modal: true,
									scroll:true,
									initCenter : false,
									//initCenter : true,
									x : pos_x-600,
									y : pos_y+10,
									bodyStyle:'padding-left:5px;',
									autoScroll:true,
									resizable:false,
									layout: 'fit',
									html:err_win_data,
									//listeners:
									//{
										//show: function(win)
										//{
											//if (this.modal)
											//{
											//var dom = Ext.dom.Query.select('.x-mask');
											//var el = Ext.fly(dom[dom.length-1]);
											//el.addCls('windowModal');
											//}
										//},
										//hide: function(win)
										//{
											//if (this.modal)
											//{
											//var dom = Ext.dom.Query.select('.x-mask');
											//var el = Ext.fly(dom[dom.length-1]);
											//el.removeCls('windowModal');
											//}
										//}
									//}
								});
							}
							err_Win.show();
						}
					}
				},
				"selectionchange":function ( grid, selected, eOpts )
				{
					Ext.getCmp('queryTextPanel').update(selected[0].data.Query_Details);
				},
				"viewready": function (grid) {
//					var view = grid.view;
//					// record the current cellIndex
//					grid.mon(view, {
//						uievent: function (type, view, cell, recordIndex, cellIndex, e) {
//							grid.cellIndex = cellIndex;
//							grid.recordIndex = recordIndex;
//						}
//					});
//
//					grid.tip = Ext.create('Ext.tip.ToolTip', {
//						target: view.el,
//						delegate: '.x-grid-cell',
//						trackMouse: true,
//						maxWidth: 500,
//						minWidth: 100,
//						cls:'yellowTip para',
//						style:{'word-wrap':'break-word'},
//						renderTo: Ext.getBody(),
//						listeners: {
//							beforeshow: function updateTipBody(tip) {
//								if (!Ext.isEmpty(grid.cellIndex) && grid.cellIndex != 1) {
//									header = grid.headerCt.getGridColumns()[grid.cellIndex];
//									var temp = grid.getStore().getAt(grid.recordIndex).get(header.dataIndex);
//									if(!Ext.isEmpty(temp))
//									{
//										if(grid.cellIndex == 3)
//											tip.update(grid.getStore().getAt(grid.recordIndex).get(header.dataIndex)+' %');
//										else if(grid.cellIndex == 5)
//											tip.update(Ext.util.Format.stripTags(grid.getStore().getAt(grid.recordIndex).get(header.dataIndex)));
//										else
//											tip.update(grid.getStore().getAt(grid.recordIndex).get(header.dataIndex)+"");
//									}
//									else
//									{
//										return false;
//									}
//								}
//								else
//								{
//									return false;
//								}
//							}
//						}
//					});
				}
			}
		},{
			xtype: 'container',
			cls: 'btmQueryDataOuter',
			border:true,
			flex:1,
			margin : '5 10 10 5',
			layout: {
				type: 'vbox',
				pack: 'left',
				align: 'stretch'
			},
			width:'100%',
			items:[
			{
				xtype:'container',
				cls:'btmQueryDataHeader',
				html:'<div class="query">Query</div>'
			},{
				xtype:'container',
				id: 'queryTextPanel',
				flex:1,
				title: 'Query',
				layout: {
					type: 'vbox',
					pack: 'left',
					align: 'stretch'
				},
				width:'100%',
				border:true,
				autoScroll: true,
				scroll: true,
				style:{'word-wrap':'break-word;'},
				padding:10,
				html:''
			}],
		}
	]
});

