Ext.define('eGBTMBase.view.SummaryView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.summaryview',
	layout: 'fit',
	autoScroll:false,
	cls:'outerpanel',
	border:false,
	frame:false,
	flex : 1,
	id:'summaryView',
	layout:
	{
		type: 'vbox'
	},
	style:{'border':'none !important','background':'none !important'},
	scroll : false,
	items: [
		{
			xtype:'container',
			height:161,
			layout:
			{
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			margin: '2 10 6 5',
			width: '100%',
			border:true,
			cls: 'btmAppDashboardsTopPanel',
			items: [
				{
					xtype: 'container',
					id: 'summaryLookupHolder',
					margin:'5 5 8 10',
					layout:
					{
						type: 'vbox',
						align: 'stretch'
					},
					flex: 3,
					items: [
						{
							xtype: 'container',
							id: 'totalProcessTimeLookup',
							cls:'btmDisplayFieldLabel',
						},
						{
							xtype: 'container',
							id: 'urlLookup',
							cls:'btmDisplayFieldLabel',
							height:24
						},
						{
							xtype: 'container',
							id: 'componentLookup',
							cls:'btmDisplayFieldLabel',
						},
						{
							xtype: 'container',
							cls:'btmDisplayFieldLabel',
							html:'<div style="float:left">'+lbl_BreakupProcessTime+' : </div>'
						},
						{
							xtype: 'container',
							padding:'0px 0px 0px 0px',
							layout:
							{
								type: 'hbox',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'container',
									id: 'javaExecTime',
									cls:'btmBreakUpTimeBox',
									height: 43,
									//width:105,
									flex:.4,
									margin: 0,
									border: true,
								},
								{
									xtype: 'container',
									id: 'externalExecTime',
									cls:'btmBreakUpTimeBox',
									height:43,
									//width: 215,
									flex:.6,
									margin:'0 0 0 15',
									border: true,
								},
							]

						}
					]
				},
				{
					xtype: 'tbseparator',
					cls:'btmSeparator',
					margin:'20px 5px 20px 5px'
				},
				{
					xtype: 'container',
					id: 'pieauto',
					flex: 2,
					border:0
				}
			]
		},
		{
			xtype: 'grid',
			cls:'btmGridSkin',
			margin : '5 10 10 5',
			autoScroll:true,
			scroll : true,
			id: 'overviewTable',
			flex : 1,
			width : '100%',
			border:true,
			frame:false,
			title:'TRANSACTION DETAILS',
			hideHeaders : true,
			store:new Ext.data.Store(
			{
				fields: ['A','B'],
				data: []
			}),
			viewConfig: {
				deferEmptyText: true
			},
			columns: {
				defaults: {
					sortable: false,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						dataIndex: 'A',
						flex:.7,
						renderer : function(value, metaData ,record) { 
							//metaData.tdAttr = 'data-qtip="'+value+'"'; 
							return '<span data-qtip="'+value+'">'+value+'<span>';  
						}
					},
					{
						dataIndex: 'B',
						flex:1.5,
						renderer : function(value, metaData ,record) 
						{ 
							if(record.raw.A.indexOf('User Experience (Overall)') > -1 || record.raw.A.indexOf('Java Processing Status') > -1)
								return '<span>'+value+'<span>'; 
							else{
								return '<span data-qtip="'+value+'">'+value+'<span>'; 
							}
						}
					}
				]
			}
//			listeners: {
//				"viewready": function (grid) {
//					var view = grid.view;
//					// record the current cellIndex
//					grid.mon(view, {
//						uievent: function (type, view, cell, recordIndex, cellIndex, e) {
//							grid.cellIndex = cellIndex;
//							grid.recordIndex = recordIndex;
//						}
//					});
//
//					grid.tip = Ext.create('Ext.tip.ToolTip', {
//						target: view.el,
//						delegate: '.x-grid-cell',
//						trackMouse: true,
//						maxWidth: 500,
//						minWidth: 100,
//						cls:'yellowTip para',
//						renderTo: Ext.getBody(),
//						listeners: {
//							beforeshow: function updateTipBody(tip) {
//								if (!Ext.isEmpty(grid.cellIndex) && grid.cellIndex != -1) {
//									header = grid.headerCt.getGridColumns()[grid.cellIndex];
//									var temp = grid.getStore().getAt(grid.recordIndex).get(header.dataIndex);
//									if(!Ext.isEmpty(temp))
//									{
//											tip.update(grid.getStore().getAt(grid.recordIndex).get(header.dataIndex)+"");
//									}
//									else
//									{
//										return false;
//									}
//								}
//								else
//								{
//									return false;
//								}
//							}
//						}
//					});
//				}
//			}
		}
	]
});



