 var publicjsonData1;
 var currentPageNo = 1;
 var totalRecCount = 0;
 Ext.define('egsearch.controller.searchcontroller',{
	extend:'Ext.app.Controller',
		refs:[
		{selector:'vmusersettings', ref:'vmusersettings'},
        {selector:'vmusertimeline', ref:'vmusertimeline'},
		{selector:'vmuserstate', ref:'vmuserstate'}
	],
	init:function(){
		appCnt = this;
		this.control({
			 'main': {
                'boxready': this.loadDefaultSearchData
            },
           'vmusertimeline button[id="gobtn"]':
			{
				'click': this.loadSettingsWiseGrid
			},
			'settings button[action=Save PDF]':
			{
				'click' : this.saveInPDFFormat
			},
			'settings button[action=Save CSV]':
			{
				'click' : this.saveInCSVFormat 
			}
		});
	},
	saveInPDFFormat:function(btn, e, opts)
	{
		if(isDataAvailable)
		{
			var eg_tbound1;
			var timeLineComboObjval =Ext.getCmp('er_timeline').getValue();
			if(timeLineComboObjval!=null && timeLineComboObjval=="Any")
				eg_tbound="Any";
			else
				eg_tbound="Fixed";
			var startdateObjval = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDisplayDateFormat);
			var enddateObjval = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDisplayDateFormat);
			var stDate = Ext.getCmp('er_stdate').getValue();
			var enDate = Ext.getCmp('er_enddate').getValue();  
			var startHourObjval=Ext.getCmp('er_sthr').dataArray;
			var endHourObjval =Ext.getCmp('er_endhr').dataArray;
			if(timeLineComboObjval!=null && timeLineComboObjval=="Any")
			{
				if(dateValidation(stDate,enDate,startHourObjval,endHourObjval,stmin,enmin) == -1)
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: 'From date should be lesser than To date',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;
				}
			}
			var vmstateComboval =Ext.getCmp('vmstateCombo').getValue(); 
			var meController = this;
			var pdfParams='',splitsearchval='';
			var tmp_pdfurl = '';
			if(searchType.toLowerCase()=="vm")
			{
				pdfParams='searchuser='+searchType+" "+searchvalue+'&eg_timeline='+timeLineComboObjval+'&eg_stdate='+(Ext.getCmp('er_stdate').dataArray)+'&eg_enddate='+(Ext.getCmp('er_enddate').dataArray)+'&starthr='+startHourObjval+'&endhr='+endHourObjval+'&eg_tbound='+eg_tbound+'&state='+vmstateComboval+'&startmin_h='+stmin+'&endmin_h='+enmin+'&searchtype='+searchType;
			}
			if(searchType.toLowerCase()=="user")
			{
				pdfParams = 'searchuser='+searchType+" "+searchvalue+'&eg_timeline='+timeLineComboObjval+'&eg_stdate='+(Ext.getCmp('er_stdate').dataArray)+'&eg_enddate='+(Ext.getCmp('er_enddate').dataArray)+'&starthr='+startHourObjval+'&endhr='+endHourObjval+'&eg_tbound='+eg_tbound+'&startmin_h='+stmin+'&endmin_h='+enmin+'&searchtype='+searchType;
			}

			var typeComObj = Ext.getCmp('typeCombo');
			var selVal = '';
			if(!Ext.isEmpty(typeComObj) && typeComObj!=null && typeComObj!=undefined)
				selVal = typeComObj.getValue();
			if(!Ext.isEmpty(selVal) && selVal!=null && selVal!=undefined)
				pdfParams = pdfParams+"&componentType="+selVal;
			var eventsPerPageObj = Ext.getCmp("eventsPerPage");
			var eventsPerPageVal = '';
			if(!Ext.isEmpty(eventsPerPageObj) && eventsPerPageObj!=null && eventsPerPageObj!=undefined)
			{
				eventsPerPageVal = eventsPerPageObj.getValue();
				pdfParams = pdfParams + '&eventsPerPage='+eventsPerPageVal;
			}
			var blankPage = "";
			var s_qryString = "/final/servlet/com.eg.EgPdfDownloadC?from=userSearch";
		
			if(!Ext.isEmpty(pdfParams) && pdfParams!=null && pdfParams!=undefined)
				s_qryString = s_qryString +"&"+pdfParams;
			var progressBar = Ext.MessageBox.progress({
				title: 'Downloading',
				value: 5,
				width: 350,
				increment: 15,
				closable: false,
				progressText: 'Connecting..',
				wait: true,
				waitConfig: {
					interval: 200
				},
				msg: '<b>Downloading Please wait...</b>',
				scope: this,
				handler: function () {
					this.updateText('Done!');
				}
				//	buttons: Ext.MessageBox.CANCEL
			});
			var iFrameExists = Ext.query("#pdfIframe");
			if(Ext.isEmpty(iFrameExists))
			{
				Ext.DomHelper.append(document.body, {
					tag: 'iframe',
					frameBorder: 0,
					width: 0,
					height: 0,
					css: 'display:none;visibility:hidden;height:1px;',
					src: s_qryString,
					id: 'pdfIframe'
				});
			}
			else
			{
				Ext.select('#pdfIframe').set( { src :  s_qryString });
			}
			Ext.Ajax.request(
			{
				url : '/final/monitor/EgSaveStatus.jsp',
				scope:this,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					if(!Ext.isEmpty(jsonData))
					{
						var downloadStatus = jsonData.downloadStatus;
						try
						{
							if(downloadStatus=='DONE' || downloadStatus == 'done' || downloadStatus=='Done')
							{
								progressBar.hide();
							}
						}
						catch (e)
						{
							progressBar.hide();
						}
					}
				},
				failure:function(response){
					progressBar.hide();
				}
			});
		}
		else
		{
			if(!Ext.isEmpty(noDataErrorMsg)){
				Ext.MessageBox.show({
					title : 'Alert',
					msg : 'No Records Found',
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING,
				});
			}
		}
	},
	saveInCSVFormat:function()
	{
		if(isDataAvailable)
		{
			window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?userSearch=Yes","CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
		}
		else
		{
			if(!Ext.isEmpty(noDataErrorMsg)){
				Ext.MessageBox.show({
					title : 'Alert',
					msg : 'No Records Found',
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING,
				});
			}
			return false;
		}
	},
	refreshSearchDetails : function()
	{				
		if(searchType == 'vm') //No need of refresh for VM search
			return;

		if (requestFrom!=null && (requestFrom == 'quickLinks' || requestFrom == 'MainDashboard'))
		{			
			var searchObj = window.parent.getSearchBoxObj();
			var searchCmbObj = window.parent.getSearchComboObj();			
			searchCmbObj.setValue(searchType);
			searchObj.setValue(searchvalue);
		}

		var param;
		var selValue = '';
		if(showSessionDetails && searchType == 'user')
		{
			if(!Ext.isEmpty(Ext.getCmp('typeCombo')) && Ext.getCmp('typeCombo') != undefined)
			{
				selValue = Ext.getCmp('typeCombo').getValue();
				selValue = encodeURI(selValue);
			}
		}
		
		if(!Ext.isEmpty(selValue) && selValue != null && selValue != undefined)
			param = genParams+"&componentType="+selValue;
		else
			param = genParams;

		var tline = Ext.getCmp("er_timeline").getValue();
		if((!Ext.isEmpty(genParams) && genParams!=null && genParams!=undefined && genParams.indexOf("eg_tbound")!=-1) && (!Ext.isEmpty(eg_stdate) && eg_stdate!=null && eg_stdate!=undefined))
		{
			param = param + "&eg_timeline="+tline+"&eg_stdate="+eg_stdate+"&eg_enddate="+eg_enddate +"&starthr="+starthr+"&endhr="+endhr+"&startmin_h="+startmin_h+"&endmin_h="+endmin_h;
		}
		if(currentPageNo>1)
			param = param +"&currentPageNo="+currentPageNo;

		var meController=this;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgSearchController',
			method:'POST',
			params: param,
			scope:this,
			async:false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					publicjsonData1 = Ext.decode(response.responseText);
					searchRes=publicjsonData1;
					var dataArraytoStore = publicjsonData1.SEARCH_DATA.DATA;
					if(!Ext.isEmpty(dataArraytoStore))
					{
						var searchGrid = Ext.getCmp('threshold1');
						if(!Ext.isEmpty(searchGrid))
						{
							searchGrid.getStore().getProxy().data = publicjsonData1.SEARCH_DATA.DATA;
							searchGrid.getStore().load();
							searchGrid.getView().refresh();
						}
					}
					else if(!Ext.isEmpty(searchRes.searchtree)){
						var vmSearchTreeGrid = Ext.getCmp('vmSearchTreeGrid');
						vmSearchTreeGrid.suspendEvents();
						vmSearchTreeGrid.setRootNode(searchRes.searchtree);
						vmSearchTreeGrid.resumeEvents();
						vmSearchTreeGrid.view.refresh();
					}
					else
					{
						var msgs= publicjsonData1.SEARCH_DATA.searchmessage;
						var resultPanelObj = Ext.getCmp('searchdetails');
						resultPanelObj.removeAll();
						resultPanelObj.add({
							xtype: 'container',
							id: 'searchid',
							margin: '200 0 10 0',
							//border: true,
							frame: true,
							style: {
								'text-align': 'center'
							},
							html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style=""></div><div style="font-size:12px">'+msgs+'! </div></td></tr></table>'
						});
						resultPanelObj.show();
					}
					
				}
			},
			failure : function(response){ 
				Ext.Msg.alert('Failed!','Sorry! Problem occured ');
			}
		});
	},
	loadDefaultSearchData : function()
	{
		var meC=this;
		var treeDataLen = -1;
		if (requestFrom!=null && (requestFrom == 'quickLinks' || requestFrom == 'MainDashboard'))
		{
			var searchObj = window.parent.getSearchBoxObj();
			var searchCmbObj = window.parent.getSearchComboObj();
			searchCmbObj.setValue(searchType);
			searchObj.setValue(searchvalue);
		}		
		var searchResData= searchRes.SEARCH_DATA;
		if(showVMMigration && searchType!=null && searchType=='vm')
		{
			treeDataLen=searchRes.searchtree.children.length;
		}
		if(Ext.isEmpty(searchResData['DATA']) || searchResData['DATA']==undefined || searchResData['DATA']==null)
			isDataAvailable = false;
		else 
			isDataAvailable = true;
		
		if(treeDataLen>0)
			isDataAvailable = true;
		
		Ext.getCmp('vmsearch').setTitle(searchResData['searchtitle']);
		if((!Ext.isEmpty(searchResData.isFromLayers) && searchResData.isFromLayers!=null && searchResData.isFromLayers!=undefined) && (!Ext.isEmpty(searchResData.dateTime) && searchResData.dateTime!=null && searchResData.dateTime!=undefined))
		{
			Ext.getCmp("er_stdate").setValue(searchResData.dateTime.eg_stdate);
			Ext.getCmp("er_enddate").setValue(searchResData.dateTime.eg_enddate);
			Ext.getCmp("er_sthr").setValue(searchResData.dateTime.start_hr);
			Ext.getCmp("er_endhr").setValue(searchResData.dateTime.end_hr);
		}

		var searchtypes=searchResData.searchtype;
		if (searchResData != undefined && !Ext.isEmpty(searchResData))
		{
			if(showVMMigration && searchtypes == 'vmsearch')
				this.loadTreeView(searchRes);
			else
				this.loadGrid(searchResData);
		} 		
		if(!Ext.isEmpty(Ext.getCmp('saveTool')) && Ext.getCmp('saveTool')!=null && Ext.getCmp('saveTool')!=undefined)
		{
			Ext.getCmp('saveTool').show();
			if(!Ext.isEmpty(Ext.getCmp('saveToolSeparator')))
				Ext.getCmp('saveToolSeparator').show();
		}
		if(!Ext.isEmpty(Ext.getCmp('csvTool')) && Ext.getCmp('csvTool')!=null && Ext.getCmp('csvTool')!=undefined)
		{
			Ext.getCmp('csvTool').show();
			if(!Ext.isEmpty(Ext.getCmp('csvToolSeparator')))
				Ext.getCmp('csvToolSeparator').show();
		} 		
	},
	loadTreeView: function(searchResData)
	{
		Ext.define('VMSearchTreeModel',{
			extend: 'Ext.data.Model',
			fields:searchResData.SEARCH_DATA.columns
		});
		
		var columnArray = [];
		columnArray.push({
			xtype: 'treecolumn',
			header:'Virtual Machine Name',
			dataIndex:'VMNAME',
			hideable : false,
			cls:'gridSkin',
			sortable:false,
			resizable:true,
			flex : 2,
			menuDisabled : true,
			renderer:function(value,metaData,record,rowIndex){
				var VMNAME_LINK_TEXT = value['VMNAME_LINK_TEXT'];
				var VMNAME_LINK_URL = value['VMNAME_LINK_URL'];
				if(!Ext.isEmpty(value))
					return '<a href='+VMNAME_LINK_URL+'>'+VMNAME_LINK_TEXT+'</a>';
			}
		},{
			header:'Server',
			//name:'comp_type',
			dataIndex:'VMCOMPNAME',
			sortable:false,
			flex : 1.5,
			menuDisabled : true,
			renderer:function(value,metaData,record,rowIndex){
				var VMCOMPNAME_LINK_TEXT = value['VMCOMPNAME_LINK_TEXT'];
				var VMCOMPNAME_LINK_URL = value['VMCOMPNAME_LINK_URL'];
				if(!Ext.isEmpty(value)){
					if(Ext.isEmpty(VMCOMPNAME_LINK_URL) || VMCOMPNAME_LINK_URL == undefined){
						VMCOMPNAME_LINK_URL = value['VMNAME_LINK_URL'];
						return '<a href='+VMCOMPNAME_LINK_URL+'>'+VMCOMPNAME_LINK_TEXT+'</a>';
					}
					else
						return '<a href="javascript:void(0);" onclick="javascript:clickURL(\''+VMCOMPNAME_LINK_URL+'\');">'+VMCOMPNAME_LINK_TEXT+'</a>';
				}
			}
		},{
			header:'Component type',
			dataIndex:'VMCOMPTYPE',
			flex : 1,
			menuDisabled : true,
			sortable:false,
			renderer:function(value,metaData,record,rowIndex){
				return value;
			}
		});
		if(searchResData.SEARCH_DATA.columns.indexOf("POWEREDON") > -1)
		{
			columnArray.push({
				header:'Powered on',
				dataIndex:'POWEREDON',
				flex : 0.5,
				sortable:false,
				resizable:true,
				//width:90,
				menuDisabled : true,
				//sortType:'AsUCString',
				renderer:function(value,metaData,record,rowIndex){
					var POWERED_LINK_TEXT = value['POWERED_LINK_TEXT'];
					var ptitle = value['POWERED_LINK_TITLE'];
					if(!Ext.isEmpty(value)){
						if(POWERED_LINK_TEXT=="Powered On")
							return '<div class="iconPoweredOn" style="margin:0px;width:20px;padding:0px;cursor:pointer" title=\''+ptitle+'\'></div>';
						else
							return '<div class="iconPoweredOff" style="margin:0px;width:20px;padding:0px;cursor:pointer" title=\''+ptitle+'\'></div>';
					}
				}
			});
		}
		columnArray.push({
			header:'Measurement time',
			dataIndex:'TIME',
			flex : 0.8,
			sortable:false,
			resizable:true,
			menuDisabled : true,
			//sortType:'AsUCString',
			renderer:function(value,metaData,record,rowIndex){
				return value;
			}
		},{
			header:'GRAPH',
			dataIndex:'VMGRAPH',
			name:'VMGRAPH',
			hideable : false,
			resizable:false,
			hideable : false,
			sortable:false,
			resizable:false,
			enableColumnHide : true,
			filter: false,
			menuDisabled : true,
			flex : 0.28,
			//width:30,
			bodyStyle:{'padding':'0px','margin':'0px'},
			baseStyle:{'padding':'0px','margin':'0px'},
			style:{'padding':'0px','margin':'0px'},
			margin:0,
			padding:0,
			renderer:function(value,metaData,record,rowIndex){
				var VMGRAPH_LINK_URL = value['VMGRAPH_LINK_URL'];
				var VMGRAPH_ALT = value['VMGRAPH_ALT'];
				metaData.tdAttr = "data-qtip="+"Graph"+' data-qclass=yellowTip'; 
				if(!Ext.isEmpty(value))
					return '<div class="iconLineChart" onClick=\'javascript:openInNewWin("'+VMGRAPH_LINK_URL+'");\' style="margin:0px;width:20px;padding:0px;cursor:pointer"></div>';
			}
		},{
			header:'DD',
			name:'VMDD',
			dataIndex:'VMDD',
			hideable : false,
			resizable:false,
			hideable : false,
			sortable:false,
			resizable:false,
			enableColumnHide : true,
			filter: false,
			menuDisabled : true,
			flex : 0.28,
			//width:30,
			bodyStyle:{'padding':'0px','margin':'0px'},
			baseStyle:{'padding':'0px','margin':'0px'},
			style:{'padding':'0px','margin':'0px'},
			margin:0,
			padding:0,
			renderer:function(value,metaData,record,rowIndex){
				var VMDD_LINK_URL= value['VMDD_LINK_URL'];//window.parent.callDrillDown();
				var VMDD_ALT= value['VMDD_ALT'];
				metaData.tdAttr = "data-qtip="+"Diagnosis"+' data-qclass=yellowTip';
				if(!Ext.isEmpty(value))
					return '<div class="iconDiagnosis" onClick=\'javascript:openDDInNewWin("'+VMDD_LINK_URL+'");\' style="margin:0px;width:20px;padding:0px;cursor:pointer"></div>';
			}
		});
		var searchTreeStore = Ext.create('Ext.data.TreeStore', {
			model: 'VMSearchTreeModel',
			autoLoad : false,
			remoteSort:true,
			batchUpdateMode:'complete',
			root : searchResData.searchtree,
		});

		var vmSearchTreeGrid = Ext.create('Ext.tree.Panel', {
			id: 'vmSearchTreeGrid',
			name: 'vmSearchTreeGrid',
			//renderTo: Ext.getBody(),
			useArrows: true,
			rootVisible: false,
			cls:'alarmTree',
			flex:1,
			style:{'border':'0px #000 solid !important'},
			margin:0,
			padding:0,
			frame:false,
			//forceFit:true,
			//height: 510,
			pageLimit:null,
			border: false,
			store: searchTreeStore,
			viewConfig: {
				listeners: {
					render: createTooltip,
					afteritemcollapse: function(node, index, item, eOpts)
					{
						  Ext.fly(item).removeCls('treeExpand');
						  Ext.fly(item).addCls('treeClose');
					},
					afteritemexpand: function(node, index, item, eOpts)
					{
						Ext.fly(item).addCls('treeExpand');
						Ext.fly(item).removeCls('treeClose');
					}
				}
			},
			dockedItems:[{
				dock: 'bottom',
				xtype:'toolbar',
				cls:'toolbar',
				id:'dockedPagnation',
				margin:'0',
				padding:'6 0 0 0',
				//bodyStyle: {background:'#b4b6bf'},
				items:[
					{
						xtype:'button',
						id:'pfirst',
						text:'',
						icon:'../images/'+skin+'/page-first.png',
						cls:'button10',
						labelWidth:50,
						padding:'4 2 2 2',
						margin:'0 0 0 0',
						width:20,
						listeners:{
							'click' : function(){
								var disp = Ext.getCmp("displayInfo");
								currentPageNo=1;
								var endInx = parseInt(recPerPage)*parseInt(currentPageNo);
								var startInx = endInx- parseInt(recPerPage);
								if(totalRecCount<endInx)
									endInx = totalRecCount;
								showVMSearchData(startInx,endInx,totalPages);
								var msg = "Displaying "+(startInx+1)+"-"+endInx+" of "+totalRecCount;
								disp.setText(msg);
								var ptot = Ext.getCmp("paginationTotals");
								ptot.setValue(currentPageNo);
								var first = Ext.getCmp("pfirst");
								var prev = Ext.getCmp("pprev");
								first.disabled=true;
								prev.disabled=true;
								if(parseInt(totalPages)>currentPageNo)
								{
									var next = Ext.getCmp("pnext");
									var last = Ext.getCmp("plast");
									next.disabled=false;
									last.disabled=false;
								}
							}
						}
					},
					{
						xtype:'button',
						text:'',
						id:'pprev',
						icon:'../images/'+skin+'/page-prev.png',
						cls:'button10',
						labelWidth:50,
						padding:'4 2 2 2',
						margin:'0 0 0 0',
						width:25,
						listeners:{
							'click' : function(){
								var disp = Ext.getCmp("displayInfo");
								currentPageNo=currentPageNo-1;
								var endInx = parseInt(recPerPage)*parseInt(currentPageNo);
								var startInx = endInx- parseInt(recPerPage);
								if(totalRecCount<endInx)
									endInx = totalRecCount;
								showVMSearchData(startInx,endInx,totalPages);
								var msg = "Displaying "+(startInx+1)+"-"+endInx+" of "+totalRecCount;
								disp.setText(msg);
								var ptot = Ext.getCmp("paginationTotals");
								ptot.setValue(currentPageNo);
								if(currentPageNo==1){
									var first = Ext.getCmp("pfirst");
									var prev = Ext.getCmp("pprev");
									first.disabled=true;
									prev.disabled=true;
								}
								if(parseInt(totalPages)>currentPageNo){
									var next = Ext.getCmp("pnext");
									var last = Ext.getCmp("plast");
									next.disabled=false;
									last.disabled=false;
								}
							}
						}
					},
					{
						xtype:'textfield',
						fieldLabel:'Page ',
						id:'paginationTotals',
						name:'goToPage',
						enableKeyEvents:true,
						value:totalPages,
						cls:'textbox',
						labelWidth:40,
						padding:'4 2 2 2',
						margin:'0 0 0 0',
						maxWidth:80
					},
						{
						xtype:'label',
						text:' of 0 ',
						id:'totalPg',
						labelWidth:50,
						padding:'4 2 2 2',
						margin:'0 0 0 0',
						maxWidth:60
					},
					{
						xtype: "tbseparator",
					},
					{
						xtype:'button',
						text:'',
						id:'pnext',
						icon:'../images/'+skin+'/page-next.png',
						cls:'button10',
						labelWidth:50,
						padding:'4 2 2 2',
						margin:'0 0 0 0',
						width:20,
						listeners:{
							'click' : function(){
								var disp = Ext.getCmp("displayInfo");
								currentPageNo=currentPageNo+1;
								var endInx = parseInt(recPerPage)*parseInt(currentPageNo);
								var startInx = endInx- parseInt(recPerPage);
								if(totalRecCount<endInx)
									endInx = totalRecCount;
								showVMSearchData(startInx,endInx,totalPages);
								var msg = "Displaying "+(startInx+1)+"-"+endInx+" of "+totalRecCount;
								disp.setText(msg);
								var ptot = Ext.getCmp("paginationTotals");
								ptot.setValue(currentPageNo);
								if(currentPageNo>1){
									var first = Ext.getCmp("pfirst");
									var prev = Ext.getCmp("pprev");
									first.disabled=false;
									prev.disabled=false;
								}
								if(parseInt(totalPages)==currentPageNo){
									var next = Ext.getCmp("pnext");
									var last = Ext.getCmp("plast");
									next.disabled=true;
									last.disabled=true;
								}
							}
						}
					},
							{
						xtype:'button',
						text:'',
						id:'plast',
						icon:'../images/'+skin+'/page-last.png',
						cls:'button10',
						labelWidth:50,
						padding:'4 2 2 2',
						margin:'0 0 0 0',
						width:20,
						listeners:{
							'click' : function(){
								var ptot = Ext.getCmp("paginationTotals");
								var disp = Ext.getCmp("displayInfo");
								currentPageNo = parseInt(totalPages);
								ptot.setValue(currentPageNo);
								var endInx = parseInt(recPerPage)*parseInt(currentPageNo);
								var startInx = endInx- parseInt(recPerPage);
								if(totalRecCount<endInx)
									endInx = totalRecCount;
								showVMSearchData(startInx,endInx,totalPages);
								var msg = "Displaying "+(startInx+1)+"-"+endInx+" of "+totalRecCount;
								disp.setText(msg);
								if(currentPageNo>1){
									var first = Ext.getCmp("pfirst");
									var prev = Ext.getCmp("pprev");
									first.disabled=false;
									prev.disabled=false;
								}
								if(parseInt(totalPages)==currentPageNo){
									var next = Ext.getCmp("pnext");
									var last = Ext.getCmp("plast");
									next.disabled=true;
									last.disabled=true;
								}
							}
						}
					},"->",
							{
						xtype:'label',
						text:'',
						id:'displayInfo',
						labelWidth:220,
						padding:'4 12 2 2',
						margin:'0 0 0 0',
						maxWidth:200
					}]
			}],
			columns:columnArray
		});

		totalPages = searchResData.SEARCH_DATA['totalPages'];
		recPerPage = searchResData.SEARCH_DATA['recPerPage'];
		var totalRecCount = searchResData.SEARCH_DATA['totalRecCount'];
		var ptot = Ext.getCmp("paginationTotals");
		var totalPg = Ext.getCmp("totalPg");
		ptot.setValue(currentPageNo);
		totalPg.setText(" of "+totalPages);
		
		if(totalPages==0){
			var disp = Ext.getCmp("displayInfo");
			disp.setText("");
			var dPage= Ext.getCmp("dockedPagnation");
			dPage.setVisible(false);
		}
		else{
			var dPage= Ext.getCmp("dockedPagnation");
			dPage.setVisible(true);
			var disp = Ext.getCmp("displayInfo");
			if(recPerPage==null || recPerPage=="")
				disp.setText("");
			else{
				var msg = "Displaying "+(""+1)+"-"+recPerPage+" of "+parseInt(totalRecCount);
				disp.setText(msg);		
			}
		}

		var first = Ext.getCmp("pfirst");
		var prev = Ext.getCmp("pprev");
		first.disabled=true;
		prev.disabled=true;

		if(parseInt(totalPages)==1)
		{
			var next = Ext.getCmp("pnext");
			var last = Ext.getCmp("plast");
			next.disabled=true;
			last.disabled=true;
		}

		var vmusersettingsobj=Ext.getCmp('vmusersettings');
		vmusersettingsobj.loadSettingsData();
		var settingTool={
			xtype:'settings'
		}
		Ext.getCmp('vmsearch').addTool(settingTool);

		var resultPanelObj;
		if(totalPages > 0){
			resultPanelObj = Ext.getCmp('searchdetails');
			resultPanelObj.removeAll();
			resultPanelObj.add(vmSearchTreeGrid);
			resultPanelObj.show();
			resultPanelObj.doLayout();
		}
		else{
			var msgs= searchResData.SEARCH_DATA['searchmessage'];
			resultPanelObj = Ext.getCmp('searchdetails');
			resultPanelObj.add({
				xtype: 'container',
				id: 'searchid',
				margin: '200 0 10 0',
				//border: true,
				frame: true,
				style: {
					'text-align': 'center'
				},
				html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style=""></div><div style="font-size:12px">'+msgs+'! </div></td></tr></table>'
			});
			resultPanelObj.show();
		}
	},
	loadGrid: function(searchResData)
	{	
		var resultPanelObj;
		var vmusersettingsobj=Ext.getCmp('vmusersettings');
		vmusersettingsobj.loadSettingsData();
		var columnDetails = searchResData.COLUMNS;
		var dataArraytoStore = searchResData.DATA;
		var searchtypes=searchResData.searchtype;
		var userdataperpage=searchResData.usersdetailsperpage;
		var cTypeOptions=searchResData.componentTypeOptions;
		if ( userdataperpage!=null && userdataperpage!='')
		{
			userdataperpage = parseInt(userdataperpage);
		}
		var fieldstoStore = new Array();
		var mainColumnsObjArray = new Array();
		var subColObjArray = new Array();
		var flexval;
		var alignmentval="left";

		if(showSessionDetails && searchType == 'user')
		{
			var viewPortWidth=Ext.getCmp('vmsearch').getWidth();
			var totColumns = searchResData.TOTAL_COLUMNS;
			var count = 0;
			for (var key in columnDetails)
			{
				subColObjArray = new Array();
				var mainColumn = key;
				var align='center';
				if (mainColumn=='User' || mainColumn=='Server')
				{
					align='left';
					flexval=1;
				}
				if (mainColumn==' Session Start Time' || mainColumn=='Logout / Disconnect Time' || mainColumn=='Logout')
				{
					flexval=0.8;
				}
				if (mainColumn == 'DD')
				{
					flexval=0.18;
				}
				if (mainColumn == 'Graph')
				{
					align='center';
					flexval=0.4;
				}
				if (mainColumn == 'Logout / Disconnect time'|| mainColumn == 'Logout')
				{
					flexval=1.0;
				}
				if (mainColumn == 'Duration' || mainColumn == 'Duration of Access')
				{
					flexval=0.5;
				}
				else if (mainColumn == 'Client Name' || mainColumn == 'Client Address' || mainColumn == 'Client Version')
				{
					flexval=0.7;
				}
				
				var subcolumn = columnDetails[key];
				var adujstedWidth = (viewPortWidth/totColumns);
				var gflex = totColumns;
				if(adujstedWidth <= 0)
					adujstedWidth=200;
				var dataidx = 'COLUMN_' + count;
				fieldstoStore.push(dataidx);
				if(!Ext.isEmpty(subcolumn)){
					mainColumn = mainColumn + '<div>'+subcolumn+'</div>';
				}
				mainColumnsObjArray.push({
					header: mainColumn,
					sortable:false,
					dataIndex: dataidx,
					align:align,
					flex:flexval,
					renderer:function(val,metaData,record,rowIndex)
					{
						if (!Ext.isEmpty(val['USERCOMPNAME_LINK_TEXT']) )
						{
							var USERCOMPNAME_LINK_TEXT= val['USERCOMPNAME_LINK_TEXT'];
							var USERCOMPNAME_LINK_URL= val['USERCOMPNAME_LINK_URL'];
							metaData.tdAttr = 'data-qtip="'+USERCOMPNAME_LINK_TEXT+'" data-qclass=yellowTip ';
							if(!Ext.isEmpty(USERCOMPNAME_LINK_URL))
								return '<a href="javascript:void(0);" onclick="javascript:clickURL(\''+USERCOMPNAME_LINK_URL+'\')">'+USERCOMPNAME_LINK_TEXT+'</a>';
							else
								return USERCOMPNAME_LINK_TEXT;

						}
						else if ( !Ext.isEmpty(val['USER_LINK_TEXT']) )
						{
							var USER_LINK_TEXT= val['USER_LINK_TEXT'];
							var USER_LINK_URL= val['USER_LINK_URL'];
							metaData.tdAttr = 'data-qtip="'+USER_LINK_TEXT+'" data-qclass=yellowTip ';
							return '<a href='+USER_LINK_URL+'>'+USER_LINK_TEXT+'</a>';
						}
						else if ( !Ext.isEmpty(val['USERDD_LINK_IMAGE']) )
						{
							var USERDD_LINK_URL= val['USERDD_LINK_URL'];
							metaData.tdAttr = 'data-qtip="'+diagnosisLbl+'" data-qclass=yellowTip ';
							return '<div class="iconDiagnosis" onClick=\'javascript:openDDInNewWin("'+USERDD_LINK_URL+'");\' style="margin:0px;width:20px;padding:0px;cursor:pointer"></div>';
						} 
						else if ( !Ext.isEmpty(val['USERGRAPH_LINK_IMAGE']) )
						{
							var USERGRAPH_LINK_URL= val['USERGRAPH_LINK_URL'];
							metaData.tdAttr = 'data-qtip="Graph" data-qclass=yellowTip ';
							return '<div class="iconLineChart" onClick=\'javascript:openInNewWin("'+USERGRAPH_LINK_URL+'");\' style="margin:auto;width:20px;padding:0px;cursor:pointer"></div>';
						} 
						else{
							//metaData.tdAttr = 'data-qtip="'+val+'" data-qclass=yellowTip ';
							return val;
						}
					},
				});
				count++;
			}
		}
		else
		{
			for (var key in columnDetails)
			{
				var mainColumn = columnDetails[key];
				if(mainColumn=="User/Virtual Desktops")
				{
					flexval=2;
				}
				/*if(mainColumn=="Connection type")
				{
					flexval=.8;
				}*/
				if(mainColumn=="Last access time")
				{
					flexval=1;
				} 
				if(mainColumn=="DD" && searchtypes=="usersearch")
				{
					flexval=.18;
				}
				if(mainColumn=="Graph" && searchtypes=="usersearch")
				{
					flexval=.28;
				} 
				if(mainColumn=="Server" &&  searchtypes=="usersearch")
				{
					flexval=1.5;
				}
				if(mainColumn=="Component type" &&  searchtypes=="usersearch")
				{
					flexval=1;
				} 
				if(mainColumn=="DD" && searchtypes=="vmsearch")
				{
					mainColumn="DD";
					flexval=.4;
				}
				if(mainColumn=="Graph" && searchtypes=="vmsearch")
				{
					flexval=.4;
				}
				if(mainColumn=="Server" &&  searchtypes=="vmsearch")
				{
					flexval=1.5;
				}
				if(mainColumn=="Component type" &&  searchtypes=="vmsearch")
				{
					flexval=0.8;
				} 
				if(mainColumn=="Powered on")
				{
					flexval=0.5;
				} 
				if(mainColumn=="Measurement time")
				{
					flexval=0.8;
				} 
				if(mainColumn=="Virtual Machine  Name")
				{
					flexval=2;
				}
					

				var dataidx = 'COLUMN_' + key;
				fieldstoStore.push(dataidx);
				mainColumnsObjArray.push({
					//header:'<h1 align=center>'+mainColumn+'</h1>',
					header:mainColumn,
					sortable: true,
					dataIndex: dataidx,
					align: 'left',
					renderer:function(val)
					{
						if ( !Ext.isEmpty(val['VMCOMPNAME_LINK_TEXT']) )
						{
							var VMCOMPNAME_LINK_TEXT = val['VMCOMPNAME_LINK_TEXT'];
							var VMCOMPNAME_LINK_URL= val['VMCOMPNAME_LINK_URL'];
							if(!Ext.isEmpty(VMCOMPNAME_LINK_URL))
								return '<a href="javascript:void(0);" onclick="javascript:clickURL(\''+VMCOMPNAME_LINK_URL+'\');">'+VMCOMPNAME_LINK_TEXT+'</a>';
							else
								return VMCOMPNAME_LINK_TEXT;
						}
						if ( !Ext.isEmpty(val['POWERED_LINK_TEXT']))
						{
							var POWERED_LINK_TEXT = val['POWERED_LINK_TEXT'];
							var ptitle = val['POWERED_LINK_TITLE'];
							if(POWERED_LINK_TEXT=="Powered On")
								return '<div class="iconPoweredOn" style="margin:0px;width:20px;padding:0px;cursor:pointer" title=\''+ptitle+'\'></div>';
							else
								return '<div class="iconPoweredOff" style="margin:0px;width:20px;padding:0px;cursor:pointer" title=\''+ptitle+'\'></div>';
						}
						else if ( !Ext.isEmpty(val['VMGRAPH_LINK_IMAGE']) )
						{
							var VMGRAPH_LINK_URL= val['VMGRAPH_LINK_URL'];
							var VMGRAPH_ALT= val['VMGRAPH_ALT'];
							return '<div class="iconLineChart" onClick=\'javascript:openInNewWin("'+VMGRAPH_LINK_URL+'");\' style="margin:0px;width:20px;padding:0px;cursor:pointer"></div>';
						}
						else if ( !Ext.isEmpty(val['VMDD_LINK_IMAGE']) )
						{
							var VMDD_LINK_URL= val['VMDD_LINK_URL'];//window.parent.callDrillDown();
							var VMDD_ALT= val['VMDD_ALT'];
							return '<div class="iconDiagnosis" onClick=\'javascript:openDDInNewWin("'+VMDD_LINK_URL+'");\' style="margin:0px;width:20px;padding:0px;cursor:pointer"></div>'; 
						}
						else if ( !Ext.isEmpty(val['VMUSER_LINK_TEXT']) )
						{
							var VMUSER_LINK_URL="";  
							var VMUSER_LINK_TEXT = val['VMUSER_LINK_TEXT'];
							if ( !Ext.isEmpty(val['VMUSER_LINK_URL']) )  
							{
								VMUSER_LINK_URL= val['VMUSER_LINK_URL'];
								return '<a href='+VMUSER_LINK_URL+'>'+VMUSER_LINK_TEXT+'</a>';
							}
							else
							{
								return VMUSER_LINK_TEXT;
							}
						}
						else if ( !Ext.isEmpty(val['USERDD_LINK_IMAGE']) )
						{
							var USERDD_LINK_URL= val['USERDD_LINK_URL'];
							
							return '<div class="iconDiagnosis" onClick=\'javascript:openDDInNewWin("'+USERDD_LINK_URL+'");\' style="margin:0px;width:20px;padding:0px;cursor:pointer"></div>';
						} 
						else if ( !Ext.isEmpty(val['USERGRAPH_LINK_IMAGE']) )
						{
							var USERGRAPH_LINK_URL= val['USERGRAPH_LINK_URL'];
							return '<div class="iconLineChart" onClick=\'javascript:openInNewWin("'+USERGRAPH_LINK_URL+'");\' style="margin:0px;width:20px;padding:0px;cursor:pointer"></div>';
						} 
						else if ( !Ext.isEmpty(val['USERCOMPTYPE_LINK_TEXT']) )
						{
							var USERCOMPTYPE_LINK_TEXT= val['USERCOMPTYPE_LINK_TEXT'];
							//var USERCOMPTYPE_LINK_URL= val['USERCOMPTYPE_LINK_URL'];
							//return '<a href="javascript:void(0);" onclick="javascript:clickURL(\''+USERCOMPTYPE_LINK_URL+'\');">'+USERCOMPTYPE_LINK_TEXT+'</a>';
							return '<div>'+USERCOMPTYPE_LINK_TEXT+'</div>';
						}
						else if ( !Ext.isEmpty(val['USERCOMPNAME_LINK_TEXT']) )
						{
							var USERCOMPNAME_LINK_TEXT= val['USERCOMPNAME_LINK_TEXT'];
							var USERCOMPNAME_LINK_URL= val['USERCOMPNAME_LINK_URL'];
							if(!Ext.isEmpty(USERCOMPNAME_LINK_URL))
								return '<a href="javascript:void(0);" onclick="javascript:clickURL(\''+USERCOMPNAME_LINK_URL+'\')">'+USERCOMPNAME_LINK_TEXT+'</a>';
							else
								return USERCOMPNAME_LINK_URL;
						}
						else if ( !Ext.isEmpty(val['USER_LINK_TEXT']) )
						{
							var USER_LINK_TEXT= val['USER_LINK_TEXT'];
							var USER_LINK_URL= val['USER_LINK_URL'];
							return '<a href='+USER_LINK_URL+'>'+USER_LINK_TEXT+'</a>';
						}
						else
						{
							return val;    
						}
					},

					flex:flexval,
				});
			}
		}
		var store = Ext.create('Ext.data.Store', {
			storeId: 'thresholdStore',
			pageSize:userdataperpage,
			fields:fieldstoStore,
			proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'json'
				}
			},
			data:dataArraytoStore,
			autoLoad : true	,
			remoteSort: true
		});
		var threshold1 = Ext.create('utilities.CustomGrid', {
			id: 'threshold1',
			name: 'threshold1',
			cls: 'gridSkin',
			flex:1,
			style:{'overflow-x':'hidden !important'},
			margin:0,
			padding:0,
			bodyPadding:0,
			frame:false,
			//forceFit:true,
			//height: 510,
			pageLimit:null,
			border: false,
			dockedItems:{
				xtype:'pagingtoolbar',
				cls:'pagingtoolbar',
				dock: 'bottom',
				displayInfo: true,
				cls:'pagingtoolbar',
				pageSize:userdataperpage,
				store:store,
				displayInfo: true,
				displayMsg: displayingTopicsLbl+' {0} - {1} '+ofLbl+' {2}',
				emptyMsg: "No topics to display"
			},
			store: store,
			columns:mainColumnsObjArray
		});
		if(!Ext.isEmpty(cTypeOptions) && !Ext.isEmpty(cTypeOptions.selectOptions))
		{
			var combo = new Ext.form.ComboBox({
				fieldLabel: cmpType,
				store: Ext.create('Ext.data.Store',{
					fields:['value','name'],
					proxy:{
						type: 'memory',
						reader: {
							type: 'json',
							root:'selectOptions'
						}
					},
					data:cTypeOptions.selectOptions
				}),
				labelWidth:110,
				cls : 'dropdown',
				id:'typeCombo',
				displayField:'name',
				labelSeparator:'',
				labelStyle:'padding:5px 0px 0px;text-align:right',
				margin:'0 5 0 0',
				valueField:'value',
				value: cTypeOptions.selectedValue,
				editable:false,
				listeners:{
					scope : this,
					'select': this.comboItemSelected
				}
			});
			Ext.getCmp('vmsearch').addTool(combo);
			var settingTool={
				xtype:'settings'
			}
			Ext.getCmp('vmsearch').addTool(settingTool);
		}
		else
		{
			var settingTool={
				xtype:'settings'
			}
			Ext.getCmp('vmsearch').addTool(settingTool);
		}
		if(!Ext.isEmpty(dataArraytoStore))
		{
			resultPanelObj = Ext.getCmp('searchdetails');
			//resultPanelObj.setTitle(searchResData.searchtitle);
			resultPanelObj.add(threshold1);
			resultPanelObj.show();
			resultPanelObj.doLayout();
		}
		else
		{
			var msgs= searchResData.searchmessage;
			resultPanelObj = Ext.getCmp('searchdetails');
			resultPanelObj.add({
				xtype: 'container',
				id: 'searchid',
				margin: '200 0 10 0',
				//border: true,
				frame: true,
				style: {
					'text-align': 'center'
				},
				html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style=""></div><div style="font-size:12px">'+msgs+'! </div></td></tr></table>'
			});
			resultPanelObj.show();
		}
		//resultPanelObj.doLayout();
	},
	loadSettingsWiseGrid: function()
	{
		var eg_tbound1;
		var timeLineComboObjval =Ext.getCmp('er_timeline').getValue();
		if(timeLineComboObjval!=null && timeLineComboObjval=="Any")
			eg_tbound="Any";
		else
			eg_tbound="Fixed";
		var startdateObjval = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDisplayDateFormat);
		var enddateObjval = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDisplayDateFormat);
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();  
		var startHourObjval=Ext.getCmp('er_sthr').dataArray;
		var endHourObjval =Ext.getCmp('er_endhr').dataArray;

		if(timeLineComboObjval!=null && timeLineComboObjval=="Any")
		{
			if(dateValidation(stDate,enDate,startHourObjval,endHourObjval,stmin,enmin) == -1)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'From date should be lesser than To date',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		
		var vmstateComboval =Ext.getCmp('vmstateCombo').getValue(); 

		var meController = this;
		var searchParams='',splitsearchval='';
		//splitsearchval=searchvalue.split(" ");		
		if(searchType.toLowerCase()=="vm")
		{    
			searchParams='searchuser='+searchType+" "+searchvalue+'&eg_timeline='+timeLineComboObjval+'&eg_stdate='+(Ext.getCmp('er_stdate').dataArray)+'&eg_enddate='+(Ext.getCmp('er_enddate').dataArray)+'&starthr='+startHourObjval+'&endhr='+endHourObjval+'&eg_tbound='+eg_tbound+'&state='+vmstateComboval+'&startmin_h='+stmin+'&endmin_h='+enmin;

		}
		if(searchType.toLowerCase()=="user")
		{    
			searchParams='searchuser='+searchType+" "+searchvalue+'&eg_timeline='+timeLineComboObjval+'&eg_stdate='+(Ext.getCmp('er_stdate').dataArray)+'&eg_enddate='+(Ext.getCmp('er_enddate').dataArray)+'&starthr='+startHourObjval+'&endhr='+endHourObjval+'&eg_tbound='+eg_tbound+'&startmin_h='+stmin+'&endmin_h='+enmin;
		}
		genParams = searchParams;		
		var typeComObj = Ext.getCmp('typeCombo');
		var selVal = '';
		if(!Ext.isEmpty(typeComObj) && typeComObj!=null && typeComObj!=undefined)
			selVal = typeComObj.getValue();
		if(!Ext.isEmpty(selVal) && selVal!=null && selVal!=undefined)
			searchParams = searchParams+"&componentType="+selVal;
		var eventsPerPageObj = Ext.getCmp("eventsPerPage");
		var eventsPerPageVal = '';
		if(!Ext.isEmpty(eventsPerPageObj) && eventsPerPageObj!=null && eventsPerPageObj!=undefined)
		{
			eventsPerPageVal = eventsPerPageObj.getValue();
			searchParams = searchParams + '&eventsPerPage='+eventsPerPageVal;
		}
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgSearchController',
			method:'POST',
			params: searchParams,
			scope:this,
			async:false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{					
					publicjsonData1 = Ext.decode(response.responseText);
					searchRes=publicjsonData1;
					for (var i=0;i<Ext.getCmp('vmsearch').tools.length ;i++ )
					{
						Ext.destroy(Ext.getCmp('vmsearch').tools[i]);
					}
					var srchDetailsObj = Ext.getCmp('searchdetails');
					srchDetailsObj.removeAll();
					meController.loadDefaultSearchData();
					Ext.get('configMod').animate({duration: 700,to: {y: -200}});
				}
			},
			failure : function(response)
			{ 
				Ext.Msg.alert('Failed!','Sorry! Problem occured ');
			}

		});
	},
	comboItemSelected:function(comboItem){
		var selValue = comboItem.getValue();
		selValue = encodeURI(selValue);

		var param = genParams+"&componentType="+selValue;
		if(!Ext.isEmpty(eg_timeline) && eg_timeline!=null && eg_timeline!=undefined)
			param = param + "&eg_timeline=" + eg_timeline;
		if((!Ext.isEmpty(genParams) && genParams!=null && genParams!=undefined && genParams.indexOf("eg_tbound")!=-1) && (!Ext.isEmpty(eg_stdate) && eg_stdate!=null && eg_stdate!=undefined ))
		{
			param = param + "&eg_stdate="+eg_stdate+"&eg_enddate="+eg_enddate +"&starthr="+starthr+"&endhr="+endhr+"&startmin_h="+startmin_h+"&endmin_h="+endmin_h;
		}
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgSearchController',
			method:'POST',
			scope:this,
			params: param,
			success: function(response){
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					publicjsonData1 = Ext.decode(response.responseText);
					searchRes=publicjsonData1;
					for (var i=0;i<Ext.getCmp('vmsearch').tools.length ;i++ )
					{
						Ext.destroy(Ext.getCmp('vmsearch').tools[i]);
					}
					var srchDetailsObj = Ext.getCmp('searchdetails');
					srchDetailsObj.removeAll();
					this.loadDefaultSearchData();
				}
			},
			failure:function(){
				Ext.Msg.alert('Failed!','Sorry! Problem occured ');
			}
		});
	}
});

function createTooltip(view) {
	view.tip = Ext.create('Ext.tip.ToolTip', {
		target: view.el,
		width:'60%',
		shadow:'frame',
		cls:'tableToolTip',
		traceMouse:true,
		shadowOffset:30,
		margin:'0',
		padding:'0',
		//autoHide:false,
		delegate: view.itemSelector,
		traceMouse: false,
		anchor: 'top',
		listeners:{
			beforeshow:function(tip){
				var htmlContent = tip.html;
				if(Ext.isEmpty(htmlContent))
					return false;
			}
		}
	});
}

function showVMSearchData(startIdx,endIdx,totalPages){
		Ext.Ajax.request({
			url:'/final/monitor/eGVMMigrationJSON.jsp?from=pagination'+'&startIdx='+startIdx+'&endIdx='+endIdx+'&totalPages='+totalPages+'&searchvalue='+searchvalue+'&searchtype='+searchType+'&state='+state+'&eg_tbound='+eg_tbound,
			method:'POST',
			scope:this,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText)){
					var jsonData = Ext.decode(response.responseText);
					searchRes = jsonData;
					if(!Ext.isEmpty(searchRes.searchtree)){
						var vmSearchTreeGrid = Ext.getCmp('vmSearchTreeGrid');
						vmSearchTreeGrid.suspendEvents();
						vmSearchTreeGrid.setRootNode(searchRes.searchtree);
						vmSearchTreeGrid.resumeEvents();
						vmSearchTreeGrid.view.refresh();
					}
				}
			}
		});
	}
