jQuery.getScript("/final/scripts/utilities/EgChartTheme.js");
var myImgHtml = '<div style="margin:12% 0 auto 25%"><img class="iconInformation" width="70%" src="/final/images/clear.png" border="0" /></div>';
var MaxImgHtml = '<center><div style="margin:12% 0 auto 0%"><img class="iconInformation" src="/final/images/clear.png" border="0" /></div></center>';
var errImgSrc = '<img class="iconInformation" src="/final/images/clear.png" border="0" />';
function getFormat(str,valign)
{
	//var retrunvar = this.name;
	//var str = retrunvar;
	if(valign == 'middle')
	{
		var toolTextStr = '';
		if(str.length >=20)
		{
			//String tmpStr=str.substring(0,50)+"...";
			//valueStr=tmpStr;
			toolTextStr=str.substring(0,20);
			var tempToolTextStr=str.substring(20);
			tempToolTextStr = tempToolTextStr.trim();
			while(tempToolTextStr.length >20)
			{
				toolTextStr=toolTextStr+"<br>"+tempToolTextStr.substring(0,20);
				tempToolTextStr=tempToolTextStr.substring(20);
			}
			toolTextStr=toolTextStr+"<br>"+tempToolTextStr;
		}
		else
			toolTextStr = str;
	}
	else
		toolTextStr = str;

	return toolTextStr;
}
/**
     * Highcharts plugin for setting a lower opacity for other series than the one that is hovered
     * in the legend
     */
(function (Highcharts) {
	var each = Highcharts.each;
	
	Highcharts.wrap(Highcharts.Legend.prototype, 'renderItem', function (proceed, item) {
		
		
		proceed.call(this, item);
		
		var series = this.chart.series,
			element = item.legendGroup.element;
		
		element.onmouseover = function () {
		   each(series, function (seriesItem) {
				if (seriesItem !== item) {
					each(['group', 'markerGroup'], function (group) {
						seriesItem[group].attr('opacity',1); // hover changes in EMD // 0.001-pie
					});
				}
			});
		}
		element.onmouseout = function () {
		   each(series, function (seriesItem) {
				if (seriesItem !== item) {
					each(['group', 'markerGroup'], function (group) {
						seriesItem[group].attr('opacity', 1);
					});
				}
			});
		}           
		
	});
}(Highcharts));

(function(b,a){
	if(!b){return}
	var c=b.Chart.prototype,d=b.Legend.prototype;
	b.extend(c,{
		legendSetVisibility:function(h){
			var i=this;
			var k=i.legend,e,g,j;
			var m=i.options.legend,f,l;
			if(m.enabled==h)
				{return}
				m.enabled=h;
			if(!h){
				d.destroy.call(k);
				e=k.allItems;
				if(e){
					for(g=0,j=e.length;g<j;++g)
						{e[g].legendItem=a}
					}
					k.group={}
				}
				c.render.call(i);
				if(!m.floating){
					f=i.scroller;
					if(f&&f.render){
						l=i.xAxis[0].getExtremes();
						f.render(l.min,l.max)
					}
				}
				jQuery('.highcharts-legend-item rect').attr('height', '8').attr('y', '5');
				jQuery('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
		},
		legendHide:function(){

			this.legendSetVisibility(false)
		},legendShow:function(){
			this.legendSetVisibility(true)
		},
		legendToggle:function(){
				jQuery('.highcharts-legend-item rect').attr('height', '8').attr('y', '5');
				jQuery('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
			if( Ext.isEmpty(this.options) )
			{
				jQuery('.highcharts-legend').show();
			}
			else
				this.legendSetVisibility(this.options.legend.enabled^true);
		}
	})
	
}(Highcharts));

// Plugin for displaying value information in the legend
(function (H) {
	H.Chart.prototype.reflow = function () {
		var chart = this,
			renderTo = chart.renderTo;
		Ext.EventManager.onWindowResize(function () {
			var panelWidth = jQuery(renderTo).width();
			var width =  jQuery(renderTo).outerWidth();
			var height = chart.chartHeight;
			if( width > 80 )
			{
				if( width > 100 )
					width = ( width == panelWidth || (( width - 5 ) <= panelWidth))? (width -50):(width-30);
				else
				{
					width = ( Ext.isEmpty(chart.options.chart))?200:chart.options.chart.width;
					//height = ( Ext.isEmpty(chart.options.chart))?180:chart.options.chart.height;
				}
				if (chart.container) { // It may have been destroyed in the meantime (#1257)
					chart.setSize(width, height, false);
				}
				chart.containerWidth = width;
				//chart.containerHeight = height;
			}
			else
			{
				//height = chart.chartHeight;
				width = chart.chartWidth;
				if (chart.container) { // It may have been destroyed in the meantime (#1257)
					chart.setSize(width, height, false);
				}
				chart.containerWidth = width;
				//chart.containerHeight = height;
			}
		});
	};
}(Highcharts));


function elipseTitle(title,charLen)
{
	if(title!=null )
	{
		//var charLen = 25;
		if( title.length > charLen )
		{
			var val2=title.substring(charLen);
			if(val2.length>3)
				title=title.substring(0,charLen)+'...'
		}
	}
	return title;
}
// currentDate format in tooltip of HighStockCharts
function tooltipDateFormate(currentDateFormat )
{
	var cdf = currentDateFormat;
	var toolTipFmt = "";
	//Tooltip date format using current date format of Manager
	if(cdf != 'null' && cdf != 'undefined' && cdf !='' && cdf != undefined)
	{
		cdf = cdf.toLowerCase();
		var symbol = ' ';
		var arrValue = new Array();
		if(cdf.indexOf("-") > -1)
		{
			symbol = '-';
		}else if(cdf.indexOf("/") > -1)
		{
			symbol = '/';
		}else if(cdf.indexOf(".") > -1)
		{
			symbol = '.';
		}
		var aValue = cdf.split(symbol);
		if (aValue !=null && aValue.length >0)
		{
			for (var v = 0; v < aValue.length; v++)
			{
				var value= aValue[v];
				var output = value;
				if(value!=null && value.indexOf("d")>-1)
				{
					if(value!=null && value == "d")
						output = '%e';
					else if(value!=null && value == "dd")
						output = '%d';
					else if(value!=null && value == "dd,")
						output = '%d,';

				}else if (value!=null && value.indexOf("m")>-1)
				{
					if(value!=null && value=="m")
						output = '%m';
					else if(value!=null && value=="mm")
						output = '%m';
					else if(value!=null && value=="mmm")
						output = '%b';

				}else if (value!=null && value.indexOf("y")>-1)
				{
					if(value!=null && value=="yy")
						output = '%y';
					else if(value!=null && value=="yyyy")
						output = '%Y';
				}
				arrValue[v]=output;
			}
		}
		if (arrValue !=null && arrValue.length >0)
		{
			for (var v = 0; v < arrValue.length; v++)
			{
				toolTipFmt += arrValue[v]+symbol;
			}
			if(toolTipFmt!=null && endsWith(toolTipFmt,symbol) && !(cdf!=null && endsWith(cdf,symbol)))
				toolTipFmt = toolTipFmt.substring(0,toolTipFmt.lastIndexOf(symbol));
			toolTipFmt = toolTipFmt+" %H:%M:%S";
		}
	}
	return toolTipFmt;
}
function getTimeLineOutputFormat(s_time)
{
	var return_s_time_fout ='';
	if(s_time != 'null' && s_time !='')
	{
		s_time = s_time.toLowerCase();
		var symbol = ' ';
		var arrValue = new Array();
		if(s_time.indexOf("-") > -1)
		{
			symbol = '-';
		}else if(s_time.indexOf("/") > -1)
		{
			symbol = '/';
		}else if(s_time.indexOf(".") > -1)
		{
			symbol = '.';
		}
		var aValue = s_time.split(symbol);
		if (aValue !=null && aValue.length >0)
		{
			for (var v = 0; v < aValue.length; v++)
			{
				var value= aValue[v];
				var output = value;
				if(value!=null && value.indexOf("d")>-1)
				{
					if(value!=null && value == "d")
						output = '%e';
					else if(value!=null && value == "dd")
						output = '%d';
					else if(value!=null && value == "dd,")
						output = '%d,';

				}else if(value!=null && value.indexOf("m")>-1)
				{
					if(value!=null && value=="m")
						output = '%m';
					else if(value!=null && value=="mm")
						output = '%m';
					else if(value!=null && value=="mmm")
						output = '%b';
				}else if (value!=null && value.indexOf("y")>-1)
				{
					if(value!=null && value=="yy")
						output = '%y';
					else if(value!=null && value=="yyyy")
						output = '%Y';
				}
				if (value == 'hh:mm' || value == 'hh:mm:ss' )
				{
					output = '  ';
				}
				arrValue[v]=output;
			}
		}
		if (arrValue !=null && arrValue.length >1)
		{
			for (var v = 0; v < arrValue.length; v++)
			{
				return_s_time_fout += arrValue[v]+symbol;
			}
			if(return_s_time_fout!=null && endsWith(return_s_time_fout,symbol))
				return_s_time_fout = return_s_time_fout.substring(0,return_s_time_fout.lastIndexOf(symbol));
			return_s_time_fout = return_s_time_fout+"%H:%M";
		}else
			return_s_time_fout='%H:%M';
	}
	return return_s_time_fout;
}

function endsWith(str, suffix) {
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
}
function getOption(chartTimeline,starttime,starthr,endtime,endhr)
{
	var strtdt = Ext.Date.dateFormat(starttime, 'm/d/Y');
	var enddt = Ext.Date.dateFormat(endtime,'m/d/Y');
	//enddt = Ext.Date.dateFormat(endDateObj, 'MM/dd/yyyy');
	strtdt = (Ext.isEmpty(strtdt))?starttime:strtdt;
	enddt = (Ext.isEmpty(enddt))?endtime:enddt;
	var tmp_s_start_time = strtdt+" "+starthr+":00:00";
	var tmp_s_end_time = enddt+" "+endhr+":00:00";
	var ctline = chartTimeline.substring(chartTimeline.indexOf(" ")+1);
	var durVal  = chartTimeline.substring(0,chartTimeline.indexOf(" "));
	var durUnit = chartTimeline.substring(chartTimeline.indexOf(" ")+1);
	var tline = getDateInfoDifference(tmp_s_start_time,tmp_s_end_time,ctline);
	var duraVal = parseInt(durVal);
	var durationVal = parseInt(tline);
	var chartOpt = (durationVal <= duraVal)?"highcharts":"graph";
	return chartOpt;
}
function getDateInfoDifference(startDate,endDate,outputFormat)
{
	if(!Ext.isEmpty(startDate) && !Ext.isEmpty(endDate))
	{
		//var stdate2 = Ext.Date.format(startDate,'d/m/Y');
		//var endate2 = Ext.Date.format(endDate,'d/m/Y');
		/*if(Ext.isEmpty(stdate2) && Ext.isEmpty(endate2))
		{
			stdate2 = startDate
			endate2 = endDate
		}*/
		//endDate = Ext.Date.format(endDate,'m/d/Y');
		var start_date = new Date(startDate);
		var end_date = new Date(endDate);
		var calendar1 = new Date(start_date.getFullYear()+1900,start_date.getMonth(), start_date.getDate(),start_date.getHours(),start_date.getMinutes(),start_date.getSeconds());
		var calendar2 = new Date(end_date.getFullYear()+1900, end_date.getMonth(), end_date.getDate(),end_date.getHours(),end_date.getMinutes(),end_date.getSeconds());
		var milliseconds1 = calendar1.getTime();
		var milliseconds2 = calendar2.getTime();
		var diff = milliseconds2 - milliseconds1;
		var diffSeconds = diff / 1000;
		var diffMinutes = diffSeconds / 60;
		var diffHours = diffMinutes / 60;
		var diffDays = diffHours / 24;
		var diffWeeks = diffDays / 7;
		if(outputFormat!=null && outputFormat == "milliseconds")
		{
			return diff;
		}
		else if(outputFormat!=null && outputFormat == "seconds")
		{
			return diffSeconds;
		}
		else if(outputFormat!=null && outputFormat == "minutes")
		{
			return diffMinutes;
		}
		else if(outputFormat!=null && outputFormat == "hours")
		{
			return diffHours;
		}
		else if(outputFormat!=null && outputFormat == "days")
		{
			return diffDays;
		}
		else if(outputFormat!=null && outputFormat == "weeks")
		{
			return diffWeeks;
		}
		else
		{
			return diffDays;
		}
	}
}
function getHighCharts(container_Id,chartHeight,chartWidth,maxURL){
	var drawChart = true;
	var resizeObj;
	var idSelect = false;
	var showLegs = false;
	var HighStockChart = {
		highchart: null,
		defaults: {
			chart: {
				plotBorderWidth: 0,
				plotBorderColor : '#C0C0C0',
				backgroundColor:'#ffffff',
				plotBackgroundColor: 'white',
				ignoreHiddenSeries:false,
				spacing:[20, 5, 0, 5],
				plotShadow: false,
				shadow: false,
				zoomType:'x',
				width:chartWidth,
				height:chartHeight,
				backgroundColor: 'transparent',
				events: {
					load: function(event) {
						// modify the legend symbol from a rect to a line
						jQuery('.highcharts-legend-item rect').attr('height', '8').attr('y', '5');
						jQuery('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
					}
				}
			},
			rangeSelector: {
				enabled: false
			},
			global: {
				useUTC: true,
				timezoneOffset:timeZoneOffsetVal
			},
			lang:{
				contextButtonTitle:'Print/Download Chart'
			},
			navigator: {
				enabled: false
			},
			yAxis: {
				border :0,
				min: 0,
				lineWidth: 0,
				gridLineWidth: 1,
				tickPixelInterval: 50,
				labels: {
					
					formatter: function() {
						return (this.value > 0 ? ' ' : '') + this.value ;
					},
					style: {
						color : 'black',
						fontFamily: 'Calibri',
						fontSize: '12px',
						textDecoration: 'none',
						whiteSpace: 'normal',
					},
				},
				showLastLabel: true,
			},
			plotOptions: {
				series: {
					states: {
					hover: {
						enabled: true,
						lineWidth: 2,
					}
				},
				connectNulls : false,
				smoothed: true,
				lineWidth: 2,
				marker: {
						enabled: false
					}
				},
				line: {
					shadow: false,
					linewidth :10
				}
			},
			scrollbar: {
				enabled: false
			},
			legend: {
				verticalAlign: 'top',
				align:'center',
				layout: 'horizontal',
				borderWidth: 0,
				y:5,
				//x:5,
				//width: 300,
				adjustChartSize: false,
				navigation: {
					arrowSize: 5
				},
				itemStyle: {
					color : 'black',
					fontFamily: 'Calibri',
					fontSize: '12px',
				},
				symbolWidth: 15
			},
			labels :{
				itemStyle: {
					color : 'black',
					fontFamily: 'Calibri',
					fontSize: '12px',
				}
			},
			tooltip: {
				shared: true,
				borderColor: 'black',
				valueDecimals: 4,
				style: {
					color : 'black',
					padding: 10,
					fontWeight:'500',
					fontFamily: 'Arial',
					fontSize: '11px',
				}
			},
			exporting: {
				enabled: false,
				chartOptions:{
					title:{
						text:''
					}
				}
			},
			credits: {
				enabled: false
			},
			xAxis: {
				border :1,
				lineWidth: 1,
				minPadding:0.02,
				maxPadding:0.02,
				type: 'datetime',
				ordinal: false,
				labels: {
					rotation:270,
					style: {
						color : '#c0c0c0',
						fontFamily: 'Arial',
						fontSize: '10px',
					},
					overflow: 'justify',
					showLastLabel: true,
					endOnTick: true,
					showFirstLabel: false,
					startOnTick: false,
					useHTML: false,
					tickPixelInterval: 75,
				},
				title: {
					enabled: true,
					offset: ''
				}
			},
			series: {
				marker: {
                enabled: false,
				 states: {
                    hover: {
                        enabled: true,
						lineWidthPlus:0,
                    }
                }},
				dataGrouping:{
					enabled: false
				}
			}
		},
		setData: function(jsonData,currentDateFormat,maxURL,isAxisTimeReq,legendPos) {
			var axisDefaultFamily = "Arial";
			var axisDefaultColor = "#c0c0c0";
			var axisDefaultSize = "11";
			var axisDefaultWeight = "500";
			var toolTipFmt = '';
			var chartType = 'line';
			var contextBtnColor = (strSkin == 'Light')?"#f7f7f7":'#828282';
			var lineChartStyleAttrbs=new Object();
			lineChartStyleAttrbs['titleFontFamily']='Arial';
			lineChartStyleAttrbs['titleFontSize']='12px';
			lineChartStyleAttrbs['titleFontClr']='#333333';
			lineChartStyleAttrbs['titleFontWgt']='500';
			lineChartStyleAttrbs['axisFontFamily'] = 'Arial';
			lineChartStyleAttrbs['axisFontClr'] = '#c0c0c0';
			lineChartStyleAttrbs['axisFontSize'] = '10px';
			lineChartStyleAttrbs['axisFontWgt'] = 'normal';
			//For legend labels
			lineChartStyleAttrbs['legFontFamily'] = 'Arial';
			lineChartStyleAttrbs['legFontClr'] = '#2a292a';
			lineChartStyleAttrbs['legFontSize'] = '10px';
			lineChartStyleAttrbs['legFontWgt'] = 'normal';

			var chartFileName = jsonData['chartFileName'];
			var mgrDateObj = new Date();
			var currentMgrDate = Ext.Date.format(mgrDateObj,'m.d.Y.H.i.s');
			toolTipFmt = tooltipDateFormate(currentDateFormat);
			var timeline_out_format = '';
			ymax = jsonData['max'];
			ymin = 0;
			var isHtmlTooltip = (Ext.isEmpty(jsonData['useHtml']))?false:jsonData['useHtml'];
			fontFamily = jsonData['fontName'];
			fontSize = jsonData['fontsize'];
			startTime = jsonData['xmin'];
			LegendPosition = jsonData['legendPosition'];
			xLabel = jsonData['axislabel'];
			LegendFont = jsonData['LegendFont'];
			xAxisDisplay = jsonData['xAxisDisplay'];
			var s_time_fout = jsonData['fmts'];
			fontFamily="Arial";
			LegendFont="Arial";
			xLabel =(xLabel == null || xLabel == '')?'':xLabel;
			fontFamily =(fontFamily == null || fontFamily == '')?"Arial":fontFamily;
			fontSize =(fontSize == null || fontSize == '')?'11px':fontFamily+"px";
			startTime =(startTime == null || startTime == '')?null:startTime;
			LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
			LegendFont =(LegendFont == null || LegendFont == '')?"Arial":LegendFont;
			s_time_fout =(s_time_fout == null || s_time_fout == '')?'HH:mm':s_time_fout;
			timeline_out_format = getTimeLineOutputFormat(s_time_fout);
			legendWidth = (LegendPosition == 'right')?150:300;
			maxLegendHeight = (LegendPosition == 'right')?null:50;
			valign = (LegendPosition == 'right')?'middle':'top';
			legendLayout = (LegendPosition == 'right')?'vertical':'horizontal';
			isThresholdLine = ( !Ext.isEmpty( jsonData['isThresholdComparison'] ))?jsonData['isThresholdComparison']:false;
			chartTitle = jsonData['title'];
			enableExport = true;
			lessWidth = 55;
			var isServiceBusDash = jsonData['isServiceBusDash'];
			var isFromRUM = jsonData['isFromRUM'];
			isHtmlTooltip = ( jsonData['DataSet'].length > 10 )?true:false;

			if(isFromRUM == undefined || !isFromRUM )
				ymax = ( !isThresholdLine && ymax == 0 )?1:null;
			var axisNameFamily = "",axisNameColor="",axisNameSize = "",axisNameWeight="",timeNameFamily="",timeNameColor="",timeNameSize="",timeNameWeight="";
			if( !Ext.isEmpty(jsonData['styles']) )
			{
				 var stylesJson = jsonData['styles'];
				if(!Ext.isEmpty(stylesJson['axisLabelStyle']))
				{
					axisNameFamily = stylesJson['axisLabelStyle'].FAMILY;
					axisNameColor = stylesJson['axisLabelStyle'].COLOR;
					axisNameSize = stylesJson['axisLabelStyle'].SIZE;
					axisNameWeight = stylesJson['axisLabelStyle'].WEIGHT;
				}
				if( !Ext.isEmpty( stylesJson['timeLabelStyle'] ))
				{
					lineChartStyleAttrbs['axisFontFamily'] = stylesJson['timeLabelStyle'].FAMILY;
					lineChartStyleAttrbs['axisFontClr'] = stylesJson['timeLabelStyle'].COLOR;
					lineChartStyleAttrbs['axisFontSize'] = stylesJson['timeLabelStyle'].SIZE;
					lineChartStyleAttrbs['axisFontWgt'] = stylesJson['timeLabelStyle'].WEIGHT;
				}
				if( !Ext.isEmpty( stylesJson['titleSty'] ))
				{
					lineChartStyleAttrbs['titleFontClr'] = stylesJson['titleSty'].COLOR;
					lineChartStyleAttrbs['titleFontFamily'] = stylesJson['titleSty'].FAMILY;
					lineChartStyleAttrbs['titleFontSize'] = stylesJson['titleSty'].SIZE;
					lineChartStyleAttrbs['titleFontWgt'] = stylesJson['titleSty'].WEIGHT;
				}
				if( !Ext.isEmpty( stylesJson['legendSty'] ))
				{
					lineChartStyleAttrbs['legFontFamily'] = stylesJson['legendSty'].FAMILY;
					lineChartStyleAttrbs['legFontClr'] = stylesJson['legendSty'].COLOR;
					lineChartStyleAttrbs['legFontSize'] = stylesJson['legendSty'].SIZE;
					lineChartStyleAttrbs['legFontWgt'] = stylesJson['legendSty'].WEIGHT;
				}
				plotPanelColor = ( !Ext.isEmpty( jsonData['styles']['panelLineStyle'] ))?jsonData['styles']['panelLineStyle'].COLOR:"#C0C0C0";
			}
			else
			{
				plotPanelColor="#C0C0C0";
			}
			
			xlineWidth = 1;
			xGridLineWidth = 1;
			ylineWidth = 1;
			yGridLineWidth = 0;
			if (isThresholdLine)
			{
				ylineWidth = 1;
				yGridLineWidth = 0;
				xlineWidth = 1;
				xGridLineWidth = 1;
			}
			axisNameFamily = ( Ext.isEmpty( axisNameFamily ) )?axisDefaultFamily:axisNameFamily;
			axisNameColor = ( Ext.isEmpty( axisNameColor ) )?axisDefaultColor:axisNameColor;
			axisNameSize = ( Ext.isEmpty( axisNameSize ) )?axisDefaultSize:axisNameSize;
			axisNameWeight = ( Ext.isEmpty( axisNameWeight ) )?axisDefaultWeight:axisNameWeight;

			var bgcolor='rgba(255, 255, 255, 0.85)';
			var legendSize = jsonData['DataSet'].length;
			var seriesCounter = jsonData['DataSet'].length;
			bgcolor= ( legendSize== 1 )?jsonData['DataSet'][0]['color']:bgcolor;
			var xVal = (legendSize<=2)?200:0;
			var exportTitle = jsonData['exportTitle'];
			var enableTitle = false;
			enableTitle = jsonData['enableTitle'];
			chartTitle = (enableTitle)?jsonData['title']:'';
			var isTabsetPage = (!Ext.isEmpty(jsonData['isTabsetPage']))?jsonData['isTabsetPage']:false;
			var ytitle = (!Ext.isEmpty(jsonData['rumAxisTitle']))?jsonData['rumAxisTitle']:'';
			var rumPage = (!Ext.isEmpty(jsonData['rumLine']))?true:false;
			var fromPageVal = '';
			if(!Ext.isEmpty(jsonData['fromPage']))
				fromPageVal = jsonData['fromPage'];
			var seumLegend = ( fromPageVal == 'seum' )?true:false;
			if(legendPos == "bottom")
			{
				valign = 'middle';
				y=5;
				legendWidth = 100
				enableExport = false;
				legendLayout = "right";
				LegendPosition = "center";
				maxLegendHeight = 20;
				var splitStr = chartTitle.split(":");
				if(splitStr!=null && splitStr!=undefined && splitStr.length>0)
				{
					chartTitle = chartTitle.substring(chartTitle.lastIndexOf(":")+1);
				}
			}
			if(Ext.isEmpty(exportTitle))
				exportTitle = chartTitle;
			chartFileName = (Ext.isEmpty(chartFileName))?exportTitle:chartFileName;
			chartFileName = chartFileName+" "+currentMgrDate;
			/*if ( !Ext.isEmpty( jsonData['fromPage'] ) && jsonData['fromPage'] == "DescComparison" ) 
			{
				var testDesc = chartTitle.substring(chartTitle.indexOf("Test :"));
				var titleComp = chartTitle.substring(0,chartTitle.indexOf("Descriptor"));
				chartTitle = titleComp+testDesc;
			}*/
			if(legendSize <= 3)
			{
				valign = 'top';
				y=(Ext.isEmpty(jsonData['smallGraph']))?5:0;
				if(legendPos == "bottom")
				{
					legendWidth = 200;
					 xVal = (legendSize<=2)?100:0;
				}
				else
				{
					legendWidth = 500;
					xVal = 200;
				}

				LegendPosition = 'center';
				legendLayout = 'horizontal';
				maxLegendHeight = 40;
				y=(Ext.isEmpty(jsonData['smallGraph']) && seumLegend )?2:y;
				if(isServiceBusDash!=null && isServiceBusDash=='true')
				{	
					y=-30;
				}
			}
			else
			{
				y=5;
				valign = 'middle';
				legendWidth = 150;
				LegendPosition = 'right';
				legendLayout = 'vertical';
				maxLegendHeight = null;
			}
			xVal = ( rumPage )?50:null;
			if(!isAxisTimeReq)
				xLabel = "";
			var xType = 'datetime';
			var stacked = ( Ext.isEmpty(jsonData['stacking']) )?null:'normal';
			var line_width=3;
			var marker_enabled =false;
			var tooltipObj =null;
			var isLegendEnabled = true;
			var tmpEnabled =jsonData['legendEnabled'];
			var isSysDashboard = jsonData['isSysDashboard'];
			isLegendEnabled = tmpEnabled;
			var yVal = "";
			var offSets = "";
			var marginbtm = 90;
			var showLegends = false;
			var showLegendChkObj = Ext.ComponentQuery.query('#showLegend').length;
			var showLegendChk = Ext.ComponentQuery.query('#showLegend')[(showLegendChkObj -1)];
			if(!Ext.isEmpty(Ext.getCmp('showLegend')))
			{
				showLegends = Ext.getCmp('showLegend').getValue();
				idSelect = true;
			}
			if (showLegendChk != 'undefined' && showLegendChk != undefined )
			{
				showLegends = showLegendChk.getValue();
			}
			showLegends = (seumLegend)?true:showLegends;
			isLegendEnabled = (seumLegend)?true:isLegendEnabled;
			showLegs = showLegends;
			var dashboardName = ( Ext.isEmpty( jsonData['dashboardName'] ) )?"":jsonData['dashboardName'];
			var spaceVal = [20, 5, 0, 5];
			if( !Ext.isEmpty( dashboardName ) && dashboardName == 'rum')
			{
				showLegends = ( Ext.isEmpty( jsonData['enableRumLegend'] ) )?false:jsonData['enableRumLegend'];
				spaceVal = [-20, 5, 0, 5];
			}
			if (isSysDashboard!=null && isSysDashboard)
			{
				showLegends = true;	
				maxLegendHeight = '200px';
				legendWidth = 100;
			}
			if((isServiceBusDash!=null && isServiceBusDash=='true') && (!tmpEnabled))
			{
				showLegends = false;
				idSelect = true;
			}
			if(isServiceBusDash!=null && isServiceBusDash=='true')
			{
				marginbtm = 25;
			}
			/*if(s_time_fout == "%H:%M")
			{
				yVal = 33;
				offSets = 60;
			}
			else
			{
				yVal = 51;
				offSets = 100;
			}*/
			if(s_time_fout == "%H:%M")
			{
				yVal = 10;
				offSets = 60;
			}
			else
			{
				yVal = 6;
				offSets = 75; // For time format more than 24 hours in Measure Graph
			}

			rotVal=270;

			if(xAxisDisplay=='horizontal')
			{
				yVal=13;
				offSets=5;
				rotVal=0;
			}

			var minPad = null;
			if (!Ext.isEmpty(isYaxisBasedOnData) && isYaxisBasedOnData)
			{
				minPad=0;
				ymin = null;
				ymax = null;
			}

			if(ymin!=null && ymax!=null && (ymin == ymax))
				ymax = ymin+1;

			var toShowLastLabel = ( !Ext.isEmpty( jsonData['showLastLabel'] ) )?jsonData['showLastLabel']:true;
			var isLookBackChart = ( Ext.isEmpty( jsonData['isLookBack'] ))?false:jsonData['isLookBack'];
			legendWidth = (isLookBackChart)?200:legendWidth;
			Highcharts.setOptions({
				global: {
					useUTC: true,
					timezoneOffset:timeZoneOffsetVal
				}
			});
			var chartingOptions = {
				chart:{
					plotBorderColor : plotPanelColor,
					spacing:spaceVal,
					marginBottom:marginbtm,
					events: {
                            selection: function (event) {
							var text,label;
							if (event.xAxis) {
								if(Highcharts.numberFormat(event.xAxis[0].min, 2)>0){
									isZoomMeasureGraph=true;
								}
							} else {
								isZoomMeasureGraph=false;
							}
						},
						click: function(e) {
							try
							{
								if( !Ext.isEmpty( e.srcElement ) && ( e.srcElement.firstChild == null || e.srcElement.firstChild == undefined))
								{
									if(maxURL != 'null' && maxURL != 'undefined' && maxURL !='' && maxURL != undefined && maxURL != 'close')
										loadMaximizedView(maxURL);
									else if(maxURL == 'close')
										closeMaximizedView();
								}
								if( !Ext.isEmpty(jQuery(e.target)[0]) )
								{
									var eventText = (jQuery(e.target)[0].textContent);
									if( isTabsetPage && eventText.indexOf("Reset") > -1 )
										zoomPageRefresh(false);
								}
							}
							catch (e)
							{
							}
							
						},
						load:function() {
							jQuery('.highcharts-legend-item rect').attr('height', '8').attr('y', '5');
							jQuery('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
						},
						selection: function(event) {
							if(event.xAxis) {
								if( !Ext.isEmpty( event.xAxis[0] ) )
								{
									var isZoomed = event.xAxis[0].axis.zoomEnabled;
									if( isZoomed && isTabsetPage )
									{
										zoomPageRefresh(true);
									}
									
								}
							}
						}
					}
				},
				tooltip: {
					xDateFormat:toolTipFmt,
					valueDecimals: 4,
					backgroundColor : bgcolor,
					borderWidth: 1,
					shared: true,
					formatter: function() {
						var items = this.points || splat(this),
						series = items[0].series,s;
						// sort the values
						items.sort(function(a, b){
							return ((a.y > b.y) ? -1 : ((a.y < b.y) ? 1 : 0));
						});
						var s ='';
						if(legendSize==1 || (strSkin=='Dark' || strSkin=='dark') )
							s = '<span style="color:white">'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</span><br/>';
						else
							s = '<span>'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</span><br/>'
						jQuery.each(this.points, function(i, point) {
							var val = Highcharts.numberFormat (point.y,4, '.','');
							var val_ar = val.split('.');
							if(val_ar.length>1)
							{
								if(val_ar[1]=='0000')
									val = val_ar[0];
							}
							if (point.series.name != '' && point.series.name != undefined && isLegendEnabled) {
								if(legendSize==1)
									s += '<b><span style="color:white">'+ Ext.String.htmlDecode(point.series.name) +' :  '+val+'</span></b><br/>';
								else
									s += '<b><span style="color:' + this.series.color + '">'+ Ext.String.htmlDecode(point.series.name) +'  :  '+val+'</span></b><br/>';
							}
							else
							{
								s += '<br/> <b><span style="color:white">'+val+'</span></b><br/>';
							}
						});
						return s;
					}
					
				},
				title:{
					text:Ext.String.htmlDecode(chartTitle),
					style: {
						color : lineChartStyleAttrbs['titleFontClr'],
						fontFamily:lineChartStyleAttrbs['titleFontFamily'],
						fontSize: lineChartStyleAttrbs['titleFontSize']
					}
				},
				yAxis:{
					max:ymax,
					min : ymin,
					minPadding:minPad,
					lineWidth: ylineWidth,
					gridLineWidth: yGridLineWidth,
					gridLineColor: plotPanelColor,
					lineColor: plotPanelColor,
					labels: {
						align: 'right',
						x: -10,
						y: 3,
						 formatter: function() {
								var val = Highcharts.numberFormat (this.value,4, '.','');
								val = (parseFloat(val));
								return val;
							},
						style: {
							color : lineChartStyleAttrbs['axisFontClr'],
							fontFamily:lineChartStyleAttrbs['axisFontFamily'],
							fontSize: lineChartStyleAttrbs['axisFontSize']
						}
					},
					title: {
						text: Ext.String.htmlDecode(ytitle)
					}
				},
				xAxis: {
					type : xType,
					lineWidth: xlineWidth,
					gridLineWidth: xGridLineWidth,
					gridLineColor: plotPanelColor,
					lineColor: plotPanelColor,
					tickWidth : 0,
					tickLength: 0,
					endOnTick: true,
					showLastLabel:toShowLastLabel,
					labels: {
						//x:4,
						y:yVal,
						rotation:rotVal,
						style: {
							color : lineChartStyleAttrbs['axisFontClr'],
							//fontWeight: lineChartStyleAttrbs['axisFontWgt'],
							fontFamily:lineChartStyleAttrbs['axisFontFamily'],
							fontSize: lineChartStyleAttrbs['axisFontSize']
						},
						formatter: function() {
							return  Highcharts.dateFormat(s_time_fout, this.value);
						}
					},
					title: {
						text: Ext.String.htmlDecode(xLabel),
						offset:offSets,
						style: {
							color : axisNameColor,
						//	fontWeight: axisNameWeight,
							fontFamily:axisNameFamily,
							fontSize: axisNameSize+"px"
						}
					}
				},
				plotOptions: {
					series: {
						//lineWidth : line_width,
						marker: {
							enabled: marker_enabled,
							states: {
								hover: {
									enabled: true,
									//lineWidth: 2,
									lineWidthPlus:0
								}
							}
						},
						stacking: stacked,
						pointStart:startTime,
						 point: {
							events: {
								click: function(e) {
									//if( !Ext.isEmpty( e.srcElement ) && ( e.srcElement.firstChild == null || e.srcElement.firstChild == undefined))
									{
										if(maxURL != 'null' && maxURL != 'undefined' && maxURL !='' && maxURL != undefined && maxURL != 'close')
											loadMaximizedView(maxURL);
										else if(maxURL == 'close')
											closeMaximizedView();
									}
								}
							}
						}
						//pointInterval: 60*1000,
					},
					scatter: {
						tooltip: tooltipObj,
					}
				},
				legend: {
					enabled:showLegends,
					verticalAlign: valign,
					//layout: legendLayout,
					//width:legendWidth,
					align:LegendPosition,
					maxHeight :maxLegendHeight,
					y:y,
					x:xVal,
					symbolRadius:0,
					itemStyle: {
						color : lineChartStyleAttrbs['legFontClr'],
						fontWeight: lineChartStyleAttrbs['legFontWgt'],
						fontFamily:lineChartStyleAttrbs['legFontFamily'],
						fontSize: lineChartStyleAttrbs['legFontSize']
					},
					labelFormatter: function() {
						var retrunvar = Ext.String.htmlDecode(this.name);
						//var tmpRetVal = '';
						if (retrunvar != '' && retrunvar !='undefined' && retrunvar !='infinity') {
							retrunvar = this.name;
						}
						else {
							retrunvar = 'null';
						}
						var str = retrunvar;
						if(valign =="middle" && !isLookBackChart)
						{
							var toolTextStr = '';
							if(str.length >=20)
							{
								//String tmpStr=str.substring(0,50)+"...";
								//valueStr=tmpStr;
								toolTextStr=str.substring(0,20);
								var tempToolTextStr=str.substring(20);
								tempToolTextStr = tempToolTextStr.trim();
								while(tempToolTextStr.length >20)
								{
									toolTextStr=toolTextStr+"<br>"+tempToolTextStr.substring(0,20);
									tempToolTextStr=tempToolTextStr.substring(20);
								}
								if(tempToolTextStr.length > 2 )
								{
									var tmpStr = tempToolTextStr.substring(0,2);
									if(tmpStr.indexOf(" ") > -1)
									{
										toolTextStr = str.substring(0,22);
									}
								}
								toolTextStr=toolTextStr+"<br>"+tempToolTextStr;
							}
							else
								toolTextStr = str;
						}
						else
							toolTextStr = retrunvar;

						return toolTextStr;
					}
				},
				navigation: {
					 buttonOptions: {
						x:3
					}
				},
				exporting: {
					enabled: enableExport,
					filename:chartFileName,
					chartOptions:{
						title:{
							text:Ext.String.htmlDecode(exportTitle)
						}
					},
					buttons: {
						contextButton: {
							theme: {
								fill:contextBtnColor,
								states: {
								hover: {
									fill: contextBtnColor
									}
								}
							}
						}
					}
				}
			};

			var chartContObj=document.getElementById(container_Id);
			if(chartContObj == null || chartContObj == undefined)
				chartContObj = Ext.getCmp(container_Id);
			
			this.highchart= jQuery.extend(true, this.defaults, chartingOptions);
			var chartData=[];
			var seriesCounter = 0;
			if(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined )
			{
				drawChart = false;
				if(chartContObj!=null)
				{
					chartContObj.innerHTML='<center><span><img style="margin:20% 0 auto 0" src="/final/images/spacer.gif" class="iconAlert"/></span><span class="rumGraphErrorMsgText">No Traffic Detected</span></center>';
				}
			}else{
				this.highchart.series=jsonData['DataSet'];
				this.highchart.chart.renderTo = container_Id;
			}
		},
		drawChart: function() {
			if(drawChart)
			{
				//new Highcharts.Chart(this.highchart);
				Highcharts.setOptions({
					lang: {
						thousandsSep: ''
					}
				});
				Highcharts.setOptions({
					global: {
						useUTC: true,
						timezoneOffset:timeZoneOffsetVal
					}
				});
				 Highcharts.seriesTypes.line.prototype.drawLegendSymbol = Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
				this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin));
				new Highcharts.Chart(this.highchart,function(chart){
					
					if(!idSelect)
						jQuery('.showLegend').click(function () { chart.legendToggle(); });
					else
					{
						jQuery('#showLegend').click(function () { chart.legendToggle(); });
						//jQuery('.showLegend').click(function () { chart.legendToggle(); });
					}
				});
			}
		}
	};
	return HighStockChart;
}
function createBar(container_Id,chartHeight,chartWidth)
{
	return getInstance(container_Id,chartHeight,chartWidth);
}
function createPie(container_Id,chartHeight,chartWidth)
{
	return getInstance(container_Id,chartHeight,chartWidth);
}
function getHighChartsBarInstance(container_Id,chartHeight,chartWidth)
{
	return getInstance(container_Id,chartHeight,chartWidth);
}
function getInstance(container_Id,chartHeight,chartWidth){
 var drawChart = true;
 var maxValue = null;
 if (container_Id.indexOf('summary')>-1)
 {
	 maxValue = 100;
 }
 var ErHighStockChart = {
	highchart: null,
	defaults: {
		chart: {
			height:chartHeight,
			width:chartWidth,
			plotBorderWidth: 0,
			plotBorderColor : '#C0C0C0',
			backgroundColor: 'transparent',
			plotBackgroundColor: 'transparent',
			plotShadow: false,
			shadow: false,
			zoomType:'xy',
			ignoreHiddenSeries:false,
			spacing:[10, 10, 10, 10],
			events: {
				load: function(event) {
					jQuery('.highcharts-legend-item rect').attr('height', '8').attr('y', '5');
					jQuery('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
				}
			}
		},
		rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			//timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		yAxis: {
               // min: 0,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: true,
			max:maxValue,
			border :0,
			lineWidth:1,
			labels: {
			    formatter: function() {
					var val = Highcharts.numberFormat (this.value,4, '.','');
					val = (parseFloat(val));
					/*var val_ar = val.split('.');
					if(val_ar.length>1)
					{
						if(val_ar[1]=='0000')
							val = val_ar[0];
					}*/
					return val;
				},
				style: {
					color : 'black',
					fontWeight:'500',
					fontFamily: 'Arial',
					fontSize: '11px',
				},
			},
			showLastLabel: true,
		},
		scrollbar: {
			enabled: false
		},
		legend: {
			verticalAlign: 'top',
			align:'center',
			layout: 'horizontal',
			borderWidth: 0,
			y:5,
			x:5,
			width: 300,
			adjustChartSize: false,
			navigation: {
				arrowSize: 5
			},
			itemStyle: {
				color : 'black',
				fontWeight:'500',
				fontFamily: 'Arial',
				fontSize: '11px',
			},
			symbolWidth: 15,
		},
		labels :{
			itemStyle: {
				color : 'black',
				fontWeight:'500',
				fontFamily: 'Arial',
				fontSize: '11px',
			},
		},
		tooltip: {
			shared: true,
			//borderColor: 'black',
			valueDecimals: 4,
			style: {
					color : '#c0c0c0',
					padding: 10,
					fontWeight:'500',
					fontFamily: 'Arial',
					fontSize: '11px',
				},
		},
		exporting: {
			enabled: false
		},
		credits: {
			enabled: false
		},
		xAxis: {
            tickWidth: 0,
			border :1,
			lineWidth: 1,
			minPadding:0.02,
			maxPadding:0.02,
			ordinal: false,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: true,
			labels: {
				style: {
					color : '#c0c0c0',
					fontFamily: 'Arial',
                    fontSize: '11px',
				},
				overflow: 'justify',
				showLastLabel: true,
				endOnTick: true,
				showFirstLabel: true,
				startOnTick: false,
				useHTML: false,
				tickPixelInterval: 50,
			},
			title: {
				enabled: true,
			}
		},
		title: {
				text: '',
				offset: '',
				margin: 0
			},
		series: {
		}
	},
    setData: function (jsonData, currentDateFormat, maxURL, ctype) {
		var isMyDashboardHealthPieChart=false;
		var isDoNut=false;
		if(ctype!=null && ctype=='healthPieChart')
		{
			ctype='pie';
			isMyDashboardHealthPieChart=true;
		}
		else if(ctype!=null && ctype=='donut')
		{
			ctype='pie';
			isDoNut = true;
		}
	  var isEndOntick = ( Ext.isEmpty( jsonData['tick'] ) )?true:jsonData['tick'];
	  jsonData = (!Ext.isEmpty(jsonData.dataXML))?jsonData.dataXML:jsonData;
	  var toolTipFmt = '';
	  var chartType = ( Ext.isEmpty(ctype))?'bar':ctype;
	  var isStackedColumn = false;
	  if (chartType == 'stackedColumn')
	  {
		  isStackedColumn = true;
	  }
	  var isStackedBar = false;
	  if (chartType == 'stackedBar')
	  {
		  isStackedBar = true;
	  }
	  var setMinPointLength=0;
	  var setPointWidth = null;
	  var maxVal = null;
	  if (jsonData['MaxValue']!=null && jsonData['MaxValue']!="" && jsonData['MaxValue']!=undefined && jsonData['MaxValue']!='undefined')
	  {
		maxVal = jsonData['MaxValue'];
	  }
	  var labelStep = 0;
	  if(isStackedColumn && jsonData['labelStep']!=null && jsonData['labelStep']!=undefined && jsonData['labelStep']!='')
	  {	
		labelStep = jsonData['labelStep'];
	  }

		var pieSize='80%';
		var pieInnerSize='';
		var pieDataLabelsEnable=true;
		var showMonitorHomeBottomPanel=true;
		showMonitorHomeBottomPanel = (Ext.isEmpty(jsonData['showMonitorHomeBottomPanel']))?false:jsonData['showMonitorHomeBottomPanel'];
		var isLogonDonut = (Ext.isEmpty(jsonData['logonDonut']))?false:jsonData['logonDonut'];
		var pieVerticalAlign="";
		var pieAllowPointSelect=true;
		var pieMargin=15;
		var tooltipFontSize=12;
		if(isDoNut)
		{
			if(showMonitorHomeBottomPanel)
			{
				//pieSize='650%';
				//pieInnerSize='240%';
				pieSize='260%';
				pieInnerSize='50%';
			}
			else if(isLogonDonut)
			{
				pieSize='100%';
				pieInnerSize='70%';
			}
			else
			{
				//pieSize='300%';
				//pieInnerSize='240%';
				pieSize='260%';
				pieInnerSize='50%';
			}
			pieDataLabelsEnable = (Ext.isEmpty(jsonData['dataLabels']))?false:jsonData['dataLabels'];
			pieVerticalAlign = "middle";
			pieMargin=0;
			pieAllowPointSelect=false;
			tooltipFontSize = jsonData['tooltipFontSize'];
		}
		tooltipFontSize=(tooltipFontSize==null || tooltipFontSize==undefined)?12:tooltipFontSize;

		var isShowTooltip=true;
		var strShowTip=jsonData['isShowToolTip'];
		if(strShowTip!=null && strShowTip!=undefined && (strShowTip=='false' || strShowTip=='FALSE' || strShowTip=='False' || strShowTip==false))
			isShowTooltip=false;
	  var barStyleAttrbs=new Object();
	  barStyleAttrbs['fontFamily']='Arial';
	  barStyleAttrbs['fontSize']='10px';
	  barStyleAttrbs['yFontClr']='#636363';
	  barStyleAttrbs['xfontClr']='#636363';
	  barStyleAttrbs['yfontFmy']='Arial';
	  barStyleAttrbs['xfontFmy']='Arial';
	  barStyleAttrbs['yfontSize']='10px';
	  barStyleAttrbs['xfontSize']='10px';
	  barStyleAttrbs['xfontWgt']='normal';
	  barStyleAttrbs['yfontWgt']='normal';

	  barStyleAttrbs['ylabelFontClr']='#636363';
	  barStyleAttrbs['xlabelfontClr']='#636363';
	  barStyleAttrbs['ylabelfontFmy']='Arial';
	  barStyleAttrbs['xlabelfontFmy']='Arial';
	  barStyleAttrbs['ylabelfontSize']='10px';
	  barStyleAttrbs['xlabelfontSize']='10px';
	  barStyleAttrbs['ylabelfontWgt']='500';
	  barStyleAttrbs['xlabelfontWgt']='normal';

	  barStyleAttrbs['legFontClr']='#636363';
	  barStyleAttrbs['legFontFmy']='Arial';
	  barStyleAttrbs['legFontSize']='10px';
	  barStyleAttrbs['legFontWgt']='normal';

	  barStyleAttrbs['capFontClr']='#333333';
	  barStyleAttrbs['capFontFmy']='Arial';
	  barStyleAttrbs['capFontSize']='12px';
	  barStyleAttrbs['capFontWgt']='500';
	  barStyleAttrbs['LegendPosition']='center';

	  var yaxisTitle ='',xLabel='',showLegend=false;
	  showLegend = (Ext.isEmpty(jsonData['showLegend']))?false:jsonData['showLegend'];
	 
	  barStyleAttrbs['bgColor'] = jsonData['bgColor'];
	  barStyleAttrbs['plotBgColor'] = jsonData['plotBgColor'];
	  barStyleAttrbs['fontColor'] = jsonData['fontColor'];
	  barStyleAttrbs['gridLineColor'] = jsonData['gridLineColor'];
	  barStyleAttrbs['LegendFont '] = jsonData['LegendFont'];
	  xLabel = jsonData['xAxisLabel'];
	 if( Ext.isEmpty(jsonData['styles']))
	 {
		barStyleAttrbs['fontFamily'] = jsonData['fontName'];
		barStyleAttrbs['fontSize'] = jsonData['fontsize'];
		yaxisTitle = jsonData['yAxisLabel'];
		xaxisTitle = jsonData['xAxisLabelName'];
		barStyleAttrbs['LegendPosition'] = jsonData['LegendPosition'];
		if (jsonData.hasOwnProperty('showlegendFont'))
		{
			showLegend = eval(jsonData['showlegendFont']);
		}
	 }
	 else
	 {
	 	barStyleAttrbs['fontFamily'] = jsonData['fontName'];
        barStyleAttrbs['fontSize'] = jsonData['fontsize'];
        yaxisTitle = jsonData['yAxisLabel'];
		xaxisTitle = jsonData['xAxisLabelName'];
        barStyleAttrbs['LegendPosition'] = jsonData['LegendPosition'];
        if (jsonData.hasOwnProperty('showlegendFont')) {
            showLegend = eval(jsonData['showlegendFont']);
        }
        var stylesJson = jsonData['styles'];
		if(!Ext.isEmpty(stylesJson['legendStyle']))
		{
			barStyleAttrbs['legFontClr'] = stylesJson['legendStyle'].COLOR;
			barStyleAttrbs['legFontFmy'] = stylesJson['legendStyle'].FAMILY;
			barStyleAttrbs['legFontSize'] = stylesJson['legendStyle'].SIZE;
			barStyleAttrbs['legFontWgt'] = stylesJson['legendStyle'].WEIGHT;
		}
		if(!Ext.isEmpty(stylesJson['title']))
		{
			barStyleAttrbs['capFontClr'] = stylesJson['title'].COLOR;
			barStyleAttrbs['capFontFmy'] = stylesJson['title'].FAMILY;
			barStyleAttrbs['capFontSize'] = stylesJson['title'].SIZE;
			barStyleAttrbs['capFontWgt'] = stylesJson['title'].WEIGHT;
		}
		
		if(!Ext.isEmpty(stylesJson['yaxis']))
		{
			barStyleAttrbs['yfontClr'] = stylesJson['yaxis'].COLOR;
			barStyleAttrbs['yfontFmy'] = stylesJson['yaxis'].FAMILY;
			barStyleAttrbs['yfontSize'] = stylesJson['yaxis'].SIZE;
			barStyleAttrbs['yfontWgt'] = stylesJson['yaxis'].WEIGHT;
		}
		if(!Ext.isEmpty(stylesJson['xaxis']))
		{
			barStyleAttrbs['xfontClr'] = stylesJson['xaxis'].COLOR;
			barStyleAttrbs['xfontFmy'] = stylesJson['xaxis'].FAMILY;
			barStyleAttrbs['xfontSize'] = stylesJson['xaxis'].SIZE;
			barStyleAttrbs['xfontWgt'] = stylesJson['xaxis'].WEIGHT;
		}
		if(!Ext.isEmpty(stylesJson['yaxislabel']))
		{
			barStyleAttrbs['ylabelfontClr'] = stylesJson['yaxislabel'].COLOR;
			barStyleAttrbs['ylabelfontFmy'] = stylesJson['yaxislabel'].FAMILY;
			barStyleAttrbs['ylabelfontSize'] = stylesJson['yaxislabel'].SIZE;
			barStyleAttrbs['ylabelfontWgt'] = stylesJson['yaxislabel'].WEIGHT;
		}
		if(!Ext.isEmpty(stylesJson['xaxislabel']))
		{
			barStyleAttrbs['xlabelfontClr'] = stylesJson['xaxislabel'].COLOR;
			barStyleAttrbs['xlabelfontFmy'] = stylesJson['xaxislabel'].FAMILY;
			barStyleAttrbs['xlabelfontSize'] = stylesJson['xaxislabel'].SIZE;
			barStyleAttrbs['xlabelfontWgt'] = stylesJson['xaxislabel'].WEIGHT;
		}
	}
	if(barStyleAttrbs['bgColor']==null || barStyleAttrbs['bgColor']=="" || barStyleAttrbs['bgColor']=="null")
	{
		//barStyleAttrbs['bgColor']="#ffffff";
		barStyleAttrbs['bgColor']="transparent";
		//fbfbfb
	}
	if(barStyleAttrbs['plotBgColor']==null || barStyleAttrbs['plotBgColor']=="" || barStyleAttrbs['plotBgColor']=="null")
	{
		barStyleAttrbs['plotBgColor'] ="#ffffff";
	}
	if(barStyleAttrbs['fontColor']==null || barStyleAttrbs['fontColor']=="" || barStyleAttrbs['fontColor']=="null")
	{
	   barStyleAttrbs['fontColor'] ="#c0c0c0";
	}
	if(barStyleAttrbs['gridLineColor']==null || barStyleAttrbs['gridLineColor']=="" || barStyleAttrbs['gridLineColor']=="null")
	{
		barStyleAttrbs['gridLineColor']="#C0C0C0";
	}
	yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
	xaxisTitle =(xaxisTitle == null || xaxisTitle == '')?'':xaxisTitle;
	legx=90,legy=100;
	legAlign='right';
	var itemMarginTopVal=5;
	var itemMarginBottomVal=5;
	var legendLayout='vertical';
	var legendMaxHeight=null;
	if(barStyleAttrbs['LegendFont']==null || barStyleAttrbs['LegendFont']=="" || barStyleAttrbs['LegendFont']=="null")
	{
		barStyleAttrbs['LegendFont']='Arial';
	}
	if(chartType!=null && chartType=='bar')
	{
		  dataLabelColor='#c0c0c0';
		  setMinPointLength=10;
		  setPointWidth=21;
		  legx=0;
		  legy=0;
		  legAlign = 'top';
	}
	else if(chartType!=null && chartType=='column')
	{
		legx=0;
		legy=0;
		itemMarginTopVal=0;
		itemMarginBottomVal=0;
		legAlign = 'top';		
		legendLayout='horizontal';
		legendMaxHeight=40;
	}
	var subTitle = ( Ext.isEmpty( jsonData.subTitle ) )?'':jsonData.subTitle;
	yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?((!Ext.isEmpty(jsonData['yAxisLabel']))?jsonData['yAxisLabel']:''):yaxisTitle;
	xaxisTitle =(xaxisTitle == null || xaxisTitle == '')?((!Ext.isEmpty(jsonData['xAxisLabelName']))?jsonData['xAxisLabelName']:''):xaxisTitle;
	xLabel =(xLabel == null || xLabel == '')?'':xLabel;
	legendWidth = (barStyleAttrbs['LegendPosition'] == 'right')?190:300;
	needLegendFormat = (barStyleAttrbs['LegendPosition'] == 'right')?'true':'false';
	maxLegendHeight = (barStyleAttrbs['LegendPosition'] == 'right')?null:50;
	valign = (barStyleAttrbs['LegendPosition'] == 'right')?'middle':'top';
	var chartTitle =jsonData['title'];
	var isHtmlTitle = ( Ext.isEmpty( jsonData['useHtml'] ) )?false:jsonData['useHtml'];
	chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
	var marginTopVal = ( chartType == 'bar' && chartTitle != '' )?40:20;
	if(chartType!=null && chartType=='column')
	{
		marginTopVal=50;
	}
	var fromPage = jsonData['fromPage'];
	var chartContObj=document.getElementById(container_Id);
	var stackingVal='normal';
	var rotateDegree = 0;
	var setGroupPadding=-0.065;
	var setPointPadding=0.1;// default value
	var data=jsonData['DataSet'];
	var enableClick = (Ext.isEmpty(jsonData['enableClick']))?false:jsonData['enableClick'];
	var insideVal = false;
	barStyleAttrbs['plotBgColor'] = 'transparent';	
	var tipColor = ( (strSkin=='Dark' || strSkin=='dark') )?'#c0c0c0':'#2a292a';
	var tipFormat = ( (strSkin=='Dark' || strSkin=='dark') )?'<span style="color:white">{point.y}</span> ':'<span style="color:{point.color}">{point.y}</span> ';
	var rotYval = 0;
	var rotXval = 0;
	if(chartType!=null && chartType=='column')
	{
		stackingVal=null;
	//	rotateDegree=-90;
		rotYval=25;
		//marginTopVal=100;
	}
	
	if (isStackedColumn)
	{
		rotateDegree = 270;
		rotYval = 30;
		rotXval = 2;
		chartType = 'column';
		stackingVal='normal';
		insideVal = true;
	//	barStyleAttrbs['xlabelfontSize'] = '12px';
		var marginTop1=jsonData['marginTop'];
		if(marginTop1==null || marginTop1=="undefined" || marginTop1=="")
			marginTopVal = 60;
			
		marginTopVal=marginTop1;
	}
	else if (isStackedBar)
	{
		rotateDegree = 0;
		chartType = 'bar';
		stackingVal='normal';
		//barStyleAttrbs['xlabelfontSize'] = '12px';
		marginTopVal = 40;
		insideVal = true;
		dataLabelColor='#c0c0c0';
	    setMinPointLength=10;
		setPointWidth=21;
		rotXval = -5;
	}
	else if( chartType == 'bar')
	{
		rotXval = -5;
		barStyleAttrbs['fontColor'] = (strSkin == 'Light')?"#2a292a":'#c0c0c0';	  
	}
  if(chartType!=null && chartType=='pie')
  {
	  barStyleAttrbs['fontColor'] = (strSkin == 'Light')?"#2a292a":'#c0c0c0';	
	  strpointFormat='';
	  if(chartTitle!=null && chartTitle!="")
		{
			chartTitle = ( Ext.isEmpty( jsonData['unit'] ) )?chartTitle:chartTitle+'('+jsonData['unit']+')';
		}
  }
  else
  {
   strpointFormat='<b>:{point.y}</b>';
  }
	if(data!=null && data.length>=1)
	{
		calx = (chartWidth/data.length)+40;
		var xx=data[0].data;
		//calBarwidth=21+((chartHeight-((xx.length*21)+50))/xx.length)/10
		//if(xx.length==1)
		if(xx.length<3)
		{
			setGroupPadding=0.2;
			setPointPadding=0.4;
		}
	}
	var yAxisLineWidth = 1;
	if(jsonData!=null && (jsonData.hasOwnProperty('hideTopGridLine') && jsonData['hideTopGridLine']=="true"))
	{
		yAxisLineWidth=0;
	}
	var space = [10, 10, 10, 10];
	var marginbottom=null;
	var marginright=null;
	var mychartwidth=chartWidth;
	var mychartheight=chartHeight;
	var marginTop=null;
	var isMyDashboard=false;
	if(fromPage!=null && fromPage=="MyDashboard")
	{
		isMyDashboard=true;
	}

	if(fromPage!=null && (fromPage=="HomePage" || fromPage=="ZonePage"))
	{
		marginbottom=20;
		marginTopVal=10;
	}
	
	if( !isMyDashboard && Ext.isEmpty( jsonData['isStateBar'] ))
	{
		var isMaxView = jsonData['isMax'];
		marginTop=20;
		if(xLabel.length>=6)
		{
			isMaxView=eval(isMaxView);
			//marginbottom = ( isMaxView )?(chartHeight-40-(xLabel.length)*(setPointWidth+1)):(chartHeight-20-(xLabel.length)*(setPointWidth+1));
			//marginbottom = ( isMaxView && mychartheight <= 400 )?null:(chartHeight-40-(xLabel.length)*(setPointWidth+1));
			if( isMaxView )
				marginbottom = ( mychartheight <= 400 )?null:(chartHeight-40-(xLabel.length)*(setPointWidth+1));
			else
				marginbottom = (chartHeight-20-(xLabel.length)*(setPointWidth+1));
		}
		if(chartType!=null && chartType=='column')
		{
			marginbottom=null;
			if(chartContObj!=null)
				chartContObj.style.height = '97%';
			if(xLabel.length>=6)
				marginright=chartWidth-20-(xLabel.length)*(setPointWidth+5);
		}
		if(chartType!=null && chartType=='bar')
		{
			mychartwidth=chartWidth;
			if(chartContObj!=null)
				chartContObj.style.width = '97%';
		}
	}
	if(isMyDashboard)
		marginbottom=null;
	
	if(isMyDashboardHealthPieChart || isLogonDonut)
	{
		space=[0,0,0,0];
		marginTopVal=null;
	}
	var isRumPie = ( Ext.isEmpty( jsonData['rumPie'] ) )?false:true;
	var spie = false;

   var chartingOptions = {
   chart:{
	height:mychartheight,
	width:mychartwidth,
	type : chartType,
	spacing:space,
	marginBottom: marginbottom,

    backgroundColor : barStyleAttrbs['bgColor'],
    plotBackgroundColor : barStyleAttrbs['plotBgColor'],
    plotBorderColor: barStyleAttrbs['gridLineColor'],
	 marginTop: marginTopVal,
					events:
					{
						click: function (e)
						{
							if (e.target.firstChild == null || e.target.firstChild == undefined)
							{
								if (maxURL != 'null' && maxURL != 'undefined' && maxURL != '' && maxURL != undefined && maxURL != 'close')
									loadMaximizedView(maxURL);
								else if (maxURL == 'close')
									closeMaximizedView();
							}
						}
					}
    },
    title: {
		useHTML:isHtmlTitle,
		text: Ext.String.htmlDecode(chartTitle),
		offset: '',
		margin: pieMargin,
		style:
		{
			color:barStyleAttrbs['capFontClr'],
			fontFamily:barStyleAttrbs['capFontFmy'],
			fontSize:barStyleAttrbs['capFontSize']
		},
		verticalAlign: pieVerticalAlign,
		floating: true,
		zIndex:'-10000',
   },
   subtitle:{
	text: subTitle,
	style:
		{
			color:barStyleAttrbs['capFontClr'],
			fontFamily:barStyleAttrbs['capFontFmy'],
			fontSize:barStyleAttrbs['capFontSize']
		}
   },
   tooltip: {
		valueDecimals: 4,
		hideDelay: 100,
		style:{padding: '5px'},
		//formatter: function() {
			/*if( !Ext.isEmpty(this.point) ){
				return (Ext.isEmpty(this.point.legendLabel))?'<span style="color:'+this.point.color+'">'+this.point.name+': <b>'+this.point.y+'</b></span> ':'<span style="color:'+this.point.color+'">'+ this.point.legendLabel +'</span>';
			}*/
			formatter: function() 
			{
				if(isShowTooltip)
				{
						var s ='';
						var val = Highcharts.numberFormat (this.y,4, '.','');
						var val_ar = val.split('.');
						if(val_ar.length>1)
						{
							if(val_ar[1]=='0000')
								val = val_ar[0];
						}
						if(isMyDashboardHealthPieChart)
						{
							s += '<span style="color:'+this.point.color+'">'+this.point.name+'</b></span>';
						}
						else
						{
							if( Ext.isEmpty(this.point) )
							{
								if(this.x == "" || this.x == 'null' || this.x == 'undefined' || this.x == undefined)
								{
									s += '<b><span style="color:'+tipColor+'">'+val+'</span></b>';
								}else
									s += '<b><span style="color:'+tipColor+'">'+ this.x +'  :  '+val+'</span></b>';
							}
							else
							{
								var tpn = (Ext.isEmpty(this.point.legendLabel))?this.point.name:this.point.legendLabel;
								var perTip="";
								if( isRumPie )
								{
									if( tpn.indexOf("(") > -1 )
									{
										var tpnfr = tpn.substring(0,tpn.indexOf("("));
										var tpnsr = tpn.substring(tpn.indexOf(")")+1);
										if(tpn!=null && tpn.indexOf("%")>-1)
										{
											perTip=" %";
											tpn = tpnfr+tpnsr;
										}
										else
										{
											tpn = tpnfr+tpnsr;
										}
									}
								}
								else
								{
									tpn = (Ext.isEmpty(this.point.legendLabel))?this.point.name:this.point.legendLabel;
								}

								if(isDoNut)
								{
									s += (Ext.isEmpty(this.point.legendLabel))?'<span style="font-size:'+tooltipFontSize+'px;color:'+this.point.color+'">'+Ext.String.htmlDecode(tpn)+': <b style="font-size:'+tooltipFontSize+'px;color:'+this.point.color+'">'+this.point.y+perTip+'</b></span> ':'<span >'+ Ext.String.htmlDecode(tpn) +'</span>';
								}
								else
								{
									//s += (Ext.isEmpty(this.point.legendLabel))?'<span style="color:'+this.point.color+'">'+tpn+': <b>'+this.point.y+perTip+'</b></span> ':'<span >'+ tpn +'</span>';
									
									var tipColor = (strSkin == 'Light')?"#000000":'#c6c6c6';
									if( tpn!=null && tpn!=undefined && tpn.indexOf("(") > -1 )
									{
										s += (Ext.isEmpty(this.point.legendLabel))?'<span style="color:'+this.point.color+'">'+Ext.String.htmlDecode(tpn)+'</b></span> ':'<span >'+ Ext.String.htmlDecode(tpn) +'</span>';
									}
									else
									{
										s += (Ext.isEmpty(this.point.legendLabel))?'<span style="color:'+this.point.color+'">'+Ext.String.htmlDecode(tpn)+': <span style="color:'+tipColor+'">'+this.point.y+perTip+'</span></span> ':'<span>'+ Ext.String.htmlDecode(tpn) +'</span>';
									}
									
									
								}
							}
						}
						return s;
					}
				else
				{
					return false;
				}
			}
   },
   yAxis: {
	 max:maxVal,
	 gridLineWidth: 1,
	 endOnTick: isEndOntick,
	 lineWidth : yAxisLineWidth,
	 startOnTick: true,
	 gridLineColor: barStyleAttrbs['gridLineColor'],
	 lineColor: barStyleAttrbs['gridLineColor'],
     labels: {
		style: {
			fontFamily: barStyleAttrbs['yfontFmy'],
			fontSize: barStyleAttrbs['yfontSize'],
			color : barStyleAttrbs['yfontClr']
		}
	},
     title: {
      text: Ext.String.htmlDecode(yaxisTitle),
      style: {
       color : barStyleAttrbs['ylabelfontClr'],
       fontFamily: barStyleAttrbs['ylabelfontFmy'],
       fontSize: barStyleAttrbs['ylabelfontSize'],
                        }
      },
		tickPositioner: function(min,max){
				if (!isStackedColumn && !isStackedBar)
				{
					var act = min,
					ticks = [];
					this.tickAmount=1;
					var flag=false;
					var interval=this.tickInterval;
					var second=0;
					if(min==max)
					{
						if(max>1)
							max=max+1;
						else if(max==0){
							max=max+1;
							second=0
							flag=true;
						}
						else
						{
							max=max+0.1;
						}
					}
					var cc=1
					while(act <= max){
						if(cc==2 && flag)
							ticks.push(second);
						else
							ticks.push(act);
						act+= interval;
						cc++;
					}
					if(!flag)
						ticks.push(act);
				  return ticks;  
				}
			}
    },
    xAxis: {
     categories: xLabel,
	 min: 0,
	 tickWidth:0,
     gridLineWidth: 0,
     gridLineColor: barStyleAttrbs['gridLineColor'],
     lineColor: barStyleAttrbs['gridLineColor'],
     lineWidth:1,
	tickPixelInterval: 75,
	tickLength: 0,
	endOnTick: true,
	showFirstLabel: true,
	startOnTick: true,
	labels: {
		 rotation:rotateDegree,
		 tickmarkPlacement: 'on',
		 x: rotXval,
		 y:rotYval,
		step:labelStep,
		 style: {
				width:'100px',
				fontFamily: barStyleAttrbs['xfontFmy'],
				fontSize: barStyleAttrbs['xfontSize'],			
				color : barStyleAttrbs['xfontClr'],
				whiteSpace: 'nowrap'
			},
			formatter: function() {
				var charLen = ( !Ext.isEmpty( fromPage ) && ( fromPage.toLowerCase() == 'insideview' || fromPage.toLowerCase() == 'virtualtab' || fromPage.toLowerCase() == 'vlive' ))?16:32;
				/*if( fromPage == 'dashboard')
				{
					charLen = 20;
				}*/
				charLen = ( fromPage == 'dashboard' )?20:16;
				var val=this.value;
				var val2=val.toString();
				if(val != null )
				{
					var firstChar = val2.charAt(0);
					if( firstChar == firstChar.toUpperCase()){
						var defLength=11;
						if(isMyDashboard)
						{
							defLength=mychartwidth*0.04;
							defLength=Ext.util.Format.round(defLength, 0);
							if(defLength<11)
								defLength=11;
						}
						if( val.length > defLength )
						{
							var val2=val.substring(defLength);
							if(val2.length>3)
								val=val.substring(0,defLength)+'...'
						}
					}
					else
					{
						var defLength=charLen;
						if(isMyDashboard)
						{
							defLength=mychartwidth*0.06666;
							defLength=Ext.util.Format.round(defLength, 0);
							if(defLength<16)
								defLength=16;
						}
						if(val!=null && val.length> defLength)
						{
							var val2=val.substring(defLength);
							if(val2.length>3)
								val=val.substring(0,defLength)+'...'
						}
					}
				}
				return val;
			}
	},
     title: {
	  text: Ext.String.htmlDecode(xaxisTitle),
      offset:40,                    
      style: { 
			fontFamily: barStyleAttrbs['xlabelfontFmy'],
			fontSize: barStyleAttrbs['xlabelfontSize'],
			color : barStyleAttrbs['xlabelfontClr'],
       },
      },
    },
   plotOptions: {
      pie: {
			borderWidth: 0, // border color control
			size: pieSize,
			allowPointSelect: pieAllowPointSelect,
			cursor: 'pointer',
			innerSize:pieInnerSize,
			dataLabels: {
				connectorColor: '#C0C0C0',
				softConnector: false,
				enabled: pieDataLabelsEnable,
				distance: 7,
				style: {
					color : barStyleAttrbs['fontColor'],
					fontFamily:barStyleAttrbs['fontFamily'],
					fontSize: '11px',
					textOutline: false,
					textShadow: false
				}
			},
			showInLegend: spie,
			tooltip: {
				valueDecimals: 4,
				 pointFormat: '<span style="color:{point.color}">{point.y}</span> ',
				formatter: function() {
					if( !Ext.isEmpty(this.point)){
						if(this.point.hasOwnProperty('legendLabel'))
						{
							return (Ext.isEmpty(this.point.legendLabel))?'<span style="color:'+this.point.color+'">'+Ext.String.htmlDecode(this.point.name)+': <b>'+this.point.y+'</b></span> ':'<span style="color:'+this.point.color+'">'+ Ext.String.htmlDecode(this.point.legendLabel) +'</span>';
						}
					}
				}
		   },
		   point: {
		   events: {
			  click: function(e) {

				  if(isMyDashboardHealthPieChart)
				  {
					  var QString=this.options;
					  if(QString!=null && QString.hasOwnProperty('diagnosisUrl'))
					  {
						  var diagnosisUrl=QString['diagnosisUrl'];
						  var openInNewWindow=QString['openInNewWindow'];
						  if(diagnosisUrl!=null && diagnosisUrl!="-")
						  {
							  if(openInNewWindow)
							  {
								loadPopup(diagnosisUrl);
							  }
							  else
							  {
								wayToLayerModel(diagnosisUrl);
							  }
						  }
					  }
				  }
				else if(isDoNut)
				{
					if(e.point.url!=null && e.point.url!=undefined && e.point.url!="")
					{
						donutClickFlag=true;
						donutSliceClick(e.point.url);
					}
					else
						return false;
				}
				/*  var QString=this.options.url;
			 if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
			   {
			   }
			   else if(chartType!=null && chartType=='pie')
			   {
				openInNewWin(QString);
				   }
				else if(chartType!=null && chartType=='bar')
			   {
			  //   document.location=QString;
						  openInNewWin(QString);
	 
			   }
				*/
			  }
		   },
		   }
      },
       bar:{
			pointPadding : 0.11,
			pointWidth:setPointWidth,
			dataLabels : {
				color : barStyleAttrbs['fontColor'],
				fontFamily:barStyleAttrbs['fontFamily'],
				fontSize: '11px',
				textOutline: false,
				textShadow: false
			 },
			 tooltip:
			 {
				valueDecimals: 4,
				 pointFormat: tipFormat
				 //pointFormat: '<span style="color:{point.color}">{point.y}</span> '
			 },
				cursor: 'pointer',
			point: {
				events: {
					click: function(e) {
						if(!Ext.isEmpty(e.point) && enableClick)
						{
							var QString=e.point.linkUrl;
							if(QString != "" || QString != 'null' || QString != 'undefined' || QString != undefined)
							{
								if(isMyDashboard)
								{
									var openInNewWindow=e.point.openInNewWindow;
									if(openInNewWindow)
									{
										 loadPopup(QString);
									}
									else
									{
										wayToLayerModel(QString);
									}
								}
								else
								{
									document.location.href=QString;
								}
							}
						}
						else if( fromPage == 'vlive' )
						{
							var maxViewId = jsonData['fullViewId'];
							var resTokens = maxViewId.split(",");
							showFullview(resTokens[0],this.event,resTokens[2])
						}
					}
		   		}
			}
		  },
		  column: {
			borderWidth: 0,
			pointPadding: 0.2,
			stacking: stackingVal,
			dataLabels : {
				rotation:rotateDegree,
				y:-5,
				x:3,
				style:
				{
					textOutline: false,
					textShadow: false
				}
			},
			cursor: 'pointer',
			point: {
				events: {
					click: function(e) {
						if(!Ext.isEmpty(e.point) && enableClick)
						{
							var QString=e.point.linkUrl;
							if(QString != "" || QString != 'null' || QString != 'undefined' || QString != undefined)
							{
								if(isMyDashboard)
								{
									var openInNewWindow=e.point.openInNewWindow;
									if(openInNewWindow)
									{
										 loadPopup(QString);
									}
									else
									{
										wayToLayerModel(QString);
									}
								}
								else
								{
									document.location.href=QString;
								}
							}
						}
					}
		   		}
			}
		  },
		  series: {
			 borderWidth: 0,
			 stacking: stackingVal,
			groupPadding:setGroupPadding,
			pointPadding:setPointPadding,
			 dataLabels: {
				enabled: pieDataLabelsEnable,
				inside:insideVal,
				color:barStyleAttrbs['fontColor'],
				fontFamily:barStyleAttrbs['fontFamily'],
				style:{
					textOutline: false,
					textShadow: false
				}
			},
			states: {
				hover: {
				 enabled: false
				}
           },
			minPointLength:setMinPointLength
		}
    },
   legend: {
	layout: legendLayout,
	//width : (chartWidth-20),
	align: legAlign,
	verticalAlign: 'top',
	y: 50,
	x:0,
   //	itemMarginTop: 5,
   // itemMarginBottom: 5,
    //enabled: showLegend,
    enabled:true,
	//maxHeight : legendMaxHeight,
    itemStyle: {
		color:barStyleAttrbs['legFontClr'],
		fontFamily:barStyleAttrbs['legFontFmy'],
		fontSize:barStyleAttrbs['legFontSize'],
     },
     labelFormatter: function() {
      var retrunvar = Ext.String.htmlDecode(this.name);
      if(retrunvar.length>30 && needLegendFormat == 'true')
      {
       c=0;
       strval=''
       while(c<retrunvar.length)
       {
        strval+=retrunvar.substring(c,c+30)+'<br>';
        c=c+30;
       }
      retrunvar= strval;
      }
      return retrunvar;
     },
    }
   };
	var myhtml = '<table width="100%" height="80%"><tr><td align="center" valign="middle">'+errImgSrc+'</td></tr></table>';
	var chartContObj=document.getElementById(container_Id);
	
//  this.highchart.chart.renderTo = container_Id;
	var chartData=[];
	
	
	if(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined || jsonData.DataSet[0].data == "" || jsonData.DataSet[0].data == 'null' || jsonData.DataSet[0].data == 'undefined' || jsonData.DataSet[0].data == undefined)
	{
		drawChart = false;
		if(chartContObj!=null)
		{
			if(!Ext.isEmpty(jsonData['measureTitle']))
			{
				
				var errHtml = '<center><div style="padding:5px;border:0px solid red;font-family:Arial;font-weight:500;font-size:12px;"><b>'+jsonData['measureTitle']+'</b></div><span ><img style="margin:20% 0 auto 0" src="/final/images/spacer.gif" class="iconAlert"/></span><span class="rumGraphErrorMsgText">No Traffic Detected</span></center>';
				chartContObj.innerHTML=errHtml;
			}
			else
			{
				chartContObj.innerHTML='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';
			}
		}
	}
	else{
		this.highchart= jQuery.extend(true, this.defaults, chartingOptions);
		this.highchart.series=jsonData['DataSet'];
		this.highchart.chart.renderTo = container_Id;
	}
 },
 drawChart: function() {
  if(drawChart)
  {
   Highcharts.setOptions({
    lang: {
      thousandsSep: ''
     }
   });
   Highcharts.setOptions({
    global: {
     useUTC: true,
     timezoneOffset: timeZoneOffsetVal
    }
   });
	Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
	this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin));
   new Highcharts.Chart(this.highchart);
  }
 }
};
return ErHighStockChart;
}

function getDefaults(container_Id,chartHeight,chartWidth,maxURL) {
	var chartDefaultValues={
			chart: {
				plotBorderWidth: 0,
				plotBorderColor : '#C0C0C0',
				backgroundColor:'#ffffff',
				plotBackgroundColor: 'white',
				ignoreHiddenSeries:false,
				spacing:[-20, 5, 0, 5],
				plotShadow: false,
				shadow: false,
				zoomType:'x',
				width:chartWidth,
				height:chartHeight,
				backgroundColor: 'transparent',
				events: {
					load: function(event) {
						// modify the legend symbol from a line to a rect
						jQuery('.highcharts-legend-item rect').attr('height', '8').attr('y', '5');
						jQuery('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
					}
				}
			},
			rangeSelector: {
				enabled: false
			},
			global: {
				useUTC: true,
				timezoneOffset:timeZoneOffsetVal
			},
			lang:{
				contextButtonTitle:'Print/Download Chart'
			},
			navigator: {
				enabled: false
			},
			yAxis: [{
				border :0,
				min: 0,
				lineWidth: 0,
				gridLineWidth: 1,
				tickPixelInterval: 50,
				opposite: true,
				labels: {
					formatter: function() {
						return (this.value > 0 ? ' ' : '') + this.value ;
					},
					style: {
						color : 'black',
						fontFamily: 'Calibri',
						fontSize: '12px',
						textDecoration: 'none',
						whiteSpace: 'normal',
					},
				},
				showLastLabel: true,
			},{
				border :0,
				min: 0,
				lineWidth: 0,
				gridLineWidth: 1,
				tickPixelInterval: 50,
				labels: {
					formatter: function() {
						return (this.value > 0 ? ' ' : '') + this.value ;
					},
					style: {
						color : 'black',
						fontFamily: 'Calibri',
						fontSize: '12px',
						textDecoration: 'none',
						whiteSpace: 'normal',
					},
				},
				showLastLabel: true,
        }],
			plotOptions: {
				series: {
					states: {
					hover: {
						enabled: true,
						lineWidth: 2,
					}
				},
				connectNulls : false,
				smoothed: true,
				lineWidth: 2,
				marker: {
						enabled: false
					}
				},
				line: {
					shadow: false,
					linewidth :10
				}
			},
			scrollbar: {
				enabled: false
			},
			legend: {
				verticalAlign: 'top',
				align:'center',
				layout: 'horizontal',
				borderWidth: 0,
				y:5,
				x:5,
				width: 300,
				adjustChartSize: false,
				navigation: {
					arrowSize: 5
				},
				itemStyle: {
					color : 'black',
					fontFamily: 'Calibri',
					fontSize: '12px',
				},
				symbolWidth: 15
			},
			labels :{
				itemStyle: {
					color : 'black',
					fontFamily: 'Calibri',
					fontSize: '12px',
				}
			},
			tooltip: {
				shared: true,
				borderColor: 'black',
				valueDecimals: 4,
				style: {
						color : 'black',
						padding: 10,
						fontWeight:'500',
						fontFamily: 'Arial',
						fontSize: '11px',
					}
			},
			exporting: {
				enabled: false,
				chartOptions:{
					title:{
						text:''
					}
				}
			},
			credits: {
				enabled: false
			},
			xAxis: {
				border :1,
				lineWidth: 1,
				minPadding:0.02,
				maxPadding:0.02,
				type: 'datetime',
				ordinal: false,
				labels: {
					rotation:270,
					style: {
						color : '#c0c0c0',
						fontFamily: 'Arial',
						fontSize: '10px',
					},
					overflow: 'justify',
					showLastLabel: true,
					endOnTick: true,
					showFirstLabel: false,
					startOnTick: false,
					useHTML: false,
					tickPixelInterval: 75,
				},
				title: {
					enabled: true,
					offset: ''
				}
			},
			series: {
				marker: {
                enabled: false,
				 states: {
                    hover: {
                        enabled: true,
						lineWidthPlus:0
                    }
                }},
				dataGrouping:{
					enabled: false
				}
			}
		};
		return chartDefaultValues;
}
function getCombinationChart(container_Id,chartHeight,chartWidth,maxURL){
	var drawChart = true;
	var resizeObj;
	var idSelect = false;
	var showLegs = false;

	var chartDefaults = getDefaults(container_Id,chartHeight,chartWidth,maxURL);
	var HighStockChart = {
		highchart: null,
		defaults: chartDefaults,
		setData: function(jsonData,currentDateFormat,maxURL,isAxisTimeReq,legendPos) {
			var axisDefaultFamily = "Arial";
			var axisDefaultColor = "#c0c0c0";
			var axisDefaultSize = "11";
			var axisDefaultWeight = "500";
			var toolTipFmt = '';
			var chartType = ( Ext.isEmpty(jsonData['rumChartType']) )?'line':jsonData['rumChartType'];
			var contextBtnColor = (strSkin == 'Light')?"#f7f7f7":'#828282';
			var yAxisTitles = jsonData['yAxisTitle'];
			var chartFileName = jsonData['chartFileName'];
			var mgrDateObj = new Date();
			var currentMgrDate = Ext.Date.format(mgrDateObj,'m.d.Y.H.i.s');
			toolTipFmt = tooltipDateFormate(currentDateFormat);
			var timeline_out_format = '';
			ymax = jsonData['max'];
			ymin = 0;
			var isHtmlTooltip = (Ext.isEmpty(jsonData['useHtml']))?false:jsonData['useHtml'];
			fontFamily = jsonData['fontName'];
			fontSize = jsonData['fontsize'];
			startTime = jsonData['xmin'];
			LegendPosition = jsonData['legendPosition'];
			xLabel = jsonData['axislabel'];
			LegendFont = jsonData['LegendFont'];
			xAxisDisplay = jsonData['xAxisDisplay'];
			var s_time_fout = jsonData['fmts'];
			fontFamily="Arial";
			LegendFont="Arial";
			xLabel =(xLabel == null || xLabel == '')?'':xLabel;
			fontFamily =(fontFamily == null || fontFamily == '')?"Arial":fontFamily;
			fontSize =(fontSize == null || fontSize == '')?'11px':fontFamily+"px";
			startTime =(startTime == null || startTime == '')?null:startTime;
			LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
			LegendFont =(LegendFont == null || LegendFont == '')?"Arial":LegendFont;
			s_time_fout =(s_time_fout == null || s_time_fout == '')?'HH:mm':s_time_fout;
			timeline_out_format = getTimeLineOutputFormat(s_time_fout);
			legendWidth = (LegendPosition == 'right')?150:300;
			maxLegendHeight = (LegendPosition == 'right')?null:50;
			valign = (LegendPosition == 'right')?'middle':'top';
			legendLayout = (LegendPosition == 'right')?'vertical':'horizontal';
			isThresholdLine = ( !Ext.isEmpty( jsonData['isThresholdComparison'] ))?jsonData['isThresholdComparison']:false;
			chartTitle = jsonData['title'];
			enableExport = true;
			lessWidth = 55;
			isHtmlTooltip = ( jsonData['DataSet'].length > 10 )?true:false;
			ymax = ( !isThresholdLine && ymax == 0 )?1:null;
			var axisNameFamily = "",axisNameColor="",axisNameSize = "",axisNameWeight="",timeNameFamily="",timeNameColor="",timeNameSize="",timeNameWeight="";
			plotPanelColor="#C0C0C0";
			if( !Ext.isEmpty(jsonData['styles']) )
			{
				plotPanelColor = ( !Ext.isEmpty( jsonData['styles']['panelLineStyle'] ))?jsonData['styles']['panelLineStyle'].COLOR:"#C0C0C0";
			}
			
			xlineWidth = 1;
			xGridLineWidth = 1;
			ylineWidth = 1;
			yGridLineWidth = 0;
			if (isThresholdLine)
			{
				ylineWidth = 1;
				yGridLineWidth = 0;
				xlineWidth = 1;
				xGridLineWidth = 1;
			}
			axisNameFamily = ( Ext.isEmpty( axisNameFamily ) )?axisDefaultFamily:axisNameFamily;
			axisNameColor = ( Ext.isEmpty( axisNameColor ) )?axisDefaultColor:axisNameColor;
			axisNameSize = ( Ext.isEmpty( axisNameSize ) )?axisDefaultSize:axisNameSize;
			axisNameWeight = ( Ext.isEmpty( axisNameWeight ) )?axisDefaultWeight:axisNameWeight;

			var bgcolor='rgba(255, 255, 255, 0.85)';
			var legendSize = jsonData['DataSet'].length;
			var seriesCounter = jsonData['DataSet'].length;
			bgcolor= ( legendSize== 1 )?jsonData['DataSet'][0]['color']:bgcolor;
			var xVal = (legendSize<=2)?200:0;
			var exportTitle = jsonData['exportTitle'];
			var enableTitle = false;
			enableTitle = jsonData['enableTitle'];
			chartTitle = (enableTitle)?jsonData['title']:'';
			var fromPageVal = '';
			if(!Ext.isEmpty(jsonData['fromPage']))
				fromPageVal = jsonData['fromPage'];
			var seumLegend = ( fromPageVal == 'seum' )?true:false;
			if(legendPos == "bottom")
			{
				valign = 'middle';
				y=5;
				legendWidth = 100
				enableExport = false;
				legendLayout = "right";
				LegendPosition = "center";
				maxLegendHeight = 20;
				var splitStr = chartTitle.split(":");
				if(splitStr!=null && splitStr!=undefined && splitStr.length>0)
				{
					chartTitle = chartTitle.substring(chartTitle.lastIndexOf(":")+1);
				}
			}
			if(Ext.isEmpty(exportTitle))
				exportTitle = chartTitle;
			chartFileName = (Ext.isEmpty(chartFileName))?exportTitle:chartFileName;
			chartFileName = chartFileName+" "+currentMgrDate;
			if(legendSize <= 3)
			{
				valign = 'top';
				y=(Ext.isEmpty(jsonData['smallGraph']))?5:0;
				if(legendPos == "bottom")
				{
					legendWidth = 200;
					 xVal = (legendSize<=2)?100:0;
				}
				else
				{
					legendWidth = 500;
					xVal = 50;
				}

				LegendPosition = 'left';
				legendLayout = 'horizontal';
				maxLegendHeight = 40;
				y=(Ext.isEmpty(jsonData['smallGraph']) && seumLegend )?2:y;
			}
			else
			{
				y=5;
				valign = 'middle';
				legendWidth = 150;
				LegendPosition = 'right';
				legendLayout = 'vertical';
				maxLegendHeight = null;
			}
			if(!isAxisTimeReq)
				xLabel = "";
			var xType = 'datetime';
			var stacked = null;
			var line_width=3;
			var marker_enabled =false;
			var tooltipObj =null;
			var isLegendEnabled = true;
			var tmpEnabled =jsonData['legendEnabled'];
			var isSysDashboard = jsonData['isSysDashboard'];
			var isBigCombination = ( Ext.isEmpty(jsonData['isBigCombination'] ) )?false:jsonData['isBigCombination'];
			var pwdth = ( isBigCombination )?15:5;
			isLegendEnabled = tmpEnabled;
			var yVal = "";
			var offSets = "";
			var showLegends = false;
			var showLegendChkObj = Ext.ComponentQuery.query('#showLegend').length;
			var showLegendChk = Ext.ComponentQuery.query('#showLegend')[(showLegendChkObj -1)];
			if(!Ext.isEmpty(Ext.getCmp('showLegend')))
			{
				showLegends = Ext.getCmp('showLegend').getValue();
				idSelect = true;
			}
			if (showLegendChk != 'undefined' && showLegendChk != undefined )
			{
				showLegends = showLegendChk.getValue();
			}
			showLegends = (seumLegend)?true:showLegends;
			isLegendEnabled = (seumLegend)?true:isLegendEnabled;
			showLegs = showLegends;
			var dashboardName = ( Ext.isEmpty( jsonData['dashboardName'] ) )?"":jsonData['dashboardName'];
			var spaceVal = [10, 15, 0, 10];
			if( !Ext.isEmpty( dashboardName ) && dashboardName == 'rum')
			{
				showLegends = ( Ext.isEmpty( jsonData['enableRumLegend'] ) )?false:jsonData['enableRumLegend'];
				//spaceVal = [10, 15, 0, 15];
				spaceVal = [-20, 15, 0, 5];
			}
			if (isSysDashboard!=null && isSysDashboard)
			{
				showLegends = true;	
				maxLegendHeight = '200px';
				legendWidth = 100;
			}
			/*if(s_time_fout == "%H:%M")
			{
				yVal = 33;
				offSets = 60;
			}
			else
			{
				yVal = 51;
				offSets = 100;
			}*/
			if(s_time_fout == "%H:%M")
			{
				yVal = 10;
				offSets = 60;
			}
			else
			{
				yVal = 6;
				offSets = 75; // For time format more than 24 hours in Measure Graph
			}
			rotVal=270;
			if(xAxisDisplay=='horizontal')
			{
				yVal=13;
				offSets=5;
				rotVal=2;
			}

			var minPad = null;
			if (!Ext.isEmpty(isYaxisBasedOnData) && isYaxisBasedOnData)
			{
				minPad=0;
				ymin = null;
				ymax = null;
			}

			if(ymin!=null && ymax!=null && (ymin == ymax))
				ymax = ymin+1;

			var yAxisTitleOne = ( Ext.isEmpty( yAxisTitles[0] ) )?'':yAxisTitles[0];
			var yAxisTitleTwo = ( Ext.isEmpty( yAxisTitles[1] ) )?'':yAxisTitles[1];
			var toShowLastLabel = ( !Ext.isEmpty( jsonData['showLastLabel'] ) )?jsonData['showLastLabel']:true;
			var isLookBackChart = ( Ext.isEmpty( jsonData['isLookBack'] ))?false:jsonData['isLookBack'];
			legendWidth = (isLookBackChart)?200:legendWidth;
			Highcharts.setOptions({
				global: {
					useUTC: true,
					timezoneOffset:timeZoneOffsetVal
				}
			});
			var chartingOptions = {
				chart:{
					type:chartType,
					plotBorderColor : plotPanelColor,
					spacing:spaceVal,
					events: {
						click: function(e) {
							if( !Ext.isEmpty( e.srcElement ) && ( e.srcElement.firstChild == null || e.srcElement.firstChild == undefined))
							{
								if(maxURL != 'null' && maxURL != 'undefined' && maxURL !='' && maxURL != undefined && maxURL != 'close')
									loadMaximizedView(maxURL);
								else if(maxURL == 'close')
									closeMaximizedView();
							}
							if( !Ext.isEmpty(jQuery(e.target)[0]) )
							{
								var eventText = (jQuery(e.target)[0].textContent);
								if( eventText.indexOf("Reset") > -1 )
									zoomPageRefresh(false);
							}
						},
						load:function() {
							jQuery('.highcharts-legend-item rect').attr('height', '8').attr('y', '5');
							jQuery('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
						},
						selection: function(event) {
							if(event.xAxis) {
								if( !Ext.isEmpty( event.xAxis[0] ) )
								{
									var isZoomed = event.xAxis[0].axis.zoomEnabled;
									if( isZoomed || isZoomed == 'true' )
									{
										zoomPageRefresh(true);
									}
									
								}
							}
						}
					}
				},
				tooltip: {
					xDateFormat:toolTipFmt,
					valueDecimals: 4,
					backgroundColor : bgcolor,
					borderWidth: 1,
					shared: true,
					formatter: function() {
						var items = this.points || splat(this),
						series = items[0].series,s;
						// sort the values
						items.sort(function(a, b){
							return ((a.y > b.y) ? -1 : ((a.y < b.y) ? 1 : 0));
						});
						var s ='';
						if(legendSize==1 || (strSkin=='Dark' || strSkin=='dark') )
							s = '<span style="color:white">'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</span><br/>';
						else
							s = '<span>'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</span><br/>'
						jQuery.each(this.points, function(i, point) {
							var val = Highcharts.numberFormat (point.y,4, '.','');
							var val_ar = val.split('.');
							if(val_ar.length>1)
							{
								if(val_ar[1]=='0000')
									val = val_ar[0];
							}
							if (point.series.name != '' && point.series.name != undefined && isLegendEnabled) {
								if(legendSize==1)
									s += '<b><span style="color:white">'+ Ext.String.htmlDecode(point.series.name) +' :  '+val+'</span></b><br/>';
								else
									s += '<b><span style="color:' + this.series.color + '">'+ Ext.String.htmlDecode(point.series.name) +'  :  '+val+'</span></b><br/>';
							}
							else
							{
								s += '<br/> <b><span style="color:white">'+val+'</span></b><br/>';
							}
						});
						return s;
					}
				},
				title:{
					text:Ext.String.htmlDecode(chartTitle),
				},
				yAxis:[{
					max:ymax,
					opposite: true,
					min : ymin,
					minPadding:minPad,
					lineWidth: ylineWidth,
					gridLineWidth: yGridLineWidth,
					gridLineColor: plotPanelColor,
					lineColor: plotPanelColor,
					labels: {
						align: 'left',
						x: 10,
						y: 3,
						 formatter: function() {
								var val = Highcharts.numberFormat (this.value,4, '.','');
								val = (parseFloat(val));
								return val;
							}
					},
					title: {
						text: Ext.String.htmlDecode(yAxisTitleOne),
						rotation:270,
						x:20
					}
				},{
					max:ymax,
					min : 0,
					lineWidth: ylineWidth,
					gridLineWidth: yGridLineWidth,
					gridLineColor: plotPanelColor,
					lineColor: plotPanelColor,
					labels: {
						align: 'right',
						x: -10,
						y: 3,
						 formatter: function() {
								var val = Highcharts.numberFormat (this.value,4, '.','');
								val = (parseFloat(val));
								return val;
							}
					},
					title: {
						text: Ext.String.htmlDecode(yAxisTitleTwo),
						rotation:270,
						x:-5
					}
				}],
				xAxis: {
					type : xType,
					lineWidth: xlineWidth,
					gridLineWidth: xGridLineWidth,
					gridLineColor: plotPanelColor,
					lineColor: plotPanelColor,
					tickWidth : 0,
					tickLength: 0,
					endOnTick: true,
					showLastLabel:toShowLastLabel,
					labels: {
						//x:4,
						y:yVal,
						rotation:rotVal,
						formatter: function() {
							return  Highcharts.dateFormat(s_time_fout, this.value);
						}
					},
					title: {
						text: Ext.String.htmlDecode(xLabel),
						offset:offSets,
					}
				},
				plotOptions: {
					series: {
						borderColor: '',
						pointWidth:pwdth,
						marker: {
							enabled: marker_enabled,
							states: {
								hover: {
									enabled: true,
									lineWidthPlus:0
								}
							}
						},
						stacking: stacked,
						pointStart:startTime,
						 point: {
							events: {
								click: function(e) {
									//if( !Ext.isEmpty( e.srcElement ) && ( e.srcElement.firstChild == null || e.srcElement.firstChild == undefined))
									{
										if(maxURL != 'null' && maxURL != 'undefined' && maxURL !='' && maxURL != undefined && maxURL != 'close')
											loadMaximizedView(maxURL);
										else if(maxURL == 'close')
											closeMaximizedView();
									}
								}
							}
						}
					},
					scatter: {
						tooltip: tooltipObj,
					}
				},
				legend: {
					enabled:showLegends,
					verticalAlign: valign,
					width:legendWidth,
					align:LegendPosition,
					maxHeight :maxLegendHeight,
					y:y,
					x:xVal,
					symbolRadius:0,
					itemDistance: 50,
					labelFormatter: function() {
						var retrunvar = Ext.String.htmlDecode(this.name);
						if (retrunvar != '' && retrunvar !='undefined' && retrunvar !='infinity') {
							retrunvar = this.name;
						}
						else {
							retrunvar = 'null';
						}
						var str = retrunvar;
						if(valign =="middle" && !isLookBackChart)
						{
							var toolTextStr = '';
							if(str.length >=20)
							{
								toolTextStr=str.substring(0,20);
								var tempToolTextStr=str.substring(20);
								tempToolTextStr = tempToolTextStr.trim();
								while(tempToolTextStr.length >20)
								{
									toolTextStr=toolTextStr+"<br>"+tempToolTextStr.substring(0,20);
									tempToolTextStr=tempToolTextStr.substring(20);
								}
								if(tempToolTextStr.length > 2 )
								{
									var tmpStr = tempToolTextStr.substring(0,2);
									if(tmpStr.indexOf(" ") > -1)
									{
										toolTextStr = str.substring(0,22);
									}
								}
								toolTextStr=toolTextStr+"<br>"+tempToolTextStr;
							}
							else
								toolTextStr = str;
						}
						else
							toolTextStr = retrunvar;

						return toolTextStr;
					}
				},
				navigation: {
					 buttonOptions: {
						x:3
					}
				},
				exporting: {
					filename:chartFileName,
					chartOptions:{
						title:{
							text:Ext.String.htmlDecode(exportTitle)
						}
					},
					buttons: {
						contextButton: {
							theme: {
								fill:contextBtnColor,
								states: {
								hover: {
									enabled: true,
									fill: contextBtnColor
									}
								}
							}
						}
					}
				}
			};
			var chartContObj=document.getElementById(container_Id);
			if(chartContObj == null || chartContObj == undefined)
				chartContObj = Ext.getCmp(container_Id);
			
			this.highchart= jQuery.extend(true, this.defaults, chartingOptions);
			var chartData=[];
			var seriesCounter = 0;
			if(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined )
			{
				drawChart = false;
				if(chartContObj!=null)
				{
					chartContObj.innerHTML='<center><div><span ><img style="margin:20% 0 auto 0" src="/final/images/spacer.gif" class="iconAlert"/></span>&nbsp;&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></center>';
				}
			}else{
				
				this.highchart.series = jsonData['DataSet'];
				this.highchart.chart.renderTo = container_Id;
			}
		},
		drawChart: function(chartDatas) {
			if(drawChart)
			{
				Highcharts.setOptions({
					lang: {
						thousandsSep: ''
					}
				});
				Highcharts.setOptions({
					global: {
						useUTC: true,
						timezoneOffset:timeZoneOffsetVal
					}
				});
				
				Highcharts.seriesTypes.line.prototype.drawLegendSymbol = Highcharts.seriesTypes.column.prototype.drawLegendSymbol;
				Highcharts.seriesTypes.spline.prototype.drawLegendSymbol = Highcharts.seriesTypes.column.prototype.drawLegendSymbol;
				if( !Ext.isEmpty(chartDatas) )
				{
					this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin,true,chartDatas.yAxisTColor));
				}
				else
					this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin,true));
				new Highcharts.Chart(this.highchart,function(chart){
					if(!idSelect)
						jQuery('.showLegend').click(function () { chart.legendToggle(); });
					else
					{
						jQuery('#showLegend').click(function () { chart.legendToggle(); });
					}
				});
			}
		}
	};
	return HighStockChart;
}