
var defaultWidth=1099;
var defaultHeight=655;

var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

var left = ((width / 2) - (defaultWidth / 2)) + dualScreenLeft;
var top = ((height / 2) - (defaultHeight / 2)) + dualScreenTop;

var chartTypeStore="";
var backEndMetricVal="";
var hidePanelLog = new Array();
var showPanelLog = new Array();
Ext.define('endUserDashboardDetails.controller.Main', {
    extend: 'Ext.app.Controller',
    views: ['Main'],
	requires:['endUserDashboardDetails.view.SettingsForm','endUserDashboardDetails.view.AddWidgetWindow','endUserDashboardDetails.view.Gridster'],
	refs: [
    	{selector:'main',ref:'main'},
    	{selector:'userdesktopdata',ref:'userdesktopdata'},
    	{selector:'maximizeview',ref:'maximizeview'},
		{selector:'settingsForm',ref:'settingsForm'},
		{selector:'settings',ref:'settings'},
		{selector:'utilitiestool',ref:'utilitiestool'},
		{selector:'userdesktopdata container[id=BaseContainer]',ref:'baseContainer'},
		{selector : 'addwidgetwindow', ref : 'addwidgetwindow'},
		{
			ref:'gridster',
			selector:'gridster'
		},
	],
	init: function ()
	{
		appCnt = this;
		this.control({
			'main textfield[id=searchString]' : {
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						this.onSearchXenApp();
					}
				}
			},
			'main':
            {
                'afterrender': function(){
					this.loadUserCombo();
					//this.loadPanels();
				}
            },
			'main button[id="backbtn"]':
			{
				'click':this.onBackBtnClick
			},
			'main button[id="AddPanelbtn"]':
			{
				'click':this.onAddPanelBtnClick
			},
			'main button[name="publishDashboard"]':
			{
				'click':this.publishDashboard
			},
			'main button[id="ShowHideBtn"]':
			{
				'click':this.onShowHideBtnClick
			},
			'userdesktopdata':
			{
				'afterrender': function(){
					//this.loadPanelChart();
				}
			},
			'settingsForm':
			{
				'afterrender':this.loadColorPalettes
			},
			'settingsForm combo[id="optionsCombo"]': 
			{
				"select": this.loadConfigurationItems
			},
			'settingsForm radiogroup[id="metrics"]':
			{
				'change': this.loadMetricsItems
			},
			'settingsForm radiogroup[id="modifyOptions"]':
			{
				'change': this.loadModifyOptions
			},
			'settingsForm radiogroup[id="AddDelete"]':
			{
				'change':function(obj){
					metricsData="";
					this.hideProcessCombos();
					this.hideModifyingComponents();
					if(obj.getValue().Config=="showHideRadio")
					{
						this.showOnlyItemSelector();
					}
					else
						this.loadTests();
				 }
			},
			'settingsForm combo[id="ExistingNew"]': 
			{
				"select": this.loadTests
			},
			'settingsForm combo[id="panelNo"]': 
			{
				"select": this.showModifyOptions
			},
			'settingsForm combo[id="group"]': 
			{
				"select": this.changeGroupCombo
			},
			'settingsForm combo[id="test"]': 
			{
				"select": this.loadMeasureForTest
			},			
			'settingsForm combo[id="measure"]': 
			{
				"select": this.loadMeasureDisplay
			},
			'settingsForm combo[id="processName"]': 
			{
				"select": this.loadProcessComboData
			},
			'settingsForm combo[id="process"]': 
			{
				//"select": this.loadMeasureDisplay
			},
			/*'settingsForm radiogroup[id="metrics"]':
			{
				'change':function(){
					metricsData="";
					this.hideProcessCombos();
					this.hideModifyingComponents();					
					this.loadTests();
				 }
			},*/
			 'settingsForm button[id="update"]': 
			{
                "click": this.updateConfiguration
            },
			 'settingsForm button[id="add"]': 
			{
                "click": this.appendMetrics
            },
			'settingsForm button[id="remove"]': 
			{
                "click": this.appendRemoveMetrics
            },
			 'settingsForm>container>button[id="modifyTestMeasure"]': 
			{
                "click": this.loadTestsForModifying
            },
			 'settingsForm combo[id="modifyTestCombo"]': 
			{
                "select": this.loadMeasureForTest
            },
			'main combo[id="userCombo"]': 
			{
				"select": this.loadComponentInTheApp
			},
			'addwidgetwindow button[chartType="Data Panel"]' : {
				'click' : this.createAddPanelBlock
			},
			'addwidgetwindow button[chartType="Area Chart"]' : {
				'click' : this.createAddPanelBlock
			},
			'addwidgetwindow button[chartType="Line Chart"]' : {
				'click' : this.createAddPanelBlock
			},
			'addwidgetwindow button[chartType="Bar Graph"]' : {
				'click' : this.createAddPanelBlock
			},
			'settingsForm combo[id="suppotedCmpType"]': 
			{
				"select": this.loadsuppotedCmpTypesTest
			},
    });
    },
	refreshSearchDetails : function()
	{
			var meC=this;
			if (maxiView)
			{
				if(!Ext.isEmpty(maximizedFunction) && maximizedFunction!=null)
				{
					if(maximizedFunction=='showMaximizedFusion')
					{
						if(maxChartName=='area')
						{
							//this.timelineSubmit();
						}
						else
						{
							var params1 = defaultParams;
							Ext.Ajax.request({
								url:  '/final/servlet/com.eg.EgMonitorResultDispatcher',
								params: params1+"&resultpage=globalsearch&isEndUserDashboard=true",
								scope: this,
								method:'POST',
								timeout:280000,
								success: function (response) 
								{
									if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
									{
										var jsonText = response.responseText;
										publicJson = Ext.decode(jsonText);
										var curViewPort=  Ext.getCmp('endUserDetailsViewPort');
										curViewPort.removeAll();
										curViewPort.add({
												xtype:'main'
											});
										
										curViewPort.doLayout();

										if(maxChartId.length >9)
										{
											maxChartId = maxChartId.substring(9);
										}
										if(!Ext.isEmpty(publicJson['RESULT']['BAR_METRICS']) &&  publicJson['RESULT']['BAR_METRICS'].hasOwnProperty(maxChartId))
										{
											var barChartObjct=FusionCharts.items['maxviewchart_'+maxChartId];
											if(barChartObjct!=null)
											{
												barChartObjct.setDataXML(publicJson['RESULT']['BAR_METRICS'][maxChartId]['XML_DATA']);
											}
										}
									}
								
								}
							});	
						}
					}
					else if(maximizedFunction=='showMaximizedView')
					{
						maxChartName='';
						//meC.timelineSubmit( )
					}
				}
			}
			else
			{
				var params1 = defaultParams;
				Ext.Ajax.request({
					url:  '/final/servlet/com.eg.EgMonitorResultDispatcher',
					params: params1+"&resultpage=globalsearch&isEndUserDashboard=true",
					scope: this,
					method:'POST',
					timeout:280000,
					success: function (response) 
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							publicJson = Ext.decode(jsonText);
							var curViewPort=  Ext.getCmp('endUserDetailsViewPort');
							if(curViewPort!=null){
								curViewPort.removeAll();
								curViewPort.add(
									Ext.create('widget.main')
								);
								//curViewPort.doLayout();
							}
							
						}
					
					}
				});
			}
		//}
	},
    selectPriority: function()
    {
    	var timeline = Ext.getCmp('er_timeline').dataArray;
    	var startDate = formatDate(new Date(getDateFromFormat(Ext.getCmp('er_stdate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
    	var startHr = Ext.getCmp('er_sthr').getValue();
    	var endDate =formatDate(new Date(getDateFromFormat(Ext.getCmp('er_enddate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
    	var endHr = Ext.getCmp('er_endhr').dataArray;
    	var timelineQStr = encodeURIComponent(Ext.getCmp('er_timeline').getValue()+"#"+startDate+' '+startHr+':'+stmin+'#'+endDate+' '+endHr+':'+enmin);
    	var tmpArray = Ext.getCmp('Maximize').dataArray;

    	var getInnerArray = tmpArray[3];

    	var comp = getInnerArray[0];
    	var test = getInnerArray[1];
    	var meas = getInnerArray[2];
    	var ddTestMeas = getInnerArray[3];
    	initLdgMask.show();
    	Ext.Ajax.request({
		    		url: '/final/servlet/com.eg.EgMonitorResultDispatcher',
		    		params: defaultParams+'&resultpage=globalsearch&drilldown=true&drilldowncomp='+encodeURIComponent(comp)+'&drilldowntest='+encodeURIComponent(test)+'&drilldownmeasure='+encodeURIComponent(meas)+'&drilldowntestmeasure='+encodeURIComponent(ddTestMeas)+'&priority='+encodeURI(Ext.getCmp('priority').getValue())+'&graph=bar&timeline='+timelineQStr,
		    		method: 'POST',
					timeout:280000,
		    		success: function( response )
		    		{
		    			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
		    			{
		    				initLdgMask.hide();
		    				var jsonText = response.responseText;
		    				var jsonData = Ext.decode( jsonText );
		    				var xmlData = jsonData['XML_DATA'];
		    				if ( xmlData != '-' )
		    				{
		    					var myChart = new FusionCharts('/final/FusionCharts/swf/Bar2D.swf','chart2', '100%', '100%','0','1');
								myChart.setXMLData(xmlData);
								myChart.setTransparent(true);
								myChart.render('fusionChart');
		    				}
		    				else
		    				{
		    					Ext.select('#fusionChart').update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
		    				}
		    			}
		    		}
		    	});
    },
    timelineSubmit: function()
    {
    	var timeline = Ext.getCmp('er_timeline').getValue();
    //	var startDate = Ext.Date.format(Ext.getCmp('er_stdate').getValue(), 'm/d/Y');
    	var startDate = formatDate(new Date(getDateFromFormat(Ext.getCmp('er_stdate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");

    	var startHr = Ext.getCmp('er_sthr').dataArray;
    //	var endDate = Ext.Date.format(Ext.getCmp('er_enddate').getValue(), 'm/d/Y');
    	var endDate = formatDate(new Date(getDateFromFormat(Ext.getCmp('er_enddate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
    	var endHr = Ext.getCmp('er_endhr').dataArray;
    	var dataArray = Ext.getCmp('Maximize').dataArray;
    	if ( !Ext.isEmpty( dataArray ) )
    	{
    		var getType = dataArray[2];
    		if ( getType.toLowerCase() == 'line_chart' )
    		{
    			var imgURL = dataArray[1]+"&user="+userName;
    			imgURL = imgURL.substring(0, imgURL.indexOf("&endtime") );
    			var er_mode = Ext.getCmp('er_mode').getValue();
    			imgURL = imgURL+'&endtime='+encodeURIComponent(endDate)+'&starttime='+encodeURIComponent(startDate)+'&starthr='+encodeURIComponent(startHr)+'&endhr='+encodeURIComponent(endHr)+'&height='+( Ext.getCmp('Maximize').getHeight() - 50 )+'&width='+( Ext.getCmp('Maximize').getWidth() - 20 )+'&mode='+er_mode+'&tline='+timeline;
				var timelineChart = getOption(timeline,Ext.getCmp('er_stdate').getValue(),startHr,Ext.getCmp('er_enddate').getValue(),endHr);
				if(!Ext.isEmpty(timelineChart) && timelineChart.indexOf("easy") > -1)
				{
					if(!Ext.isEmpty(Ext.get('chartMaximize')))
					{
						Ext.getCmp('chartMaximize').remove();
					}
    				Ext.get('imgDiv').update('<img src="'+imgURL+'" />');
				}
				else
				{
					setHighChart(imgURL,"chartMaximize",Ext.getCmp('Maximize').getHeight()-20,Ext.getCmp('Maximize').getWidth()-20,'',true);
				}
				Ext.get('configMod').animate({duration: 700,to: {y: -200}});
    		}
    		else if ( getType.toLowerCase() == 'area_chart' )
    		{
    			var timelineQStr = encodeURIComponent(Ext.getCmp('er_timeline').getValue()+"#"+startDate+' '+startHr+':'+stmin+'#'+endDate+' '+endHr+':'+enmin);
    			var tmpDataArr = dataArray[3];
    			//initLdgMask.show();
    			Ext.Ajax.request({
		    		url: '/final/servlet/com.eg.EgMonitorResultDispatcher',
		    		params: defaultParams+'&resultpage=globalsearch&drilldown=true&drilldowncomp='+encodeURIComponent(tmpDataArr[0])+'&drilldowntestmeasure='+encodeURIComponent(tmpDataArr[3])+'&graph=area&timeline='+timelineQStr,
		    		method: 'POST',
					timeout:280000,
		    		success: function( response )
		    		{
		    			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
		    			{
							Ext.get('configMod').animate({duration: 700,to: {y: -200}});
		    				//initLdgMask.hide();
		    				var jsonText = response.responseText;
		    				var jsonData = Ext.decode( jsonText );
		    				var xmlData = jsonData['XML_DATA'];
							var chartRndrId='chart2';
					       if (FusionCharts(chartRndrId) != null) 
					             FusionCharts(chartRndrId).dispose();
		    				if ( xmlData != '-' )
		    				{
		    					var myChart = new FusionCharts('/final/FusionCharts/swf/MSArea.swf',chartRndrId, '100%', '100%','0','1');
								myChart.setXMLData(xmlData);
								myChart.setTransparent(true);
								myChart.render('fusionChart');
		    				}
		    				else
		    				{
		    					Ext.select('#fusionChart').update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
		    				}
		    			}
		    		}
		    	});
    		}
    	}
    },
    afterMaximizedViewRendered: function()
    {
    	 this.showConfigDropdown();
         Ext.getBody().on('click',function()
         {
         	Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		 },null,{delegate:'#closeSettings'});

		Ext.Ajax.request({
	      	url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
	      	method: 'POST',
	      	params: 'comesFrom=globalsearch&period=H&time=1 hour&user='+userName,
			timeout:280000,
	      	success: function( response )
	      	{
	      		if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
	      		{
	      			var jsonText = response.responseText;
	      			var jsonData = Ext.decode( jsonText );
	      			var timelineDetails = jsonData['timelinedetails'];
	      			var selectedValues = timelineDetails['timelineSelections'];
	      			if ( !Ext.isEmpty( jsonData ) )
	      			{
	      				Ext.getCmp('er_timeline').suspendEvents(true);
	      				Ext.getCmp('er_timeline').getStore().loadRawData(timelineDetails['timeline']);
	      				Ext.getCmp('er_timeline').setValue(selectedValues['selectedTimeline']);
	      				Ext.getCmp('er_timeline').resumeEvents();
	      				Ext.getCmp('er_stdate').setValue(selectedValues['selectedStartDate']);
	      				Ext.getCmp('er_sthr').setValue(selectedValues['selectedStartHour']);
	      				Ext.getCmp('er_enddate').setValue(selectedValues['selectedEndDate']);
	      				Ext.getCmp('er_endhr').setValue(selectedValues['selectedEndHour']);
	      				Ext.getCmp('er_timeline').fireEvent('select', Ext.getCmp('er_timeline'));
	      				Ext.getCmp('er_mode').setValue('2D');
	      			}
	      		}
	      	}
      });
    },
	showMaximizedGraphView: function( url,grp_title,graphFormat)
	{	
		maxiView = true;
		maximizedFunction='showMaximizedView';
		var isHighChart = (graphFormat.indexOf("highchart") > -1)?true:false;
		var isAxisTimeReq = true;
		var legendPos = "right";
		//var dataArray = Ext.getCmp(id).dataArray;
		var dataArray = url;
    	var getMainWidth = this.getMain().getWidth();
    	var getMainHeight = this.getMain().getHeight();
    	var getTitle = grp_title;
        var genURL = dataArray+'&height='+(getMainHeight-200)+'&width='+(getMainWidth-50)+"&user="+userName;
        var tmpDataArray = new Array();
        tmpDataArray[tmpDataArray.length] = getTitle;
        tmpDataArray[tmpDataArray.length] = genURL;
        tmpDataArray[tmpDataArray.length] = 'LINE_CHART';
        tmpDataArray[tmpDataArray.length] = 'LINE_CHART';
		var imgSrcUrl = '';

		if(isHighChart)
		{
			imgSrcUrl = '<div id="chartMaximize"></div>';
		}
		else
		{
			imgSrcUrl = '<div id="imgDiv" style="margin:6px"><img id="graphImage" src="'+genURL+'" /></div>';
		}

		Ext.widget('maximizeview', {
				title: getTitle,
				width: getMainWidth,
				height: getMainHeight,
				id : 'Maximize',
				dataArray: tmpDataArray,
				html:imgSrcUrl,
				listeners:{
					show:function(){
						if(isHighChart){
							setHighChart(genURL,"chartMaximize",getMainHeight-50,getMainWidth-30,'',isAxisTimeReq,legendPos,true);
						}
						else
						{
							this.update('<table height="100%" width="100%"><tr><td><div align="center" valign="bottom" ><img src="'+genURL+'&height=190&width=400&mode=2D" /></div></td</tr</table>');
						}
					}					
				}
		}).show();

    },
    showMaximizedView: function(id,graphFormat)
    {	
        maxiView = true;
        maximizedFunction='showMaximizedView';
        maxChartId=id;
		var isHighChart = false;
		var isAxisTimeReq = true;
		var legendPos = "right";
		if(graphFormat.indexOf("highchart")>-1){
			isHighChart = true;
		}
    	var dataArray = Ext.getCmp(id).dataArray;
    	var getMainWidth = this.getMain().getWidth();
    	var getMainHeight = this.getMain().getHeight();
    	var getTitle = dataArray[0];
        var genURL = dataArray[1]+'&height='+(getMainHeight-200)+'&width='+(getMainWidth-50)+"&user="+userName;
        var tmpDataArray = new Array();
        tmpDataArray[tmpDataArray.length] = getTitle;
        tmpDataArray[tmpDataArray.length] = genURL;
        tmpDataArray[tmpDataArray.length] = 'LINE_CHART';
        tmpDataArray[tmpDataArray.length] = 'LINE_CHART';
		var imgSrcUrl = '';
		if(isHighChart)
		{
			imgSrcUrl = '<div id="chartMaximize"></div>';
		}
		else
		{
			imgSrcUrl = '<div id="imgDiv" style="margin:6px"><img id="graphImage" src="'+genURL+'" /></div>';
		}

		Ext.widget('maximizeview', {
			title: getTitle,
			width: getMainWidth,
			height: getMainHeight,
			id : 'Maximize',
			dataArray: tmpDataArray,
			html:imgSrcUrl,
			listeners:{
				show:function(){
					if(isHighChart){
						setHighChart(genURL,"chartMaximize",getMainHeight-50,getMainWidth-30,'',isAxisTimeReq,legendPos,true);
					}
					else
					{
						this.update('<table height="100%" width="100%"><tr><td><div align="center" valign="bottom" ><img src="'+genURL+'&height=190&width=400&mode=2D" /></div></td</tr</table>');
					}
				}
			}
		}).show();

    },
	showDDMaximizedFusion: function(  gtkey,tkey,gh )
	{
		var chartRndrId='maxviewddchart';
		if (FusionCharts(chartRndrId) != null) 
			FusionCharts(chartRndrId).dispose();

		maxiView=true;
		maximizedFunction='showMaximizedFusion';
		var getId = '';
		var swfPath = '';

		getId = 'dd-bar-block-';
		swfPath = '/final/FusionCharts/swf/Bar2D.swf';
		var mObj = Ext.getCmp('grpData_'+gh+"_"+gtkey);
		var getMainWidth = this.getMain().getWidth();
		var getMainHeight = this.getMain().getHeight();
		var getTitle = mObj.dataObjArray[tkey]['TITLE'];
		var xmlData = mObj.dataObjArray[tkey]['XML_DATA'];
		Ext.widget('maximizeview', {
				title: getTitle,
				width: getMainWidth,
				height: getMainHeight,
				dataArray: mObj,
				id : 'Maximize',
				html:'<div style="margin:6px;border:0px solid red;width:'+(getMainWidth-20)+'px;height:'+(getMainHeight-200)+'px;" id="fusionChart" ></div>'
		}).show();
		
		if(isFusion)
		{
			if ( xmlData != '-' )
			{
				var myChart = new FusionCharts(swfPath,chartRndrId, '100%', '100%','0','1');
				myChart.setXMLData(xmlData);
				myChart.setTransparent(true);
				myChart.render('fusionChart');
			}
			else
			{
				Ext.select('#fusionChart').update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>')
			}
		}
		else
		{
			var barChartPanel = {};
			barChartPanel = jQuery.extend(true, {}, createBar('fusionChart',(getMainHeight-200),(getMainWidth-20)), barChartPanel);
			barChartPanel.setData(xmlData,'','','bar');
			barChartPanel.drawChart();
		}
		
		isMaximizedView = true;
	},
    showMaximizedFusion: function( chartName, id )
    {
    	{
			var chartRndrId='maxviewchart_'+id;
			if (FusionCharts(chartRndrId) != null) 
				FusionCharts(chartRndrId).dispose();

			maxiView=true;
			maximizedFunction='showMaximizedFusion';
			maxChartName=chartName;
			maxChartId=id;
			var getId = '';
	    	var swfPath = '';
	    	if ( chartName == 'area' )
	    	{
	    		getId = 'area-block-'+id;
	    		swfPath = '/final/FusionCharts/swf/MSArea.swf';
	    	}
	    	else
	    	{
	    		getId = 'bar-block-'+id;
	    		swfPath = '/final/FusionCharts/swf/Bar2D.swf';
	    	}
	    	var dataArray = Ext.getCmp(getId).dataArray;
	    	var getMainWidth = this.getMain().getWidth();
	    	var getMainHeight = this.getMain().getHeight();
	    	var getTitle = dataArray[0];
	    	var xmlData = dataArray[1];
	    	Ext.widget('maximizeview', {
	    			title: getTitle,
					width: getMainWidth,
					height: getMainHeight,
					dataArray: dataArray,
					id : 'Maximize',
					html:'<div style="margin:6px;border:0px solid red;width:'+(getMainWidth-20)+'px;height:'+(getMainHeight-200)+'px;" id="fusionChart" ></div>'
			}).show();

			if(isFusion)
			{
				if ( xmlData != '-' )
				{
					var myChart = new FusionCharts(swfPath,chartRndrId, '100%', '100%','0','1');
					myChart.setXMLData(xmlData);
					myChart.setTransparent(true);
					myChart.render('fusionChart');
				}
				else
				{
					Ext.select('#fusionChart').update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
				}
			}
			else
			{
				var barChartPanel = {};
				barChartPanel = jQuery.extend(true, {}, createBar('fusionChart',(getMainHeight-200),(getMainWidth-20)), barChartPanel);
				barChartPanel.setData(xmlData,'','','bar');
				barChartPanel.drawChart();
			}

	    	isMaximizedView = true;
    	}
    },

	showMaximizedAreaChart: function(id)
    {			
    	var chartRndrId='maxviewchart_'+id;
		if (FusionCharts(chartRndrId) != null) 
			FusionCharts(chartRndrId).dispose();
		var getId = 'area-block-'+id;
		var swfPath = '/final/FusionCharts/swf/MSArea.swf';
		var comp=Ext.getCmp(getId);
		var dataArray = comp.dataArray;
		var graphFormat=comp.chartType;
		var graphURL=comp.URL;
		var getMainWidth = this.getMain().getWidth();
		var getMainHeight = this.getMain().getHeight();
		var getTitle = dataArray[0];
		var xmlData = dataArray[1];
		var html;
		
		if(graphFormat.indexOf("highchart")>-1)
		{
			html = '<div id="chartId"></div>';
		}
		else if(graphFormat.indexOf("easychart")>-1)
		{
			html = '<div id="chartId" style="margin:6px;border:0px solid red;width:'+(getMainWidth-20)+'px;height:'+(getMainHeight-200)+'px;"><img id="graphImage" src="'+graphURL+'&height='+(getMainHeight-50)+'&width='+(getMainWidth-30)+'&mode=2D" /></div>';
		}
		else
		{
			html='<div style="margin:6px;border:0px solid red;width:'+(getMainWidth-20)+'px;height:'+(getMainHeight-200)+'px;" id="chartId" ></div>';
		}
		Ext.widget('maximizeview', {
				title: getTitle,
				width: getMainWidth,
				height: getMainHeight,
				dataArray: dataArray,
				id : 'Maximize',
				html:html,
				listeners:{
					show:function(){
						if(graphFormat.indexOf("fusioncharts")>-1)
						{
							if ( xmlData != '-' )
							{
								var myChart = new FusionCharts(swfPath,chartRndrId, '100%', '100%','0','1');
								myChart.setXMLData(xmlData);
								myChart.setTransparent(true);
								myChart.render('chartId');
							}
							else
							{
								Ext.select('#chartId').update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>')
							}
						}
						else
						{
							if(graphFormat.indexOf("highchart")>-1)
							{
								setHighChart(graphURL,"chartId",getMainHeight-50,getMainWidth-30,'',true,'right',false);
							}
							else
							{
								//Ext.select('#chartId').update('<table height="100%" width="100%"><tr><td><div align="center" valign="bottom" ><img src="'+graphURL+'&height='+getMainHeight-50+'&width='+getMainWidth-30+'&mode=2D" /></div></td</tr</table>');
							}			
						}
					}
				}
		}).show();
		isMaximizedView = true;
    },


    loadDialCharts: function()
    {
    	var loadId = "DialPanel";
    	if ( !Ext.isEmpty( Ext.getCmp(loadId) ) )
    	{
			var dialValues = Ext.getCmp(loadId).dataArray;
			if ( !Ext.isEmpty( dialValues ) )
			{
				for ( var key in dialValues )
				{
					if ( dialValues[key]['XML_DATA'] != undefined )
					{
						var xmlData = dialValues[key]['XML_DATA'];
						if ( xmlData != '-' )
						{
							var chartRndrId='dialchart-'+key;
							if (FusionCharts(chartRndrId) != null) 
							 FusionCharts(chartRndrId).dispose();

							var myChart = new FusionCharts('/final/FusionCharts/swf/AngularGauge.swf',chartRndrId, '100%', '100%','0','1');
							myChart.setXMLData(xmlData);
							myChart.setTransparent(true);
							myChart.render('dial-block-'+key);
						}
						else
						{
							Ext.select('#dial-block-'+key).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>')
						}
					}
				}
			}
		}
    },
    loadAreaCharts: function()
    {
    	var loadId = "AreaPanel";
    	
    	var areaValues = Ext.getCmp(loadId).dataArray;
    	if ( !Ext.isEmpty( areaValues ) )
    	{
    		for ( var key in areaValues )
    		{
    			if(isFusion){
					if ( areaValues[key]['XML_DATA'] != undefined )
					{
					   var chartRndrId='areachart-'+key;
					   if (FusionCharts(chartRndrId) != null) 
							 FusionCharts(chartRndrId).dispose();
						var xmlData = areaValues[key]['XML_DATA'];
						var dataArray = Ext.getCmp('area-block-'+key).dataArray;
						var detailsArr = new Array();
						detailsArr[detailsArr.length] = areaValues[key]['COMPONENT_DETAILS'];
						detailsArr[detailsArr.length] = areaValues[key]['TEST'];
						detailsArr[detailsArr.length] = areaValues[key]['MEASURE'];
						detailsArr[detailsArr.length] = areaValues[key]['COMBINED_TEST_MEASURES'];
						dataArray[1] = xmlData;
						dataArray[2] = 'AREA_CHART';
						dataArray[3] = detailsArr;
						if ( xmlData != "-" )
						{
							var myChart = new FusionCharts('/final/FusionCharts/swf/MSArea.swf',chartRndrId, '100%', '100%','0','1');
							myChart.setXMLData(xmlData);
							myChart.setTransparent(true);
							myChart.render('areaChart-'+key);
						}
						else
						{
							Ext.select('#areaChart-'+key).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>')
						}
						Ext.getCmp('area-block-'+key).dataArray = dataArray;
	//    				Ext.getCmp('area-block-'+key).doLayout();
					}
				}
				else
				{
					if(!Ext.isEmpty(areaValues[key]['IMAGE_URL']))
					{						
						var url = areaValues[key]['IMAGE_URL']+"&anonymousUser=true&dashboardUserId="+userName;
						var imgHeight = 190;
						var imgWidth = 430;
						var containerId='area-block-'+key;
						setHighChart(url,containerId,imgHeight,imgWidth,'',true,'right',false);	
					}
					else
					{
						Ext.select('#areaChart-'+key).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
					}			
				}
				
    		}
    	}
    },
    loadBarCharts: function( id )
    {	
    	var loadId = "BarPanel";
    	
    	var barValues = Ext.getCmp(loadId).dataArray;
    	if ( !Ext.isEmpty( barValues ) )
    	{
    		for ( var key in barValues )
    		{
    			if ( barValues[key]['XML_DATA'] != undefined )
    			{
					var chartRndrId='barchart-'+key;
			       if (FusionCharts(chartRndrId) != null) 
						 FusionCharts(chartRndrId).dispose();
    				var chartHeight = barValues[key]['XML_DATA'].chartHeight;
					var xmlData = barValues[key]['XML_DATA'];
					var barObj = Ext.getCmp('bar-block-'+key);
					var dataArray = barObj.dataArray;
    				var detailsArr = new Array();
    				detailsArr[detailsArr.length] = barValues[key]['COMPONENT_DETAILS'];
    				detailsArr[detailsArr.length] = barValues[key]['TEST'];
    				detailsArr[detailsArr.length] = barValues[key]['MEASURE'];
    				detailsArr[detailsArr.length] = barValues[key]['COMBINED_TEST_MEASURES'];
    				dataArray[1] = xmlData;
    				dataArray[2] = 'BAR_CHART';
    				dataArray[3] = detailsArr;
    				if(isFusion)
					{
						if ( xmlData != "-" )
						{
							Ext.getCmp('barMaximizedId'+key).setVisible(true);
							var myChart = new FusionCharts('/final/FusionCharts/swf/Bar2D.swf',chartRndrId, '100%', '100%','0','1');
							myChart.setXMLData(xmlData);
							myChart.setTransparent(true);
							myChart.render('barChart-'+key);
						}
						else
						{
							Ext.getCmp('barMaximizedId'+key).setVisible(false);
							Ext.select('#barChart-'+key).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>')
						}
						Ext.getCmp('bar-block-'+key).dataArray = dataArray;
						Ext.getCmp('bar-block-'+key).doLayout();
						}
					else
					{
						var barChartPanel = {};
						barChartPanel = jQuery.extend(true, {}, createBar('barChart-'+key,chartHeight,300), barChartPanel);
						barChartPanel.setData(xmlData,'','','bar');
						barChartPanel.drawChart();
					}					
    			}
    		}
    	}
    },
    beforeUserDesktopDataShow: function()
    {
    	var screenLabels = publicJson['RESULT']['screenLabels'];
    	if ( screenLabels != undefined )
    	{	    	
			Ext.getCmp('usersummarytitle').update('<b>'+screenLabels['monitor.common.User Summary']+'</b>');
	    	Ext.getCmp('ipAddressLbl').setText(screenLabels['monitor.common.ipAddres']+":");
	    	Ext.getCmp('osTypeLbl').setText(screenLabels['monitor.common.OS']+":");
    	}
    },
	afterMainRendered: function()
	{
		var resultObj = publicJson['RESULT'];
		if ( resultObj != undefined )
		{
			var title = resultObj['TITLE'];
			var getView = resultObj['VIEW'];
			this.getMain().setTitle(title);
			this.showUserDesktop( resultObj );
		}
	},
	showUserDesktop: function ( resultData )
	{
		var iniOrder = resultData['ORDER'];
		if(!Ext.isEmpty(iniOrder))
		{
			this.getUserdesktopdata().show();
			this.updateSessionDetails(resultData['Session_Details'],"sessionDetails");
			this.updateLoginDetails(resultData['Login_Details'],"loginDetails");
			if(iniOrder.length>0)
			{
				for(i=0;i<iniOrder.length;i++){
					var metrics = iniOrder[i];
					if(metrics=="Group_Metrics"){
						this.genGroupMetrics("GroupPanel", resultData['Group_Metrics']);
					}else if(metrics=="Dial_Metrics"){
						//this.genDialCharts("DialPanel", resultData);
					}else if(metrics=="Bar_Metrics"){
						this.loadBarMetrics("BarPanel", resultData);
					}else if(metrics=="Line_Metrics"){
						this.loadLineMetrics("BarPanel", resultData);
					}else if(metrics=="Area_Metrics"){
						this.loadAreaMetrics("BarPanel", resultData);
					}
				}
			}
			else
			{
				var strErr = resultData['ERROR'];
				if(!Ext.isEmpty(strErr))
				{
					var errPanelObj = Ext.getCmp("ErrPanel");
					if(!Ext.isEmpty(errPanelObj))
					{
						errPanelObj.show();
					}

					var configWindowObj = Ext.getCmp("configWindow");
					if(!Ext.isEmpty(errPanelObj))
					{
						configWindowObj.hide();
					}
				}
			}
		}
		else
		{
			var strErr = resultData['ERROR'];
			if(!Ext.isEmpty(strErr))
			{
				var errPanelObj = Ext.getCmp("ErrPanel");
				if(!Ext.isEmpty(errPanelObj))
				{
					errPanelObj.show();
				}

				var configWindowObj = Ext.getCmp("configWindow");
				if(!Ext.isEmpty(errPanelObj))
				{
					configWindowObj.hide();
				}
			}
		}
	},
	genGroupMetrics: function(id, resultData){
		var groupAllValues = resultData['GROUP_VALUES'];
		var groupHeaders = resultData['GROUP_HEADER'];
		var groupObj = Ext.getCmp(id);
		var ghkey;
		for ( ghkey in groupHeaders )
		{
			var flg=false;
			var mgsty="0 8 8 0";
				if(flg)
				{	
					mgsty="0 0 0 0";
					flg=false;
				}
				else 
					flg=true;
			var grpHeader = groupHeaders[ghkey];
			if(!Ext.isEmpty(grpHeader))
			{
				//<td><div style="margin-right:0px;" class="state_'+groupDataState+'" title="'+groupDataStateTip+'"></div></td>
				var groupData = groupAllValues[ghkey][grpHeader];
				var groupDataState = groupAllValues[ghkey][grpHeader+"_STATE"];
				var groupDataStateTip = groupAllValues[ghkey][grpHeader+"_STATE_TIP"];
				if(!Ext.isEmpty(groupData))
				{
					groupObj.add(
					{
						//columnWidth:.333,
						//xtype: 'panel',
						id: 'grpColPanel'+ghkey,
						itemId: 'grpColPanel'+ghkey,
						//cls:'block1',
						//cls:'datapanel',
						border:false,
						frame:false,
						scroll: false,
						autoScroll:true,
						//style:{'border':'1px solid #D2D2D2'},
						margin:mgsty,
						height:200,
						padding:0,
						//margin:'0 8 8 0',
						title:'<table ><tr><td style="padding-left:6px">'+grpHeader+'</td></tr></table>',
						items:[
						{
							xtype: 'container',
							id:'grpData_'+grpHeader+"_"+ghkey,
							itemId:'grpData_'+grpHeader+"_"+ghkey,
							idVal:ghkey,
							autoScroll:true,
							border:1,
							dataObjArray:null,
							html: ''
						}]
					});

					var key;
					var dkey;
					var temp='<table align="left" cellpadding="5" style="margin:4px 10px 0 5px;border:0px solid blue">';
					var ddBarObjArray = new Array();
					for ( key in groupData )
					{
						var grpVal = groupData[key];
						var title = grpVal['TITLE'];
						var measureVal = grpVal['MEASURE_VALUE'];
						var measureGraphURL = "";

						var unit = grpVal['UNIT'];
						var stateVal = grpVal['STATE'];
						var stateTip = grpVal['STATE_TIP'];
						var graphFormat = grpVal['GRAPH_FORMAT'];

						if(Ext.isEmpty(stateVal) || stateVal=="-" )
							stateVal="GOOD";

						var grpLink='<td align="right" width="80"><b style="font-size:14px;text-align:left;">'+measureVal+'</b></td>';
						if(!Ext.isEmpty(grpVal['MEASURE_URL']))
						{
							measureGraphURL = grpVal['MEASURE_URL'];
							grpLink='<td align="right" width="80" ><b style="font-weight:bolder;text-align:left;"><a href="javascript:void(0);" onclick="javascript:openGraph(\''+measureGraphURL+'\',\''+title+unit+'\',\''+graphFormat+'\');">'+measureVal+'</a></b></td>';
						}

						var ddLink = '<td align="right" width="20"><img src="/final/monitor/eg_images/spacer.gif" width="20"/></td>';
						if(!Ext.isEmpty(grpVal['BAR_METRICS']))
						{
							var ddBarValues = grpVal['BAR_METRICS'];
							ddBarObjArray[dkey]=ddBarValues;
							var ddtip="DIAGNOSIS";
							ddLink='<td align="right" width="20"><a href="javascript:void(0);" onclick="javascript:openDDMaxBar(\''+ghkey+'\',\''+dkey+'\',\''+grpHeader+'\');"><div class="iconDiagnosis" style="border:0px solid red;margin-left:9px" title="'+ddtip+'"></div></a> </td>';
							dkey++;
						}

						temp=temp+'<tr><td width="35"><div style="margin-right:5px;margin-left:3px;" class=stateSymbol_'+stateVal+' title="'+stateTip+'"></div></td><td align="left" style="font-weight:normal" width="90%">'+title+' '+unit+'</td>'+grpLink+ddLink+'</tr>';
					}
					temp=temp+'</table>';

					var grpDataObj = Ext.getCmp('grpData_'+grpHeader+"_"+ghkey);
					grpDataObj.update(temp);
					grpDataObj.dataObjArray=ddBarObjArray;
				}
			}
		}
		groupObj.doLayout(); // Need to check this case for design - Jaiwin
	},
	genDialCharts: function( id , resultData )
	{
		var dialObj = Ext.getCmp(id);
		var dialValues = resultData['DIAL_METRICS'];

		if ( !Ext.isEmpty( dialValues ) )
		{
			dialObj.add(
			{
				xtype: 'container',
				id: 'dialpanel',
				cls:'datapanel',				
				border:true,
				frame:true,
				style:{'border':'0px solid red'},
				layout:'column',
				margin:'0 0 0 0',
				defaults:
				{
					columnWidth:.25
				}
			});
			var dialPanelObj = Ext.getCmp('dialpanel');
    		for ( var key in dialValues )
    		{
    			var dialTitle = dialValues[key]['TITLE'];
    			var xmlData = dialValues[key]['XML_DATA'];
    			dialPanelObj.add(
    			{
    				xtype: 'container',
		        	id: 'dialblock'+key,
		        	itemId: 'dialblock'+key,
					title:dialTitle,
					border:false,
					frame:true,
		        	height: 130,
					defaults:{
						margin:4
					},
		        	items:[
							{
		        			xtype:'label',
							width:'100%',
							labelAlign:'center',
							html:'<b>'+dialTitle+'</b>',
							},
							{
								xtype: 'container',
								html: '<div id="dial-block-'+key+'" style="border:0px solid green;height:100px;"></div>'
		        			}
		        	]
    			});
    		}
			if(Ext.getCmp('dialblock'+key[0])){
				Ext.getCmp('dialblock'+key[0]).addCls('lastChild');
			}
			Ext.create
    		dialObj.doLayout();
	    	var getItems = dialObj.items.length;
	    	if ( ( getItems / 4 ) > 1 )
	    	{
	    		var genHt = Math.ceil(( getItems / 4 ));
		    	var tmpHeight = dialObj.getHeight() * genHt;
		    	tmpHeight = Math.round(tmpHeight);
		    	dialObj.setHeight(tmpHeight);
	    	}
    		dialObj.dataArray = dialValues;
    		dialObj.fireEvent('boxready', dialValues);
    	}
	},
	loadLineMetrics: function( id, resultData)
	{
		var highChartUrls = new Array();
		var highChartIds = new Array();
		var highChartHeight = new Array();
		var highChartWidth = new Array();
		var highChartMaxUrl = new Array();
		var lineObj = Ext.getCmp(id);
    	var lineValues = resultData['LINE_METRICS'];
		var isAxisTimeReq = false;
		var legendPos = "bottom";
		var j=0;
    	if ( !Ext.isEmpty( lineValues ) )
    	{
			var linePanelObj = Ext.getCmp('BarPanel');			
    		for ( var key in lineValues )
    		{
    			var lineTitle = lineValues[key]['TITLE'];
    			var imgURL = lineValues[key]['IMAGE_URL']+"&user="+userName;
				var graphFormat = lineValues[key]['GRAPH_FORMAT'];
    			var tmpArray = new Array();
    			tmpArray[tmpArray.length] = lineValues[key]['COMPONENT_DETAILS'];
    			tmpArray[tmpArray.length] = lineValues[key]['TEST'];
    			tmpArray[tmpArray.length] = lineValues[key]['MEASURE'];
    			var imgHeight = 190;
    			var imgWidth = 430;
    			var dataArray = new Array();
    			dataArray[0] = lineTitle;
    			dataArray[1] = imgURL;
    			dataArray[2] = tmpArray;
				var imgDiv = '',isTitleHidden = false;
				if(!Ext.isEmpty(graphFormat))
				{
					if(graphFormat.indexOf("highchart") > -1)
					{
						imgDiv = '<div id="desktopChart'+key+'"></div>';
						highChartIds.push('desktopChart'+key);
						highChartUrls.push(imgURL);
						highChartHeight.push(imgHeight);
						//highChartWidth.push((this.getWidth() - 10 ));
						isTitleHidden = true;
						highChartMaxUrl.push('highchartlineblock'+key);
					}
				}
    			linePanelObj.add(
    			{
    				xtype: 'panel',
		        	id: 'lineblock'+key,
		        	itemId: 'lineblock'+key,
		        	cls: 'datapanel',
					columnWidth:.33,
		        	dataArray: dataArray,
					border:true,
					frame:true,
					//layout: 'vbox',
					title:lineTitle,
		        	//margin:'0 0 10 10',
					padding:'0 0 0 0',
					width: '33%',	
					style:{'border':'0px solid blue'},
					//columnWidth:.333,
		        	height: 240,
					tools:[{
						xtype:'button',
						cls:'iconMaximize',
							hidden:true,
						style:{'border':'none'},
						handler: function()
						{							
							maximizedView(this.up('panel').id,graphFormat);
						}
					}],
		        	items:[
		        		{
		        			xtype: 'container',
		        			layout: 'hbox',
		        			width: '100%',
							height: 190,
							padding:'8 0 0 0',
							id:'desktopChart'+key,
		        			items:[
		        				{
		        					xtype: 'container',
									//flex:.7,
									id:'dh'+key,
									idVal:key,
									height:'100%',
									//width: '100%',
									width:'100%',
		        					//margin:'0px 5px 2px 10px',
									border:1,
		        					dataArray: imgURL,
		        					listeners:{
										'afterrender': function(currObj)
										{
											var URL = this.dataArray;
											var winWidth = jQuery(window).width();
											var winHeight = jQuery(window).height();
											var index=currObj.idVal;
											imgWidth=(Math.round(winWidth/3)-20);
											if(!Ext.isEmpty(graphFormat))
											{
												if(graphFormat.indexOf("highchart") > -1)
												{
													//setHighChart(highChartUrls[j],highChartIds[j],highChartHeight[j],imgWidth,'',isAxisTimeReq,legendPos,false);
													if(!Ext.isEmpty(highChartUrls[j]))
													{
														Ext.Ajax.request(
														{
															url : highChartUrls[j]+"&anonymousUser=true&dashboardUserId="+userName,
															scope:this,
															method: 'POST',
															timeout:280000,
															success: function(response) 
															{	
																if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
																	{
																		if(response.responseText.indexOf('.png')>=0)
																		{	
																			Ext.select('#'+currObj.id).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
																		}
																		else
																		{	
																			var chartData=Ext.decode(response.responseText);
																			var showChartCurrentValue="yes";
																			var showCharLegend="yes";
																			if(!Ext.isEmpty(chartData) && chartData!='' && chartData.hasOwnProperty('DataSet'))
																			{
																				try
																				{
																					var dataSetObjArray=chartData.DataSet;
																					var measHeight=currObj.getHeight();
																					var measWidth = currObj.getWidth();
																					if ((dataSetObjArray != null && !Ext.isEmpty(dataSetObjArray))) {
																						var liveMeasHtml= '<div class="chartCount" style="border:0px solid red;width:300;overflow:auto;height:64px"><ul >';
																						for(var dObj in dataSetObjArray)
																						{	
																						   var seriesObj = dataSetObjArray[dObj];
																						   if (seriesObj != null && seriesObj.hasOwnProperty('dispLegend')) 
																						   {																						
																								var legndName = seriesObj['dispLegend'];		
																								var measVal = seriesObj['measVal'];
																								var measState = seriesObj['measState'];
																								var layerModelUrl = seriesObj['layerModelUrl'];
																								var legndColor=seriesObj['color'];
																								var unitForMeas=seriesObj['unit'];
																								liveMeasHtml += '<li>';
																								if(showChartCurrentValue.toLowerCase()!="no" && showChartCurrentValue.toLowerCase()=="yes")
																								{
																									 if (seriesObj != null && layerModelUrl!="-") {
																										liveMeasHtml += '<div class="uxGraphValue_WHITE">';
																										  if((showChartCurrentValue.toLowerCase()!="no" && showCharLegend.toLowerCase()=="no") )
																										  {
																										   liveMeasHtml += '<div><span class="chartLegend" style="color:'+legndColor+'">.</span>';
																										  }
																										  //liveMeasHtml += '<a class="uxGraphValue_WHITE" href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'>'+ measVal + '</a></div>'
																										  //liveMeasHtml += '<a class="uxGraphValue_'+measState+'" href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'>'+ measVal + '</a></div>'
																										  liveMeasHtml += '<div style="margin-top:0px" class="uxGraphValue_WHITE" onclick=href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'><img  class=\"stateSymbol_'+measState+'\" src=\"/final/images/clear.png\" border=\"0\" s/>'+ measVal + '</div>';
																									 } else {
																										  //liveMeasHtml += '<li><div class="uxGraphValue_WHITE">';
																										 // liveMeasHtml += '<div><span class="chartLegend" style="color:'+legndColor+'">.</span>22';
																										  //liveMeasHtml += measVal + '</div>';

																										  liveMeasHtml += '<div style="margin-top:0px" class="uxGraphValue_WHITE" ><img  class=\"stateSymbol_'+measState+'\" src=\"/final/images/clear.png\" border=\"0\" />'+ measVal + '</div>';
																									 }
																								}
																								if(showCharLegend.toLowerCase()!="no" && showCharLegend.toLowerCase()=="yes")
																								{
																								 liveMeasHtml += '<div><span class="chartLegend" style="color:'+legndColor+'">.</span>';
																								 if (measVal != null && (measVal!="-" && layerModelUrl!="-")) {
																								  liveMeasHtml += '<a href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'><span class="status">'
																									+ legndName + '</span></a>';
																								  if (unitForMeas != null && (unitForMeas!="-" && unitForMeas!="undefined" && unitForMeas!="")) {
																								   liveMeasHtml += '<a href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'><span class="matric"> ('
																									 + unitForMeas + ')</span></a>';
																								  }
																								 } else {
																								  liveMeasHtml += '<span class="uxGraphLabel" style="white-space:nowrap">' + legndName + '</span>';
																								  if (unitForMeas != null && (unitForMeas!="-" && unitForMeas!="undefined" && unitForMeas!="")) {
																								   liveMeasHtml += '<span class="matric"> (' + unitForMeas + ')</span>';
																								  }
																								 }
																								 liveMeasHtml += '</div>';
																								}
																								liveMeasHtml += '</li>'
																						   }
																						  }
																						  liveMeasHtml += '</ul></div>';
																						  if (liveMeasHtml != null && liveMeasHtml != "") {
																							  liveMeasHtml = '<div>' + liveMeasHtml + '</div></div> <div id="measureLineGraph_'+index+'" class="timelineDiv" style="border:0px solid yellow;height:'+measHeight+'px;width:100%">';
																							  
																							  this.update(liveMeasHtml);
																							  var lineChart = {};
																							  lineChart = jQuery.extend(true, {}, getHighCharts('measureLineGraph_'+index,measHeight,measWidth,''), lineChart);
																							  lineChart.setData(chartData,mgrDateFormat,'',true,'right');
																							  lineChart.drawChart();
																						}
																					}
																					else
																					{
																						Ext.select('#'+currObj.id).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
																					}
																					
																				}
																				catch (e)
																				{
																					alert("exception in highchart method::"+e);
																				}
																			}
																			else
																			{	
																				Ext.select('#'+currObj.id).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
																			}
																		}								
																	}
															}
														});
													}
												}
												else
												{
													this.update('<table height="100%" width="100%"><tr><td><div align="center" valign="bottom" ><img src="'+URL+'&height='+imgHeight+'&width='+imgWidth+'&mode=2D" /></div></td</tr</table>');
												}
											}
											else
											{
												this.update('<table height="100%" width="100%" ><tr><td><div align="center" valign="bottom" ><img src="'+URL+'&height='+imgHeight+'&width='+imgWidth+'&mode=2D" /></div></td</tr</table>');
											}
											j = j+1;
										}
		        					}
		        				}
		        			]
		        		}
		        	]
    			});
    		}
    		lineObj.doLayout();
    		var getItems = lineObj.items.length;
	    	if ( ( getItems / 2 ) > 1 )
	    	{
	    		var genHt = Math.ceil(( getItems / 2 ));
		    	var tmpHeight = 250 * genHt;
		    	tmpHeight = Math.round(tmpHeight);
		    	//lineObj.setHeight(tmpHeight);
	    	}
    	}
	},
	loadBarMetrics: function( id, resultData )
	{
		var barObj = Ext.getCmp(id);
    	var barValues = resultData['BAR_METRICS'];
		if ( !Ext.isEmpty( barValues ) )
		{
			/*barObj.add(
			{
				//xtype: 'container',
				id: 'barpanel',
				//cls:'block1',
				border:false,
				frame:false,
				
				//layout:'column',
				//margin:10,
				//height:300,
				defaults:
				{
					margin:'0 8 8 0',
					//columnWidth:.333
				}
			});*/
			var barPanelObj = Ext.getCmp('BarPanel');

			for ( var key in barValues )
			{
				var flg=false;
				var mgsty="0 8 8 0";
				if(flg)
				{	
					mgsty="0 0 8 0";
					flg=false;
				}
				else 
					flg=true;

				var barTitle = barValues[key]['TITLE'];
				var dataArray = new Array();
    			dataArray[0] = barTitle;
				barPanelObj.add(
				{
    				xtype: 'panel',
		        	id: 'bar-block-'+key,
					autoScroll:true,
		        	itemId: 'bar-block-'+key,
		        	cls: 'datapanel',
					style:{'border':'0px solid orange'},
		        	dataArray: dataArray,
					border:false,
					frame:true,
					title:barTitle,
					barId:key,
					columnWidth:.33,
		        	//layout:'column',
					margin:mgsty,
					//height:300,
		        	height: 240,
					tools:[{
						xtype:'button',
						cls:'iconMaximize',
						id:'barMaximizedId'+key,
						hidden:true,
						style:{'border':'none'},
						handler: function()
						{
							maximizedFusion('bar',this.up('panel').barId);
						}
					}],
		        	items:[
		        		{
		        			xtype: 'container',
							width:'100%',
		        			html: '<center><div style="margin-top:-10px"><div id="barChart-'+key+'" style="height:auto;border:0px solid red;"></div></div></center>'
		        		}
		        	]
				});
			}
			barObj.dataArray = barValues;
			barObj.fireEvent('boxready', barValues);
			barObj.doLayout();
			var getItems = barObj.items.length;
	    	if ( ( getItems / 2 ) > 1 )
	    	{
	    		var genHt = Math.ceil(( getItems / 2 ));
		    	var tmpHeight = 500 * genHt;
		    	tmpHeight = Math.round(tmpHeight);
		    	barObj.setHeight(tmpHeight);
	    	}
		}
	},

	loadAreaMetrics: function(id, resultData){
		var lineObj = Ext.getCmp(id);
		var areaValues = resultData['AREA_METRICS'];
    		if ( !Ext.isEmpty( areaValues ) )
    		{
				/*lineObj.add(
				{
					xtype: 'container',
					id: 'areapanel',			
					border:false,
					frame:true,
					style:{'border':'0px solid yellow'},
					layout:'column',
					defaults:
					{
						margin:'0 8 8 0',
						columnWidth:.33
					}
				});*/
				var areaPanelObj = Ext.getCmp('BarPanel');

    			for ( var key in areaValues )
    			{
					var chartType=areaValues[key]['GRAPH_FORMAT'];
    				var areaTitle = areaValues[key]['TITLE'];
					var graphURL;
					if(!Ext.isEmpty(areaValues[key]['IMAGE_URL']))
					{
						graphURL=areaValues[key]['IMAGE_URL']+"&anonymousUser=true&dashboardUserId="+userName;
					}
    				var dataArray = new Array();
    				dataArray[0] = areaTitle;
    				dataArray[2] = 'AREA_CHART';
    				areaPanelObj.add(
    				{
	    				xtype: 'panel',
			        	id: 'area-block-'+key,
			        	itemId: 'area-block-'+key,
			        	cls: 'datapanel',
			        	dataArray: dataArray,
			        	layout: 'vbox',
						frame:true,
						border:false,
						style:{'border':'0px solid violet'},
						areaId:key,
						title:areaTitle,
						chartType:chartType,
						URL:graphURL,	
						height: 240,
						columnWidth:.33,
						tools:[{
							xtype:'button',
							cls:'iconMaximize',
							style:{'border':'none'},
							hidden:true,
							handler: function()
							{
								showMaximizedAreaChart(this.up('panel').areaId);
							}
						}],
			        	items:[
			        		{
			        			xtype: 'container',
			        			width: '100%',
								items:[{
									xtype:'container',
									id:'areaChart-'+key,
									chartId:'areaChartId-'+key,
									inKey:key,
									listeners:{
										'afterrender':function(obj){
											var inKey=obj.inKey;
											if(!Ext.isEmpty(areaValues[inKey]['GRAPH_FORMAT']) && areaValues[inKey]['GRAPH_FORMAT'].indexOf('fusionchart')>-1){
												if ( areaValues[key]['XML_DATA'] != undefined )
												{
												   var chartRndrId=obj.chartId;												   
												   if (FusionCharts(chartRndrId) != null) 
														 FusionCharts(chartRndrId).dispose();
													var xmlData = areaValues[inKey]['XML_DATA'];
													var dataArray = Ext.getCmp('area-block-'+inKey).dataArray;
													var detailsArr = new Array();
													detailsArr[detailsArr.length] = areaValues[inKey]['COMPONENT_DETAILS'];
													detailsArr[detailsArr.length] = areaValues[inKey]['TEST'];
													detailsArr[detailsArr.length] = areaValues[inKey]['MEASURE'];
													detailsArr[detailsArr.length] = areaValues[inKey]['COMBINED_TEST_MEASURES'];
													dataArray[1] = xmlData;
													dataArray[2] = 'AREA_CHART';
													dataArray[3] = detailsArr;
													if ( xmlData != "-" )
													{
														var myChart = new FusionCharts('/final/FusionCharts/swf/MSArea.swf',chartRndrId, '100%', '100%','0','1');
														myChart.setXMLData(xmlData);
														myChart.setTransparent(true);
														myChart.render(obj.getId());
													}
													else
													{
														Ext.select('#'+obj.getId()).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>')
													}
												}
											}
											else
											{
												if(!Ext.isEmpty(areaValues[inKey]['IMAGE_URL']) && areaValues[inKey]['IMAGE_URL']!="-")
												{
													var imgHeight = 190;
													var imgWidth = 430;
													var url = areaValues[inKey]['IMAGE_URL']+"&anonymousUser=true&dashboardUserId="+userName;
													if(areaValues[inKey]['GRAPH_FORMAT'].indexOf('highchart')>-1)
													{												
														
														//setHighChart(url,obj.getId(),imgHeight,imgWidth,'',true,'right',false);
														if(!Ext.isEmpty(url))
														{
															Ext.Ajax.request(
															{
																url : url,
																scope:this,
																method: 'POST',
																timeout:280000,
																success: function(response) 
																{	
																	if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
																		{
																			if(response.responseText.indexOf('.png')>=0)
																			{	
																				Ext.select('#'+obj.getId()).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
																			}
																			else
																			{	
																				var chartData=Ext.decode(response.responseText);
																				var showChartCurrentValue="yes";
																				var showCharLegend="yes";
																				if(!Ext.isEmpty(chartData) && chartData!='' && chartData.hasOwnProperty('DataSet'))
																				{
																					try
																					{
																						var dataSetObjArray=chartData.DataSet;
																						var measHeight=obj.getHeight()-110;
																						var measWidth = obj.getWidth() - 15;
																						if ((dataSetObjArray != null && !Ext.isEmpty(dataSetObjArray))) {
																							var liveMeasHtml= '<div class="chartCount" style="height:64px;overflow:auto"><ul>';
																							for(var dObj in dataSetObjArray)
																							{	
																							   var seriesObj = dataSetObjArray[dObj];
																							   if (seriesObj != null && seriesObj.hasOwnProperty('dispLegend')) 
																							   {																						
																									var legndName = seriesObj['dispLegend'];																										
																									var measVal = seriesObj['measVal'];
																									var measState = seriesObj['measState'];
																									var layerModelUrl = seriesObj['layerModelUrl'];
																									var legndColor=seriesObj['color'];
																									var unitForMeas=seriesObj['unit'];
																									liveMeasHtml += '<li>';
																									if(showChartCurrentValue.toLowerCase()!="no" && showChartCurrentValue.toLowerCase()=="yes")
																									{
																										 if (seriesObj != null && layerModelUrl!="-") {
																											liveMeasHtml += '<div class="uxGraphValue_WHITE">';
																											  if((showChartCurrentValue.toLowerCase()!="no" && showCharLegend.toLowerCase()=="no") )
																											  {
																											   liveMeasHtml += '<div><span class="chartLegend" style="color:'+legndColor+'">.</span>';
																											  }
																											  //liveMeasHtml += '<a class="uxGraphValue_WHITE" href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'>'+ measVal + '</a></div>'
																											  //liveMeasHtml += '<a class="uxGraphValue_'+measState+'" href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'>'+ measVal + '</a></div>'
																											  liveMeasHtml += '<div style="margin-top:0px" class="uxGraphValue_WHITE" onclick=href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'><img  class=\"stateSymbol_'+measState+'\" src=\"/final/images/clear.png\" border=\"0\" />'+ measVal + '</div>';
																										 } else {
																											  liveMeasHtml += '<li><div class="uxGraphValue_WHITE">';
																											  liveMeasHtml += '<div><span class="chartLegend" style="color:'+legndColor+'">.</span>';
																											  liveMeasHtml += measVal + '</div>';
																										 }
																									}
																									if(showCharLegend.toLowerCase()!="no" && showCharLegend.toLowerCase()=="yes")
																									{
																									 liveMeasHtml += '<div><span class="chartLegend" style="color:'+legndColor+'">.</span>';
																									 if (measVal != null && (measVal!="-" && layerModelUrl!="-")) {
																									  liveMeasHtml += '<a href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'><span class="status">'
																										+ legndName + '</span></a>';
																									  if (unitForMeas != null && (unitForMeas!="-" && unitForMeas!="undefined" && unitForMeas!="")) {
																									   liveMeasHtml += '<a href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'><span class="matric"> ('
																										 + unitForMeas + ')</span></a>';
																									  }
																									 } else {
																									  liveMeasHtml += '<span class="status">' + legndName + '</span>';
																									  if (unitForMeas != null && (unitForMeas!="-" && unitForMeas!="undefined" && unitForMeas!="")) {
																									   liveMeasHtml += '<span class="matric"> (' + unitForMeas + ')</span>';
																									  }
																									 }
																									 liveMeasHtml += '</div>';
																									}
																									liveMeasHtml += '</li>'
																							   }
																							  }
																							  liveMeasHtml += '</ul></div>';
																							  if (liveMeasHtml != null && liveMeasHtml != "") {
																								  liveMeasHtml = '<div>' + liveMeasHtml + '</div></div> <div id="measuregraph_' + inKey + '" class="timelineDiv" style="border:0px solid yellow;height:'+measHeight+'px;width:100%">';
																								  obj.update(liveMeasHtml);
																								  var lineChart = {};
																								  lineChart = jQuery.extend(true, {}, getHighStockAreaChartForMyDashboard('measuregraph_'+ inKey,measHeight,measWidth,'',chartData.DataSet), lineChart);
																								  lineChart.setData(chartData,mgrDateFormat,'',true,'right');
																								  lineChart.drawChart();
																							}
																						}
																						else
																						{
																							Ext.select('#'+obj.getId()).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
																						}
																						
																					}
																					catch (e)
																					{
																						alert("exception in highchart method::"+e);
																					}
																				}
																				else
																				{	
																					Ext.select('#'+obj.getId()).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
																				}
																			}								
																		}
																}
															});
														}
													}
													else
													{
														Ext.select('#'+obj.getId()).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
													}
												}
												else
												{
													Ext.select('#'+obj.getId()).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
												}														
											}
										}
									}
								}]
			        		}
			        	]
    				});
    			}
    		}
	},
    userdetailsDefaultLoad: function ()
    {
//      this.getUserdata().loadDefaultData();
	},
	onBackBtnClick:function()
	{
		//window.history.go("/final/monitor/endUserDashboard.jsp?access=allusers");	
		var tempUserType = userType;
		if(!Ext.isEmpty(treeSession) && treeSession.indexOf("EgCitrixDashCloud.jsp"))
		{
			window.location.href=treeSession;
		}
		else if(isNormalBack)
		{
			window.history.back();
		}
		else if(isUserSearch)
		{
			document.location='/final/monitor/eGSearch.jsp?'+userSearchParams;
		}
		else if(!Ext.isEmpty(fromVCDSDrilldown) && fromVCDSDrilldown!=null && fromVCDSDrilldown!=undefined && (fromVCDSDrilldown==true || fromVCDSDrilldown=='yes') && !Ext.isEmpty(orgUserType) && orgUserType!=undefined && orgUserType=='VDIESX')
		{
			if(detail!=null && detail!=undefined && detail!="")
			{
				window.location.href="/final/monitor/endUserDashboard.jsp?access=allusers&userType="+orgUserType+"&fromMenu="+isFromMenu+"&filterBy="+filterBy+"&enableBackButton="+enableBackButton+"&isfromuedoverview="+isFromUEDOverview+"&overviewsearchstr="+overviewSearchStr+"&filterFlag=true&searchFilter="+searchFilter+"&nextSearch="+nextSearch+"&priorityFilter="+priorityFilter+"&dscomp="+encodeURI(dscomp)+"&dscomptype="+dscomptype+"&dsInfo="+encodeURI(dsInfo)+"&dsmsmt_host="+encodeURI(dsmsmt_host)+"&isFromVCDS=true&detail="+encodeURI(detail)+"&compCombo="+encodeURI(compCombo);
			}
			else
			{
				window.location.href="/final/monitor/endUserDashboard.jsp?access=allusers&userType="+orgUserType+"&fromMenu="+isFromMenu+"&filterBy="+filterBy+"&enableBackButton="+enableBackButton+"&isfromuedoverview="+isFromUEDOverview+"&overviewsearchstr="+overviewSearchStr+"&filterFlag="+filterFlag+"&searchFilter="+searchFilter+"&nextSearch="+nextSearch+"&priorityFilter="+priorityFilter+"&dscomp="+encodeURI(dscomp)+"&dscomptype="+dscomptype+"&dsInfo="+encodeURI(dsInfo)+"&dsmsmt_host="+encodeURI(dsmsmt_host)+"&isFromVCDS=true&detail="+encodeURI(detail)+"&compCombo="+encodeURI(compCombo);
			}
		}
		else if(!Ext.isEmpty(isFromUEDOverview) && isFromUEDOverview!=null && isFromUEDOverview!=undefined && (isFromUEDOverview==true||isFromUEDOverview=='true'))
		{
			window.location.href="/final/monitor/endUserDashboard.jsp?access=allusers&userType="+tempUserType+"&fromMenu="+isFromMenu+"&filterBy="+filterBy+"&enableBackButton="+enableBackButton+"&isfromuedoverview="+isFromUEDOverview+"&overviewsearchstr="+overviewSearchStr+"&filterFlag="+filterFlag+"&searchFilter="+encodeURI(searchFilter)+"&nextSearch="+encodeURI(nextSearch)+"&nextSubSearch="+encodeURI(nextSubSearch)+"&priorityFilter="+priorityFilter+"&showKeyUser="+showKeyUser;
		}
		else
		{
			if ( !Ext.isEmpty( parent.window.location ) )
			{
				if(isFromGeo == true || isFromGeo == 'true'){
					var url = "";
					if(isDirectLinkfromCtx || isDirectLinkfromCtx == 'true'){
						if(!Ext.isEmpty(view_name) && view_name == "Overview_View"){
							url = "/final/monitor/citrixDashboard.jsp?iniName="+iniName+"&action=loadViewData&user_name="+user_name+"&userBased="+isUserBased+"&fromMenu=true&fromUED=false&showConfig=true&dashboard_name="+dashboard_name+"&view_name="+view_name+"&filterName="+encodeURI(filterName.trim())+"&filterViewName="+filterViewName+"&dashboard_mapping="+dashboard_mapping;

							if(!Ext.isEmpty(fromServiceHomePage) && fromServiceHomePage != null && fromServiceHomePage != undefined && fromServiceHomePage != 'null' && fromServiceHomePage != 'undefined')
								url += "&fromServiceHomePage="+fromServiceHomePage;

							if(!Ext.isEmpty(fromZonePage) && fromZonePage != null && fromZonePage != undefined && fromZonePage != 'null' && fromZonePage != 'undefined')
								url += "&fromZonePage="+fromZonePage;
						}
						else{
							if(!Ext.isEmpty(filterName) && filterName.indexOf("-") > -1)
							{
								filterName = filterName.substring(filterName.indexOf("-")+1);
							}

							url = "/final/monitor/citrixDashboard.jsp?iniName="+iniName+"&action=loadViewData&user_name="+user_name+"&userBased="+isUserBased+"&fromMenu=true&fromUED=true&showConfig=true&dashboard_name="+dashboard_name+"&view_name="+view_name+"&filterName="+encodeURI(filterName.trim())+"&filterViewName="+filterViewName+"&dashboard_mapping="+dashboard_mapping;

							if(!Ext.isEmpty(fromServiceHomePage) && fromServiceHomePage != null && fromServiceHomePage != undefined && fromServiceHomePage != 'null' && fromServiceHomePage != 'undefined')
								url += "&fromServiceHomePage="+fromServiceHomePage;

							if(!Ext.isEmpty(fromZonePage) && fromZonePage != null && fromZonePage != undefined && fromZonePage != 'null' && fromZonePage != 'undefined')
								url += "&fromZonePage="+fromZonePage;
						}

						if(!Ext.isEmpty(countryCode) && countryCode != null && countryCode != undefined && countryCode != 'null' && countryCode != 'undefined')
							url += "&countryCode="+countryCode;

						if(!Ext.isEmpty(regionName) && regionName != null && regionName != undefined && regionName != 'null' && regionName != 'undefined')
							url += "&regionName="+encodeURI(regionName);

						if(!Ext.isEmpty(selectedTest) && selectedTest != null && selectedTest != undefined)
							url +="&selectedTest="+selectedTest;

						if(!Ext.isEmpty(selectedMeasure) && selectedMeasure != null && selectedMeasure != undefined)
							url +="&selectedMeasure="+selectedMeasure;
					}
					else{
						url += "/final/monitor/endUserDashboard.jsp?access=allusers&userType="+tempUserType+"&fromGeo="+isFromGeo+"&enableBackButton=true&filterBy="+filterBy+"&filterFlag="+filterFlag+"&searchFilter="+encodeURI(searchFilter)+"&nextSearch="+encodeURI(nextSearch)+"&nextSubSearch="+encodeURI(nextSubSearch)+"&iniName="+iniName+"&user_name="+user_name+"&isUserBased="+isUserBased+"&dashboard_name="+dashboard_name+"&view_name="+view_name+"&dashboard_mapping="+dashboard_mapping+"&time_line="+encodeURI(time_line)+"&ginfo="+geoInfo+"&usercountval="+usercountval+"&showKeyUser="+showKeyUser;

						if(!Ext.isEmpty(detail) && detail != null && detail != undefined && detail != 'null' && detail != 'undefined')
							url += "&detail="+encodeURI(detail);

						if(!Ext.isEmpty(compCombo) && compCombo != null && compCombo != undefined && compCombo != 'null' && compCombo != 'undefined')
							url += "&compCombo="+compCombo;

						if(!Ext.isEmpty(fromServiceHomePage) && fromServiceHomePage != null && fromServiceHomePage != undefined && fromServiceHomePage != 'null' && fromServiceHomePage != 'undefined')
							url += "&fromServiceHomePage="+fromServiceHomePage;

						if(!Ext.isEmpty(fromZonePage) && fromZonePage != null && fromZonePage != undefined && fromZonePage != 'null' && fromZonePage != 'undefined')
							url += "&fromZonePage="+fromZonePage;

						if(!Ext.isEmpty(selectedTest) && selectedTest != null && selectedTest != undefined)
							url +="&selectedTest="+selectedTest;

						if(!Ext.isEmpty(selectedMeasure) && selectedMeasure != null && selectedMeasure != undefined)
							url +="&selectedMeasure="+selectedMeasure;
					}
					window.location.href = url;
				} else {
					var endUsrDashUrl = "/final/monitor/endUserDashboard.jsp?access=allusers&userType="+tempUserType+"&fromMenu="+isFromMenu+"&filterBy="+filterBy+"&filterFlag="+filterFlag+"&searchFilter="+encodeURI(searchFilter)+"&nextSearch="+encodeURI(nextSearch)+"&nextSubSearch="+encodeURI(nextSubSearch)+"&enableBackButton="+enableBackButton+"&isfromuedoverview="+isFromUEDOverview+"&overviewsearchstr="+overviewSearchStr+"&priorityFilter="+priorityFilter+"&showKeyUser="+showKeyUser;
					if(!Ext.isEmpty(searchString) && searchString!=undefined && searchString!=null)
						endUsrDashUrl = endUsrDashUrl + "&searchString=" +searchString;
					if(!Ext.isEmpty(adtnlSearchStr) && adtnlSearchStr!=undefined && adtnlSearchStr!=null)
						endUsrDashUrl = endUsrDashUrl + "&adtnlSearchStr=" +adtnlSearchStr;
					window.location.href = endUsrDashUrl;
				}
			}
			else if ( !Ext.isEmpty( window.location ) )
			{
				if(isFromGeo == true || isFromGeo == 'true')
				{
					var url = "";
					if(isDirectLinkfromCtx || isDirectLinkfromCtx == 'true')
					{
						if(!Ext.isEmpty(view_name) && view_name == "Overview_View")
							url = "/final/monitor/citrixDashboard.jsp?iniName="+iniName+"&action=loadViewData&user_name="+user_name+"&userBased="+isUserBased+"&fromMenu=true&fromUED=false&showConfig=true&dashboard_name="+dashboard_name+"&view_name="+view_name+"&filterName="+encodeURI(filterName.trim())+"&filterViewName="+filterViewName+"&dashboard_mapping="+dashboard_mapping;

							if(!Ext.isEmpty(fromServiceHomePage) && fromServiceHomePage != null && fromServiceHomePage != undefined && fromServiceHomePage != 'null' && fromServiceHomePage != 'undefined')
								url += "&fromServiceHomePage="+fromServiceHomePage;

							if(!Ext.isEmpty(fromZonePage) && fromZonePage != null && fromZonePage != undefined && fromZonePage != 'null' && fromZonePage != 'undefined')
								url += "&fromZonePage="+encodeURI(fromZonePage);
						else{
							if(!Ext.isEmpty(filterName) && filterName.indexOf("-") > -1)
							{
								filterName = filterName.substring(filterName.indexOf("-")+1);
							}

							url = "/final/monitor/citrixDashboard.jsp?iniName="+iniName+"&action=loadViewData&user_name="+user_name+"&userBased="+isUserBased+"&fromMenu=true&fromUED=true&showConfig=true&dashboard_name="+dashboard_name+"&view_name="+view_name+"&filterName="+encodeURI(filterName.trim())+"&filterViewName="+filterViewName+"&dashboard_mapping="+dashboard_mapping;

							if(!Ext.isEmpty(fromServiceHomePage) && fromServiceHomePage != null && fromServiceHomePage != undefined && fromServiceHomePage != 'null' && fromServiceHomePage != 'undefined')
								url += "&fromServiceHomePage="+fromServiceHomePage;

							if(!Ext.isEmpty(fromZonePage) && fromZonePage != null && fromZonePage != undefined && fromZonePage != 'null' && fromZonePage != 'undefined')
								url += "&fromZonePage="+encodeURI(fromZonePage);
						}

						if(!Ext.isEmpty(countryCode) && countryCode != null && countryCode != undefined && countryCode != 'null' && countryCode != 'undefined')
							url += "&countryCode="+countryCode;

						if(!Ext.isEmpty(regionName) && regionName != null && regionName != undefined && regionName != 'null' && regionName != 'undefined')
							url += "&regionName="+encodeURI(regionName);

						if(!Ext.isEmpty(selectedTest) && selectedTest != null && selectedTest != undefined)
							url +="&selectedTest="+selectedTest;

						if(!Ext.isEmpty(selectedMeasure) && selectedMeasure != null && selectedMeasure != undefined)
							url +="&selectedMeasure="+selectedMeasure;
					}
					else
					{
						url += "/final/monitor/endUserDashboard.jsp?access=allusers&userType="+tempUserType+"&fromGeo="+isFromGeo+"&enableBackButton=true&filterBy="+filterBy+"&filterFlag="+filterFlag+"&searchFilter="+encodeURI(searchFilter)+"&nextSearch="+encodeURI(nextSearch)+"&nextSubSearch="+encodeURI(nextSubSearch)+"&iniName="+iniName+"&user_name="+user_name+"&isUserBased="+isUserBased+"&dashboard_name="+dashboard_name+"&view_name="+view_name+"&dashboard_mapping="+dashboard_mapping+"&time_line="+encodeURI(time_line)+"&ginfo="+geoInfo+"&usercountval="+usercountval+"&showKeyUser="+showKeyUser;

						if(!Ext.isEmpty(detail) && detail != null && detail != undefined && detail != 'null' && detail != 'undefined')
							url += "&detail="+encodeURI(detail);

						if(!Ext.isEmpty(compCombo) && compCombo != null && compCombo != undefined && compCombo != 'null' && compCombo != 'undefined')
							url += "&compCombo="+compCombo;

						if(!Ext.isEmpty(fromServiceHomePage) && fromServiceHomePage != null && fromServiceHomePage != undefined && fromServiceHomePage != 'null' && fromServiceHomePage != 'undefined')
							url += "&fromServiceHomePage="+fromServiceHomePage;

						if(!Ext.isEmpty(fromZonePage) && fromZonePage != null && fromZonePage != undefined && fromZonePage != 'null' && fromZonePage != 'undefined')
							url += "&fromZonePage="+encodeURI(fromZonePage);

						if(!Ext.isEmpty(selectedTest) && selectedTest != null && selectedTest != undefined)
							url +="&selectedTest="+selectedTest;

						if(!Ext.isEmpty(selectedMeasure) && selectedMeasure != null && selectedMeasure != undefined)
							url +="&selectedMeasure="+selectedMeasure;
					}
					window.location.href = url;
				}
				else
				{
					if(detail!=null && detail!=undefined && detail!="")
					{
						var endUsrDashUrl ="";
						if ( !Ext.isEmpty( parent.window.location ) )
						{
							endUsrDashUrl ="/final/monitor/endUserDashboard.jsp?access=allusers&userType="+tempUserType+"&fromMenu="+isFromMenu+"&filterBy="+filterBy+"&enableBackButton="+enableBackButton+"&isfromuedoverview="+isFromUEDOverview+"&overviewsearchstr="+overviewSearchStr+"&filterFlag=true&searchFilter="+searchFilter+"&nextSearch="+nextSearch+"&priorityFilter="+priorityFilter+"&detail="+encodeURI(detail)+"&compCombo="+encodeURI(compCombo);
						}
						else if ( !Ext.isEmpty( window.location ) )
						{
							endUsrDashUrl ="/final/monitor/endUserDashboard.jsp?access=allusers&userType="+tempUserType+"&fromMenu="+isFromMenu+"&filterBy="+filterBy+"&enableBackButton="+enableBackButton+"&isfromuedoverview="+isFromUEDOverview+"&overviewsearchstr="+overviewSearchStr+"&filterFlag=true&searchFilter="+searchFilter+"&nextSearch="+nextSearch+"&priorityFilter="+priorityFilter+"&detail="+encodeURI(detail)+"&compCombo="+encodeURI(compCombo);
						}
						if(!Ext.isEmpty(adtnlSearchStr) && adtnlSearchStr!=undefined && adtnlSearchStr!=null)
							endUsrDashUrl = endUsrDashUrl + "&adtnlSearchStr=" +adtnlSearchStr;

						window.location.href = endUsrDashUrl;
					}
					else
					{
						window.location.href="/final/monitor/endUserDashboard.jsp?access=allusers&userType="+tempUserType+"&fromMenu="+isFromMenu+"&filterBy="+filterBy+"&filterFlag="+filterFlag+"&searchFilter="+encodeURI(searchFilter)+"&nextSearch="+encodeURI(nextSearch)+"&nextSubSearch="+encodeURI(nextSubSearch)+"&showKeyUser="+showKeyUser;
					}
				}
			}
		}
	},
	maximizedView: function ()
	{
        maxiView=true;
        maximizedFunction='maximizedView';
		var urlForMaximize = publicJsonData['urlForMaximize'];
        var getMainWidth = this.getMain().getWidth(),
            getMainHeight = this.getMain().getHeight();

			Ext.widget('maximizeview', {
				width: getMainWidth-100,
				height: getMainHeight-100,
				id : 'Maximize',
				html:'<div style="margin:6px"><img src='+urlForMaximize+' width='+(getMainWidth-20)+' height= '+(getMainHeight-20)+' /></div>'
			}).show();

	},
	BarOnclick:function(i)
	{
		var br_path = publicJsonData['path'];
		var barGrps = publicJsonData['BarGraph'];
		var bartitle = publicJsonData['bartitle'];
		var getMainWidth = this.getMain().getWidth(),
            getMainHeight = this.getMain().getHeight();

			Ext.widget('maximizeview', {
				width: getMainWidth,
				height: getMainHeight,

				html:'<div style="margin:8px"><font size="5"><b><center>' + bartitle[i] + '</center></b></font></div><div id="Maximize' + i +'" style="float:left;margin:4px;"></div>'

			}).show();

			var bargraph = new FusionCharts(br_path, "Gauge" + i,(getMainWidth-20), (getMainHeight-20), "0", "1");
                bargraph.setDataXML(barGrps[i]);
                bargraph.setTransparent(true);
                bargraph.render("Maximize" + i);

	},
	AreaOnclick:function(i)
	{

		var areaGrps = publicJsonData['areagraphdata'];
		var a_path = publicJsonData['a_path'];
        var areatitle = publicJsonData['areatitle'];
		 var getMainWidth = this.getMain().getWidth(),
            getMainHeight = this.getMain().getHeight();

			Ext.widget('maximizeview', {
				width: getMainWidth,
				height: getMainHeight,

				html:'<div style="margin:8px"><font size="5"><b><center>' + areatitle[i] + '</center></b></font></div><div id="areachart_max' + i + '" style="margin:4px;"></div>'

			}).show();

			var areachart_fv = new FusionCharts(a_path, "ChartId" + i, (getMainWidth-65), (getMainHeight-65), "0", "1");
                areachart_fv.setDataXML(areaGrps[i]);
                areachart_fv.setTransparent(true);
                areachart_fv.render("areachart_max" + i);

	},

	showConfigDropdown:function(){
			var tpl = new Ext.XTemplate('<div style="color:#fff;float:left;margin:4px 0px 0px 4px"><b>'+defaultSettings+'</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="closeSettings"></div></div>');
				//config dropdown mode
				Ext.create('Ext.container.Container',{
				width:580,
				padding:5,
				//layout:'vbox',
				id:'configMod',
				cls:'configMode_popup',
				//html:tpl.apply(),
				items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'526px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						style:{'top':'0px','margin':'2px'}
					},
					{
						xtype:'panel',
						cls:'configMode_popup_inner',
						defaults: {
							labelAlign: 'top',
							margin: '8 5 8 10',
							labelSeparator: ''
						},
						items:[
							{
								xtype:'timeline',
								parent: this
							},
							{
								xtype: 'button',
								cls: 'button20',
								margin: '0px 0px 8px 250px',
								id: 'timelinesubmit',
								text: goBtn,
								handler: function()
								{
									appCnt.timelineSubmit();
								}
							}
						]
					}
				],
				renderTo:'Maximize-body',
			});
	},

	loadConfigurationItems:function(obj)
	{
		metricsData="";
		removeMetricsData="";
		var metrics = obj.up().down('radiogroup[id=metrics]');		
		var panelTitle = obj.up().down('textfield[id=panelTitle]');
		var chartTimeline = obj.up().down('combo[id=chartTimeline]');
		var testCombo = obj.up().down('combo[id=test]');
		var measureCombo = obj.up().down('combo[id=measure]');
		var displayName = obj.up().down('textfield[id=displayName]');
		var processName = obj.up().down('textfield[id=processName]');
		var process = obj.up().down('textfield[id=process]');
		var addButton = obj.up().up().down('button[id=add]');
		var panelNo = obj.up().down('combo[id=panelNo]');
		var showHidePanels = obj.up().down('itemselector[id=showHidePanels]');
		var deleteCustomPanels = obj.up().down('multiselect[id=deleteCustomPanels]');
		var modifyRadio = obj.up().down('radiogroup[id=modifyOptions]');
		var sessionDetailsTimeline = obj.up().down('combo[id=sessionDetailsTimeline]');
		var sessionDetailsTopN = obj.up().down('combo[id=sessionDetailsTopN]');
		var userAlertsNop = obj.up().down('combo[id=userAlertsNop]');
		var paletteContainer = obj.up().down('container[id=paletteContainer]');

		if(obj.getValue()=="add")
		{
			metrics.show();
			panelNo.hide();
			modifyRadio.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			addButton.hide();
			panelTitle.setValue("");
			panelTitle.hide();
			showHidePanels.hide();
			deleteCustomPanels.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
			if(!Ext.isEmpty(metrics.getValue().metricsRadio))
				this.loadMetricsItems(metrics);
		}
		else if(obj.getValue()=="modify")
		{
			metrics.hide();
			panelTitle.hide();
			chartTimeline.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			processName.hide();
			process.hide();
			addButton.hide();
			showHidePanels.hide();
			deleteCustomPanels.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
			this.loadPanelsCombo(obj);
		}
		else if(obj.getValue()=="delete")
		{
			metrics.hide();
			panelTitle.hide();
			chartTimeline.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			processName.hide();
			process.hide();
			addButton.hide();
			panelNo.hide();
			modifyRadio.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
			showHidePanels.hide();
			deleteCustomPanels.show();
		}
		else if(obj.getValue()=="showHide")
		{
			metrics.hide();
			panelTitle.hide();
			chartTimeline.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			processName.hide();
			process.hide();
			addButton.hide();
			panelNo.hide();
			modifyRadio.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
			deleteCustomPanels.hide();
			showHidePanels.show();
		}
		else
		{
			metrics.hide();
			panelTitle.hide();
			chartTimeline.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			processName.hide();
			process.hide();
			addButton.hide();
			panelNo.hide();
			modifyRadio.hide();
			showHidePanels.hide();
			deleteCustomPanels.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
		}
	},
	loadConfigurationItems_Modify:function(obj,panel_Title,ObjId,metricsVal)
	{
		metricsData="";
		removeMetricsData="";
		var metrics = obj.up().down('radiogroup[id=metrics]');		
		var panelTitle = obj.up().down('textfield[id=panelTitle]');
		var chartTimeline = obj.up().down('combo[id=chartTimeline]');
		var testCombo = obj.up().down('combo[id=test]');
		var measureCombo = obj.up().down('combo[id=measure]');
		var displayName = obj.up().down('textfield[id=displayName]');
		var processName = obj.up().down('textfield[id=processName]');
		var process = obj.up().down('textfield[id=process]');
		var addButton = obj.up().up().down('button[id=add]');
		var panelNo = obj.up().down('combo[id=panelNo]');
		var showHidePanels = obj.up().down('itemselector[id=showHidePanels]');
		var deleteCustomPanels = obj.up().down('multiselect[id=deleteCustomPanels]');
		var modifyRadio = obj.up().down('radiogroup[id=modifyOptions]');
		var sessionDetailsTimeline = obj.up().down('combo[id=sessionDetailsTimeline]');
		var sessionDetailsTopN = obj.up().down('combo[id=sessionDetailsTopN]');
		var userAlertsNop = obj.up().down('combo[id=userAlertsNop]');
		var paletteContainer = obj.up().down('container[id=paletteContainer]');

		if(obj.getValue()=="add")
		{
			metrics.show();
			panelNo.hide();
			modifyRadio.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			addButton.hide();
			panelTitle.setValue("");
			panelTitle.hide();
			showHidePanels.hide();
			deleteCustomPanels.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
			if(!Ext.isEmpty(metrics.getValue().metricsRadio))
				this.loadMetricsItems(metrics);
		}
		else if(obj.getValue()=="modify")
		{
			metrics.hide();
			panelTitle.hide();
			chartTimeline.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			processName.hide();
			process.hide();
			addButton.hide();
			showHidePanels.hide();
			deleteCustomPanels.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
			this.loadPanelsCombo_Modify(obj,panel_Title,ObjId,metricsVal);
		}
		else if(obj.getValue()=="delete")
		{
			metrics.hide();
			panelTitle.hide();
			chartTimeline.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			processName.hide();
			process.hide();
			addButton.hide();
			panelNo.hide();
			modifyRadio.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
			showHidePanels.hide();
			deleteCustomPanels.show();
		}
		else if(obj.getValue()=="showHide")
		{
			metrics.hide();
			panelTitle.hide();
			chartTimeline.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			processName.hide();
			process.hide();
			addButton.hide();
			panelNo.hide();
			modifyRadio.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
			deleteCustomPanels.hide();
			showHidePanels.show();
		}
		else
		{
			metrics.hide();
			panelTitle.hide();
			chartTimeline.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			processName.hide();
			process.hide();
			addButton.hide();
			panelNo.hide();
			modifyRadio.hide();
			showHidePanels.hide();
			deleteCustomPanels.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
		}
	},
	loadMetricsItems:function(obj)
	{
		metricsData="";
		removeMetricsData="";
		var metrics = obj.getValue().metricsRadio;
		var panelTitle = obj.up().down('textfield[id=panelTitle]');
		var chartTimeline = obj.up().down('combo[id=chartTimeline]');
		var testCombo = obj.up().down('combo[id=test]');
		var measureCombo = obj.up().down('combo[id=measure]');
		var displayName = obj.up().down('textfield[id=displayName]');
		var processName = obj.up().down('textfield[id=processName]');
		var process = obj.up().down('textfield[id=process]');
		var addButton = obj.up().up().down('button[id=add]');
		var paletteContainer = obj.up().down('container[id=paletteContainer]');
		var colorPalette =obj.up().down('displayfield[id=colorPalette]');
		
		this.resetTestMeasure(obj);		

		if(metrics!="Other_Metrics")
		{
			this.loadTestsForMetrics(obj);
			panelTitle.show();
			
			if(metrics=="Area_Metrics" || metrics=="Line_Metrics")
			{
				chartTimeline.show();
			}
			else
			{
				chartTimeline.hide();
			}

			if(metrics=="Area_Metrics" || metrics=="Line_Metrics" || metrics=="Bar_Metrics")
			{
				paletteContainer.show();
				colorPalette.setValue("Palette1");
				colorPalette.update('<div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#8399b0\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#ffd95a\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#a4ac91\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#98d980\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#d5b996\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#f48848\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#8b8cc2\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#eb4052\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#c4b3d0\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#b18651\"></div>');
			}
			else
			{
				paletteContainer.hide();
			}

			if(metrics!="Bar_Metrics")
				addButton.show();
			else
				addButton.hide();
		}
		else
		{
			panelTitle.hide();
			chartTimeline.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			processName.hide();
			process.hide();
			addButton.hide();
			paletteContainer.hide();
		}
	},
	loadMetricsItems_AddPanel:function(obj,chartType)
	{
		metricsData="";
		removeMetricsData="";
		var metrics =chartType;
		var panelTitle = obj.up().down('textfield[id=panelTitle]');
		var chartTimeline = obj.up().down('combo[id=chartTimeline]');
		var testCombo = obj.up().down('combo[id=test]');
		var measureCombo = obj.up().down('combo[id=measure]');
		var displayName = obj.up().down('textfield[id=displayName]');
		var processName = obj.up().down('textfield[id=processName]');
		var process = obj.up().down('textfield[id=process]');
		var addButton = obj.up().up().down('button[id=add]');
		var paletteContainer = obj.up().down('container[id=paletteContainer]');
		var colorPalette =obj.up().down('displayfield[id=colorPalette]');
		this.resetTestMeasure(obj);		
		var showHidePanels = obj.up().down('itemselector[id=showHidePanels]');
		var modifyOptions = obj.up().down('radiogroup[id=modifyOptions]');
		var panelNo = obj.up().down('textfield[id=panelNo]');
		var panelTitleCombo = Ext.getCmp('panelTitle');

		if(metrics!="Other_Metrics")
		{
			this.loadTestsForMetrics_AddPanel(obj,chartType);
			panelTitleCombo.setValue('');
			panelTitle.show();
			if(metrics=="Area_Metrics" || metrics=="Line_Metrics")
			{
				chartTimeline.show();
			}
			else
			{
				chartTimeline.hide();
			}
			if(metrics=="Area_Metrics" || metrics=="Line_Metrics" || metrics=="Bar_Metrics")
			{
				paletteContainer.show();
				colorPalette.setValue("Palette1");
				colorPalette.update('<div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#8399b0\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#ffd95a\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#a4ac91\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#98d980\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#d5b996\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#f48848\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#8b8cc2\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#eb4052\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#c4b3d0\"></div><div style=\"float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:#b18651\"></div>');
			}
			else
			{
				paletteContainer.hide();
			}
			if(metrics!="Bar_Metrics")
				addButton.show();
			else
				addButton.hide();
			if (!Ext.isEmpty(showHidePanels) && showHidePanels!=undefined && showHidePanels!=null)
				showHidePanels.hide();
			if (!Ext.isEmpty(modifyOptions) && modifyOptions!=undefined && modifyOptions!=null)
				modifyOptions.hide();
			if (!Ext.isEmpty(panelNo) && panelNo!=undefined && panelNo!=null)
				panelNo.hide();
		}
		else
		{
			panelTitle.hide();
			chartTimeline.hide();
			testCombo.hide();
			measureCombo.hide();
			displayName.hide();
			processName.hide();
			process.hide();
			addButton.hide();
			paletteContainer.hide();
			if (!Ext.isEmpty(showHidePanels) && showHidePanels!=undefined && showHidePanels!=null)
				showHidePanels.hide();
			if (!Ext.isEmpty(modifyOptions) && modifyOptions!=undefined && modifyOptions!=null)
				modifyOptions.hide();
			if (!Ext.isEmpty(panelNo) && panelNo!=undefined && panelNo!=null)
				panelNo.hide();
		}
	},
	loadTestsForMetrics:function(obj)
	{
		var metrics = obj.up().down('radiogroup[id=metrics]').getValue().metricsRadio;
		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var optionsCombo = "add";
		var url = defaultUrl+"loadTest=true&addOrDelete="+optionsCombo;		
		url = url+"&metrics="+metrics;
		url = url+"&userType="+userType;
		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var testCombo = obj.up().down('combo[id=test]');

				if( !Ext.isEmpty( testCombo ) && !Ext.isEmpty( jsonData["TEST"]))
				{
					testCombo.getStore().loadRawData(jsonData["TEST"]);
					testCombo.setValue("-1");
					testCombo.show();
				}				
			},
			failure : function()
			{
				//alert("failure");
			}
		});	
	},
	loadTestsForMetrics_AddPanel:function(obj,chartType)
	{
		var metrics = chartType;
		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var optionsCombo = "add";
		var url = defaultUrl+"loadTest=true&addOrDelete="+optionsCombo;		
		url = url+"&metrics="+metrics;
		url = url+"&userType="+userType;
		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				Ext.getCmp("showHidePanelNew").hide();
				var testCombo = obj.up().down('combo[id=test]');
				var measureCombo = obj.up().down('combo[id=measure]');
				var processNameCombo = obj.up().down('combo[id=processName]');
				var processCombo = obj.up().down('combo[id=process]');
				if( !Ext.isEmpty( testCombo ) && !Ext.isEmpty( jsonData["TEST"]))
				{
					testCombo.getStore().loadRawData(jsonData["TEST"]);
					testCombo.setValue("-1");
					testCombo.show();
					if( !Ext.isEmpty( measureCombo ) && measureCombo.hidden == false)
					{
						measureCombo.setValue("-1");
						measureCombo.hide();
					}
					if( !Ext.isEmpty( processCombo ) && processCombo.hidden == false)
					{
						processCombo.setValue("-1");
						processCombo.hide();
					}
					if( !Ext.isEmpty( processNameCombo ) && processNameCombo.hidden == false)
					{
						processNameCombo.setValue("-1");
						processNameCombo.hide();
					}
				}
			},
			failure : function()
			{
				//alert("failure");
			}
		});	
		//this.loadMeasureDisplay_AddPanel(testCombo,chartType);
	},

	loadTestsForModify:function(obj,metrics,action)
	{
		var panelNo = obj.up().down('combo[id=panelNo]');		
		var optionsCombo = obj.up().down('combo[id=optionsCombo]').getValue();

		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var url = defaultUrl+"loadTest=true&addOrDelete="+optionsCombo;		
		url = url+"&metrics="+metrics;
		url = url+"&userType="+userType;
		url = url+"&panelNo="+panelNo.getValue();
		url = url+"&action="+action;

		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var testCombo = obj.up().down('combo[id=test]');
				var chartTimeline = obj.up().down('combo[id=chartTimeline]');

				if( !Ext.isEmpty( testCombo ) && !Ext.isEmpty( jsonData["TEST"]))
				{
					testCombo.getStore().loadRawData(jsonData["TEST"]);
					testCombo.setValue("-1");
					testCombo.show();
				}
				if(action=="update" && (metrics=="Area_Metrics" || metrics=="Line_Metrics") && !Ext.isEmpty(jsonData["TIMELINE"]))
				{
					chartTimeline.setValue(jsonData["TIMELINE"]);
					chartTimeline.show();
				}

				if(!Ext.isEmpty(jsonData["PALETTE"]) && !Ext.isEmpty(jsonData["PALETTE_COLORS"]) && action=="update" && (metrics=="Area_Metrics" || metrics=="Line_Metrics"))
				{
					var disp = Ext.getCmp("colorPalette");
					disp.setValue(jsonData["PALETTE"]);
					disp.update(jsonData["PALETTE_COLORS"]);
				}
				else if(!Ext.isEmpty(jsonData["PALETTE"]) && !Ext.isEmpty(jsonData["PALETTE_COLORS"]) && metrics=="Bar_Metrics")
				{
					var disp = Ext.getCmp("colorPalette");
					disp.setValue(jsonData["PALETTE"]);
					disp.update(jsonData["PALETTE_COLORS"]);
				}

				
			},
			failure : function()
			{
				//alert("failure");
			}
		});	
	},
	 createGridsterTags: function() {
		
        html = '<div class="gridster"><ul class="gridsterul" style="border:1px solid red;width:1000px !important;margin:0px !important">' +
			'<li data-row="1" data-col="1" data-sizex="1" data-sizey="1"></li><li data-row="2" data-col="1" data-sizex="1" data-sizey="1"></li><li data-row="3" data-col="1" data-sizex="1" data-sizey="1"></li><li data-row="1" data-col="2" data-sizex="1" data-sizey="1"></li><li data-row="2" data-col="2" data-sizex="1" data-sizey="1"></li><li data-row="1" data-col="4" data-sizex="1" data-sizey="1"></li><li data-row="2" data-col="4" data-sizex="1" data-sizey="1"></li><li data-row="3" data-col="4" data-sizex="1" data-sizey="1"></li><li data-row="1" data-col="5" data-sizex="1" data-sizey="1"></li><li data-row="3" data-col="5" data-sizex="1" data-sizey="1"></li><li data-row="1" data-col="6" data-sizex="1" data-sizey="1"></li><li data-row="2" data-col="6" data-sizex="1" data-sizey="1"></li></ul></div>';
        return html;
		// html = '<div class="gridster"><ul class="gridsterul" style="width:1000px !important;margin:0px !important">' +
            //'</ul></div>';
		 //alert(this.settingWidth);
       // return html;
    },
	loadPanelsCombo:function(obj)
	{
		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var url = defaultUrl+"&userType="+userType+"&loadPanels=true";
		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(!Ext.isEmpty( jsonData["PANELS"]))
				{
					var panelNo = obj.up().down('combo[id=panelNo]');
					panelNo.getStore().loadRawData(jsonData["PANELS"]);
					panelNo.setValue("-1");
					panelNo.show();
				}				
			},
			failure : function()
			{
				//alert("failure");
			}
		});	
	},
	loadPanelsCombo_Modify:function(obj,panelTitle,ObjId,metricsVal)
	{
		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var url = defaultUrl+"&userType="+userType+"&loadPanels=true";
		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(!Ext.isEmpty( jsonData["PANELS"]))
				{
					var panelNo = obj.up().down('combo[id=panelNo]');
					panelNo.getStore().loadRawData(jsonData["PANELS"]);
					if(panelTitle!=null && panelTitle!=undefined && !Ext.isEmpty(panelTitle))
					{
						panelNo.setValue(ObjId);
						//panelNo.setValue(panelTitle);
						this.showModifyOptions_Modify(obj.up().down('combo[id=panelNo]'),ObjId,panelTitle,metricsVal);							
					}
					else
					{
						panelNo.setValue("-1");
					}
					panelNo.show();
				}				
			},
			failure : function()
			{
				//alert("failure");
			}
		});	
	},

	loadColorPalettes:function(obj)
	{		
		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var url = defaultUrl+"&loadColorPalettes=true";
		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var palButtons = new Array();
				if(!Ext.isEmpty( jsonData["PALETTES"]))
				{
					for(var palette in jsonData["PALETTES"])
					{
						var colors = jsonData["PALETTES"][palette];

						var colorsDiv = "";
						for(i=0;i<colors.length;i++)
						{
							var col = colors[i];
							colorsDiv +='<div style="float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:'+col+'"></div>';
						}


						var palButton = {
							xtype:'button',
							cls:'button20',
							id:'button_'+palette,
							palette:palette,
							//padding:'2 0 0 0',
							htmlValue:colorsDiv,
							html:colorsDiv +"&nbsp;"+palette,
							listeners:{
								'click':function(obj){
									var disp = Ext.getCmp("colorPalette");
									disp.setValue(obj.palette);
									disp.update(obj.htmlValue);
									colorPaletteWindow.hide();
								 }
							}
						};
						palButtons.push(palButton);
					}



					var colorPaletteWindow = new Ext.Window({
							width:196,
							cls:'graphpalettewindow',
							height:116,
							x:1100,
							y:210,
							border:true,
							style:{'border':'none','position':'absolute'},
							frame:false,
							id:'paletteWindow',
							modal:false,
							autoScroll:false,
							closable:false,
							scroll:false,
							//title:"Palette",
							ghost:false,
							floatable:true,
							focusOnToFront:true,
							draggable:false,
							resizable:false,
							//closeAction:'hide',
							items:palButtons
					  });
				}				
			},
			failure : function()
			{
				//alert("failure");
			}
		});	
	},

	showModifyOptions:function(obj)
	{
		metricsData="";
		removeMetricsData="";
		var modifyOptions = obj.up().down('radiogroup[id=modifyOptions]');
		var test = obj.up().down('combo[id=test]');
		var measure = obj.up().down('combo[id=measure]');
		var displayName = obj.up().down('textfield[id=displayName]');
		var addButton = obj.up().down('button[id=add]');
		var removeButton = obj.up().down('button[id=remove]');
		var panelTitle = obj.up().down('textfield[id=panelTitle]');
		var chartTimeline = obj.up().down('combo[id=chartTimeline]');
		var sessionDetailsTimeline = obj.up().down('combo[id=sessionDetailsTimeline]');
		var sessionDetailsTopN = obj.up().down('combo[id=sessionDetailsTopN]');
		var userAlertsNop = obj.up().down('combo[id=userAlertsNop]');
		var paletteContainer = obj.up().down('container[id=paletteContainer]');
		var v = obj.getValue();
		var record = obj.findRecord(obj.valueField || obj.displayField, v);
		var index = obj.store.indexOf(record);
		var metrics = obj.getStore().getAt(index).get('metricsField');
		if(obj.getValue()=="-1")
		{
			panelTitle.setValue("");
			panelTitle.hide();
		}

		if(obj.getValue()!="-1" && (metrics=="Group_Metrics" || metrics=="Area_Metrics" || metrics=="Line_Metrics"))
		{
			modifyOptions.show();
			if(modifyOptions.getValue().modifyRadio=="add")
			{
				this.loadTestsForModify(obj,metrics,"add");
				paletteContainer.hide();
				chartTimeline.hide();
				addButton.show();
				removeButton.hide();
				panelTitle.hide();
			}
			else if(modifyOptions.getValue().modifyRadio=="update")
			{
				removeButton.hide();
				addButton.hide();
				panelTitle.setValue(obj.getRawValue());
				panelTitle.show();
				if(metrics!="Group_Metrics")
				{
					chartTimeline.show();
					paletteContainer.show();
				}
				else
				{
					chartTimeline.hide();
					paletteContainer.hide();
				}				
				this.loadTestsForModify(obj,metrics,"update");
			}
			else
			{
				paletteContainer.hide();
				removeButton.show();
				addButton.hide();
				panelTitle.setValue("");
				panelTitle.hide();
				chartTimeline.hide();
				this.loadTestsForModify(obj,metrics,"delete");
			}
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
		}
		else if(obj.getValue()!="-1")
		{
			modifyOptions.hide();			
			test.hide();
			measure.hide();
			displayName.hide();
			addButton.hide();
			chartTimeline.hide();
			removeButton.hide();
			panelTitle.setValue(obj.getRawValue());
			panelTitle.show();
			if(metrics=="Bar_Metrics")
			{
				paletteContainer.show();
				this.loadTestsForModify(obj,metrics,"update");
			}
			else
			{
				paletteContainer.hide();
			}
			if(metrics=="SessionDetails")
			{
				sessionDetailsTimeline.show();
				sessionDetailsTopN.show();
				userAlertsNop.hide();
			}
			else if(metrics=="User_Alerts")
			{
				userAlertsNop.show();
				sessionDetailsTimeline.hide();
				sessionDetailsTopN.hide();
			}
			else
			{
				sessionDetailsTimeline.hide();
				sessionDetailsTopN.hide();
				userAlertsNop.hide();
			}
		}
		else
		{
			modifyOptions.hide();			
			test.hide();
			measure.hide();
			displayName.hide();
			addButton.hide();
			chartTimeline.hide();
			removeButton.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
		}
	},
	showModifyOptions_Modify:function(obj,objId,panelTitleObj,metricsVal)
	{
		metricsData="";
		removeMetricsData="";
		var modifyOptions = obj.up().down('radiogroup[id=modifyOptions]');
		var test = obj.up().down('combo[id=test]');
		var measure = obj.up().down('combo[id=measure]');
		var displayName = obj.up().down('textfield[id=displayName]');
		var addButton = obj.up().down('button[id=add]');
		var removeButton = obj.up().down('button[id=remove]');
		var panelTitle = obj.up().down('textfield[id=panelTitle]');
		var chartTimeline = obj.up().down('combo[id=chartTimeline]');
		var sessionDetailsTimeline = obj.up().down('combo[id=sessionDetailsTimeline]');
		var sessionDetailsTopN = obj.up().down('combo[id=sessionDetailsTopN]');
		var userAlertsNop = obj.up().down('combo[id=userAlertsNop]');
		var paletteContainer = obj.up().down('container[id=paletteContainer]');
		var optionsComboObj = obj.up().down('combo[id=optionsCombo]');		
		optionsComboObj.hide();
		var panelNoObj = obj.up().down('combo[id=panelNo]');
		panelNoObj.setDisabled(true);
		if(objId!=null && objId!=undefined && !Ext.isEmpty(objId))
		{
			var v = objId;
		}
		else
		{
		var v = obj.getValue();
		}
		obj.displayField=v;
		var record = obj.findRecord(obj.valueField || obj.displayField, v);
		var index = obj.store.indexOf(record);
		var metrics = obj.getStore().getAt(index).get('metricsField');
		
		if(obj.getValue()=="-1")
		{
			panelTitle.setValue("");
			panelTitle.hide();
		}

		if(obj.getValue()!="-1" && (metrics=="Group_Metrics" || metrics=="Area_Metrics" || metrics=="Line_Metrics"))
		{
			modifyOptions.show();
			if(modifyOptions.getValue().modifyRadio=="add")
			{
				this.loadTestsForModify(obj,metrics,"add");
				
				paletteContainer.hide();
				chartTimeline.hide();
				addButton.show();
				removeButton.hide();
				panelTitle.hide();
			}
			else if(modifyOptions.getValue().modifyRadio=="update")
			{
				removeButton.hide();
				addButton.hide();

				panelTitle.setValue(obj.getRawValue());
				panelTitle.show();

				if(metrics!="Group_Metrics")
				{
					chartTimeline.show();
					paletteContainer.show();
				}
				else
				{
					chartTimeline.hide();
					paletteContainer.hide();
				}				

				this.loadTestsForModify(obj,metrics,"update");
			}
			else
			{
				paletteContainer.hide();
				removeButton.show();
				addButton.hide();
				panelTitle.setValue("");
				panelTitle.hide();
				chartTimeline.hide();
				this.loadTestsForModify(obj,metrics,"delete");
			}
			
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
		}
		else if(obj.getValue()!="-1")
		{
			modifyOptions.hide();			
			test.hide();
			measure.hide();
			displayName.hide();
			addButton.hide();
			chartTimeline.hide();
			removeButton.hide();
			
			panelTitle.setValue(obj.getRawValue());
			panelTitle.show();

			if(metrics=="Bar_Metrics")
			{
				paletteContainer.show();
				this.loadTestsForModify(obj,metrics,"update");
			}
			else
			{
				paletteContainer.hide();
			}

			if(metrics=="SessionDetails")
			{
				sessionDetailsTimeline.show();
				sessionDetailsTopN.show();
				userAlertsNop.hide();
			}
			else if(metrics=="User_Alerts")
			{
				userAlertsNop.show();
				sessionDetailsTimeline.hide();
				sessionDetailsTopN.hide();
			}
			else if(metricsVal=="BackendApplicationStatus")
			{
				sessionDetailsTimeline.hide();
				sessionDetailsTopN.hide();
				userAlertsNop.hide();
				var modifyOptionsObj = Ext.getCmp("modifyOptions");
				modifyOptionsObj.show();
				var suppotedCmpTypeObj  = Ext.getCmp("suppotedCmpType");
				suppotedCmpTypeObj.show();
				backEndMetricVal = metricsVal;
				if(modifyOptions.getValue().modifyRadio=="update")
				{
					this.loadSuppotedCmpTypes(suppotedCmpTypeObj,modifyOptionsObj);
				}
			}
			else
			{
				sessionDetailsTimeline.hide();
				sessionDetailsTopN.hide();
				userAlertsNop.hide();
			}
		}
		else
		{
			modifyOptions.hide();			
			test.hide();
			measure.hide();
			displayName.hide();
			addButton.hide();
			chartTimeline.hide();
			removeButton.hide();
			sessionDetailsTimeline.hide();
			sessionDetailsTopN.hide();
			userAlertsNop.hide();
			paletteContainer.hide();
		}
	},

	loadModifyOptions:function(obj)
	{
		var addButton = obj.up().down('button[id=add]');
		var removeButton = obj.up().down('button[id=remove]');
		var panelNo = obj.up().down('combo[id=panelNo]'); 
		var chartTimeline = obj.up().down('combo[id=chartTimeline]'); 
		var panelTitle = obj.up().down('textfield[id=panelTitle]'); 
		var test = obj.up().down('combo[id=test]');
		var measure = obj.up().down('combo[id=measure]');
		var displayName = obj.up().down('textfield[id=displayName]'); 
		var modifyOptions = obj.up().down('radiogroup[id=modifyOptions]').getValue().modifyRadio;
		var v = panelNo.getValue();
		var record = panelNo.findRecord(panelNo.valueField || panelNo.displayField, v);
		var index = panelNo.store.indexOf(record);
		var metrics = panelNo.getStore().getAt(index).get('metricsField');
		var paletteContainer = obj.up().down('container[id=paletteContainer]');
		var modifyOptionsObj = obj.up().down('radiogroup[id=modifyOptions]');
		if(obj.getValue().modifyRadio=="add")
		{
			panelTitle.hide();
			addButton.show();
			removeButton.hide();
			chartTimeline.hide();
			paletteContainer.hide();
		}
		else if(obj.getValue().modifyRadio=="update")
		{
			addButton.hide();
			removeButton.hide();
			panelTitle.setValue(panelNo.getRawValue());
			panelTitle.show();
			
			if(metrics=="Area_Metrics" || metrics=="Line_Metrics")
				chartTimeline.show();
			else
				chartTimeline.hide();

			if(metrics=="Area_Metrics" || metrics=="Line_Metrics" || metrics=="Bar_Metrics")
				paletteContainer.show();
			else
				paletteContainer.hide();
		}
		else if(obj.getValue().modifyRadio=="delete")
		{
			panelTitle.hide();
			chartTimeline.hide();
			addButton.hide();
			removeButton.show();
			paletteContainer.hide();
		}
		else
		{
			panelTitle.hide();
			chartTimeline.hide();
			addButton.hide();
			removeButton.hide();
			paletteContainer.hide();
		}
		
		test.hide();
		measure.hide();
		displayName.hide();
		if(metrics=="Group_Metrics" || (metrics=="Area_Metrics" || metrics=="Line_Metrics" || metrics=="Bar_Metrics"))
			this.loadTestsForModify(obj,metrics,modifyOptions);
		if(metrics=="BackendApplicationStatus")
		{
			if(obj.getValue().modifyRadio!="update")
			{
				this.loadSuppotedCmpTypes(obj,modifyOptionsObj);
			}
			else if(obj.getValue().modifyRadio=="update")
			{
				var suppotedCmpTypObj  = Ext.getCmp("suppotedCmpType");
				if(!Ext.isEmpty(suppotedCmpTypObj) && suppotedCmpTypObj!=null && suppotedCmpTypObj!=undefined)
					suppotedCmpTypObj.hide();
			}
		}
	},

	changeGroupCombo : function()
	{
		var groupComboObj = Ext.getCmp('group');
		var existingNew = Ext.getCmp("ExistingNew");
		var addDelete = Ext.getCmp('AddDelete')!=null?Ext.getCmp('AddDelete').getValue().Config:"add";
		if ( !Ext.isEmpty( groupComboObj ) )
		{
			var grpVal=groupComboObj.getValue();
			if(addDelete=="add")
			{
				this.loadTestsForGroup();
				Ext.getCmp("displayName").setValue("");
				var panelTitle = Ext.getCmp('panelTitle');
				panelTitle.setValue(groupComboObj.getRawValue());
			}
			else
			{
				this.loadTestsForGroup();
				Ext.getCmp("displayName").setValue("");
				var panelTitle = Ext.getCmp('panelTitle');
				panelTitle.setValue(groupComboObj.getRawValue());				
				if(addDelete!='delete')
					panelTitle.show();
			}
		}
	},
	loadTestsForGroup :function()
	{
		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';

		var addDelete = Ext.getCmp('AddDelete')!=null?Ext.getCmp('AddDelete').getValue().Config:"add";

		var url = defaultUrl+"loadTest=true&addOrDelete="+addDelete;

		var metrics = Ext.getCmp('metrics').getValue().metricsRadio;
		url = url+"&metrics="+metrics;

		url = url+"&userType="+userType;

		var grpFlage=false;
		if(addDelete=='add' || addDelete=='modify' || addDelete=='delete')
		{
			var groupComboObj = Ext.getCmp('group');
			if (!Ext.isEmpty(groupComboObj))
			{
				var grpVal=groupComboObj.getValue();
				url = url+"&group="+grpVal;
				grpFlage=true;
				
				if(addDelete=="modify")
				{
					var panelTitle = Ext.getCmp("panelTitle"); 
					if(!Ext.isEmpty(panelTitle) && panelTitle.isVisible())
					{
						panelTitle.setValue(groupComboObj.getRawValue());
					}
				}				
			}
		}		

		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var testCombo = Ext.getCmp('test');

				if ( !Ext.isEmpty( testCombo ) && !Ext.isEmpty( jsonData["TEST"] ) )
				{
					testCombo.getStore().loadRawData(jsonData["TEST"]);
					testCombo.setValue("-1");
				}
				/*else
				{
					testCombo.getStore().loadRawData('');
				}*/

				if ( !Ext.isEmpty( metrics ) && metrics=='Group_Metrics' )
				{
					if(addDelete=='add')
					{
						/*groupCombo.setValue("-1");

						var groupTxtObj = Ext.getCmp('groupname');
						groupTxtObj.show();

						var groupNameSpObj = Ext.getCmp('groupnameSp');
						groupNameSpObj.show();*/
					}
					else
					{
						var groupTxtObj = Ext.getCmp('groupname');
						groupTxtObj.hide();

						//var groupNameSpObj = Ext.getCmp('groupnameSp');
						//groupNameSpObj.hide();
					}
				}
			},
			failure : function()
			{
				//alert("failure");
			}
		});

		if(addDelete=="add" || addDelete=="modify")
			Ext.getCmp("displayName").show();
		else
			Ext.getCmp("displayName").hide();
	},
	
	loadTests :function()
	{

		/*this.resetTestMeasure();
		Ext.getCmp('panelTitle').setValue("");
		var displayNameObj=Ext.getCmp('displayName');
		if ( !Ext.isEmpty( displayNameObj ) )
		{
			displayNameObj.setValue("");
		}

		var addButton = Ext.getCmp('add');
		if (!Ext.isEmpty(addButton) && addButton.isVisible())
		{
			addButton.hide();
		}

		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var addDelete = Ext.getCmp('AddDelete')!=null?Ext.getCmp('AddDelete').getValue().Config:"add";
		var url = defaultUrl+"loadTest=true&addOrDelete="+addDelete;
		var metrics = Ext.getCmp('metrics').getValue().metricsRadio;
		url = url+"&metrics="+metrics;
		url = url+"&userType="+userType;
		
		if(Ext.getCmp('metrics').isHidden())
			Ext.getCmp('metrics').show();

		if(!Ext.isEmpty(Ext.getCmp('ShowHidePanels')) && Ext.getCmp('ShowHidePanels').isVisible())
			Ext.getCmp('ShowHidePanels').hide();

		if(!Ext.isEmpty(Ext.getCmp('chartTimeline')) && Ext.getCmp('chartTimeline').isVisible())
			Ext.getCmp('chartTimeline').hide();
	
		if(!Ext.isEmpty(Ext.getCmp('sessionDetailsTimeline')) && Ext.getCmp('sessionDetailsTimeline').isVisible())
			Ext.getCmp('sessionDetailsTimeline').hide();
	
		if(!Ext.isEmpty(Ext.getCmp('sessionDetailsTopN')) && Ext.getCmp('sessionDetailsTopN').isVisible())
			Ext.getCmp('sessionDetailsTopN').hide();
	
		if(!Ext.isEmpty(Ext.getCmp('userAlertsNop')) && Ext.getCmp('userAlertsNop').isVisible())
			Ext.getCmp('userAlertsNop').hide();

		if(addDelete=='modify')
		{
			var otherRadio = Ext.getCmp('metricsRadio_Other_Metrics');
			otherRadio.show();
		}
		else
		{
			var otherRadio = Ext.getCmp('metricsRadio_Other_Metrics');
			otherRadio.hide();
		}

		if(metrics!='Group_Metrics')
		{
			var groupCombo = Ext.getCmp('group');
			groupCombo.hide();

			var groupTxtObj = Ext.getCmp('groupname');
			groupTxtObj.hide();
		}
		else
		{
			var existingNew = Ext.getCmp("ExistingNew");
			if(addDelete=="add" && existingNew.isVisible() && existingNew.getValue()=="-1")
			{
				var groupTxtObj = Ext.getCmp('groupname');
				groupTxtObj.show();
				var panelTitle = Ext.getCmp('panelTitle');
				panelTitle.show();
			}
			else if(addDelete=="add" && existingNew.isVisible() && existingNew.getValue()!="-1")
			{
				var groupCombo = Ext.getCmp('group');
				groupCombo.show();
				var panelTitle = Ext.getCmp('panelTitle');
				panelTitle.show();
			}
		}

		var grpFlage=false;
		if(addDelete=='modify' || addDelete=='delete')
		{
			var groupComboObj = Ext.getCmp('group');
			if ( !Ext.isEmpty( groupComboObj ) )
			{
				var grpVal=groupComboObj.getValue();
				if(grpVal!='-1')
				{
					//url = url+"&group="+grpVal;
					grpFlage=true;
				}
			}
			else
			{
				url = url+"&loadChartTypePanel=true";
			}
		}
		else
		{
			var panelNo = Ext.getCmp('panelNo');

			if(metrics=='Group_Metrics' || metrics=='Area_Metrics' || metrics=='Line_Metrics')
			{
				var addButton = Ext.getCmp('add');
				if (!Ext.isEmpty(addButton))
				{
					addButton.show();
				}
			}
		}

		if(addDelete=='add' && (metrics=='Group_Metrics' || metrics=='Area_Metrics' || metrics=='Line_Metrics'))
		{
			var panelTitle = Ext.getCmp('panelTitle');
			var panelNo = Ext.getCmp('panelNo');
			var existingNew = Ext.getCmp("ExistingNew");
			existingNew.show();
			
			if(!Ext.isEmpty(existingNew) && existingNew.getValue()=="0")
				url += "&loadExistingPanels=true";

			if(!Ext.isEmpty(existingNew) && existingNew.isVisible() && existingNew.getValue()=="-1")
			{						
				if(metrics=='Group_Metrics')
				{
					var groupCombo = Ext.getCmp('group');
					groupCombo.hide();

					var groupTxtObj = Ext.getCmp('groupname');
					groupTxtObj.show();
				}
				else
				{
					panelNo.hide();
				}
				panelTitle.show();
			}
			else
			{
				if(metrics=='Group_Metrics')
				{
					var groupCombo = Ext.getCmp('group');
					groupCombo.show();

					var groupTxtObj = Ext.getCmp('groupname');
					groupTxtObj.hide();
				}
				else
				{
					panelNo.show();
				}
				panelTitle.hide();
			}

		}
		else
		{
			var panelTitle = Ext.getCmp('panelTitle');
			var panelNo = Ext.getCmp('panelNo');
			var existingNew = Ext.getCmp("ExistingNew");
			existingNew.hide();	
			panelNo.hide();
		}		

		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var testCombo = Ext.getCmp('test');
				var existingNew = Ext.getCmp("ExistingNew");

				if( !Ext.isEmpty( testCombo ) && !Ext.isEmpty( jsonData["TEST"]))
				{
					testCombo.getStore().loadRawData(jsonData["TEST"]);
					testCombo.setValue("-1");					
				}
				
				if (!Ext.isEmpty( metrics ) && metrics=='Group_Metrics')
				{ 
					var groupCombo = Ext.getCmp('group');
					var panelTitle = Ext.getCmp('panelTitle');
					var panelNo = Ext.getCmp('panelNo');
					if ( !Ext.isEmpty( panelNo ))
					{
						panelNo.hide();
					}
					groupCombo.getStore().loadRawData(jsonData["GROUP"]);
					
					if(addDelete=='add')
					{

						groupCombo.setValue(jsonData["GROUP"][0]['valueField']);
						var groupTxtObj = Ext.getCmp('groupname');
						if(existingNew.getValue()!="-1")
							groupTxtObj.hide();

					}
					else
					{

						groupCombo.setValue(jsonData["GROUP"][0]['valueField']);
						groupCombo.show();
						var groupTxtObj = Ext.getCmp('groupname');
						if(existingNew.isVisible() && existingNew.getValue()=="-1")
							groupTxtObj.show();
						else
							groupTxtObj.hide();
					}

					if(addDelete=="delete")
					{
						var groupTxtObj = Ext.getCmp('groupname');
						groupTxtObj.hide();
						panelTitle.hide();
					}
					else
					{
						if(existingNew.getValue()!="-1")
						{
							panelTitle.setValue(jsonData["GROUP"][0]['selected']);
							panelTitle.show();
						}
					}
				}
				else
				{
					var panelNo = Ext.getCmp('panelNo');
					var panelTitle = Ext.getCmp('panelTitle');
					var chartTimeline = Ext.getCmp('chartTimeline');					
					if ( !Ext.isEmpty( panelNo ) && !Ext.isEmpty( jsonData["PANELS"] ) )
					{
						panelNo.getStore().loadRawData(jsonData["PANELS"]);
						panelNo.show();

						if(addDelete=="add" && metrics=="Bar_Metrics")
							panelNo.hide();

						if(addDelete=="add")
						{
							if(!Ext.isEmpty(jsonData["PANELS"][0]))
								panelNo.setValue(jsonData["PANELS"][0]['valueField']);
							else
								panelNo.setValue("-1");
						}
						else if(addDelete=="modify")
						{
							if(!Ext.isEmpty(jsonData["PANELS"][1]))
								panelNo.setValue(jsonData["PANELS"][1]['valueField']);	
							else
								panelNo.setValue("-1");							

							if(!Ext.isEmpty(jsonData["PANELS"][1]))
							{
								panelTitle.setValue(jsonData["PANELS"][1]['displayField']);	
								
								if(addDelete=="modify" && metrics=="Other_Metrics")
								{
									var panelMetrics = jsonData["PANELS"][1]["metricsField"];
									if(!Ext.isEmpty(panelMetrics) && panelMetrics!="")
									{
										if(panelMetrics=="User_Alerts")
										{
											Ext.getCmp('userAlertsNop').show();
											Ext.getCmp('sessionDetailsTimeline').hide();
											Ext.getCmp('sessionDetailsTopN').hide();
										}
										else if(panelMetrics=="SessionDetails")
										{
											Ext.getCmp('sessionDetailsTimeline').show();
											Ext.getCmp('sessionDetailsTopN').show();
											Ext.getCmp('userAlertsNop').hide();
										}
										else
										{
											Ext.getCmp('userAlertsNop').hide();
											Ext.getCmp('sessionDetailsTimeline').hide();
											Ext.getCmp('sessionDetailsTopN').hide();
										}
									}
								}
							}
							else
								panelTitle.setValue("");
						}
						else
							panelNo.setValue("-1");
						
					}					
					
					if(addDelete=="modify" || (addDelete=="add" && existingNew.getValue()=="-1"))
					{
						panelTitle.show();					
						if(metrics=="Area_Metrics" || metrics=="Line_Metrics")
						{
							chartTimeline.show();
							if(!Ext.isEmpty(jsonData["TIMELINE"]))
								chartTimeline.setValue(jsonData["TIMELINE"]);
						}						
					}
					else
					{
						panelTitle.hide();
						chartTimeline.hide();
					}
				}
			},
			failure : function()
			{
				alert("failure");
			}
		});	
		
		if((addDelete=="add" || addDelete=="modify"))
		{
			Ext.getCmp("displayName").show();
		}
		else
			Ext.getCmp("displayName").hide();

		if((addDelete=="modify" || addDelete=="delete") && (metrics=='Bar_Metrics' || metrics=='Other_Metrics'))
		{
			var testComboData = Ext.getCmp('test');
			testComboData.hide();

			var measureComboData = Ext.getCmp('measure');
			measureComboData.hide();

			Ext.getCmp("displayName").hide();
		}
		else
		{
			var testComboData = Ext.getCmp('test');
			testComboData.show();

			var measureComboData = Ext.getCmp('measure');
			measureComboData.show();
		}*/
	},

	hideProcessCombos:function()
	{
		var processName = Ext.getCmp("processName");
		var process = Ext.getCmp("process");					

		if(!Ext.isEmpty(processName))
		{
			processName.hide();
			processName.setValue("-1");
		}

		if(!Ext.isEmpty(process))
		{
			process.hide();
			process.setValue("-1");
		}
	},

	hideModifyingComponents:function()
	{
		var modifyTestMeasure = Ext.getCmp("modifyTestMeasure");
		var modifyTestCombo = Ext.getCmp("modifyTestCombo");
		var modifyMeasureCombo = Ext.getCmp("modifyMeasureCombo");

		if(!Ext.isEmpty(modifyTestMeasure) && modifyTestMeasure.isVisible())
		{
			modifyTestMeasure.hide();
		}

		if(!Ext.isEmpty(modifyTestCombo) && modifyTestCombo.isVisible())
		{
			modifyTestCombo.hide();
			modifyTestCombo.setValue("-1");
		}

		if(!Ext.isEmpty(modifyMeasureCombo) && modifyMeasureCombo.isVisible())
		{
			modifyMeasureCombo.hide();
			modifyMeasureCombo.setValue("-1");
		}

		var addButton = Ext.getCmp('add');
		if (!Ext.isEmpty(addButton) && addButton.isVisible())
		{
			addButton.hide();
		}
	},

	showOnlyItemSelector:function()
	{
		Ext.getCmp('metrics').hide();
		Ext.getCmp('test').hide();
		Ext.getCmp('measure').hide();
		Ext.getCmp('displayName').hide();
		Ext.getCmp('group').hide();
		Ext.getCmp('groupname').hide();
		Ext.getCmp('panelNo').hide();
		Ext.getCmp('panelTitle').hide();
		Ext.getCmp('chartTimeline').hide();
		Ext.getCmp('sessionDetailsTimeline').hide();
		Ext.getCmp('sessionDetailsTopN').hide();
		Ext.getCmp('userAlertsNop').hide();
		Ext.getCmp('ExistingNew').hide();
		Ext.getCmp('ShowHidePanels').show();
	},

	loadTestsForPanel:function()
	{
		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var addDelete = Ext.getCmp('AddDelete')!=null?Ext.getCmp('AddDelete').getValue().Config:"add";
		var url = defaultUrl+"loadTest=true&addOrDelete="+addDelete;
		var metrics = Ext.getCmp('metrics').getValue().metricsRadio;
		url = url+"&metrics="+metrics;
		url = url+"&userType="+userType;
		var panelNoCombo = Ext.getCmp('panelNo');
		var panelTitleCombo = Ext.getCmp('panelTitle');
		var chartTimeline = Ext.getCmp('chartTimeline');
		var existingNew = Ext.getCmp("ExistingNew");

		if(!Ext.isEmpty(panelNoCombo) && panelNoCombo.isVisible())
		{
			url = url+"&panelNo="+panelNoCombo.getValue();
			if(addDelete=="modify" || (addDelete=="add" && existingNew.getValue()=="-1"))
			{
				if(existingNew.isVisible() && existingNew.getValue()=="-1")
					panelTitleCombo.setValue('');
				else
					panelTitleCombo.setValue(panelNoCombo.getRawValue());

				panelTitleCombo.show();

				if(addDelete=="add" && existingNew.getValue()=="-1" && (metrics=="Area_Metrics" || metrics=="Line_Metrics"))
				{
					chartTimeline.show();
					chartTimeline.setValue("1 hour");
				}
				else if(addDelete=="modify" && panelNoCombo.getValue()!="-1" && (metrics=="Area_Metrics" || metrics=="Line_Metrics"))
				{
					chartTimeline.show();
				}
				else
				{
					chartTimeline.hide();
				}

				if(addDelete=="modify")
				{
					if(!Ext.isEmpty(panelNoCombo) && !Ext.isEmpty(panelNoCombo.getValue()) && panelNoCombo.getValue()!="")
					{
						var v = panelNoCombo.getValue();
						var record = panelNoCombo.findRecord(panelNoCombo.valueField || panelNoCombo.displayField, v);
						var index = panelNoCombo.store.indexOf(record);
						var panelMetrics = panelNoCombo.getStore().getAt(index).get('metricsField');

						if(!Ext.isEmpty(panelMetrics) && panelMetrics!="")
						{
							if(panelMetrics=="User_Alerts")
							{
								Ext.getCmp('userAlertsNop').show();
								Ext.getCmp('sessionDetailsTimeline').hide();
								Ext.getCmp('sessionDetailsTopN').hide();
							}
							else if(panelMetrics=="SessionDetails")
							{
								Ext.getCmp('sessionDetailsTimeline').show();
								Ext.getCmp('sessionDetailsTopN').show();
								Ext.getCmp('userAlertsNop').hide();
							}
							else
							{
								Ext.getCmp('userAlertsNop').hide();
								Ext.getCmp('sessionDetailsTimeline').hide();
								Ext.getCmp('sessionDetailsTopN').hide();
							}
						}
						else
						{
							Ext.getCmp('userAlertsNop').hide();
							Ext.getCmp('sessionDetailsTimeline').hide();
							Ext.getCmp('sessionDetailsTopN').hide();
						}
					}
				}
			}
			else
			{
				panelTitleCombo.hide();
				chartTimeline.hide();
			}
		}
		
		var addDelete = Ext.getCmp("AddDelete");
		if(!Ext.isEmpty(addDelete) && addDelete.getValue().Config!="add")
		{
			Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				timeout:280000,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var testCombo = Ext.getCmp('test');
					if(!Ext.isEmpty(testCombo) && !Ext.isEmpty(jsonData["TEST"]))
					{
						testCombo.getStore().loadRawData(jsonData["TEST"]);
						testCombo.setValue("-1");
					}
					else
					{
						testCombo.getStore().loadRawData('');
					}

					if(!Ext.isEmpty(jsonData["TIMELINE"]))
						chartTimeline.setValue(jsonData["TIMELINE"]);
				},
				failure : function()
				{
					//alert("failure");
				}
			});
		}		
	},

	loadMetrics :function()
	{
		var metricsCmp = Ext.getCmp("metrics");
		metricsCmp.add(
				{
					boxLabel:'Data',
					checked:true,
					name:'metricsRadio',
					id:'metricsRadio_Group_Metrics',
					inputValue:'Group_Metrics',
					width:65
				},
				{
					boxLabel:'Area',
					name:'metricsRadio',
					id:'metricsRadio_Area_Metrics',
					inputValue:'Area_Metrics',
					width:70
				},
				{
					boxLabel:'Line',
					name:'metricsRadio',
					id:'metricsRadio_Line_Metrics',
					inputValue:'Line_Metrics',
					width:60
				},
				{
					boxLabel:'Bar',
					name:'metricsRadio',
					id:'metricsRadio_Bar_Metrics',
					inputValue:'Bar_Metrics',
					width:60
				},
				{
					boxLabel:'Others',
					name:'metricsRadio',
					id:'metricsRadio_Other_Metrics',
					inputValue:'Other_Metrics',
					width:60,
					hidden:true
				}
		);
		metricsCmp.show();
		this.loadTests();
		/*var resultObj = publicJson['RESULT'];
		var metrics = resultObj['ORDER'];
		if(metrics!=null){
			var metricsCmp = Ext.getCmp("metrics");
			for(i=0;i<metrics.length;i++){
				var met = metrics[i];

				var box_label="Data";
				if(met=='Group_Metrics')
					box_label="Data";
				else if(met=='Dial_Metrics')
					box_label="Dial";
				else if(met=='Bar_Metrics')
					box_label="DD";
				else if(met=='Line_Metrics')
					box_label="Graph";
				else if(met=='Area_Metrics')
					box_label="Area Graph";

				metricsCmp.add(
				{
					boxLabel: box_label,
					checked: (i==0)?true:false,
					name:'metricsRadio',
					id:'metricsRadio_'+met,
					inputValue: met,
					width:90
				}),
				metricsCmp.show();
			}
			this.loadTests();
		}*/
	},
	loadMeasureForTest :function(obj)
	{
		var optionsCombo = obj.up().down('combo[id=optionsCombo]').getValue();
		var metrics = obj.up().down('radiogroup[id=metrics]').getValue().metricsRadio;
		if(Ext.isEmpty(metrics) || metrics==null || metrics==undefined)
		{
			if(!Ext.isEmpty(chartTypeStore) && chartTypeStore!=null && chartTypeStore!=undefined )
			{
				metrics=chartTypeStore; 
			}
		}
		var test = obj.up().down('combo[id=test]').getValue();
		var processName = obj.up().down('combo[id=processName]');
		var process = obj.up().down('combo[id=process]');	
		var panelNo = obj.up().down('combo[id=panelNo]');	
		processName.hide();
		process.hide();

		if(optionsCombo!="add")
		{
			var v = panelNo.getValue();
			var record = panelNo.findRecord(panelNo.valueField || panelNo.displayField, v);
			var index = panelNo.store.indexOf(record);
			metrics = panelNo.getStore().getAt(index).get('metricsField');
		}
		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var url = defaultUrl+"addOrDelete="+optionsCombo;		
		url = url+"&metrics="+metrics;
		url = url+"&userType="+userType;
		url +="&loadMeasure=true&test="+test;
		if(optionsCombo!="add")
		{
			var modifyRadio = obj.up().down('radiogroup[id=modifyOptions]').getValue().modifyRadio;
			url +="&action="+modifyRadio;
		}

		if(optionsCombo!="add")
		{
			url = url+"&panelNo="+panelNo.getValue();
		}
		if(metrics=="BackendApplicationStatus")
		{
			var suppotedCmpTypeObj=Ext.getCmp("suppotedCmpType");
			url=url+"&enduserBackendPanel=BackendAppStatus&loadData=loadMeasureTrue&suppotedCmpType="+suppotedCmpTypeObj.getValue();
		}
		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);				
				var measureCombo =obj.up().down('combo[id=measure]');
				measureCombo.getStore().loadRawData(jsonData["MEASURE"]);
				measureCombo.setValue(jsonData["MEASURE"][0]['valueField']);
				measureCombo.show();				
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},

	loadTestsForModifying :function()
	{		
		var addDelete = Ext.getCmp('AddDelete').getValue().Config;
		var test = Ext.getCmp('test').getValue();
		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var url = defaultUrl+"modifyTest=true&addOrDelete="+addDelete+"&test="+test
		var metrics = Ext.getCmp('metrics').getValue().metricsRadio;
		url = url+"&metrics="+metrics;
		url = url+"&userType="+userType;

		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var modifyTest = Ext.getCmp('modifyTestCombo');
				modifyTest.getStore().loadRawData(jsonData["MODIFIED_TEST"]);
				modifyTest.setValue("-1");
				modifyTest.show();
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	loadMeasureDisplay :function(obj)
	{
		var optionsCombo = obj.up().down('combo[id=optionsCombo]').getValue(); 
		var metrics = obj.up().down('radiogroup[id=metrics]').getValue().metricsRadio; 
		if(Ext.isEmpty(metrics) || metrics==null || metrics ==undefined)
		{
			metrics=chartTypeStore;
		}
		if(Ext.isEmpty(metrics))
		{
			metrics = backEndMetricVal;
		}		
		var displayName = obj.up().down('textfield[id=displayName]');
		var modifyRadio = obj.up().down('radiogroup[id=modifyOptions]').getValue().modifyRadio;
		var panelNo = obj.up().down('combo[id=panelNo]');
		if(optionsCombo!="add")
		{
			var v = panelNo.getValue();
			var record = panelNo.findRecord(panelNo.valueField || panelNo.displayField, v);
			var index = panelNo.store.indexOf(record);
			metrics = panelNo.getStore().getAt(index).get('metricsField');
		}
		if((optionsCombo=="add" || optionsCombo=="modify") && metrics=="Bar_Metrics")
		{	
			var test = obj.up().down('combo[id=test]').getValue();
			var measure = obj.up().down('combo[id=measure]').getValue();			
			var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
			var url = defaultUrl+"loadBarDDColumns=true&test="+test+"&measure="+measure;
			Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				timeout:280000,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var processName = obj.up().down('combo[id=processName]');
					processName.getStore().loadRawData(jsonData["DD_COLUMNS"]);
					processName.setValue("-1");
					processName.show();
				},
				failure : function()
				{
					//alert("failure");
				}
			});
		}
		if(optionsCombo=="modify" && modifyRadio=="update" && metrics=="BackendApplicationStatus")
		{
			var test = obj.up().down('combo[id=test]').getValue();
			var measure = obj.up().down('combo[id=measure]').getValue();	
			var suppotedCmpTypeVal = Ext.getCmp("suppotedCmpType").getValue();
			var backendUrl = "/final/monitor/endUserDashboardDetailsConfigJson.jsp?loadData=loadmeasureDispName&enduserBackendPanel=BackendAppStatus&test="+test+"&measure="+measure+"&userType="+userType+"&suppotedCmpType="+suppotedCmpTypeVal;
			Ext.Ajax.request({
				url : backendUrl,
				method : 'POST',
				scope:this,
				timeout:280000,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					displayName.setValue(jsonData['usrTypeMeasureDisp']);
					displayName.show();
				},
				failure : function()
				{
					//alert("failure on backend load display name");
				}
			});
		}
		if(optionsCombo=="add" && metrics!="Bar_Metrics")
		{
			displayName.setValue(obj.getRawValue());
			displayName.show();
		}
		else if(optionsCombo=="modify" && (modifyRadio=="add" || modifyRadio=="update") && (metrics=="Group_Metrics" || metrics=="Area_Metrics" || metrics=="Line_Metrics"  ) )
		{
			displayName.setValue(obj.getRawValue());
			displayName.show();
		}
		else if(metrics=="BackendApplicationStatus" && modifyRadio=="add")
		{
			displayName.setValue(obj.getRawValue());
			displayName.show();
		}
		else
		{
			displayName.setValue("");
			displayName.hide();
		}
	},
	loadMeasureDisplay_AddPanel :function(obj,chartType)
	{
		var optionsCombo = obj.up().down('combo[id=optionsCombo]').getValue(); 
		var metrics = chartType; 
		var displayName = obj.up().down('textfield[id=displayName]');
		var modifyRadio = obj.up().down('radiogroup[id=modifyOptions]').getValue().modifyRadio;
		var panelNo = obj.up().down('combo[id=panelNo]');

		if(optionsCombo!="add")
		{
			var v = panelNo.getValue();
			var record = panelNo.findRecord(panelNo.valueField || panelNo.displayField, v);
			var index = panelNo.store.indexOf(record);
			metrics = panelNo.getStore().getAt(index).get('metricsField');
		}


		if(optionsCombo=="add" && metrics=="Bar_Metrics")
		{	
			var test = obj.up().down('combo[id=test]').getValue();
			var measure = obj.up().down('combo[id=measure]').getValue();			

			var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
			var url = defaultUrl+"loadBarDDColumns=true&test="+test+"&measure="+measure;
			
			Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				timeout:280000,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var processName = obj.up().down('combo[id=processName]');
					processName.getStore().loadRawData(jsonData["DD_COLUMNS"]);
					processName.setValue("-1");
					processName.show();
				},
				failure : function()
				{
					//alert("failure");
				}
			});
		}

		if(optionsCombo=="add" && metrics!="Bar_Metrics")
		{
			displayName.setValue(obj.getRawValue());
			displayName.show();
		}
		else if(optionsCombo=="modify" && (modifyRadio=="add" || modifyRadio=="update") && (metrics=="Group_Metrics" || metrics=="Area_Metrics" || metrics=="Line_Metrics"))
		{
			displayName.setValue(obj.getRawValue());
			displayName.show();
		}
		else
		{
			displayName.setValue("");
			displayName.hide();
		}

		

	},

	loadProcessComboData:function(obj)
	{
		var test = obj.up().down('combo[id=test]').getValue();
		var measure = obj.up().down('combo[id=measure]').getValue();
		var processName = obj.up().down('combo[id=processName]');
		var process = obj.up().down('combo[id=process]');	
		process.hide();

		var defaultUrl = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?';
		var url = defaultUrl+"loadBarDDColumns=true&test="+test+"&measure="+measure;
		url +="&processName="+processName.getValue();

		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);				
				process.getStore().loadRawData(jsonData["DD_COLUMNS"]);
				process.setValue("-1");
				process.show();
			},
			failure : function()
			{
				//alert("failure");
			}
		});
		
	},

	resetTestMeasure:function(obj)
	{
		var testData = [
					{displayField:'Please choose a test',valueField:'-1'}
				 ];

		var testCombo = obj.up().down('combo[id=test]');
		testCombo.getStore().loadRawData(testData);
		testCombo.setValue('-1');

		var measureData = [
					{displayField:'Please choose a measure',valueField:'-1'}
				 ];

		var measureCombo = obj.up().down('combo[id=measure]');
		measureCombo.getStore().loadRawData(measureData);
		measureCombo.setValue('-1');

		var displayName = obj.up().down('textfield[id=displayName]').setValue("");
	},
	checkSpecialCharacter: function (name) {
        var splChar = "~`!@^&*;<>.?|#&+:,$=\"";

        for (var i = 0; i < name.length; i++) {
            check_char = splChar.indexOf(name.charAt(i))
            //Returns value 1 if the special character listed in splChar is found
            if (check_char >= 0) {
                return true;
            }
        }
        return false;
    },
	updateConfiguration : function(obj)
	{
		var meGridster=this;
		var settingsForm = obj.up().up();
		var optionsCombo = settingsForm.down('combo[id=optionsCombo]').getValue();
		var metrics = settingsForm.down('radiogroup[id=metrics]').getValue().metricsRadio;
		if(Ext.isEmpty(metrics) || metrics==null || metrics==undefined)
		{
			if(chartTypeStore!=null &&  !Ext.isEmpty(chartTypeStore) && chartTypeStore!=undefined)
			{
				metrics=chartTypeStore;
			}
		}
		var panelTitle = settingsForm.down('textfield[id=panelTitle]');
		var chartTimeline = settingsForm.down('combo[id=chartTimeline]');
		var test = settingsForm.down('combo[id=test]');
		var measure = settingsForm.down('combo[id=measure]');
		var displayName = settingsForm.down('textfield[id=displayName]');
		var processName = settingsForm.down('combo[id=processName]');
		var process = settingsForm.down('combo[id=process]');
		var panelNo = settingsForm.down('combo[id=panelNo]');
		var modifyRadio = settingsForm.down('radiogroup[id=modifyOptions]');
		var showHidePanels = settingsForm.down('itemselector[id=showHidePanels]');
		var deleteCustomPanels = settingsForm.down('multiselect[id=deleteCustomPanels]');
		var sessDetTimeline = settingsForm.down('combo[id=sessionDetailsTimeline]');
		var sessionDetailsTopN = settingsForm.down('combo[id=sessionDetailsTopN]');
		var userAlertsNop = settingsForm.down('combo[id=userAlertsNop]');
		var paletteContainer =settingsForm.down('container[id=paletteContainer]');
		var colorPalette =settingsForm.down('displayfield[id=colorPalette]');
		var suppotedCmpTypeObj =Ext.getCmp("suppotedCmpType");
//		console.log(suppotedCmpTypeObj.getValue());
		var isUpdate = true;
		
		if(optionsCombo=="-1")
		{
			Ext.Msg.alert("Error","Please choose an option");
			isUpdate = false;
		}

		if(optionsCombo=="modify")
		{
			var v = panelNo.getValue();
			var record = panelNo.findRecord(panelNo.valueField || panelNo.displayField, v);
			var index = panelNo.store.indexOf(record);
			metrics = panelNo.getStore().getAt(index).get('metricsField');
		}

		if(isUpdate && optionsCombo=="add")
		{
			if(Ext.isEmpty(metrics))
			{
				Ext.Msg.alert("Error","Please select the Panel Type");
				isUpdate = false;
			}
			else if(panelTitle.getValue()=="")
			{
				Ext.Msg.alert("Error","Please enter the Panel Title");
				isUpdate = false;
			}
			else if(metrics!="Group_Metrics" && colorPalette.getValue().indexOf("Please select a palette")>-1)
			{
				Ext.Msg.alert("Error","Please select a Colour Palette");
				isUpdate = false;
			}
			else if(metricsData.length==0 && test.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the test");
				isUpdate = false;
			}
			else if(metricsData.length==0 && measure.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the measure");
				isUpdate = false;
			}
			else if(metrics!="Bar_Metrics" && metricsData.length==0 && displayName.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please enter the display name");
				isUpdate = false;
			}
			else if(metrics=="Bar_Metrics" && processName.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the process name");
				isUpdate = false;
			}
			else if(metrics=="Bar_Metrics" && process.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the process");
				isUpdate = false;
			}
			else if(metricsData.length==0 && metrics=="BackendApplicationStatus" && suppotedCmpTypeObj.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the Component Type");
				isUpdate = false;
			}
		}
		
		if(isUpdate && optionsCombo=="modify")
		{
			if(panelNo.getValue()==-1)
			{
				Ext.Msg.alert("Error","Please choose the Panel");
				isUpdate = false;				
			}
			else if(metrics!="Group_Metrics" && metrics!="Area_Metrics" && metrics!="Line_Metrics" && panelTitle.getValue()=="")
			{
				Ext.Msg.alert("Error","Please enter the Panel Title");
				isUpdate = false;				
			}
			else if(modifyRadio.isVisible())
			{
				if(modifyRadio.getValue().modifyRadio=="update" && panelTitle.getValue()=="")
				{
					Ext.Msg.alert("Error","Please enter the Panel Title");
					isUpdate = false;				
				} 
				/*else if( metricsData.length==0 && metrics=="BackendApplicationStatus" && (modifyRadio.getValue().modifyRadio=="add" || modifyRadio.getValue().modifyRadio=="delete") && suppotedCmpTypeObj.getValue()=="-1")
				{
					Ext.Msg.alert("Error","Please choose the Component Type");
					isUpdate = false;				
				}
				else if(metricsData.length==0 && metrics=="BackendApplicationStatus" && (modifyRadio.getValue().modifyRadio=="add" || modifyRadio.getValue().modifyRadio=="delete") && test.getValue()=="-1")
				{
					Ext.Msg.alert("Error","Please choose the test");
					isUpdate = false;				
				}
				else if(metricsData.length==0 && metrics=="BackendApplicationStatus" && (modifyRadio.getValue().modifyRadio=="add" || modifyRadio.getValue().modifyRadio=="delete") && measure.getValue()=="-1")
				{
					Ext.Msg.alert("Error","Please choose the measure");
					isUpdate = false;				
				}*/
				else if(removeMetricsData.length==0 && panelTitle.getValue()=="" && test.getValue()=="-1")
				{
					Ext.Msg.alert("Error","Please choose the test");
					isUpdate = false;
				}
				else if(removeMetricsData.length==0 && panelTitle.getValue()!="" && (modifyRadio.getValue().modifyRadio=="add" || modifyRadio.getValue().modifyRadio=="delete") && test.getValue()=="-1")
				{
					//Ext.Msg.alert("Error","Please choose the test");
					//Fix to update panel if single measure is added using ADD MEASURES radio button
					Ext.MessageBox.confirm('ALERT', 'Are you sure want to exit the settings?', function(btn){
													if(btn === 'yes'){
														updateMetricsData();
													}
													else{
														isUpdate = false;
													}
												});
					return false;
				}
				else if(removeMetricsData.length==0 && test.getValue()!="-1" && measure.isVisible() && measure.getValue()=="-1")
				{
					Ext.Msg.alert("Error","Please choose the measure");
					isUpdate = false;
				}
				else if(modifyRadio.getValue().modifyRadio=="add" && removeMetricsData.length==0 && test.getValue()!="-1" && measure.getValue()!="-1" && displayName.getValue()=="")
				{
					Ext.Msg.alert("Error","Please enter the display name");
					isUpdate = false;
				}
			}
		}

		if(isUpdate && optionsCombo=="delete")
		{
			if(Ext.isEmpty(deleteCustomPanels.getValue()))
			{
				Ext.Msg.alert("Error","Please select atleast one item");
				isUpdate = false;
			}
		}

		if(metrics=="BackendApplicationStatus" && modifyRadio.getValue().modifyRadio=="modify" && optionsCombo=="modify") 
		{
			optionsCombo="modify";
		}
		else if(metrics=="BackendApplicationStatus" && modifyRadio.getValue().modifyRadio=="delete" && optionsCombo=="modify")
		{
			optionsCombo="delete";
		}
		else if(metrics=="BackendApplicationStatus" && modifyRadio.getValue().modifyRadio=="add" && optionsCombo=="modify")
		{
			optionsCombo="add";
		}

		if(isUpdate)
		{
			var txtVal=panelTitle.getValue();
			if (!Ext.isEmpty(txtVal) && txtVal!=undefined && this.checkSpecialCharacter(txtVal)) 
			{
				Ext.Msg.show({
							 title:'Alert',
							 msg: tipSpe,
							 buttons: Ext.Msg.OK,
							 icon: Ext.Msg.WARNING
						});
				isUpdate = false;
				return false;
			}
			txtVal=displayName.getValue();
			if (!Ext.isEmpty(txtVal) && txtVal!=undefined && this.checkSpecialCharacter(txtVal)) 
			{
				Ext.Msg.show({
							 title:'Alert',
							 msg: tipSpe,
							 buttons: Ext.Msg.OK,
							 icon: Ext.Msg.WARNING
						});
				isUpdate = false;
				return false;
			}

			if(!Ext.isEmpty(metricsData) && metricsData.length>0)
			{
				if(test.getValue()!="-1" && measure.getValue()!="-1" && displayName.getValue()!="")
				{
					var buf="";
					if(metrics=="Group_Metrics")
						buf +=",";
					else
						buf +="|hash|";

					buf +=test.getValue();
					buf +=":";
					buf +=measure.getValue();
					buf +=":";
					buf +=displayName.getValue();

					metricsData +=buf;
				}

				var url = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?isUpdate=true&&isMulti=true&metrics='+metrics+'&addOrDelete='+optionsCombo+'&userType='+userType;
				url = url+"&wholeValue="+encodeURI(metricsData);				
				url += '&panelTitle='+encodeURI(parent.filterEncode(panelTitle.getValue()));

				if(!Ext.isEmpty(chartTimeline) && chartTimeline.isVisible())
					url = url+"&chartTimeline="+chartTimeline.getValue();

				if(!Ext.isEmpty(panelNo) && panelNo.isVisible())
					url = url+"&panelNo="+panelNo.getValue();

				if(!Ext.isEmpty(panelNo) && panelNo.isVisible())
					url = url+"&panelNo="+panelNo.getValue();

				if(!Ext.isEmpty(modifyRadio) && modifyRadio.isVisible())
					url = url+"&action="+modifyRadio.getValue().modifyRadio;

				if(paletteContainer.isVisible())
					url = url+"&colorPalette="+colorPalette.getValue();
				if(suppotedCmpTypeObj.getValue()!=null && !Ext.isEmpty(suppotedCmpTypeObj.getValue()))
				{	
					url=url+"&suppotedCmpType="+suppotedCmpTypeObj.getValue();
				}
				Ext.Ajax.request({
					url : url,
					method : 'POST',
					scope:this,
					timeout:280000,
					success : function(response, opts){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(jsonData["UPDATE"]=='FAILED')
							Ext.Msg.alert("Error",UpdateError);
						if(jsonData["UPDATE"]=='SUCCESS'){
							this.hideConfigWindow();
							refreshAfterUpdate();
						}
						
					},
					failure : function()
					{
						//alert("failure");
					}
				});					
			}
			else if(!Ext.isEmpty(removeMetricsData) && removeMetricsData.length>0)
			{
				if(test.getValue()!="-1" && measure.getValue()!="-1")
				{
					var buf="";
					if(metrics=="Group_Metrics")
						buf +=",";
					else
						buf +="|hash|";

					buf +=test.getValue();
					buf +=":";
					buf +=measure.getValue();

					removeMetricsData +=buf;
				}
				var url = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?isUpdate=true&&isMulti=true&metrics='+metrics+'&addOrDelete='+optionsCombo+'&userType='+userType;
				url = url+"&removeWholeValue="+encodeURI(removeMetricsData);

				if(!Ext.isEmpty(panelNo) && panelNo.isVisible())
					url = url+"&panelNo="+panelNo.getValue();
				if(suppotedCmpTypeObj.getValue()!=null && !Ext.isEmpty(suppotedCmpTypeObj.getValue()))
				{	
					url=url+"&suppotedCmpType="+suppotedCmpTypeObj.getValue();
				}
				var testVal = test.getValue();
				var measureVal = measure.getValue();
				try
				{
					var testId = Ext.getCmp('test');
					var measureId = Ext.getCmp('measure');
					if(!Ext.isEmpty(testId.getValue()))
						testVal = testId.getValue();					
					if(!Ext.isEmpty(measureId.getValue()))
						measureVal = measureId.getValue();					
				}
				catch (ee)
				{
				}
				
				url += '&test='+testVal;
				url += '&measure='+measureVal;
				url += '&displayName='+encodeURI(displayName.getValue());
				if(!Ext.isEmpty(modifyRadio) && modifyRadio.isVisible())
					url = url+"&action="+modifyRadio.getValue().modifyRadio;
				
				Ext.Ajax.request({
					url : url,
					method : 'POST',
					scope:this,
					timeout:280000,
					success : function(response, opts){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(jsonData["UPDATE"]=='FAILED')
							Ext.Msg.alert("Error",UpdateError);
						if(jsonData["UPDATE"]=='SUCCESS'){
							this.hideConfigWindow();
							refreshAfterUpdate();
						}
					},
					failure : function()
					{
						//alert("failure");
					}
				});					
			}
			else
			{
				var url = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?isUpdate=true&addOrDelete='+optionsCombo+'&userType='+userType;
				if(optionsCombo=="add")
				{
					url += '&metrics='+metrics;

					if(panelTitle.isVisible())
						url += '&panelTitle='+encodeURI(parent.filterEncode(panelTitle.getValue()));

					url += '&test='+test.getValue();
					url += '&measure='+measure.getValue();

					if(metrics!="Bar_Metrics" && displayName.isVisible())
						url += '&displayName='+encodeURI(displayName.getValue());
					else
					{
						if(processName.isVisible() && process.isVisible())
							url += '&processName='+processName.getValue()+'&process='+process.getValue();
					}

					if((metrics=="Area_Metrics" || metrics=="Line_Metrics") && chartTimeline.isVisible())
						url += '&chartTimeline='+chartTimeline.getValue();

					if((metrics=="Area_Metrics" || metrics=="Line_Metrics" || metrics=="Bar_Metrics") && colorPalette.isVisible())
					{
						if(paletteContainer.isVisible())
							url = url+"&colorPalette="+colorPalette.getValue();
					}
					if(suppotedCmpTypeObj.getValue()!=null && !Ext.isEmpty(suppotedCmpTypeObj.getValue()))
					{	
						url=url+"&suppotedCmpType="+suppotedCmpTypeObj.getValue();
						url = url+"&removeWholeValue="+encodeURI(removeMetricsData);
					}
				}
				else if(optionsCombo=="modify")
				{
					url += '&metrics='+metrics;
					url += '&panelNo='+panelNo.getValue();
					
					if(panelTitle.isVisible())
						url += '&panelTitle='+encodeURI(parent.filterEncode(panelTitle.getValue()));
					if(suppotedCmpTypeObj.getValue()!=null && !Ext.isEmpty(suppotedCmpTypeObj.getValue()))
					{
						url=url+"&suppotedCmpType="+suppotedCmpTypeObj.getValue();
					}
					var testVal = test.getValue();
					var measureVal = measure.getValue();
					try
					{
						var testId = Ext.getCmp('test');
						var measureId = Ext.getCmp('measure');
						if(!Ext.isEmpty(testId.getValue()))
							testVal = testId.getValue();					
						if(!Ext.isEmpty(measureId.getValue()))
							measureVal = measureId.getValue();					
					}
					catch (ee)
					{
					}
					
					url += '&test='+testVal;
					url += '&measure='+measureVal;
					url += '&displayName='+encodeURI(displayName.getValue());
					if(metrics=="Group_Metrics" || metrics=="Area_Metrics" || metrics=="Line_Metrics" || metrics=="Bar_Metrics")
					{
						if(metrics!="Bar_Metrics" && displayName.isVisible())
							url += '&displayName='+encodeURI(displayName.getValue());
						else
						{
							if(processName.isVisible() && process.isVisible())
								url += '&processName='+processName.getValue()+'&process='+process.getValue();
						}

						if((metrics=="Area_Metrics" || metrics=="Line_Metrics") && chartTimeline.isVisible())
							url += '&chartTimeline='+chartTimeline.getValue();

						if((metrics=="Area_Metrics" || metrics=="Line_Metrics" || metrics=="Bar_Metrics") && colorPalette.isVisible())
						{
							if(paletteContainer.isVisible())
								url = url+"&colorPalette="+colorPalette.getValue();
						}

						if(!Ext.isEmpty(modifyRadio) && modifyRadio.isVisible())
							url = url+"&action="+modifyRadio.getValue().modifyRadio;

						if(!Ext.isEmpty(modifyRadio) && modifyRadio.isVisible() && modifyRadio.getValue().modifyRadio=="delete")
							url = url+"&isMulti=true&removeWholeValue="+encodeURI(test.getValue()+":"+measure.getValue());
					}
					else
					{
						if(!Ext.isEmpty(sessDetTimeline) && sessDetTimeline.isVisible())
							url += "&sessionDetailsTimeline="+sessDetTimeline.getValue();
						
						if(!Ext.isEmpty(sessionDetailsTopN) && sessionDetailsTopN.isVisible())
							url += "&sessionDetailsTopN="+sessionDetailsTopN.getValue();
						
						if(!Ext.isEmpty(userAlertsNop) && userAlertsNop.isVisible())
							url += "&userAlertsNop="+userAlertsNop.getValue();
					}
				}
				else if(optionsCombo=="delete")
				{
					var values = deleteCustomPanels.getValue();
					var valStr = "";
					if(!Ext.isEmpty(values) && values.length>0)
					{
						for(i=0;i<values.length;i++)
						{
							if(i!=0)
								valStr += ",";
							valStr += values[i];
						}
					}
					url = url+"&deleteCustomPanels="+valStr;	
					if(metrics=="BackendApplicationStatus")
					{						
						url += '&test='+test.getValue();
						url += '&measure='+measure.getValue();
						url += '&displayName='+encodeURI(displayName.getValue());
						url += '&metrics='+metrics;
						if(suppotedCmpTypeObj.getValue()!=null && !Ext.isEmpty(suppotedCmpTypeObj.getValue()))
						{	
							url=url+"&suppotedCmpType="+suppotedCmpTypeObj.getValue();
						}
						url = url+"&removeWholeValue="+encodeURI(removeMetricsData);
					}
				}
				else
				{
					var values = showHidePanels.getValue();
					var valStr = "";
					if(!Ext.isEmpty(values) && values.length>0)
					{
						for(i=0;i<values.length;i++)
						{
							if(i!=0)
								valStr += ",";
							valStr += values[i];
						}
					}
					url = url+"&disabledDefaultPanels="+valStr;
					if(hidePanelLog != null && hidePanelLog != undefined && hidePanelLog.length>0){
						var hideText='';
						for(var p=0;p<hidePanelLog.length;p++){
							hideText = hideText+hidePanelLog[p];
							if(p+1 != hidePanelLog.length)
								hideText = hideText+',';
						}

						url=url+"&hidePanelLog="+encodeURI(parent.filterEncode(hideText));
					}

					if(showPanelLog != null && showPanelLog != undefined && showPanelLog.length>0){
						var showText='';
						for(var p=0;p<showPanelLog.length;p++){
							showText = showText+showPanelLog[p];
							if(p+1 != showPanelLog.length)
								showText = showText+',';
						}

						url=url+"&showPanelLog="+encodeURI(parent.filterEncode(showText));
					}
				}
				if(optionsCombo=="add")
				{
					var gridsterObj = $(".gridster > ul.gridsterul"),
					gridster = gridsterObj.gridster().data('gridster');

					gridster.add_widget('<li tabindex="-1" class="gs_w" id="vijay" widgetname="vijay"/>', 5, 2, '', '');

					var pnlPositionsArr = gridster.serialize();

					var pnlPosObj = pnlPositionsArr[arrCtr];
					var posQryStr = '';
					for (var arrCtr in pnlPositionsArr) 
					{
						var pnlPosObj = pnlPositionsArr[arrCtr];
						var blkId = pnlPosObj['id'];
						if(blkId!=null && blkId!=undefined && blkId=='vijay')
						{
							var colPos = pnlPosObj['col'];
							var rowPos = pnlPosObj['row'];
							var size_x = pnlPosObj['size_x'];
							var size_y = pnlPosObj['size_y'];
							var widthVal = pnlPosObj['widthVal'];
							var heightVal = pnlPosObj['heightVal'];
							//posQryStr += "|" + blkId + ":" + colPos + "," + rowPos + "," + size_x + "," + size_y + "," + widthVal + "," + heightVal;

							url = url+"&addPropsPos="+colPos+','+rowPos+","+size_x+","+size_y;
							break;
						}
					}
				}

				Ext.Ajax.request({
					url : url,
					method : 'POST',
					scope:this,
					timeout:280000,
					success : function(response, opts){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if((jsonData["UPDATE"]=='FAILED') && Ext.isEmpty(jsonData.groupPanelTitle))
							Ext.Msg.alert("Error",UpdateError);
						else if((jsonData["UPDATE"]=='FAILED') && !Ext.isEmpty(jsonData.groupPanelTitle))
							Ext.Msg.alert("Error",jsonData.groupPanelTitle);
						if(jsonData["UPDATE"]=='SUCCESS'){
							this.hideConfigWindow();
						refreshAfterUpdate();
						}
					},
					failure : function()
					{
						//alert("failure");
					}
				});
			}
		}
	},

	appendMetrics:function(obj)
	{
		var settingsForm = obj.up().up();
		var optionsCombo = settingsForm.down('combo[id=optionsCombo]').getValue();
		var metrics = settingsForm.down('radiogroup[id=metrics]').getValue().metricsRadio;
		var panelTitle = settingsForm.down('textfield[id=panelTitle]');
		var chartTimeline = settingsForm.down('combo[id=chartTimeline]');
		var test = settingsForm.down('combo[id=test]');
		var measure = settingsForm.down('combo[id=measure]');
		var displayName = settingsForm.down('textfield[id=displayName]');
		var panelNo = settingsForm.down('combo[id=panelNo]');
		var supportedCmpTypeObj= Ext.getCmp("suppotedCmpType");
		var isUpdate = true;

		if(optionsCombo=="add" || optionsCombo=="modify")
		{
			if(panelTitle.getValue()=="")
			{
				Ext.Msg.alert("Error","Please enter the Panel Title");
				isUpdate = false;
			}
			else if(test.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the test");
				isUpdate = false;
			}
			else if(measure.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the measure");
				isUpdate = false;
			}
			else if(metrics!="Bar_Metrics" && displayName.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please enter the display name");
				isUpdate = false;
			}
			else if (metrics=="BackendApplicationStatus" && supportedCmpTypeObj.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the component type");
				isUpdate = false;
			}
			else if (metrics=="BackendApplicationStatus" && test.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the test");
				isUpdate = false;
			}
			else if (metrics=="BackendApplicationStatus" && measure.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the measure");
				isUpdate = false;
			}
		}

		if(isUpdate)
		{			
			if(optionsCombo!="add")
			{
				var v = panelNo.getValue();
				var record = panelNo.findRecord(panelNo.valueField || panelNo.displayField, v);
				var index = panelNo.store.indexOf(record);
				metrics = panelNo.getStore().getAt(index).get('metricsField');
			}
			
			var value=test.getValue()+":"+measure.getValue()+":"+displayName.getValue();
			var dispValue = displayName.getValue();
			var finalValue="";
			if(metrics=="Group_Metrics")
			{
				if(!Ext.isEmpty(metricsData))
				{
					if(metricsData.indexOf(test.getValue()+":"+measure.getValue())>-1)
						finalValue="";
					else
						finalValue=","+value;
				}
				else
				{
					finalValue=value;
				}
			}
			else if(metrics=="BackendApplicationStatus")
			{
				finalValue=value;
			}
			else
			{
				if(!Ext.isEmpty(metricsData))
				{
					if(metricsData.indexOf(test.getValue()+":"+measure.getValue())>-1)
						finalValue="";
					else
						finalValue="|hash|"+value;
				}
				else
				{
					finalValue=value;
				}
			}			
			if(!Ext.isEmpty(metricsData) && metricsData.length>0)
				metricsData += "|hash|"+finalValue;
			else
				metricsData += finalValue;
			test.setValue("-1");
			measure.setValue("-1");
			displayName.setValue("");
			if (metricsData != null && metricsData != "")
			{
				Ext.Msg.alert("ALERT","Settings added successfully -> "+dispValue);
			}
		}
	},

	appendRemoveMetrics:function(obj)
	{		
		var settingsForm = obj.up().up();
		var optionsCombo = settingsForm.down('combo[id=optionsCombo]').getValue();
		var metrics = settingsForm.down('radiogroup[id=metrics]').getValue().metricsRadio;
		var panelTitle = settingsForm.down('textfield[id=panelTitle]');
		var chartTimeline = settingsForm.down('combo[id=chartTimeline]');
		var test = settingsForm.down('combo[id=test]');
		var measure = settingsForm.down('combo[id=measure]');
		var displayName = settingsForm.down('textfield[id=displayName]');
		var panelNo = settingsForm.down('combo[id=panelNo]');
		var supportedCmpTypeObj= Ext.getCmp("suppotedCmpType");
		var isUpdate = true;

		if(optionsCombo=="modify")
		{	
			if(test.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the test");
				isUpdate = false;
			}
			else if(measure.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the measure");
				isUpdate = false;
			}	
			else if (metrics=="BackendApplicationStatus" && supportedCmpTypeObj.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the component type");
				isUpdate = false;
			}
			else if (metrics=="BackendApplicationStatus" && test.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the test");
				isUpdate = false;
			}
			else if (metrics=="BackendApplicationStatus" && measure.getValue()=="-1")
			{
				Ext.Msg.alert("Error","Please choose the measure");
				isUpdate = false;
			}		
		}

		if(isUpdate)
		{			
			var v = panelNo.getValue();
			var record = panelNo.findRecord(panelNo.valueField || panelNo.displayField, v);
			var index = panelNo.store.indexOf(record);
			metrics = panelNo.getStore().getAt(index).get('metricsField');
			
			var value=test.getValue()+":"+measure.getValue();
			// To get Displayname of test & measure
			var selected_test = test.getValue();
			var test_store = test.getStore();
			var disp_test = "";
			var disp_measure = "";
			for(var i=0;i<test_store.getCount();i++)
			{
				var acttest = test_store.getAt(i).data.valueField;
				if(acttest == selected_test)
				{
					disp_test=test_store.getAt(i).data.displayField;
				}
			}
			var selected_measure = measure.getValue();
			var measure_store = measure.getStore();
			for(var j=0;j<measure_store.getCount();j++)
			{
				var actmeasure = measure_store.getAt(j).data.valueField;
				if(actmeasure == selected_measure)
				{
					disp_measure = measure_store.getAt(j).data.displayField;
				}
			}
			var dispName = disp_test+":"+disp_measure;
			//end
			var finalValue="";
			if(metrics=="Group_Metrics")
			{
				if(!Ext.isEmpty(removeMetricsData))
				{
					if(removeMetricsData.indexOf(test.getValue()+":"+measure.getValue())>-1)
						finalValue="";
					else
						finalValue=","+value;
				}
				else
				{
					finalValue=value;
				}
			}
			else if(metrics=="BackendApplicationStatus")
			{
				finalValue=value;
			}
			else
			{
				if(!Ext.isEmpty(removeMetricsData))
				{
					if(removeMetricsData.indexOf(test.getValue()+":"+measure.getValue())>-1)
						finalValue="";
					else
						finalValue="|hash|"+value;
				}
				else
				{
					finalValue=value;
				}
			}			
			if(!Ext.isEmpty(removeMetricsData) && removeMetricsData.length>0)
				removeMetricsData +="|hash|"+finalValue;
			else
				removeMetricsData +=finalValue;
			test.setValue("-1");
			measure.setValue("-1");
			if (removeMetricsData != null && removeMetricsData != "")
			{
				Ext.Msg.alert("ALERT","Removed successfully ->"+dispName);
			}
		}
	},

	loadComponentInTheApp : function(){
		var url = Ext.getCmp('userCombo').getValue();
		window.location.href = encodeURI('/final/monitor/endUserDashboardDetailsData.jsp'+url);
	},

	loadUserCombo :function()
	{
		if(showBackBtn == 'false' || showBackBtn == false)
			Ext.getCmp('backbtn').hide();
		if(isHistory !='' && isHistory == "true")
		{
			Ext.getCmp('searchString').hide();
			Ext.getCmp('publishDashboard_icon').hide();
			Ext.getCmp('AddPanelbtn').hide();
			Ext.getCmp('ShowHideBtn').hide();
		}
		if(!showUserCombo){
			var testCombo = Ext.getCmp('userCombo');
			if (!Ext.isEmpty( testCombo ) && !Ext.isEmpty( requestParams.userCombo ) )
			{
				testCombo.show();
				testCombo.getStore().loadRawData(requestParams.userCombo[0].value);
				testCombo.setValue(requestParams.userCombo[0].selected);
			}
			else if (!Ext.isEmpty( testCombo ) )
			{
				testCombo.hide();
			}
		}
	},

	hideConfigWindow:function(){
		Ext.get("configMod").animate({
			duration: 500,
			to: {
				y: -400
			}
		});
	},

	updateSessionDetails:function(json,id){		
		var sessionObj=Ext.getCmp(id);
		if(!Ext.isEmpty(json) && json["Data"]!="NO_DATA")
		{
			var timeline=json["Timeline"];
			var data=json["Data"];
			data='<div class="x-table" style="box-shadow: 5px 5px 5px #ccc;"><table cellspacing="0" cellpadding="0" width="auto" class="x-grid-table x-grid-table-resizer" height="auto"><thead><tr class="x-grid-row  x-grid-row-column"><td class="x-grid-cell" style="width:40%;border-top:0px !important;"><div class="x-grid-cell-inner">Server</div></td><td class="x-grid-cell" style="border-top:0px !important;"><div class="x-grid-cell-inner">Last Accessed Time</div></td><td class="x-grid-cell" style="width:70px;border-top:0px !important;border-right:0px !important;"><div class="x-grid-cell-inner">&nbsp;</div></td></tr></thead><tbody><tr class="x-grid-row"><td class="x-grid-cell"><div class="x-grid-cell-inner">07/10/2014 11:02:01</div></td><td class="x-grid-cell"><div class="x-grid-cell-inner">CITRIXXENAPP_180_SV</div></td><td class="x-grid-cell"><div class = "x-grid-cell-inner"><img src="/final/images/spacer.gif" class="iconLineChart" style="cursor:pointer" hspace="3px" onClick="javascript:loadPopup("");" data-qtip="Graph" data-qclass="yellowTip"/><img src="/final/images/spacer.gif" class="iconDiagnosis"  hspace="3px" onClick="javascript:loadPopup("");" style="cursor:pointer" data-qtip="Diagnosis" data-qclass="yellowTip"/></div></td></tr><tr class="x-grid-row"><td class="x-grid-cell"><div class="x-grid-cell-inner">07/10/2014 11:02:01</div></td><td class="x-grid-cell"><div class="x-grid-cell-inner">CITRIXXENAPP_130_SV</div></td><td class="x-grid-cell"><div class = "x-grid-cell-inner"><img src="/final/images/spacer.gif" class="iconLineChart" style="cursor:pointer" hspace="3px" onClick="javascript:loadPopup("");" data-qtip="Graph" data-qclass="yellowTip"/><img src="/final/images/spacer.gif" class="iconDiagnosis"  hspace="3px" onClick="javascript:loadPopup("");" style="cursor:pointer" data-qtip="Diagnosis" data-qclass="yellowTip"/></div></td></tr></tbody></table></div>';
			sessionObj.down('displayfield[id=sessionDetailsTimeline]').setValue(timeline);
			sessionObj.update(data);
		}
		else
		{
			sessionObj.update('<table width="100%" height="100%" style="margin:20% 0 auto 0"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');	
		}
	},

	updateLoginDetails:function(json,id){		
		var loginObj=Ext.getCmp(id);
		if(json!="NO_DATA")
		{
			loginObj.add({rowspan: 2,margin:'0 10 0 10',html:'<div class="uxLoggedIn" style="margin-bottom:60px"></div>'});
			for(var key in json){
				var value=json[key];
				loginObj.add({
					xtype:'displayfield',
					fieldBodyCls:'uxGraphLabel',
					margin:10,
					labelSeparator:'',
					fieldCls:'uxGraphValue_WHITE',
					labelAlign:'top',
					fieldLabel:key,
					value:value
				});
				
			}
		}
		else
		{
			loginObj.update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');	
		}
	}/*,

	updateLogonExperienceDetails:function(json,id){		
		var loginObj=Ext.getCmp(id);
		if(json!="NO_DATA")
		{
			if(!Ext.isEmpty(json.grid)){
				var dynamicStore = Ext.create('Ext.data.Store',{
					autoLoad:true,
					fields:['timeLoggedIn','totalLogonTime','accountDiscoveryTime','dcDiscoveryTime','ldapBindToAd','profileLoadTime','systemPolicyTime','authenticationTime','server'],
					data:[{timeLoggedIn:'July 3 10:34:23 am',totalLogonTime:'1.23',accountDiscoveryTime:'0.05',dcDiscoveryTime:'0.95',ldapBindToAd:'20',profileLoadTime:'0.07',systemPolicyTime:'40',authenticationTime:'0.05',server:'infoway_ctx'}]
					this.getLocationOverviewGrid().reconfigure(dynamicStore,json.grid.columns);
			}
		}
		else
		{
			loginObj.update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style=""></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');	
		}
	}*/

	,

	loadPanels:function(){
		var me=this;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Please wait..."});
		myMask.show();
		
		for(var k=0;k<panelOrder.length;k++)
		{
			var panelId=panelOrder[k].PanelId;
			var containerId=panelId+"_container";
			var panelMetrics=panelOrder[k].Metrics;
			//panelMetrics=encodeURI(panelMetrics);
			var panelProps=panelOrder[k].Props;
			var panelToolIcon=panelOrder[k].ToolIcon;
			var panelToolIconText=panelOrder[k].ToolIconText;
			var panelToolIconId=panelOrder[k].ToolIconId;
			if(panelToolIcon==null || panelToolIcon==undefined || panelToolIcon=='undefined')
			{
				panelToolIcon="iconClose3";
				panelToolIconText="Remove Panel";
				panelToolIconId="closeWinId";
			}
			var isGraph=false;
			var isBarGraph=false;
			var isPieGraph=false;
			if(panelMetrics.indexOf("Area_Metrics")>-1 || panelMetrics.indexOf("Line_Metrics")>-1 || panelMetrics.indexOf("Bar_Metrics")>-1 || panelMetrics.indexOf("Pie_Metrics")>-1)
			{
				isGraph=true;
				if(panelMetrics.indexOf("Bar_Metrics")>-1)
				{
					isBarGraph=true;
				}
				else if(panelMetrics.indexOf("Pie_Metrics")>-1)
				{
					isPieGraph=true;
				}
			}
			var url='/final/servlet/com.eg.EgMonitorResultDispatcher';
			if(!Ext.isEmpty(url))
			{
				Ext.Ajax.request({
					url : url,
					scope:this,
					method : 'POST',
					timeout:280000,
					params: /*parameters+"&panelId="+panelId+"&panelMetrics="+panelMetrics+"&resultpage=globalsearch&isEndUserDashboard=true",*/
					parameters+"&panelId="+panelId+"&panelMetrics="+encodeURIComponent(panelMetrics)+"&resultpage=globalsearch&isEndUserDashboard=true",
					panelId:panelId,
					containerId:containerId,
					panelMetrics:panelMetrics,
					isGraph:isGraph,
					isBarGraph:isBarGraph,
					isPieGraph:isPieGraph,
					panelProps:panelProps,
					panelToolIcon:panelToolIcon,
					panelToolIconText:panelToolIconText,
					panelToolIconId:panelToolIconId,
					success: function(response){
						if(response.status==200 && !Ext.isEmpty(response.responseText)){
							
							var windowId=response.request.options.panelId;
							var metrics=response.request.options.panelMetrics;
							var props=response.request.options.panelProps.split(",");
							var url=response.request.options.url;
							var params=response.request.options.params;
							var containerId=response.request.options.containerId;
							var panelToolIconCls=response.request.options.panelToolIcon;
							var panelToolIconText=response.request.options.panelToolIconText;
							var panelToolIconId=response.request.options.panelToolIconId;

							var panelWidth=parseInt(props[0]);
							var panelHeight=parseInt(props[1]);
							var panelX=parseInt(props[2]);
							var panelY=parseInt(props[3]);

							var strRes=true;
							var strClose=true;
							var isHiddenConfig=false;
							var isDraggable=true;
							if(hideConfigFlag || isModifyEnable)
							{
								strRes=false;
								strClose=false;
								isDraggable=false;
								isHiddenConfig=true;
							}
							if(isHiddenConfig)
							{
								Ext.getCmp("AddPanelbtn").hide();
								Ext.getCmp("ShowHideBtn").hide();
							}
							var windowPanel = Ext.widget('window',{
								id:response.request.options.panelId,
								url:url,
								params:params,
								title:title,
								cls:'uxfluidwindow',
								renderTo:'BaseContainer',
								metrics:metrics,
								constrainHeader: true,
								//constrain:true,
								width: panelWidth,
								closable:strClose,
								closable:false,
								height: panelHeight,
								border:false,
								ghost:false,
								x:panelX,
								layout:{type:'vbox',align:'stretch'},
								y:panelY,
								isResized:false,
								resizeHandles:'all',
								style:{'border':'0px solid #020202;'},
								resizable:strRes,
								draggable:isDraggable,
								padding:0,
								bodyPadding:0,
								autoScroll: false,
								scroll:false,
								containerId:containerId,
								graphId:'graph_'+containerId,
								isGraph:response.request.options.isGraph,
								isBarGraph:response.request.options.isBarGraph,
								isPieGraph:response.request.options.isPieGraph,
								chartObj:null,
								barChartHeight:null,
								pieChartHeight:null,
								tools: [
								{
									xtype:'button',
									itemId:'settingId_'+containerId,
									winid:response.request.options.panelId,
									iconCls:"iconConfig",
									tooltip:"Edit Panel",
									style:{'background':'none','border':'none'},
									hidden:isHiddenConfig,
									handler: function(){
										var winObj=Ext.getCmp(this.winid);
										//alert("winObj.id-->"+winObj.id);
										var metricsVal="";
										if(metrics.indexOf('~')>=0)
										{
											metricsVal = metrics.substring(0,metrics.indexOf('~'));
										}
										Ext.get('configMod').setWidth(538);
										Ext.get('configMod').select('.configMode_popupArrow').hide();
										Ext.get('configMod').center();
										Ext.getCmp('optionsCombo').setValue('modify');
										me.loadConfigurationItems_Modify(Ext.getCmp('optionsCombo'),title,winObj.id,metricsVal);
									},									
								},
								{
									xtype:'button',
									itemId:panelToolIconId,
									winid:response.request.options.panelId,
									iconCls:panelToolIconCls,
									tooltip:panelToolIconText,
									style:{'background':'none','border':'none'},
									hidden:isHiddenConfig,
									handler: function(){
										if(!Ext.isEmpty(this.itemId) && this.itemId=='closeWinId')
										{
											var winObj=Ext.getCmp(this.winid);
											var winAct="close";
											if(!Ext.isEmpty(winObj))
											{
												Ext.MessageBox.confirm('Delete', 'Window and its configuration will be deleted permanently. Are you sure ?', function(btn){
													if(btn === 'yes'){
														me.removeWindowDetails(winObj,winAct);
														winObj.destroy();
													}
												});
												return false;
											}
										}
										else if(!Ext.isEmpty(this.itemId) && this.itemId=='hideWinId')
										{
											var winObj=Ext.getCmp(this.winid);
											var winAct="hide";
											if(!Ext.isEmpty(winObj))
											{
												Ext.MessageBox.confirm('Hide', 'Are you sure to hide ?', function(btn){
													if(btn === 'yes'){
														me.removeWindowDetails(winObj,winAct);
														winObj.destroy();
													}
												});
												return false;
											}
										}
									}
								}],
								items:[
										{
											xtype:'container',
											style:{'border':'0px solid red','overflow-x':'hidden !important'},
											baseStyle:{'background':'transparent !important','opacity':'.5 !important'},
											bodyPadding:'10 0 0 20',
											padding:0,
											flex:1,
											//border:true,
											id:containerId,
											layout:{type:'vbox',align:'stretch'},
											//height:'100%',
											//width:'100%',
											autoScroll: true,
											scroll:true,
										}	
									],
								listeners:{
									'beforeclose':function(win){
										Ext.MessageBox.confirm('Delete', 'Window and its configuration will be deleted permanently. Are you sure ?', function(btn){
										   if(btn === 'yes'){
											   var winAct="close";
											   me.removeWindowDetails(win,winAct);
											   win.destroy();
										   }
										 });
										 return false;
									 },
									'resize':function(obj){
										if(obj.isGraph){
											var measHeight=obj.getHeight();
											var measWidth = obj.getWidth();
											var graphDiv= jQuery(obj.graphId);
											var graphConId= obj.getComponent(0);

											//alert('measHeight---'+measHeight);
											if (obj.chartObj != null) 
											{
												var hCHart = obj.chartObj.highchart.chart;
												if (hCHart.container)
												{
													hCHart.width = measWidth;
													hCHart.height = measHeight;
												}
												hCHart.width = measWidth+40;
												//alert('measHeight----------'+measHeight+'hCHart.height----------'+hCHart.height);
												//alert('measHeight------'+measHeight+'measWidth------'+measWidth);

												if(obj.isBarGraph)
												{
													if(!Ext.isEmpty(obj.barChartHeight))
													{
														if(parseInt(obj.barChartHeight)>=(parseInt(measHeight)-40))
														{
															hCHart.height = obj.barChartHeight;
															graphConId.setAutoScroll(true);
														}
														else
														{
															hCHart.height = measHeight-30;
															graphConId.setAutoScroll(false);
														}
													}
													else
													{
														hCHart.height = measHeight-60;
														graphConId.setAutoScroll(false);
													}
												}
												else if(obj.isPieGraph)
												{
													if(!Ext.isEmpty(obj.pieChartHeight))
													{
														/*if(parseInt(obj.pieChartHeight)>=(parseInt(measHeight)-40))
														{
															hCHart.height = obj.pieChartHeight;
															graphConId.setAutoScroll(true);
														}
														else
														{*/
															hCHart.height = measHeight-50;
															graphConId.setAutoScroll(false);
														//}
													}
													else
													{
														hCHart.height = measHeight-50;
														graphConId.setAutoScroll(false);
													}
												}
												else
												{
													hCHart.height = measHeight-90;
													graphConId.setAutoScroll(false);
												}

												obj.chartObj.drawChart();

											}
										}
										if(obj.isResized)
											me.saveWindowHeightWidth(obj);
										else
											obj.isResized=true;

										obj.syncShadow();
											
									},
									'afterrender':function(obj)
									{
										setInterval(function(){
											refreshPanelContent(obj)
										},refreshFrequency);

										if(isDraggable)
										{
											jQuery("#"+obj.id).draggable({stop: function(){
												me.saveWindowPositions(obj);
											},handle: ".x-window-header", snapTolerance:4,grid: [4,4]});
										}
									}
								}
								
							});
							 
							me.getBaseContainer().add(windowPanel.show());
							var jsonData=Ext.decode(response.responseText);
							var data=jsonData["RESULT"];
							var title=data["TITLE"];
							var winID=windowPanel.id;
							
							if(Ext.isEmpty(title))
								title=data["JSON_DATA"]["TITLE"]

							if(response.responseText.indexOf('.png')>=0)
							{	
								windowPanel.setTitle(title);
								windowPanel.getComponent(0).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
							}
							else
							{															
								if(!Ext.isEmpty(data) && data["JSON_DATA"]!="NO_DATA")
								{
									if(!Ext.isEmpty(title))
										windowPanel.setTitle(title);

									if(Ext.isEmpty(data["PANEL_TYPE"]))
									{
										if(metrics.indexOf("LoginDetails")>-1)
										{
											windowPanel.getComponent(0).update(data["JSON_DATA"]);
											//windowPanel.getComponent(0).update('<table><tr><td width="40" valign="top"><div style="border:0px solid green;width:40px;float:left;margin:10px 0 0 10px"><div class="uxLoggedOff"></div></div></td><td width="85%"><div style="border:0px solid red;width:100%;float:right;"><ul class="uxGraphValue_box" style="width:22%;display:table;"><li class="uxGraphLabel">Currently Logged In</li><li class="uxGraphValue_WHITE">No</li></ul><ul class="uxGraphValue_box" style="width:29%;display:table;"><li class="uxGraphLabel" >Last Login</li><li class="uxGraphValue_WHITE">08/08/2014<br>11:51:14</li></ul><ul class="uxGraphValue_box" style="width:29%;display:table;"><li class="uxGraphLabel" >Last accessed</li><li class="uxGraphValue_WHITE">08/08/2014 20:51:25</li></ul><ul class="uxGraphValue_box_noline" style="width:13%;display:table;"><li class="uxGraphLabel">Duration (Mins)</li><li class="uxGraphValue_WHITE">546.75</li></ul><div class="crl"></div><div class="uxSeparatorLine" style="padding:30 0 0 0"></div><ul class="uxGraphValue_box" style="display:table;width:33%"><li class="uxGraphLabel">XenApp Server</li><li class="uxGraphValue_WHITE" data-qtip="XenApp_8.180" data-qclass="yellowTip"/ >XenApp_8.180</li></ul><ul class="uxGraphValue_box" style="display:table;width:32%"><li class="uxGraphLabel">Client IP</li><li class="uxGraphValue_WHITE">192.168.9.39</li></ul><ul class="uxGraphValue_box_noline" style="display:table;width:27%"><li class="uxGraphLabel">Client Version</li><li class="uxGraphValue_WHITE">14.1.0.0</li></ul></div></td></tr></table>');
										}
										else if(metrics.indexOf("Group_Metrics")>-1)
										{
											//windowPanel.getComponent(0).update(data["JSON_DATA"]);
											//if (Ext.getCmp("groupmetrics"))
												Ext.getCmp(windowId+'_GroupMetrics').update(data["JSON_DATA"]);
											//windowPanel.getComponent(0).addClass('panelScroll');
										}
										else if(metrics.indexOf("LogonExperience")>-1 && data["JSON_DATA"]!="NO_DATA")
										{	
											windowPanel.setTitle("<table style='margin-top:3px' width='"+(panelWidth-70)+"' border='0'><tr><td align='left'>"+title+"</td><td align='right'>Last "+data["TIME_LINE"]+" Sessions</td></tr></table>");
											
											var grid = data["JSON_DATA"];
											var dynamicStore = Ext.create('Ext.data.Store',{
												autoLoad:true,
												fields:grid["Fields"],
												data:grid["Data"]
											});
											
											

											var gridHeight=windowPanel.getHeight()-30;
											var gridWidth=windowPanel.getWidth();
											
											//windowPanel.setSize(gridWidth, gridHeight);
											
											var grid = Ext.create('Ext.grid.Panel',{
												id:windowId+'_LogonExperienceGrid',
												cls:'gridSkin',
												autoScroll:true,
												scroll:true,
												height:windowPanel.height-20,
												//height:'auto',
												frame:false,
												padding:0,	
												forceFit:true,
												store:dynamicStore,
												style:{'border':'0px solid blue','border':'none !important'},
												margin:'0 0 8 0',
												collapsible: false,
												multiSelect: true,
												stripeRows: false,
												columns:{
													items:grid["Columns"]
												}, 
												listeners:{
													resize:function(){
															var gridID=Ext.getCmp(windowId+'_LogonExperienceGrid');
															gridID.setHeight(windowPanel.height-20);

														}
													}
											});
											windowPanel.getComponent(0).add(grid);
											windowPanel.getComponent(0).setAutoScroll(false);
										}
										else if(metrics.indexOf("SessionDetails")>-1 && data["JSON_DATA"]!="NO_DATA")
										{
											windowPanel.setTitle("<table style='margin-top:2px' id='sessionDetailsTitle' width='"+(panelWidth-70)+"' border='0'><tr><td align='left'>"+title+"</td><td align='right'>"+data["TIME_LINE"]+"</td></tr></table>");

											var dynamicStore = Ext.create('Ext.data.Store',{
												autoLoad:true,
												fields:['server','lastAccessedTime','graphLinks'],
												data:data["JSON_DATA"]
											});
											var grid = Ext.create('Ext.grid.Panel',{
												id:windowId+'_SessionDetailsGrid',
												cls:'gridSkin',
												autoScroll:true,
												scroll:true,
												height:150,
												frame:false,
												padding:0,
												layout:'fit',
												store:dynamicStore,
												style:{'border':'none !important'},
												margin:'0 0 8 0',
												stateful: true,
												collapsible: false,
												multiSelect: true,
												stripeRows: true,
												columns:{
													defaults:{
														sortable:false,
														draggable:true,
														hideable:false,
													},
													items:[{
														text:'Server',
														dataIndex:'server',
														flex:2.1,
														style:{'border-left':'0px'},
													},{
														text:'Last Accessed Time',
														dataIndex:'lastAccessedTime',
														width:150
													},
													{
														dataIndex:'graphLinks',
														xtype: 'actioncolumn',
														width: 60,
														renderer:function(rec){
															return '<div >'+rec+'</div>';
														}
													}
													]
												},
												listeners:{
														resize:function(){
															var gridID=Ext.getCmp(windowId+'_SessionDetailsGrid');
															//alert("resizing");
															//alert(windowPanel.height);
															//alert(Ext.getCmp(windowId+'_UserAlertsGrid'));
															gridID.setHeight(windowPanel.height-40);
															gridID.setWidth(windowPanel.width);
														},
														render:function(){
															var gridID=Ext.getCmp(windowId+'_SessionDetailsGrid');
															//alert("resizing");
															//alert(windowPanel.height);
															//alert(Ext.getCmp(windowId+'_UserAlertsGrid'));
															gridID.setHeight(windowPanel.height-40);
															gridID.setWidth(windowPanel.width);
														}
														
													}
											});
											windowPanel.getComponent(0).add(grid);
										}
										else if(metrics.indexOf("User_Alerts")>-1 && data["JSON_DATA"]!="NO_DATA")
										{
											windowPanel.setTitle("<table style='margin-top:2px' id='userAlertsTitle' width='"+(panelWidth-70)+"' border='0'><tr><td align='left'>"+title+"</td><td align='right'>Recent "+data["TIME_LINE"]+"</td></tr></table>");
											
											var grid = data["JSON_DATA"];
											var dynamicStore = Ext.create('Ext.data.Store',{
												fields:['STATE','COMPONENT','DESCRIPTION','START_TIME','DURATION'],
												data:data["JSON_DATA"],
											});
											var grid = Ext.create('Ext.grid.Panel',{
												id:windowId+'_UserAlertsGrid',
												cls:'gridSkin',
												autoScroll:true,
												scroll:true,
												height:160,
												frame:false,
												padding:0,
												layout:'fit',
												store:dynamicStore,
												style:{'border':'none !important'},
												margin:'0 0 8 0',
												stateful: true,
												collapsible: false,
												multiSelect: true,
												stripeRows: false,
												width:'100%',
												columns:
													{
													defaults:{
														sortable:false,
														draggable:true,
														hideable:false,
													},
													items:[{
														dataIndex:'STATE',
														width:30,
														style:{'border-left':'0px'},
														renderer:function(rec){
															var stateIcon="<div style='margin-right:6px;margin-top:1px' class='state_"+rec+"'></div>";
															return stateIcon;
														}
													},{
														text:'Component',
														dataIndex:'COMPONENT',
														flex:1.5,
														sortable:true,
													},{
														text:'Description',
														dataIndex:'DESCRIPTION',
														flex:1.5,
														sortable:true,
													},{
														text:'StartTime',
														dataIndex:'START_TIME',
														width:140,
														sortable:true,
													},{
														text:'Duration',
														dataIndex:'DURATION',
														width:70,
														sortable:false,
													}]
												},
												listeners:{
														resize:function(){
															var gridID=Ext.getCmp(windowId+'_UserAlertsGrid');
															//alert("resizing");
															//alert(windowPanel.height);
															//alert(Ext.getCmp(windowId+'_UserAlertsGrid'));
															gridID.setHeight(windowPanel.height-42);
															gridID.setWidth(windowPanel.width);
														},
														render:function(){
															var gridID=Ext.getCmp(windowId+'_UserAlertsGrid');
															//alert("resizing");
															//alert(windowPanel.height);
															//alert(Ext.getCmp(windowId+'_UserAlertsGrid'));
															gridID.setHeight(windowPanel.height-42);
															gridID.setWidth(windowPanel.width);
														}
														
													}
											});
											windowPanel.getComponent(0).add(grid);
										}
										else if(metrics.indexOf("BackendApplicationStatus")>-1 && data["JSON_DATA"]!="NO_DATA")
										{	
											var grid = data["JSON_DATA"];
											var dynamicStore = Ext.create('Ext.data.Store',{
												autoLoad:true,
												fields:grid["Fields"],
												data:grid["Data"]
											});
											var grid = Ext.create('Ext.grid.Panel',{
												id:windowId+'_BackendApplicationStatusGrid',
												cls:'gridSkin',
												autoScroll:true,
												frame:false,
												padding:0,
												width:1000,
												maintainFlex:true,
												store:dynamicStore,
												style:{'border':'0px solid blue'},
												margin:'0 0 8 0',
												stateful: true,
												collapsible: false,
												multiSelect: true,
												stripeRows: false,
												
												columns:{
													defaults:{flex:3},
													items:grid["Columns"]
												}
											});
											windowPanel.getComponent(0).add(grid);
										}
									}
									else
									{
										if(Ext.isEmpty(data["CHART_TYPE"]))
										{
											if(data["JSON_DATA"]['IMAGE_URL']!="-")
											{
												me.updateChartData(data["JSON_DATA"]['IMAGE_URL'],windowPanel.getComponent(0),windowPanel);
											}
											else
											{
												windowPanel.getComponent(0).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
											}
										}
										else
										{
											if(data["JSON_DATA"]['XML_DATA']!="-")
											{
												if(data["CHART_TYPE"]=='PIE')
												{
													me.updatePieChartData(data["JSON_DATA"],windowPanel.getComponent(0),windowPanel);
												}
												else
												{
													me.updateBarChartData(data["JSON_DATA"]['XML_DATA'],windowPanel.getComponent(0),windowPanel);
												}
											}
											else
											{
												windowPanel.getComponent(0).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
											}	
										}
									}
								}
								else
								{	
									windowPanel.setTitle(title);
									if(metrics.indexOf("User_Alerts")>-1)
									{
										windowPanel.getComponent(0).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconNoalarms" style="margin:15% 0 auto 0"></div><div style="font-size:12px">No Alarms found! </div></td></tr></table>');
									}
									else
									{
										windowPanel.getComponent(0).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
									}
								}
							}
						
							if (k!=panelOrder.length-1)
							{

								
								myMask.hide();
							}
						}
					}
				});
			}
		}
	},

	updateChartData:function(url,obj,parent)
	{
		// obj.update('');
		if(!Ext.isEmpty(url))
		{
			obj.setLoading();
			Ext.Ajax.request(
			{
				url : url+"&anonymousUser=true&dashboardUserId="+userName,
				scope:this,
				method:'POST',
				timeout:280000,
				success: function(response) 
				{
					if(response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						obj.setLoading(false);
						
						if((response.responseText.indexOf('.png')>=0 || response.responseText.indexOf('.gif')>=0))
						{
							obj.update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
						}
						else
						{
							var chartData=Ext.decode(response.responseText);
							var showChartCurrentValue="yes";
							var showCharLegend="yes";
							if(!Ext.isEmpty(chartData) && chartData!='' && chartData.hasOwnProperty('DataSet'))
							{
								try
								{
									var graphId="graph_"+obj.id;

									if (parent.chartObj != null) 
									{
										//console.log("b4 destroy",parent.chartObj.highchart);
										//parent.chartObj.highchart=null;
										jQuery('#'+graphId).highcharts().destroy();
										parent.chartObj=null;
										//console.log("af destroy",parent.chartObj);
									}

									var dataSetObjArray=chartData.DataSet;
									var measHeight=obj.getHeight();
									var measWidth = obj.getWidth();
									var windowmeasHeight=parent.getHeight();
									var windowmeasWidth = parent.getWidth();
									if ((dataSetObjArray != null && !Ext.isEmpty(dataSetObjArray))) {
										var liveMeasHtml= '<div class="chartCount" style="border:0px solid red;height:90px;width:100%;overflow:auto"><div style="display:table;margin: 0 auto;width:auto"><ul style="border:0px solid green;align:center;margin-top:27px;width:auto;height:auto">';
										for(var dObj in dataSetObjArray)
										{
										   var seriesObj = dataSetObjArray[dObj];
										   if (seriesObj != null && seriesObj.hasOwnProperty('dispLegend')) 
										   {																						
												var legndName = seriesObj['dispLegend'];		
												var measVal = seriesObj['measVal'];
												var measState = seriesObj['measState'];
												var layerModelUrl = seriesObj['layerModelUrl'];
												var legndColor=seriesObj['color'];
												var unitForMeas=seriesObj['unit'];
												liveMeasHtml += '<li class="uxGraphValue_box">';
												
												 liveMeasHtml += '<div style="margin-top:0;padding-right:10px;margin-left:5px;border:0px solid violet;"><table style="margin:auto;"><tr><td valign="top"><span class="chartLegend" style="color:'+legndColor+';margin-top:-10px">.</span></td><td>';
												 liveMeasHtml += '<span class="uxGraphLabel" style="white-space:nowrap">'
													+ legndName + '</span>';
												 liveMeasHtml += '</td></tr></table>';
												 liveMeasHtml += '<div style="border:0px solid red"><div>';
												  if((showChartCurrentValue.toLowerCase()!="no" && showCharLegend.toLowerCase()=="no") )
												  {
												   liveMeasHtml += '<div><span class="chartLegend" style="color:'+legndColor+'">.</span>';
												  }
												 //liveMeasHtml += '<div style="margin-left:5px;margin-top:0px" class="uxGraphValue_WHITE">'+ measVal + '</div>';
												 //liveMeasHtml += '<div style="margin-left:5px;margin-top:0px" class="uxGraphValue_'+measState+'">'+ measVal + '</div>';
												if(isHistory !='' && isHistory == "true")
												{	if(measVal == 'NA' || measVal == '-')
													{
														liveMeasHtml += '<div style="margin-top:0px" class="uxGraphValue_WHITE"> - </div>';
													}
													else
														liveMeasHtml += '<div style="margin-top:0px" class="uxGraphValue_WHITE">'+ measVal + '</div>';
													liveMeasHtml +='</div></div>';
												}
												else
												{
													if(measVal == 'NA' || measVal == '-')
													{
														liveMeasHtml += '<div style="margin-top:0px" class="uxGraphValue_WHITE"> - </div>';
													}
													else
														liveMeasHtml += '<div style="margin-top:0px" class="uxGraphValue_WHITE"><img  class=\"stateSymbol_'+measState+'\" src=\"/final/images/clear.png\" border=\"0\" />'+ measVal + '</div>';
													liveMeasHtml +='</div></div>';
												}
												liveMeasHtml += '</li>'
										   }
										  }
										  liveMeasHtml += '</ul></div>';										   
										  if (liveMeasHtml != null && liveMeasHtml != "") {
											  liveMeasHtml = '<div>' + liveMeasHtml + '</div></div> <div id="'+graphId+'" class="timelineDiv" style="border:0px solid blue;height:auto;width:100%"></div></div>';
											  obj.update(liveMeasHtml);
											  var lineChart = {};
											  lineChart = jQuery.extend(true, {}, getHighStockAreaChartForUserExperienceDashboard(graphId,(windowmeasHeight-71),(measWidth+10),''), lineChart);
											  lineChart.setData(chartData,mgrDateFormatTemp,'',true,'right');
											  parent.chartObj=lineChart;
											  lineChart.drawChart();
											 
										}
									}
									else
									{
										obj.update('<table width="100%" height="100%"  ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
									}
									
								}
								catch (e)
								{
									alert("exception in highchart method::"+e);
								}
							}
							else
							{
								obj.update('<table width="100%" height="100%"  ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
							}
						}
					}
				}
			});
		}
	},

	updateBarChartData:function(xmlData,obj,parent){
		var chartHeight = xmlData.chartHeight;
		var windowmeasHeight=parent.getHeight();
		var windowmeasWidth = parent.getWidth();
		var graphId="graph_"+obj.id;

		if (parent.chartObj != null) 
		{
			//console.log("b4 destroy",parent.chartObj.highchart);
			//parent.chartObj.highchart=null;
			jQuery('#'+graphId).highcharts().destroy();
			parent.chartObj=null;
			//console.log("af destroy",parent.chartObj);
		}

		var divHight=windowmeasHeight;
		if(parseInt(windowmeasHeight)<parseInt(chartHeight))
		{
			divHight=chartHeight;
			obj.setAutoScroll(true);
		}
		else
			obj.setAutoScroll(false);

		//obj.update('<center><div style="margin-top:20px;margin-left:20px"><div id="barChart-'+obj.id+'" style="height:auto;border:0px solid red;"></div></div></center>');
		obj.update('<center><div style="margin-top:0px;margin-left:0px"><div id="'+graphId+'" style="width:100%;height:auto;border:0px solid blue;"></div></div></center>');
		var barChartPanel = {};
		barChartPanel = jQuery.extend(true, {}, //getHighChartsBarInstanceForEndUserDashboard('barChart-'+obj.id,chartHeight,300), barChartPanel);
		getHighChartsBarInstanceForEndUserDashboard(graphId,(divHight),windowmeasWidth-40), barChartPanel);
		barChartPanel.setData(xmlData,'','','bar');
		parent.chartObj=barChartPanel;
		parent.barChartHeight=chartHeight;
		barChartPanel.drawChart();
	},
	updatePieChartData:function(xmlData,obj,parent)
	{
		var chartHeight = 140;
		var titleColor = ( strSkin == 'Dark' )?'#9b9fa1':'#333333';
		if(xmlData.pieChartData.title == 'Total memory (MB),Free memory (MB)')
		{
			var pieTitle = '<div class="f12-bold" style="text-align:center;"><div data-qtip="'+xmlData.pieChartData.title+'" style="color:'+titleColor+';">Memory (MB)</div></div>';
		}
		else
		{
			
			var pieTitle = '<div class="f12-bold" style="text-align:center;"><div data-qtip="'+xmlData.pieChartData.title+'" style="color:'+titleColor+';">Disk Space (GB)</div></div>';
		}

		//xmlData['title'] =pieTitle;
		xmlData['useHtml']=true;

		var windowmeasHeight=parent.getHeight();
		var windowmeasWidth = parent.getWidth();
		var graphId="pie_"+obj.id;

		if (parent.chartObj != null) 
		{
			//console.log("b4 destroy",parent.chartObj.highchart);
			//parent.chartObj.highchart=null;
			jQuery('#'+graphId).highcharts().destroy();
			parent.chartObj=null;
			//console.log("af destroy",parent.chartObj);
		}
		var divHight=windowmeasHeight-10;
		if(parseInt(windowmeasHeight)<parseInt(chartHeight))
		{
			divHight=chartHeight-10;
			obj.setAutoScroll(true);
		}
		else
			obj.setAutoScroll(false);

		obj.update('<center><div style="margin-top:-10px;margin-left:5px"><div id="'+graphId+'" style="width:100%;height:'+(divHight)+'px;border:0px solid red;"></div></div></center>');

		var pieChart = {};
		pieChart = jQuery.extend(true, {}, createBar(graphId,divHight,windowmeasWidth-40), pieChart);
		pieChart.setData(xmlData,'','','pie');
		pieChart.drawChart();

		parent.chartObj=pieChart;
		parent.pieChartHeight=chartHeight;
	},
	refreshPanelContent:function(windowPanel)
	{
		var me=this;
		var panelId=windowPanel.id;
		var panelMetrics=windowPanel.metrics;
		panelMetrics=encodeURI(panelMetrics);
		var isGraph=false;			
		if(panelMetrics.indexOf("Area_Metrics")>-1 || panelMetrics.indexOf("Line_Metrics")>-1 || panelMetrics.indexOf("Bar_Metrics")>-1)
			isGraph=true;				
		
		var url=windowPanel.url;
		var params=windowPanel.params;
		if(!Ext.isEmpty(url))
		{
			Ext.Ajax.request({
				url : url,
				scope:this,
				method:'POST',
				timeout:280000,
				params:params,
				panelId:panelId,
				panelMetrics:panelMetrics,
				isGraph:isGraph,
				success: function(response)
				{
					if(response.status==200 && !Ext.isEmpty(response.responseText))
					{				
						var windowId=response.request.options.panelId;
						var metrics=response.request.options.panelMetrics;							
						var jsonData=Ext.decode(response.responseText);
						var data=jsonData["RESULT"];

						if(response.responseText.indexOf('.png')>=0)
						{	
							windowPanel.getComponent(0).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
						}
						else
						{																
							if(!Ext.isEmpty(data) && data["JSON_DATA"]!="NO_DATA")
							{
								if(Ext.isEmpty(data["PANEL_TYPE"]))
								{
									if(metrics.indexOf("LoginDetails")>-1)
									{
										windowPanel.getComponent(0).update(data["JSON_DATA"]);
										
									}
									else if(metrics.indexOf("Group_Metrics")>-1)
									{
										//windowPanel.getComponent(0).update(data["JSON_DATA"]);
										if (Ext.getCmp("groupmetrics"))
											Ext.getCmp("groupmetrics").update(data["JSON_DATA"]);
										
									}
									else if(metrics.indexOf("LogonExperience")>-1 && data["JSON_DATA"]!="NO_DATA")
									{										
										var grid = Ext.getCmp(windowId+'_LogonExperienceGrid');
										if(!Ext.isEmpty(grid))
										{
											var gridData = data["JSON_DATA"];
											var dynamicStore = Ext.create('Ext.data.Store',{
												autoLoad:true,
												fields:gridData['Fields'],
												data:gridData['Data']
											});
											grid.reconfigure(dynamicStore,gridData['Columns']);
										}
									}
									else if(metrics.indexOf("SessionDetails")>-1 && data["JSON_DATA"]!="NO_DATA")
									{
										var grid = Ext.getCmp(windowId+'_SessionDetailsGrid');
										if(!Ext.isEmpty(grid))
										{
											grid.getStore().loadData(data["JSON_DATA"]);
										}
									}
									else if(metrics.indexOf("User_Alerts")>-1 && data["JSON_DATA"]!="NO_DATA")
									{	
										var grid = Ext.getCmp(windowId+'_UserAlertsGrid');
										if(!Ext.isEmpty(grid))
										{
											grid.getStore().loadData(data["JSON_DATA"]);
										}
									}
									else if(metrics.indexOf("BackendApplicationStatus")>-1 && data["JSON_DATA"]!="NO_DATA")
									{	
										var grid = Ext.getCmp(windowId+'_BackendApplicationStatusGrid');
										if(!Ext.isEmpty(grid))
										{
											var gridData = data["JSON_DATA"];
											var dynamicStore = Ext.create('Ext.data.Store',{
												autoLoad:true,
												fields:gridData['Fields'],
												data:gridData['Data']
											});
											grid.reconfigure(dynamicStore,gridData['Columns']);
										}
									}
								}
								else
								{
									if(Ext.isEmpty(data["CHART_TYPE"]))
									{
										if(data["JSON_DATA"]['IMAGE_URL']!="-")
										{
											me.updateChartData(data["JSON_DATA"]['IMAGE_URL'],windowPanel.getComponent(0),windowPanel);
										}
										else
										{
											windowPanel.getComponent(0).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
										}
									}
									else
									{
										if(data["JSON_DATA"]['XML_DATA']!="-")
										{
											if(data["CHART_TYPE"]=='PIE')
											{
												me.updatePieChartData(data["JSON_DATA"],windowPanel.getComponent(0),windowPanel);
											}
											else
											{
												me.updateBarChartData(data["JSON_DATA"]['XML_DATA'],windowPanel.getComponent(0),windowPanel);
											}
										}
										else
										{
											windowPanel.getComponent(0).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
										}
									}
								}
							}
							else
							{	
								if(metrics.indexOf("User_Alerts")>-1)
								{
									windowPanel.getComponent(0).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconNoalarms" style="margin:15% 0 auto 0"></div><div style="font-size:12px">No Alarms found! </div></td></tr></table>');
								}
								else
								{
									windowPanel.getComponent(0).update('<table width="100%" height="100%" ><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:15% 0 auto 0"></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
								}
							}
						}								
					}
				}
			});
		}
	},
	showDDWindow:function(url)
	{
		Ext.Ajax.request({
	      	url: url,
	      	method: 'POST',
			timeout:280000,
	      	success: function( response )
	      	{
	      		if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
	      		{
	      			var jsonText = response.responseText;
	      			var jsonData = Ext.decode(jsonText);
					var htmlData = jsonData["DD_DATA"];
					var win = new Ext.Window({
							width:950,
							height:550,
							border:false,
							style:{'border':'none'},
							frame:false,
							modal:true,
							autoScroll:true,
							scroll:true,
							title:"Diagnosis Data",
							html:htmlData
					  });
					 win.show();
	      		}
	      	}
      });
	},
	showNewDDWindow:function(url,wName)
	{
		parent.openWindow((url+"&newWindow=true"),wName,'toolbar=no,menubar=no,location=no,status=no,width='+defaultWidth+', height='+defaultHeight+', top='+top+', left='+left,'screenx=0,screeny=0,scrollbars=yes,resizable=no');
	},
	showMaxGraphWindow:function(url,winTitle)
	{	
		var isAxisTimeReq = true;
		var legendPos = "right";
	    	var getMainWidth = this.getMain().getWidth();
	    	var getMainHeight = this.getMain().getHeight();
	    	var getTitle = decodeURIComponent(winTitle);
		getTitle = getTitle.split("+").join(" ");
	        var genURL = url+"&height="+(getMainHeight-200)+"&width="+(getMainWidth-50)+"&anonymousUser=true&dashboardUserId="+userName+"&hideUnitInDispname=true";
		var imgSrcUrl = '<div id="chartMaximize" style="width:'+(getMainWidth-20)+'px;display:block;" ></div>';

		Ext.widget('maximizeview', {
				title: getTitle,
				width: getMainWidth,
				height: getMainHeight,
				id : 'Maximize',
				html:imgSrcUrl,
				listeners:{
					show:function(){
						setHighChart(genURL,"chartMaximize",getMainHeight-50,getMainWidth-30,'',isAxisTimeReq,legendPos,true,true);
					}					
				}
		}).show();
	},
	showNewMaxGraphWindow:function(url,winTitle,wName)
	{
		var isAxisTimeReq = true;
		var legendPos = "right";
		var getMainWidth = this.getMain().getWidth();
		var getMainHeight = this.getMain().getHeight();
		var getTitle = decodeURIComponent(winTitle);
		getTitle = getTitle.split("+").join(" ");
		var genURL = url+"&height="+(getMainHeight-200)+"&width="+getMainWidth+"&anonymousUser=true&dashboardUserId="+userName+"&hideUnitInDispname=true";
		var imgSrcUrl = '<div id="chartMaximize" style="margin:0px 0px 0px 15px !important;width:'+getMainWidth+'px;display:block;" ></div>';
		
		parent.openWindow((url+"&newWindow=true"),wName,'toolbar=no,menubar=no,location=no,status=no,width='+defaultWidth+', height='+defaultHeight+', top='+top+', left='+left,'screenx=0,screeny=0,scrollbars=yes,resizable=no');

		
	},
	saveWindowPositions:function(win)
	{		
		var url='/final/monitor/endUserDashboardDetailsConfigJson.jsp?isUpdatePanelProps=true';
		Ext.Ajax.request({
	      	url: url,
			timeout:280000,
			params:{
				userType:userType,
				winId:win.id,
				winX:win.x,
				winY:win.y,
			},
	      	method: 'POST',
	      	success: function(response)
	      	{
	      		if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
	      		{
	      			var jsonText = response.responseText;
	      			var jsonData = Ext.decode(jsonText);
	      		}
	      	}
        });
	},
	saveWindowHeightWidth:function(win)
	{
		var url='/final/monitor/endUserDashboardDetailsConfigJson.jsp?isUpdatePanelProps=true';
		Ext.Ajax.request({
	      	url: url,
			params:{
				userType:userType,
				winId:win.id,
				winWidth:win.width,
				winHeight:win.height,
			},
			timeout:280000,
	      	method: 'POST',
	      	success: function(response)
	      	{
	      		if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
	      		{
	      			var jsonText = response.responseText;
	      			var jsonData = Ext.decode(jsonText);
					win.isResized=true;
	      		}
	      	}
        });
	},
	removeWindowDetails:function(win,winAct)
	{
		var url='/final/monitor/endUserDashboardDetailsConfigJson.jsp?isRemovePanel=true';
		if(!Ext.isEmpty(winAct) && winAct!=undefined)
		{
			url=url+"&winAct="+winAct;
		}
		Ext.Ajax.request({
	      	url: url,
			params:{
				userType:userType,
				winId:win.id
			},
			timeout:280000,
	      	method: 'POST',
	      	success: function(response)
	      	{
	      		if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
	      		{
	      			var jsonText = response.responseText;
	      			var jsonData = Ext.decode(jsonText);
					refreshAfterUpdate();
	      		}
	      	}
        });
	},
	updateMetricsData:function()
	{
		var settingsForm = this.getSettingsForm();
		var optionsCombo = settingsForm.down('combo[id=optionsCombo]').getValue();
		var metrics = settingsForm.down('radiogroup[id=metrics]').getValue().metricsRadio;
		//Fix to add single measure if close button is clicked instead of update 
		if(Ext.isEmpty(metrics) || metrics==null || metrics==undefined)
		{
			if(chartTypeStore!=null &&  !Ext.isEmpty(chartTypeStore) && chartTypeStore!=undefined)
			{
				metrics=chartTypeStore;
			}
		}
		//end
		var panelTitle = settingsForm.down('textfield[id=panelTitle]');
		var chartTimeline = settingsForm.down('combo[id=chartTimeline]');
		var test = settingsForm.down('combo[id=test]');
		var measure = settingsForm.down('combo[id=measure]');
		var displayName = settingsForm.down('textfield[id=displayName]');
		var panelNo = settingsForm.down('combo[id=panelNo]');
		var modifyRadio = settingsForm.down('radiogroup[id=modifyOptions]');
		var paletteContainer =settingsForm.down('container[id=paletteContainer]');
		var colorPalette =settingsForm.down('displayfield[id=colorPalette]');
		var isUpdate = true;
		var suppotedCmpTypeObj = Ext.getCmp("suppotedCmpType");

		if(optionsCombo!="add")
		{
			var v = panelNo.getValue();
			var record = panelNo.findRecord(panelNo.valueField || panelNo.displayField, v);
			var index = panelNo.store.indexOf(record);
			metrics = panelNo.getStore().getAt(index).get('metricsField');
		}
		
		if(!Ext.isEmpty(metricsData) && metricsData.length>0)
		{
			if(test.getValue()!="-1" && measure.getValue()!="-1" && displayName.getValue()!="")
			{
				var buf="";
				if(metrics=="Group_Metrics")
					buf +=",";
				else
					buf +="|hash|";

				buf +=test.getValue();
				buf +=":";
				buf +=measure.getValue();
				buf +=":";
				buf +=displayName.getValue();

				metricsData +=buf;
			}

			var url = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?isUpdate=true&&isMulti=true&metrics='+metrics+'&addOrDelete='+optionsCombo+'&userType='+userType;
			url = url+"&wholeValue="+encodeURI(metricsData);				
			url += '&panelTitle='+encodeURI(panelTitle.getValue());

			if(!Ext.isEmpty(chartTimeline) && chartTimeline.isVisible())
				url = url+"&chartTimeline="+chartTimeline.getValue();

			if(!Ext.isEmpty(panelNo) && panelNo.isVisible())
				url = url+"&panelNo="+panelNo.getValue();

			if(!Ext.isEmpty(panelNo) && panelNo.isVisible())
				url = url+"&panelNo="+panelNo.getValue();

			if(!Ext.isEmpty(modifyRadio) && modifyRadio.isVisible())
				url = url+"&action="+modifyRadio.getValue().modifyRadio;

			if(paletteContainer.isVisible())
				url = url+"&colorPalette="+colorPalette.getValue();
			if(suppotedCmpTypeObj.getValue()!=null && !Ext.isEmpty(suppotedCmpTypeObj.getValue()))
			{	
				url=url+"&suppotedCmpType="+suppotedCmpTypeObj.getValue();
			}
			Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				timeout:280000,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if(jsonData["UPDATE"]=='FAILED')
						Ext.Msg.alert("Error",UpdateError);
					if(jsonData["UPDATE"]=='SUCCESS'){
						this.hideConfigWindow();
						refreshAfterUpdate();
					}
					
				},
				failure : function()
				{
					//alert("failure");
				}
			});					
		}
		else if(!Ext.isEmpty(removeMetricsData) && removeMetricsData.length>0)
		{
			if(test.getValue()!="-1" && measure.getValue()!="-1")
			{
				var buf="";
				if(metrics=="Group_Metrics")
					buf +=",";
				else
					buf +="|hash|";

				buf +=test.getValue();
				buf +=":";
				buf +=measure.getValue();

				removeMetricsData +=buf;
			}

			var url = '/final/monitor/endUserDashboardDetailsConfigJson.jsp?isUpdate=true&&isMulti=true&metrics='+metrics+'&addOrDelete='+optionsCombo+'&userType='+userType;
			url = url+"&removeWholeValue="+encodeURI(removeMetricsData);

			if(!Ext.isEmpty(panelNo) && panelNo.isVisible())
				url = url+"&panelNo="+panelNo.getValue();

			if(!Ext.isEmpty(modifyRadio) && modifyRadio.isVisible())
				url = url+"&action="+modifyRadio.getValue().modifyRadio;
			

			Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				timeout:280000,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if(jsonData["UPDATE"]=='FAILED')
						Ext.Msg.alert("Error",UpdateError);
					if(jsonData["UPDATE"]=='SUCCESS'){
						this.hideConfigWindow();
						refreshAfterUpdate();
					}
					
				},
				failure : function()
				{
					//alert("failure");
				}
			});
		}
	},
	onAddPanelBtnClick : function()
	{
		var addwidgetwindow=this.getAddwidgetwindow();
		if (Ext.isEmpty(addwidgetwindow))
			addwidgetwindow = Ext.widget('addwidgetwindow');
		addwidgetwindow.show();
		addwidgetwindow=null;
		delete addwidgetwindow;
	},
	createAddPanelBlock : function(obj)
	{
			var addwidgetwindow=this.getAddwidgetwindow();
			isNewpanel = 'true'; // variable to check new widget
			if (!Ext.isEmpty(addwidgetwindow))
			{
				addwidgetwindow.hide();
			}
			addwidgetwindow=null;
			delete addwidgetwindow;
			//Ext.getCmp('configMod').setWidth(538);
			//Ext.getCmp('configMod').select('.configMode_popupArrow').hide();
			//Ext.getCmp('configMod').center();
			Ext.getCmp('configMod').show();
			Ext.getCmp('optionsCombo').setValue('add');
			var chartType=obj.chartType;
			if(chartType=="Data Panel")
			{
				chartType="Group_Metrics";
			}
			else if(chartType=="Area Chart")
			{
				chartType="Area_Metrics";
			}
			else if(chartType=="Line Chart")
			{
				chartType="Line_Metrics";
			}
			else if(chartType=="Bar Graph")
			{
				chartType="Bar_Metrics";
			}
			chartTypeStore=chartType;
			Ext.getCmp('optionsCombo').hide();
			Ext.getCmp('metrics').setValue(chartType);
			this.loadMetricsItems_AddPanel(Ext.getCmp('metrics'),chartType);
	},
	onShowHideBtnClick:function(obj)
	{
		var addwidgetwindow=this.getAddwidgetwindow();
		if (!Ext.isEmpty(addwidgetwindow))
		{
			addwidgetwindow.hide();
		}
		addwidgetwindow=null;
		delete addwidgetwindow;
		//Ext.get('configMod').setWidth(538);
		//Ext.get('configMod').select('.configMode_popupArrow').hide();
		//Ext.get('configMod').center();
		Ext.getCmp('configMod').show();
		Ext.getCmp("showHidePanelNew").show();
		Ext.getCmp('optionsCombo').setValue('showHide');
		Ext.getCmp('optionsCombo').hide();
		this.loadConfigurationItems(Ext.getCmp('optionsCombo'));
	},
	loadSuppotedCmpTypes : function(obj,modifyOptionsObj)
	{
		var url = "/final/monitor/endUserDashboardDetailsConfigJson.jsp?enduserBackendPanel=BackendAppStatus&loadData=loadCmpTypeTrue&userType="+userType+"&action="+modifyOptionsObj.getValue().modifyRadio;
		Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				timeout:280000,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var suppotedCmpTypeObj  = Ext.getCmp("suppotedCmpType");
					if( !Ext.isEmpty( suppotedCmpTypeObj ) && !Ext.isEmpty( jsonData["USER_BACKEND_APP"]))
					{
						suppotedCmpTypeObj.getStore().loadRawData(jsonData["USER_BACKEND_APP"]);
						suppotedCmpTypeObj.setValue(jsonData["USER_BACKEND_APP"][0]['valueField']);
						suppotedCmpTypeObj.show();
					}						
				},
				failure : function()
				{
					//alert("failure on backend app status");
				}
			});	
	},
	loadsuppotedCmpTypesTest : function(obj)
	{
		var cmpTypeComboObj=Ext.getCmp("suppotedCmpType");
		var cmpTypeComboValue = cmpTypeComboObj.getValue();
		var modifyOptionsObj=Ext.getCmp("modifyOptions");
		if(modifyOptionsObj.getValue().modifyRadio=="add")
		{
			var paramsForRc = 'C=true&F=getTestsForComponentJSON&P0={' + cmpTypeComboValue + '}&calljson=true';
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
				method : 'POST',
				params : paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
				scope : this,
				timeout:280000,
				//async : asyncMode,
				success : function(response){
						var jsonText = response.responseText;
	//					console.log(jsonText);
						var jsonData = Ext.decode(jsonText);									
						var testCombo =Ext.getCmp('test');
						if( !Ext.isEmpty( testCombo ) && !Ext.isEmpty( jsonData["TEST_VALUES"]))
						{
							testCombo.getStore().loadRawData(jsonData["TEST_VALUES"]);
							testCombo.setValue(jsonData["TEST_VALUES"][0]['valueField']);
							testCombo.show();						
						}					
						//this.loadMeasureOnSelectCmpTypesTest(testCombo);
					},
					failure : function()
					{
						//alert("failure on loasuppotedCmpTypesTest");
					}
				});	
		}
		else if(modifyOptionsObj.getValue().modifyRadio =="update" || modifyOptionsObj.getValue().modifyRadio=="delete")
		{
			var url = "/final/monitor/endUserDashboardDetailsConfigJson.jsp?enduserBackendPanel=BackendAppStatus&loadData=loadTestTrue&userType="+userType+"&action="+modifyOptionsObj.getValue().modifyRadio+"&suppotedCmpType="+cmpTypeComboValue;
			Ext.Ajax.request({
					url : url,
					method : 'POST',
					scope:this,
					timeout:280000,
					success : function(response, opts){
						var jsonText = response.responseText;
						//console.log(jsonText);
						var jsonData = Ext.decode(jsonText);
						var testCombo  = Ext.getCmp("test");
						if( !Ext.isEmpty( testCombo ) && !Ext.isEmpty( jsonData["TEST_VALUES"]))
							{
								testCombo.getStore().loadRawData(jsonData["TEST_VALUES"]);
								testCombo.setValue(jsonData["TEST_VALUES"][0]['valueField']);
								testCombo.show();						
							}							
					},
					failure : function()
					{
						//alert("failure on backend app status");
					}
				});	
		}
	},
	publishDashboard : function() {
		desktopName=parent.filterEncode(desktopName);
		var url = "/final/monitor/endUserDashboardDetailsConfigJson.jsp?publishDashboard=true&userType="+userType+"&desktop_Name="+encodeURI(desktopName);
		Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				timeout:280000,
				success : function(response, opts){
					var jsonText = response.responseText;					
					var jsonData = Ext.decode(jsonText);
					url=jsonData['serverUrl'];
					var meC = this;
					var publishWinObj = Ext.create('Ext.window.Window', {
						width : 480,
						title : "Publish URL",
						cls:'myDashboardwindow',
						header:{
							height:32,
							padding:'0 10',
							margin:0,
							//style:{'border-bottom':'#2b2b2b 1px solid !important'}
						},
						frame:true,
						padding:0,
						margin:0,
						resizable:false,
						border:true,
						modal:true,
						ghost:false,
						//tools: [],
						//closeAction : 'destroy',
						items : [ {
							xtype : "panel",
							margin:'10',
							layout : {
								type : 'vbox',
								align : 'stretch'
							},
							buttonAlign : 'center',
							items : [ {
								xtype : 'label',
								id : 'publishUrl',
								name : 'publishUrl',
								padding : '12 0 0 0',
								width : 100,
								html : '<div style="font-weight:bold;color:#bebebe">Publish Url</div>'
							}, {
								xtype : 'container',
								html : '<div class="arrow-container" style="overflow:auto;">' + url + '</div><div style="clear:both"></div></div>'
							} ],							
						/*	buttons : [ {
								xtype : 'button',
								text : 'Publish',
								margin:'10 0 0 0',
								padding : '0 0 0 0',
								cls : 'button20',
								align : 'center',
								handler : function() {
									this.up('.window').close(); 
								}
							} ]*/
						} ]
					});
					publishWinObj.show();
				},
				failure : function()
				{
					//alert("failure on publish dashboard");
				}
			});
	},
	onSearchXenApp : function()
	{
		var searchString = Ext.getCmp("searchString")!=null?Ext.getCmp("searchString").value:"";
		searchString = searchString.trim();
		desktopName=parent.filterEncode(desktopName);
		searchString=parent.filterEncode(searchString);
		var url='/final/monitor/endUserDashboardData.jsp?access=allusers&searchFrom=InsideEndUserDashboard&userType='+userType+'&username='+encodeURIComponent(desktopName)+'&searchStringData='+encodeURIComponent(searchString)+"&enableBackButton=true&fromMenu="+isFromMenu;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Please wait..."});
		myMask.show();
		Ext.Ajax.request({
					url : url,
					method : 'POST',
					scope:this,
					timeout:280000,
					success : function(response, opts){
						var jsonText = response.responseText;
						Ext.destroy(myMask);
						var jsonData = Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData['REDIRECT_URL']) && jsonData['REDIRECT_URL'] != null && jsonData['REDIRECT_URL'] != undefined && jsonData['REDIRECT_URL'] != '')
							window.document.location = 	jsonData['REDIRECT_URL'];
						else
							Ext.Msg.show({
								 title:'Alert',
								 msg: 'No details found',
								 buttons: Ext.Msg.OK,
								 icon: Ext.Msg.WARNING
							});
					},
					failure : function()
					{
						//alert("failure on SearchXenApp");
					}
				});
	}
});