Ext.define("endUserDashboardDetails.view.SettingsForm", {
    extend: "Ext.form.Panel",
    alias: "widget.settingsForm",
    requires: ["utilities.TimeLine",'Ext.ux.form.ItemSelector'],
    id: "settings",
	//cls:'configMode_popup_inner',
    queryString: null,
	height:'auto',
	//height:300,
	style:{'border':'none'},
	//width:515,
	//style:{'background':'#fbfbfb','z-index':'10000'},
	buttonAlign : 'center',
    items: [ 
		
		{
			xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'optionsCombo',
			id:'optionsCombo',
			labelWidth: 160,
			editable: false,
			width:400,
			margin: '10 0 10 10',
			fieldLabel:optionsLabel,
			displayField:'displayField',
			valueField:'valueField',
			queryMode:'local',
			value:'-1',
			store:Ext.create('Ext.data.Store',{
				fields:['displayField','valueField'],
				data:[
						{displayField:'Please choose an option',valueField:'-1'},
						{displayField:addLabel,valueField:'add'},
						{displayField:modifyLabel,valueField:'modify'},
						{displayField:deleteLabel,valueField:'delete'},
						{displayField:showHideLabel,valueField:'showHide'}
					 ]
			})
		},{
			xtype: 'radiogroup',
			labelSeparator:'',
			fieldLabel:metricsLabel,
			baseCls:'radiobt',
			labelWidth: 160,
			margin: '10 0 0 10',
			id:'metrics',
			hidden:true,
			width:380,
			items:[{
					boxLabel:'Data',
					name:'metricsRadio',
					id:'metricsRadio_Group_Metrics',
					inputValue:'Group_Metrics',
					width:65
				},
				{
					boxLabel:'Area',
					name:'metricsRadio',
					id:'metricsRadio_Area_Metrics',
					inputValue:'Area_Metrics',
					width:70
				},
				{
					boxLabel:'Line',
					name:'metricsRadio',
					id:'metricsRadio_Line_Metrics',
					inputValue:'Line_Metrics',
					width:60
				},
				{
					boxLabel:'DD - Bar Chart',
					name:'metricsRadio',
					id:'metricsRadio_Bar_Metrics',
					inputValue:'Bar_Metrics',
					width:150
				}]
		},{
			xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'panelNo',
			id:'panelNo',
			labelWidth: 160,
			editable: false,
			width:400,
			margin: '10 0 10 10',
			fieldLabel:'Panel',
			displayField:'displayField',
			valueField:'valueField',
			metricsField:'metricsField',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['displayField','valueField','metricsField'],
			}),
			hidden:true
		},{
			xtype: 'radiogroup',
			labelSeparator:'',
			fieldLabel:modifyOptions,
			baseCls:'radiobt',
			labelWidth: 160,
			margin: '10 0 0 10',
			id:'modifyOptions',
			hidden:true,
			width:500,
			items:[
				{
					boxLabel:updateExisting,
					checked:true,
					name:'modifyRadio',
					id:'UpdateExisiting',
					inputValue:'update',
					width:105
				},
				{
					boxLabel:addNew,					
					name:'modifyRadio',
					id:'addNew',
					inputValue:'add',
					width:105
				},
				{
					boxLabel:removeExisting,
					name:'modifyRadio',
					id:'RemoveExisting',
					inputValue:'delete',
					width:150
				}]
		},{
			xtype: 'textfield',
			labelSeparator:'',
			fieldLabel: panelTitleLabel,
			name: 'panelTitle',
			id: 'panelTitle',
		    cls:'textbox',
			labelWidth:160,
			width:400,
			maxLength:120,
			enforceMaxLength:true, 
			margin: '10 10 10 10',
			hidden:true
	    },{
		    xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'suppotedCmpType',
			id:'suppotedCmpType',
			labelWidth: 160,
			editable: false,
			width:400,
			margin: '10 0 10 10',
			fieldLabel:'Supported Component Type',
			displayField:'displayField',
			valueField:'valueField',
			metricsField:'metricsField',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['displayField','valueField','metricsField'],
			}),
			hidden:true
		},{
		    xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'chartTimeline',
			id:'chartTimeline',
			editable: false,
			labelWidth: 160,
			width:400,
			margin: '10 0 10 10',
			fieldLabel:timelineLabel,
			displayField:'display',
			valueField:'value',
			queryMode:'local',
			emptyText:'Select timeline',
			hidden:true,
			value:chartTimeline,
			store:Ext.create('Ext.data.Store',{
			fields:['display','value'],
				data:[
					{display:'1 hour',value:'1 hour'},
					{display:'3 hours',value:'3 hours'},
					{display:'6 hours',value:'6 hours'},
					{display:'12 hours',value:'12 hours'},
					{display:'18 hours',value:'18 hours'},
					{display:'24 hours',value:'24 hours'},
					{display:'2 days',value:'2 days'},
					{display:'3 days',value:'3 days'},
					{display:'4 days',value:'4 days'},
					{display:'5 days',value:'5 days'},
					{display:'6 days',value:'6 days'},
					{display:'1 week',value:'1 week'}
				]							
			})
		},
		{
			xtype:'container',
			layout:'hbox',
			hidden:true,
			id:'paletteContainer',
			margin: '10 0 10 10',
			items:[
				{
					xtype: 'displayfield',
					name: 'colorPaletteLabel',
					id:'colorPaletteLabel',
					labelSeparator:'',
					value:'Color Palette'
				},
				{
					xtype: 'displayfield',
					margin: '4 0 0 100',
					name: 'colorPalette',
					style:{'display':'inline-block'},
					id:'colorPalette',
					labelSeparator:'',
					value:'Palette1'
				},
				{
					xtype:'button',
					margin: '0 0 0 5',
					//text:'Show Palette',
					id:'showPalette',
					action:'showPalette',
					iconCls:'colorTool',
					style:{'background':'none','border':'none'},
					tooltip:'click here to choose a different color palette',
					listeners:{
						'click':function(e)
						{
							//alert(this.el.getX())
							var win = Ext.getCmp("paletteWindow");
							win.showAt([this.el.getX()-150,this.el.getY()+16]);

						}
					}
				}
			]
		},
		{
			xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'test',
			id:'test',
			labelWidth: 160,
			editable: false,
			width:400,
			margin: '10 0 10 10',
			fieldLabel:TestLabel,
			displayField:'displayField',
			valueField:'valueField',
			queryMode:'local',
			hidden:true,
			store:Ext.create('Ext.data.Store',{
				fields:['displayField','valueField'],
			
			})
		},{
			xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'measure',
			id:'measure',
			editable: false,
			labelWidth: 160,
			width:400,					
			fieldLabel:MeasureLabel,
			displayField:'displayField',
			valueField:'valueField',
			queryMode:'local',
			margin: '10 0 10 10',
			hidden:true,
			store:Ext.create('Ext.data.Store',{
				fields:['displayField','valueField'],
			
			})
		},{
			xtype: 'textfield',
			labelSeparator:'',
			fieldLabel: DisplayLabel,
			name: 'displayName',
			id: 'displayName',
		    cls:'textbox',
			labelWidth:160,
			width:400,
			maxLength:120,
			enforceMaxLength:true, 
			margin: '10 10 10 10',
			hidden:true
	    },{
			xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'processName',
			id:'processName',
			editable: false,
			labelWidth: 160,
			width:400,
			margin: '10 0 10 10',
			fieldLabel:processNameLabel,
			displayField:'displayField',
			valueField:'valueField',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['displayField','valueField'],			
			}),
			hidden:true
		},{
			xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'process',
			id:'process',
			editable: false,
			labelWidth: 160,
			width:400,
			margin: '10 0 10 10',
			fieldLabel:processLabel,
			displayField:'displayField',
			valueField:'valueField',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['displayField','valueField']			
			}),
			hidden:true
		},
		/*{
			xtype: 'itemselector',
			cls: 'itemselector',
			name: 'showHidePanels',
			id: 'showHidePanels',
			width : 550,
				height : 100,
				margin:'0 20 0 0',
				hidden : true,
				displayField: 'displayField',
				valueField: 'valueField',
				fieldLabel:showHideLabel,
			labelSeparator:'',
			margin: '10 10 10 10',
			labelWidth:160,
			height:150,
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				data:enabledDefaultPanels,
				fields: ['value','text'],
				sortInfo: {
					field: 'value',
					direction: 'ASC'
				}
			}),
				
				allowBlank : true,
				// msgTarget: 'side',
				fromTitle : 'Available Users',
				toTitle : 'Selected Users',
				listeners : {
					change : function() {
						var selectedValue = Ext.getCmp("sharingCombo").getValue();
						var form = Ext.getCmp('parForm').getForm();
						form.findField("shareUsers").setValue(this.getValue());
					}
				},
				hideNavIcons : false,
				buttons : ['add', 'remove'],
				buttonsText : {
					add: "Grant",
					remove: "Revoke"
				}
			},*/
	{
		xtype:'container',
		id:'showHidePanelNew',
		hidden:true,
		style:{'font-size':'12px','padding-left':'10px','padding-top':'10px'},
		html:showHideLabel
	},
	{
		xtype: 'itemselector',
			cls: 'itemselector',
			name: 'showHidePanels',
			id: 'showHidePanels',
			width:525,
			//fieldLabel:showHideLabel,
			labelSeparator:'',
			margin: '10 10 10 10',
			//labelWidth:80,
			//labelAlign:'top',
			height:150,

			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				data:enabledDefaultPanels,
				fields: ['value','text'],
				sortInfo: {
					field: 'value',
					direction: 'ASC'
				}
			}),
			buttonsText: {
				add: "Add to hide",
				remove: "Remove to show"
			},
			displayField: 'text',
			valueField: 'value',
			value:disabledDefaultPanels,
			//allowBlank: false,
			//msgTarget: 'side',
			buttons: ['add','remove'],
			fromTitle: 'Shown',
			toTitle: 'Hidden',
			hidden:true,

			onAddBtnClick : function() {
				var me = this,
				fromList = me.fromField.boundList,
				selected = this.getSelections(fromList);
				var showhideObj = Ext.getCmp('showHidePanels');
				var values = null;
				if(showhideObj!=null && showhideObj!=undefined && showhideObj!='')
					values = showhideObj.getValue();
				if(selected != null && selected != undefined){
					for(var i=0;i<selected.length;i++){
						var text = selected[i].data.text;	
						values.push(selected[i].data.value);
						hidePanelLog.push(text);
					}
				}

				fromList.getStore().remove(selected);
				this.toField.boundList.getStore().add(selected);
			},

			onRemoveBtnClick : function() {
				var me = this,
				toList = me.toField.boundList,
				selected = this.getSelections(toList);
				var showhideObj = Ext.getCmp('showHidePanels');
				var values = null;
				if(showhideObj!=null && showhideObj!=undefined && showhideObj!='')
					values = showhideObj.getValue();
				if(selected != null && selected != undefined){
					for(var i=0;i<selected.length;i++){
						var text = selected[i].data.text;
						var index = values.indexOf(selected[i].data.value);
						if (index >= 0) {
						  values.splice( index, 1 );
						}
						showPanelLog.push(text);
					}
				}

				Ext.getCmp('showHidePanels').setValue(values);
			},
			onItemDblClick : function(view) {
				var me = this;
				if (view == me.toField.boundList){
					me.onRemoveBtnClick();
				}
				else if (view == me.fromField.boundList) {
					me.onAddBtnClick();
				}
			},
		},
				
		{
			xtype: 'multiselect',
			name: 'deleteCustomPanels',
			id:'deleteCustomPanels',
			labelSeparator:'',
			fieldLabel: deleteLabel,
			minHeight: 100,
			margin: '10 10 10 10',
			labelWidth:160,
			width:400,
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				data:customPanels,
				fields: ['value','text'],
				sortInfo: {
					field: 'value',
					direction: 'ASC'
				}
			}),
			displayField: 'text',
            valueField: 'value',
			msgTarget: 'side',
			hidden:true,
		},{
		    xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'sessionDetailsTimeline',
			id:'sessionDetailsTimeline',
			editable: false,
			labelWidth: 160,
			width:400,
			margin: '10 0 10 10',
			fieldLabel:sessionDetailsTimelineLabel,
			displayField:'display',
			valueField:'value',
			queryMode:'local',
			emptyText:'Select timeline',
			hidden:true,
			value:sessionDetailsTimeline,
			store:Ext.create('Ext.data.Store',{
			fields:['display','value'],
				data:[
					{display:'1 hour',value:'1 hour'},
					{display:'3 hours',value:'3 hours'},
					{display:'6 hours',value:'6 hours'},
					{display:'12 hours',value:'12 hours'},
					{display:'18 hours',value:'18 hours'},
					{display:'24 hours',value:'24 hours'}
				]							
			})
		},{
		    xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'sessionDetailsTopN',
			id:'sessionDetailsTopN',
			editable: false,
			labelWidth: 160,
			width:400,
			margin: '10 0 10 10',
			fieldLabel:sessionDetailsTopNLabel,
			displayField:'display',
			valueField:'value',
			queryMode:'local',
			emptyText:'Select top N',
			hidden:true,
			value:sessionDetailsTopN,
			store:Ext.create('Ext.data.Store',{
			fields:['display','value'],
				data:[
					{display:'5',value:'5'},
					{display:'10',value:'10'},
					{display:'20',value:'20'},
					{display:'50',value:'50'}
				]							
			})
		},{
		    xtype:'combo',
			labelSeparator:'',
			cls:'dropdown',
			name:'userAlertsNop',
			id:'userAlertsNop',
			editable: false,
			labelWidth: 160,
			width:400,
			margin: '10 0 10 10',
			fieldLabel:userAlertsNopLabel,
			displayField:'display',
			valueField:'value',
			queryMode:'local',
			emptyText:'Select No of Records',
			hidden:true,
			value:userAlertsNop,
			store:Ext.create('Ext.data.Store',{
			fields:['display','value'],
				data:[
					{display:'5',value:'TOP-5'},
					{display:'10',value:'TOP-10'},
					{display:'20',value:'TOP-20'},
					{display:'50',value:'TOP-50'}
				]							
			})
		}],
	buttons:[{
				text:'Add',
				cls:'quickMenuWhiteButton',
				action: 'add',
				id:'add',
				margin:'0 10 10 0',
				hidden:true,
				tooltip:'To add multiple metrics in a graph(Comparison Graph)'
			},{
				text:'Remove',
				cls:'quickMenuWhiteButton',
				action: 'remove',
				id:'remove',
				margin:'0 10 10 0',
				hidden:true,
				tooltip:'To remove multiple metrics in a graph(Comparison Graph)'
			},{
				text:UpdateLabel,
				cls:'quickMenuWhiteButton',
				action: 'Update',
				id:'update',
				margin:'0 0 10 0'
			}]
});