Ext.define('historyack.view.DetailsGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.detailsgrid',
	title:'No of transitions found : ',
	forceFit:true,
	store:'historyack.store.HistoryAckDetail',
	cls:'history-details-grid',
	emptyText : '<img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No transitions found',
	
	initComponent : function() {
		this.columns=[{
			header:'Component Type',
			dataIndex:'compType',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'Component Name',
			dataIndex:'compName',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'Test',
			dataIndex:'test',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'Description',
			dataIndex:'description',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'Start Time',
			dataIndex:'startTime',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'End Time',
			dataIndex:'endTime',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'Duration',
			width:50,
			dataIndex:'duration',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		}];
	
		this.callParent();
	},
	
	afterRender:function(){
		this.getStore().on('load',this.storeLoadHandler,this);
		this.callParent();
	},
	
	storeLoadHandler:function(store){
		if(store.getCount()>0){
			this.setTitle('No of transitions found : '+store.getCount());
			//set the chart for first record
			var record=store.getAt(0);
			showTransitionDistribution(record.get("split"),false);
		}
	}
});