Ext.define('historyack.view.HistoryAckFilters', {
    extend: 'Ext.form.Panel',
    requires: ['historyack.view.HistoryAckFiltersCategory', 'historyack.view.HistoryAckMoreFilters'],
    alias: 'widget.historyackfilters',
    id: 'historyackfilters',
	//collapseMode: 'mini',
    moreFiltersWindow: null,
    tools: [{
        xtype: 'container',
        margin: '0 1px 0 1px',
        cls: 'iconBg',
        items: [{
            xtype: 'button',
            iconCls: 'iconSettings',
           listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: SettingsTool
                            });
                        }
                    },
				style:{
					background:'none',border:'0px'
					},
            handler: function (event, toolEl, panel) {
                 Ext.get('configMod').animate({to: {y: 41},listeners:{ afteranimate:function(){  Ext.get('configMod').setStyle('left', '');}}}).show();
            }
        }]
    },{
        xtype: 'tbseparator'
    },{
        xtype: 'container',
        margin: '0 1px 0 1px',
        id: 'saveTool',
        cls: 'iconBg',
        //disabled: true,
        items: [{
            xtype: 'button',
            iconCls: 'iconSave',
				id:'iconPDF',
				name:'iconPDF',            
			action: 'Save PDF',
			 listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: saveTool
                            });
                        }
                    },
				style:{
					background:'none',border:'0px'
					},       
           
        }]
    },{
        xtype: 'tbseparator'
    }, {
        xtype: 'container',
        margin: '0 1px 0 1px',
        cls: 'iconBg',
        id: 'csvTool',
        //disabled: true,
        items: [{
            xtype: 'button',
            iconCls: 'iconCsv',
				id:'iconCSV',
				name:'iconCSV',
			 action: 'Save CSV',
            listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: CSVTool
                            });
                        }
                    },
				style:{
					background:'none',border:'0px'
					},  
        }]
    }],
    
    screenLabels: null,
  
   cls: 'history-filters-panel',
	 padding: '0 0 5 0',
 
    items: [
	{
			xtype:'panel',	
			cls:'formOuter',
			margin:'10 10 2 10',
			layout: {
			type: 'hbox',
			align: 'stretch'
			},
			items:[
			{
			xtype: 'historyackfilterscategory',
			parent: this,
			flex:1
			},
			{
        xtype: 'button',
        itemId: 'upbutton',
        id: 'upbutton',
		hidden:true,
        enableToggle: true,
        margin:'15 10 10 10',
        iconCls: 'iconPanelDownArrow', //iconPanelUpArrow
        style: {
            background: 'none',
            border: '0px'
        },
        handler: function () {
           
			var collapsePanel = Ext.getCmp('historyackfilters');
			if(collapsePanel){
				collapsePanel.toggleCollapse(true);
			}
				if(this.pressed == true){
					this.setIconCls('iconPanelUpArrow');
					//Ext.getCmp('showAlarm').hide();
				}
				else{
					this.setIconCls('iconPanelDownArrow');
					//Ext.getCmp('showAlarm').show();
				}
        }
    }
			]}],
    buttonAlign: 'center',
   
    onRender: function () {
        var me = this;
        this.callParent();
      
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px;color:#f7f7f7" class="settingsfont"><b>'+defaultSettings+'</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="close"></div></div>');
		me.moreFiltersWindow = new Ext.Container({
			cls:'configMode_popup monitorpopup',
			width: 500,
			padding:5,
			id: 'configMod',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'410px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px 2px 2px 2px'}
				},
				{
					xtype:'historyackmorefilters',
					id: 'more-filter-options-panel',
					parent: me
				}
			],
			renderTo:'historyMain-body',
			listeners:{
				render:function(){
					if(Ext.get('close')){
					Ext.get('close').on('click',function(){
						 Ext.get('configMod').animate({duration: 500,to: {y: -350}});
						 
					});
				}}
			}
		});
        //This is to avoid empty window to be visible on the screen while loading.
       //me.moreFiltersWindow.setPosition(-500, -500);

        this.loadFields(
            'EgAlarmHistoryFrame.jsp?newAlarms=true&eg_tbound=Fixed', '');
    },

    loadFields: function (url, params, moreFiltersVisible) {
        var me = this;
        Ext.Ajax.request({
            url: url,
            params: params,
            method: 'POST',
            scope: this,
            failure: function (response) {
                var historyFiltersForm = me.getForm();
                //				Ext.Msg.alert("Something went wrong!","Sorry! we are unable to process your request. Please try reloading the page.");
            }

        });
    }


});