Ext.define('historyack.view.HistoryAckFiltersTimeline', {
	extend: 'Ext.panel.Panel',
	alias:'widget.historyackfilterstimeline',
	border:false,
	layout:'column',
	defaults:{
		labelSeparator : '',
		margin : '5 5 5 10',
		labelAlign : 'top'
	},
	items:[{
		//columnWidth : '.2',
		xtype:'scrollcombo',
		labelWidth:80,
		width:80,
		editable : false,
		cls:'dropdown',
		//fieldLabel:'Timeline',
		name:'eg_timeline',
		id:'eg_timeline',
		displayField:'displayField',
		valueField:'valueField',
		queryMode:'local',
		store:new Ext.data.Store({
			fields:['displayField','valueField'],
			data:[]
	
		}),
		listeners: {
            'select': function (obj) {
                if (obj.getValue() == 'Any') {
                    Ext.getCmp('er_enddate').setDisabled(false);
                    Ext.getCmp('er_endhr').setDisabled(false);
                    Ext.getCmp('er_sthr').setDisabled(false);
                    Ext.getCmp('er_stdate').setDisabled(false);
                } else {
                    Ext.getCmp('er_enddate').setDisabled(true);
                    Ext.getCmp('er_endhr').setDisabled(true);
                    Ext.getCmp('er_sthr').setDisabled(true);
                    Ext.getCmp('er_stdate').setDisabled(true);
                    var timeline = Ext.getCmp("eg_timeline").getValue();
                    var strtdt = Ext.getCmp("er_stdate").getValue();
                    var enddt = Ext.getCmp("er_enddate").getValue();
                    var strthour = Ext.getCmp("er_sthr").getValue();
                    var endhr = Ext.getCmp("er_endhr").getValue();

					if(timeline=="Any")
					{
						strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
						enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
					}
					else
					{
						strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
						enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
					}
                    // strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
                    //enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
					
                    var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + dateFormatForTimeline + "]";		
                    var param = "C=id&F=getTime" + no_params;
                    Ext.Ajax.request({
                        url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
                        params: param,
                        scope: this,
                        method: 'POST',
                        success: function (response) {
                            var jsontext = response.responseText;
                            var jsonData = Ext.decode(jsontext);
                            if (!Ext.isEmpty(jsonData)) {
                                var timedata = jsonData.timeline;
                                Ext.getCmp("er_stdate").setValue(timedata[6]);
                                Ext.getCmp("er_stdate").dataArray = timedata[0];
                                Ext.getCmp("er_enddate").setValue(timedata[7]);
                                Ext.getCmp("er_enddate").dataArray = timedata[1];
                                Ext.getCmp("er_sthr").setValue(timedata[8]);
                                Ext.getCmp("er_sthr").dataArray = timedata[2];
                                Ext.getCmp("er_endhr").setValue(timedata[9]);
                                Ext.getCmp("er_endhr").dataArray = timedata[3];
                                stmin = timedata[10];
                                enmin = timedata[11];
                                mgr_stmin = timedata[4];
                                mgr_enmin = timedata[5];
                            }
                        }
                    });
                }
            }
        }
	},{
	//	columnWidth : '.27',
		xtype:'datefield',
		//fieldLabel:'From',
		name:'er_stdate',
		id:'er_stdate',
		labelWidth:30,
		width:110,
		format:mgrDateFormat,
		disabled:false,
		cls:'datepicker',
		value:'',
		dataArray:'null',
		 listeners: {
            'select': function (obj) {
				var timeline = Ext.getCmp("eg_timeline").getValue();
				var strtdt = Ext.getCmp("er_stdate").getValue();
				var enddt = Ext.getCmp("er_enddate").getValue();
				var strthour = Ext.getCmp("er_sthr").getValue();
				var endhr = Ext.getCmp("er_endhr").getValue();
				if(timeline=="Any")
				{
					strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
					enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
				}
				else
				{
					strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
					enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
				}


			
				var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]";
				var param = "F=getTime&C=id" + no_params;
				Ext.Ajax.request({
					url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params: param,
					scope: this,
					method: 'POST',
					success: function (response) {
						var jsontext = response.responseText;
						var jsonData = Ext.decode(jsontext);
						if (!Ext.isEmpty(jsonData)) {
							var timedata = jsonData.timeline;
							Ext.getCmp("er_stdate").setValue(timedata[6]);
							Ext.getCmp("er_stdate").dataArray = timedata[0];
							Ext.getCmp("er_enddate").setValue(timedata[7]);
							Ext.getCmp("er_enddate").dataArray = timedata[1];
							Ext.getCmp("er_sthr").setValue(timedata[8]);
							Ext.getCmp("er_sthr").dataArray = timedata[2];
							Ext.getCmp("er_endhr").setValue(timedata[9]);
							Ext.getCmp("er_endhr").dataArray = timedata[3];
							stmin = timedata[10];
							enmin = timedata[11];
							mgr_stmin = timedata[4];
							mgr_enmin = timedata[5];
						}
					}
				});
            }
        }
	},{
		//columnWidth : '.13',
		xtype:'scrollcombo',
		//fieldLabel:'Hr',
		editable : false,
		cls:'dropdown',
		name:'er_sthr',
		disabled:false,
		id:'er_sthr',
		labelWidth:20,
		displayField:'displayField',
		valueField:'valueField',
		queryMode:'local',
		dataArray:'null',
		width:50,
		 defaultListConfig: {
						loadingHeight: 70,
						minWidth: 50,
						maxHeight: 300,
						shadow: 'sides'
		},
		store:new Ext.data.Store({
			fields:['displayField','valueField'],
			data:[]
		}),
		listeners: {
            'select': function (combo) {
                formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_stdate").getValue(),mgrDateFormat);
                //formated_edate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(),mgrDateFormat);
                //formated_edate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
				if(mgr_stmin==null || mgr_stmin=="undefined")
					mgr_stmin="00";			

                var dateValue = formated_sdate + " " + combo.getValue() + ":" + stmin + ":00";



                var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
                Ext.Ajax.request({
                    url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
                    params: param,
                    scope: this,
                    method: 'POST',
                    success: function (response) {
                        var responseText = response.responseText;
                        responseText = Ext.String.trim(responseText);
                        var dt = responseText.substring(0, responseText.lastIndexOf(" "));
                        var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
                       // Ext.getCmp("er_stdate").dataArray = dt;
                       // Ext.getCmp("er_stdate").dataArray = formated_edate;
                        if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
                            Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));
                            mgr_stmin = tim.substring(tim.indexOf(":") + 1, tim.length);
                        } else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
                            Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));
                            mgr_stmin = tim.substring(tim.indexOf(":") + 1, tim.lastIndexOf(":"));
                        }
                    }
                });
            }
        }
	},{
		//columnWidth : '.27',
		xtype:'datefield',
		//fieldLabel:'To',
		name:'er_enddate',
		id:'er_enddate',
		disabled:false,
		labelWidth:30,
		width:110,
		format:mgrDateFormat,
		cls:'datepicker',
		dataArray:'null',
		value:'',
		listeners: {
            'select': function (obj) {
				var timeline = Ext.getCmp("eg_timeline").getValue();
				var strtdt = Ext.getCmp("er_stdate").getValue();
				var enddt = Ext.getCmp("er_enddate").getValue();
				var strthour = Ext.getCmp("er_sthr").getValue();
				var endhr = Ext.getCmp("er_endhr").getValue();

				if(timeline=="Any")
				{
					strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
					enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
				}
				else
				{
					strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
					enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
				}
				var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]";
				var param = "F=getTime&C=id" + no_params;
				Ext.Ajax.request({
					url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params: param,
					scope: this,
					method: 'POST',
					success: function (response) {
						var jsontext = response.responseText;
						var jsonData = Ext.decode(jsontext);
						if (!Ext.isEmpty(jsonData)) {
							var timedata = jsonData.timeline;
							Ext.getCmp("er_stdate").setValue(timedata[6]);
							Ext.getCmp("er_stdate").dataArray = timedata[0];
							Ext.getCmp("er_enddate").setValue(timedata[7]);
							Ext.getCmp("er_enddate").dataArray = timedata[1];
							Ext.getCmp("er_sthr").setValue(timedata[8]);
							Ext.getCmp("er_sthr").dataArray = timedata[2];
							Ext.getCmp("er_endhr").setValue(timedata[9]);
							Ext.getCmp("er_endhr").dataArray = timedata[3];
							stmin = timedata[10];
							enmin = timedata[11];
							mgr_stmin = timedata[4];
							mgr_enmin = timedata[5];
						}
					}
				});
            }
        }
	},{
		//columnWidth : '.13',
		xtype:'scrollcombo',
		//fieldLabel:'Hr',
		editable : false,
		cls:'dropdown',
		name:'er_endhr',
		disabled:false,
		id:'er_endhr',
		labelWidth:20,
		dataArray:'null',
		width:50,
		 defaultListConfig: {
                                    loadingHeight: 70,
                                    minWidth: 50,
                                    maxHeight: 300,
                                    shadow: 'sides'
                                },
		displayField:'displayField',
		valueField:'valueField',
		queryMode:'local',
		store:new Ext.data.Store({
			fields:['displayField','valueField'],
			data:[]
		}),
		 listeners: {
            'select': function (combo) {
                formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
                //formated_edate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
				if(mgr_enmin==null || mgr_enmin=="undefined")
					mgr_enmin="00"
                var dateValue = formated_sdate + " " + combo.getValue() + ":" + enmin + ":00";
                var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
                Ext.Ajax.request({
                    url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
                    params: param,
                    scope: this,
                    method: 'POST',
                    success: function (response) {
                        var responseText = response.responseText;
                        var dt = responseText.substring(0, responseText.lastIndexOf(" "));
                        var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
                      //  Ext.getCmp("er_enddate").dataArray = dt;
                        if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
                            Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
                            mgr_enmin = tim.substring(tim.indexOf(":") + 1, tim.length);
                        } else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
                            Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
                            mgr_enmin = tim.substring(tim.indexOf(":") + 1, tim.lastIndexOf(":"));
                        }
                    }
                });
            }
        }
	}]
});
