
function createTooltip(view) {
		alert("test");
        view.tip = Ext.create('Ext.tip.ToolTip', {
            target: view.el,
			width:'60%',
			shadow:'frame',
			shadowOffset:50,
            delegate: view.itemSelector,
            trackMouse: true,
            //renderTo: Ext.getBody(),
            anchor: 'top',
            contentEl: 'tip1', // This instance contains static data kept in html page
                listeners: {
                   
                    beforeshow: function (tip) {
						var idTip = view.getRecord(tip.triggerElement).get('#tooltipBox');
						
						//tip.update('Doesn\'t have content for this tooltip');
						
					}
            }
        });
    }
Ext.QuickTips.init();

Ext.define('history.view.DetailsGrid', {
	 extend: 'Ext.grid.Panel',
	alias : 'widget.detailsgrid',
	title:'No of transitions found : ',
	forceFit:true,
	margin:'10 0 10 10',
	ui:'newGridPanel newGridPanelBorder',
	store:'HistoryDetail',
	header:{
		padding:'5 10',
		style:{'font-size':'12px','font-weight':'500'}
	},
	border:true,
	emptyText : '<img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No transitions found',
	initComponent : function() {
		this.columns=[{
			header:'',
			dataIndex:'state',
			hideable : false,
			sortable:false,
			resizable:false,
			enableColumnHide : true,
			filter: false,
			menuDisabled : true,
			width:36,
			bodyStyle:{'padding':'0px','margin':'0px'},
			baseStyle:{'padding':'0px','margin':'0px'},
			style:{'padding':'0px','margin':'0px'},
			margin:0,
			padding:0,
			renderer:function(state,metaData,record,rowIndex){
						if (state=='LOW')
						{
							state='Minor';
						}
						if (state=='INTERMEDIATE')
						{
							state='Major';
						}
						if (state=='HIGH')
						{
							state='Critical';
						}
						var returnState = '<img src="/final/images/clear.png" class="alarm'+state+'" />';
						return returnState;
						
				}
			},
			{
			header:'Comp Type',
			menuDisabled:true,
			dataIndex:'compType',
			renderer:function(value,metaData,record,rowIndex){
				//alert(value);
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'Comp Name',
			menuDisabled:true,
			dataIndex:'compName',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'Test',
			menuDisabled:true,
			dataIndex:'test',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'Description',
			menuDisabled:true,						
			dataIndex:'description',
			renderer:function(value,metaData,record,rowIndex){
				var decode_Val=value.replace('|hash|', '#')
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ Ext.String.htmlDecode(decode_Val) +'</a>';
				return returnValue;
			}
		},{
			header:'Start Time',
			menuDisabled:true,
			width:110,
			dataIndex:'startTime',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'End Time',
			menuDisabled:true,								
			width:110,
			dataIndex:'endTime',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		},{
			header:'Duration',
			menuDisabled:true,
			width:70,
			dataIndex:'duration',
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=showTransitionDistribution("'+record.get("split")+'")>'+ value +'</a>';
				return returnValue;
			}
		}];
	
		this.callParent();
	},
	afterRender:function(){
		this.getStore().on('load',this.storeLoadHandler,this);
		this.callParent();

	},
	
	storeLoadHandler:function(store){
		if(store.getCount()>0){
			this.setTitle('No of transitions found : '+store.getCount());
			//set the chart for first record
			var record=store.getAt(0);
			showTransitionDistribution(record.get("split"),false);
		}
	}
});