Ext.define('history.view.HistoryDetails', {
	extend : 'Ext.window.Window',
	requires:['history.view.DetailsGrid','history.view.DistributionChart'],
	cls:'history-window',
	ghost:false,
	alias : 'widget.historywindow',
	title:'Alarm transitions',
	width:885,
	height:400,
	layout:'border',
	modal:true,
	closeAction:'destroy',
	margin:'0px 0px 0px 0px',
	padding:'5 10 10 10',		
	constrain: true,
    border: false,
    frame: false,
	tools:[
		{
			xtype : 'button',
			iconCls : 'iconHelp',									
			//tooltip : '<b>New Window</b>',
			listeners: {
			afterrender: function () {
			Ext.create('Ext.tip.ToolTip', {
			target: this.id,
			anchor: 'top',
			cls: 'yellowTip',										
			trackMouse: true,
			html: 'Help'
			});
			}
			},
			style : {
				'background' : 'none',
				'border' : '0px',
				'margin':'0 10 0 0',
			},
			handler : function()
			{
				HelpWin();
			}
		}],
	listeners: {
    show: function (win) {
        if (this.modal) {
            console.log(el);
            var dom = Ext.dom.Query.select('.x-mask');
            for (var y = 0; y < dom.length; y++) {
                var el = Ext.fly(dom[y]);
               
            }
		 el.addCls('windowModal');
        }
    },
    hide: function (win) {
        var dom = Ext.dom.Query.select('.x-mask');
        if (this.modal) {

            var el = Ext.fly(dom[0]);
            el.removeCls('windowModal');
        }
    },
    afterrender: function () {
        Ext.EventManager.onWindowResize(function () {
            var me = this;
            me.center();
        }, this);
    }
	},
	initComponent : function(){
	    this.items=[{
			region:'center',
			xtype:'detailsgrid',
			 border: false,
             frame: false,
		},{
			width: 300,
			layout:{
				type:'vbox',
				align:'stretch'
			},
			items:[
				{
				xtype:'distributionchart',
				flex:1
			}	
			],
			header:false,
			region:'east',
			collapsed: true,
			border: 0,
			ui:'empty',
            frame: false,
			split: true,
			collapseMode :'mini',
			collapsible: true
		}];
	
		this.callParent();
	}
});