Ext.define('history.view.HistoryFilters', {
   extend: 'Ext.form.Panel',
    requires: ['history.view.HistoryFiltersCategory', 'history.view.HistoryMoreFilters'],
    alias: 'widget.historyfilters',
    id: 'historyfilters',
    moreFiltersWindow: null,
    tools: [{
        xtype: 'container',
        margin: '0 1px 0 1px',
        cls: 'iconBg',
        items: [{
            xtype: 'button',
            iconCls: 'iconSettings',
          listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html:settings
                            });
                        }
                    },
				style:{
					background:'none',border:'0px'
					},
            handler: function (event, toolEl, panel) {
                 Ext.get('configMod').animate({to: {y: 41},listeners:{ afteranimate:function(){  Ext.get('configMod').setStyle('left', '');}}}).show();
            }
        }]
    }, {
         xtype: 'tbseparator'
    },{
        xtype: 'container',
        margin: '0 1px 0 1px',
        id: 'saveTool',
        cls: 'iconBg',
        //disabled: true,
        items: [{
            xtype: 'button',
            iconCls: 'iconSave',
			 listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: save
                            });
                        }
                    },
				style:{
					background:'none',border:'0px'
					},           
			action: 'Save PDF',          
        }]
    }, {
         xtype: 'tbseparator'
    }, {
        xtype: 'container',
        margin: '0 1px 0 1px',
        cls: 'iconBg',
        id: 'csvTool',
        //disabled: true,
        items: [{
            xtype: 'button',
            iconCls: 'iconCsv',
			 action: 'Save CSV',
            listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: csv
                            });
                        }
                    },
				style:{
					background:'none',border:'0px'
					},  
        }]
    },{
         xtype: 'tbseparator',
		 hidden : backHidden,
		 }, {
			xtype: 'button',
			id: 'backButtonId',
			itemId: 'backButtonItemId',
			text: backLbl,
			action: 'back',
			hidden : backHidden,
			cls:'backbutton',
			margin:"4 4 0 8",
			iconCls:"iconBack"
		}
		],
    //collapsible : true,
    //collapseFirst: false,
    screenLabels: null,
    //collapseDirection: 'top',
   // cls: 'history-filters-panel',
    title: '<div>'+pageLbl+'</div>',
    padding: '0 0 5 0',
    border: false,
    url: '/final/monitor/EgAlarmHistoryView.jsp?eventsCount=0',
    items: [
			{
			xtype:'panel',	
			cls:'formOuter',
			margin:'10 10 2 10',
			layout: {
			type: 'hbox',
			align: 'stretch'
			},
			items:[
			{
			xtype: 'historyfilterscategory',
			parent: this,
			flex:1
			},
			{
        xtype: 'button',
        itemId: 'upbutton',
        id: 'upbutton',
		hidden:true,
		margin:'15 10 10 10',
        enableToggle: true,        
        iconCls: 'iconPanelDownArrow', //iconPanelUpArrow
        style: {
            background: 'none',
            border: '0px'
        },
        handler: function () {
           
			var collapsePanel = Ext.getCmp('historyfilters');
			if(collapsePanel){
				collapsePanel.toggleCollapse(true);
			}
			
				if(this.pressed == true){
					this.setIconCls('iconPanelUpArrow');
					
					}
				else{
					this.setIconCls('iconPanelDownArrow');
					

					}
        }
    }
			]}],/* buttons:[
		{
            text: 'Show Alarms',
            cls: 'button20',
            action: 'Show Alarms'
        }
	], */

    buttonAlign: 'center',
  
    /*dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        ui: 'footer',
        items: ['->', {
            xtype: 'label',
            text: 'Download as : '
        }, {
            text: '',
            iconCls: 'iconCsv',
            border: false,
            cls: 'export-formats-button',
            action: 'Save CSV'
        }, {
            text: '',
            iconCls: 'iconPdf',
            border: false,
            cls: 'export-formats-button',
            action: 'Save PDF'
        }]
    }],*/
    onRender: function () {
        var me = this;
        this.callParent();
        /*me.moreFiltersWindow = new Ext.Window({
            closeAction: 'hide',
            id: 'panelHide',
            header: false,
            resizable: false,
            collapseDirection: 'top',
            hideCollapseTool: true,
            collapsible: true,
            collapseMode: 'mini',
            cls: 'history-filters-panel history-more-filters-panel',
            padding: 0,
            margin: 0,
            style: {
                borderColor: '#EAEBED !important'
            },
            width: 500,
            items: [{
                xtype: 'historymorefilters',
                id: 'more-filter-options-panel',
                parent: me
            }]
        }).show();*/

		var leftPos="";


		if (backHidden!=true)
		{
			leftPos="355px";
		}
		else
		{
			leftPos="430px";
		}

		 var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px;color:#f7f7f7" class="settingsfont""><b>'+settings+'</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="close"></div></div>');
		me.moreFiltersWindow = new Ext.Container({
			width: 520,
			padding:5,
			id: 'configMod',
			cls:'configMode_popup monitorpopup',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					height:12,
					style:{'top':'-12px','left':""+leftPos+""}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px 2px 2px 2px'}
				},
				{
					xtype:'historymorefilters',
					id: 'more-filter-options-panel',
					parent: me
				}
			],
			renderTo:'main-body',
			listeners:{
				render:function(){
					if(Ext.get('close')){
					Ext.get('close').on('click',function(){
						 Ext.get('configMod').animate({duration: 500,to: {y: -350}});
						 
					});
				}}
			}
		});
        //This is to avoid empty window to be visible on the screen while loading.
       //me.moreFiltersWindow.setPosition(-500, -500);
		this.loadComboData();
    },

    findComponents: function (url, val, thisForm, moreFiltersVisible) {
        var me = this;
        var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
        var v_event = thisForm.findField('eventfor').getValue();
        var subevent = null;
        var selectedsubzone = null;

        if (v_event != null && v_event != "" && (v_event == 'Service' || v_event == 'Zone' || v_event == 'Segment')) subevent = thisForm.findField('event_select').getValue();
        if (subevent != null && subevent != "" && v_event == 'Zone') selectedsubzone = thisForm.findField('includeSubZone').getValue();
        var ctype = thisForm.findField('compTypeList').getValue();
        var cname = thisForm.findField('compNameList').getValue();
        var st = thisForm.findField('state').getValue();
        var dur = moreFiltersForm.findField('duration').getValue();
        var ts = moreFiltersForm.findField('timeselect').getValue();
        var cond = moreFiltersForm.findField('glduration').getValue();
        var tline = moreFiltersForm.findField('eg_timeline').getValue();
        var stdate = moreFiltersForm.findField('eg_stdate').getRawValue();
        var enddate = moreFiltersForm.findField('eg_enddate').getRawValue();
        var sthr = moreFiltersForm.findField('starthr').getValue();
        var endhr = moreFiltersForm.findField('endhr').getValue();
        var arrAlarms = moreFiltersForm.findField('sortBy').getValue();
        var ackValue = moreFiltersForm.findField('showacknowledge').getValue();
        var eventsPerPage = moreFiltersForm.findField('eventsPerPage').getValue();
        var showUsers = "";
        if (moreFiltersForm.showuser != null && moreFiltersForm.showuser != 'undefined' && moreFiltersForm.showuser != undefined) showUsers = moreFiltersForm.showuser.value;
			showUsers = moreFiltersForm.findField('showuser').getValue();
        if (val == 'Type') {
            // document.Event.compTypeList.value=ctype;
            if (ctype == '-1' || ctype == 'Host_system') {
                thisForm.findField('compTypeList').setValue('-1');
                cname = '-1';
            }
        }

        if (cond != null && cond == '<') {
            dur = -dur;
        } else if (cond) {
            dur = "0" + dur;
        }
        if (cname != null && cname != undefined && cname.length > 0) {
            cname = cname.replace('&', '|amp|');
        }
        var paramValue = null;
        paramValue = "v_event=" + v_event + "&subevent=" + subevent + "&selectedsubzone=" + selectedsubzone + "&compTypeList=" + encodeURI(ctype) + "&compNameList=" + encodeURI(cname) + "&state=" + st + "&duration=" + dur + "&timeselect=" + ts + "&eg_timeline=" + tline + "&arrangeAlarms=" + arrAlarms + "&eventsPerPage=" + eventsPerPage + "&showacknowledge=" + ackValue + "&showuser=" + encodeURIComponent(showUsers);
        if (tline == "Any") {
            paramValue = paramValue + "&eg_stdate=" + stdate + "&eg_enddate=" + enddate + "&starthr=" + sthr + "&endhr=" + endhr;
        }
        this.loadFields(url, paramValue, moreFiltersVisible);
    },

    loadFields: function (url,params,moreFiltersVisible) {
        var me = this;
		console.log('In loadFields method!');
		/*console.log(monitor.HistorySummary.filterData);
		if(!Ext.isEmpty(monitor.HistorySummary.filterData))
			return;
		var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
        Ext.Ajax.request({
            url: url,
            params: params,
            method: 'POST',
            scope: this,
			async:true,
            success: function (response) {
				console.log('Received response in loadFields method!');
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                var historyFiltersForm = me.getForm();

                var screenLabels = jsonData.screenLabels;
                this.screenLabels = jsonData.screenLabels;
                this.updateLabels(historyFiltersForm, screenLabels);
                /*me.setValueWithOptionInList(historyFiltersForm, 'eventfor', jsonData.eventfor, jsonData.eventfor_value);

                me.setValueWithOptionInList(historyFiltersForm, 'compTypeList', jsonData.compTypeList, jsonData.compTypeList_value);

                me.setValueWithOptionInList(historyFiltersForm, 'state', jsonData.state, jsonData.state_value);

                me.setValueWithOptionInList(historyFiltersForm, 'compNameList', jsonData.compNameList, jsonData.compNameList_value);*/
				/*historyFiltersForm.findField('eventfor').getStore().loadRawData(jsonData.eventfor);
				historyFiltersForm.findField('compTypeList').getStore().loadRawData(jsonData.compTypeList);
				historyFiltersForm.findField('state').getStore().loadRawData(jsonData.state);
				historyFiltersForm.findField('compNameList').getStore().loadRawData(jsonData.compNameList);

                if (jsonData.event_select_Ind == "true") {
                    historyFiltersForm.findField('event_select')
                        .setDisabled(false);
                    historyFiltersForm.findField('event_select')
                        .setVisible(true);
                    me.setValueWithOptionInList(historyFiltersForm, 'event_select', jsonData.event_select, jsonData.event_select_value);
                } else {
                    historyFiltersForm.findField('event_select')
                        .setDisabled(true);
                    historyFiltersForm.findField('event_select')
                        .setVisible(false);
                    historyFiltersForm.findField('event_select').el.dom.style.display = "none";
                }

                if (jsonData.includeSubZone_Ind == "true") {
                    historyFiltersForm.findField('includeSubZone')
                        .setDisabled(false);
                    historyFiltersForm.findField('includeSubZone')
                        .setVisible(true);
                    historyFiltersForm.findField('includeSubZone').el.dom.style.display = "block";

                    me.setValueWithOptionInList(historyFiltersForm, 'includeSubZone', jsonData.includeSubZone, jsonData.includeSubZone_value);
                } else {
                    historyFiltersForm.findField('includeSubZone')
                        .setDisabled(true);
                    historyFiltersForm.findField('includeSubZone')
                        .setVisible(false);
                    historyFiltersForm.findField('includeSubZone').el.dom.style.display = "none";
                }
                //Ext.getCmp('more-filter-options-panel').loadFields(jsonData);
                if (!moreFiltersVisible) {
                    me.moreFiltersWindow.hide();
                }
				console.log('Finished execution in loadFields method!');
			},
			failure: function (response) {
				var historyFiltersForm = me.getForm();
				//Ext.Msg.alert("Something went wrong!","Sorry! we are unable to process your request. Please try reloading the page.");
            }
        });*/
    },

    setValueWithOptionInList: function (form, fieldName, list, value) {
        form.findField(fieldName).getStore().loadRawData(list);
        form.findField(fieldName).suspendEvents(false);
        var valueAssigned = false;
        for (var listCounter = 0; listCounter < list.length; listCounter++) {
            if (list[listCounter].valueField == value && value != "" && value != null) {
                form.findField(fieldName).setValue(value);
                valueAssigned = true;
            }
        }
        if (!valueAssigned) {
            form.findField(fieldName).setValue(list[0].valueField);
        }
        form.findField(fieldName).resumeEvents();
    },

    updateLabels: function (screenLabels) {
		var form = this.getForm();
        form.findField('eventfor').setFieldLabel(screenLabels['monitor.history.Analysis By']);
        form.findField('compTypeList').setFieldLabel(screenLabels['monitor.history.Type']);
        form.findField('state').setFieldLabel(screenLabels['monitor.history.Priority']);
        form.findField('compNameList').setFieldLabel(screenLabels['monitor.common.Component']);
        form.findField('event_select').setFieldLabel(screenLabels['select_event']);
        form.findField('includeSubZone').setFieldLabel(screenLabels['monitor.history.Include Subzones']);
		//Ext.getCmp('more-filter-options-panel').updateLabels(screenLabels);
    },

	loadComboData:function(){
		var me = this;
		var jsonData = monitor.HistorySummary.filterData;
		var historyFiltersForm = me.getForm();

		var screenLabels = jsonData.screenLabels;
		this.screenLabels = jsonData.screenLabels;
		this.updateLabels(historyFiltersForm, screenLabels);

		historyFiltersForm.findField('eventfor').getStore().getProxy().data = jsonData;
		historyFiltersForm.findField('eventfor').getStore().load();
		historyFiltersForm.findField('compTypeList').getStore().loadRawData(jsonData.compTypeList);
		historyFiltersForm.findField('state').getStore().loadRawData(jsonData.state);
		historyFiltersForm.findField('compNameList').getStore().loadRawData(jsonData.compNameList);
		historyFiltersForm.findField('includeSubZone').getStore().loadRawData(jsonData.includeSubZone);

		if (jsonData.event_select_Ind == "true") {
			historyFiltersForm.findField('event_select')
				.setDisabled(false);
			historyFiltersForm.findField('event_select')
				.setVisible(true);
			historyFiltersForm.findField('event_select').getStore().loadRawData(jsonData.event_select);
			//me.setValueWithOptionInList(historyFiltersForm, 'event_select', jsonData.event_select, jsonData.event_select_value);
		} else {
			historyFiltersForm.findField('event_select')
				.setDisabled(true);
			historyFiltersForm.findField('event_select')
				.setVisible(false);
			historyFiltersForm.findField('event_select').hide();
		}

		if (jsonData.includeSubZone_Ind == "true") {
			historyFiltersForm.findField('includeSubZone')
				.setDisabled(false);
			historyFiltersForm.findField('includeSubZone')
				.setVisible(true);
			historyFiltersForm.findField('includeSubZone').show();

			historyFiltersForm.findField('includeSubZone').getStore().loadRawData(jsonData.includeSubZone);
			//me.setValueWithOptionInList(historyFiltersForm, 'includeSubZone', jsonData.includeSubZone, jsonData.includeSubZone_value);
		} else {
			historyFiltersForm.findField('includeSubZone')
				.setDisabled(true);
			historyFiltersForm.findField('includeSubZone')
				.setVisible(false);
			historyFiltersForm.findField('includeSubZone').hide();
		}
		Ext.getCmp('more-filter-options-panel').loadFields(jsonData);
		Ext.getCmp('more-filter-options-panel').updateLabels(screenLabels);
		//me.moreFiltersWindow.hide();
	}
});