Ext.define('historyApp.view.HistorySummaryGrid', {
	extend: 'utilities.CustomGrid',
	alias:'widget.historysummarygrid',
	border:false,
	forceFit : true,
	cls:'history-grid',
	columnLabels : ['Comp Type', 'Comp Name', 'Service(s)', 'Test', 'Description', 'Start Time', 'Duration'],
	pageSize:15,
	defaultPagingToolbar : null,
	
	initComponent : function() {
	    this.dockedItems= [this.defaultPagingToolbar];
    
		this.columns=[{
			header:' ',
			dataIndex:'priority',
			flex : 1,
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<img class="alarm'+value+'" src="/final/images/clear.png"/>'
				return returnValue;
			}
		},{
			header:this.columnLabels[0],
			dataIndex:'type',
			flex : 3,
			renderer:function(value,metaData,record,rowIndex){
				var popupVal = ""+record.get("popupVal");
				popupVal = encodeURI(popupVal);
				var returnValue = '<a href="javascript:void(0);" onclick=showDetails("event","'+popupVal+'",'+rowIndex+')>'+value+'</a>';
				return returnValue;
			}
		},{
			header:this.columnLabels[1],
			dataIndex:'name',
			flex : 3,
			renderer:function(value,metaData,record,rowIndex){
				var popupVal = ""+record.get("popupVal");
				popupVal = encodeURI(popupVal);
				var returnValue = '<a href="javascript:void(0);" onclick=showDetails("event","'+popupVal+'",'+rowIndex+')>'+value+'</a>';
				return returnValue;
			}
		},{
			header:this.columnLabels[2],
			dataIndex:'services',
			flex : 3,
			renderer:function(value,metaData,record,rowIndex){
				var popupVal = ""+record.get("popupVal");
				popupVal = encodeURI(popupVal);
				var returnValue = '<a href="javascript:void(0);" onclick=showDetails("event","'+popupVal+'",'+rowIndex+')>'+value+'</a>';
				return returnValue;
			}
		},{
			header:this.columnLabels[3],
			dataIndex:'test',
			flex : 3,
			renderer:function(value,metaData,record,rowIndex){
				var popupVal = ""+record.get("popupVal");
				popupVal = encodeURI(popupVal);
				var returnValue = '<a href="javascript:void(0);" onclick=showDetails("event","'+popupVal+'",'+rowIndex+')>'+value+'</a>';
				return returnValue;
			}
		},{
			header:this.columnLabels[4],
			dataIndex:'description',
			flex : 4,
			renderer:function(value,metaData,record,rowIndex){
				var popupVal = ""+record.get("popupVal");
				popupVal = encodeURI(popupVal);
				var returnValue = '<a href="javascript:void(0);" onclick=showDetails("event","'+popupVal+'",'+rowIndex+')>'+value+'</a>';
				return returnValue;
			}
		},{
			header:this.columnLabels[5],
			dataIndex:'stdate',
			flex : 3,
			renderer:function(value,metaData,record,rowIndex){
				var popupVal = ""+record.get("popupVal");
				popupVal = encodeURI(popupVal);
				var returnValue = '<a href="javascript:void(0);" onclick=showDetails("event","'+popupVal+'",'+rowIndex+')>'+value+'</a>';
				return returnValue;
			}
		},{
			header:this.columnLabels[6],
			dataIndex:'duration',
			flex : 2,
			renderer:function(value,metaData,record,rowIndex){
				var popupVal = ""+record.get("popupVal");
				popupVal = encodeURI(popupVal);
				var returnValue = '<a href="javascript:void(0);" onclick=showDetails("event","'+popupVal+'",'+rowIndex+')>'+value+'</a>';
				return returnValue;
			}
		},{
			header:' ',
			hideable : false,
			flex : 1,
			renderer:function(value,metaData,record,rowIndex){
				var returnValue = '<a href="javascript:void(0);" onclick=popupValue("'+record.get("graphParams").url+'","'+record.get("graphParams").subParam+'","'+record.get("graphParams").popup_selection+'")><img class="barGraphIcon" src="/final/images/clear.png"/></a>';
				return returnValue;
			}
		}];
		this.listeners={
			scope:this,
			'columnhide':function(){
				this.getView().refresh();
			},
			'columnshow':function(){
				this.getView().refresh();
			}
		};
		this.getStore().fireGroupChange();
		this.callParent();
	}	
});
