Ext.define('history.view.Main', {
			//extend : 'Ext.panel.Panel',
			extend : 'utilities.OuterPanel',
			requires : ['history.view.HistorySummary',
					'history.view.HistoryFilters','history.store.HistorySummary','utilities.ScrollCombo'],
			alias : 'widget.main',
			id:'main',
			//cls:'history-main-panel',
			margin:'8 8 0 8',
			//bodyStyle:{'background-color':'#e6e6e6'},
			border : false,
			autoScroll:true,
			scroll:false,
			flex:1,
			layout : {
				type : 'vbox',
				align : 'stretch'
			},
			items : [{
						xtype : 'historyfilters'
					},
					{
						xtype:'container',
						margin:'0 5 0 0',				
						layout : {
							type : 'hbox',
							pack : 'end'
						},				
						items:[
						{
							xtype:'button',
							cls:'iconCollapseAll',
							style:{'border':'none'},
							id:'treeExpand',
							toolTip:'Expand/Collapse all',
							margin:'10 0 0 10',
							hidden:showEventHistory,
							enableToggle:true,
							listeners:{
								'afterrender':function(win){
									var tip = Ext.create('Ext.tip.ToolTip', {
										target: 'treeExpand',
										id: 'iconTooltip',
										html: 'Expand all'
									});
								},
								'toggle':function(me, pressed, eOpts){
									if (!pressed)
									{
										var childNodeLength=Ext.getCmp("historysummary").getRootNode().childNodes.length;
										me.addCls('iconCollapseAll');
										me.removeCls('iconExpandAll');
										for(i=0;i<childNodeLength;i++)
										{
											Ext.getCmp("historysummary").getRootNode().childNodes[i].collapse();
										}
										Ext.getCmp('iconTooltip').update('Expand All');

									}
									else
									{
										me.addCls('iconExpandAll');
										me.removeCls('iconCollapseAll');
										Ext.getCmp("historysummary").getRootNode().expand(true); 
										Ext.getCmp('iconTooltip').update('Collapse All');
										var childNodeLength=Ext.getCmp("historysummary").getRootNode().childNodes.length;
										for(i=0;i<childNodeLength;i++)
										{
											try
											{
												var index = i;
												if(Ext.get("configRow"+index).isVisible())
												{
													Ext.get("configRow"+index).setVisibilityMode(Ext.Element.DISPLAY);
													Ext.get("configRow"+index).hide();
												}																								
											}
											catch (e)
											{
											}
										}
									}									
								}
							}
						},
						{
							xtype:'tbfill'
						},
						{
							//xtype:'textfield',
							/*xtype:'trigger',
							fieldLabel:'',
							style:{'margin-left': '-4px'},
							cls: 'whitedropdown_search',
							emptyText:'Search',
							dock:'top',
							enableKeyEvents: true,					
							name:'gridsearch',
							cls: 'whitedropdown_search',									
							labelWidth:50,
							padding:'5',					
							width:200,
							dock:'top',				
							id:'triggerId'*/
							
							xtype:'trigger',
							//fieldLabel:'',
							cls: 'whitedropdown_search',
							emptyText:descriptionSearch,
							id : 'triggerId',
							name : 'gridsearch',
							labelSeparator:'',
							labelAlign : 'left',
							margin : '5 5 5 10',
							enableKeyEvents: true,
							onTriggerClick: function() {
								var triggerId= Ext.getCmp('triggerId').getValue();
								var moreFiltersForm = Ext.getCmp('more-filter-options-panel').getForm();
									moreFiltersForm.findField('infosearch').setValue(triggerId);
								currentPageNo = 1;
								var disp = Ext.getCmp("displayInfo");
								var endInx = parseInt(pageCount)*parseInt(currentPageNo);
								var startInx = endInx- parseInt(pageCount);
								var msg = "Displaying "+(startInx+1)+"-"+endInx+" of "+recCount;
								disp.setText(msg);
								
								var first = Ext.getCmp("pfirst");
								var prev = Ext.getCmp("pprev");
								first.disabled=true;
								prev.disabled=true;
								if(parseInt(totalRecords)>currentPageNo)
								{
									var next = Ext.getCmp("pnext");
									var last = Ext.getCmp("plast");
									next.disabled=false;
									last.disabled=false;
								}
								history.app.getController("Main").showAlarms(history.app.getController("Main").getSubmitButton(),'','');
							}
						}]
					},
					{
						xtype : 'historysummary',                        						
						flex:.75,						
						margin:'0 10 10 10',
					},
					{
						xtype: 'panel',
						id:'errorpanel',
						name:'errorpanel',
						width: '100%',
						flex:.75,	
						hidden:true,
						html:'<table width="100%" height="300px"><tr><td align="center" valign="middle"><div class="iconNoalarms"></div>No Alarms found</td></tr></table>'
					}]
		});