Ext.define('insideViewDashboard.view.ConfigureThresholds', {
	extend:'Ext.window.Window',
	alias: 'widget.configurethresholds',
	width: 950,
	frame: true,
	title: pageName,
	modal: true,
	closable: true,
	closeAction: 'hide',
	resizable: false,
	draggable: true,
	id: 'configureThreshId',
	bodyBorder: true,
	bodyPadding: 10,
	padding: '4 10 10 10',
	autoScroll: true,
	scroll: true,
	items: [
		{
			xtype: 'component',
			autoEl: {id: 'testDescriptionId'},
			id: 'testDescriptionId',
			html: '',
			margin: '15 0 17 0'
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			flex: 1,
			margin: '5 5 0 5',
			items : [
				{
					xtype: 'fieldset',
					cls:'fieldset',
					title: '<b>'+minThreshText+'</b>',
					flex: 1,
					padding:'10 10 10 10',
					margin: 10,
					items: [
						{
							xtype: 'displayfield',
							id: 'minThreshDisplayField',
							fieldLabel: '&nbsp',
							value: minThreshTipText,
							labelAlign: 'top',
							labelSeparator: '',
							hideLabel: true,
							margin: '0 0 15 0',
							style: (!Ext.isIE6) ? 'opacity:.3' : '',
							disabled: true,
							flex: 1
						},
						{
							xtype: 'checkbox',
							cls: 'checkbt',
							id:'minStaticCheck',
							name:'minStaticCheck',
							fieldLabel: staticText,
							labelWidth: 80,
							labelSeparator: ' ',
							boxLabel: 'None',
							checked: true
						},
						{
							xtype: 'fieldcontainer',
							id:'minStaticFieldContainer',
							layout: 'hbox',
							defaultType: 'textfield',
							defaults: {
								labelAlign: 'top',
								labelSeparator: '',
								allowBlank: false
							},
							margin: '15 0 0 0',
							items: [
								{
									fieldLabel: criticalText,
									id:'absMinCritical',
									margin: '0 0 0 20',
									cls: 'textbox',
									flex: 1,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									value: '-'
								},
								{
									fieldLabel: majorText,
									id: 'absMinMajor',
									cls: 'textbox',
									margin: '0 0 0 10',
									flex: 1,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									value: '-'
								},
								{
									fieldLabel: minorText,
									id:'absMinMinor',
									cls: 'textbox',
									margin: '0 0 0 10',
									flex: 1,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									value: '-'
								}
							]
						},
						{
							xtype: 'checkbox',
							id: 'minAutoCheck',
							fieldLabel: autoText,
							labelWidth: 80,
							cls: 'checkbt',
							labelSeparator: ' ',
							boxLabel: 'None',
							checked: true,
							margin: '25 0 0 0'
						},
						{
							xtype: 'fieldcontainer',
							id: 'minAutoFieldContainer',
							layout: 'column',
							defaultType: 'slider',
							defaults: {
								labelAlign: 'top',
								labelSeparator: '',
								value: 0,
								minValue: 0,
								maxValue: 1000,
								tipText: function(thumb){
									return String(thumb.value) + '%';
								}
							},
							flex: 1,
							margin: '15 0 0 0',
							items: [
								{
									fieldLabel: autoCriText,
									id: 'relMinCritical',
									margin: '0 0 10 20',
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									columnWidth: 0.7,
									//plugins:['fillslider']
								},
								{
									xtype: 'displayfield',
									id: 'relMinCriticalText',
									fieldLabel: '',
									value: '0',
									margin: '0 0 0 20',
									columnWidth: 0.3,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true
								},
								{
									fieldLabel: autoMajorText,
									id: 'relMinMajor',
									margin: '10 0 10 20',
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									columnWidth: 0.7,
									//plugins:['fillslider']
								},
								{
									xtype: 'displayfield',
									id: 'relMinMajorText',
									fieldLabel: '',
									value: '0',
									margin: '10 0 0 20',
									columnWidth: 0.3,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true
								},
								{
									fieldLabel: autoMinorText,
									id: 'relMinMinor',
									margin: '10 0 10 20',
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									columnWidth: 0.7,
									//plugins:['fillslider']
								},
								{
									xtype: 'displayfield',
									id: 'relMinMinorText',
									fieldLabel: '',
									value: '0',
									margin: '10 0 0 20',
									columnWidth: 0.3,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true
								}
							]
						}
					]
				},
				{
					xtype: 'fieldset',
					cls:'fieldset',
					title: '<b>'+maxThreshText+'</b>',
					flex: 1,
					margin: 10,
					items: [
						{
							xtype: 'displayfield',
							id: 'maxThreshDisplayField',
							fieldLabel: '&nbsp',
							value: maxThreshTipText,
							labelAlign: 'top',
							labelSeparator: '',
							hideLabel: true,
							margin: '0 0 15 0',
							style: (!Ext.isIE6) ? 'opacity:.3' : '',
							disabled: true
						},
						{
							xtype: 'checkbox',
							cls: 'checkbt',
							id: 'maxStaticCheck',
							fieldLabel: staticText,
							labelWidth: 80,
							labelSeparator: ' ',
							boxLabel: 'None',
							checked: true
						},
						{
							xtype: 'fieldcontainer',
							layout: 'hbox',
							defaultType: 'textfield',
							defaults: {
								labelAlign: 'top',
								labelSeparator: '',
								allowBlank: false
							},
							margin: '15 0 0 0',
							items: [
								{
									fieldLabel: criticalText,
									id:'absMaxCritical',
									cls: 'textbox',
									margin: '0 0 0 20',
									flex: 1,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									value: '-'
								},
								{
									fieldLabel: majorText,
									id: 'absMaxMajor',
									cls: 'textbox',
									margin: '0 0 0 10',
									flex: 1,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									value: '-'
								},
								{
									fieldLabel: minorText,
									id: 'absMaxMinor',
									cls: 'textbox',
									margin: '0 0 0 10',
									flex: 1,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									value: '-'
								}
							]
						},
						{
							xtype: 'checkbox',
							id: 'maxAutoCheck',
							cls: 'checkbt',
							fieldLabel: autoText,
							labelWidth: 80,
							labelSeparator: ' ',
							boxLabel: 'None',
							checked: true,
							margin: '25 0 0 0'
						},
						{
							xtype: 'fieldcontainer',
							padding:'10 10 10 10',
							id: 'maxAutoFieldContainer',
							layout: 'column',
							defaultType: 'slider',
							defaults: {
								labelAlign: 'top',
								labelSeparator: '',
								value: 0,
								minValue: 0,
								maxValue: 1000,
								tipText: function(thumb){
									return String(thumb.value) + '%';
								}
							},
							margin: '15 0 0 0',
							flex: 1,
							items: [
								{
									fieldLabel: autoCriText,
									id: 'relMaxCritical',
									margin: '0 0 10 20',
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									columnWidth: 0.7,
									//plugins:['fillslider']
								},
								{
									xtype: 'displayfield',
									id: 'relMaxCriticalText',
									fieldLabel: '',
									value: '0',
									margin: '0 0 0 20',
									columnWidth: 0.3,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true
								},
								{
									fieldLabel: autoMajorText,
									id: 'relMaxMajor',
									margin: '10 0 10 20',
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									columnWidth: 0.7,
									//plugins:['fillslider']
								},
								{
									xtype: 'displayfield',
									id: 'relMaxMajorText',
									fieldLabel: '',
									value: '0',
									margin: '10 0 0 20',
									columnWidth: 0.3,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true
								},
								{
									fieldLabel: autoMinorText,
									id: 'relMaxMinor',
									margin: '10 0 10 20',
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true,
									columnWidth: 0.7,
									//plugins:['fillslider']
								},
								{
									xtype: 'displayfield',
									id: 'relMaxMinorText',
									fieldLabel: '',
									value: '0',
									margin: '10 0 0 20',
									columnWidth: 0.3,
									style: (!Ext.isIE6) ? 'opacity:.3' : '',
									disabled: true
								}
							]
						}
					]
				},
				{
					xtype: 'fieldset',
					cls:'fieldset',
					title: alarmPolText,
					flex: 1,
					margin: 10,
					items: [
						{
							xtype: 'scrollcombo',
							id: 'alarmPolicyCombo',
							fieldLabel: polText,
							width: 250,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode:'local',
							editable: false,
							store: new Ext.data.Store(
							{
								fields: ['displayField','valueField'],
								data: []
							}),
							labelAlign: 'top',
							labelSeparator: ' '
						},
						{
							xtype: 'displayfield',
							id:'alarmDispField',
							fieldLabel: descText,
							value: '',
							labelAlign: 'top',
							labelSeparator: '',
							margin: '15 0 0 0',
							style: (!Ext.isIE6) ? 'opacity:.3' : ''
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id:'allMeasureContainer',
			hidden:true,
			margin: '0 0 0 10',
			flex: 1,
			items: [
				{
					xtype: 'checkbox',
					cls: 'checkbt',
					id: 'allMeasureCheck',
					fieldLabel: '',
					labelWidth: 80,
					labelSeparator: ' ',
					boxLabel: 'Apply to other measures',
					checked: false,
				}
			]
		},
		{
			xtype: 'container',
			frame: true,
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'button',
					id: 'updateBtn',
					text: 'Update',
					cls:'button20',
					width: 80
				}
			]
		}
	]
});



