

Ext.define('insideViewDashboard.view.InsideViewDashboardTabPanel', {
	extend : 'Ext.panel.Panel',
	requires : [
			'insideViewDashboard.view.MeasuresData',
			'insideViewDashboard.view.SystemPanel',
			'insideViewDashboard.view.NetworkPanel',
			'utilities.ScrollPanel'
	],
	alias : 'widget.insideviewdashboardtabpanel',
	layout:'fit',
	frame:false,
	border:true,
	padding: 0,
	items:[
			{
				xtype:'tabpanel',
				autoScroll: false,
				scroll:false,
				//style:{'background-color':'#fff','background':'none'},
				flex:1,
				margin:0,
				layout: 'fit',
				padding: '0px 0px 0px 0px',
				plain: false,
				name:'insideViewtabpanelName',
				ui:'newTabPanelBasic',
				//cls: 'tablayout insideviewBg',
				border: false,
				frame: false,
				defaults:{
					border:true,
					frame:false
				},
				activeTab:requestParams.activeTabInx,
				items: [
					{
						
						id:'Measures',
						title: tabMeasure,
						//style:{'background-color':'#fff','background':'none','border':'0px !important'},
						flex:1,
						layout: 'fit',
						padding:0,
						margin:0,
						items: [{
							xtype: 'measuresdata',
							id:'measuredatapanel',
							//height:500,
							layout:{
									type:'vbox',
									align:'stretch'
								},
							margin:0,
							flex:1,
							autoScroll: true,
							scroll:false,
							//style:{border:'5px solid blue'},
							pageUrl : requestParams.measuresUrl,
							listeners:{
									resize:{
										fn:function()
										{
											var thisPanel=Ext.getCmp('measuredatapanel');
											//var width = '100%';
											//var height = Ext.getBody().getViewSize().height - 70;
											//console.log('height-->'+height);
											//thisPanel.setSize(width, height);
										}
									
									}
							
							}
						}]
					},{
						id:'System',
						title: tabSystem,
							layout:'fit',
						cls:'insidetabmeasure',
						//style:{'background-color':'#fff','background':'none','border':'0px !important'},
						items: [{
							xtype: 'systempanel',
							id:'sytempanel',
							
							layout:{
									type:'vbox',
									align:'stretch'
								},
							autoScroll: false,
							scroll:false,
							pageUrl : requestParams.systemUrl,

						}]
					},{
						id:'Network',
						title: tabNetwork,
						cls:'insidetabmeasure',
						//style:{'background-color':'#fff','background':'none','border':'0px !important'},
						items: [{
							xtype: 'networkpanel',
							id:'networkpanel',
							border:false,
							//height:600,
							flex:1,
							layout:{
									type:'vbox',
									align:'stretch'
								},
							autoScroll: false,
							scroll:false,
							pageUrl : requestParams.networkUrl,
							
						}]
				}],
				listeners:{
					'beforerender':function(thisObj){
						Ext.state.Manager.get('active_tab', thisObj.activeTab);
						//var tab = Ext.getCmp(thisObj.getActiveTab().id);
						//this.setActiveTab(tab);
						//Ext.state.Manager.set(tab, thisObj.getActiveTab().id);
					},
					'tabchange': function(tabObj,tab){
						var tab = Ext.getCmp(tabObj.getActiveTab().id);
						this.setActiveTab(tab);
						Ext.state.Manager.set(tab, tabObj.getActiveTab().id);
					},
					render:function(){
						var infoData = new Array();
						var infoDataValueRequest = requestParams.vmsCombo[0].value;
						var infoStates = requestParams.vmsCombo[0].selectedState;
						var labelWidth = requestParams.vmsCombo[0].labelWidth
						 var infoDataStore = Ext.create('Ext.data.Store',{
							data : infoDataValueRequest,
							fields:[{name:'name',convert:function(value, record){
								return Ext.String.htmlDecode(value);
							}},'value','state','icon']
						});
						var selectedIconClass = requestParams.vmsCombo[0].selectedIconClass;
						this.tabBar.add(
							{
								xtype:'tbfill'
							},{
								xtype: 'scrollcombo',
								fieldLabel:requestParams.vmsCombo[0].label,
								cls:'dropdown',
								labelSeparator:'',
								labelWidth:labelWidth+20,
								labelStyle: {'white-space':'nowrap;','font-size':'13px','font-weight':'normal'},
								name:requestParams.vmsCombo[0].name,
								id:requestParams.vmsCombo[0].name+'_insideViewCombo',
								labelAlign:'left',
								margin:"3px 20px 0px 0px",
								displayField : 'name',
								valueField : 'value',
								store : infoDataStore,
								editable:false,
								value:requestParams.vmsCombo[0].selected,
								width:500,
								listeners:{
									'render':function(){
										$('#'+requestParams.vmsCombo[0].name+'_insideViewCombo-inputEl').addClass('state_'+requestParams.vmsCombo[0].selectedState);
									},
								},
								changeselDispField:function(inputEl,cls){
									$('#'+inputEl+'-inputEl').removeClass('state_HIGH');	
									$('#'+inputEl+'-inputEl').removeClass('state_INTERMEDIATE');	
									$('#'+inputEl+'-inputEl').removeClass('state_LOW');	
									$('#'+inputEl+'-inputEl').removeClass('state_UNKNOWN');	
									$('#'+inputEl+'-inputEl').removeClass('state_GOOD');
									$('#'+inputEl+'-inputEl').addClass('state_'+cls);	
								},
								tpl: Ext.create('Ext.XTemplate',
									'<ul style="white-space:nowrap">',
										'<tpl for=".">',
											'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{name}</li>',
										'</tpl>',
									'</ul>'
								)
							},
							{
								id:'CompLayers',
								xtype: 'button',
								text : componentLayers,
								cls:'button20',
								width: 160,
								margin:'4 10 0 0',
								listeners: {
									click: function(){
										var infoVMCombo=requestParams.vmsCombo[0].selected;
										infoVMCombo=parent.filterEncode(infoVMCombo);
										window.location.href=requestParams.compLayersUrl+"&infoVMCombo="+encodeURI(infoVMCombo);
									}
								}
							},
							{
								id:'stateCon',
								xtype:'container',
								//margin:"6px 200px 0px 0px",
								hidden:true,
								//html:'<div class="vm_'+infoStates+'"></div>'
								html:'<div class="'+selectedIconClass+'"></div>'
							},{
								xtype:'commonbackbutton',
								margin:'5 5 0 0',
							}
						);
					}
				}
			}]
});
