Ext.define('kbsearch.controller.Main', {
    extend: 'Ext.app.Controller',
    requires:['kbsearch.view.Main'],
    views:['Main'],
    
    refs:[
		{
			ref:'main',
			selector:'main'
		},
		{
			ref:'problemTime',
			selector:'kbsearchmodify timelinemodify#problemTime'
		},
		{
			ref:'fixTime',
			selector:'kbsearchmodify timelinemodify#fixTime'
		},
		{
		ref:'tablePanel',
		selector:'kbsearchmain container[id=tableView]'
		}
		],
	dbStartDate:null,
	dbEndDate:null,
	hiddenValues:null,
	QueryStringURL:null,
	CSVData:null,
    init: function() {
		appcnt = this;
    	this.control({
					'main':{
						'boxready':this.loadform
					},
					'kbsearchtimeline':{
							'render':this.loadTimeLine
					},
					'kbsearchform combo[id="componentNameCombo"]':{
					'select':this.component_onchange
					},
					'kbsearchform combo[id="layerlist"]':{
					'select':this.layer_onchange
					},
					'kbsearchform combo[id="testlist"]':{
					'select':this.test_onchange
					},
					'kbsearchform combo[id="searchby"]':{
					'select':this.event_onchange
					},
					'kbsearchform combo[id="service"]':{
					'select':this.SubEvent_onchange
					},
					'kbsearchform combo[id="segment"]':{
					'select':this.SubEvent_onchange
					},
					'kbsearchform combo[id="zone"]':{
					'select':this.SubEvent_onchange
					},
					'kbsearchform combo[id="comptype"]':{
					'select':this.type_onchange
					},
					'kbsearchtimeline combo[id="eg_timeline"]':
					{
						'select' : this.changeTimeline
					},
					'kbsearchform button[id="submit"]':{
					'click':this.loadData
					},
					'kbsearchmodify':{
						'render':this.loadModify
					},
					'kbsearchmodify button[id="clearValue"]':{
						'click':this.clearModify
					},
					'kbsearchmodify button[id="saveValue"]':{
						'click':this.saveModify
					},
					'kbsearchmain button[id=saveCSV]':{
							'click':this.saveCSV
					}
				});
	},
	loadform:function(obj)
	{
		var form =null;
		if(Ext.isEmpty(obj.value))
			form = obj.down('form').getForm();
		else
			form = obj.up('form').getForm();

		Ext.getCmp('search').setValue('');
		Ext.getCmp('searchResult').setValue('');
		var searchByCombo = Ext.getCmp('searchBy');
		searchByCombo.setValue('3');

		this.setNotApplicable(form,'searchby',AllLbl);
		this.setNotApplicable(form,'comptype',AllLbl);
		this.setNotApplicable(form,'componentNameCombo',AllLbl);
		//this.setNotApplicable(form,'testlist','All');
		//this.setNotApplicable(form,'measurelist','All');
		this.setNotApplicable(form,'layerlist',AllLbl);
		this.setNotApplicable(form,'testlist',AllLbl);
		this.setNotApplicable(form,'measurelist',AllLbl);
		
		this.loadAnalysis(form);
		this.loadComponents(form);

		//var resultTable = "<table cellspacing='0' cellpadding='2' width='100%' align='center' border='0' height='300'> <tr> <td align='center' valign='middle' height='100%' width='100%' style='font-size:12px' ><div class='iconInformation'></div>No data Available</td> </tr> </table> ";
		var resultTable = "<table cellspacing='0' cellpadding='2' width='100%' align='center' border='0' height='100%'> <tr> <td align='center' valign='middle' height='100%' width='100%' style='font-size:12px'><div class='iconInformation'></div><div class='KbSerachError'>"+submitTxt+"</div></td> </tr> </table> ";
		Ext.getCmp('tableView').update(resultTable);
		//this.loadData();
	},
	loadAnalysis:function(form)
	{
		//Loading Analysis
		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getAnalysisByNew';
		var me = this;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.RemoteScriptingServlet',
			params : param,
			success : function(response) {
				var responseTextData=response.responseText;
				if(responseTextData!=null && responseTextData!=undefined && responseTextData!="")
				{
					var formdata = Ext.decode(responseTextData);
					componentsRawData = formdata.analysisBy;
					me.setComboOptionsInList(form, 'searchby', formdata,'Component');
				}
			},
			failure:function()
			{
				window.location.href = "/final/monitor/KBSearch.jsp";
			}
		});
		//Analysis Loading Ends
		//Loading Component Types,by default
		Ext.Ajax.request({
			url : '/final/monitor/KBSearchP.jsp?1=1',
			success : function(response) {
				var responseTextData=response.responseText;
				if(responseTextData!=null && responseTextData!=undefined && responseTextData!="")
				{
					var formdata = Ext.decode(responseTextData);
					componentsRawData = formdata;
					me.setComboOptionsInList(form, 'comptype', formdata,'All');
				}
			},
			failure:function()
			{
				window.location.href = "/final/monitor/KBSearch.jsp";
			}
		});
		//component loading ends
	},
	loadComponents:function(form)
	{
		Ext.getCmp('search').setValue('');
		Ext.getCmp('searchResult').setValue('');
		var searchByCombo = Ext.getCmp('searchBy');
		searchByCombo.setValue('3');
		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getUserComponents';
		var me = this;
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.RemoteScriptingServlet',
					params : param,
					success : function(response) {
						var formdata = Ext.decode(response.responseText);
						componentsRawData = formdata;
						var tempCompList = [];
						for(var i=0;i<componentsRawData.length;i++)
						{
							var tempCompDisplay = formdata[i].displayField;
							var tempCompReal = formdata[i].valueField;
							tempCompDisplay = tempCompDisplay.substring(tempCompDisplay.lastIndexOf(':')+1,tempCompDisplay.length);
							var tempElement = {'displayField':tempCompDisplay,'valueField':tempCompReal};
							tempCompList.push(tempElement);
						}
						me.setComboOptionsInList(form, 'componentNameCombo', formdata,
								'-1');
					},
					failure:function()
					{
						window.location.href = "/final/monitor/KBSearch.jsp";
					}
				});
	},
	
	component_onchange:function(compObj)
	{
		var val = compObj.getValue();
		var form = compObj.up('.form').getForm();
		var no_param = '&P0=' + val;
		var me = this;
		me.setComboOptionsInList(form, 'layerlist','','Loading..');
		this.doFilter('layerlist', form, 'getLayersForComponent', no_param,'-1');
		this.setNotApplicable(form,'testlist',AllLbl);
		this.setNotApplicable(form,'measurelist',AllLbl);
		Ext.getCmp('searchResult').setValue('');
		var searchByCombo = Ext.getCmp('searchBy');
		searchByCombo.setValue('3');
		//Ext.getCmp('search').setValue('');
	},
	layer_onchange : function(thisObj) {
		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();
		var hostName = form.findField('componentNameCombo').getValue();
		siteName = 'NULL';
		var hostName = form.findField('componentNameCombo').getValue();
		var me = this;
		me.setComboOptionsInList(form, 'testlist','','Loading..');

		var no_param = '&P0=' + siteName + '&P1=' + hostName + '&P2=' + val + '';

		this.doFilter('testlist', form, 'getTestsForGraph', no_param, '-1');
		this.setNotApplicable(form,'measurelist',AllLbl);
		Ext.getCmp('searchResult').setValue('');
		var searchByCombo = Ext.getCmp('searchBy');
		searchByCombo.setValue('3');

	},
	test_onchange : function(thisObj) {
		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();
		
		siteName = 'NULL';
		var hostName = form.findField('componentNameCombo').getValue();
		var layerName = form.findField('layerlist').getValue();
		var me = this;
		me.setComboOptionsInList(form, 'measurelist','','Loading..');
		val = val.substring(0, val.indexOf('-'));

		var no_param = '&P0=' + siteName + '&P1=' + hostName + '&P2=' + val + '';

		this.doFilter('measurelist', form, 'getMeasuresForGraph1', '&P0=' + encodeURIComponent(val) + '&P1=' + layerName + '&','-');
		if(form.findField('measurelist').getStore()!=null && form.findField('measurelist').getStore().length>0)
		{					
		form.findField('measurelist').getStore().getAt(0).get('valueField');
		}
		Ext.getCmp('searchResult').setValue('');
		var searchByCombo = Ext.getCmp('searchBy');
		searchByCombo.setValue('3');
	},
	doFilter:function(fieldname, form, method, no_param, val) 
	{
		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method='
				+ method + no_param;
		var me = this;
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.RemoteScriptingServlet',
					params : param,
					success : function(response) {
						var formdata = Ext.decode(response.responseText);
						me.setComboOptionsInList(form, fieldname,formdata, val);
					},
					failure:function()
					{
						window.location.href = "/final/monitor/KBSearch.jsp";
					}
				});
	},
	setComboOptionsInList : function(form, fieldName, list, value) 
	{
		if(fieldName!='zone')
		{
			if(!Ext.isEmpty(list[0]))
			{
				if(!Ext.isEmpty(list[0].displayField))
				{
					if(list[0].displayField.indexOf("Please choose") > -1)
					{
						list[0].displayField=AllLbl;
					}
				}
			}
		}
		else if(fieldName=="comptype")
		{
			var searchby = Ext.getCmp('searchby').value;
			if(!Ext.isEmpty(searchby) && searchby=='Component')
			{
				var add ={"displayField":AllLbl,"valueField":"All"};
				list.splice(0,0,add);
			}
		}
		else if(fieldName=="measurelist")
		{	var searchByCombo = Ext.getCmp('searchBy');
			searchByCombo.setValue('3');
			var add ={"displayField":AllLbl,"valueField":"All"};
			list.splice(0,0,add);
		}
		else if(fieldName=='componentNameCombo')
		{
			var totalCompList = [];
			
			for(var i=0;i<list.length;i++)
			{
				var displayField = list[i].displayField;
				var valueField = list[i].valueField;
				var state = list[i].state;
				if(displayField.indexOf(':')>-1)
				{
					displayField = displayField.substring(0,displayField.indexOf(':'));
					var tempCompName = {'displayField':displayField,'state':state,'valueField':valueField};
					totalCompList.push(tempCompName);
				}
			}
			if(totalCompList.length>0)
			{
				var add ={"displayField":AllLbl,"valueField":"All"};
				totalCompList.splice(0,0,add);
				list = totalCompList;
			}
		}
		else if(fieldName=='testlist')
		{
			var newList =[];
			for(var i=0;i<list.length;i++)
			{
				var displayField = list[i].displayField;
				var valueField = list[i].valueField;
				var previousDisplayField = null;
				if(i>0)
					previousDisplayField = list[i-1].displayField;
				var tempData =null;
				if(!Ext.isEmpty(displayField) && displayField.indexOf('(') > -1)
				{
					if(displayField==AllLbl)
					{
						tempData ={'valueField':valueField,'displayField':displayField}
					}
					else
					{
						//displayField = displayField.substring(displayField.indexOf('(')+1,displayField.length-1);
						if(i>0)
						{
							//previousDisplayField = previousDisplayField.substring(previousDisplayField.indexOf('(')+1,previousDisplayField.length-1);
							if(previousDisplayField==displayField)
								continue;
						}
						tempData ={'valueField':valueField,'displayField':displayField}
					}
					newList.push(tempData);
				}
			}
			if(newList.length>0)
			{
				newList.sort(function(a,b)
				{
					if(!Ext.isEmpty(a.displayField) && !Ext.isEmpty(a.displayField))
					{
						if (a.displayField < b.displayField)
							return -1;
						if (a.displayField > b.displayField)
							return 1;
					}
					return 0;
				});
				var add ={"displayField":AllLbl,"valueField":"All"};
				newList.splice(0,0,add);
				list = newList;
			}
		}
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		
		if(fieldName=='measurelist')
		{
			if(value.indexOf(",")>-1)
			{
				
				var meas=[];
				var tmp = value.split(',');
				for(var i=0;i<tmp.length;i++)
				{
					meas.push(tmp[i]);
				}
				form.findField(fieldName).setValue(meas);
			}
			else
			{
				if(value=='-')
                {
                    value = form.findField(fieldName).getStore().getAt(0).get('valueField');
                }
				form.findField(fieldName).setValue(value);
			}
		}
		else
		{
			if(value=='-')
            {
				if(form.findField(fieldName).getStore()!=null && form.findField(fieldName).getStore().length>0)
				{
                    value = form.findField(fieldName).getStore().getAt(1).get('valueField');
				}
			
            }
			form.findField(fieldName).setValue(value);
		}
		form.findField(fieldName).resumeEvents();
		try
		{
			var compObj = Ext.getCmp('componentNameCombo');
			var val = compObj.getValue();
			var store_data=compObj.getStore();
			for(var k=0;k<store_data.getCount();k++)
			{
				var cmp=store_data.data.items[k].data.valueField;
				if(cmp==val)
				{
					var state=store_data.data.items[k].data.state;
					compObj.changeselDispField('componentNameCombo',state);
					break;
				}
			}
		}
		catch (w)
		{
			//console.log("w-==-=->>",w)
		}
	},
	setNotApplicable : function(form, fieldname, option) {
		form.findField(fieldname).getStore().removeAll();
		form.findField(fieldname).getStore().loadRawData([{
					"displayField" : option,
					"valueField" : "All"
				}]);
		form.findField(fieldname).setValue("All");
	},
	event_onchange:function(obj)
	{
		Ext.getCmp('searchResult').setValue('');
		Ext.getCmp('search').setValue('');
		var searchByCombo = Ext.getCmp('searchBy');
		searchByCombo.setValue('3');
		var value = obj.getValue();
		var form = obj.up('form').getForm();
		var fieldname="";
		var param="event_onchange=true";
		if(!Ext.isEmpty(value))
		{
			param=param+'&eventSelection='+value;
			if(value=='Segment')
			{
				fieldname='segment';
				form.findField('segment').show();
				form.findField('service').hide();
				form.findField('zone').hide();
				form.findField('includesubzone').hide();
			}
			else if(value=='Service')
			{
				fieldname='service';
				form.findField('service').show();
				form.findField('segment').hide();
				form.findField('zone').hide();
				form.findField('includesubzone').hide();
			}
			else if(value=='Zone')
			{
				fieldname='zone';
				form.findField('segment').hide();
				form.findField('service').hide();
				form.findField('zone').show();
				form.findField('includesubzone').show();
			}
			else if(value=='Component')
			{
				form.findField('service').hide();
				form.findField('segment').hide();
				form.findField('zone').hide();
				form.findField('includesubzone').hide();
				this.loadform(obj);
			}
			if(value!='Component')
			{
				var me = this;
				me.setComboOptionsInList(form, 'comptype','', 'Loading...');
				Ext.Ajax.request({
					url : '/final/monitor/KBSearchP.jsp?'+param,
					//params : param,
					success : function(response) {
						var formdata = Ext.decode(response.responseText);
						if(!Ext.isEmpty(formdata))
						{
							if(value!='Zone')
							{
								me.setComboOptionsInList(form, fieldname,formdata.analysisObject, 'All');
								me.setComboOptionsInList(form, 'comptype',formdata.typesObject, 'All');
								me.setComboOptionsInList(form, 'componentNameCombo',formdata.serversObject, 'All');
							}
							else
							{
								me.setComboOptionsInList(form, fieldname,formdata.Zone, 'All');
								me.setComboOptionsInList(form, 'includesubzone',formdata.IncludeSubZone, 'Yes');
								me.setComboOptionsInList(form, 'comptype',formdata.typesObject, 'All');
								me.setComboOptionsInList(form, 'componentNameCombo',formdata.serversObject, 'All');
							}
						}
					},
					failure:function()
					{
						window.location.href = "/final/monitor/KBSearch.jsp";
					}
				});
			}
		}
	},
	SubEvent_onchange:function(obj)
	{
		Ext.getCmp('searchResult').setValue('');
		Ext.getCmp('search').setValue('');
		var searchByCombo = Ext.getCmp('searchBy');
		searchByCombo.setValue('3');
		var value = obj.getValue();
		var form = obj.up('form').getForm();
		var fieldname="";
		var param="event_onchange=true";
		var eventSelection = Ext.getCmp('searchby').value;
		if(!Ext.isEmpty(value) && !Ext.isEmpty(eventSelection))
		{
			param=param+'&subEventSelection='+encodeURI(value)+"&eventSelection="+eventSelection;
			var me = this;
				Ext.Ajax.request({
					url : '/final/monitor/KBSearchP.jsp?'+param,
					//params : param,
					success : function(response) {
					var formdata = Ext.decode(response.responseText);
					if(!Ext.isEmpty(formdata))
					{
						if(value!='Zone')
						{
							//me.setComboOptionsInList(form, fieldname,formdata.analysisObject, 'All');
							me.setComboOptionsInList(form, 'comptype',formdata.typesObject, 'All');
							me.setComboOptionsInList(form, 'componentNameCombo',formdata.serversObject, 'All');
						}
						else
						{
							//me.setComboOptionsInList(form, fieldname,formdata.Zone, 'All');
							//me.setComboOptionsInList(form, 'includesubzone',formdata.IncludeSubZone, 'Yes');
							me.setComboOptionsInList(form, 'comptype',formdata.typesObject, 'All');
							me.setComboOptionsInList(form, 'componentNameCombo',formdata.serversObject, 'All');
						}
					}
				},
				failure:function()
				{
					window.location.href = "/final/monitor/KBSearch.jsp";
				}
			});
		}
	},
	type_onchange:function(obj)
	{
		var tempAnalysis = Ext.getCmp('searchby').value;
		var searchByCombo = Ext.getCmp('searchBy');
		searchByCombo.setValue('3');
		var tempCompType = Ext.getCmp('comptype').rawValue;
		if(!Ext.isEmpty(tempAnalysis) && tempAnalysis=='Component')
		{
			var selected_component_type = Ext.getCmp('comptype').value;
			var form = obj.up('form').getForm();
			var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getUserComponents';
			var me = this;
			var tempCompList = [];
			me.setComboOptionsInList(form, 'componentNameCombo','','Loading..');
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.RemoteScriptingServlet',
						params : param,
						success : function(response) {
							var formdata = Ext.decode(response.responseText);
							componentsRawData = formdata;
							if(!Ext.isEmpty(selected_component_type) && selected_component_type!='All')
							{
								var newFormData = [];
								for(var temp = 0;temp<componentsRawData.length;temp++)
								{
									var this_component = componentsRawData[temp].valueField;
									var this_component_type = this_component.substring(this_component.lastIndexOf(':')+1);
									if(selected_component_type==this_component_type)
									{
										var this_component_display = componentsRawData[temp].displayField;
										var this_component_state = componentsRawData[temp].state;
										this_component_display = this_component_display.substring(0,this_component_display.indexOf(':'));
										var compElement = {"displayField":this_component_display,"state":this_component_state,"valueField":this_component};
										newFormData.push(compElement);
									}
								}
								var add ={"displayField":AllLbl,"valueField":"All"};
								newFormData.splice(0,0,add);
								me.setComboOptionsInList(form, 'componentNameCombo', newFormData,'All');
							}
							else
							{
								me.setComboOptionsInList(form, 'componentNameCombo', formdata,'All');
							}
						},
						failure:function()
						{
							window.location.href = "/final/monitor/KBSearch.jsp";
						}
					});
		}
		else
		{
			var value = obj.getValue();
			var form = obj.up('form').getForm();
			var fieldname="";
			var param="event_onchange=true";
			var eventSelection = Ext.getCmp('searchby').value;
			var idValue =null;
			if(!Ext.isEmpty(eventSelection))
			{
				if(eventSelection=='Service')
				{
					idValue = 'service' ;
				}
				else if(eventSelection=='Segment')
				{
					idValue = 'segment';
				}
				else if(eventSelection=='Zone')
				{
					idValue = 'zone';
				}
			}
			var subEventSelection = Ext.getCmp(idValue).value;
			if(!Ext.isEmpty(value) && !Ext.isEmpty(eventSelection))
			{
				param=param+'&subEventSelection='+encodeURI(subEventSelection)+'&eventSelection='+eventSelection+'&typeList='+value;
				var me = this;
					Ext.Ajax.request({
						url : '/final/monitor/KBSearchP.jsp?'+param,
						success : function(response) {
						var formdata = Ext.decode(response.responseText);
						if(!Ext.isEmpty(formdata))
						{
							if(value!='Zone')
							{
								me.setComboOptionsInList(form, 'componentNameCombo',formdata.serversObject, 'All');
							}
							else
							{
								me.setComboOptionsInList(form, 'componentNameCombo',formdata.serversObject, 'All');
							}
						}
					},
					failure:function()
					{
						window.location.href = "/final/monitor/KBSearch.jsp";
					}
				});
			}
		}
		Ext.getCmp('search').setValue('');
		Ext.getCmp('searchResult').setValue('');
		this.setNotApplicable(form,'layerlist',AllLbl);
		this.setNotApplicable(form,'testlist',AllLbl);
		this.setNotApplicable(form,'measurelist',AllLbl);
	},
	search_onchange:function(obj)
	{
		Ext.getCmp('searchResult').setValue('');
		var searchByCombo = Ext.getCmp('searchBy');
		searchByCombo.setValue('3');
		var matchedValue = obj.getValue();
		var form = obj.up('form').getForm();
		if(!Ext.isEmpty(matchedValue))
		{
			matchedValue = matchedValue.trim();
			if(matchedValue.length==0)
			{
				this.loadComponents(form);
			}
			else
			{
				if(matchedValue!=null)
				{
					matchedValue = matchedValue.toLowerCase();
				}

				var compNames = Ext.getCmp("componentNameCombo").getStore().data.items;
				var resultValue = [];
				for(var i=0;i<compNames.length;i++)
				{
					var display = compNames[i].data.displayField;
					var displayVal = "";
					if(display!=null)
					{
						displayVal = compNames[i].data.displayField.toLowerCase();
					}

					if(displayVal.indexOf("please") > -1)
						continue;
					var value = null;
					var state = null;
					if(!Ext.isEmpty(displayVal))
					{
						if(displayVal.indexOf(matchedValue) > -1)
						{
							value = compNames[i].data.valueField;
							state = compNames[i].data.state;
							var matchedField = {"displayField":display,"state":state,"valueField":value};
							resultValue.push(matchedField);
						}
					}
				}
				if(resultValue.length > 0)
				{
				//	if(resultValue.length == compNames.length-1)
				//		resultValue = compNames;
					this.setComboOptionsInList(form, 'componentNameCombo', resultValue,resultValue[0].valueField);
				}
				else
				{
					this.setComboOptionsInList(form, 'componentNameCombo', '','');
					Ext.getCmp('componentNameCombo').setValue('No matching Found');

				}
			}
		}
		else
		{
			this.loadComponents(form);
		}
	},
	loadTimeLine:function(obj)
	{
		form = obj.up('form').getForm();
		var me = this;
		//params = form.findField('eg_timeline').getValue();
		Ext.Ajax.request({
			url : '/final/monitor/EgTimeSelect.jsp',
			success : function(response) {
				var formdata = Ext.decode(response.responseText);
			
			if(form.findField('starthr').setValue(formdata.hiddenFields.org_starthr)!=null)
				var new_org_starthr = parseInt(formdata.hiddenFields.org_starthr);

			if(form.findField('startmin').setValue(formdata.hiddenFields.org_starthr)!=null)
				var new_startmin = parseInt(formdata.hiddenFields.startmin);
			
			if(form.findField('endhr').setValue(formdata.hiddenFields.org_starthr)!=null)
				var new_org_endhr = parseInt(formdata.hiddenFields.org_endhr);
			
			if(form.findField('endmin').setValue(formdata.hiddenFields.endmin)!=null)
				var new_endmin = parseInt(formdata.hiddenFields.endmin);

				form.findField('eg_timeline').getStore().loadRawData(formdata.timeLine);
				form.findField('eg_timeline').setValue(formdata.selectedTimeLine);
				form.findField('eg_timeline').suspendEvents(false);
				form.findField('eg_timeline').resumeEvents();
				
				form.findField('eg_stdate').setValue(formdata.startTime);
				//form.findField('eg_stdate').setValue(new Date());
				form.findField('starthr').getStore().loadRawData(formdata.startHr);
				form.findField('starthr').setValue(new_org_starthr);
				//form.findField('starthr').setValue(formdata.hiddenFields.starthr_h);
				form.findField('starthr').suspendEvents(false);
				form.findField('starthr').resumeEvents();


				form.findField('startmin').getStore().loadRawData(formdata.startMin);
				form.findField('startmin').setValue(new_startmin);
				//form.findField('starthr').setValue(formdata.hiddenFields.starthr_h);
				form.findField('startmin').suspendEvents(false);
				form.findField('startmin').resumeEvents();

				form.findField('eg_enddate').setValue(formdata.endtime);
				//form.findField('eg_enddate').setValue(new Date());
				form.findField('endhr').getStore().loadRawData(formdata.endHr);
				form.findField('endhr').setValue(new_org_endhr);
				//form.findField('endhr').setValue(formdata.hiddenFields.endhr_h);
				form.findField('endhr').suspendEvents(false);
				form.findField('endhr').resumeEvents();

				form.findField('endmin').getStore().loadRawData(formdata.endMin);
				form.findField('endmin').setValue(new_endmin);
				//form.findField('endhr').setValue(formdata.hiddenFields.endhr_h);
				form.findField('endmin').suspendEvents(false);
				form.findField('endmin').resumeEvents();


				me.dbStartDate = formdata.hiddenFields.dbstrtdate;
				me.dbEndDate = formdata.hiddenFields.dbenddate;
			},
			failure:function()
			{
				window.location.href = "/final/monitor/KBSearch.jsp";
			}
		});
	},
	changeTimeline : function(obj) {
		var getTimelineVal = Ext.getCmp('eg_timeline').getValue();
		var stDateObj = Ext.getCmp('eg_stdate');
		var endDateObj = Ext.getCmp('eg_enddate');
		var stHrObj = Ext.getCmp('starthr');
		var endHrObj = Ext.getCmp('endhr');
		var stMinObj = Ext.getCmp('startmin');
		var endMinObj = Ext.getCmp('endmin');

		if (getTimelineVal == 'Any') {
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
			stMinObj.setDisabled(false);
			endMinObj.setDisabled(false);

		} else {
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
			stMinObj.setDisabled(true);
			endMinObj.setDisabled(true);

		}
		if(getTimelineVal!='Any')
		{
    		var strtdt = Ext.Date.dateFormat(stDateObj.getValue(), mgrDateFormat);
    		var enddt = Ext.Date.dateFormat(endDateObj.getValue(), mgrDateFormat);
    		if (!Ext.isEmpty(obj)) {
    			var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getTime&P0='
    					+ getTimelineVal
    					+ '&P1='
    					+ encodeURIComponent(strtdt)
    					+ '&P2='
    					+ encodeURIComponent(enddt)
    					+ '&P3='
    					+ stHrObj.getValue()
    					+ '&P4='
    					+ endHrObj.getValue()
    					+ '&P5=' + encodeURIComponent(currentDateFormat);
    			var me = this;
    			Ext.Ajax.request({
					url : '/final/servlet/com.eg.RemoteScriptingServlet',
					params : param,
					success : function(response) {
					var formdata = Ext.decode(response.responseText);

					/*stDateObj.setValue(formdata[0]);
					endDateObj.setValue(formdata[1]);
					stHrObj.setValue(formdata[2]);
					endHrObj.setValue(formdata[3]);
					*/

					stDateObj.dataArray = formdata[0];
					endDateObj.dataArray = formdata[1];
					stHrObj.dataArray = formdata[2];
					endHrObj.dataArray = formdata[3];
					stMinObj.dataArray = formdata[4];
					endMinObj.dataArray = formdata[5];
				
					if(stHrObj.setValue(formdata[8]) != null)
						var st_HrObj=parseInt(formdata[8]);

					if(endHrObj.setValue(formdata[9]) != null)
						var end_HrObj=parseInt(formdata[9]);

					if(stMinObj.setValue(formdata[10]) != null)
						var st_MinObj=parseInt(formdata[10]);

					if(endMinObj.setValue(formdata[11]) != null)
						var end_MinObj=parseInt(formdata[11]);

				
					stDateObj.setValue(formdata[6]);
					endDateObj.setValue(formdata[7]);
					stHrObj.setValue(st_HrObj);
					endHrObj.setValue(end_HrObj);
					stMinObj.setValue(st_MinObj);
					endMinObj.setValue(end_MinObj);
					
					//params = form.findField('eg_timeline').getValue();
					//alert(params);
					Ext.Ajax.request({
						url : '/final/monitor/EgTimeSelect.jsp?time_line='+getTimelineVal,
						success : function(response) {
							var formdata = Ext.decode(response.responseText);
							me.dbStartDate = formdata.hiddenFields.dbstrtdate;
							me.dbEndDate = formdata.hiddenFields.dbenddate;
						},
						failure:function()
						{
							window.location.href = "/final/monitor/KBSearch.jsp";
						}
					});
					},
					failure:function()
					{
						window.location.href = "/final/monitor/KBSearch.jsp";
					}
				});
    			}
		}
	},
	loadData:function()
	{
		
		if(Ext.getCmp('configModx').toggled){
			Ext.get("configModx").animate({
                            duration: 500,
                            to: {
                                y: -350
                            },
							listeners: { 
								afteranimate: function () {  
									Ext.getCmp('configModx').toggled = false;
								} 
							}
                        });
		}
		
		var settingsPanel = Ext.getCmp('kbsearchsettings');
		var QueryString = this.genQueryString();
		this.QueryStringURL = QueryString;
		var params = QueryString;
		var mask =this.getTablePanel();
		mask.setLoading(true,true);
		var me =this;
		Ext.Ajax.request({
			url : '/final/monitor/KBSearchData.jsp?'+params,
			success : function(response) {
				var formdata = Ext.decode(response.responseText);
				me.CSVData = formdata.dataSize;
				Ext.getCmp('tableView').update(formdata.tableData);
			},
			failure:function()
			{
				window.location.href = "/final/monitor/KBSearch.jsp";
			}
		});
		mask.setLoading(false);
	},
	genQueryString:function()
	{
		var all = 'spec';
		var searchBy = Ext.getCmp('searchby').value;
		var compNameList = Ext.getCmp('componentNameCombo').value;
		if(!Ext.isEmpty(compNameList) && compNameList!='undefined' && (compNameList=="All" || compNameList=="-1") || compNameList.indexOf('Please choose') > -1)
			compNameList = "ALL";
		var test = Ext.getCmp('testlist').value;
		if(!Ext.isEmpty(test) && (test=="All" || test=="-1"))
			test = "ALL";
		var layerList = Ext.getCmp('layerlist').value;
		if(!Ext.isEmpty(layerList) && (layerList=="All" || layerList=="-1"))
			layerList = "ALL";
		var meas = Ext.getCmp('measurelist').value;
		if(!Ext.isEmpty(meas) && (meas=="All" || meas=="-1"))
			meas = "ALL";
		
		var time_line = Ext.getCmp('eg_timeline').value;
		var start_time = Ext.getCmp('eg_stdate').value;
		var end_time = Ext.getCmp('eg_enddate').value;
		var start_hr = Ext.getCmp('starthr').value;
		var end_hr = Ext.getCmp('endhr').value;
		var usermin = Ext.getCmp('startmin').value;
		var userendmin = Ext.getCmp('endmin').value;

		if(time_line!='Any')
		{
			start_time = Ext.Date.format(start_time, currentDateFormat_JS);
			end_time = Ext.Date.format(end_time, currentDateFormat_JS);
			start_hr = Ext.getCmp('starthr').dataArray;
			end_hr = Ext.getCmp('endhr').dataArray;
		
			if(start_hr==null || start_hr=='null')
				start_hr = Ext.getCmp('starthr').getValue();

			if(end_hr==null || end_hr=='null')
				end_hr = Ext.getCmp('endhr').getValue();
		}
		else if(time_line=='Any')
		{
			var tempStartTime =  Ext.Date.format(start_time,'m/d/Y');
			var tempEndTime = Ext.Date.format(end_time,'m/d/Y');
			start_time = Ext.Date.format(start_time, mgrDateFormat);
			end_time = Ext.Date.format(end_time, mgrDateFormat);
			if(new Date(tempStartTime) > new Date(tempEndTime))
			{
				Ext.MessageBox.show({
				title: 'Alert',
				msg: "Start date should be lesser than end date",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var ct_event = Ext.getCmp('comptype').value;
		if(!Ext.isEmpty(ct_event) && (ct_event=="All" || ct_event=="-1"))
			ct_event = "ALL";
		var searchResult = Ext.getCmp('searchResult').value;

		var dbstrtdate = this.dbStartDate;
		var dbenddate = this.dbEndDate;

		var v_event=searchBy;
		var event=v_event;
		var subevent="ALL";
		var site=null;
		var selectedsubzone=null;
		var complayer = null;
		if(!Ext.isEmpty(v_event) && v_event!='Component')
		{
			if(v_event=='Segment')
			{
				subevent = Ext.getCmp('segment').value;
				if(subevent=='All')
					subevent = 'ALL';
			}
			if(v_event=='Service')
			{
				subevent = Ext.getCmp('service').value;
				if(subevent=='All')
					subevent = 'ALL';
				site=subevent;
			}
			if(v_event=='Zone')
			{
				subevent = Ext.getCmp('zone').value;
				if(subevent=='All')
					subevent = 'ALL';
				selectedsubzone='Yes';
			}
		}

		if(Ext.isEmpty(search))
		{
			search = "";
		}
		if(!Ext.isEmpty(searchBy) && !Ext.isEmpty(ct_event) && !Ext.isEmpty(compNameList))
		{
			//if(ct_event=='ALL' && compNameList=='ALL' && searchBy=='Component')
			if(compNameList=='ALL' && searchBy=='Component')
				all ="ALL";
		}
		if(!Ext.isEmpty(layerList))
		{
			if(layerList!='ALL')
			{
				if(test!='ALL')
				{
					all ="spec";
					test = test.substring(0,test.indexOf('-'));
				}
				else
				{
					all ="Layspec";
					complayer='complayer';
				}
			}
		}
		
		if(!Ext.isEmpty(compNameList) && compNameList!='ALL')
		{
			var index = compNameList.lastIndexOf(':');
			var tempCompName = compNameList.substring(0,index);
			var tempCompType = compNameList.substring(index+1,compNameList.length);
			compNameList = tempCompType + ":" + tempCompName;
		}
		var params ="";
		if(Ext.isEmpty(searchResult))
		{
			if(v_event=='Component')
			{
				params = "all="+all+"&compNameList="+encodeURI(compNameList)+"&test="+test+"&layerList="+layerList+"&meas="+meas+"&time_line="+time_line+"&start_time="+start_time+"&end_time="+end_time+"&start_hr="+start_hr+"&end_hr="+end_hr+"&usermin="+usermin+"&userendmin="+userendmin+"&dbstrtdate="+dbstrtdate+"&dbenddate="+dbenddate+"&ct_event="+ct_event+"&isSubmitted=true&subevent="+encodeURI(subevent)+"&event="+event+"&site="+site+"&v_event="+v_event+"&selectedsubzone="+selectedsubzone;
			}
			else
			{
				var tempCompNameList = Ext.getCmp('componentNameCombo');
				var compNameListLength = null;
				if(!Ext.isEmpty(tempCompNameList.getStore().data.items))
					compNameListLength = tempCompNameList.getStore().data.items.length;
				if(!Ext.isEmpty(compNameListLength) && compNameListLength==2)
					compNameList = tempCompNameList.getStore().data.items[1].data.valueField;

				if(compNameList!='ALL')
				{
					var index = compNameList.lastIndexOf(':');
					var tempCompName = compNameList.substring(0,index);
					var tempCompType = compNameList.substring(index+1,compNameList.length);
					compNameList = tempCompType + ":" + tempCompName;
				}
				if(subevent=='ALL' && compNameList=='ALL')
				{
					if(v_event=='Segment')
					{
						params = "seg=Seg";
					}
					else if(v_event=='Service')
					{
						params = "serv=Serv";
					}
					else if(v_event=='Zone')
					{
						params = "zon=zon";
					}
				}
				else
				{
					params = "all="+all;
				}
				params = params +"&compNameList="+encodeURI(compNameList)+"&test="+test+"&layerList="+layerList+"&meas="+meas+"&time_line="+time_line+"&start_time="+start_time+"&end_time="+end_time+"&start_hr="+start_hr+"&end_hr="+end_hr+"&usermin="+usermin+"&userendmin="+userendmin+"&dbstrtdate="+dbstrtdate+"&dbenddate="+dbenddate+"&ct_event="+ct_event+"&isSubmitted=true&subevent="+encodeURI(subevent)+"&event="+event+"&site="+site+"&v_event="+v_event+"&selectedsubzone="+selectedsubzone;
			}

			if(!Ext.isEmpty(complayer))
				params = params + "&complayer="+complayer;
		}
		else
		{
			var tempCompNameList = Ext.getCmp('componentNameCombo');
			var compNameListLength = null;
			if(!Ext.isEmpty(tempCompNameList.getStore().data.items))
				compNameListLength = tempCompNameList.getStore().data.items.length;
			if(!Ext.isEmpty(compNameListLength) && compNameListLength==2)
				compNameList = tempCompNameList.getStore().data.items[1].data.valueField;

			if(compNameList!='ALL')
			{
				if(v_event!='Component')
				{
					var index = compNameList.lastIndexOf(':');
					var tempCompName = compNameList.substring(0,index);
					var tempCompType = compNameList.substring(index+1,compNameList.length);
					//alert(tempCompType);
					//alert(tempCompName);
					compNameList = tempCompType + ":" + tempCompName;
				}
				else
				{
					var index = compNameList.lastIndexOf(':');
					var tempCompName = compNameList.substring(0,index);
					compNameList = tempCompName;
				}
			}
	
			params = "compNameList="+encodeURI(compNameList)+"&test="+test+"&meas="+meas+"&time_line="+time_line+"&start_time="+start_time+"&end_time="+end_time+"&start_hr="+start_hr+"&end_hr="+end_hr+"&usermin="+usermin+"&userendmin="+userendmin+"&dbstrtdate="+dbstrtdate+"&dbenddate="+dbenddate+"&ct_event="+ct_event+"&isSubmitted=true&subevent="+encodeURI(subevent)+"&event="+event+"&site="+site+"&v_event="+v_event+"&selectedsubzone="+selectedsubzone;

			params = params+"&selectString="+searchResult;
			var searchByCombo = Ext.getCmp('searchBy').value;
			var fixed = null;
			var reason = null;
			var searchAll =null;
			if(searchByCombo=='1')
			{
				reason='reason';
			}
			else if(searchByCombo=='2')
			{
				fixed = 'fixed';
			}
			else
			{
				searchAll = 'searchAll';
			}
			//if(compNameList=='ALL')
				params = params+"&reason="+reason+"&fixed="+fixed+"&searchAll="+searchAll;
			//else
			   // params = params+"&reason="+reason+"&fixed="+fixed;
		}
		return params;
	},
	loadModify:function()
	{
		var me = this;
		var params = Ext.getCmp("modify").parameter;
		Ext.Ajax.request({
		url : '/final/monitor/KBModify.jsp?Count='+params,
		success : function(response) {
			var formdata = Ext.decode(response.responseText);
			me.hiddenValues = formdata.hiddenFields;
			var table = new Ext.XTemplate(
					'<div class="x-table">', 
					'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">', 
						'<thead>', 
							'<tr class="x-grid-row">', 
								'<th class=" x-grid-cell x-grid-cell-first">', 
									'<div class="x-grid-cell-inner">Comp Type</div>', 
								'</th>', 
								'<th class=" x-grid-cell">', 
									'<div class="x-grid-cell-inner">Comp Name</div>', 
								'</th>', 
								'<th class=" x-grid-cell" >', 
									'<div class="x-grid-cell-inner">Test</div>', 
								'</th>', 
								'<th class=" x-grid-cell" >', 
									'<div class="x-grid-cell-inner">Descriptor</div>', 
								'</th>', 
									'<th class=" x-grid-cell" >', 
									'<div class="x-grid-cell-inner">Measure</div>', 
								'</th>', 
							'</tr>', 
						'</thead>', 
					'<tbody>', 
						'<tr class="x-grid-row">', 
							'<td class=" x-grid-cell x-grid-cell-first kbmodify_zero">', 
								'<div class="x-grid-cell-inner" >'+formdata.headerFields.compType+'</div>', 
							'</td>', 
							'<td class=" x-grid-cell">', 
								'<div class="x-grid-cell-inner" >'+formdata.headerFields.comp+'</div>', 
							'</td>', 
							'<td class="x-grid-cell" >', 
								'<div  class="x-grid-cell-inner" >'+formdata.headerFields.test+'</div>', 
							'</td>', 
							'<td class="x-grid-cell" >', 
								'<div  class="x-grid-cell-inner" >'+formdata.headerFields.info+'</div>', 
							'</td>', 
							'<td class="x-grid-cell" >', 
								'<div  class="x-grid-cell-inner" >'+formdata.headerFields.measure+'</div>', 
							'</td>', 
						'</tr>', 
					'</tbody>', 
					'</table>', 
					'</div>'
			);
			Ext.getCmp('titleHeader').update(table);
			Ext.getCmp('problemreason').setValue(formdata.dataFields.probreason);
			Ext.getCmp('problemFix').setValue(formdata.dataFields.fixreason);
			Ext.getCmp('fixedBy').setValue(formdata.dataFields.fixby);
			var problemTime = me.getProblemTime().items.items;
			var fixTime = me.getFixTime().items.items;
			for(var i = 0;i<problemTime.length;i++)
			{
				if(i==0)
				{
					problemTime[i].setValue(formdata.dataFields.prob_time);
				}
				if(i==1)
				{
					if(!Ext.isEmpty(problemTime[i].getStore()))
					{
						problemTime[i].suspendEvents(false);
						problemTime[i].getStore().loadRawData(formdata.dataFields.problemHrCombo);
						problemTime[i].setValue(formdata.selectedProblemHr);
						problemTime[i].resumeEvents();
					}
				}
				if(i==2)
				{
					if(!Ext.isEmpty(problemTime[i].getStore()))
					{
						problemTime[i].suspendEvents(false);
						problemTime[i].getStore().loadRawData(formdata.dataFields.problemMinCombo);
						problemTime[i].setValue(formdata.selectedProblemMin);
						problemTime[i].resumeEvents();
					}
				}
			}
			for(var i = 0;i<fixTime.length;i++)
			{
				if(i==0)
				{
					fixTime[i].setValue(formdata.dataFields.fix_time);
				}
				if(i==1)
				{
					if(!Ext.isEmpty(fixTime[i].getStore()))
					{
						fixTime[i].suspendEvents(false);
						fixTime[i].getStore().loadRawData(formdata.dataFields.fixHrCombo);
						fixTime[i].setValue(formdata.selectedFixHr);
						fixTime[i].resumeEvents();
					}
				}
				if(i==2)
				{
					if(!Ext.isEmpty(fixTime[i].getStore()))
					{
						fixTime[i].suspendEvents(false);
						fixTime[i].getStore().loadRawData(formdata.dataFields.fixMinCombo);
						fixTime[i].setValue(formdata.selectedFixMin);
						fixTime[i].resumeEvents();
					}
				}
			}
		},
		failure:function()
		{
			window.location.href = "/final/monitor/KBSearch.jsp";
		}
		});
	},
	clearModify:function()
	{
		Ext.getCmp('problemreason').setValue("");
		Ext.getCmp('problemFix').setValue("");
	},
	saveModify:function()
	{
		var QueryURL="";
		var problemTime = this.getProblemTime().items.items;

		var msmttime = problemTime[0].getValue();
		msmttime = Ext.Date.format(msmttime, mgrDateFormat);
		QueryURL = QueryURL+"&msmttime="+msmttime;

		var msmthr = problemTime[1].getValue();
		QueryURL = QueryURL+"&msmthr="+msmthr;

		var msmtmin = problemTime[2].getValue();
		QueryURL = QueryURL+"&msmtmin="+msmtmin;

		var fixTime = this.getFixTime().items.items;
		var fixtime = fixTime[0].getValue();
		fixtime = Ext.Date.format(fixtime, mgrDateFormat);
		QueryURL = QueryURL+"&fixtime="+fixtime;

		var fixhr = fixTime[1].getValue();
		QueryURL = QueryURL+"&fixhr="+fixhr;

		var fixmin = fixTime[2].getValue();
		QueryURL = QueryURL+"&fixmin="+fixmin;

		var prob_reason = Ext.getCmp('problemreason').getValue();
		QueryURL = QueryURL+"&prob_reason="+encodeURI(prob_reason);

		var fix_reason = Ext.getCmp('problemFix').getValue();
		QueryURL = QueryURL+"&fix_reason="+encodeURI(fix_reason);

		var fixby = Ext.getCmp('fixedBy').getValue();
		var fixBackEndName = this.hiddenValues.fixby;
		QueryURL = QueryURL+"&fixby="+encodeURI(fixBackEndName);

		var componemt = this.hiddenValues.comp;
		QueryURL = QueryURL+"&componemt="+encodeURI(componemt);
		var compType = this.hiddenValues.modifyCompType;
		if(compType!=null && compType!='undefined')
			QueryURL = QueryURL+"&compType="+encodeURI(compType);

		var test = this.hiddenValues.test;
		QueryURL = QueryURL+"&test="+test;

		var measure = this.hiddenValues.measure;
		QueryURL = QueryURL+"&measure="+measure;

		var info = this.hiddenValues.info;
		if(info!=null && info!='undefined' && info !='')
		{
			if(info.indexOf("+") != -1)
			{
				do
				{
					info=info.replace('+','|plus|');
				}
				while (info.indexOf("+")>-1);
			}
			if(info.indexOf("%") != -1)
			{
				do
				{
					info=info.replace('%','|pct|');
				}
				while (info.indexOf("%")>-1);
			}
			if(info.indexOf("#") != -1)
			{
				do
				{
					info=info.replace('#','|hash|');
				}
				while (info.indexOf("#")>-1);
			}
			if(info.indexOf("&") != -1)
			{
				do
				{
					info=info.replace('&','|amp|');
				}
				while (info.indexOf("&")>-1);
			}
		}
		
		QueryURL = QueryURL+"&info="+encodeURI(info);

		QueryURL = QueryURL+"&modifyDiv=modifyDiv";

		var def_probDate = this.hiddenValues.def_probDate;
		QueryURL = QueryURL+"&def_probDate="+def_probDate;

		var def_probhr = this.hiddenValues.def_probhr;
		QueryURL = QueryURL+"&def_probhr="+def_probhr;

		var def_probmin = this.hiddenValues.def_probmin;
		QueryURL = QueryURL+"&def_probmin="+def_probmin;

		var def_fixDate = this.hiddenValues.def_fixDate;
		QueryURL = QueryURL+"&def_fixDate="+def_fixDate;

		var def_fixhr = this.hiddenValues.def_fixhr;
		QueryURL = QueryURL+"&def_fixhr="+def_fixhr;

		var def_fixmin = this.hiddenValues.def_fixmin;
		QueryURL = QueryURL+"&def_fixmin="+def_fixmin;

		var searchByCombo = Ext.getCmp('searchBy').value;
		var fixed = null;
		var reason = null;
		var searchAll =null;
		if(searchByCombo=='1')
		{
			reason='reason';
		}
		else if(searchByCombo=='2')
		{
			fixed = 'fixed';
		}
		else
		{
			searchAll = 'searchAll';
		}
		QueryURL = QueryURL+"&reason="+reason;
		QueryURL = QueryURL+"&fixed="+fixed;
		QueryURL = QueryURL+"&searchAll="+searchAll;

		var prevProbDate = this.hiddenValues.prevProbDate;
		QueryURL = QueryURL+"&prevProbDate="+prevProbDate;

		var prevFixDate = this.hiddenValues.prevFixDate;
		QueryURL = QueryURL+"&prevFixDate="+prevFixDate;

		var prevProbReason = this.hiddenValues.prevProbReason;
		QueryURL = QueryURL+"&prevProbReason="+encodeURI(prevProbReason);

		var prevProbFix = this.hiddenValues.prevProbFix;
		QueryURL = QueryURL+"&prevProbFix="+encodeURI(prevProbFix);

		var tempString = this.QueryStringURL;
		var splitString = tempString.split("&");

		for(var temp =0;temp<splitString.length;temp++)
		{
			if(splitString[temp].indexOf("all")==0 || splitString[temp].indexOf("db")==0 || splitString[temp].indexOf("ct")==0 || splitString[temp].indexOf("is")==0 || splitString[temp].indexOf("sear")==0)
			{
				continue;
			}
			else
			{
				QueryURL = QueryURL +'&'+ splitString[temp];
			}
			
		}

		var probDate = this.getProblemTime().down('datefield').getValue();
		probDate = Ext.Date.format(probDate, mgrDateFormat);
		var fixDate = this.getFixTime().down('datefield').getValue();
		fixDate = Ext.Date.format(fixDate, mgrDateFormat);
		var probHr = this.getProblemTime().down('scrollcombo[fieldLabel=Hr]').getValue();
		var fixHr = this.getFixTime().down('scrollcombo[fieldLabel=Hr]').getValue();
		var probMin = this.getProblemTime().down('scrollcombo[fieldLabel=Min]').getValue();
		var fixMin = this.getFixTime().down('scrollcombo[fieldLabel=Min]').getValue();
		var currentdate = new Date();
		var currentHrs = currentdate.getHours();
		var currentMin = currentdate.getMinutes();
		currentdate = Ext.Date.format(currentdate, mgrDateFormat);
		var fdate = Ext.Date.format(this.getFixTime().down('datefield').getValue(), 'm/d/Y');
		var pdate = Ext.Date.format(this.getProblemTime().down('datefield').getValue(), 'm/d/Y');

		var dummy = new Date();
		var updateTime = (dummy.getTime())-refDate.getTime();
		refDate = dummy;
		if(!curDate)
			curDate =new Date(parseInt(cyear),parseInt(cmon),parseInt(cday),parseInt(chr),parseInt(cmin),parseInt(csec)); 
		else
			curDate.setTime(curDate.getTime()+updateTime);

		var cudate=(curDate.getMonth())+"/"+curDate.getDate()+"/"+curDate.getFullYear();
		var cuhr=curDate.getHours();
		var cumin=curDate.getMinutes();

		if(Ext.isEmpty(prob_reason))
		{
			Ext.Msg.alert("Error",reasonLbl);
		}
		else if(Ext.isEmpty(fix_reason))
		{
			Ext.Msg.alert("Error",fixLbl);
		}
		else if(prob_reason.indexOf("=")>-1 || prob_reason.indexOf("\"")>-1)
		{
			Ext.Msg.alert("Error",specialError);
		}
		else if(fix_reason.indexOf("=")>-1 || fix_reason.indexOf("\"")>-1)
		{
			Ext.Msg.alert("Error",specialError);
		}
		else if(fixby.indexOf("=")>-1 || fixby.indexOf("\"")>-1)
		{
			Ext.Msg.alert("Error",specialError);
		}
		else if(dateValidation(pdate,fdate,parseInt(probHr),parseInt(fixHr),parseInt(probMin),parseInt(fixMin))==-1)
		{	
			Ext.Msg.alert("Error",error1);
			
		}
		else if(dateValidation(fdate,cudate,parseInt(fixHr),cuhr,parseInt(fixMin),cumin)==-1)
		{	
			Ext.Msg.alert("Error",error2);
		}
	/*	else if(!this.checkTime(probDate,fixDate,probHr,fixHr,probMin,fixMin))
		{
			Ext.Msg.alert("Error",error1);
		}
		else if(!this.checkCurrentTime(fixDate,currentdate,fixHr,currentHrs,fixMin,currentMin))
		{
			Ext.Msg.alert("Error",error2);
		}*/
		else{
			var me =this;
			Ext.Ajax.request({
				url : '/final/monitor/KBSearchData.jsp?'+QueryURL,
				success : function(response) {
					me.loadData();
					closeWindow.close();
				},
				failure:function()
				{
					window.location.href = "/final/monitor/KBSearch.jsp";
				}
			});
		}
	},
	saveCSV:function()
	{
		var dSize=this.CSVData;
		if(dSize!=null && dSize==0)
		{
			//alert('No Data Available');
			Ext.Msg.show({
				 title:saveCvs,
				 msg: noDataLbl,
				 buttons: Ext.Msg.OK,
				 icon: Ext.Msg.QUESTION
			});
			return;
		}
		if(dSize==null)
		{
			Ext.Msg.show({
				 title:saveCvs,
				 msg: noDataLbl,
				 buttons: Ext.Msg.OK,
				 icon: Ext.Msg.QUESTION
			});
			//alert('No Data Available');
			return;
		}
		 window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat";
	},

	checkTime : function(timstart,timend,startHr,endHr,startMin,endMin)
	 {
		var startHr = startHr;
		var endHr = endHr;
		var startMin = startMin;
		var endMin = endMin;
		
		if((typeof startHr) == "number"){
			startHr = startHr.toString();
		}
		var slen = startHr.length;
		if(slen == 1 )
		{
			startHr = "0" + startHr;
		}
		
		if((typeof endHr) == "number"){
			endHr = endHr.toString();
		}
		var elen = endHr.length;
		
		if(elen == 1)
		{
			endHr = "0" + endHr;
		}
		if((typeof startMin) == "number"){
			startMin = startMin.toString();
		}
		var sminlen = startMin.length;
		if(sminlen == 1)
		{
			startMin = "0" + startMin;
		}

		if((typeof endMin) == "number"){
			endMin = endMin.toString();
		}
		
		var eminlen = endMin.length;
		if(eminlen == 1)
		{
			endMin  = "0" + endMin;
		}

		var startmon = timstart.substring(0,timstart.indexOf("/"));
		var interstartmon = timstart.substring(timstart.indexOf("/")+1);
		var startday = interstartmon.substring(0,interstartmon.indexOf("/"));
		var startyear = interstartmon.substring(interstartmon.indexOf("/")+1);
		var startdate = startyear + startmon + startday + startHr + startMin;
		//alert("timstart"+timstart);
		//alert("timend"+timend);
		var endmon = timend.substring(0,timend.indexOf("/"));
		var interendmon = timend.substring(timend.indexOf("/")+1);
		var endday = interendmon.substring(0,interendmon.indexOf("/"));
		var endyear = interendmon.substring(interendmon.indexOf("/")+1);
		var enddate = endyear + endmon + endday + endHr + endMin;

		if(startdate > enddate || startdate == enddate)
		{
			return false;
		}
		else
		{
			return true;
		}
		return true;
	},
	checkCurrentTime : function(timstart,timend,startHr,endHr,startMin,endMin)
	 {	
		var startHr = startHr;
		var endHr = endHr;
		var startMin = startMin;
		var endMin = endMin;
		
		if((typeof startHr) == "number"){
			startHr = startHr.toString();
		}
		var slen = startHr.length;
		if(slen == 1 )
		{
			startHr = "0" + startHr;
		}
		
		if((typeof endHr) == "number"){
			endHr = endHr.toString();
		}
		var elen = endHr.length;
		
		if(elen == 1)
		{
			endHr = "0" + endHr;
		}
		if((typeof startMin) == "number"){
			startMin = startMin.toString();
		}
		var sminlen = startMin.length;
		if(sminlen == 1)
		{
			startMin = "0" + startMin;
		}

		if((typeof endMin) == "number"){
			endMin = endMin.toString();
		}
		
		var eminlen = endMin.length;
		if(eminlen == 1)
		{
			endMin  = "0" + endMin;
		}

		var startmon = timstart.substring(0,timstart.indexOf("/"));
		var interstartmon = timstart.substring(timstart.indexOf("/")+1);
		var startday = interstartmon.substring(0,interstartmon.indexOf("/"));
		var startyear = interstartmon.substring(interstartmon.indexOf("/")+1);
		var startdate = startyear + startmon + startday + startHr + startMin;
		//alert("timstart"+timstart);
		//alert("timend"+timend);
		var endmon = timend.substring(0,timend.indexOf("/"));
		var interendmon = timend.substring(timend.indexOf("/")+1);
		var endday = interendmon.substring(0,interendmon.indexOf("/"));
		var endyear = interendmon.substring(interendmon.indexOf("/")+1);
		var enddate = endyear + endmon + endday + endHr + endMin;

		if(startdate > enddate)
		{
			return false;
		}
		else
		{
			return true;
		}
		return true;
	}
});
function dateValidation(starttime,endtime,starthr,endhr,startmin,tomin)
{	
	var styear = parseInt(starttime.substring((starttime.lastIndexOf("/")+1)));		
	var stday = parseInt(starttime.substring((starttime.indexOf("/")+1),starttime.lastIndexOf("/")));
	var stmon = parseInt(starttime.substring(0,starttime.indexOf("/")));
	var endyear = parseInt(endtime.substring((endtime.lastIndexOf("/")+1)));
	var endday = parseInt(endtime.substring((endtime.indexOf("/")+1),endtime.lastIndexOf("/")));
	var endmon = parseInt(endtime.substring(0,endtime.indexOf("/")));
	var state=0;	
	if(styear > endyear)			
		state=-1;		
	else if(styear == endyear)			
		if(stmon > endmon)				
			state=-1;				
		else if(stmon == endmon)
			if(stday > endday)						
				state=-1;
			else if(stday == endday)
				if(starthr > endhr)
					state = -1;
				else if(starthr == endhr)
					if(startmin >= tomin)
						state = -1;
	
	return state;
}
