Ext.define('kbsearch.view.KbSearchMain', {
    extend: 'Ext.form.Panel',
    requires: ['kbsearch.view.KbSearchForm', 'kbsearch.view.KbSearchData', 'kbsearch.view.KbSearchTimeline', 'kbsearch.view.KbSearchSettings', 'kbsearch.view.KbSearchModify', 'utilities.ScrollPanel'],
    alias: 'widget.kbsearchmain',
    id: 'kbsearchmain',
    collapseMode: 'mini',
    flex: 1,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    flex: 1,
    // moreFiltersWindow: null,
    tools: [{

        xtype: 'button',
        iconCls: 'iconSettings',
        id: 'settingIconId',
        //tooltip: '<b>Settings</b>',
        style: {
            background: 'none',
            border: '0px'
        },
        listeners: {
            afterrender: function () {
                Ext.create('Ext.tip.ToolTip', {
                    target: this.id,
                    anchor: 'top',
                    cls: 'yellowTip',
                    trackMouse: true,
                    html: settingsLbl
                });
            }
        },
        handler: function (event, toolEl, panel) {
            var VWidth = Ext.Element.getViewportWidth();

            var containerPosition = VWidth - 620;
            Ext.get('configModx').animate(
                {
                   
						from: {
						x:containerPosition,
							y:-500
						},
						to: {
						   y:40,
						   x: containerPosition
						},
					
                    listeners: { 
						afteranimate: function () { 
							//Ext.get('configMod').setStyle('left', ''); 
							Ext.getCmp('configModx').toggled = true;
						} 
					}
                }
            );
			Ext.getCmp('configModx').showAt(containerPosition,5000);
			Ext.getCmp('configModx').focus();  
        }
    },
    {
        xtype: 'tbseparator'
    },
    {

        xtype: 'button',
        iconCls: 'iconCsv',
        action: 'Save CSV',
        id: 'saveCSV',
        //tooltip: '<b>CSV</b>',
        style: {
            background: 'none',
            border: '0px'
        },
        listeners: {
            afterrender: function () {
                Ext.create('Ext.tip.ToolTip', {
                    target: this.id,
                    anchor: 'top',
                    cls: 'yellowTip',
                    trackMouse: true,
                    html: csv
                });
            }
        }
    }
    ],
    //collapsible : true,
    //collapseFirst: false,
    screenLabels: null,
    //collapseDirection: 'top',
    title: titleLbl,
    padding: 0,
    margin: 0,
    border: false,
    // url: '/final/monitor/EgAlarmHistoryView.jsp?eventsCount=0',
    items: [{
        xtype: 'kbsearchform',
        id: 'kbserchform',
        collapseMode: 'mini',
        parent: this,

    },/*{
        xtype: 'kbsearchdata',
        parent: this,

    },*/
    {
        xtype: 'scrollpanel',
        padding: 0,
        margin: 10,
        flex: 1,
        layout: {
            type: 'vbox',
            align: 'stretch'
        },
        //height:330,
        frame: true,
        scroll: false,
        autoScroll: true,
        //title:'Data Panel',
        cls: 'dataPanel kbmarintop',
        id: 'datapanel',
        name: 'tableView',
        listeners: {
            resize: function (width, height) {
                //alert(width,height);
                width = '100%';
                var datapanelID = Ext.getCmp("datapanel");
                height = Ext.getBody().getViewSize().height - 320;
                datapanelID.setSize(width, height);
            }

        },
        items: [
            {
                xtype: 'panel',
                id: 'tableView',
                flex: 1,
                margin: '0 0 0 0',
                bodyPadding: 10,

            }
        ],


    }],
    listeners: {
        "boxready": function () {
            this.showConfigDropdown();
        }
    },
    buttonAlign: 'center',
    showConfigDropdown: function () {
        var me = this;
        //this.callParent();
        var VWidth = Ext.Element.getViewportWidth();
        function targetPosition(totalwidth, targetID, popupwidth) {
			
            var left = totalwidth - Ext.getCmp(targetID).getPosition()[0],
                targetWidth = Ext.getCmp(targetID).getWidth() / 2 + 1,
                targetPosition = (popupwidth + targetWidth) - left;
            return targetPosition;
        }
        var left = targetPosition(VWidth, 'settingIconId', 615);
		var containerPosition = VWidth - 620;
        var a = new Ext.XTemplate('<div class="settingsfont" style="float:left;text-transform:uppercase;">Settings</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="close"></div></div>');
        Ext.create("Ext.container.Container", {
            id: "configModx",
            ui: 'configOuterContainer',
            width: 600,

            floatable:true,
            floating:true,
            hidden: true,
            style: { 'zIndex': '999' },
            renderTo: Ext.getBody(),
            //height:80,
            //html:tpl.apply(),
            //border:true,
            //hidden:true,
			toggled:false,
            items: [{
                xtype: 'container',
                cls: 'configMode_popupArrow',
                id: 'configMode_popupArrow',
               style:{'top':'-14px','left':left+'px'}
            },
            {
                xtype: 'container',
                html: a.apply(),
                margin: '0 10',
                padding: '10 0 5 0',
                cls: 'configMode_header',
            }, {
                xtype: 'kbsearchsettings',
                id: 'kbsearchsettings',
                //height:47,
                padding: 5,
                parent: me
            }],
            //renderTo:'kbsearchmain-body',
            listeners: {
                render: function (c) {
					Ext.create('Ext.util.KeyNav', c.getEl(), {
                      "esc" : function(e){
                        c.hide();
						Ext.getCmp('configModx').toggled = false;
                      },
                      scope: c
                    });
                    Ext.get("close").on("click", function () {

                        Ext.get("configModx").animate({
                            duration: 500,
							from: {
								x:containerPosition,
								y:40
							},
							to: {
							   y:-500,
							   x: containerPosition
							},
							listeners: { 
								afteranimate: function () { 
									//Ext.get('configMod').setStyle('left', ''); 
									Ext.getCmp('configModx').toggled = false;
								} 
							}
                        });
                    });
                }
            }
        });
    }
});