Ext.define('measures.controller.Main', {
	extend : 'Ext.app.Controller',
	requires:['measures.view.TestInfo',
			  'measures.view.ConfigureThresholds'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'measuresform',ref:'measuresform'},
		{selector:'measuresdata',ref:'measuresdata'},
		{selector:'testinfo',ref:'testInfo'},
		{selector:'configurethresholds',ref:'configureThresholds'},
		{selector:'listofmeasures', ref:'listofmeasures'},
		{selector:'testinfo container#tableContainer',ref:'testInfoTableContainer'},
	    {selector:'favlistpopup', ref:'favlistpopup'}
      ],
	init: function() {
		app = this;
		this.control({
				'testinfo button[itemId="iconTestConfig"]': {
					click: this.testConfigureEvent
				},
				'main':
				{
					'boxready':this.afterMainRender,
					resize:function(){
						this.submitForResult
					},
						render: function(){
						if(Ext.isEmpty(this.getTestInfo()))
						Ext.create('measures.view.TestInfo');

						if(Ext.isEmpty(this.getConfigureThresholds()))
						Ext.create('measures.view.ConfigureThresholds');
					}
				},
				'main button[id="submit"]':
				{
					'click': this.submitForResult
				},
				'main button[id="favList"]':
				{
					'click': this.showFavList
				},

				'main button[id="favoriteLink"]':
				{
					'click': this.createFavoriteLink
				},
				'main combo[id="compType"]':
				{
					'select': this.getComponentsForType
				},
				'main combo[id="compName"]':
				{
					'select': this.submitForResult
				},
				'main button[id="back"]':
				{
					'click': this.goBack
				},
				'configurethresholds slider[id="relMinCritical"]':
				{
					'drag': this.minRelCriticalSlider,
					'change': this.minRelCriticalSlider,
				},
				'configurethresholds slider[id="relMinMajor"]':
				{
					'drag': this.minRelMajorSlider,
					'change': this.minRelMajorSlider,
				},
				'configurethresholds slider[id="relMinMinor"]':
				{
					'drag': this.minRelMinorSlider,
					'change': this.minRelMinorSlider,
				},
				'configurethresholds slider[id="relMaxCritical"]':
				{
					'drag': this.maxRelCriticalSlider,
					'change': this.maxRelCriticalSlider,
				},
				'configurethresholds slider[id="relMaxMajor"]':
				{
					'drag': this.maxRelMajorSlider,
					'change': this.maxRelMajorSlider,
				},
				'configurethresholds slider[id="relMaxMinor"]':
				{
					'drag': this.maxRelMinorSlider,
					'change': this.maxRelMinorSlider,
				},
				'configurethresholds checkbox[id="minStaticCheck"]':  
				{
					'change': this.minStaticCheckChange,
				},
				'configurethresholds checkbox[id="minAutoCheck"]':
				{
					'change': this.minAutoCheckChange,
				},
				'configurethresholds checkbox[id="maxStaticCheck"]':
				{
					'change': this.maxStaticCheckChange,
				},
				'configurethresholds checkbox[id="maxAutoCheck"]':
				{
					'change': this.maxAutoCheckChange,
				},
				'configurethresholds combo[id="alarmPolicyCombo"]':
				{
					'select': this.alarmPolicyChange,
				},
				'configurethresholds button[id="updateBtn"]':
				{
					'click': this.applyThresholdsData
				}
		});
	},
	getComponentsForType: function(){
		
		var mainForm = this.getMeasuresform().getForm();
		var compTypeObj = mainForm.findField('compType');

		this.callRemoteScript( mainForm, 'compName', '/final/servlet/com.eg.RemoteScriptingServlet', 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getComponentsForTypeMeasures&P0='+ compTypeObj.getValue() );
	},
	testConfigureEvent : function(){

		var queryStr = '/final/admin/EgSpecificTestConfiguration.jsp?reqfrom=LayerModel&showUnconfigCompType=false&testType=PerformanceTest&com.eg.CSRF_NONCE='+csrfToken;
		var tmpQueryStr = 'reqfrom=LayerModel&showUnconfigCompType=false&testType=PerformanceTest&com.eg.CSRF_NONCE='+csrfToken;
		var winParObj = window.parent;

		if (!Ext.isEmpty(Ext.getCmp('testname1').monSource))
		{
			queryStr += '&monSource='+Ext.getCmp('testname1').monSource;
			tmpQueryStr += '&monSource='+Ext.getCmp('testname1').monSource;
		}
		
		if (!Ext.isEmpty(Ext.getCmp('testname1').State))
		{
			queryStr += '&State='+Ext.getCmp('testname1').State;
			tmpQueryStr += '&State='+Ext.getCmp('testname1').State;
		}
		
		if (!Ext.isEmpty(Ext.getCmp('testname1').compName))
		{
			queryStr += '&compName='+Ext.getCmp('testname1').compName;
			tmpQueryStr += '&compName='+Ext.getCmp('testname1').compName;
		}

		if (!Ext.isEmpty(Ext.getCmp('testname1').layerName))
		{
			queryStr += '&layerName='+Ext.getCmp('testname1').layerName;
			tmpQueryStr += '&layerName='+Ext.getCmp('testname1').layerName;
		}
		if (!Ext.isEmpty(Ext.getCmp('testname1').testName))
		{
			queryStr += '&testName='+Ext.getCmp('testname1').testName;
			queryStr += '&layerTestName='+Ext.getCmp('testname1').testName;

			tmpQueryStr += '&testName='+Ext.getCmp('testname1').testName;
			tmpQueryStr += '&layerTestName='+Ext.getCmp('testname1').testName;
		}
		if (!Ext.isEmpty(Ext.getCmp('testname1').testStateName))
		{
			queryStr += '&clickedFrom='+Ext.getCmp('testname1').testStateName;
			tmpQueryStr += '&clickedFrom='+Ext.getCmp('testname1').testStateName;
		}
		if (!Ext.isEmpty(Ext.getCmp('testname1').compType))
		{
			queryStr += '&componentType='+Ext.getCmp('testname1').compType;
			tmpQueryStr += '&componentType='+Ext.getCmp('testname1').compType;
		}
		if (!Ext.isEmpty(Ext.getCmp('testname1').compName))
		{
			queryStr += '&componentName='+Ext.getCmp('testname1').compName;
			tmpQueryStr += '&componentName='+Ext.getCmp('testname1').compName;
		}
		var wholeViewport = document.getElementsByTagName("body")[0];
		mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
		mask.show();

		Ext.Ajax.request({
			url : "/final/admin/SpecificTestConfiguration/data/MonitorURL.jsp?"+tmpQueryStr,
			method : 'POST',
			params: {
				hitFrom: 'monitor'
			},
			scope:this,
			async: false,
			success : function(response, opts){
				mask.hide();
			},
			failure : function(){}
		});
		window.parent.goToTestConfiguration(indexTabURL.adminTabURL+'&monLayerUrl='+encodeURIComponent(winParObj.filterEncode(queryStr)));
	},
	openTestInfoWindow:function(infoUrl){
		var me = this;
		Ext.Ajax.request({
			url:infoUrl,
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				var testInfoWinObj = me.getTestInfo();
				csrfToken = json.strCsrfToken;
				if(testInfoWinObj==null || Ext.isEmpty(testInfoWinObj))
				{
					testInfoWinObj = Ext.widget('testinfo');
				}
				testInfoWinObj.setTestDetailsData(json);
				me.getTestInfoTableContainer().removeAll();
				if (json.isAdminLinkEnabled)
				{
					me.getTestInfoTableContainer().add(me.createTableViewForThreshold('Measure','Max/Min','Critical','Major','Minor','Alarm policy',' ',json.jsonArrayValue));
				}
				else
				{
					me.getTestInfoTableContainer().add(me.createTableViewForThreshold('Measure','Max/Min','Critical','Major','Minor','Alarm policy',json.jsonArrayValue));
				}
				if(!Ext.isEmpty(json.measureDescription))
				{
					me.getTestInfoTableContainer().add(me.createTableView('Measures without Thresholds',json.measureDescription));
				}
				
				testInfoWinObj.show();
			},
			failure:function(){
				window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},

		showFavList:function(){
		var me = this;
		var mainForm = this.getMeasuresform().getForm();
		var stateObj = mainForm.findField('State');
		var compObj = mainForm.findField('compName');
		var searchMeasureVal = mainForm.findField('searchMeasure').getValue();
		if ( compObj.getValue() == '-1' )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: chooseComponents,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}

                 listOfMeasureObj2= Ext.widget('favlistpopup');
                 listOfMeasureObj2.show();
		         initLdgMask.show();

		         listOfMeasureObj2.add({
                 region: 'west',
                 xtype: 'panel',
		         itemId:'measuresListId',
				 id:'measuresListId',
                 items:[]
               //bodyCls:'measurefavlist',
	            });



	           listOfMeasureObj2.add({
                region: 'east',
	        	xtype: 'panel',
				margin:'0 0 0 5',
	  	    //bodyCls:'measurefavlist',
	        	itemId:'favMeasuresListId',
				id:'favMeasuresListId',
                width: '50%',
                items:[]

	           });





		lastMeasRefreshDate=new Date();
		//initLdgMask.show();
		var resultObj = this.getMeasuresdata();
		//resultObj.removeAll();
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgMonitorController',
			method: 'POST',
			params: 'State='+encodeURIComponent(stateObj.getValue())+'&searchMeasure='+encodeURIComponent(searchMeasureVal)+'&compName='+encodeURIComponent(compObj.getValue())+'&newWindow='+newWindow+'&monCmd=measures&action=measures&search=&isSubmit=true&resultpage=favmeasures&jsonResponse=true',
			success: function ( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					var resultData = jsonData['RESULTS'];
					me.showFavListData( resultData,resultObj );
					initLdgMask.hide();
				    resultData=null;
					jsonData=null;
				    jsonText=null;
				}
			}
		});

},
	showFavListData:function(resultData,resultObj){
		 var noMesFound="No Measures Found";
		 var listMeasureData = resultData['MEASURES'];
		 var listOfMeasuresObj =listOfMeasureObj2.getComponent('measuresListId');
		 listOfMeasuresObj.removeAll();

            if ( !Ext.isEmpty( listMeasureData ) ){
			var totalHTML='';
				var dataArray = new Array();

			for ( var i = 1; i < listMeasureData.length; i++ )
			{

				var link = listMeasureData[i]['LINK'];
				var text = listMeasureData[i]['TEXT'];
				dataArray[dataArray.length] = text;
				dataArray[dataArray.length] = link;
				var genHTML = '';
			    var measuresDivCls = 'measuresLink';
				var favIconCls = '';
			/**	if ( selectedSearchMeasure == text && linkFromFav == 'false' )
				{
					measuresDivCls = 'measuresLinkSelected';
					favIconCls = 'iconFavorite';
					lastFavShowId = i;
				}
				**/




			genHTML = '<div style="float:left;width:100%;border:0px solid blue" class="'+measuresDivCls+'" id="measures-div-'+i+'" onMouseOver="javascript:measuresOver(\''+i+'\'); " onmouseout="javascript:measuresOut(\''+i+'\');"><div style="padding:2px;border:0px solid green;width:85%;float:left"><a href="javascript:void(0);" data-qclass="yellowTip" onclick="javascript:executelink(\''+link+'\',\'false\');showMeasure(\''+text+'\',\'true\');" data-qtip="'+text+'" >'+text+'</a></div><div id="Fav-'+i+'" style="float:right;border:0px solid red;cursor:pointer;width:10%" class="'+favIconCls+'" data-qtip="Add to favourites" onclick="javascript:createFav(\''+i+'\',\''+text+'\',\''+link+'\');"></div></div>';

				totalHTML+=genHTML;

			}
			listOfMeasuresObj.add(
				{

					region: 'west',
                    xtype: 'panel',
                    title: 'Measures',
					cls:'outerpanel',
		           //bodyCls:'measurefavlist',
	                height:363,
		            frame:true,
		            scroll:true,
		            autoScroll:true,
                    id: 'mes',
					dataArray: dataArray,
					width: 300,
				    html: totalHTML
				});

		}
		else
		{
			listOfMeasuresObj.add(
				{
					xtype: 'container',
					columnWidth: '1',
					style: 'text-align:center',
					border: true,
					html: '<div class = "iconInformation" style="margin:50% auto 0 auto"></div><div>No measures found</div>'
				});
		}
		listOfMeasuresObj.doLayout();
		var listFavMeasureData = resultData['FAV_MEASURES'];
		var dataArray2 = new Array();

		var listFavMeasureObj = listOfMeasureObj2.getComponent('favMeasuresListId');
		listFavMeasureObj.removeAll();
		if ( !Ext.isEmpty( listFavMeasureData ) )
		{

			var genHTML='';
			for ( var i = 0; i < listFavMeasureData.length; i++ )
			{
				var link = listFavMeasureData[i]['LINK'];
				var text = listFavMeasureData[i]['TEXT'];
				dataArray2[i] = text;
				//dataArray[dataArray.length] = link;
				var favmeasuresDivCls= 'measuresLink';

				var favMeasureCls ='';
				var favdelicon = '';

			/**	if ( selectedSearchMeasure == text && linkFromFav == 'true' )
				{
					favMeasureCls = 'measuresLinkSelected';
					lastSelectedFavDiv = i;
				}
				**/
			genHTML+= '<div class="'+favmeasuresDivCls+'" style="float:left;border:0px solid blue;" id="fav-measure-div-'+i+'" onMouseOver="javascript:favOver(\''+i+'\');" onmouseout="javascript:favOut(\''+i+'\');"><div style="padding:2px;float:left;border:0px solid red;float:left"><a href="javascript:void(0);" data-qclass="yellowTip" onclick="javascript:executelink(\''+link+'\',\'false\');showMeasure(\''+text+'\',\'true\');" data-qtip="'+text+'" >'+text+'</a></div><div id="fav-div2-'+i+'" class="'+favdelicon+'" style="float:right;margin-right: 20px;cursor:pointer;" data-qtip="Delete from favourites" onclick="javascript:deletelink(\''+i+'\',\''+text+'\');"></div></div>';


			}
			listFavMeasureObj.add(
				{
				    region: 'east',
					xtype: 'panel',
					cls:'outerpanel',
                    frame:true,
		            scroll:true,
		            autoScroll:true,
                    width: 280,
                    title: 'Favourite Measures',
	                height:360,
                    id: 'favId',
					dataArray: dataArray2,
					//bodyCls:'measurefavlist',
                    html:genHTML
				});
		}
		else
		{
			listFavMeasureObj.add(
				{
	               region: 'east',
				   xtype: 'panel',
                   frame:true,
		           scroll:true,
		           autoScroll:true,
                   width: 300,
				   cls:'outerpanel',
                   title: 'Favourite Measures',
	               height:380,
				   id: 'favId',
				   dataArray: dataArray2,

				 //bodyCls:'measurefavlist',
                   itemId:'favMeasuresListId',
                   html:'<div class="emptycontentdiv"><div class = "iconInformation" style="margin:50% auto 0 auto"></div><div style="text-align: center;">No measures found</div><div>'
						});
		}
		listFavMeasureObj.doLayout();
        listFavMeasureData=null;
        delete listFavMeasureData;
        listMeasureData=null;
        delete listMeasureData;


		},

	createTableView:function(){
		/*
		* Used arguments concept of javascript function
		* It is done so to accept any number of arguments for the function
		* so that this function can be globally used to create dynamic table of any size
		*/

		var headers = Array.prototype.slice.call(arguments);
		var bodyData = headers.pop();

		var table = '<div class="x-table no_rap"><table width="100%" class="x-grid-table" cellspacing="0" cellpadding="0" border="0" style="table-layout:auto"><thead ><tr class="x-grid-row">';
		for(h=0;h<headers.length;h++)
			table += '<th class=" x-grid-cell"><div class="x-grid-cell-inner" >'+headers[h]+'</div></th>';
		table += '</tr></thead>';

		table += '<tbody>';

		if(typeof bodyData == 'string'){
			table += '<tr class="x-grid-row"><td class=" x-grid-cell" wrap><div class="x-grid-cell-inner">'+bodyData+'</div></td></tr>';
		}
		else if(!Ext.isEmpty(bodyData)){
			for( p = 0; p < bodyData.length; p++){
				var data = bodyData[p];
				var keys = [];
				for (var key in data) {
					keys.push(key);
				}
				table += '<tr class="x-grid-row">';
				for(q = 0; q < keys.length; q++){
					table += '<td class=" x-grid-cell"><div class="x-grid-cell-inner">'+data[keys[q]]+'</div></td>';
				}
				table += '</tr>';
			}
		}
		else
			return false;

		table += '</tbody></table></div>';
		var container = {
			xtype:'panel',
			cls:'block1',
			frame:true,
			border:true,
			margin:'0 0 10 0',
			html:table
		};
		return container;
	},
	goBack: function()
	{
		window.location.href = backBtnURL;
	},

   deleteLinkConfirm: function( id, measure){

           Ext.Msg.confirm('<div class="favpopupalert">Measures</div>', 'Are you sure you want to delete?', function(e) {
	       if (e == "yes") {
           app.deleteLink(id,measure);
            }

       });
    },
	deleteLink: function( id, measure){
		var me = this;

        var listMeasureObj = me.getFavlistpopup();

		var URL = '/final/servlet/com.eg.EgMonitorController';
		var params = 'action=measures&compName='+Ext.getCmp('compName').getValue()+'&createlink=&measure=&monCmd=measures&newWindow=false&search=&State='+Ext.getCmp('State').getValue()+'&isSubmit=true&resultpage=favmeasures&deletelink='+encodeURIComponent(measure);
		var isDeleted = false;

		Ext.Ajax.request({
				url: URL,
				params: params,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{

		               var listFavMeasureObj = listMeasureObj.getComponent('favMeasuresListId');
                       var dataArray=listFavMeasureObj.getComponent(0).dataArray;

                       var arr = dataArray.indexOf(measure);
					   if(arr != -1) {
	                   dataArray.splice(arr, 1);
					   }
                       Ext.fly('fav-measure-div-'+id).remove();
					   Ext.MessageBox.show({
				       title: 'Alert',
				       msg: 'Favourite measure deleted successfully!',
				       buttons: Ext.MessageBox.OK,
				       icon: Ext.MessageBox.WARNING
			           });

				   }
				}

			});

	},
	createFavoriteLink: function(id,measureName,link)
	{
		var me = this;
        var genHTML='';
	    var e = Ext.dom.Query.select(".emptycontentdiv");

        if(e.length==1){
	    var c = Ext.fly(e[0]);
	    c.addCls("hidecontentDiv");
        }

		var listMeasureObj = this.getFavlistpopup();
		var listFavMeasureObj = listMeasureObj.getComponent('favMeasuresListId');
		var measure = Ext.getCmp('searchMeasure').getValue();
		var link = Ext.getCmp('searchMeasure').dataArray;
        var dataArray=listFavMeasureObj.getComponent(0).dataArray;

		if ( !Ext.isEmpty( measureName ) )
		{
			if ( !Ext.isEmpty(dataArray)&&dataArray!='undefined')
		  {

          for( j=0;j< dataArray.length;j++)
		  {
			  var getMeasure = dataArray[j];
			  if ( getMeasure == measureName )
			   {
				Ext.MessageBox.show({
				title: 'Alert',
				msg: selectMeasureExist,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
						});
				return;
			   }
		  }
	      }
		   else{
              listFavMeasureObj.getComponent(0).dataArray[0]='NA';
		      dataArray = listFavMeasureObj.getComponent(0).dataArray;

		    }
		}

		genHTML=Ext.getElementById('favId-body').innerHTML;
	    var measure = measureName;
        var URL = '/final/servlet/com.eg.EgMonitorController';
		var params = 'action=measures&compName='+Ext.getCmp('compName').getValue()+'&deletelink=&measure=&monCmd=measures&newWindow=false&search=&State='+Ext.getCmp('State').getValue()+'&isSubmit=true&resultpage=favmeasures&createlink='+encodeURIComponent(measure);

        Ext.Ajax.request({
				url: URL,
				params: params,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
                       var favmeasuresDivCls='measuresLink';
				       var favdelicon='';
				       var text=measure;
				       var  i=0-id;


                      dataArray[dataArray.length]=measureName;
					  genHTML+= '<div class="'+favmeasuresDivCls+'" style="float:left;border:0px solid blue;" id="fav-measure-div-'+i+'" onMouseOver="javascript:favOver(\''+i+'\');" onmouseout="javascript:favOut(\''+i+'\');"><div style="padding:2px;float:left;border:0px solid red;float:left"><a href="javascript:void(0);" data-qclass="yellowTip" onclick="javascript:executelink(\''+link+'\',\'false\');showMeasure(\''+text+'\',\'true\');" data-qtip="'+text+'" >'+text+'</a></div><div id="fav-div2-'+i+'" class="'+favdelicon+'" style="float:right;margin-right: 20px;cursor:pointer;" data-qtip="Delete from favourites" onclick="javascript:deletelink(\''+i+'\',\''+text+'\');"></div></div>';

			          Ext.fly('favId-body').update(genHTML);

					  Ext.MessageBox.show({
				            title: 'Alert',
				            msg: 'Favourite measure added successfully!',
                            buttons: Ext.MessageBox.OK,
				            icon: Ext.MessageBox.WARNING
			           });
                     }
			    },
			 failure: function()
			 {
				console.log('No Response...');
			 }
			});
	},
	executeLink: function( link, fromFavLink )
	{
		var me = this;
		var mainForm = this.getMeasuresform().getForm();
		var params = link.substring(link.indexOf('?')+1);

		var resultObj = this.getMeasuresdata();
		resultObj.removeAll();

		params += '&isSubmit=true&newWindow=false&resultpage=measures&linkFromFav='+fromFavLink;
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgMonitorController',
			method: 'POST',
			params: params,
			success: function ( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					var resultData = jsonData['RESULTS'];

					me.showDataView( resultData ,resultObj);
					resultData=null;
					jsonText=null;
					jsonData=null;
				}
			},
			failure: function()
			{
				console.log('No Response...');
			}
		});
	},
	submitForResult: function()
	{
		var me = this;
		var mainForm = this.getMeasuresform().getForm();
		var stateObj = mainForm.findField('State');
		var compObj = mainForm.findField('compName');
		var compTypeObj = mainForm.findField('compType');
		var selected_val=compObj.getValue();
		var store_data=compObj.getStore();
		for(var k=0;k<store_data.getCount();k++)
		{
			var comp_val=store_data.getAt(k).data.valueField;
			if(comp_val==selected_val)
			{
				var state=store_data.getAt(k).data.state;
				$('#compName-inputEl').removeClass('state_'+state_Comp);
				$('#compName-inputEl').addClass('state_'+state);
				state_Comp=state;
				break;
			}
		}
		
		var searchMeasureVal = mainForm.findField('searchMeasure').getValue();
		if ( compObj.getValue() == '-1' )
		{
			if(!Ext.isEmpty(isFrom) && (isFrom == 'MainDashboard' ||isFrom == 'refresh'))
			{
				isFrom = "submit";
				return;
			}
			else if(!Ext.isEmpty(isFrom) && isFrom == 'submit')
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: chooseComponents,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		Ext.getCmp('favList').show();

		lastMeasRefreshDate=new Date();
		initLdgMask.show();
		var resultObj = this.getMeasuresdata();
		resultObj.removeAll();
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgMonitorController',
			method: 'POST',
			params: 'State='+encodeURIComponent(stateObj.getValue())+'&searchMeasure='+encodeURIComponent(searchMeasureVal)+'&compType='+encodeURIComponent(compTypeObj.getValue())+'&compName='+encodeURIComponent(compObj.getValue())+'&newWindow='+newWindow+'&monCmd=measures&action=measures&search=&isSubmit=true&resultpage=measures&jsonResponse=true',
			success: function ( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					var resultData = jsonData['RESULTS'];
					me.showDataView( resultData,resultObj );
					initLdgMask.hide();
					resultData=null;
					jsonData=null;
					jsonText=null;
				}
			}
		});
	},
	refreshMeasures : function()
	{
		var newMeasRefreshDate=new Date();
		if(lastMeasRefreshDate!=null && (newMeasRefreshDate.getTime()-lastMeasRefreshDate.getTime())>=refreshFrequency)
		{
			if(isDataAvailableB4Refresh)
			{
				var measureDataView= this.getMeasuresdata().query('#measureDataView');
				if(!Ext.isEmpty(measureDataView))
					startPosB4Refresh=measureDataView[0].getStore().currentPage;
			}
			else
			{
				startPosB4Refresh=null;
			}
			isFrom = 'refresh';
			this.submitForResult();
		}
	},
	showDataView : function(resultData,resultObj)
	{

		var bdColorval = (strSkin == 'Light')?"0px":'1px';
		var assignWidth = $(window).width()-70;

		var resultObj = this.getMeasuresdata();
		resultObj.removeAll();
		var reportTableArr  = resultData['OUTPUT_VALUES'];
		if(!Ext.isEmpty(reportTableArr))
		{
			isDataAvailableB4Refresh=true;

			var datStore = new Ext.data.Store({
						fields:[{ name : 'CASE',type : 'string' },{ name : 'HEADERS',type : 'object' },{ name : 'TABLE_VALUES',type : 'array'},{ name : 'IS_GRID',type : 'string' },{ name : 'GRID_FIELDS',type : 'array' },{ name : 'GRID_VALUES',type : 'array' }],
						//data:reportTableArr,
						// autoLoad: true,
						 proxy: {
							 type: 'ajax',
							  url: '/final/servlet/com.eg.EgMonitorResultDispatcher?resultpage=measures&fromPagination=true',
							   actionMethods: {
								   read : 'POST' // use HTTP POST when making the AJAX request
			                 },
							 reader: {
								 type :'json',
								 root: 'OUTPUT_VALUES',
								 totalProperty: 'totalCount'
							 }
						 },
						pageSize : 10
						});

			//datStore.getProxy().data = reportTableArr;
			if(startPosB4Refresh!=null)
			{
				var totlPages=resultData['totalPages'];
				if(!Ext.isEmpty(totlPages))
				{
					totlPages = parseInt(totlPages);
					startPosB4Refresh = parseInt(startPosB4Refresh);
					if(startPosB4Refresh>totlPages)
					{
						startPosB4Refresh = 1;
					}
					datStore.loadPage(startPosB4Refresh);
				}
			}
			else
			{
				datStore.load();
			}
			var addSubmittedReports = Ext.widget('commonPanel',
			{
				layout:{
						type:'vbox',
						align:'stretch'
				},
				//border:0,
				frame:false,
				margin:'0',
				padding:0,
				bodyPadding:'0',
				//layout:'fit',
				cls:'datapanel',
				//header:{cls:'networkheader'},
				//bodyCls:'networkborder',
				//bodyStyle:{'background':'none'},
				title:resultData['title'],
				titleAlign:'left',
				flex:1,
				id:'commonPnlId',
				//height : (Ext.getBody().getViewSize().height-150),
				dockedItems: [{
					dock: 'bottom',
					xtype : 'pagingtoolbar',
					cls:"pagingtoolbar pagingtoolbartop",
					store: datStore,
					displayInfo: true,
					listeners:{
						change:function(){
							var panObj = Ext.get('commonPnlId-body');
							if(!Ext.isEmpty(panObj) && panObj!=null && panObj!=undefined)	
								panObj.dom.scrollTop = 0;
						}
					}
				}],
				items:[
					{
					xtype:'dataview',
					flex:1,
					scroll:true,
					autoScroll:true,
					padding:'10',
					bodyStyle:{'background':'none'},
					itemId : 'measureDataView',
					store: datStore,
					tpl:new Ext.XTemplate(
				'<tpl for=".">',
				'<div class="x-table no_rap">',
					'<tr>', 
						'<td>',
							'<div class="measuretitletop" style="margin:5px 5px 0px 5px;border-bottom:'+bdColorval+' solid #525252 !important;width:'+assignWidth+';overflow:auto">',
								'<div class="measureHeader"><div style="float:left;"><div class="state_{HEADERS.STATE}" style="float:left;margin:0px 5px 0px -4px"></div>',
									'<tpl if="!Ext.isEmpty(HEADERS.LINKS)">',
										'<div style="border:0px solid red;padding:1px;float:left;"><a href="javascript:void(0);" data-qclass="yellowTip" onclick="javascript:{HEADERS.LINKS.METHOD_NAME}(\'{HEADERS.LINKS.LINK}\');" data-qtip="{HEADERS.LINKS.TITLE}">{HEADERS.LINKS.TEXT}</a></div>',
									'<tpl else>',
										'<div style="border:0px solid blue;float:left;margin-top:2px !important;">{HEADERS.TITLE}</div>',
									'</tpl>',
									'<tpl if="!Ext.isEmpty(HEADERS.MAINTENANCE)">',
										'<tpl exec="this.prepareParams(HEADERS.MAINTENANCE.LINK)"></tpl>',
										'<div class="iconQuickLinksConfig" id="maintenanceIcon{[xindex]}" style="float:left;cursor:pointer;" title="{[this.prepareParams[0]]}"></div>',
									'</tpl>',
									'<tpl if="!Ext.isEmpty(HEADERS.INFO_LINK)">',
										'</div><div style="float:right;border:0px solid blue;"><div style="float:left;border:0px solid blue;font-size:11px;margin:2px 5px 0px 5px">{HEADERS.DISPLAY_DATE}</div><div style="float:left;margin:0px 3px 0px 3px"><a href="javascript:void(0)" data-qtip="INFO" data-qclass="yellowTip"><img src="../images/clear.png" class="iconRumInfo" id="iconInfo{[xindex]}" style="float:left;cursor:pointer;" onclick="javascript:openInfoLink(\'{HEADERS.INFO_LINK}\');"/></a></div><div class="measurevertical_line"></div><div class="iconHelp" style="float:left;cursor:pointer;margin:0px 5px 0px 5px" data-qtip="HELP" data-qclass="yellowTip"onclick="javascript:openHelpWin(\'{HEADERS.HELP_LINK}\');"></div></div><div style="clear:both"></div></div>',
									'<tpl else>',
										'</div><div style="float:right;border:0px solid blue;"><div style="float:left;font-size:11px;margin:2px 5px 0px 5px">{HEADERS.DISPLAY_DATE}</div><div class="measurevertical_line"></div><div class="iconHelp" style="float:left;cursor:pointer;margin:0px 5px 0px 5px" data-qtip="HELP" data-qclass="yellowTip"onclick="javascript:openHelpWin(\'{HEADERS.HELP_LINK}\');"></div></div><div style="clear:both"></div></div>',
									'</tpl>',
								'</div>',
						'</td>', 
					'</tr>',
					'<table border="0" cellspacing="0" cellpadding="0" width="100%" >', 
						'<tr>', 
							'<td>', 
								'<div class="measuretitletop x-grid-table-measure" style="margin:0px 5px 10px 5px;border-top:'+bdColorval+' solid #525252;width:'+assignWidth+';overflow:auto">',
								'<tpl if="CASE == \'1\'">',
									'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer nowrap darktheme_measure" style="width:100% !important;table-layout: auto;" >',
										'<thead>',
											'<tr class="x-grid-row">',
												'<tpl for="GRID_FIELDS">',
													'<th class="x-grid-cell" style="vertical-align:middle">xx',
														'<div class="x-grid-cell-inner" style="overflow:visible;border-bottom:0px !important">{TEXT}</div>',
													'</th>',
												'</tpl>',
											'</tr>',
										'</thead>',
										'<tbody>',
										'<tpl for="GRID_VALUES">',
											'<tr class="x-grid-row">',
												'<tpl exec="this.objectToArray(values)"></tpl>',
												'<tpl for="this.array">',
													'<tpl if="key == \'COLUMN_0\'">',
														'<td class=" x-grid-cell">',
														'<div class="x-grid-cell-inner" >',
														'<tpl if="!Ext.isEmpty(value.INFO_LINKS)">',
															'<img style="border:0px;vertical-align:middle;margin:0px 0px" class="iconRumInfo" data-qclass="yellowTip" data-qtip="{value.INFO_LINKS.TITLE}" src="../images/clear.png" onclick="javascript:openInfoLink(\'{value.INFO_LINKS.PARAMS}\')"/>',

															'<img class="stateSymbol_{value.LINKS.STATE}" style="border:0px solid red;margin:0px 0px" border="0px" src="../images/clear.png" />',
															'<a href="javascript:void(0);" onclick="javascript:{value.LINKS.METHOD_NAME}(\'{value.LINKS.PARAMS}\')">{value.LINKS.LINK_TEXT}</a>',
														'</tpl>',
														'</div>',
														'</td>',
													'</tpl>',
														'<tpl else if="!Ext.isEmpty(value.MEASURE)">',
														'<td class=" x-grid-cell">',
														'<div class="x-grid-cell-inner" ><img style="vertical-align:middle;margin:0px 2px" src="../images/clear.png" class="stateSymbol_{value.STATE}"/>',
														'<tpl if="!Ext.isEmpty(value.MEASURE) && !Ext.isEmpty(value.MEASURE.LINK_TEXT)">',
															'<a href="javascript:void(0);" onclick="javascript:{value.MEASURE.METHOD_NAME}(\'{value.MEASURE.PARAMS}\');">{value.MEASURE.LINK_TEXT}</a>',
															'<tpl if="!Ext.isEmpty(value.MEASURE.DD)">',
																'<img style="vertical-align:middle;margin:0px 2px;cursor:pointer" src="../images/clear.png" class="iconDiagnosis" data-qclass="yellowTip" onclick="javascript:{value.MEASURE.DD.METHOD_NAME}(\'{value.MEASURE.DD.PARAMS}\');" data-qtip="{value.MEASURE.DD.LINK_TITLE}"/>',
															'</tpl>',
														'</tpl>',
														'<tpl else if="!Ext.isEmpty(value.MEASURE) && Ext.isEmpty(value.MEASURE.LINK_TEXT)">',
															'{value.MEASURE}',
														'</tpl>',
														'</div></td>',
													'</tpl>',
												'</tpl>',
											'</tr>',
										'</tpl>',
										'</tbody>',
									'</table>',
								'</tpl>',
								'<tpl if="CASE == \'2\'">',
									'<tpl if="!Ext.isEmpty(TABLE_VALUES)">',
										'<div style="font-size: 12px;" class="measuresInnerTable"><table width="100%" cellspacing="0" cellpadding="0" border="0">',
										'<tpl for="TABLE_VALUES">',
													'<td  width="50%"><div style="width:100%" class="measuresInnerTable2"><table border="0" cellpadding="0" cellspacing="0"><col width="50%"><col width="50%">',
														'<tr><td width="50%"><div class="stateSymbol_{STATE}" style="display:inline-block;margin-left:4px;vertical-align:top;"></div><div style="display:inline-block;margin-left:5px;">{MEASURE} {UNIT}</div></td>',
															'<td width="50%">',
																'<tpl if="!Ext.isEmpty(MEASURE_RESULT.LINK_TEXT)">',
																	'<div style="float:left;padding:2px"><a href="javascript:void(0);" onclick="javascript:{MEASURE_RESULT.METHOD_NAME}(\'{MEASURE_RESULT.PARAMS}\')">{MEASURE_RESULT.LINK_TEXT}</a></div>',
																	'<tpl if="!Ext.isEmpty(MEASURE_RESULT.DD)">',
																		'<div class="iconDiagnosis" data-qtip="DIAGNOSIS" data-qclass="yellowTip" style="cursor:pointer;float:right" onclick="javascript:{MEASURE_RESULT.DD.METHOD_NAME}(\'{MEASURE_RESULT.DD.PARAMS}\')"></div>',
																	'</tpl>',
																'</tpl>',
																'</td></tr></table></div></td>',
											'<tpl if="xindex===0">',
												'<tr>',
											'<tpl elseif="xindex%2===0">',
												'</tr><tr>',
											'<tpl elseif="xindex%2!==0 && xindex===xcount">',
												'<td>&nbsp;</td></tr>',
											'</tpl>',
										'</tpl>',
										'</table></div>',
									'<tpl else>',
										'<div style="text-align:center;width:400px;margin:10px auto 10px auto;"><div class="iconInformation" style="margin:0px auto"> </div>'+noMeasures+'</div>',
									'</tpl>',
								'</tpl>',
								'<tpl if="CASE == \'3\'">',
									'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer nowrap darktheme_measure" style="width:100% !important;table-layout: auto;">',
										'<thead>',
											'<tr class="x-grid-row">',
												'<tpl for="GRID_FIELDS">',
													'<th class=" x-grid-cell" width="25%"  style="vertical-align:middle">', 
														'<div class="x-grid-cell-inner" style="overflow:visible;border-bottom:0px !important">{TEXT}</div>',
													'</th>',
												'</tpl>',
											'</tr>',
										'</thead>',
										'<tbody>',
										'<tpl for="GRID_VALUES">',
											'<tr class="x-grid-row">',
												'<tpl exec="this.objectToArray(values)"></tpl>',
												'<tpl for="this.array">',
													'<tpl if="!Ext.isEmpty(value)">',
														'<tpl if="key==\'COLUMN_0\'">',
															'<td class=" x-grid-cell">',
															'<div class="x-grid-cell-inner" >',
															'<tpl if="!Ext.isEmpty(value.INFOS)">',
																'<a href="javascript:void(0)" data-qtip="INFO" data-qclass="yellowTip">',
																'<img style="border:0px;display:inline-block;vertical-align:middle;margin:0px 0px" class="iconRumInfo" data-qclass="yellowTip" src="../images/clear.png" onclick="javascript:openInfoLink(\'{value.INFOS.PARAMS}\')" data-qtip="{value.INFOS.TITLE}"/>',
															'</tpl>',
															'<tpl if="!Ext.isEmpty(value.LINK)">',
																'<img style="vertical-align:middle;margin:0px 2px" src="../images/clear.png" class="stateSymbol_{value.LINK.STATE}" />',
																'<a href="javascript:void(0);" onclick="javascript:{value.LINK.METHOD_NAME}(\'{value.LINK.PARAMS}\')" data-qclass="yellowTip" data-qtip="{value.LINK.LINK_TEXT}">{value.LINK.LINK_TEXT}</a>',
															'<tpl elseif="!Ext.isEmpty(value.TEXT)">',
																'{value.TEXT}',
															'</tpl>',
															'</div>',
															'</td>',
														'<tpl elseif="key!=\'COLUMN_0\'">',
															'<td class="x-grid-cell">',
															'<div class="x-grid-cell-inner" ><img style="vertical-align:middle;margin:0px 2px" src="../images/clear.png" class="stateSymbol_{value.STATE}" />',
															'<tpl if="!Ext.isEmpty(value.MEASURES) && !Ext.isEmpty(value.MEASURES.LINK_TEXT)">',
																'<a href="javascript:void(0);" onclick="javascript:{value.MEASURES.METHOD_NAME}(\'{value.MEASURES.PARAMS}\');">{value.MEASURES.LINK_TEXT}</a>',
																'<tpl if="!Ext.isEmpty(value.MEASURES.DD)">',
																	'<img src="../images/clear.png"  style="vertical-align:middle;margin:0px 2px;cursor:pointer" class="iconDiagnosis" data-qclass="yellowTip" onclick="javascript:{value.MEASURES.DD.METHOD_NAME}(\'{value.MEASURES.DD.PARAMS}\');" data-qtip="{value.MEASURES.DD.TITLE}"/>',
																'</tpl>',
															'<tpl elseif="!Ext.isEmpty(value)">',
																'<a href="javascript:void(0);" onclick="javascript:{value.METHOD_NAME}(\'{value.PARAMS}\')">{value.LINK_TEXT}</a>',
															'</tpl>',
															'</td>',
														'</tpl>',
													'</tpl>',
												'</tpl>',
											'</tr>',
										'</tpl>',
										'</tbody>',
									'</table>',
								'</tpl>',
								'</div>',
							'</td>',
						'</tr>',
					'</table>',
				'</div>',
				'</tpl>',
						{
						prepareParams : function(values)
						{
							this.paramArray=[];
							if(values!=null && values.indexOf("|")>0)
							{
								var param1 = values.substring(0, values.indexOf('|'));
								var param2 = values.substring(values.indexOf('|') + 1);
								this.paramArray.push(param1);
								this.paramArray.push(param2);
							}
						},
						objectToArray: function(values){
							this.array = [];
							for(var key in values){
								if(values.hasOwnProperty(key)){
									if(!Ext.isEmpty(values[key]))
									{
										this.array.push({key: key, value: values[key]});
									}
								}
							}
						}

				}
						),
					itemSelector: 'div.x-table'
					}]
			 });
			resultObj.add(addSubmittedReports);
			resultObj.show();
			resultObj.doLayout();
			datStore=null;
			delete datStore;
			reportTableArr=null;
			delete reportTableArr;
			listFavMeasureData=null;
			delete listFavMeasureData;
			resultData=null;
			delete resultData;
			//addSubmittedReports=null;
		}
		else
		{
			isDataAvailableB4Refresh=false;
			startPosB4Refresh=null;
			var addSubmittedReports = resultObj.add({
					xtype:'panel',
					flex:1,
					//cls:'darkborder_monitor',
					cls:'datapanel',
					title: resultData['title'],
					//width: (Ext.getBody().getViewSize().width-56),
					//height : 426,
					html : '<table width="100%" height="400px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><span style="font-size: 12px;">'+noMeasures+'</span></td></tr></table>'
				});
			resultObj.add(addSubmittedReports);
			resultObj.show();
			resultObj.doLayout();
		}
	},
	hideResult: function()
	{
		//this.getMeasuresdata().hide();
	},
	afterMainRender: function()
	{
		var me = this;
		this.hideResult();
		Ext.getCmp('centerP').setTitle(pageTitle);
		Ext.getCmp('back').setText(backBtnText);
		var mainForm = this.getMeasuresform().getForm();
		var submitObj = Ext.getCmp('submit');
		var ObjectArr = new Array();
		if ( !Ext.isEmpty( screenLabels ) )
		{
			ObjectArr['compType'] = screenLabels['monitor.measures.Component Type'];
			ObjectArr['compName'] = screenLabels['monitor.measures.Component'];
			ObjectArr['State'] = screenLabels['monitor.measures.State'];
			ObjectArr['searchMeasure'] = screenLabels['monitor.measures.Measures'];
			submitObj.setText(screenLabels['monitor.common.Submit']);
			this.loadScreenLabels( mainForm, ObjectArr );
		}

		this.callRemoteScript( mainForm, 'compType', '/final/servlet/com.eg.RemoteScriptingServlet', 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getComponentTypesForSite&P0=no' );
		this.callRemoteScript( mainForm, 'compName', '/final/servlet/com.eg.RemoteScriptingServlet', 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getUserComponents' );
		this.callRemoteScript( mainForm, 'State', '/final/servlet/com.eg.RemoteScriptingServlet', 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getAllStates' );

		if ( !Ext.isEmpty( selectedCompType ) )
		{
			mainForm.findField('compType').setValue(selectedCompType);
		}
		if ( !Ext.isEmpty( selectedComp ) )
		{
			mainForm.findField('compName').setValue(selectedComp);
			var store_data=mainForm.findField('compName').getStore();
			for(var k=0;k<store_data.getCount();k++)
			{
				var vm=store_data.getAt(k).data.valueField;
				if(vm==selectedComp)
				{
					var state=store_data.getAt(k).data.state;
					mainForm.findField('compName').changeselDispField(state);
					break;
				}
			}
		}
		if ( !Ext.isEmpty( selectedState ) )
		{
			mainForm.findField('State').setValue(selectedState);
		}
		if ( !Ext.isEmpty( selectedSearchMeasure ) )
		{
			mainForm.findField('searchMeasure').setValue(selectedSearchMeasure);
		}
		if ( !Ext.isEmpty( isSubmit ) && isSubmit == 'true' )
		{
			initLdgMask.show();
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgMonitorController',
				params: queryString,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );
						var resultData = jsonData['RESULTS'];
						me.showDataView( resultData );
						initLdgMask.hide();
					}
				}
			});
		}
		else if(!Ext.isEmpty(backToMeasrues) && backToMeasrues!=undefined && backToMeasrues!=null && backToMeasrues=='true')
		{
			this.submitForResult();
		}
	},
	callRemoteScript: function( form, fieldName, remoteURL, params )
	{
		var me = this;
		Ext.Ajax.request({
			url: remoteURL,
			method: 'POST',
			async: false,
			params: params,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					form.findField(fieldName).suspendEvents(true);
					form.findField(fieldName).getStore().loadRawData( jsonData );
					form.findField(fieldName).setValue( jsonData[0]['valueField']);
					if ( fieldName == 'State' )
					{
						form.findField(fieldName).getStore().insert(0,{'displayField': otherStates['AllStates'], 'valueField': 'AllStates'});
						form.findField(fieldName).getStore().insert(1,{'displayField': otherStates['Abnormal'], 'valueField': 'Abnormal'});
						form.findField(fieldName).setValue('AllStates');
					}

				form.findField(fieldName).resumeEvents();
				}
			}
		});
	},
	loadScreenLabels: function ( form, ObjectArr )
	{
		var obj = '';
		for ( var key in ObjectArr )
		{
			obj = !Ext.isEmpty(form.findField(key))?form.findField(key):Ext.getCmp(key);
			if ( obj.getXType() != 'label' )
			{
				form.findField(key).setFieldLabel(ObjectArr[key]);
			}
			else
			{
				Ext.getCmp(key).setText(ObjectArr[key]);
			}
		}
	},
	alarmPolicyChange: function()
	{
		var alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicy]
		Ext.getCmp('alarmDispField').setValue(tmpDescription);
	},
	maxStaticFieldChange: function(field){
		var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (maxStaticCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	maxAutoFieldChange: function(field){
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (maxAutoCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	minStaticFieldChange: function(field){
		var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (minStaticCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	minAutoFieldChange: function(field){
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (minAutoCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
    },
	maxStaticCheckChange: function(box, checked)
	{
		//max static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('absMaxCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('absMaxMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('absMaxCritical').setFieldLabel(criticalText);
			Ext.getCmp('absMaxMajor').setFieldLabel(majorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('textfield'), this.maxStaticFieldChange, this);
        Ext.Array.forEach(fieldset.query('textfield'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });

		var isAllMeasureCheck = false;
		var allMeasureCheck = publicJson['applyOtherMeasure_check_box'];
		if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
		{
			isAllMeasureCheck = true;
		}
		if(checked && isAllMeasureCheck)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	maxAutoCheckChange: function(box, checked)
	{
		//max auto block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('relMaxCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('relMaxMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('relMaxCritical').setFieldLabel(autoCriText);
			Ext.getCmp('relMaxMajor').setFieldLabel(autoMajorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.maxAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'maxThreshDisplayField')
			{
			}
			else
			{

				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });

		var isAllMeasureCheck = false;
		var allMeasureCheck = publicJson['applyOtherMeasure_check_box'];
		if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
		{
			isAllMeasureCheck = true;
		}
		if(checked && isAllMeasureCheck)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	minStaticCheckChange: function(box, checked)
	{
		//min static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('absMinCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('absMinMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('absMinCritical').setFieldLabel(criticalText);
			Ext.getCmp('absMinMajor').setFieldLabel(majorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('textfield'), this.minStaticFieldChange, this);
        Ext.Array.forEach(fieldset.query('textfield'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });

		var isAllMeasureCheck = false;
		var allMeasureCheck = publicJson['applyOtherMeasure_check_box'];
		if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
		{
			isAllMeasureCheck = true;
		}
		if(checked && isAllMeasureCheck)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	minAutoCheckChange: function(box, checked)
	{
		//min auto block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('relMinCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('relMinMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('relMinCritical').setFieldLabel(autoCriText);
			Ext.getCmp('relMinMajor').setFieldLabel(autoMajorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'minThreshDisplayField')
			{
			}
			else
			{
				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });

		var isAllMeasureCheck = false;
		var allMeasureCheck = publicJson['applyOtherMeasure_check_box'];
		if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
		{
			isAllMeasureCheck = true;
		}
		if(checked && isAllMeasureCheck)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	//updateData: function ()
	//{
		//var me = this;
		//var flag = this.applyThresholdsData();
		//if (flag)
		//{
			//Ext.Msg.alert(pageName,successAlert1, function (){
				//var mask = null;
				//var wholeViewport = document.getElementsByTagName("body")[0];
				//if(!Ext.isEmpty(Ext.get(wholeViewport))){
					//mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
					//mask.show();
				//}
				//setTimeout(function() {
					//mask.hide();
					//me.getConfigureThresholds().close();
					//me.getTestInfo().close();
					//me.openTestInfoWindow(testInfoGlobalURL);
				//},5000);
				////detailsClicked();
			//});
		//}
	//},
	applyThresholdsData: function()
	{
		var flag = true;
		var v_testname = publicJson['hiddenObj']['testName'];
		if (v_testname == "null")
		{
			flag = false;
			return false;
		}

		var v_measure =  publicJson['hiddenObj']['measure'];
		if (v_measure == "null")
		{
			flag = false;
			return false;
		}

		var v_policy = "mix";
		var minThreshold = "-1";
		var maxThreshold = "-1";
		var v_alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var lastItem = "HML";

		var abs_MinCritical = "-";
		var abs_MinMajor = "-";
		var abs_MinMinor = "-";
		var abs_MinOpt = Ext.getCmp('minStaticCheck').getValue();
		var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
		if (!abs_MinOpt)
		{
			abs_MinCritical = Ext.getCmp('absMinCritical').getValue();
			abs_MinMajor =  Ext.getCmp('absMinMajor').getValue();
			abs_MinMinor =  Ext.getCmp('absMinMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(){
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNonNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinCriticalErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMajorErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMinorErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MinCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinCriticalErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMajorErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMinorErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}

			//check ascending order...
			if (abs_MinCritical != "-" && abs_MinMajor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinMajor != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinMajor) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinCritical != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MinCritical = "-";
		var rel_MinMajor = "-";
		var rel_MinMinor = "-";
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
		if (!minAutoCheck)
		{
			var v_amount_A = Ext.getCmp('relMinCriticalText').getValue();
			if (v_amount_A != 0)
			{
				if (v_amount_A == 100)
				{
					rel_MinCritical = "sqc";
				}
				else
				{
					rel_MinCritical = (v_amount_A/100) + "*sqc";
				}
			}

			var v_amount_B = Ext.getCmp('relMinMajorText').getValue();
			if (v_amount_B != 0)
			{
				if (v_amount_B == 100)
				{
					rel_MinMajor = "sqc";
				}
				else
				{
					rel_MinMajor = (v_amount_B/100) + "*sqc";
				}
			}

			var v_amount_C = Ext.getCmp('relMinMinorText').getValue();
			if (v_amount_C != 0)
			{
				if (v_amount_C == 100)
				{
					rel_MinMinor = "sqc";
				}
				else
				{
					rel_MinMinor = (v_amount_C/100) + "*sqc";
				}
			}

			//check ascending order...
			var relCri,relMaj,relMin;
			relCri = rel_MinCritical;
			relMaj = rel_MinMajor;
			relMin = rel_MinMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMaj))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) >= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MinCritical.indexOf(".") != -1 )
		{
			var abs_MinCriticalDecimal = abs_MinCritical.substring(abs_MinCritical.indexOf(".")+1);
			if(abs_MinCriticalDecimal == "00" || abs_MinCriticalDecimal == "0" )
			{
				abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.indexOf("."));
			}
			else if(abs_MinCriticalDecimal.length > 1)
			{
				if(abs_MinCriticalDecimal.charAt(1) == "0")
				{
					abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMajor.indexOf(".") != -1 )
		{
			var abs_MinMajorDecimal = abs_MinMajor.substring(abs_MinMajor.indexOf(".")+1);
			if(abs_MinMajorDecimal == "00" || abs_MinMajorDecimal == "0")
			{
				abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.indexOf("."));
			}
			else if(abs_MinMajorDecimal.length > 1)
			{
				if(abs_MinMajorDecimal.charAt(1) == "0")
				{
					abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMinor.indexOf(".") != -1 )
		{
			var abs_MinMinorDecimal = abs_MinMinor.substring(abs_MinMinor.indexOf(".")+1);
			if(abs_MinMinorDecimal == "00" || abs_MinMinorDecimal == "0")
			{
				abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.indexOf("."));
			}
			else if(abs_MinMinorDecimal.length > 1)
			{
				if(abs_MinMinorDecimal.charAt(1) == "0")
				{
					abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.lastIndexOf("0"));
				}
			}
		}

		var minCritical = "-";
		if (abs_MinCritical != "-" && rel_MinCritical != "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString() + "&" + rel_MinCritical;
			}
			else
			{
				minCritical = rel_MinCritical;
			}
		}
		else if (abs_MinCritical != "-" && rel_MinCritical == "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString();
			}
			else
			{
				minCritical = "-";
			}
		}
		else if (abs_MinCritical == "-" && rel_MinCritical != "-")
		{
			minCritical = rel_MinCritical;
		}

		var minMajor = "-";
		if (abs_MinMajor != "-" && rel_MinMajor != "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString() + "&" + rel_MinMajor;
			}
			else
			{
				minMajor = rel_MinMajor;
			}
		}
		else if (abs_MinMajor != "-" && rel_MinMajor == "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString();
			}
			else
			{
				minMajor = "-";
			}
		}
		else if (abs_MinMajor == "-" && rel_MinMajor != "-")
		{
			minMajor = rel_MinMajor;
		}

		var minMinor = "-";
		if (abs_MinMinor != "-" && rel_MinMinor != "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString() + "&" + rel_MinMinor;
			}
			else
			{
				minMinor = rel_MinMinor;
			}
		}
		else if (abs_MinMinor != "-" && rel_MinMinor == "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString();
			}
			else
			{
				minMinor = "-";
			}
		}
		else if (abs_MinMinor == "-" && rel_MinMinor != "-")
		{
			minMinor = rel_MinMinor;
		}

		if (minCritical != "-" || minMajor != "-" || minMinor != "-")
		{
			minThreshold = minCritical + "/" + minMajor + "/" + minMinor
		}

		var abs_MaxCritical = "-";
		var abs_MaxMajor = "-";
		var abs_MaxMinor = "-";
		var abs_MaxOpt = Ext.getCmp('maxStaticCheck').getValue();
		if (!abs_MaxOpt)
		{
			abs_MaxCritical = Ext.getCmp('absMaxCritical').getValue();
			abs_MaxMajor =  Ext.getCmp('absMaxMajor').getValue();
			abs_MaxMinor =  Ext.getCmp('absMaxMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxCriticalErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMajorErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMinorErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MaxCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxCriticalErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMajorErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMinorErrMsg1+".\n"+errMsg1+" : \n"+"1) "+errMsg2+".\n"+"2) "+errMsg3+".\n"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}
			//check descending order...
			if (abs_MaxCritical != "-" && abs_MaxMajor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxMajor != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxMajor) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxCritical != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MaxCritical = "-";
		var rel_MaxMajor = "-";
		var rel_MaxMinor = "-";
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
		if (!maxAutoCheck)
		{
			var v_amount_D = Ext.getCmp('relMaxCriticalText').getValue();
			if (v_amount_D != 0)
			{
				if (v_amount_D == 100)
				{
					rel_MaxCritical = "sqc";
				}
				else
				{
					rel_MaxCritical = (v_amount_D/100) + "*sqc";
				}
			}

			var v_amount_E =  Ext.getCmp('relMaxMajorText').getValue();
			if (v_amount_E != 0)
			{
				if (v_amount_E == 100)
				{
					rel_MaxMajor = "sqc";
				}
				else
				{
					rel_MaxMajor = (v_amount_E/100) + "*sqc";
				}
			}

			var v_amount_F = Ext.getCmp('relMaxMinorText').getValue();
			if (v_amount_F != 0)
			{
				if (v_amount_F == 100)
				{
					rel_MaxMinor = "sqc";
				}
				else
				{
					rel_MaxMinor = (v_amount_F/100) + "*sqc";
				}
			}

			//check descending order...
			var relCri,relMaj,relMin;
			relCri = rel_MaxCritical;
			relMaj = rel_MaxMajor;
			relMin = rel_MaxMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMaj))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) <= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MaxCritical.indexOf(".") != -1 )
		{
			var abs_MaxCriticalDecimal = abs_MaxCritical.substring(abs_MaxCritical.indexOf(".")+1);
			if(abs_MaxCriticalDecimal == "00" || abs_MaxCriticalDecimal == "0")
			{
				abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.indexOf("."));
			}
			else if(abs_MaxCriticalDecimal.length > 1)
			{
				if(abs_MaxCriticalDecimal.charAt(1) == "0")
				{
					abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMajor.indexOf(".") != -1 )
		{
			var abs_MaxMajorDecimal = abs_MaxMajor.substring(abs_MaxMajor.indexOf(".")+1);
			if(abs_MaxMajorDecimal == "00" || abs_MaxMajorDecimal == "0")
			{
				abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.indexOf("."));
			}
			else if(abs_MaxMajorDecimal.length > 1)
			{
				if(abs_MaxMajorDecimal.charAt(1) == "0")
				{
					abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMinor.indexOf(".") != -1 )
		{
			var abs_MaxMinorDecimal = abs_MaxMinor.substring(abs_MaxMinor.indexOf(".")+1);
			if(abs_MaxMinorDecimal == "00" || abs_MaxMinorDecimal == "0")
			{
				abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.indexOf("."));
			}
			else if(abs_MaxMinorDecimal.length > 1)
			{
				if(abs_MaxMinorDecimal.charAt(1) == "0")
				{
					abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.lastIndexOf("0"));
				}
			}
		}

		var maxCritical = "-";
		if (abs_MaxCritical != "-" && rel_MaxCritical != "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString() + "&" + rel_MaxCritical;
			}
			else
			{
				maxCritical = rel_MaxCritical;
			}
		}
		else if (abs_MaxCritical != "-" && rel_MaxCritical == "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString();
			}
			else
			{
				maxCritical = "-";
			}
		}
		else if (abs_MaxCritical == "-" && rel_MaxCritical != "-")
		{
			maxCritical = rel_MaxCritical;
		}

		var maxMajor = "-";
		if (abs_MaxMajor != "-" && rel_MaxMajor != "-")
		{
			if(abs_MaxMajor > -1 || abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString() + "&" + rel_MaxMajor;
			}
			else
			{
				maxMajor = rel_MaxMajor;
			}
		}
		else if (abs_MaxMajor != "-" && rel_MaxMajor == "-")
		{
			if(abs_MaxMajor > -1 || + abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString();
			}
			else
			{
				maxMajor = "-";
			}
		}
		else if (abs_MaxMajor == "-" && rel_MaxMajor != "-")
		{
			maxMajor = rel_MaxMajor;
		}

		var maxMinor = "-";
		if (abs_MaxMinor != "-" && rel_MaxMinor != "-")
		{
			if(abs_MaxMinor > -1 || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString() + "&" + rel_MaxMinor;
			}
			else
			{
				maxMinor = rel_MaxMinor;
			}
		}
		else if (abs_MaxMinor != "-" && rel_MaxMinor == "-")
		{
			if(abs_MaxMinor > -1  || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString();
			}
			else
			{
				maxMinor = "-";
			}
		}
		else if (abs_MaxMinor == "-" && rel_MaxMinor != "-")
		{
			maxMinor = rel_MaxMinor;
		}

		if (maxCritical != "-" || maxMajor != "-" || maxMinor != "-")
		{
			maxThreshold = maxCritical + "/" + maxMajor + "/" + maxMinor
		}

		//resultStr = this.updateThresholds(v_testname,v_threshold);
		if (flag)
		{
			var me = this;
			var maskHome = null;
			var wholeViewport = document.getElementsByTagName("body")[0];
			if(!Ext.isEmpty(Ext.get(wholeViewport))){
				maskHome = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
				maskHome.show();
			}

			var v_threshold = v_measure + ":" + v_policy + ":" + minThreshold + ":" + maxThreshold + ":" + v_alarmPolicy + ":" + lastItem;
			var params = '';
			var urlVal = '';
			if (!Ext.isEmpty(threshTypeVar) && threshTypeVar != undefined && threshTypeVar == 'DefaultDescriptor')
			{
				var descVal = publicJson['selectedDescriptor'];
				strDescName = descVal;
				var check = Ext.getCmp('allMeasureCheck').getValue();
				var allMeasVal = "";
				if(check)
				{
					allMeasVal = "true";
				}

				params = "testName="+v_testname+"&descName="+encodeURIComponent(descVal)+"&threshold="+escape(v_threshold)+"&operation=updateThresholds&allMeasure="+allMeasVal;
				urlVal = '/final/admin/DefaultThreshold/data/EgApplyDescThresholds.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;
			}
			else if (!Ext.isEmpty(threshTypeVar) && threshTypeVar != undefined && threshTypeVar == 'Global')
			{
				var compType = publicJson['hiddenObj']['componentType'];
				params = "componentType="+compType+"&testName="+v_testname+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";
				urlVal = '/final/admin/DefaultThreshold/data/EgApplyThresholds.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;
			}
			else if (!Ext.isEmpty(threshTypeVar) && threshTypeVar != undefined && threshTypeVar == 'Group')
			{
				var policyName = publicJson['hiddenObj']['strPolicyName'];
				params = "policyName="+policyName+"&testName="+v_testname+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";
				urlVal = '/final/admin/GroupThreshold/data/EgApplyGroupThresholdsJson.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;
			}
			else 
			{
				var strCompType = '';
				var strCompName = '';
				var strTestName = v_testname;
				var strDescName = '';
				var from = publicJson['hiddenObj']['from'];

				var tmpCompType = publicJson['hiddenObj']['componentType'];
				if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
				{
					strCompType = tmpCompType;
				}
				
				tmpCompName = publicJson['hiddenObj']['componentName'];
				if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
				{
					strCompName = tmpCompName;
				}
				tmpTestName = publicJson['hiddenObj']['testName'];
				if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
				{
					strTestName = tmpTestName;
				}

				tmpDescName = publicJson['hiddenObj']['descriptorName'];
				if (tmpDescName != null && !Ext.isEmpty(tmpDescName))
				{
					strDescName = tmpDescName;
				}

				params = "componentType="+encodeURI(strCompType)+"&componentName="+encodeURI(strCompName)+"&testName="+encodeURIComponent(v_testname)+"&descriptorName="+encodeURIComponent(strDescName)+"&from="+from+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";
				urlVal = '/final/admin/SpecificThreshold/data/EgApplySpecificThresholds.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;

			}
			//return false;
			Ext.Ajax.request({
				url:urlVal,
				method:'POST',
				timeout: 6000000,
				//async: false,
				scope:this,
				success:function(response)
				{
					if (response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						maskHome.hide();
						Ext.Msg.alert(pageName,successAlert1, function (){
							var mask = null;
							var wholeViewport = document.getElementsByTagName("body")[0];
							if(!Ext.isEmpty(Ext.get(wholeViewport))){
								mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
								mask.show();
								
							}
							setTimeout(function() {
								mask.hide();
								me.getConfigureThresholds().close();
								me.getTestInfo().close();
								me.openTestInfoWindow(testInfoGlobalURL);
							},5000);
						});
					}
				},
				failure: function(response)
				{
					maskHome.hide();
					Ext.Msg.show({
						title: pageName,
						msg: 'Updating problem in server side...',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
			});
		}
	},
	maxRelCriticalSlider: function()
	{
		Ext.getCmp('relMaxCriticalText').setValue(Ext.getCmp('relMaxCritical').getValue());
	},
	maxRelMajorSlider: function()
	{
		Ext.getCmp('relMaxMajorText').setValue(Ext.getCmp('relMaxMajor').getValue());
	},
	maxRelMinorSlider: function()
	{
		Ext.getCmp('relMaxMinorText').setValue(Ext.getCmp('relMaxMinor').getValue());
	},
	minRelCriticalSlider: function()
	{
		Ext.getCmp('relMinCriticalText').setValue(Ext.getCmp('relMinCritical').getValue());
	},
	minRelMajorSlider: function()
	{
		Ext.getCmp('relMinMajorText').setValue(Ext.getCmp('relMinMajor').getValue());
	},
	minRelMinorSlider: function()
	{
		Ext.getCmp('relMinMinorText').setValue(Ext.getCmp('relMinMinor').getValue());
	},
	getHiddenFields : function(jsonVal,measureActualVal)
	{
		var hiddenFields = jsonVal[measureActualVal.trim()];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	getHiddenFieldsForMeasure: function(jsonVal,measureActualVal)
	{
		var hiddenFields = jsonVal[measureActualVal.trim()];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
		clearAllThresholdsValues: function()
	{
		Ext.getCmp('minStaticCheck').setValue(true);
		Ext.getCmp('absMinCritical').setValue('-');
		Ext.getCmp('absMinMajor').setValue('-');
		Ext.getCmp('absMinMinor').setValue('-');

		Ext.getCmp('minAutoCheck').setValue(true);
		Ext.getCmp('relMinCritical').setValue(0);
		Ext.getCmp('relMinCriticalText').setValue('0');
		Ext.getCmp('relMinMajor').setValue(0);
		Ext.getCmp('relMinMajorText').setValue('0');
		Ext.getCmp('relMinMinor').setValue(0);
		Ext.getCmp('relMinMinorText').setValue('0');

		Ext.getCmp('maxStaticCheck').setValue(true);
		Ext.getCmp('absMaxCritical').setValue('-');
		Ext.getCmp('absMaxMajor').setValue('-');
		Ext.getCmp('absMaxMinor').setValue('-');

		Ext.getCmp('maxAutoCheck').setValue(true);
		Ext.getCmp('relMaxCritical').setValue(0);
		Ext.getCmp('relMaxCriticalText').setValue('0');
		Ext.getCmp('relMaxMajor').setValue(0);
		Ext.getCmp('relMaxMajorText').setValue('0');
		Ext.getCmp('relMaxMinor').setValue(0);
		Ext.getCmp('relMaxMinorText').setValue('0');
	},
	configureMainRender: function(jsonData,threshType,measureName)
	{
		var me = this;
		var urlVal = '';
		if (!Ext.isEmpty(threshType) && threshType != undefined && threshType == 'DefaultDescriptor')
		{
			var strTestName = jsonData.hiddenObj.strTestName;
			var descName = jsonData.hiddenObj.strDescName;
			var measCount = jsonData.hiddenObj.measCount;
			var hiddenFieldsVal = this.getHiddenFields(jsonData.hiddenDataObj,measureName.trim());
			urlVal = '/final/admin/DefaultThreshold/data/EgConfigureDescThresholdsJson.jsp?testName='+strTestName+'&descName='+descName+'&measCount='+measCount+'&com.eg.CSRF_NONCE='+csrfToken;
			if (!Ext.isEmpty(hiddenFieldsVal))
			{
				urlVal +='&'+hiddenFieldsVal;
			}
		}
		else if (!Ext.isEmpty(threshType) && threshType != undefined && threshType == 'Global')
		{
			var hiddenFieldsVal = this.getHiddenFields(jsonData.hiddenDataObj,measureName.trim());
			urlVal = '/final/admin/DefaultThreshold/data/EgConfigureThresholdsJson.jsp?';
			if (!Ext.isEmpty(hiddenFieldsVal))
			{
				urlVal +=hiddenFieldsVal;
			}
			urlVal = urlVal+'&com.eg.CSRF_NONCE='+csrfToken;
		}
		else if (!Ext.isEmpty(threshType) && threshType != undefined && threshType == 'Group')
		{
			var strCompType = jsonData.hiddenObj.server;
			var strCompName = jsonData.hiddenObj.component;
			var strTestName = jsonData.hiddenObj.testName;

			var hiddenFieldsVal = this.getHiddenFieldsForMeasure(jsonData.hiddenDataObj,measureName.trim());
			urlVal =  '/final/admin/GroupThreshold/data/EgConfigureGroupThresholdsJson.jsp?specthreshpage=yes&testName='+strTestName+'&strServer='+strCompType+'&component='+strCompName+'&comeFrom=admin'+'&com.eg.CSRF_NONCE='+csrfToken;
			if (!Ext.isEmpty(hiddenFieldsVal))
			{
				urlVal += '&'+hiddenFieldsVal;
			}
		}
		else 
		{
			params = '';
			var qStr = '';
			var strCompType = jsonData.hiddenObj.componentType;
			var strCompName = jsonData.hiddenObj.componentName;
			var strTestName = jsonData.hiddenObj.testName;
			var strDescName = jsonData.hiddenObj.descriptorName;
			var isRefine = jsonData.hiddenObj.isRefine;
			var comeFrom = jsonData.hiddenObj.comeFrom;

			if (!Ext.isEmpty(strCompType) && strCompType != undefined)
			{
				qStr = 'componentType='+strCompType+'&server='+strCompType;
			}
			if (!Ext.isEmpty(strCompName) && strCompName != undefined)
			{
				qStr += '&componentName='+encodeURIComponent(strCompName);
			}
			if (!Ext.isEmpty(strTestName) && strTestName != undefined)
			{
				qStr += '&testName='+strTestName;
			}
			if ( !Ext.isEmpty(strDescName) && strDescName != undefined)
			{
				qStr += '&descriptorName='+encodeURIComponent(strDescName);
			}
			if (!Ext.isEmpty(threshType) && threshType != undefined)
			{
				if (threshType == 'Specific' || threshType == 'Descriptor')
				{
					qStr += '&from=specificTest';
				}
				else
				{
					qStr += '&from=defaultTest';
				}
				
			}
			if (!Ext.isEmpty(isRefine) && isRefine != undefined)
			{
				qStr += '&isRefine='+isRefine;
			}
			if (!Ext.isEmpty(comeFrom) && comeFrom != undefined)
			{
				qStr += '&comeFrom='+comeFrom;
			}
			
			if (qStr != null && qStr.length > 0)
			{
				params = qStr;
			}
			urlVal = '/final/admin/SpecificThreshold/data/EgConfigureSpecificThresholdsJson.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;
			var hiddenFieldsVal = this.getHiddenFields(jsonData.hiddenDataObj,measureName.trim());
			if (!Ext.isEmpty(hiddenFieldsVal))
			{
				urlVal +='&'+hiddenFieldsVal;
			}
		}
		
		Ext.Ajax.request({
			url:urlVal,
			method:'POST',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				me.getConfigureThresholds().show();
				var testDescription =  '';
				if (threshType == 'Specific' || threshType == 'Descriptor' || threshType == 'Default')
				{
					testDescription = publicJson['screenLabels']['disp_title'];
				}
				else
				{
					testDescription = publicJson['screenLabels']['test_description'];
				}
				me.clearAllThresholdsValues();
				if (Ext.getCmp('allMeasureContainer').isVisible())
				{
					Ext.getCmp('allMeasureContainer').hide();
				}
				var descComp = Ext.getCmp('testDescriptionId');
				var alarmPolicyCombo = publicJson['alarmPolicyArr'];
				var minThreshObj = publicJson['minThreshObj'];
				var maxThreshObj = publicJson['maxThreshObj'];
				var selectAlarm = publicJson['selectedAlarmType'];
				var selectedAlarmDescription = publicJson['selectedAlarmDescription'];
				var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
				var isGlobalThresholds = publicJson['isGlobalThresholds'];
				if(isGlobalThresholds)
				{
					Ext.getCmp('minAutoCheck').hide();
					Ext.getCmp('minAutoFieldContainer').hide();
					Ext.getCmp('maxAutoCheck').hide();
					Ext.getCmp('maxAutoFieldContainer').hide();
				}

				var toolTipMsg = publicJson.isToolTip;

				var minStaticOption = minThreshObj.minStaticOption;
				var minStaticBlock = minThreshObj.minStaticBlock;
				if(minStaticOption != null && !Ext.isEmpty(minStaticOption) && minStaticOption == 'selected')
				{
					//min static block specific description for BusinessTransTest,KBusinessTransTest
					if (toolTipMsg)
					{
						Ext.getCmp('absMinCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						Ext.getCmp('absMinMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
					}
					else
					{
						Ext.getCmp('absMinCritical').setFieldLabel(criticalText);
						Ext.getCmp('absMinMajor').setFieldLabel(majorText);
					}

					var absMinCritical = minThreshObj.absMinCritical;
					var absMinMajor = minThreshObj.absMinMajor;
					var absMinMinor = minThreshObj.absMinMinor;
					Ext.getCmp('minStaticCheck').setValue(false);
					Ext.getCmp('absMinCritical').setValue(absMinCritical);
					Ext.getCmp('absMinMajor').setValue(absMinMajor);
					Ext.getCmp('absMinMinor').setValue(absMinMinor);
					
				}
				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var minAutomaticOption = minThreshObj.minAutomaticOption;
						var minAutomaticBlock = minThreshObj.minAutomaticBlock;
						Ext.getCmp('minAutoCheck').show();
						Ext.getCmp('minAutoFieldContainer').show();
						if (minAutomaticOption != null && !Ext.isEmpty(minAutomaticOption) && minAutomaticOption == 'selected')
						{
							var relMinCritical = minThreshObj.relMinCritical;
							var relMinMajor = minThreshObj.relMinMajor;
							var relMinMinor = minThreshObj.relMinMinor;
							//Ext.getCmp('minAutoCheck').show();
							//Ext.getCmp('minAutoFieldContainer').show();
							Ext.getCmp('minAutoCheck').setValue(false);
							Ext.getCmp('relMinCritical').setValue(relMinCritical);
							Ext.getCmp('relMinCriticalText').setValue(relMinCritical);
							Ext.getCmp('relMinMajor').setValue(relMinMajor);
							Ext.getCmp('relMinMajorText').setValue(relMinMajor);
							Ext.getCmp('relMinMinor').setValue(relMinMinor);
							Ext.getCmp('relMinMinorText').setValue(relMinMinor);

							if (toolTipMsg)
							{
								Ext.getCmp('relMinCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
								Ext.getCmp('relMinMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
							}
							else
							{
								Ext.getCmp('relMinCritical').setFieldLabel(autoCriText);
								Ext.getCmp('relMinMajor').setFieldLabel(autoMajorText);
							}
						}
					}
				}

				var maxStaticOption = maxThreshObj.maxStaticOption;
				var maxStaticBlock = maxThreshObj.maxStaticBlock;
				if (maxStaticOption != null && !Ext.isEmpty(maxStaticOption) && maxStaticOption == 'selected')
				{
					//max static block specific description for BusinessTransTest,KBusinessTransTest
					if (toolTipMsg)
					{
						Ext.getCmp('absMaxCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						Ext.getCmp('absMaxMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
					}
					else
					{
						Ext.getCmp('absMaxCritical').setFieldLabel(criticalText);
						Ext.getCmp('absMaxMajor').setFieldLabel(majorText);
					}

					var absMaxCritical = maxThreshObj.absMaxCritical;
					var absMaxMajor = maxThreshObj.absMaxMajor;
					var absMaxMinor = maxThreshObj.absMaxMinor;
					Ext.getCmp('maxStaticCheck').setValue(false);
					Ext.getCmp('absMaxCritical').setValue(absMaxCritical);
					Ext.getCmp('absMaxMajor').setValue(absMaxMajor);
					Ext.getCmp('absMaxMinor').setValue(absMaxMinor);
					
				}

				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var maxAutomaticOption = maxThreshObj.maxAutomaticOption;
						var maxAutomaticBlock = maxThreshObj.maxAutomaticBlock;
						Ext.getCmp('maxAutoCheck').show();
						Ext.getCmp('maxAutoFieldContainer').show();
						if (maxAutomaticOption != null && !Ext.isEmpty(maxAutomaticOption) && maxAutomaticOption == 'selected')
						{
							var relMaxCritical = maxThreshObj.relMaxCritical;
							var relMaxMajor = maxThreshObj.relMaxMajor;
							var relMaxMinor = maxThreshObj.relMaxMinor;
							//Ext.getCmp('maxAutoCheck').show();
							//Ext.getCmp('maxAutoFieldContainer').show();
							Ext.getCmp('maxAutoCheck').setValue(false);
							Ext.getCmp('relMaxCritical').setValue(relMaxCritical);
							Ext.getCmp('relMaxCriticalText').setValue(relMaxCritical);
							Ext.getCmp('relMaxMajor').setValue(relMaxMajor);
							Ext.getCmp('relMaxMajorText').setValue(relMaxMajor);
							Ext.getCmp('relMaxMinor').setValue(relMaxMinor);
							Ext.getCmp('relMaxMinorText').setValue(relMaxMinor);

							if (toolTipMsg)
							{
								Ext.getCmp('relMaxCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
								Ext.getCmp('relMaxMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
							}
							else
							{
								Ext.getCmp('relMaxCritical').setFieldLabel(autoCriText);
								Ext.getCmp('relMaxMajor').setFieldLabel(autoMajorText);
							}
						}
					}
				}
				var isHostTest = publicJson['isHostTest'];
				descComp.update('<center>'+testDescription+'</center>');
				var alarmDispField = Ext.getCmp('alarmDispField');
				var alarmCombo = Ext.getCmp('alarmPolicyCombo');
				if(alarmPolicyCombo != null && !Ext.isEmpty(alarmPolicyCombo))
				{
					alarmDispField.el.animate({opacity: 1});
					alarmCombo.getStore().suspendEvents(true);
					alarmCombo.getStore().removeAll();
					alarmCombo.getStore().loadRawData(alarmPolicyCombo);
					alarmCombo.getStore().resumeEvents();

					if (selectAlarm != null && !Ext.isEmpty(selectAlarm))
					{
						alarmCombo.setValue(selectAlarm);
					}
					else
					{
						//selectAlarm = alarmPolicyCombo[0].valueField;
						alarmCombo.setValue(alarmPolicyCombo[0].valueField);
					}
					if (selectedAlarmDescription != null && !Ext.isEmpty(selectedAlarmDescription))
					{
						//alarmDispField.el.update(selectedAlarmDescription);
						alarmDispField.setValue(selectedAlarmDescription);
					}
					else
					{
						var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicyCombo[0].valueField]
						//alarmDispField.el.update(tmpDescription);
						alarmDispField.setValue(tmpDescription);
					}
				}
				var isShowAllMeasureCheckBox = publicJson['applyOtherMeasure_check_box'];
				if (!Ext.isEmpty(isShowAllMeasureCheckBox) && isShowAllMeasureCheckBox != undefined && isShowAllMeasureCheckBox == 'true')
				{
					var allMeasureCheck = publicJson['allMeasureCheck'];
					if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
					{
						Ext.getCmp('allMeasureContainer').show();
					}
				}
			},
			failure: function()
			{
			}
		});
	},
	createTableViewForThreshold:function(){
		/*
		* Used arguments concept of javascript function
		* It is done so to accept any number of arguments for the function
		* so that this function can be globally used to create dynamic table of any size
		*/
		var headers = Array.prototype.slice.call(arguments);
		var bodyData = headers.pop();

		var table = '<div class="x-table-outer-border"><div class="x-table" style="margin:0 0 0px 0"><table style="table-layout:auto" class="x-grid-table" cellspacing="0" cellpadding="0" border="0" ><col width="1354"><thead ><tr class="x-grid-row">';
		for(h=0;h<headers.length;h++)
		{
			if (!Ext.isEmpty(headers[h]))
			{
				table += '<th class=" x-grid-cell"><div class="x-grid-cell-inner" >'+headers[h]+'</div></th>';
			}
		}
		table += '</tr></thead>';

		table += '<tbody>';

		if(typeof bodyData == 'string'){
			table += '<tr class="x-grid-row"><td class=" x-grid-cell"><div class="x-grid-cell-inner" style="white-space:nowrap!important">'+bodyData+'</div></td></tr>';
		}
		else if(!Ext.isEmpty(bodyData)){
			for( p = 0; p < bodyData.length; p++){
				var data = bodyData[p];
				var keys = [];
				for (var key in data) {
					keys.push(key);
				}
				table += '<tr class="x-grid-row">';
				for(q = 0; q < keys.length; q++){
					table += '<td class=" x-grid-cell"><div class="x-grid-cell-inner" style="white-space:nowrap!important">'+data[keys[q]]+'</div></td>';
				}
				table += '</tr>';
			}
		}
		else
			return false;
		table += '</tbody></table></div></div>';
		var container = {
			xtype:'container',
			padding:0,
			margin:'0 0 10 0',
			html:table
		};
		return container;
	}
});