Ext.define('microsoftDashboard.controller.Main', {
    extend: 'Ext.app.Controller',
	requires: [
        'microsoftDashboard.view.Main',
        'microsoftDashboard.view.DashboardMenu',        
        'microsoftDashboard.view.office365.OverviewPage',      
        'microsoftDashboard.view.office365.ServiceHealthPage',        
        'microsoftDashboard.view.office365.LicenseUsagePage',        
        'microsoftDashboard.view.office365.UsersGroupsPage',        
        'microsoftDashboard.view.office365.ServiceUsagePage',   
		'microsoftDashboard.view.exchangeonline.OverviewPage',
		'microsoftDashboard.view.exchangeonline.UserviewPage',
		'microsoftDashboard.view.exchangeonline.MailTrafficPage',
		'microsoftDashboard.view.exchangeonline.MailProtectPage',
		'microsoftDashboard.view.exchangeonline.NonOwnerActivityPage',
		'microsoftDashboard.view.sharepointonline.OverviewPage',
		'microsoftDashboard.view.sharepointonline.UsagePage',
		'microsoftDashboard.view.365AlarmDetailsDashboard.ContainerPage'
    ],
	refs:[
	{
		ref: 'main',
		selector: 'main'
	},{
		ref: 'dashboardmenu',
		selector: 'dashboardmenu'
	}],
    init: function() {
		setInterval("execute()",refreshFrequency);
		this.control(
		{
            'dashboardmenu': {
                viewready: this.menuOnLoad,
                itemclick: this.menuItemClick
            },
			'main button[id="backButton"]':
			{
				'click': this.goBack
			},
		});
	},
	goBack: function()
	{
		var fromHome =requestParams.isFromHomepage;
		var fromMenu = requestParams.isFromMenu;
		var fromList = requestParams.isFromList;

		if(fromHome && fromList)
		{
			document.location='/final/servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&action=componentType&searchIndComps=true&viewId=components&viewTreeTitle=Component&componentType='+requestParams.dashboardCompType+'&fromPageView=Home&filterBy=Component&msDashboardLink=true';
		}
		else if(fromList && fromMenu)
		{
			document.location='/final/servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&action=componentType&searchIndComps=true&viewId=components&viewTreeTitle=Component&componentType='+requestParams.dashboardCompType+'&fromMenu=true&filterBy=Component&msDashboardLink=true';
		}
		else if(fromHome)
		{
			document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
		}
		else
			window.history.go(-1);

	},
	menuItemClick: function(cmp, record, item, index, e, eOpts) {
		try
		{
			var recordName=record.get('id');
			
			if(recordName == "Unclickable_Sub_View")
				return;			
		}
		catch (w)
		{
		}
		var me = this,
		innerCard = me.getMain().getComponent('microsoft_ground').getComponent('cardID');

		requestParams.selectedTab = record.get('id');
		requestParams.dashboard = record.get('type');
		setSession(requestParams.selectedTab,requestParams.dashboard);
		if (!Ext.isEmpty(innerCard)) {
			innerCard.stopAnimation( );
			innerCard.animate({
			duration: 500,
			to: {
				'opacity': 0
			},

			listeners: {
				afteranimate: function() {
					//@ get the record from menu 
					requestParams.selectedTab = record.get('id');
					requestParams.dashboard = record.get('type');
					me.addPage(record.get('id'),record.get('type'));					
				}
			},
			scope: me.getMain()
			});
		}
	},
	menuOnLoad: function(cmp) {
		var cmp = this.getDashboardmenu(),
		cmpEl = this.getDashboardmenu().el,
		store = this.getDashboardmenu().store,
		selectedRecord = store.findRecord("type",requestParams.dashboard,0, false, true, true),
		selectedIndex =  store.indexOf(selectedRecord);
		this.addPage(requestParams.selectedTab,requestParams.dashboard);
		setSession(requestParams.selectedTab,requestParams.dashboard);
		cmp.selectMenuonLoad(selectedIndex,requestParams.selectedTab,requestParams.dashboard);
		
		/*this.getMain().addTool(
		{
			xtype:'button',
			id:'backButton',
			margin:0,
			padding:0,
			cls:'backbutton',
			iconCls:'iconBackArrow',
			text:'Back'
		});*/
	},
	updatePage: function()
	{
		var me = this;
		if(requestParams.selectedTab != undefined && requestParams.selectedTab != null )
		{
			var seltab = requestParams.selectedTab;
			var compType = requestParams.dashboard;
			var comboTime = "";
			try
			{
				comboTime = Ext.getCmp("serviceProvisionGrid_combo").getValue();
			}
			catch (e)
			{
				comboTime = "";
			}
			var accountValue = Ext.getCmp('dashTypeComId').getValue();
			
			var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?isFrom=msdashboard&iniName=eg_msdashboard&userBased=true&fromMenu=true&showConfig=true&dashboard_name="+compType+"&selectedTab="+seltab+"&time_line=2%20days&comboTimeLine="+comboTime+"&isRefresh=true&accountValue="+accountValue;
			Ext.getBody().mask('Loading...');
			Ext.Ajax.request({
				url : tabUrl,
				method : 'POST',
				//params:params,
				scope:this,
				timeout:280000,
				success : function(response, opts)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if(seltab != null && seltab === "overview_view")
					{					
						me.updateOverviewPage(jsonData);
						Ext.getBody().unmask();
					}
					else if(seltab != null && seltab === "service_health_view")
					{					
						me.updateServiceHealthPage(jsonData);
						Ext.getBody().unmask();
					}
					else if(seltab != null && seltab === "license_usage_view")
					{					
						me.updateLicenseUsagePage(jsonData);
						Ext.getBody().unmask();
					}
					else if(seltab != null && seltab === "users_group_view")
					{					
						me.updateUsersGroupsPage(jsonData);
						Ext.getBody().unmask();
					}
					else if(seltab != null && seltab === "service_usage_view")
					{					
						me.updateServiceUsagePage(jsonData);
						Ext.getBody().unmask();
					}		
					else if(seltab != null && seltab === "users_view")
					{					
						me.updateUserViewPage(jsonData);
						Ext.getBody().unmask();
					}
					else if(seltab != null && seltab === "mail_traffic_view")
					{					
						me.updateMailTrafficPage(jsonData);
						Ext.getBody().unmask();
					}					
					else if(seltab != null && seltab === "mail_protection_view")
					{					
						me.updateMailProtectionPage(jsonData);
						Ext.getBody().unmask();
					}					
					else if(seltab != null && seltab === "non_owner_activities_view")
					{					
						me.updateNonOwnerActivitiesPage(jsonData);
						Ext.getBody().unmask();
					}					
					else if(seltab != null && seltab === "usage_view")
					{					
						me.updateUsagePage(jsonData);
						Ext.getBody().unmask();
					}
					else if(seltab != null && seltab === "All_Events")
					{					
						me.updateallEventsPage(jsonData);
						Ext.getBody().unmask();
					}
					Ext.getBody().unmask();
				},
				failure:function(){
					Ext.getBody().unmask();
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});		

		}
	},
	addPage: function(menuItem,compType) {
		var me = this,
		card = Ext.getCmp('microsoft_ground');
        // @ destroy all the objects in the card
        for (var i = 0; i < Ext.getCmp('microsoft_ground').items.items[0].items.items.length; i++) {
            Ext.destroy(card.items.items[0].items.items[i])
        }
        card.removeAll(true);
		/*var params = this.getDefaultParams();
		params +='&action=loadViewData';
		
		
		var menuObj = Ext.getCmp('dashmenu_model_id');
		var forceClickKey ;
		var dispInfo ;
		var cnCombo ;
		var isFromForceClick = false;
		if(menuObj != undefined && menuObj != null )
		{
			forceClickKey = menuObj.forceClickKey;
			dispInfo = menuObj.dispInfo;
			cnCombo = menuObj.cnCombo;
			if(forceClickKey != undefined && forceClickKey != null && cnCombo != undefined && cnCombo != null )
			{
				params +='&isRefresh=true';
				params +='&viewName=region';
				params +='&filterNameRaw='+dispInfo;
				params +='&filterName='+forceClickKey;
				isFromForceClick = true;
			}
		}*/
		//var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?isFrom=msdashboard&iniName=eg_msdashboard&userBased=true&fromMenu=true&showConfig=true&dashboard_name=MS365_Dashboard&selectedTab=overview_view&time_line=2%20months";
		var accountValue = Ext.getCmp('dashTypeComId').getValue();		
		var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?isFrom=msdashboard&iniName=eg_msdashboard&userBased=true&fromMenu=true&showConfig=true&dashboard_name="+compType+"&selectedTab="+menuItem+"&time_line=2%20days&accountValue="+accountValue;
		Ext.getBody().mask('Loading...');
		Ext.Ajax.request({
			url : tabUrl,
			method : 'POST',
			//params:params,
			scope:this,
			timeout:280000,
			success : function(response, opts)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				
				if(menuItem != null && menuItem === "overview_view")
				{					
					me.addOverviewPage(jsonData,card,compType);
					Ext.getBody().unmask();
				
				}
				else if(menuItem != null && menuItem === "service_health_view")
				{					
					me.addServiceHealthPage(jsonData,card,compType);
					Ext.getBody().unmask();
				}
				else if(menuItem != null && menuItem === "license_usage_view")
				{					
					me.addLicenseUsagePage(jsonData,card,compType);
					Ext.getBody().unmask();
				}
				else if(menuItem != null && menuItem === "users_group_view")
				{					
					me.addUsersGroupsPage(jsonData,card,compType);
					Ext.getBody().unmask();
				}
				else if(menuItem != null && menuItem === "service_usage_view")
				{					
					me.addServiceUsagePage(jsonData,card,compType);
					Ext.getBody().unmask();
				}					
				else if(menuItem != null && menuItem === "users_view")
				{					
					me.addUserViewPage(jsonData,card,compType);
					Ext.getBody().unmask();
				}					
				else if(menuItem != null && menuItem === "mail_traffic_view")
				{				
					me.addMailTrafficPage(jsonData,card,compType);
					Ext.getBody().unmask();
				}					
				else if(menuItem != null && menuItem === "mail_protection_view")
				{				
					me.addMailProtectionPage(jsonData,card,compType);
					Ext.getBody().unmask();
				}					
				else if(menuItem != null && menuItem === "non_owner_activities_view")
				{					
					me.addNonOwnerActivitiesPage(jsonData,card,compType);
					Ext.getBody().unmask();
				}					
				else if(menuItem != null && menuItem === "usage_view")
				{					
					me.addUsagePage(jsonData,card,compType);
					Ext.getBody().unmask();
				}					
				else if(menuItem != null && menuItem === "All_Events")
				{					
					me.addallEventsPage(jsonData,card,compType);
					Ext.getBody().unmask();
				}					
				Ext.getBody().unmask();
			},
			failure:function(){
				Ext.getBody().unmask();
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});		
		
		//return;        
        //card.doLayout();
    }, 
	addOverviewPage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');
		var xtypeText = compType+'.overviewpage';
		
		card.add({
			xtype: 'cardItem',
			id: "cardID",			
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,						
						id:'overviewpage',
						data:jsonData.loadViewDetails						
					});
				}
			}
		});
		card.doLayout();
	},
	updateOverviewPage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('overviewpage').updatePage(jsonData.loadViewDetails);
	},
	addServiceHealthPage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');

		var xtypeText = compType+'.servicehealthpage';

		card.add({
			xtype: 'cardItem',
			id: "cardID",
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,
						id:'servicehealthpage',
						data:jsonData.loadViewDetails
					});
				}
			}
		});
		card.doLayout();
	},
	updateServiceHealthPage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('servicehealthpage').updatePage(jsonData.loadViewDetails);
	},
	addLicenseUsagePage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');

		var xtypeText = compType+'.licenseusagepage';

		card.add({
			xtype: 'container',
			id: "cardID",
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,
						id:'licenseusagepage',
						data:jsonData.loadViewDetails
					});
				}
			}
		});
		card.doLayout();
	},
	updateLicenseUsagePage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('licenseusagepage').updatePage(jsonData.loadViewDetails);
	},
	addUsersGroupsPage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');

		var xtypeText = compType+'.usersgroupspage';

		card.add({
			xtype: 'cardItem',
			id: "cardID",
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,
						id:'usersgroupspage',
						data:jsonData.loadViewDetails
					});
				}
			}
		});
		card.doLayout();
	},
	updateUsersGroupsPage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('usersgroupspage').updatePage(jsonData.loadViewDetails);
	},
	addServiceUsagePage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');

		var xtypeText = compType+'.serviceusagepage';

		card.add({
			xtype: 'cardItem',
			id: "cardID",
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,
						id:'serviceusagepage',
						data:jsonData.loadViewDetails
					});
				}
			}
		});
		card.doLayout();
	},
	updateServiceUsagePage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('serviceusagepage').updatePage(jsonData.loadViewDetails);
	},
	addUserViewPage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');

		var xtypeText = compType+'.userviewpage';

		card.add({
			xtype: 'cardItem',
			id: "cardID",
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,
						id:'userviewpage',
						data:jsonData.loadViewDetails
					});
				}
			}
		});
		card.doLayout();
	},
	updateUserViewPage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('userviewpage').updatePage(jsonData.loadViewDetails);
	},
	addMailTrafficPage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');

		var xtypeText = compType+'.mailtrafficpage';

		card.add({
			xtype: 'cardItem',
			id: "cardID",
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,
						id:'mailtrafficpage',
						data:jsonData.loadViewDetails
					});
				}
			}
		});
		card.doLayout();
	},
	updateMailTrafficPage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('mailtrafficpage').updatePage(jsonData.loadViewDetails);
	},
	addMailProtectionPage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');

		var xtypeText = compType+'.mailprotectpage';

		card.add({
			xtype: 'cardItem',
			id: "cardID",
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,
						id:'mailprotectpage',
						data:jsonData.loadViewDetails
					});
				}
			}
		});
		card.doLayout();
	},
	updateMailProtectionPage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('mailprotectpage').updatePage(jsonData.loadViewDetails);
	},
	addNonOwnerActivitiesPage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');

		var xtypeText = compType+'.nonowneractivitiypage';

		card.add({
			xtype: 'cardItem',
			id: "cardID",
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,
						id:'nonowneractivitiypage',
						data:jsonData.loadViewDetails
					});
				}
			}
		});
		card.doLayout();
	},
	updateNonOwnerActivitiesPage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('nonowneractivitiypage').updatePage(jsonData.loadViewDetails);
	},
	addUsagePage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');

		var xtypeText = compType+'.usagepage';

		card.add({
			xtype: 'cardItem',
			id: "cardID",
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,
						id:'usagepage',
						data:jsonData.loadViewDetails
					});
				}
			}
		});
		card.doLayout();
	},
	updateUsagePage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('usagepage').updatePage(jsonData.loadViewDetails);
	},
	addallEventsPage:function(jsonData,card,compType)
	{
		var me = this,
		card = Ext.getCmp('microsoft_ground');

		var xtypeText = compType+'.containerpage';

		card.add({
			xtype: 'cardItem',
			id: "cardID",
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:xtypeText,
						flex:1,
						id:'containerpage',
						data:jsonData.loadViewDetails
					});
				}
			}
		});
		card.doLayout();
	},
	updateallEventsPage:function(jsonData)
	{
		var me = this;
		Ext.getCmp('containerpage').updatePage(jsonData.loadViewDetails);
	}
});