Ext.define('DashMenuModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'menu_iconCls', type:'string' },
        { name:'caption', type:'string' },
        { name:'captionTitle', type:'string' },
        { name:'userExpText', type:'string' },
        { name:'type', type:'string' },
        { name:'name', type:'string' },
        { name:'children' }
    ]
});

Ext.create('Ext.data.Store', {
    id:'dashmenu_model_id',
    model: 'DashMenuModel',
	autoLoad:true,
	data:dashInfo.tabArray	
});

var dashMenuTpl_new = new Ext.XTemplate(
	'<ul>',
    '<tpl for=".">',
    	'<li class="menu-wrap-new" id="list-{#}">',
			'<div class="">',
				'<div>',
					'<div class="menu_icon" style="width:58px;display:inline-block;vertical-align:top;text-align:center;float:left">',
						'<div><img src="/final/images/clear.png" class="{menu_iconCls}"/></div>',
						'<div  class="caption f9-normal" style="width: 40px;text-align: center;white-space:normal"><span>{captionTitle}</span></div>',
					'</div>',					
					'<dl class="menu_holder">',
					  '<dt class="menu_title f12-normal" style="margin:5px 0px 10px 0px">{captionTitle}</dt>',
					  '<dl class="menu-children">',
					  '<tpl for="children">',
							'<dt style="margin:0px 0px 5px 0px;padding:3px 0 3px 0" class="children f11-normal" id="{id}" parentId={parent.id} view={type}>{captionTitle}</dt>',
						'</tpl>',
					  '</dl>',
					'</dl>',
				'</div>',
			'</div>',
		'</li>',
    '</tpl>',
	'</ul>'
);

Ext.define('microsoftDashboard.view.DashboardMenu', {
	extend:'Ext.view.View',
	ui:'ms-menu-view',
	//ui:'eg-menu-view',
	alias:'widget.dashboardmenu',
	id:'dashmenu_model_id',
	store: Ext.data.StoreManager.lookup('dashmenu_model_id'),
	//tpl: dashMenuTpl,
	tpl: dashMenuTpl_new,
	trackOver :true,
	overItemCls:'ms-menu-view-over',
	overCls : 'ms-menu-con-over',
    itemSelector: 'li.menu-wrap-new',
    emptyText: '',
	listeners: {
		viewready:function(view){	
		
		},
		render:function(view, record, item, index, e, eOpts){
					
		},
		itemclick: function(view, record, item, index, e, eOpts) {
			try
			{
				var selectedItem =  e.getTarget('.x-item-selected');
				var target = e.target;
				
				if(!selectedItem){
					//case not select menu
				}else{
					if(target.className === 'children'){
						Ext.fly(target).set({"selectedTab": index});
					}
					return false;
				}  
			}
			catch (e)
			{
			}
			                  
		},
		el: {
			 delegate: 'dt.children',
			 click: function(view, a) {
				
				var id = Ext.fly(a).getAttribute('id'),
				view = Ext.fly(a).getAttribute('view'),			
				selectedTab = Ext.fly(a).getAttribute('view'),
				selectedRecord = Ext.getCmp('dashmenu_model_id').getSelectionModel().getSelection()[0];
				selectedIndex= 	Ext.getCmp('dashmenu_model_id').store.indexOf(selectedRecord);
				microsoftDashboard.app.getController('Main').addPage(id,view);
				//adding sub menu class
				Ext.select('.children').removeCls('selected');
				Ext.get('list-'+(selectedIndex+1)).select('#'+id).radioCls('selected');
				requestParams.selectedTab = id;
				requestParams.dashboard = view;
				setSession(requestParams.selectedTab,requestParams.dashboard);
			 }
		},
		
	},
	selectMenuonLoad:function(indexVal,tab,type){
		var me = this;
		
		try
		{
			me.getSelectionModel().select(indexVal);
			//removing sub menu class
			var menuObj = Ext.getCmp('dashmenu_model_id');
			var store_data=menuObj.getStore();
			var viewArray;
			for(var k=0;k<store_data.getCount();k++)
			{
				for(var c=0;c<store_data.data.items.length;c++)
				{
					if(store_data.data.items[c].data.type == type)
					{
						viewArray = store_data.data.items[c].data.children;			
					}
				}		
			}
			for(var b=0;b<viewArray.length;b++)
			{
				Ext.get('list-'+(indexVal+1)).select('#'+viewArray[b].id).removeCls('selected');				
			}

			//adding sub menu class
			Ext.get('list-'+(indexVal+1)).select('#'+tab).addCls('selected');
		}
		catch (ert)
		{
			//Ext.getCmp('cardID').update('<div style="display:table;height:100%;width:100%;" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>Entries not yet configured!</div></div></div>');			
		}
		
	},
	stopAnimationFn:function(){
		var me = this, meEl = Ext.get(me.id);
		meEl.on('afteranimate', function() {
			meEl.stopAnimation();
		});
	}
});