Ext.define('microsoftDashboard.view.Viewport', {
	extend: 'Ext.container.Viewport',
	alias : 'widget.viewport',
	layout: 'fit',
	requires: ['microsoftDashboard.view.Main'],
	initComponent: function() {
		var viewport = this;
		viewport.items = [{
			xtype: 'main',
			dockedItems:[{
				xtype:'toolbar',
				id:'mainview_tbar_Id',
				cls:'headerToolbar',
				padding:'5',
				items:[
				{
					xtype:'tbtext',
					text:'OFFICE 365 DASHBOARD',
					cls:'f15-bold',
					style:{'font-weight':'bold !important'},
					textAlign:'left'
				},
				{
					xtype: 'tbfill',
					width:30
				},
				{
					xtype: 'combo',
					fieldLabel:'Tenant',
					cls:'dropdown',
					labelSeparator:'',
					width:250,
					labelWidth:50,
					editable:false,
					hidden:false,
					name:'dashTypeComId',
					id:'dashTypeComId',
					margin:"0 10 0 0",
					displayField : 'name',
					valueField : 'value',
					queryMode : 'local',
					store:Ext.create('Ext.data.Store',{
						data : requestParams.accComboObj.accountCombo,
						fields:['name','value'],
					}),
					value:requestParams.accComboObj.selectedValue,
					listeners:{
						'select':function(){
							var accountName = Ext.getCmp('dashTypeComId').getRawValue();
							var accountValue = Ext.getCmp('dashTypeComId').getValue();
							var ctxUrl = "/final/monitor/microsoftDashboard.jsp?iniName=eg_msdashboard&userBased=true&fromMenu=true&showConfig=true&active_view=overview_view&firstTimeHit=true&accountName="+accountName+"&accountValue="+accountValue;
							document.location.href=ctxUrl;
						}
					}
				},{
					xtype:'tbseparator',
					hidden:requestParams.isFromMenu,
					margin:"0 10 0 0",
				},{
					xtype: 'button',
					id: 'backButton',
					margin:"0 5 0 0",
					padding: 0,
					hidden:requestParams.isFromMenu,
					cls: 'backbutton',
					iconCls: 'iconBack',
					text: 'Back'
				}]
			}]
		}];
		viewport.callParent();
	}
});
