var strSkinclr = ( strSkin == 'Dark' )?'#6a6a6a':'#cdcdcd';
Ext.define('microsoftDashboard.view.office365.OverviewPage', {
    extend: 'Ext.panel.Panel',
	alias: 'widget.MS365_Dashboard.overviewpage',
	ui:'eg-panel',
	border: false,
    autoScroll: false,
    scroll: false,
	style:{'overflow':'visible !important'},
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	items:[],
	updatePage:function(jsonData)
	{
		Ext.getCmp('ov_header_id').setTitle(jsonData[8].Overview_view_header);
		Ext.getCmp('serviceHealth').getStore().loadData(jsonData[0].Overview_first_block[0].TextBlock1);
		Ext.getCmp('connectionStatus').getStore().loadData(jsonData[0].Overview_first_block[0].TextBlock3);
		Ext.getCmp('userLicense').getStore().loadData(jsonData[0].Overview_first_block[0].TextBlock2);

		Ext.getCmp('userLicense').updatePanel(jsonData[0].Overview_first_block[0].TextBlock2[0]);

		Ext.getCmp('mailboxes').updatePanel(jsonData);
		Ext.getCmp('officeUsage').updatePanel(jsonData);
		Ext.getCmp('inboundMails').updatePanel(jsonData);
		Ext.getCmp('outboundMails').updatePanel(jsonData);

		Ext.getCmp('latencyRequestView').getStore().loadData(jsonData[4].Overview_fifth_block);
		
		Ext.getCmp('siteAvail').setTitle(jsonData[5].Overview_sixth_block[0].heading);
		Ext.getCmp('siteAvailView').getStore().loadRawData(jsonData[5].Overview_sixth_block[0]);

		Ext.getCmp('activeUsers').updatePanel(jsonData);
	},
	listeners:
	{
		afterrender:function(e)
		{
			var memain = this;
			memain.add({
				xtype:'header',
				height:25,
				margin:'0 0 0 0',
				id:'ov_header_id',
				title:memain.data[8].Overview_view_header
			},
			{
				xtype:'container',
				ui:'eg-container',
				margin:'5 0 0 0',
				height:140,
				layout:{
					type:'hbox',
					align:'stretch'
				},
				listeners:
				{
					afterrender:function(e)
					{
						var me = this;
						me.add({
							xtype:'dataview',
							id:'serviceHealth',
							cls:'dividerGradient',
							ui:'uniqueSessions',
							minWidth:530,
							flex:2.5,
							store: Ext.create('Ext.data.Store', {
								fields: [{ name:'iconCls', type:'string' },{ name:'backgroundCls', type:'string' },{ name:'value', type:'string' },{ name:'valueText', type:'string'},{ name:'valueStatus', type:'string'},{ name:'layerLink',type:'string'},{ name:'valueComment', type:'string'},{ name:'stateValue', type:'string'}],
								autoLoad:true,
								data:memain.data[0].Overview_first_block[0].TextBlock1
							}), 
							tpl:new Ext.XTemplate(
								'<div class="widgetholders" style="height:73%;width:95%;margin:20px 10px 20px 20px;display:flex;">',
									'<tpl for=".">',
											'<tpl if="xindex === 1">',
												'<div onClick="javascrip:gotoSpecPage(\'servicehealth\',\'MS365_Dashboard\')" style="position:relative;width:140px;text-align:center;cursor:pointer" class="{backgroundCls}">',
											'<tpl elseif="xindex === 2">',
												'<tpl if="layerLink!=&quot;&quot;">',
													'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="position:relative;flex:auto;text-align:center;cursor:pointer;padding:0 5;" class="{backgroundCls}">',
												'<tpl else>',
													'<div style="position:relative;flex:auto;text-align:center;" class="{backgroundCls}">',													
												'</tpl>',
											'<tpl else>',
												'<tpl if="layerLink!=&quot;&quot;">',
													'<tpl if="valueText==\'Maintenance Events\'">',
														'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="position:relative;flex:auto;text-align:center;cursor:pointer;padding:0 5;" class="{backgroundCls} ms-separator">',
													'<tpl else>',
														'<tpl if="valueText==\'Total Events\'">',
															'<div onClick="javascrip:gotoSpecPage(\'All_Events\',\'365AlarmDetailsDashboard\')" style="position:relative;flex:auto;text-align:center;" class="{backgroundCls} ms-separator">',
														'<tpl else>',
															'<div style="position:relative;flex:auto;text-align:center;" class="{backgroundCls} ms-separator">',
														'</tpl>',														
													'</tpl>',
												'<tpl else>',
													'<tpl if="valueText==\'Total Events\'">',
														'<div onClick="javascrip:gotoSpecPage(\'All_Events\',\'365AlarmDetailsDashboard\')" style="position:relative;flex:auto;text-align:center;" class="{backgroundCls} ms-separator">',
													'<tpl else>',
														'<div style="position:relative;flex:auto;text-align:center;" class="{backgroundCls} ms-separator">',
													'</tpl>',													
												'</tpl>',
											'</tpl>',
											'<div class="d_m_t25" style="display:inline-block;">',
												'<div style="display:inline-block;">',
													'<tpl if="stateValue">',
														'<img src="/final/images/clear.png" class="stateIcon22_{stateValue}" style="float:left;margin-right:8px;margin-top:3px;">',
													'<tpl else>',
														'<img src="/final/images/clear.png" class="{iconCls}" style="float:left;margin-right:8px">',
													'</tpl>',
													'<span class="f24-normal">{value}',
														'<span class="f19-normal"></span>',
													'</span>',
												'</div>',
												'<div class="crl"></div>',
												'<tpl if="backgroundCls==&quot;&quot;">',
													'<span class="f12-normal">{valueText}</span>',
													'<tpl if="valueComment">',
														'<span class="f12-normal">{valueStatus}<br/><span style="font-size:9px">{valueComment}</span></span>',
													'</tpl>',
												'<tpl else>',
													'<tpl if="valueComment">',
														'<span style="color:white;" class="f12-normal">{valueStatus}<br/><span style="font-size:9px">{valueComment}</span></span>',
													'<tpl else>',
														'<span style="color:white;" class="f12-normal">{valueStatus}</span>',
													'</tpl>',
												'</tpl>',
											'</div>',
										'</div>',
									'</tpl>',
								'</div>'
							)
						},{
							xtype:'dataview',
							id:'userLicense',
							cls:'dividerGradient',
							ui:'uniqueSessions',
							flex:1,
							padding:'10 20 10 20',
							minWidth:250,
							chartData:memain.data[0].Overview_first_block[0].TextBlock2[0],
							store: Ext.create('Ext.data.Store', {
								 fields: [{ name:'state', type:'string' },{ name:'title', type:'string' },{ name:'noData', type:'boolean' },{ name:'value', type:'number' },{ name:'legend', type:'string' },{ name:'sessions' },{ name:'data' },{name:'graphID', type:'string' },{ name:'layerLink',type:'string'}],
								autoLoad:true,
								data:memain.data[0].Overview_first_block[0].TextBlock2
							}),
							tpl:new Ext.XTemplate(
								'<tpl for=".">',
								'<div class="widgetholders" style="border:0px solid blue;width:100%">',
									'<div>',
									  '<div class="f15-bold">',
										'<tpl if="state">',
											'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" />',
											'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;" data-qtip="{title}">{title}</ span></div>',
										'<tpl else>',
											'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;" data-qtip="{title}">{title}</ span></div>',
										'</tpl>',
										'<div id="chartTplContainer">',
										'<table style="margin:auto" cellspacing="0" cellpadding="0"><tr>',
										'<tpl  if="noData != undefined && noData">',
											'<td style="text-align:center;"><div style="float:left;border:0px solid blue;margin-left:-10px;margin-top:-5px;width:100px;height:110px" id="donutalert-graph"></div>',
											'</td><td style="vertical-align:middle;padding-left:0px">',
												'<div>',
													'<table style="text-align:center;vertical-align:middle" cellspacing="0" cellpadding="0"><tr><td class="f14-normal">',
														'No Alerts <br> <div style="padding-top: 5px;">Found</div>',
													'</td></tr></table>',
											'</div>',
										'<tpl else>',
											 '<td  style="text-align:center;" ><div style="border:0px solid red;margin-top:-5px;width:100px;height:110px" id="donutalert-graph"></div></td>',
											'<td style="vertical-align:middle;padding-left:20px;padding-top:10px;">',
												'<div style="margin-top:0px !important;">',
													'<table style="float:right;margin-right:0px" cellspacing="10" cellpadding="10"><tr>',
															'<tpl for="data">',
																'<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
																	'<tr><td><div class="msChartLegend" style="background:{color};margin-top:2px"></div></td><td style="padding:5px 0px 5px 0px;" class="f11-normal">',
																	'<tpl if="value ==&quot;0&quot;">',
																		'<a>{name}&nbsp;({value})</a>',
																	'<tpl else>',
																		'<tpl if="subjectVariable !=&quot;&quot;">',
																			'<a href="javascript:openAlarmPopup(\'{name}\',\'{subjectVariable}\')">{name}&nbsp;({value})</a>',
																		'<tpl else>',
																			'<tpl if="layerLink!=&quot;&quot;">',
																				'<tpl if="name==\'Unlicensed Users\'">',
																						'<span onClick="javascript:layerModelLinks(\'{layerLink}\')" style="cursor:pointer"><a>{name}&nbsp;({value})</a></span>',
																				'<tpl else>',
																					'<a>{name}&nbsp;({value})</a>',
																				'</tpl>',
																			'<tpl else>',
																					'<a>{name}&nbsp;({value})</a>',
																			'</tpl>',
																			
																		'</tpl>',
																	'</tpl>',
																	'</td></tr>',
																'</tpl>',
															'</tpl>',
														//'</tpl>',														
													'</table>',
											'</div></td></tr></table>',
										'</tpl>',
									'</div>',
								'</div>',
								'</tpl>'
							),
							updatePanel:function(data)
							{
								var me = this;
								try
								{

									var nodata = false;
									var donutData = data;
									try
									{
										for(var u=0;u<donutData.data.length;u++){
											if(donutData.data[u].value == "-" || donutData.data[u].value == "0")
												nodata = true;
											else
												break;
										}											
									}
									catch (e1)
									{
									}
									if(nodata)
									{
										$('#chartTplContainer').html('<div style="display:table;height:74%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
									}
									else
									{												
										donutData['innersize']='67%';
										donutData['outersize']='165%';
										donutData['title']='';
										donutData['DataSet']=[{"data":donutData['data']}];
										var pieChart = jQuery.extend(true, {}, getDonutChartsInstance1('',null,null), pieChart);
										pieChart.setData(donutData,'','','donut');											
										$('#donutalert-graph').highcharts(pieChart.highchart);	
									}
								}
								catch (er)
								{									
								}
							},
							listeners:
							{
								viewready:function()
								{
									var me = this;
									try
									{

										var nodata = false;
										var donutData = me.chartData;
										try
										{
											for(var u=0;u<donutData.data.length;u++){
												if(donutData.data[u].value == "-" || donutData.data[u].value == "0")
													nodata = true;
												else
													break;
											}											
										}
										catch (e1)
										{
										}
										if(nodata)
										{
											$('#chartTplContainer').html('<div style="display:table;height:74%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
										}
										else
										{												
											donutData['innersize']='67%';
											donutData['outersize']='165%';
											donutData['title']='';
											donutData['DataSet']=[{"data":donutData['data']}];
											
											var pieChart = jQuery.extend(true, {}, getDonutChartsInstance1('',null,null), pieChart);
											pieChart.setData(donutData,'','','donut');											
											$('#donutalert-graph').highcharts(pieChart.highchart);	
										}
									}
									catch (er)
									{										
									}
								},
							}
						},{
							xtype:'dataview',
							id:'connectionStatus',
							cls:'dividerGradient',
							ui:'uniqueSessions',
							flex:0.7,
							minWidth:200,
							store: Ext.create('Ext.data.Store', {
								fields: [{ name:'iconCls', type:'string' },{ name:'backgroundCls', type:'string' },{ name:'value', type:'string' },{ name:'valueText', type:'string'},{ name:'layerLink',type:'string'},{ name:'stateValue',type:'string'}],
								autoLoad:true,
								data:memain.data[0].Overview_first_block[0].TextBlock3
							}), 
							tpl:new Ext.XTemplate(
								'<div class="widgetholders" style="height:100%;width:90%;margin:0px 10px 0 10px;display:grid;align-items: stretch;">',
									'<tpl for=".">',
										'<tpl if="xindex === 1">',
											'<div style="display:flex;align-items:center;position:relative;" class="ms-separator-vertical">',
										'<tpl else>',
											'<div style="display:flex;align-items:center;position:relative;">',
										'</tpl>',
											'<div style="display:flow-root;width:100%;">',
												'<tpl if="iconCls != &quot;&quot;">',
													'<tpl if="stateValue">',
														'<div class="stateIcon22_{stateValue}" style="float:left;text-align:center;margin-left:20px;margin-right:30px;    margin-top: 3px;">',
													'<tpl else>',
														'<div class="{iconCls}" style="float:left;text-align:center;margin-left:20px;margin-right:30px;">',
													'</tpl>',													
													'</div>',
													'<div onClick="javascript:gotoSpecPage(\'servicehealth\',\'MS365_Dashboard\')" class="f12-normal" style="margin-top:4px;margin-left:10px;cursor:pointer;">{valueText}</div>',
												'</div>',
												'<tpl else>',
													'<tpl if="stateValue">',
														'<div class="f24-normal" style="float:left;width:50px;text-align:center;margin-left:20px;margin-right:20px;">',
														'<img src="/final/images/clear.png" class="stateIcon22_{stateValue}" style="float:left;margin-right:8px;margin-top:3px;">',
													'<tpl else>',
														'<div class="f24-normal" style="float:left;width:50px;text-align:center;margin-left:15px;margin-right:16px;">',
													'</tpl>',
													'{value}',
													'</div>',
														'<tpl if="layerLink!=&quot;&quot;">',
															'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" class="f12-normal" style="margin-top:4px;margin-left:10px;cursor:pointer;">{valueText}</div>',
														'<tpl else>',
															'<div onClick="javascript:gotoSpecPage(\'licenseusage\',\'MS365_Dashboard\')" class="f12-normal" style="margin-top:4px;margin-left:10px;cursor:pointer">{valueText}</div>',
														'</tpl>',
												'</div>',
												'</tpl>',
										'</div>',										
									'</tpl>',									
								'</div>'
							),
							items:[{
							xtype:'panel',
							//floating:true,
							html:'one',
							height:20,}],
							listeners:
								{
								afterrender:function(e)
									{
										
										var newpanel= new Ext.create('Ext.panel.Panel',{
										html:'one',
										height:20,
										});
										var me = this;										
								}
							},
						});						
					}
				}
			},
			{
				xtype:'panel',
				margin:'10 0 0 0',
				defaults:{
					columnWidth: 0.5,
					height: 260
				},
				layout:'column',
				manageOverflow:2,
				items:[],
				listeners:
				{
					afterrender:function()
					{
						var me = this;
						me.add({
							xtype:'panel',
							id:'mailboxes',
							ui: 'eg-x-panel',
							margin:'0 10 10 0',
							updatePanel:function(data)
							{
								this.setTitle(data[1].Overview_second_block[0].title);
								Ext.getCmp('mailboxesView').getStore().loadRawData(data[1].Overview_second_block[1]);
								Ext.getCmp('mailboxesView').updateView(data[1].Overview_second_block[0]);
							},
							listeners:
							{
								afterrender:function()
								{
									var me = this;
									me.setTitle(memain.data[1].Overview_second_block[0].title);
									me.add({
										xtype:'dataview',
										id:'mailboxesView',
										padding:'0 5 0 5',
										layout:{type:'vbox',pack:'center'},
										store: Ext.create('Ext.data.Store', {
											 fields: [{ name:'state', type:'string' },{ name:'title', type:'string' },{ name:'noData', type:'boolean' },{ name:'value', type:'number' },{ name:'valueText', type:'string' },{ name:'sessions' },{ name:'data' },{name:'graphID', type:'string' },{name:'Mailboxes'},{name:'Mails'},{ name:'layerLink',type:'string'}],
											autoLoad:true,
											data:memain.data[1].Overview_second_block[1]
										}),
										tpl: new Ext.XTemplate(
											'<tpl for=".">',		
											'<div class="widgetholders" style="margin-top:0px;border:0px solid blue !important">',				
												'<div id="b_box1" class="b_box1" style="margin:auto;width:100%;display:inline-flex;">',
												  '<div class="f14-bold"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span></ span></div>',
													 '<div  style="border:0px solid blue;margin-top:0px;text-align:center;width:300px;height:205px;float:left" id="'+me.id+'_bgDonut"></div>',
													 '<div style="width:100%;padding-top:10px;padding-left:40px;padding-right:40px;">',
														'<div style="height:83px;width:100%;" class="msChartminmax">',
															'<div style="width:100%;display:flex;">',
																'<tpl for="Mailboxes">',
																	'<tpl if="xindex == 2">',
																		'<tpl if="layerLink!=&quot;&quot;">',
																			'<tpl if="valueText == \'Mailboxes Size (GB)\'">',
																				'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="width:50%;height:74%;text-align:center;margin:15px 0px 10px 0px;cursor:pointer;">',
																			'<tpl else>',
																				'<div style="width:50%;height:74%;text-align:center;margin:15px 0px 10px 0px;" >',
																			'</tpl>',
																		'<tpl else>',
																			'<div style="width:50%;height:74%;text-align:center;margin:15px 0px 10px 0px;" >',
																		'</tpl>',
																	'<tpl else>',
																		'<tpl if="layerLink!=&quot;&quot;">',
																			'<tpl if="valueText == \'Mailboxes\'">',
																				'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="width:50%;height:74%;text-align:center;margin:15px 0px 10px 0px;cursor:pointer;" class="ms-separator-innerbox">',
																			'<tpl else>',
																				'<div style="width:50%;height:74%;text-align:center;margin:15px 0px 10px 0px;" class="ms-separator-innerbox">',
																			'</tpl>',
																		'<tpl else>',
																			'<div style="width:50%;height:74%;text-align:center;margin:15px 0px 10px 0px;" class="ms-separator-innerbox">',
																		'</tpl>',
																		
																	'</tpl>',
																		'<div class="f24-normal">{value}</div>',
																		'<div class="f12-normal" style="margin-top:10px">{valueText}</div>',
																	'</div>',										
																'</tpl>',
															'</div>',
														'</div>',
														'<div style="height:83px;width:100%;margin-top:20px;" class="msChartminmax">',
															'<div style="width:100%;display:flex;">',
																'<tpl for="Mails">',
																	'<tpl if="xindex == 2">',
																		'<tpl if="valueText == \'Mail Size (GB)\'">',
																			'<div onClick="javascsript:gotoSpecPage(\'mailtraffic\',\'MS_EXOnline_Dashboard\')"style="width:50%;height:74%;text-align:center;margin:15px 0px 10px 0px;cursor:pointer;" >',
																		'<tpl else>',
																			'<div style="width:50%;height:74%;text-align:center;margin:15px 0px 10px 0px;" >',
																		'</tpl>',
																	'<tpl else>',
																		'<tpl if="valueText == \'Total Mails\'">',
																			'<div  onClick="javascript:gotoSpecPage(\'mailtraffic\',\'MS_EXOnline_Dashboard\')" style="width:50%;height:74%;text-align:center;margin:15px 0px 10px 0px;cursor:pointer;" class="ms-separator-innerbox">',
																		'<tpl else>',
																			'<div style="width:50%;height:74%;text-align:center;margin:15px 0px 10px 0px;" class="ms-separator-innerbox">',
																		'</tpl>',

																	'</tpl>',
																		'<div class="f24-normal">{value}</div>',
																		'<div class="f12-normal" style="margin-top:10px">{valueText}</div>',
																	'</div>',															
																'</tpl>',
															'</div>',
														'</div>',
													'</div>',
												'</div>',
											'</tpl>',
											'</div>'
										),
										updateView:function(viewData)
										{
											var checkData = noDataComputefunction(viewData);
												if(!checkData)
												{
													try
													{
														var pieChart = {};
														var chartData = viewData
														var dontCheck = true;
														if (me.ifLogOn)
														{
															dontCheck = false;
															chartData['outersize']='110%';
															chartData['innersize']='47%';
															chartData['setTitle']=true;
															chartData['useHtml']=true;
														}
														else
														{
															dontCheck = false;
															chartData['outersize']='115%';
															chartData['innersize']='30%';
															chartData['borderWidth']='0'
														}

														if(me.ifUx)
															chartData['innersize']='30%';
														else if(dontCheck)
															 chartData['innersize']='42%';
														
														chartData['showLegend']=true;
														try
														{
															var seriesData = chartData.DataSet[0].data;
															var allZero = 0;
															for(var z=0;z<seriesData.length;z++)
															{
																allZero += seriesData[z].y;
															}
															if(allZero == 0)
																chartData.DataSet[0].data[seriesData.length] = {name:"-", color: "#cdcdcd", y:100, value: "-"};
														}
														catch (e)
														{
														}
														pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
														pieChart.setData(chartData,'','','bgdonut');
														jsonData = pieChart.highchart;											
													}
													catch (er)
													{														
													}											
													$('#'+me.id+"_bgDonut").highcharts(jsonData);	
												}
												else
												{
													this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
										},
										listeners:{
											viewready:function(){
												var chartData = memain.data[1].Overview_second_block[0];
												var checkData = noDataComputefunction(chartData);
												if(!checkData)
												{
													try
													{
														var pieChart = {};
														
														var dontCheck = true;
														if (me.ifLogOn)
														{
															dontCheck = false;
															chartData['outersize']='110%';
															chartData['innersize']='47%';
															chartData['setTitle']=true;
															chartData['useHtml']=true;
														}
														else
														{
															dontCheck = false;
															chartData['outersize']='115%';
															chartData['innersize']='30%';
															chartData['borderWidth']='0'
														}

														if(me.ifUx)
															chartData['innersize']='30%';
														else if(dontCheck)
															 chartData['innersize']='42%';
														
														chartData['showLegend']=true;

														try
														{
															var seriesData = chartData.DataSet[0].data;
															var allZero = 0;
															for(var z=0;z<seriesData.length;z++)
															{
																allZero += seriesData[z].y;
															}
															if(allZero == 0)
																chartData.DataSet[0].data[seriesData.length] = {name:"-", color: "#cdcdcd", y:100, value: "-"};
														}
														catch (e)
														{
														}

														pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
														pieChart.setData(chartData,'','','bgdonut');
														jsonData = pieChart.highchart;													
														
													}
													catch (er)
													{														
													}												
													$('#'+me.id+"_bgDonut").highcharts(jsonData);
												}
												else
												{
													this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
											}
										},
									});
								}
							}
						},{
							xtype:'panel',
							title:memain.data[2].Overview_third_block[0].title,
							id:'officeUsage',
							ui: 'eg-x-panel',
							margin:'0 1 10 0',
							updatePanel:function(data)
							{
								var me = this;
								me.setTitle(data[2].Overview_third_block[0].title);
								var chartData = data[2].Overview_third_block[0];
								me.setTitle(data[2].Overview_third_block[0].title);
								try
								{
									chartData['isStateBar']=false;
									chartData['isStackingNeeded']=false;
									chartData['isStackedColumnLeg']=false;
									chartData['showLegend']=true;
									chartData['labelsNeeded']=true;
									chartData['ignoreHiddenSeriesFlag']=false;
									chartData['tick']=true;
									chartData['showYaxis']=true;
									chartData['ifLogonDashboard']=true;
									chartData['rotateXaxis']=true;
									chartData['title']="";
									var barChart = {};				
									var nodata = false;
									try
									{
										if(chartData.data == undefined || chartData.data == null)
											nodata = true;
										else
										{
											nodata = false;
											if(chartData.data.length == 0)
													nodata = true;
											for(var u=0;u<chartData.data.length;u++){
												if(chartData.data[u].value == "-" || chartData.data[u].value == "0")
													nodata = true;
												else
													nodata = false;
											}	
										}
										
										if(chartData.DataSet == undefined || chartData.DataSet == null)
											nodata = true;
										else
										{
											nodata = false;
											for(var u=0;u<chartData.DataSet.length;u++){
												if(chartData.DataSet[u].data.length == 0)
													nodata = true;
												for(var v=0;v<chartData.DataSet[u].data.length;v++){
													if(chartData.DataSet[u].data[v].value == "-" || chartData.DataSet[u].data[v].value == "0")
														nodata = true;
													else
														nodata = false;
												}	
											}
										}
																				
									}
									catch (e1)
									{											
									}
									if(!nodata)
									{
										barChart = jQuery.extend(true, {}, createBar1(this.id,null,null), barChart);
										barChart.setData(chartData,mgrDateFormat,'','stackedColumn');
										jsonData = barChart.highchart;
									}
								}
								catch (er)
								{									
								}
								if(nodata)
									$('#officeUsage-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
								else
									$('#'+me.body.id).highcharts(jsonData);
								me.doLayout();
							},
							listeners:
							{
								afterLayout:function()
								{
									var me = this;
									var jsonData = "";
									var chartData = memain.data[2].Overview_third_block[0];
									try
									{
										chartData['isStateBar']=false;
										chartData['isStackingNeeded']=false;
										chartData['isStackedColumnLeg']=false;
										chartData['showLegend']=true;
										chartData['labelsNeeded']=true;
										chartData['ignoreHiddenSeriesFlag']=false;
										chartData['tick']=true;
										chartData['showYaxis']=true;
										chartData['ifLogonDashboard']=true;
										chartData['rotateXaxis']=true;
										chartData['title']="";

										var barChart = {};	
										var nodata = false;
										try
										{
											if(chartData.data == undefined || chartData.data == null)
												nodata = true;
											else
											{
												nodata = false;
												if(chartData.data.length == 0)
														nodata = true;
												for(var u=0;u<chartData.data.length;u++){
													if(chartData.data[u].value == "-" || chartData.data[u].value == "0")
														nodata = true;
													else
														nodata = false;
												}	
											}
											
											if(chartData.DataSet == undefined || chartData.DataSet == null)
												nodata = true;
											else
											{
												nodata = false;
												for(var u=0;u<chartData.DataSet.length;u++){
													if(chartData.DataSet[u].data.length == 0)
														nodata = true;
													for(var v=0;v<chartData.DataSet[u].data.length;v++){
														if(chartData.DataSet[u].data[v].value == "-" || chartData.DataSet[u].data[v].value == "0")
															nodata = true;
														else
															nodata = false;
													}	
												}
											}
																					
										}
										catch (e1)
										{											
										}
										if(!nodata)
										{
											barChart = jQuery.extend(true, {}, createBar1(this.id,null,null), barChart);
											barChart.setData(chartData,mgrDateFormat,'','stackedColumn');
											jsonData = barChart.highchart;
										}
									}
									catch (er)
									{										
									}
									if(nodata)
										$('#officeUsage-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
									else
										$('#'+me.body.id).highcharts(jsonData);
										
								},
								'afterrender':function()
									{
										var chartData = memain.data[2].Overview_third_block[0];
										var checkData = noDataComputefunction(chartData);
										if(!checkData)
										{
											$('#'+this.id).css({'cursor':'pointer'});
										}
										$('#'+this.id).click(function(){
										var checkData = noDataComputefunction(chartData);
										if(!checkData)
										{
											gotoSpecPage('serviceusage','MS365_Dashboard');
										}
										});
									}
								
							}
						},
						{
							xtype:'panel',
							title:memain.data[3].Overview_fourth_block[0].title,
							id:'inboundMails',
							ui: 'eg-x-panel',
							itemId:'thisisme',
							margin:'0 10 10 0',
							bodyPadding:'0 13 7 13',
							updatePanel:function(data)
							{
								var me = this;
								var jsonData = "";
								var chartData = data[3].Overview_fourth_block[0];
								me.setTitle(data[3].Overview_fourth_block[0].title);
								
								try{
									var chartData = data[3].Overview_fourth_block[0];
									var lineChart = {};
									var nodata = false;
									try
									{
										if(chartData.data == undefined || chartData.data == null)
											nodata = true;
										else
											nodata = false;

										if(chartData.DataSet == undefined || chartData.DataSet == null)
											nodata = true;
										else
											nodata = false;

										for(var u=0;u<chartData.data.length;u++){
											if(chartData.data[u].value == "-" || chartData.data[u].value == "0")
												nodata = true;
											else
												break;
										}											
									}
									catch (e1)
									{
									}
									if(!nodata)
									{
										lineChart = jQuery.extend(true, {}, createLineChart(me.id,null,null), lineChart);
										chartData["title"] = "";
										
										lineChart.setData(chartData,'','','line');
										jsonData = lineChart.highchart;
									}
								}
								catch(eo)
								{									
								}
								if(nodata)
									$('#inboundMails-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
								else
									$('#'+me.body.id).highcharts(jsonData);		
								me.doLayout();
							},
							listeners:
							{
								afterLayout:function()
								{
									var me = this;
									var jsonData = "";
									var chartData = memain.data[3].Overview_fourth_block[0];
									try{
										var chartData = memain.data[3].Overview_fourth_block[0];
										var lineChart = {};
										var nodata = false;
										try
										{
											if(chartData.data == undefined || chartData.data == null)
												nodata = true;
											else
												nodata = false;

											if(chartData.DataSet == undefined || chartData.DataSet == null)
												nodata = true;
											else
												nodata = false;

											for(var u=0;u<chartData.data.length;u++){
												if(chartData.data[u].value == "-" || chartData.data[u].value == "0")
													nodata = true;
												else
													break;
											}											
										}
										catch (e1)
										{
										}
										if(!nodata)
										{
											lineChart = jQuery.extend(true, {}, createLineChart(me.id,null,null), lineChart);
											chartData["title"] = "";
											lineChart.setData(chartData,'','','line');
											jsonData = lineChart.highchart;
										}
									}
									catch(eo)
									{
									}
									
									if(nodata)
										$('#inboundMails-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
									else
										$('#'+me.body.id).highcharts(jsonData);
										
								}
							}
						},
						{
							xtype:'container',
							layout:'column',
							height:270,
							listeners:
							{
								afterrender:function()
								{
									var me = this;
									me.add({
										xtype:'panel',
										ui: 'eg-x-panel',
										cls:'ovFlowVisiblePanel',
										id:'latencyRequest',
										columnWidth:.4,
										height:260,
										margin:'0 5 0 0',
										padding:'0 20',
										items:[{
											xtype:'dataview',
											id:'latencyRequestView',
											store: Ext.create('Ext.data.Store', {
												 fields: [{ name:'state', type:'string' },{ name:'iconCls', type:'string' },{ name:'noData', type:'boolean' },{ name:'value'},{ name:'valueText', type:'string' },{ name:'sessions' },{ name:'data' },{name:'graphID', type:'string' },{name:'Mailboxes'},{name:'Mails'},{name:'stateValue',type:'string'}],
												autoLoad:true,
												data:memain.data[4].Overview_fifth_block
											}),
											tpl: new Ext.XTemplate(
												'<div class="widgetholders" style="height:100%;width:100%;display:grid;align-items: stretch;">',
													'<tpl for=".">',
														'<tpl if="xindex === 1">',
															'<div style="position:relative;display:flex;align-items:center;" class="ms-separator-vertical">',
														'<tpl else>',
															'<div style="position:relative;display:flex;align-items:center;">',
														'</tpl>',
																'<div style="width: 100%;text-align: center;">',
																'<div style="display:inline-block;">',
																	'<tpl if="stateValue">',
																		'<img src="/final/images/clear.png" class="stateIcon22_{stateValue}" style="float:left;margin-right:8px;margin-top:6px;">',
																	'<tpl else>',
																		'<img src="/final/images/clear.png" class="{iconCls}" style="float:left;margin-top:3px;margin-right:8px">',
																	'</tpl>',
																	'<tpl if="error">',
																		'<span class="f28-normal">-',
																	'<tpl else>',
																		'<span class="f28-normal">{value}',
																	'</tpl>',
																		//unit
																		'<span class="f19-normal"></span>',
																	'</span>',
																'</div>',
																'<div class="crl"></div>',
																'<div class="f12-normal">{valueText}</div>',
															'</div>',
														'</div>',
													'</tpl>',
												'</div>'
											)
										}]
									},{
										xtype:'panel',
										id:'siteAvail',
										scroll:true,
										autoScroll:true,
										ui: 'eg-x-panel',
										title:memain.data[5].Overview_sixth_block[0].heading,
										columnWidth:.6,
										height:260,
										margin:'0 0 0 5',
										items:[{
											xtype:'dataview',
											id:'siteAvailView',
											store: Ext.create('Ext.data.Store', {
												 fields: [{ name:'name', type:'string' },{ name:'value', type:'string' },{ name:'dataArray'}],
												autoLoad:true,
												data:memain.data[5].Overview_sixth_block[0]
											}),
											tpl: new Ext.XTemplate(
												'<div class="widgetholders" style="height:100%;width:100%;display:grid;padding:15px 20px 20px 20px;">',
													 '<tpl for=".">',
														  '<tpl if="dataArray">',
																'<tpl for="dataArray">',
																	'<div class="ms-separator-vertical" style="display:flex;height:35px;margin-top:-3px">',
																		'<span style="text-transform:capitalize;margin-top:5px;margin-left:0px;" class="f12-normal">{name}</span>',
																		'<div style="border-radius:16px;height:6px;width:100%;margin: 11px 10px 5px 55px;background-color:#dfdfdf;">',
																			'<span style="border-radius: 16px;width:{value}%;height:6px;display:block;background-color: {color};"></span>',														
																		'</div>',
																		'<span style="margin-top:5px;margin-right:0px;margin-left:10px;" class="f12-normal">{value}%</span>',
																	'</div>',
																'</tpl>',
													 	'<tpl else>',
													 		'<div style="height:164%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>',
													 '</tpl>',
												'</tpl>',
											'<div>'
											)
										}]
									});
								}
							}
						},
						{
							xtype:'panel',
							id:'outboundMails',
							title:memain.data[6].Overview_seventh_block[0].title,
							ui: 'eg-x-panel',
							margin:'0 10 10 0',
							bodyPadding:'0 13 7 13',
							layout:{type:'vbox',align:'stretch'},
							updatePanel:function(data)
							{
								var me = this;
								var jsonData = "";
								var chartData = data[6].Overview_seventh_block[0];
								me.setTitle(data[6].Overview_seventh_block[0].title);
								try{
									var chartData = data[6].Overview_seventh_block[0];
									var lineChart = {};
									var nodata = false;
									try
									{
										if(chartData.data == undefined || chartData.data == null)
											nodata = true;
										else
											nodata = false;

										if(chartData.DataSet == undefined || chartData.DataSet == null)
											nodata = true;
										else
											nodata = false;

										for(var u=0;u<chartData.data.length;u++){
											if(chartData.data[u].value == "-" || chartData.data[u].value == "0")
												nodata = true;
											else
												break;
										}											
									}
									catch (e1)
									{
									}
									if(!nodata)
									{
										lineChart = jQuery.extend(true, {}, createLineChart(me.id,null,null), lineChart);
										chartData["title"] = "";
										lineChart.setData(chartData,'','','line');
										jsonData = lineChart.highchart;
									}
								}
								catch(eo)
								{									
								}
								if(nodata)
									$('#outboundMails-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
								else
									$('#'+me.body.id).highcharts(jsonData);	
							},
							listeners:
							{
								afterLayout:function()
								{
									var me = this;
									var jsonData = "";
									var chartData = memain.data[6].Overview_seventh_block[0];
									try{
										var chartData = memain.data[6].Overview_seventh_block[0];
										var lineChart = {};
										var nodata = false;
										try
										{
											if(chartData.data == undefined || chartData.data == null)
												nodata = true;
											else
											{
												nodata = false;
												if(chartData.data.length == 0)
														nodata = true;
												for(var u=0;u<chartData.data.length;u++){
													if(chartData.data[u].value == "-" || chartData.data[u].value == "0")
														nodata = true;
													else
														nodata = false;
												}	
											}
											
											if(chartData.DataSet == undefined || chartData.DataSet == null)
												nodata = true;
											else
											{
												nodata = false;
												for(var u=0;u<chartData.DataSet.length;u++){
													if(chartData.DataSet[u].data.length == 0)
														nodata = true;
													for(var v=0;v<chartData.DataSet[u].data.length;v++){
														if(chartData.DataSet[u].data[v].value == "-" || chartData.DataSet[u].data[v].value == "0")
															nodata = true;
														else
															nodata = false;
													}	
												}
											}
																					
										}
										catch (e1)
										{											
										}
										if(!nodata)
										{
											lineChart = jQuery.extend(true, {}, createLineChart(me.id,null,null), lineChart);
											chartData["title"] = "";
											lineChart.setData(chartData,'','','line');
											jsonData = lineChart.highchart;
										}
									}
									catch(eo)
									{										
									}
									if(nodata)
										$('#outboundMails-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
									else
										$('#'+me.body.id).highcharts(jsonData);	
								}
							}
						},{
							xtype:'panel',
							title:memain.data[7].Overview_eighth_block[0]["title"],
							id:'activeUsers',
							ui: 'eg-x-panel',
							margin:'0 0 8 0',
							bodyPadding:'0 13 7 13',
							updatePanel:function(data)
							{
								var me = this;
								var chartData = data[7].Overview_eighth_block[0];
								var checkData = noDataComputefunction(chartData);
									if(!checkData)
									{
										try{
											var barChart = {};
											barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
											me.setTitle(chartData["title"]);
											chartData["title"] = "";
											chartData["marginTop"] = 0;
											barChart.setData(chartData,'','','bar');
											jsonData = barChart.highchart;
											$('#'+me.body.id).highcharts(jsonData);
										}catch(eo){
											me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
										}
									}
								else
									{
										me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
									}
							},
							listeners:
							{
								boxready:function(e)
								{
									var me = this;
									var chartData = memain.data[7].Overview_eighth_block[0];
									var checkData = noDataComputefunction(chartData);
									if(!checkData)
									{
										try{
											var barChart = {};
											barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
											chartData["title"] = "";
											chartData["marginTop"] = 0;
											barChart.setData(chartData,'','','bar');
											jsonData = barChart.highchart;
											$('#'+me.body.id).highcharts(jsonData);
										}catch(eo){
											me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
										}
									}
									else
									{
										me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
									}
								}
							}
						});
					}
				}
			});
		}
	}
});