Ext.define('microsoftDashboard.view.office365.ServiceHealthPage', {
    extend: 'Ext.panel.Panel',
	alias: 'widget.MS365_Dashboard.servicehealthpage',
	ui:'eg-panel',
    border: false,
    autoScroll: false,
    scroll: false,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	flex:1,
	items:[],
	updatePage:function(jsonData)
	{
		Ext.getCmp('sh_header_id').setTitle(jsonData[4].Service_health_view_header);
		Ext.getCmp('healthServiceView').getStore().loadData(jsonData[0].HealthView_first_block);
		Ext.getCmp('connectionStatus').getStore().loadData(jsonData[1].HealthView_second_block);
		Ext.getCmp('messageCenter').updatePanel(jsonData);
		Ext.getCmp('portalConnect').updatePanel(jsonData);
	},
	listeners:
	{
		afterrender:function(e)
		{
			var memain = this;
			memain.add({
				xtype:'header',
				height:25,
				margin:'0 0 5 0',
				id:'sh_header_id',
				cls:'f13-bold',
				title:memain.data[4].Service_health_view_header
			},
			{
				xtype:'container',
				flex:1,
				margin:0,
				padding:0,
				defaults:{
					columnWidth: 0.5,					 
				},
				layout:'column',
				manageOverflow:2,
				listeners:
				{
					afterrender:function(e)
					{
						var me = this;
						me.add({
							xtype:'container',
							margin:'0 0 10 0',
							listeners:
							{
								afterrender:function(e)
								{
									var me = this;
									me.add({
										xtype:'panel',
										id:'healthService',
										scroll:true,
										autoScroll:true,
										ui: 'eg-x-panel',
										header:
										{
											cls:'ms-separator-vertical',
											style:{'margin':'0px 20px 0px 20px !important'}
										},
										title:'<div class="f12-bold">OFFICE 365 SERVICE HEALTH</div>',
										height:800,
										items:[{
											xtype:'dataview',
											id:'healthServiceView',
											store: Ext.create('Ext.data.Store', {
												 fields: [{ name:'name', type:'string' },{ name:'value', type:'string' },{ name:'dataArray'},{ name:'layerURL',type:'string'}],
												autoLoad:true,
												data:memain.data[0].HealthView_first_block
											}),
											tpl: new Ext.XTemplate(
												'<div class="widgetholders" style="height:100%;width:100%;display:grid;padding:0 20 20 20;">',
													'<tpl for=".">',
													 	'<tpl if="dataArray == undefined">',
													 		'<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>',
													 	'<tpl elseif="dataArray == null">',
													 		'<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>',
													 	'<tpl else>',
															'<tpl for="dataArray">',
																'<tpl if="layerLink!=&quot;&quot;">',
																	'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" class="ms-separator-vertical" style="height:43px;padding: 5px;cursor:pointer">',
																		'<img src="/final/images/clear.png" class="{iconClass}" style="float:left;margin-right:8px">',
																		'<span style="display:inline-block;margin-top:8px;margin-left:10px;" class="f12-normal">{name}</span>',
																		'<img src="/final/images/clear.png" class="stateIcon22_{valueBasedClass}" style="float:right;margin-right:8px;margin-top:4px;">',
																	'</div>',
																'<tpl else>',
																	'<div class="ms-separator-vertical" style="height:43px;padding: 5px;">',
																		'<img src="/final/images/clear.png" class="{iconClass}" style="float:left;margin-right:8px">',
																		'<span style="display:inline-block;margin-top:8px;margin-left:10px;" class="f12-normal">{name}</span>',
																		'<img src="/final/images/clear.png" class="stateIcon22_{valueBasedClass}" style="float:right;margin-right:8px;margin-top:4px;">',
																	'</div>',
																'</tpl>',
															'</tpl>',														
													 	'</tpl>',														
													'</tpl>',
												'</div>'
											)
										}]
									});
								}
							}
						},{
							xtype:'container',
							margin:'0 0 8 8',
							listeners:
							{
								afterrender:function(e)
								{
									var me = this;
									me.add({
										xtype:'panel',
										ui: 'eg-x-panel',
										cls:'ovFlowVisiblePanel',
										height:104,
										padding:'20 0 20 0',
										margin:'0 0 8 0',
										listeners:
										{
											afterrender:function(e)
											{
												var me = this;
												me.add({
													xtype:'dataview',
													id:'connectionStatus',
													//cls:'dividerGradient',
													//ui:'uniqueSessions',
													minWidth:530,
													flex:3,
													store: Ext.create('Ext.data.Store', {
														fields: [{ name:'iconCls', type:'string' },{ name:'backgroundCls', type:'string' },{ name:'value', type:'string' },{ name:'valueText', type:'string'},{ name:'valueStatus', type:'string'},{ name:'layerLink',type:'string'},{ name:'stateValue',type:'string'}],
														autoLoad:true,
														data:memain.data[1].HealthView_second_block
													}), 
													tpl:new Ext.XTemplate(
														'<div class="widgetholders" style="height:100%;width:100%;margin:0px 0px 0px 0px;display:flex;">',
															'<tpl for=".">',
																	'<tpl if="xindex === 1">',
																		'<div onClick="javascript:scrollAnimation(\'portalConnect\')"style="position:relative;flex:1.2;cursor:pointer;text-align:center;background:{backgroundCls}" class="{backgroundCls}">',
																	'<tpl else>',
																			'<tpl if=" valueText==\'Login Time (Secs)\'">',
																					'<div onClick="javascript:scrollAnimation(\'portalConnect\')" style="position:relative;flex:1;text-align:center;cursor:pointer;background:{backgroundCls}" class="{backgroundCls} ms-separator">',
																			'<tpl else>',
																					'<tpl if="layerLink!=&quot;&quot;">',
																						'<tpl if="valueText==\'Service Incidents\'">',
																							'<div onClick="javascript:layerModelLinks(\'{layerLink}\')"style="position:relative;flex:1;text-align:center;cursor:pointer;background:{backgroundCls}" class="{backgroundCls} ms-separator">',
																						'<tpl elseif="valueText==\'Maintenance Events\'">',
																							'<div onClick="javascript:layerModelLinks(\'{layerLink}\')"style="position:relative;flex:1;text-align:center;cursor:pointer;background:{backgroundCls}" class="{backgroundCls} ms-separator">',
																						'<tpl else>',
																							'<div style="position:relative;flex:1;text-align:center;background:{backgroundCls}" class="{backgroundCls} ms-separator">',
																						'</tpl>',
																					'<tpl else>',
																						'<div style="position:relative;flex:1;text-align:center;background:{backgroundCls}" class="{backgroundCls} ms-separator">',
																					'</tpl>',
																					
																			'</tpl>',
																	'</tpl>',
																	'<div style="display:inline-block;">',
																		'<div style="display:inline-block;">',
																			'<tpl if="stateValue">',
																				'<img src="/final/images/clear.png" class="stateIcon22_{stateValue}" style="float:left;margin-right:8px;margin-top:3px;    margin-bottom: 5px;">',
																			'<tpl else>',
																				'<img src="/final/images/clear.png" class="{iconCls}" style="float:left;margin-right:8px">',
																			'</tpl>',
																			'<span class="f24-normal">{value}',
																				//unit
																				'<span class="f19-normal"></span>',
																			'</span>',
																		'</div>',
																		'<div class="crl"></div>',
																		'<tpl if="backgroundCls==&quot;&quot;">',
																			'<tpl if="iconCls==&quot;&quot;">',
																				'<div style="width: 80%;text-align: center;margin: auto;" class="f24-normal">-</div>',
																			'<tpl else>',
																				'<div style="width: 80%;text-align: center;margin: auto;" class="f12-normal">{valueText}</div>',
																			'</tpl>',
																		'<tpl else>',
																			'<div style="color:white;width: 80%;text-align: center;margin: auto;" class="f12-normal">{valueStatus}</div>',
																		'</tpl>',
																	'</div>',
																'</div>',
															'</tpl>',
														'</div>'
													)
												});
											}
										}
									},{
										xtype:'panel',
										title:memain.data[2].HealthView_third_block[0]["title"],
										id:'messageCenter',
										ui: 'eg-x-panel',
										height:339,
										margin:'0 0 8 0',
										bodyPadding:'0 13 7 13',
										updatePanel:function(data)
										{
											var me = this;
											var chartData = data[2].HealthView_third_block[0];
											var checkData = noDataComputefunction(chartData);
												if(!checkData)
												{
													try{
														var barChart = {};
														barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
														me.setTitle(chartData["title"]);
														chartData["title"] = "";
														chartData["marginTop"] = 0;
														barChart.setData(chartData,'','','bar');
														jsonData = barChart.highchart;
														$('#'+me.body.id).highcharts(jsonData);
													}catch(eo){
														me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
													}
												}
											else
												{
													me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
										},
										listeners:
										{
											boxready:function(e)
											{
												var me = this;
												var chartData = memain.data[2].HealthView_third_block[0];
												var checkData = noDataComputefunction(chartData);
												if(!checkData)
												{
													try{
														var barChart = {};
														barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
														chartData["title"] = "";
														chartData["marginTop"] = 0;
														barChart.setData(chartData,'','','bar');
														jsonData = barChart.highchart;
														$('#'+me.body.id).highcharts(jsonData);
													}catch(eo){
														me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
													}
												}
												else
												{
													me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
											}
										}
									},{
										xtype:'panel',
										title:memain.data[3].HealthView_fourth_block[0].title,
										id:'portalConnect',
										ui: 'eg-x-panel',
										height:339,
										margin:'0 0 0 0',
										bodyPadding:'0 13 7 13',
										updatePanel:function(data)
										{
											var me = this;
											var jsonData = "";
											var chartData = data[3].HealthView_fourth_block[0];
											var checkData = noDataComputefunction(chartData);
											if(!checkData)
											{
												me.setTitle(data[3].HealthView_fourth_block[0].title);
												try{
													var chartData = data[3].HealthView_fourth_block[0];
													var lineChart = {};
													lineChart = jQuery.extend(true, {}, createCombinationChart(me.id,null,null), lineChart);
													chartData["title"] = "";
													lineChart.setData(chartData,'','','line');
													jsonData = lineChart.highchart;
												}
												catch(eo)
												{													
												}
												if(chartData['DataSet'] != undefined || chartData['data'] != undefined)
													$('#'+me.id+'-body').highcharts(jsonData);	
											}
										else
											{
												me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
											}
										},
										listeners:
										{
											boxready:function(e)
											{
												var me = this;
												var jsonData = "";
												var chartData = memain.data[3].HealthView_fourth_block[0];
												var checkData = noDataComputefunction(chartData);
												if(!checkData)
												{
													try{
														var chartData = memain.data[3].HealthView_fourth_block[0];
														var lineChart = {};
														lineChart = jQuery.extend(true, {}, createCombinationChart(me.id,null,null), lineChart);
														chartData["title"] = "";
														lineChart.setData(chartData,'','','line');
														jsonData = lineChart.highchart;
													}
													catch(eo)
													{														
													}
													if(chartData['DataSet'] != undefined || chartData['data'] != undefined)
														$('#'+me.id+'-body').highcharts(jsonData);	
												}
												else
												{
													me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
											}
										}
									});
								}
							}
						});
					}
				}
			});
		}
	}
});