Ext.define('microsoftDashboard.view.office365.ServiceUsagePage', {
    extend: 'Ext.panel.Panel',
	alias: 'widget.MS365_Dashboard.serviceusagepage',
	ui:'eg-panel',
    border: false,
    autoScroll: false,
    scroll: false,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	requires:[
		'microsoftDashboard.view.ChartParentPanel'	
	],
	items:[],
	updatePage:function(jsonData)
	{
		Ext.getCmp('servUsage_header_id').setTitle(jsonData[4].Service_usage_view_header);

		var textData = jsonData[0].ServiceUsageView_first_block[0].TextBlock;
		for(var y=0;y<textData.length;y++)
		{
			Ext.getCmp(textData[y].heading).getStore().loadRawData(textData[y]);
		}
		Ext.getCmp('usageService').updatePanel(jsonData);
		Ext.getCmp('productUsage').updateChart(jsonData[1].ServiceUsageView_second_block);
		Ext.getCmp('serviceProvisionGrid_combo').getStore().loadData(jsonData[2].ServiceUsageView_third_block[1].comboArray);
		Ext.getCmp('serviceProvisionGrid_combo').setValue(jsonData[2].ServiceUsageView_third_block[1].selectedComboValue);
		Ext.getCmp('serviceProvisionGrid').setTitle(jsonData[2].ServiceUsageView_third_block[0].title);
		Ext.getCmp('serviceProvisionGridId').loadData(jsonData[2].ServiceUsageView_third_block[0]);
		Ext.getCmp('mostOperations').updatePanel(jsonData);
		Ext.getCmp('freqOperations').updatePanel(jsonData);
	},
	listeners:
	{
		afterrender:function(e)
		{
			var memain = this;
			memain.add({
				xtype:'header',
				height:25,
				margin:'0 0 5 0',
				id:'servUsage_header_id',
				title:memain.data[4].Service_usage_view_header						
			},
			{
				xtype:'panel',
				margin:'0 0 0 0',
				defaults:{
					columnWidth: 0.5,
					height: 300
				},
				layout:'column',
				manageOverflow:2,
				items:[],
				listeners:
				{
					afterrender:function()
					{
						var me = this;
						me.add({
							xtype:'panel',
							id:'userOperations',
							layout:'column',
							height: 305,
							defaults:{
								columnWidth: 0.5,
								height: 145								
							},
							margin:'0 10 10 0',
							manageOverflow:2,
							//ui: 'eg-x-panel',
							listeners:
							{
								afterrender:function(e)
								{
									var me = this;
									var textBlockData = memain.data[0].ServiceUsageView_first_block[0].TextBlock;
									for(var t=0;t<textBlockData.length;t++)
									{
										var marginVal = '0 5 5 0';
										if(t==1)
											marginVal = '0 0 5 5';
										if(t==2)
											marginVal = '5 5 0 0';
										if(t==3)
											marginVal = '5 0 0 5';
										me.add({
											xtype:'panel',
											ui: 'eg-x-panel',
											margin:marginVal,
											items:[{
												xtype:'dataview',
												id:textBlockData[t].heading,
												store: Ext.create('Ext.data.Store', {
													fields: [{ name:'iconCls', type:'string' },{ name:'backgroundCls', type:'string' },{ name:'value', type:'string' },{ name:'valueText', type:'string'},{ name:'layerLink',type:'string'}],
													autoLoad:true,
													data:textBlockData[t]
												}), 
												tpl:new Ext.XTemplate(
													'<div class="widgetholders" style="height:73%;width:87%;margin:20px;display:flex;">',
														'<tpl for=".">',
																'<tpl if="layerLink!=&quot;&quot;">',
																	'<tpl if="valueText==\'Total Operations\'">',
																		'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="flex:1;text-align:center;background:{backgroundCls};cursor:pointer" class="{backgroundCls}">',
																	'<tpl elseif="valueText==\'Unique Operations\'">',
																		'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="flex:1;text-align:center;background:{backgroundCls};cursor:pointer;" class="{backgroundCls}">',
																	'<tpl elseif="valueText==\'Unique Users\'">',
																		'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="flex:1;text-align:center;background:{backgroundCls};cursor:pointer;" class="{backgroundCls}">',
																	'<tpl elseif="valueText==\'Unique Client IPs\'">',
																		'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="flex:1;text-align:center;background:{backgroundCls};cursor:pointer;" class="{backgroundCls}">',
																	'<tpl else>',
																		'<div style="flex:1;text-align:center;background:{backgroundCls}" class="{backgroundCls}">',
																	'</tpl>',
																'<tpl else>',
																	'<div style="flex:1;text-align:center;background:{backgroundCls}" class="{backgroundCls}">',
																'</tpl>',
																'<div class="d_m_t25" style="display:inline-block;">',
																	'<div style="display:inline-block;">',
																		'<img src="/final/images/clear.png" class="{iconCls}" style="float:left;margin-right:8px">',
																		'<span class="f24-normal" style="position:relative;top:-2px">{value}',
																			'<span class="f19-normal"></span>',
																		'</span>',
																	'</div>',
																	'<div class="crl"></div>',
																	'<tpl if="backgroundCls==&quot;&quot;">',
																		'<span class="f12-normal">{valueText}</span>',
																	'<tpl else>',
																		'<span style="color:white;" class="f12-normal">{valueStatus}</span>',
																	'</tpl>',
																'</div>',
															'</div>',
														'</tpl>',
													'</div>'
												)
											}]
										});
									}
								}
							}
						},{
							xtype:'panel',
							title:memain.data[0].ServiceUsageView_first_block[0].BarChartBlock[0].title,
							id:'usageService',
							ui: 'eg-x-panel',
							margin:'0 1 10 0',
							updatePanel:function(data)
							{
								var me = this;
								me.setTitle(data[0].ServiceUsageView_first_block[0].BarChartBlock[0].title);
								var chartData = data[0].ServiceUsageView_first_block[0].BarChartBlock[0];
								try
								{
									chartData['isStateBar']=false;
									chartData['isStackingNeeded']=false;
									chartData['isStackedColumnLeg']=true;
									chartData['showLegend']=true;
									chartData['labelsNeeded']=true;
									chartData['ignoreHiddenSeriesFlag']=false;
									chartData['tick']=true;
									chartData['showYaxis']=true;
									chartData['ifLogonDashboard']=true;
									chartData['rotateXaxis']=true;
									chartData['title']="";
									var barChart = {};				
									var nodata = false;
									try
									{
										if(chartData.data == undefined || chartData.data == null)
											nodata = true;
										else
										{
											nodata = false;
											if(chartData.data.length == 0)
													nodata = true;
											for(var u=0;u<chartData.data.length;u++){
												if(chartData.data[u].value == "-" || chartData.data[u].value == "0")
													nodata = true;
												else
													nodata = false;
											}	
										}
										
										if(chartData.DataSet == undefined || chartData.DataSet == null)
											nodata = true;
										else
										{
											nodata = false;
											for(var u=0;u<chartData.DataSet.length;u++){
												if(chartData.DataSet[u].data.length == 0)
													nodata = true;
												for(var v=0;v<chartData.DataSet[u].data.length;v++){
													if(chartData.DataSet[u].data[v].value == "-" || chartData.DataSet[u].data[v].value == "0")
														nodata = true;
													else
														nodata = false;
												}	
											}
										}
																				
									}
									catch (e1)
									{											
									}
									if(!nodata)
									{
										barChart = jQuery.extend(true, {}, createBar1(this.id,null,null), barChart);
										barChart.setData(chartData,mgrDateFormat,'','stackedColumn');
										jsonData = barChart.highchart;
									}
								}
								catch (er)
								{									
								}
								if(nodata)
									$('#usageService-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
								else
									$('#'+me.body.id).highcharts(jsonData);
								me.doLayout();
							},
							listeners:
							{
								afterLayout:function()
								{
									var me = this;
									var jsonData = "";
									var chartData = memain.data[0].ServiceUsageView_first_block[0].BarChartBlock[0];
									try
									{
										chartData['isStateBar']=false;
										chartData['isStackingNeeded']=false;
										chartData['isStackedColumnLeg']=true;
										chartData['showLegend']=true;
										chartData['labelsNeeded']=true;
										chartData['ignoreHiddenSeriesFlag']=false;
										chartData['tick']=true;
										chartData['showYaxis']=true;
										chartData['ifLogonDashboard']=true;
										chartData['rotateXaxis']=true;
										chartData['title']="";

										var barChart = {};	
										var nodata = false;
										try
										{
											if(chartData.data == undefined || chartData.data == null)
												nodata = true;
											else
											{
												nodata = false;
												if(chartData.data.length == 0)
														nodata = true;
												for(var u=0;u<chartData.data.length;u++){
													if(chartData.data[u].value == "-" || chartData.data[u].value == "0")
														nodata = true;
													else
														nodata = false;
												}	
											}
											
											if(chartData.DataSet == undefined || chartData.DataSet == null)
												nodata = true;
											else
											{
												nodata = false;
												for(var u=0;u<chartData.DataSet.length;u++){
													if(chartData.DataSet[u].data.length == 0)
														nodata = true;
													for(var v=0;v<chartData.DataSet[u].data.length;v++){
														if(chartData.DataSet[u].data[v].value == "-" || chartData.DataSet[u].data[v].value == "0")
															nodata = true;
														else
															nodata = false;
													}	
												}
											}
																					
										}
										catch (e1)
										{											
										}
										if(!nodata)
										{
											barChart = jQuery.extend(true, {}, createBar1(this.id,null,null), barChart);
											barChart.setData(chartData,mgrDateFormat,'','stackedColumn');
											jsonData = barChart.highchart;
										}
									}
									catch (er)
									{										
									}
									if(nodata)
										$('#usageService-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
									else
										$('#'+me.body.id).highcharts(jsonData);
								},
								'afterrender':function()
								{
									var chartData = memain.data[0].ServiceUsageView_first_block[0].BarChartBlock[0];
									var checkData = noDataComputefunction(chartData);
									if(!checkData)
									{
										$('#usageService').css({'cursor':'pointer'});
									}
									$('#usageService').click(function(){
										var chartData = memain.data[0].ServiceUsageView_first_block[0].BarChartBlock[0];
										var checkData = noDataComputefunction(chartData);
										if(!checkData)
										{
											scrollAnimation('productUsage');
										}
									});
								}

							}
						});
					}
				}
			},{
				xtype:'container',
				padding:0,
				id:'geoBarIns',
				bodyPadding:0,
				flex:1,
				layout: {
					type: 'card',
					reserveScrollbar: true 
				},
				items:[{
					xtype:'chartparentpanel',
					margin:0,
					id:'productUsage',
					data:memain.data[1].ServiceUsageView_second_block,
					orgData:memain.data[1].ServiceUsageView_second_block,
					flex:1						
				}]
			},{
				xtype:'container',
				height:410,
				ui:'eg-container',
				flex:1,
				margin:'0 1 8 0',
				layout:{
					type:'fit'
				},
				listeners:
				{
					afterrender:function(e)
					{
						var me = this;
						me.add({
							xtype:'panel',
							padding:10,
							ui:'eg-x-panel',
							layout:'fit',
							id:'serviceProvisionGrid',
							title:memain.data[2].ServiceUsageView_third_block[0].title,
							margin:0,
							tools:[{
								xtype: 'combo',
								fieldLabel:'',
								cls:'dropdown',
								labelSeparator:'',
								width:100,
								labelStyle: {'white-space':'nowrap;'},
								//hidden:(!showComboBar),									
								id:"serviceProvisionGrid_combo",
								margin:"0 5 0 0",
								displayField : 'name',
								valueField : 'value',
								queryMode : 'local',
								store:Ext.create('Ext.data.Store',{
									data : memain.data[2].ServiceUsageView_third_block[1].comboArray,
									fields:['name','value']
								}),
								value:memain.data[2].ServiceUsageView_third_block[1].selectedComboValue,
								listeners: {
									change: function(ele, newValue, oldValue) 
									{
										var compType = requestParams.dashboard;
										var seltab = requestParams.selectedTab;
										var comboTime = "";
										try
										{
											comboTime = Ext.getCmp("serviceProvisionGrid_combo").getValue();
										}
										catch (e)
										{
											comboTime = "";
										}
										
										var accountValue = Ext.getCmp('dashTypeComId').getValue();
										var tabUrl = "/final/servlet/com.eg.EgCommonDashboardController?isFrom=msdashboard&iniName=eg_msdashboard&userBased=true&fromMenu=true&showConfig=true&dashboard_name="+compType+"&selectedTab="+seltab+"&time_line=2%20days&comboTimeLine="+comboTime+"&isRefresh=true&accountValue="+accountValue;

										Ext.getCmp('serviceProvisionGridId_grid').el.mask('Loading...');
										Ext.Ajax.request({
											url : tabUrl,
											method : 'POST',
											scope:this,
											timeout:280000,
											success : function(response, opts)
											{
												var jsonText = response.responseText;
												var jsonData = Ext.decode(jsonText);
												try
												{
													Ext.getCmp('serviceProvisionGridId').loadData(jsonData.loadViewDetails[2].ServiceUsageView_third_block[0]);	
												}
												catch (e)
												{
												}
												
											}
										});
										Ext.getCmp('serviceProvisionGridId_grid').el.unmask();
									}
								}
							}],
							items:[{
								xtype:'commongrid',
								width:'100%',
								id:'serviceProvisionGridId',								
								data:memain.data[2].ServiceUsageView_third_block[0]
							}],
							listeners:
							{
							 afterrender:function()
							 {
								 try
								 {
									var gridDataLength=memain.data[2].ServiceUsageView_third_block[0].data.items.length;
									 if(gridDataLength<10 && gridDataLength>0)
									 {
										me.setHeight(106+(30*gridDataLength)+4);
									 }
								 }
								 catch (e)
								 {
								 }
								 
							 }
							}
						});
					}
				}
			},{
				xtype:'panel',
				defaults:{
					columnWidth: 0.5,
					height: 300
				},
				layout:'column',
				manageOverflow:2,
				items:[],
				listeners:
				{
					afterrender:function()
					{
						var me = this;
						me.add({
							xtype:'panel',
							title:memain.data[3].ServiceUsageView_fourth_block[0]["title"],
							id:'freqOperations',
							ui: 'eg-x-panel',
							height:360,
							margin:'0 10 10 0',
							bodyPadding:'0 13 7 13',
							updatePanel:function(data)
							{
								var me = this;
								var chartData = data[3].ServiceUsageView_fourth_block[0];
								var checkData = noDataComputefunction(chartData);
								if(!checkData)
								{
									try{
										var barChart = {};
										barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
										
										me.setTitle(chartData["title"]);
										chartData["title"] = "";
										chartData["marginTop"] = 0;
										barChart.setData(chartData,'','','bar');
										jsonData = barChart.highchart;
										$('#'+me.body.id).highcharts(jsonData);
									}catch(eo){
										me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
									}
								}
								else
								{
									this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
								}
							},
							listeners:
							{
								boxready:function(e)
								{
									var me = this;
									var chartData = memain.data[3].ServiceUsageView_fourth_block[0];
									var checkData = noDataComputefunction(chartData);
									if(!checkData)
									{
										try{
											var barChart = {};
											barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
											chartData["title"] = "";
											chartData["marginTop"] = 0;
											barChart.setData(chartData,'','','bar');
											jsonData = barChart.highchart;
											$('#'+me.id+'-body').highcharts(jsonData);
											
										}catch(eo){
											me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
										}	
									}
									else
									{
										this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
									}
								}
							}
						},{
							xtype:'panel',
							title:memain.data[3].ServiceUsageView_fourth_block[1]["title"],
							id:'mostOperations',
							ui: 'eg-x-panel',
							height:360,
							margin:'0 1 10 0',
							bodyPadding:'0 13 7 13',
							updatePanel:function(data)
							{
								var me = this;
								var chartData = data[3].ServiceUsageView_fourth_block[1];
								var checkData = noDataComputefunction(chartData);
								if(!checkData)
								{
									try{
										var barChart = {};
										barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
										me.setTitle(chartData["title"]);
										chartData["title"] = "";
										chartData["marginTop"] = 0;
										barChart.setData(chartData,'','','bar');
										jsonData = barChart.highchart;
										$('#'+me.id+'-body').highcharts(jsonData);
									}catch(eo){
										me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
									}
								}
								else
								{
									this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
								}
							},
							listeners:
							{
								
								boxready:function(e)
								{
									var me = this;
									var chartData = memain.data[3].ServiceUsageView_fourth_block[1];
									var checkData = noDataComputefunction(chartData);
									if(!checkData)
									{
										try{
											var barChart = {};
											barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
											chartData["title"] = "";
											chartData["marginTop"] = 0;
											barChart.setData(chartData,'','','bar');
											jsonData = barChart.highchart;
											$('#'+me.body.id).highcharts(jsonData);
										}catch(eo){
											me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
										}
									}
									else
									{
										this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
									}
								}
							}
						});
					}
				}
			});
		}
	}
});