Ext.define('microsoftDashboard.view.office365.UsersGroupsPage', {
    extend: 'Ext.panel.Panel',
	alias: 'widget.MS365_Dashboard.usersgroupspage',
	ui:'eg-panel',
    border: false,
    autoScroll: false,
    scroll: false,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	requires:[
		'microsoftDashboard.view.ChartParentPanel'	
	],
	items:[],
	updatePage:function(jsonData)
	{
		Ext.getCmp('userGrp_header_id').setTitle(jsonData[4].Users_group_view_header);

		var firstBlockArray = jsonData[0].UsersGroupView_first_block;
		for(var t=0;t<firstBlockArray.length;t++)
		{
			Ext.getCmp(firstBlockArray[t].measure).getStore().loadRawData(firstBlockArray[t]);
		}

		Ext.getCmp('newModgroupsView').getStore().loadRawData(jsonData[1].UsersGroupView_second_block[0].TextBlock);

		Ext.getCmp('groupDistType').updatePanel(jsonData);
		Ext.getCmp('emptyGroups').updatePanel(jsonData);

		Ext.getCmp('multgrp_activity').updateChart(jsonData[2].UsersGroupView_third_block);
		Ext.getCmp('multgrp_activity').orgData = jsonData[2].UsersGroupView_third_block;

		Ext.getCmp('serviceProvisionGridId').loadData(jsonData[3].UsersGroupView_fourth_block[0]);	
		Ext.getCmp('serviceProvisionGridId').orgData = jsonData[3].UsersGroupView_fourth_block[0];	

	},
	listeners:
	{
		afterrender:function(e)
		{
			var memain = this;
			
			memain.add({
				xtype:'header',
				height:25,
				margin:'0 0 5 0',
				id:'userGrp_header_id',
				title:memain.data[4].Users_group_view_header						
			},
			{
				xtype:'container',
				ui:'eg-container',
				height:95,
				layout:{
					type:'hbox',
					align:'stretch'
				},
				listeners:
				{
					afterrender:function(e)
					{
						var me = this;
						var firstBlockArray = memain.data[0].UsersGroupView_first_block;
						for(var t=0;t<firstBlockArray.length;t++)
						{
							me.add({
								xtype:'dataview',
								cls:'dividerGradient',
								ui:'uniqueSessions',
								id:firstBlockArray[t].measure,
								minWidth:190,
								flex:1,
								store: Ext.create('Ext.data.Store', {
									fields: [{ name:'iconCls', type:'string' },{ name:'backgroundCls', type:'string' },{ name:'value', type:'string' },{ name:'valueText', type:'string'},{ name:'layerLink',type:'string'},{ name:'stateValue',type:'string'}],
									autoLoad:true,
									data:firstBlockArray[t]
								}), 
								tpl:new Ext.XTemplate(
									'<div class="widgetholders" style="height:100%;width:100%;display:flex;align-items:center;">',
										'<tpl for=".">',
												'<tpl if="xindex === 1">',
													'<tpl if="layerLink!=&quot;&quot;">',
														'<tpl if="valueText==\'Sign in Denied Users\'">',
															'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="position:relative;flex:1;text-align:center;background:{backgroundCls};cursor:pointer;" class="{backgroundCls}">',
														'<tpl elseif="valueText==\'Deleted Users\'">',
															'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="position:relative;flex:1;text-align:center;background:{backgroundCls};cursor:pointer;" class="{backgroundCls}">',
														'<tpl elseif="valueText==\'Users with Non-expiring Passwords\'">',
															'<div onClick="javascript:layerModelLinks(\'{layerLink}\')"  style="position:relative;flex:1;text-align:center;background:{backgroundCls};cursor:pointer;" class="{backgroundCls}">',
														'<tpl else>',
															'<div style="position:relative;flex:1;text-align:center;background:{backgroundCls}" class="{backgroundCls}">',
														'</tpl>',
													'<tpl else>',
														'<div style="position:relative;flex:1;text-align:center;background:{backgroundCls}" class="{backgroundCls}">',
													'</tpl>',
												'<tpl elseif="xindex === 2">',
													'<div style="position:relative;flex:1;text-align:center;background:{backgroundCls}" class="{backgroundCls}">',
												'<tpl else>',
													'<div style="position:relative;flex:1;text-align:center;background:{backgroundCls}" class="{backgroundCls} ms-separator">',	
												'</tpl>',
												'<div>',
													'<div style="display:inline-block;">',
														'<tpl if="stateValue">',
															'<img src="/final/images/clear.png" class="stateIcon22_{stateValue}" style="float:left;margin-right:8px;margin-top:3px;">',
														'<tpl else>',
															'<img src="/final/images/clear.png" class="{iconCls}" style="float:left;margin-right:8px">',
														'</tpl>',														
														'<span class="f24-normal">{value}',
															//unit
															'<span class="f19-normal"></span>',
														'</span>',
													'</div>',
													//'<div class="crl"></div>',
													//'<tpl if="backgroundCls">'
													
													'<tpl if="backgroundCls==&quot;&quot;">',
														'<div style="width:100%;margin:auto;" class="f12-normal">{valueText}</div>',
													'<tpl else>',
														'<div style="width:100%;margin:auto;color:white;" class="f12-normal">{valueStatus}</div>',
													'</tpl>',
												'</div>',
											'</div>',
										'</tpl>',
									'</div>'
								)
							});
						}
						
					}
				}
			},
			{
				xtype:'container',
				//ui:'eg-container',
				height:200,
				layout:'column',
				margin:'10 0 10 0',
				listeners:
				{
					afterrender:function(e)
					{
						var me = this;
						me.add({
							xtype:'panel',
							ui: 'eg-x-panel',
							//id:'latencyRequest',
							columnWidth:.2,
							height:200,
							margin:'0 10 0 0',
							padding:'0 20',
							items:[{
								xtype:'dataview',
								id:'newModgroupsView',
								store: Ext.create('Ext.data.Store', {
									 fields: [{ name:'state', type:'string' },{ name:'iconCls', type:'string' },{ name:'noData', type:'boolean' },{ name:'value', type:'number' },{ name:'valueText', type:'string' },{ name:'sessions' },{ name:'data' },{name:'graphID', type:'string' },{name:'error', type:'string' },{name:'Mailboxes'},{name:'Mails'},{ name:'layerLink',type:'string'}],
									autoLoad:true,
									data:memain.data[1].UsersGroupView_second_block[0].TextBlock
								}),
								tpl: new Ext.XTemplate(
									'<div class="widgetholders" style="height:100%;width:100%;display:grid;align-items:stretch;">',
										'<tpl for=".">',
										 	'<tpl if="xindex === 1">',
												'<div style="position:relative;display:flex;align-items:center;" class="ms-separator-vertical">',
										 	'<tpl else>',
										 		'<div style="position:relative;display:flex;align-items:center;">',
											'</tpl>',											
											'<tpl if="layerLink!=&quot;&quot;">',
												'<tpl if="valueText==\'Modified Groups\'">',
													'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="display:inline-block;width: 100%;text-align: center;cursor:pointer;">',
												'<tpl else>',
													'<div style="display:inline-block;width: 100%;text-align: center;">',
												'</tpl>',
											'<tpl else>',
												'<div style="display:inline-block;width: 100%;text-align: center;">',
											'</tpl>',
													'<div style="display:inline-block;">',
														'<img src="/final/images/clear.png" class="{iconCls}" style="float:left;margin-top:5px;margin-right:8px">',
														'<tpl if="error">',
															'<span class="f28-normal">-',
														'<tpl else>',
															'<span class="f28-normal">{value}',
														'</tpl>',
															//unit
															'<span class="f19-normal"></span>',
														'</span>',
													'</div>',
													'<div class="crl"></div>',
													'<div class="f12-normal">{valueText}</div>',
												'</div>',
											'</div>',
										'</tpl>',
									'</div>'
								)
							}]
						},{
							xtype:'panel',
							id:'groupDistType',
							ui: 'eg-x-panel',
							margin:'0 10 0 0',
							height:200,
							columnWidth:.4,
							updatePanel:function(data)
							{
								this.setTitle(data[1].UsersGroupView_second_block[0].DonutBlock1[0].title);
								Ext.getCmp('groupDistTypeView').getStore().loadRawData(data[1].UsersGroupView_second_block[0].DonutBlock1[0]);
								Ext.getCmp('groupDistTypeView').updateView(data[1].UsersGroupView_second_block[0].DonutBlock1[0]);
							},
							listeners:
							{
								afterrender:function()
								{
									var me = this;
									me.setTitle(memain.data[1].UsersGroupView_second_block[0].DonutBlock1[0].title);
									me.add({
										xtype:'dataview',
										id:'groupDistTypeView',
										padding:5,
										layout:{type:'vbox',pack:'center'},
										store: Ext.create('Ext.data.Store', {
											 fields: [{ name:'state', type:'string' },{ name:'name', type:'string' },{ name:'title', type:'string' },{ name:'noData', type:'boolean' },{ name:'value', type:'number' },{ name:'valueText', type:'string' },{ name:'sessions' },{ name:'data' },{name:'graphID', type:'string' },{name:'DataSet'},{name:'Mails'}],
											autoLoad:true,
											data:memain.data[1].UsersGroupView_second_block[0].DonutBlock1[0]
										}),
										tpl: new Ext.XTemplate(
											'<tpl for=".">',
											'<div class="widgetholders" style="margin-top:-5px;border:0px solid orange !important">',				
												'<div class="b_box1" style="margin:auto;width:100%;display:inline-flex;">',
												  '<div class="f14-bold"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span></ span></div>',
													 '<div style="margin:auto"><div style="border:0px solid blue;margin:0px;text-align:center;width:140px;height:135px;float:left" id="'+me.id+'_bgDonut"></div>',
													 '<div style="float:left">',
														'<div class="sessions_legends" style="position:relative;text-align:center;height:100px;float:right;margin-top:0;margin-left:15px !important">',
														'<table style="top:20px;margin-right:0px;width:60%;height: 100%;position:relative;text-align:center;">',
														'<tpl for="DataSet">',
															'<tpl for="data">',
															 '<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
																'<tr><td style="padding:0px 0px 8px 0px !important;"><div class="widgetholders {handSymbol}" ><div style="display:table-cell;margin-top:-10px;margin-right:5px;"><div class="msChartLegend" style="background:{color}"></div></div><div  style="display:table-cell;white-space: nowrap;" class="f11-normal">{name}&nbsp;({value})</div></div></td><td class="f11-normal"></td></tr>',
															 '</tpl>',
															'</tpl>',
														'</tpl>',
														'</table>',
														'</div>',
													'</div>',											
												'</div></div>',
											'</tpl>',
											'</div>'
										),
										updateView:function(viewData)
										{
											var checkData = noDataComputefunction(viewData);
											if(!checkData)
											{
												try
												{
													var pieChart = {};
													var chartData = viewData;
													chartData['outersize']='125%';
													chartData['innersize']='80%';
													chartData['showLegend']=false;
													try
													{
														var seriesData = chartData.DataSet[0].data;
														var allZero = 0;
														for(var z=0;z<seriesData.length;z++)
														{
															allZero += seriesData[z].y;
														}
														if(allZero == 0)
															chartData.DataSet[0].data[seriesData.length] = {name:"-", color: "#cdcdcd", y:100, value: "-"};
													}
													catch (e)
													{
													}
													pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
													pieChart.setData(chartData,'','','bgdonut');
													jsonData = pieChart.highchart;													
												}
												catch (er)
												{													
												}
												$('#'+me.id+"_bgDonut").highcharts(jsonData);	
											}
										else
											{
												this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
											}

										},
										listeners:{
											viewready:function(){
												var chartData = memain.data[1].UsersGroupView_second_block[0].DonutBlock1[0]
												var checkData = noDataComputefunction(chartData);
												if(!checkData)
												{
													try
													{
														var pieChart = {};
														chartData['outersize']='125%';
														chartData['innersize']='80%';
														
														chartData['showLegend']=false;
														try
														{
															var seriesData = chartData.DataSet[0].data;
															var allZero = 0;
															for(var z=0;z<seriesData.length;z++)
															{
																allZero += seriesData[z].y;
															}
															if(allZero == 0)
																chartData.DataSet[0].data[seriesData.length] = {name:"-", color: "#cdcdcd", y:100, value: "-"};
														}
														catch (e)
														{
														}
														pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
														pieChart.setData(chartData,'','','bgdonut');
														jsonData = pieChart.highchart;													
													}
													catch (er)
													{														
													}
													$('#'+me.id+"_bgDonut").highcharts(jsonData);
												}
											else
												{
													this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
											}
										},
									});
								}
							}
						},{
							xtype:'panel',
							id:'emptyGroups',
							ui: 'eg-x-panel',
							margin:0,
							height:200,
							columnWidth:.4,
							updatePanel:function(data)
							{
								this.setTitle(data[1].UsersGroupView_second_block[0].DonutBlock2[0].title);
								Ext.getCmp('emptyGroupsView').getStore().loadRawData(data[1].UsersGroupView_second_block[0].DonutBlock2[0]);
								Ext.getCmp('emptyGroupsView').updateView(data[1].UsersGroupView_second_block[0].DonutBlock2[0]);
							},
							listeners:
							{
								afterrender:function()
								{
									var me = this;
									me.setTitle(memain.data[1].UsersGroupView_second_block[0].DonutBlock2[0].title);
									me.add({
										xtype:'dataview',
										id:'emptyGroupsView',
										padding:5,
										layout:{type:'vbox',pack:'center'},
										store: Ext.create('Ext.data.Store', {
											 fields: [{ name:'state', type:'string' },{ name:'name', type:'string' },{ name:'title', type:'string' },{ name:'noData', type:'boolean' },{ name:'value', type:'number' },{ name:'valueText', type:'string' },{ name:'sessions' },{ name:'data' },{name:'graphID', type:'string' },{name:'DataSet'},{name:'Mails'},{ name:'layerLink',type:'string'}],
											autoLoad:true,
											data:memain.data[1].UsersGroupView_second_block[0].DonutBlock2[0]
										}),
										tpl: new Ext.XTemplate(
											'<tpl for=".">',
											'<div class="widgetholders" style="margin-top:-5px;border:0px solid blue !important">',				
												'<div class="b_box1" style="margin:auto;width:100%;display:inline-flex;">',
												  '<div class="f14-bold"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span></ span></div>',
													 '<div style="margin:auto"><div  style="border:0px solid blue;margin-top:0px;text-align:center;width:140px;height:135px;float:left" id="'+me.id+'_bgDonut"></div>',
													 '<div style="float:left">',
														'<div class="sessions_legends" style="position:relative;text-align:center;height:100px;float:right;margin-top:0;margin-left:15px !important">',
														'<table style="top:20px;margin-right:0px;width:60%;height: 100%;position:relative;text-align:center;">',
														'<tpl for="DataSet">',
															'<tpl for="data">',
															 '<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
																'<tpl if="layerLink!=&quot;&quot;">',
																	'<tr onClick="javascript:layerModelLinks(\'{layerLink}\')" style="cursor:pointer"><td style="padding:0px 0px 8px 0px !important;"><div class="widgetholders {handSymbol}" ><div style="display:table-cell;margin-top:-10px;margin-right:5px;color:{color}"><div class="msChartLegend" style="background:{color}"></div></div><div  style="display:table-cell;white-space: nowrap;" class="f11-normal">{name}&nbsp;({value})</div></div></td><td class="f11-normal"></td></tr>',
																'<tpl else>',
																	'<tr><td style="padding:0px 0px 8px 0px !important;"><div class="widgetholders {handSymbol}" ><div style="display:table-cell;margin-top:-10px;margin-right:5px;color:{color}"><div class="msChartLegend" style="background:{color}"></div></div><div  style="display:table-cell;white-space: nowrap;" class="f11-normal">{name}&nbsp;({value})</div></div></td><td class="f11-normal"></td></tr>',
																'</tpl>',
															 '</tpl>',
															'</tpl>',
														'</tpl>',
														'</table>',
														'</div>',
													'</div>',											
												'</div></div>',
											'</tpl>',
											'</div>'
										),
										updateView:function(viewData)
										{
											var checkData = noDataComputefunction(viewData);
												if(!checkData)
												{
													try
													{
														var pieChart = {};
														var chartData = viewData;
														var dontCheck = true;
														chartData['outersize']='125%';
														chartData['innersize']='80%';
														
														chartData['showLegend']=false;
														try
														{
															var seriesData = chartData.DataSet[0].data;
															var allZero = 0;
															for(var z=0;z<seriesData.length;z++)
															{
																allZero += seriesData[z].y;
															}
															if(allZero == 0)
																chartData.DataSet[0].data[seriesData.length] = {name:"-", color: "#cdcdcd", y:100, value: "-"};
														}
														catch (e)
														{
														}
														pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
														pieChart.setData(chartData,'','','bgdonut');
														jsonData = pieChart.highchart;													
													}
													catch (er)
													{														
													}
													$('#'+me.id+"_bgDonut").highcharts(jsonData);
												}
												else
												{
													this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
										},
										listeners:{
											viewready:function(){
												var chartData = memain.data[1].UsersGroupView_second_block[0].DonutBlock2[0];
												var checkData = noDataComputefunction(chartData);
												if(!checkData)
												{
													try
													{
														var pieChart = {};
														var dontCheck = true;
														chartData['outersize']='125%';
														chartData['innersize']='80%';
														chartData['showLegend']=false;
														try
														{
															var seriesData = chartData.DataSet[0].data;
															var allZero = 0;
															for(var z=0;z<seriesData.length;z++)
															{
																allZero += seriesData[z].y;
															}
															if(allZero == 0)
																chartData.DataSet[0].data[seriesData.length] = {name:"-", color: "#cdcdcd", y:100, value: "-"};
														}
														catch (e)
														{
														}
														pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
														pieChart.setData(chartData,'','','bgdonut');
														jsonData = pieChart.highchart;													
													}
													catch (er)
													{														
													}
													$('#'+me.id+"_bgDonut").highcharts(jsonData);
												}
												else
												{
													this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
											}
										},
									});
								}
							}
						});
					}
				}
			});
			memain.add({
				xtype:'panel',
				id:'res_acc_pan_id',
				ui:'eg-accordion-panel',
				padding:0,
				margin:'0 0 10 0',
				//fill:true,
				flex:2,
				layout: {
					type: 'accordion',
					animate: true,
					multi: true,				
				},
				items:[{
					title:memain.data[5].UsersGroupView_third_block_header,
					width:'100%',
					layout:{type:'anchor',anchor:'50%'},
					margin:'0 2 0 0',
					bodyPadding:'0 20 20 20',
					collapsed :false,
					items:[{
						xtype:'chartparentpanel',
						id:'multgrp_activity',
						//bodyPadding:'0 1'
						//margin:'0 0 0 12',
						bodyPadding:'0 0 0 0',
						style:{'left':'-12px'},
						ifRes:true,
						data:memain.data[2].UsersGroupView_third_block,
						orgData:memain.data[2].UsersGroupView_third_block,
						flex:1						
					}],
					listeners: {
						afterlayout: function() {
							var res_chartObj = Ext.getCmp('multgrp_activity');
							
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topUserJsonDataObj=null;
									try
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}
									catch (ee)
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}

									if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
										continue;

									//var chartObj_id = 'chartParent_multgrp_activity_'+res_chartObj.orgData[i].chartCId+'_'+i;
									var chartObj_id = '';
									if(topUserJsonDataObj.chartCId != undefined && topUserJsonDataObj.chartCId != null)
										chartObj_id = 'chartParent_multgrp_activity_'+topUserJsonDataObj.chartCId+'_'+i;
									else
										chartObj_id = 'chartParent_multgrp_activity_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")

									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
									{
										$('#'+chartObj_id+'-body').width('100%');
										var skinBorder=( (strSkin=='Dark' || strSkin=='dark') )?'#525252':'#f2f2f2';
										if(i%2 == 0)
										{
											Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="1px solid "+skinBorder;
										}
										else
										{
											Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="0px solid "+skinBorder;
										}
											

										if((res_chartObj.data.length-2)>i)
											Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="1px solid "+skinBorder;
										else
											Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="0px solid "+skinBorder;
									}
								}
							}
						},
						expand: function() 
						{						
							var res_chartObj = Ext.getCmp('multgrp_activity');
							
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{							
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topUserJsonDataObj=null;
									try
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}
									catch (ee)
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}

									if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
										continue;
									
									if(topUserJsonDataObj.chartCId != undefined && topUserJsonDataObj.chartCId != null)
										chartObj_id = 'chartParent_multgrp_activity_'+topUserJsonDataObj.chartCId+'_'+i;
									else
										chartObj_id = 'chartParent_multgrp_activity_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")
									
									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
										Ext.getCmp(chartObj_id).updateChart(chartObj_id+'-body',topUserJsonDataObj,'Line');									
								}
							}
						}
					}
				},{
					title:memain.data[6].UsersGroupView_fourth_block_header,
					width:'100%',
					layout:{type:'anchor',anchor:'50%'},
					margin:'10 2 0 0',
					collapsed :false,
					items:[{
						xtype:'panel',
						padding:'0 10 10 10',
						layout:'fit',
						height:410,
						id:'serviceProvisionGrid',						
						margin:0,							
						items:[{
							xtype:'commongrid',
							width:'99%',
							id:'serviceProvisionGridId',								
							data:memain.data[3].UsersGroupView_fourth_block[0],
							orgData:memain.data[3].UsersGroupView_fourth_block[0]
						}],
					listeners:
							{
							 afterrender:function()
							 {
								 try
								 {
									var gridDataLength=memain.data[3].UsersGroupView_fourth_block[0].data.items.length;
									 if(gridDataLength<10 && gridDataLength>0)
									 {
										this.setHeight(68+(30*gridDataLength));
									 }
								 }
								 catch (e)
								 {
								 }
								 
							 }
							},
					}],
					listeners:{
						expand: function() 
						{
							var grid_obj = Ext.getCmp('serviceProvisionGridId');
							grid_obj.loadData(grid_obj.orgData);	
						}
					}
				}]
			});
		}
	}
});