Ext.define('MyDashBoard.view.AddDDMetrics', {
    extend: 'Ext.window.Window',
    alias: 'widget.ddmetrics',
    requires: ['Ext.ux.form.MultiSelect', 'MyDashBoard.view.ComparisonTable','utilities.CustomGrid','utilities.ScrollCombo'],
    title: MetricDDTitle,
    width:strSkin=="Light"?900:880,
    modal: true,
	border:true,
	frame:true,
    autoShow: false,
	ghost:false,
	padding:'0 0 0 0',
	autoScroll:true,
	header:{
		height:32,
		padding:'0 20',
		margin:0
	},
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	autoShow : false,
    cls:'myDashboardwindow',
	ui:'newPopupWindow newplainHeader',
  // height:550,
	blockId : null,
	isFluidWindowConfigPopup : false,
	closeAction : 'destroy',
	initComponent : function()
	{
		this.buttonAlign = 'center';
		this.callParent();
	},
    items: [{
        xtype: 'form',
			itemId : 'ddconfigForm',
		//	hidden : true,
			buttonAlign: 'center',
        defaults: {
            padding: '3',
            margin: '3 3 20 3',
        },
        buttons: [{
            text: addDispBtn,
			id : 'addDDBlockConfig',
			name : 'addDDBlockConfig',
            cls: 'buttonNew',
			padding:'0 10 0 10',
		//	hidden : true
        }
			],
        items: [{
					xtype: 'container',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						margin: '0 10 0px 0px',
						labelSeparator:'',
					},
					items: [{
                        xtype: 'container',
                        defaults: {
                            labelAlign: 'top',
							labelSeparator:''
                        },
                        items: [{
                        xtype: 'scrollcombo',
						id : 'ddCompTypeCombo',
						name : 'ddCompTypeCombo',
						cls: 'dropdown',
                        fieldLabel: 'Component Type',
                        width: 250,
						margin:'10 0 0 10',
                        store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
					//	hidden : true,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						value : notApplicable
                    },
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						margin: '10px 0px 0px 10px',
						fieldLabel: 'Test',
						id: 'testCombo',
						name: 'testCombo',
					//	hidden : true,
						width: 250,
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: []
						}),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						value : notApplicable
					},
					{
						xtype:'textareafield',
						//width: 150,
						width: 250,
						fieldLabel:excludeDescriptorLbl,
						cls: 'text-area excludeDescriptor_textareafield',
						margin: '10px 0px 0px 10px',
						labelWidth:130,
						labelAlign: 'top',
						id:'excludeDesc',
						emptyText:excludeDescriptorEmptLbl,
						autoScroll:true,
						//cols:this.blckType!=null && (this.blckType =="BarChart")? 35 :45,
						//cols:45,
						minHeight:50,
						rows:1,
					}
					]
				},
				{
					 xtype: 'container',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						margin: '0 10 0px 0px',
						labelSeparator:''
					},
					items: [{
                        xtype: 'container',
                        defaults: {
                            labelAlign: 'top',
							labelSeparator:''
                        },
                        items: [
							{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: 'Component',
								id : 'ddcompCombo',
								name : 'ddcompCombo',
								margin:'10 0 0 10',
						//		hidden : true,
								width: 250,
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField','valueField'],
									data: []
								}),
								editable:false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								value : notApplicable
							},
							{
								xtype: 'scrollcombo',
								id: 'ddMeasuresCombo',
								name: 'ddMeasuresCombo',
								margin: '10px 0px 0px 10px',
								cls: 'dropdown',
								fieldLabel: 'Measure',
								width: 250,
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField','valueField'],
									data: []
								}),
								editable:false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								value : notApplicable
						//		hidden : true
							}]
					}]
                }, {
                    xtype: 'container',
					defaults: {
                        labelAlign: 'top',
						labelSeparator:''
                    },
				
		    margin:'0 0 10 0',
					
                    items: [
				{
					xtype :'label',
					id : 'dd_measure_cols',
					name : 'dd_measure_cols',
					 margin: '10px 0px 5px 10px',
			//		hidden : true
				},
				{
					xtype:'container',
					layout:{type:'vbox',align:'stretch'},
					width : 280,
					cls:'darkbox',
					//height:145,
					height:125,
					id:'ddSearchBoxCont',
					items:[{
						xtype:'trigger',
						margin : '10',
						id : 'ddSearchTextBox',
						name : 'ddSearchTextBox',
						width : 228,
						cls: 'whitedropdown_search',
						emptyText : 'Search DD Column(s)',
						metComboStore : null,
					//	hidden : true,
						listeners :
						{
							'change' : function(triggerField, newValue, oldValue, eOpts) {
								var me = this;
								var metStore = me.metComboStore;
								if(metStore==null)
								{
									me.metricComboStore = this.up('form').getForm().findField('ddMeasureCols').getStore();
									metStore = me.metricComboStore;
								}
								if(newValue=="*")
								{
									metStore.clearFilter();
								}
								else
								{
									if(newValue.lastIndexOf("*")==(newValue.length-1))
									{
										newValue = newValue.substr(0,(newValue.length-1));
									}
									metStore.clearFilter();
									if (newValue) {
										var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
										metStore.filter({
											filterFn: function(record) {
												return matcher.test(record.get('displayField')) ;
											}
										});
									}
								 triggerField.focus();
								}
							 }
						}
					},
					{
						xtype: 'multiselect',
					 //   title: 'Descriptors',
						margin: '8px 0px 0px 0px',
						id: 'ddMeasureCols',
						name: 'ddMeasureCols',
						baseCls: 'egmultiselect',
						multiSelect: true,
						height: 74,
						width: 200,
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: []
						}),
						scroll : true,
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						value : notApplicable,
						listConfig:{
						id : 'ddMeasureColsBList',
						name : 'ddMeasureColsBList',
						simpleSelect: true,
						itemTpl:new Ext.XTemplate(
							'<tpl for=".">',
								'<div id="{valueField}"  style="text-align:left">{displayField}</div>',
							'</tpl>'
						),
						listeners:{
							itemdblclick:function(thisItems, record, item, index, e, eOpts){
								var me = this
								var selection = thisItems.getSelectionModel().getSelection();
								for (var i=0; i< selection.length; i++)
								{
												
									mySelectionHeaders = selection[i].data.displayField;
									mySelectionHeadersd = selection[i].data.valueField;
												
									var editor = new Ext.Editor({
											updateEl: true,
											shadow:false,
											border:false,
											width:230,
											field: {
												xtype: 'textfield',
												height:26,
												width :230												
											},
											ignoreNoChange : true,
											listeners :
											{
												'beforecomplete' : function(meEdtr,value,startValue,eOpts)
												{
													if(value==null || value==''  || value=='-1')
													{
														meEdtr.setValue(startValue);
														Ext.Msg.show({
															title: 'Alert',
															msg: componentEmptyMsg,
															buttons: Ext.MessageBox.OK,
															icon: Ext.MessageBox.WARNING
														});
														return false;
													}
													else if(me.store.find('displayField', value, 0, false, true, true)!=-1)
													{
														meEdtr.cancelEdit(false);
														Ext.Msg.show({
															title: 'Alert',
															msg: compNameAlreadyExists,
															buttons: Ext.MessageBox.OK,
															icon: Ext.MessageBox.WARNING
														});
														return false;

													}
													else if(myDashApp.getController("Main").checkSpecialCharacter(value))
													{
														Ext.Msg.show({
														title: 'Alert',
														msg: compnameSpecialCharacterAlert,
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.WARNING
														 });
														return;
													}
												},													
												'complete' : function(meEdtr, value, startValue, eOpts)
												{
													me.store.suspendEvents();
													me.store.insert(index,{'displayField':this.getValue(),'valueField':mySelectionHeadersd}); 
													me.store.remove(selection[i], true);
													me.store.resumeEvents();
												}
														
											}
										});
										if(mySelectionHeadersd!="-1")
										{
											var el = Ext.get(mySelectionHeadersd); // The element to 'edit'
											editor.startEdit(el,el.getValue());
										}
									//me.store.remove(selection[i]);
												
								//	alert('--'+mySelectionHeaders);
							//	me.store.remove(selection[i]);
								}
							}
						}
					}
				//		hidden : true


					}]
				}
                   		]
			}]
		}]
	}],
    
	 onRender : function () {
		var mePopup = this;
		//myDashboardMask.show();
		var thisWind =new Ext.LoadMask(this.getEl(), {
							msg : "Loading .."
					});
		thisWind.show();
		var thisBlockId = mePopup.blockId;	
		var metricsFormPanelObj = this.getComponent('ddconfigForm');
		var metricsForm = metricsFormPanelObj.getForm();
		var editViewPage='dashboardLayout2';
		if(this.isFluidWindowConfigPopup)
		{
			editViewPage='fluidDashLayout';
		}
        var profileName = Ext.getCmp('dashboardLayoutObj').profileName;

			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				method : 'POST',
				params: 'comesFrom=myDashboard&action=loadDDConfigPopup&profileName='+profileName+'&blockId='+thisBlockId+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(jsonText!=null && jsonText!='')
					{
						var jsonData = Ext.decode(jsonText);
						thisWind.hide();
						var compTypeCombo = metricsForm.findField('ddCompTypeCombo');

						var ddConfigDetails = jsonData['ddConfigDetails'];

						var selectedCompType = '';
						var selectedComp = '';
						var selectedTest = '';
						var selectedMeasure = '';
						var ddColumns = '';
						var myDashC = '';
						if(!Ext.isEmpty(ddConfigDetails))
						{
							selectedCompType = ddConfigDetails['selectedCompType'];
							selectedComp = ddConfigDetails['selectedComp'];
							if((selectedCompType!=null && selectedCompType!="undefined" && selectedCompType!="" && selectedCompType!="-1") && (selectedComp!=null && selectedComp!="undefined" && selectedComp!='' && selectedComp!="-1"))
							{
								selectedComp = selectedCompType+":"+selectedComp;
							}
							selectedTest = ddConfigDetails['selectedTest'];
							selectedMeasure = ddConfigDetails['selectedMeasure'];
							ddColumns = ddConfigDetails['ddColumns'];
							myDashC = myDashApp.getController("Main");
						}
						
						compTypeCombo.getStore().removeAll();
						compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
						var compTypeStore = compTypeCombo.getStore();
						compTypeStore.loadRawData(jsonData['comptypes']);
						compTypeStore.insert(0,{
							displayField:jsonData['screenLabels']['reporter.common.Please choose a Component Type'],
							valueField: '-1'
						});
						if(selectedCompType!=null && selectedCompType!='')
						{
							compTypeCombo.setValue(selectedCompType);
						}
						else
						{
							compTypeCombo.setValue('-1');
						}

						var compCombo = metricsForm.findField('ddcompCombo');
						compCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
						var compComboStore = compCombo.getStore();
						compComboStore.removeAll();

						if(selectedCompType!=null && selectedCompType!='')
						{
							myDashC.loadComponentsForDDWithSelection(selectedCompType,selectedComp);
						}
						else
						{	
							compComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							compCombo.setValue('-1');
						}
						var testCombo = metricsForm.findField('testCombo');
						testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
						var testComboStore = testCombo.getStore();
						testComboStore.removeAll();
						if(selectedTest!= null && selectedTest!=undefined)
						{
								preSelectedTestForDD = selectedTest;
						}
						if(selectedComp!=null && selectedComp!='')
						{
							myDashC.loadDDTestsForComponentWithSelection(selectedComp,selectedTest);
						}
						else
						{
							testComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							testCombo.setValue('-1');
						}
						var ddMeasuresCombo =  metricsForm.findField('ddMeasuresCombo');
						ddMeasuresCombo.setFieldLabel(jsonData['screenLabels']['monitor.measures.Measures']);
						var ddMeasuresComboStore = ddMeasuresCombo.getStore();
						ddMeasuresComboStore.removeAll();
						if(selectedTest!=null && selectedTest!='')
						{
							myDashC.loadDDMeasuresForTestWithSelection(selectedTest,selectedMeasure);
						}
						else
						{
							ddMeasuresComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							ddMeasuresCombo.setValue('-1');
						}
						var ddMeasureCols = metricsForm.findField('ddMeasureCols');
						Ext.getCmp('dd_measure_cols').setText(jsonData['screenLabels']['monitor.dashboard.DD Columns']);
						var ddMeasureColsComboStore = ddMeasureCols.getStore();
						ddMeasureColsComboStore.removeAll();
						if(selectedMeasure!=null && selectedMeasure!='')
						{
							myDashC.loadDDColumnsForMeasureWithSelection(selectedTest,selectedMeasure,ddColumns,selectedCompType,selectedComp);
						}
						else
						{
							ddMeasureColsComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							ddMeasureCols.setValue('-1');
						}
						var excludeDescVal = ddConfigDetails['excludedDescriptors'];
						var excludeDesc = metricsForm.findField('excludeDesc');
						if (!Ext.isEmpty(excludeDescVal)) {	
							excludeDesc.setValue(excludeDescVal);
						}else{
							excludeDesc.setValue("");
						}

					}
				},
				failure : function()
				{

				}
			});
			this.callParent();
		},
		setBlockId : function(blockId)
		{
			this.blockId = blockId;
		},
		checkspecialCharacterForMetric : function(dispMVal)
		{
			var splChar =":~!@#$%^&*+={}[]|\\;\"\<>,";
			for(var i=0; i<obj_val.length; i++)
			{
				var check_char = splChar.indexOf(obj_val.charAt(i))
				//Returns value 1 if the special character listed in splChar is found
				if(check_char >= 0)
				{
					return true;
				}
			}
		}
})