Ext.define('MyDashBoard.view.AddDialMetrics', {
    extend: 'Ext.window.Window',
    alias: 'widget.adddialmetrics',
    requires: ['Ext.ux.form.MultiSelect','utilities.Multiselector', 'MyDashBoard.view.ComparisonTable','utilities.CustomGrid','utilities.TimeLine','utilities.ScrollCombo'],
    title:addMetricsTitle,
    //width: 950,
	width:strSkin=="Light"?970:950,
    modal: true,
	border:false,
	frame:true,
    autoShow: false,
	ghost:false,
	padding:'0 0 0 0',
	bodyPadding:0,
	autoScroll:true,
	/*header:{
		height:32,
		padding:'0 10',
		margin:0
	},*/
	cls:'myDashboardwindow',
	ui:'newPopupWindow newplainHeader',
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	autoShow : false,
  //  height:550,
	blockId : null,
	blckType : '',
	isFluidWindowConfigPopup : false,
	closeAction : 'destroy',
	initComponent : function()
	{
		this.buttonAlign = 'center';
		var thisBlockId = this.blockId;	
		if(thisBlockId!=null)
		{
			this.blckType = thisBlockId.substr(0,thisBlockId.indexOf("_"));
		}
		var blockType = this.blckType;
		if(blockType!=null && blockType=='pieChart')
		{
			this.createLayoutForPieCharts();
		}
		else if(blockType!=null && blockType=='liveMeasuresBox')
		{
			this.createLayoutForLiveMeasuresBox();
		}
		else
		{
			this.createLayoutForDialCharts();
		}
		this.callParent();
	},
	loadDialDigitalPopupDefaultData : function(jsonData,blockType)
	{
			var metricsFormPanelObj = this.getComponent('dialConfigForm');
			var metricsForm = metricsFormPanelObj.getForm();
			var compTypeCombo = metricsForm.findField('dialCompTypeCombo');
			var dialConfigDetails = jsonData['configDetails'];
			var useStateColorForFontsObj=Ext.getCmp('useStateColorForFonts');
			//var resizeFontObj=Ext.getCmp('resizeFontYesNo');
			var showGaugeCircleObj=Ext.getCmp('showGaugeCircle');
			var stateColorForGaugeObj=Ext.getCmp('useStateColorForGauge');
			var selectedCompType = '';
			var selectedComp = '';
			var selectedTest = '';
			var selectedMeasure = '';
			var selectedDescriptor = '';
			var selectedGraphType='';
			var useStateColorForFonts='';
			//var resizeFont='';
			var showGaugeCircle='';
			var showStateColorForGauge='';
			if(!Ext.isEmpty(dialConfigDetails))
			{
				selectedCompType = dialConfigDetails['selectedCompType'];
				selectedComp = dialConfigDetails['selectedComp'];
				if((selectedCompType!=null && selectedCompType!="undefined" && selectedCompType!="" && selectedCompType!="-1") && (selectedComp!=null && selectedComp!="undefined" && selectedComp!='' && selectedComp!="-1"))
				{
					selectedComp = selectedCompType+":"+selectedComp;
				}
				selectedTest = dialConfigDetails['selectedTest'];
				selectedMeasure = dialConfigDetails['selectedMeasure'];
				selectedDescriptor = dialConfigDetails['selectedDescriptor'];
				selectedGraphType = dialConfigDetails['selectedGraphType'];
				useStateColorForFonts = dialConfigDetails['useStateColorForFonts'];
				//resizeFont = dialConfigDetails['resizeFont'];
				showGaugeCircle = dialConfigDetails['gaugeCircleEnabled'];
				showStateColorForGauge = dialConfigDetails['stateColorForGaugeEnabled'];
			}
			if(blockType != null && blockType=='digitalChart')
			{
				if(useStateColorForFonts!=null && useStateColorForFonts=="yes")
				{
					useStateColorForFontsObj.setValue(true);	
				}
				else
				{
					useStateColorForFontsObj.setValue(false);	
				}
			}
			if(blockType != null && blockType=='dialChart')
			{
				if(showGaugeCircle!=null && showGaugeCircle=="yes")
				{
					showGaugeCircleObj.setValue(true);
				}
				else
				{
					showGaugeCircleObj.setValue(false);
				}
				if(showStateColorForGauge!=null && showStateColorForGauge=="yes")
				{
					stateColorForGaugeObj.setValue(true);
				}
				else
				{
					stateColorForGaugeObj.setValue(false);
				}
			}
			compTypeCombo.getStore().removeAll();
			compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
			var compTypeStore = compTypeCombo.getStore();
			compTypeStore.loadRawData(jsonData['comptypes']);
			compTypeStore.insert(0,{
				displayField:jsonData['screenLabels']['reporter.common.Please choose a Component Type'],
				valueField: '-1'
			});
			if(selectedCompType!=null && selectedCompType!='')
			{
				compTypeCombo.setValue(selectedCompType);
				compTypeCombo.fireEvent('select',compTypeCombo);
			}
			else
			{
				compTypeCombo.setValue('-1');
			}

			var compCombo = metricsForm.findField('dialComponentCombo');
			compCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
			var compComboStore = compCombo.getStore();
			compComboStore.removeAll();

			var meDialPopup = this;

			if(selectedComp!=null && selectedComp!='')
			{
				compCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(compCombo,selectedComp);  }, this, {
						single: true,
						delay: 100
					});
			}
			else
			{	
				compComboStore.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				compCombo.setValue('-1');
			}
			var testCombo = metricsForm.findField('testCombo');
			testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
			var testComboStore = testCombo.getStore();
			testComboStore.removeAll();
			if(selectedTest!=null && selectedTest!='')
			{
					testCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(testCombo,selectedTest);  }, this, {
						single: true,
						delay: 100
					});
			}
			else
			{
				testComboStore.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				testCombo.setValue('-1');
			}
		
			var ddMeasuresCombo =  metricsForm.findField('measureSingleCombo');
			ddMeasuresCombo.setFieldLabel(jsonData['screenLabels']['monitor.measures.Measures']);
			var ddMeasuresComboStore = ddMeasuresCombo.getStore();
			ddMeasuresComboStore.removeAll();
			if(selectedMeasure!=null && selectedMeasure!='')
			{
					ddMeasuresCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(ddMeasuresCombo,selectedMeasure);  }, this, {
						single: true,
						delay: 100
					});
			}
			else
			{
				ddMeasuresComboStore.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				ddMeasuresCombo.setValue('-1');
			}
			var dialDescriptorCombo = metricsForm.findField('dialDescriptorCombo');
			dialDescriptorCombo.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
			if(selectedDescriptor!=null && selectedDescriptor!="")
			{
					dialDescriptorCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(dialDescriptorCombo,selectedDescriptor);  }, this, {
						single: true,
						delay: 100
					});
			}
			else
			{
				var dialDescriptorComboStore = dialDescriptorCombo.getStore();
				dialDescriptorComboStore.removeAll();
				dialDescriptorComboStore.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				dialDescriptorCombo.setValue('-1');
			}
			var templateIcon = '/final/images/'+strSkin+'/listViewWidgetDefault.png';
			var showChartSummaryObj=Ext.getCmp('showChartSummary');
			if(!Ext.isEmpty(showChartSummaryObj))
			{
				var enableChartSummary=dialConfigDetails['ChartSummaryEnabled'];
				if(enableChartSummary!=null && enableChartSummary=="yes")
				{
					showChartSummaryObj.setValue(true);
					var summaryGraphType=dialConfigDetails['summaryGraphType'];
					var chartSummaryGraphTypeObj=Ext.getCmp('chartSummaryOpts');
					if(Ext.isEmpty(summaryGraphType) || summaryGraphType=='none')
						summaryGraphType="-1";

					chartSummaryGraphTypeObj.setValue(summaryGraphType);
					var enableChartIcon=dialConfigDetails['enableChartIcon'];
					if(enableChartIcon!=null && enableChartIcon=="yes")
					{
						var showIconObj=Ext.getCmp('showIcon');
						showIconObj.setValue(true);
						templateIcon=dialConfigDetails['imgIcon'];
						if(Ext.isEmpty(templateIcon))
						{
							templateIcon = '/final/images/'+strSkin+'/listViewWidgetDefault.png';
						}
					}

				}
			}

			if(templateIcon!=null && templateIcon!="")
			{
				if(templateIcon.indexOf(":")>0 && templateIcon.startsWith("Default"))
				{
					templateIcon = templateIcon.substring(templateIcon.indexOf(":")+1);
					var digitalChartImgCont=Ext.getCmp('digitalChartImgCont');
					digitalChartImgCont.iconClass=templateIcon;
					if(templateIcon.indexOf('_')>-1)
					{
						templateIcon = templateIcon.substring(0,templateIcon.lastIndexOf('_')+1)+'32';
					}
					digitalChartImgCont.update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><div id="dashboardImageIcon"  class= "'+templateIcon+'" width="32px" height="32px" border="0px"/><div class="settingOver"></div></div>');
					digitalChartImgCont.setImageTriggerEvents(digitalChartImgCont);
				}
				else
				{
					var digitalChartImgCont=Ext.getCmp('digitalChartImgCont');
					if(!Ext.isEmpty(digitalChartImgCont))
					{
						digitalChartImgCont.update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="dashboardImageIcon"  src="'+templateIcon+'" width="100%" height="100%" border="0px"/><div class="settingOver"></div></div>');
						//Ext.getCmp('customImgcont').update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault"><div style="width:32px;height:32px;overflow:hidden;position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;"><img id="dashboardImageIcon"  src="'+templateIcon+'"  style="position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;" border="0px"/><div class="settingOver"></div></div>');
						digitalChartImgCont.setImageTriggerEvents(digitalChartImgCont);
					}
				}
			}
	},
	loadDefaultData : function(jsonData,blockType)
	{
		var metricsFormPanelObj = this.getComponent('dialConfigForm');
		var metricsForm = metricsFormPanelObj.getForm();
		var compTypeCombo = metricsForm.findField('dialCompTypeCombo');
		var areaConfigDetails = jsonData['configDetails'];
		var selectedCompType = '';
		var selectedComp = '';
		var selectedTest = '';
		var selectedMeasure = '';
		var selectedDescriptor = '';
		var selectedGraphType='';
		var viewType='';
		//var resizeFont='';
		var useStateColorForBackground='';
		var useStateColorForBackgroundObj=Ext.getCmp('useStateColorForBackground');
		//var resizeFontObj=Ext.getCmp('resizeFontYesNo');
			
		if(!Ext.isEmpty(areaConfigDetails))
		{
			selectedCompType = areaConfigDetails['selectedCompType'];
			selectedComp = areaConfigDetails['selectedComp'];
			if((selectedCompType!=null && selectedCompType!="undefined" && selectedCompType!="" && selectedCompType!="-1") && (selectedComp!=null && selectedComp!="undefined" && selectedComp!='' && selectedComp!="-1"))
			{
				selectedComp = selectedCompType+":"+selectedComp;
			}
			selectedTest = areaConfigDetails['selectedTest'];
			selectedMeasure = areaConfigDetails['selectedMeasure'];
			selectedDescriptor = areaConfigDetails['selectedDescriptor'];
			viewType = areaConfigDetails['viewType'];
			useStateColorForBackground = areaConfigDetails['useStateColorForBackground'];
			//resizeFont = areaConfigDetails['resizeFont'];
		}
		if(blockType != null && blockType=='liveMeasuresBox')
		{
			if(useStateColorForBackground!=null && useStateColorForBackground=="yes")
			{
				useStateColorForBackgroundObj.setValue(true);
			}
			else
			{
				useStateColorForBackgroundObj.setValue(false);
			}
			/*if(resizeFont!=null && resizeFont=="yes")
			{
				resizeFontObj.setValue(true);
			}
			else
			{
				resizeFontObj.setValue(false);
			}*/
		}
		if(viewType==null || viewType=="" || viewType=="undefined")
			viewType="vertical";
	
		compTypeCombo.getStore().removeAll();
		compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
		var compTypeStore = compTypeCombo.getStore();
		compTypeStore.loadRawData(jsonData['comptypes']);
		compTypeStore.insert(0,{
			displayField:jsonData['screenLabels']['reporter.common.Please choose a Component Type'],
			valueField: '-1'
		});
		if(selectedCompType!=null && selectedCompType!='')
		{
			compTypeCombo.setValue(selectedCompType);
			compTypeCombo.fireEvent('select',compTypeCombo);
		}
		else
		{
			compTypeCombo.setValue('-1');
		}

		var compCombo = metricsForm.findField('dialComponentCombo');
		compCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
		var compComboStore = compCombo.getStore();
		compComboStore.removeAll();

		var meDialPopup = this;

		if(selectedComp!=null && selectedComp!='')
		{
			compCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(compCombo,selectedComp);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{	
			compComboStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			compCombo.setValue('-1');
		}
		var testCombo = metricsForm.findField('testCombo');
		testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
		var testComboStore = testCombo.getStore();
		testComboStore.removeAll();
		if(selectedTest!=null && selectedTest!='')
		{
				testCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(testCombo,selectedTest);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{
			testComboStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			testCombo.setValue('-1');
		}
	
		var ddMeasuresCombo =  metricsForm.findField('measureMultiCombo');
		Ext.getCmp('measureComboLbl').setText(jsonData['screenLabels']['monitor.measures.Measures']);
		var ddMeasuresComboStore = ddMeasuresCombo.getStore();
		ddMeasuresComboStore.removeAll();
		if(selectedMeasure!=null && selectedMeasure!='')
		{
				ddMeasuresCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(ddMeasuresCombo,selectedMeasure);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{
			ddMeasuresComboStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			ddMeasuresCombo.setValue('-1');
		}
		var dialDescriptorCombo = metricsForm.findField('dialDescriptorCombo');
		dialDescriptorCombo.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
		if(selectedDescriptor!=null && selectedDescriptor!="")
		{
				dialDescriptorCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(dialDescriptorCombo,selectedDescriptor);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{
			var dialDescriptorComboStore = dialDescriptorCombo.getStore();
			dialDescriptorComboStore.removeAll();
			dialDescriptorComboStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			dialDescriptorCombo.setValue('-1');
		}

	/*	var startdateObj = metricsForm.findField('er_stdate');
		var enddateObj = metricsForm.findField('er_enddate');
		var startHourObj = metricsForm.findField('er_sthr');
		var endHourObj = metricsForm.findField('er_endhr');

		startdateObj.setFieldLabel(fromLbl);
		enddateObj.setFieldLabel(toLbl);
		startHourObj.setFieldLabel(hrsLbl);
		endHourObj.setFieldLabel(hrsLbl);
		var configuredData = jsonData['configuredDetails'];
		var configDetails = jsonData['configDetails'];
		Ext.getCmp("er_mode").hide();
		var timelineComboObj = metricsForm.findField('er_timeline');
		timelineComboObj.getStore().loadRawData(jsonData['timelineJson']);
		timelineComboObj.setValue(configDetails['timeline']);
		startdateObj.setValue(configDetails['startDateForDisplay']);
		startdateObj.dataArray = configDetails['startDate'];
		enddateObj.setValue(configDetails['endDateForDisplay']);
		enddateObj.dataArray = configDetails['endDate'];
		startHourObj.setValue(configDetails['startHourForDisplay']);
		startHourObj.dataArray = configDetails['startHour'];
		endHourObj.setValue(configDetails['endHourForDisplay']);
		endHourObj.dataArray = configDetails['endHour'];
		stmin = configDetails.startMinForDisplay;
		enmin = configDetails.endMinForDisplay;
		mgr_stmin = configDetails.startmin;
		mgr_enmin = configDetails.endmin;*/
		var blkDispType=metricsForm.findField('blkDispType');
		/*var showThreshold = configuredData['showThreshold'];
		if (showThreshold == null || showThreshold != 'yes')
			showThreshold = 'no';*/

		/**blkDispType.setValue({
			blkDispOpt: viewType
		});**/
		//blkDispType.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Show Thresholds']);
		//blkDispType.show();

	},
	loadPieChartDefaultData : function(jsonData,blockType)
	{
		var metricsFormPanelObj = this.getComponent('dialConfigForm');
		var metricsForm = metricsFormPanelObj.getForm();
		var dialConfigDetails = jsonData['configDetails'];

		var selectedPieChartTemplate = '';
		var selectedComp = '';
		var selectedDescriptor = '';
		var selectedCompType = '';
		if(!Ext.isEmpty(dialConfigDetails))
		{
			selectedCompType = dialConfigDetails['selectedCompType'];
			selectedComp = dialConfigDetails['selectedComp'];
			if((selectedCompType!=null && selectedCompType!="undefined" && selectedCompType!="" && selectedCompType!="-1") && (selectedComp!=null && selectedComp!="undefined" && selectedComp!='' && selectedComp!="-1"))
			{
				selectedComp = selectedCompType+":"+selectedComp;
			}
			selectedDescriptor = dialConfigDetails['selectedDescriptor'];
			selectedPieChartTemplate = dialConfigDetails['selectedPieChartTemplate'];
		}
		var pieChartDistributionCombo = metricsForm.findField('pieChartDistributionCombo');
        pieChartDistributionCombo.setFieldLabel(jsonData['screenLabels']['reporter.common.Template Name']);
		var pieChartDistributionComboStore = pieChartDistributionCombo.getStore();
		pieChartDistributionComboStore.loadRawData(jsonData['pieChartTemplateOptions']);
		pieChartDistributionComboStore.insert(0,{
			displayField:jsonData['screenLabels']['reporter.common.Please choose a template'],
			valueField: '-1'
		});
		if(selectedPieChartTemplate!=null && selectedPieChartTemplate!='')
		{
			pieChartDistributionCombo.setValue(selectedPieChartTemplate);
			pieChartDistributionCombo.fireEvent('select',pieChartDistributionCombo);
		}
		else
		{
			pieChartDistributionCombo.setValue('-1');
		}

		var compTypeCombo = metricsForm.findField('dialCompTypeCombo');
		compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
		if(selectedCompType!=null && selectedCompType!='')
		{
			compTypeCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(compTypeCombo,selectedCompType);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{
			var compTypeStore = compTypeCombo.getStore();
			compTypeStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			compTypeCombo.setValue('-1');
		}

		var compCombo = metricsForm.findField('dialComponentCombo');
		compCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
		var compComboStore = compCombo.getStore();
		compComboStore.removeAll();

		var meDialPopup = this;

		if(selectedComp!=null && selectedComp!='')
		{
			compCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(compCombo,selectedComp);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{	
			compComboStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			compCombo.setValue('-1');
		}		
		var dialDescriptorCombo = metricsForm.findField('dialDescriptorCombo');
		dialDescriptorCombo.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
		if(selectedDescriptor!=null && selectedDescriptor!="")
		{
				dialDescriptorCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(dialDescriptorCombo,selectedDescriptor);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{
			var dialDescriptorComboStore = dialDescriptorCombo.getStore();
			dialDescriptorComboStore.removeAll();
			dialDescriptorComboStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			dialDescriptorCombo.setValue('-1');
		}
	},
	 onRender : function () {
			var mePopup = this;
			//myDashboardMask.show();
			var thisWind =new Ext.LoadMask(this.getEl(), {
							msg : "Loading .."
						});
			thisWind.show();
			var thisBlockId = mePopup.blockId;	
			var editViewPage='dashboardLayout2';
			if(this.isFluidWindowConfigPopup)
			{
				editViewPage='fluidDashLayout';
			}
			var profileName = Ext.getCmp('dashboardLayoutObj').profileName;

			var blockType = this.blckType;
			
			if(thisBlockId!=null)
			{
				blockType = thisBlockId.substr(0,thisBlockId.indexOf("_"));
			}

				Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				method : 'POST',
				params: 'comesFrom=myDashboard&action=loadDialConfigPopup&profileName='+profileName+'&blockId='+thisBlockId+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(jsonText!=null && jsonText!='')
					{
						var jsonData = Ext.decode(jsonText);
						thisWind.hide();
						if(blockType!=null && blockType=='pieChart')
						{
							mePopup.loadPieChartDefaultData(jsonData,blockType);
						}
						else if(blockType!=null && blockType=='liveMeasuresBox')
						{
							mePopup.loadDefaultData(jsonData,blockType);
						}
						else
						{
							mePopup.loadDialDigitalPopupDefaultData(jsonData,blockType);
						}
					}	
				},
				failure : function()
				{

				}
			});
			this.callParent();
		},
		createLayoutForLiveMeasuresBox :function()
		{
			   this.items =  [{
        xtype: 'form',
			itemId : 'dialConfigForm',
			buttonAlign: 'center',
        defaults: {
            padding: '3',
            margin: 3,
			labelSeparator:''
        },
        buttons: [
		{
		    text : updateDispBtn,
			id : 'updateDialConfig',
			name : 'updateDialConfig',
            cls: 'buttonNew',
			padding:'0 10 0 10',
        }
			],
        items: [ {
					xtype: 'container',

					flex: 1,
					layout:'hbox',
					margin: '5 0 0 15',
					/**items:[
						{
                            xtype: 'radiogroup',
                            width: 350,
                            column: 2,
                            labelAlign: 'left',
                            height: 20,
							labelSeparator:'',
                            fieldLabel: 'View Type',
                            id: 'blkDispType',
                            name: 'blkDispType',
                            items: [{
                                boxLabel: 'Horizontal',
                                name: 'blkDispOpt',
                                inputValue: 'horizontal',
                                cls: 'radiobt'
                            }, {
                                boxLabel: 'Vertical',
                                name: 'blkDispOpt',
                                inputValue: 'vertical',
                                cls: 'radiobt'
                            }]
                        }]**/
			},{
                xtype: 'container',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                   margin: '5 0 0 10',
				   labelSeparator:''
                },
                items: [{
                        xtype: 'container',
                        defaults: {
                            labelAlign: 'top',
							labelSeparator:''
                        },
                        items: [
							{
                        xtype: 'scrollcombo',
						cls: 'dropdown',
							margin: '0 0 20 0',
                        fieldLabel: 'Component Type',
						labelSeparator:'',
						id : 'dialCompTypeCombo',
						name : 'dialCompTypeCombo',
                        width: 280,
						store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
                    },
					{
							xtype : 'label',
							id : 'measureComboLbl',
							 margin: '0 0 0 0',
							name : 'measureComboLbl'
					},
					{
						xtype:'container',
						layout:{type:'vbox',align:'stretch'},
						width : 280,
						cls:'darkbox',
						//height:145,
						height:125,
						id:'metricSearchBoxCont',
						items:[{
							xtype:'trigger',
							margin : '10',
							id : 'metricsSearchTextBox',
							name : 'metricsSearchTextBox',
							width : 228,
									
							cls: 'whitedropdown_search',
							emptyText : 'Search Metric(s)',
							metComboStore : null,
						//	hidden : true,
							listeners :
							{
								'change' : function(triggerField, newValue, oldValue, eOpts) {
									var me = this;
									var metStore = me.metComboStore;
									if(metStore==null)
									{
										me.metricComboStore = this.up('form').getForm().findField('measureMultiCombo').getStore();
										metStore = me.metricComboStore;
									}
									if(newValue=="*")
									{
										metStore.clearFilter();
									}
									else
									{
										if(newValue.lastIndexOf("*")==(newValue.length-1))
										{
											newValue = newValue.substr(0,(newValue.length-1));
										}
										metStore.clearFilter();
										if (newValue) {
											var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
											metStore.filter({
												filterFn: function(record) {
													return matcher.test(record.get('displayField')) ;
												}
											});
										}
									 triggerField.focus();
									}
								 }
							}
						},
						{
							xtype: 'multiselect',
							id: 'measureMultiCombo',
							name: 'measureMultiCombo',
							labelAlign:'top',
							margin:'3 0 0 0',
							baseCls: 'egmultiselect',
							border: true,
							bodyPadding: 0,
							multiSelect: true,
							scroll: false,
							autoScroll: false,
							height: 130,
							listConfig: {
								simpleSelect: true,
								itemTpl: new Ext.XTemplate(

									'<tpl for=".">',
									'<div id="{valueField}" style="text-align:left;border:0px solid red">{displayField}</div>',
									'</tpl>'

								),
								listeners: {
									itemdblclick: function (thisItems, record, item, index, e, eOpts) {
										var me = this;
										var meMCombo = this;
										var selection = thisItems.getSelectionModel().getSelection();
										for (var i = 0; i < selection.length; i++) {
											mySelectionHeaders = selection[i].data.displayField;
											mySelectionHeadersd = selection[i].data.valueField;
											var editor = new Ext.Editor({
												updateEl: true,
												completeOnEnter: true,
												shadow: false,
												border: false,
												width: 230,
												ignoreNoChange: true,
												field: {
													xtype: 'textfield',
													cls : 'headerTextEdit',
													height: 26,
													width: 230
												},
												listeners: {
													'beforecomplete': function (meEdtr, value, startValue, eOpts) {
														if (value == null || value == '' || value == '-1') {
															meEdtr.cancelEdit(false);
															Ext.Msg.show({
																title: myDashboardAlertLbl,
																msg: measureEmptyMsg,
																buttons: Ext.MessageBox.OK,
																icon: Ext.MessageBox.WARNING
															});
															return false;
														} else if (me.store.find('displayField', value, 0, false, true, true) != -1) {
															meEdtr.cancelEdit(false);
															Ext.Msg.show({
																title: myDashboardAlertLbl,
																msg: measureNameAlreadyExists,
																buttons: Ext.MessageBox.OK,
																icon: Ext.MessageBox.WARNING
															});
															return false;

														} else if (myDashApp.getController("Main").checkSpecialCharacter(value)) {
															meEdtr.cancelEdit(false);
															Ext.Msg.show({
																title: myDashboardAlertLbl,
																msg: measureSplCharacterAlertMsg,
																buttons: Ext.MessageBox.OK,
																icon: Ext.MessageBox.WARNING
															});
															return;
														}
													},
													'complete': function (meEdtr, value, startValue, eOpts) {

														me.store.suspendEvents();
														me.store.remove(record);
														me.store.insert(index,{
															'displayField': this.getValue(),
															'valueField': mySelectionHeadersd
														});
														me.refresh();
														me.store.resumeEvents();
													}
												}
											});
										}
										if (mySelectionHeadersd != "-1" || mySelectionHeadersd != "")
										{
										   var el = Ext.get(mySelectionHeadersd); // The element to 'edit'
												editor.startEdit(el, el.getValue());
										}
									}
								}
							},
							width: 280,
							displayField: 'displayField',
							valueField: 'valueField',
							store: Ext.create('Ext.data.Store', {
								fields: ['valueField', 'displayField'],
								data: []
							})
						}]
					}]
				},{
                    xtype: 'container',
					defaults: {
                        labelAlign: 'top',
						labelSeparator:''
                    },
                    items: [				
					{
                        xtype: 'scrollcombo',      
						cls: 'dropdown',
                        id: 'dialComponentCombo',
						fieldLabel : 'Component',
                        name: 'dialComponentCombo',
						margin:'0 0 0 10',
                        width: 280,
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
                        store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
                    },
						{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel : 'Descriptor',
						id: 'dialDescriptorCombo',
						name: 'dialDescriptorCombo',
						width: 280,
						margin:'20 0 0 10',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: []
						}),
						scroll : true,
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
							}
					]
                },
				 {
                    xtype: 'container',
                    defaults: {
                        labelAlign: 'top',
						labelSeparator:''
                    },
                    items: [
							{
                        xtype: 'scrollcombo',
                        id: 'testCombo',
                        name: 'testCombo',
						cls: 'dropdown',
                        fieldLabel: 'Test',
                        width: 280,
						margin:'0 0 0 10',
                        store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
                    }]
                }
            ]

            },

				{
				   xtype:'fieldset',
				  layout : {
						type : 'hbox'
					},
				   title : 'Font Settings', 
				   collapsible: false,
				   style:{"box-shadow":"none","background":"none"},
				   margin:'20 20 5 20',
				   defaults: {
						labelAlign: 'left',
						labelSeparator:''
					},
				   items: [{
							xtype : 'switchfield',
							name: 'useStateColorForBackground',
							id: 'useStateColorForBackground',
							fieldLabel: 'Apply State Color For Box Background :',
							inputValue: 'Yes',
							uncheckedValue:'No',
							margin:'4 0 0 0',
						//	columns: 2,
							width :280,
							labelWidth:210,
							vertical: false,
							checked:false
						},
						/*{
							xtype : 'switchfield',
							name: 'resizeFontYesNo',
							id: 'resizeFontYesNo',
							fieldLabel: 'Resize Font :',
							inputValue: 'Yes',
							uncheckedValue:'No',
							margin:'4 0 0 0',
						//	columns: 2,
							width :230,
							labelWidth:100,
							vertical: false,
							checked:false
						}*/
					]

				}

        ]
    }]
		},
		createLayoutForDialCharts :function()
		{
			var popupOptsArr=[];
			
			popupOptsArr.push(
			{
                xtype: 'container',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    margin: '0 10 0px 0px',
					labelSeparator:''
                },
                items: [{
                        xtype: 'container',
                        defaults: {
                            labelAlign: 'top',
							labelSeparator:''
                        },
						margin:10,
                        items: [
							{
                        xtype: 'scrollcombo',
						cls: 'dropdown',
                        fieldLabel: 'Component Type',
						id : 'dialCompTypeCombo',
						name : 'dialCompTypeCombo',
                        width: 280,
						store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
                    },
					{
						xtype: 'scrollcombo',
						id: 'measureSingleCombo',
						name: 'measureSingleCombo',
						cls: 'dropdown',
						margin:'10 0 0 0',
						fieldLabel: 'Measure',
						width: 280,
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: []
						}),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					}]
				},{
                    xtype: 'container',
					defaults: {
                        labelAlign: 'top',
						labelSeparator:''
                    },
                    items: [				
					{
                        xtype: 'scrollcombo',      
						cls: 'dropdown',
                        id: 'dialComponentCombo',
						fieldLabel : 'Component',
                        name: 'dialComponentCombo',
						 margin:'10 0 0 10',
                        width: 280,
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
                        store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
                    },
						{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel : 'Descriptor',
						id: 'dialDescriptorCombo',
						name: 'dialDescriptorCombo',
						width: 280,
						margin:'10 0 0 10',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: []
						}),
						scroll : true,
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
						}
					]
                },
				 {
                    xtype: 'container',
                    defaults: {
                        labelAlign: 'top',
						labelSeparator:''
                    },
                    items: [
							{
                        xtype: 'scrollcombo',
                        id: 'testCombo',
                        name: 'testCombo',
						cls: 'dropdown',
                        fieldLabel: 'Test',
                        width: 280,
						margin:'10 0 0 10',
                        store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					}]
                }
            ]

            });

			if(this.blckType!=null && this.blckType=='dialChart')
			{
				popupOptsArr.push(
				{
					xtype:'fieldset',
					layout : {
						//type : 'vbox'
						type : 'hbox'
					},
					title : 'Chart Settings', 
					collapsible: false,
					style:{"box-shadow":"none","background":"none"},
					margin:'20 20 5 20',
					defaults: {
						labelAlign: 'left',
						labelSeparator:''
					},
					items: [
						{
							xtype : 'switchfield',
							name: 'showGaugeCircle',
							id: 'showGaugeCircle',
							fieldLabel: 'Enable Full Gauge',
							inputValue: 'Yes',
							uncheckedValue:'No',
							margin:'4 0 5 20',
						//	columns: 2,
							width :210,
							labelWidth:95,
							vertical: false,
							checked:false
						},{
							xtype : 'switchfield',
							name: 'useStateColorForGauge',
							id: 'useStateColorForGauge',
							fieldLabel: 'Apply State Color For Gauge:',
							inputValue: 'Yes',
							uncheckedValue:'No',
							margin:'6 0 0 0',
						//	columns: 2,
							width :210,
							labelWidth:180,
							vertical: false,
							checked:false
						}
					]
				}
					);
			}

			if(this.blckType!=null && this.blckType=='digitalChart')
			{
				popupOptsArr.push(
				{
				   xtype:'fieldset',
				  layout : {
						type : 'vbox'
					},
				   title : 'Chart Settings', 
				   collapsible: false,
				   style:{"box-shadow":"none","background":"none"},
				   margin:'20 20 5 20',
				   defaults: {
						labelAlign: 'left',
						labelSeparator:''
					},
				   items: [
					{
						xtype : 'container',
						margin:'0 0 0 0',
						layout : {
							type : 'hbox'
						},
					//	width : 600,
					//	height : 300,
						items : [
							{
							xtype : 'switchfield',
							name: 'showChartSummary',
							id: 'showChartSummary',
							fieldLabel: 'Enable History View',
							inputValue: 'Yes',
							uncheckedValue:'No',
							margin:'6 0 0 0',
						//	columns: 2,
							width :210,
							labelWidth:150,
							vertical: false,
							checked:false
						},
						{
								xtype: 'scrollcombo',
								id: 'chartSummaryOpts',
								name: 'chartSummaryOpts',
								cls: 'dropdown',
								fieldLabel: 'Chart Type',
								width: 250,
								labelWidth:100,
								margin:'6 0 0 20',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField','valueField'],
									data: [{'displayField':'Please choose a chart','valueField' : '-1'},{'displayField':'Area','valueField' : 'area'},{'displayField':'Line','valueField' : 'line'},{'displayField':'Column','valueField' : 'column'}]
								}),
								disabled : true,
								editable:false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								value : '-1'
						},
						{
							xtype : 'switchfield',
							name: 'showIcon',
							id: 'showIcon',
							fieldLabel: 'Show Icon',
							inputValue: 'Yes',
							uncheckedValue:'No',
							margin:'6 0 0 20',
						//	columns: 2,
							width :150,
							labelWidth:80,
							vertical: false,
							checked:false
						},
						{
							xtype: 'container',
							id : 'digitalChartImgCont',
							name : 'digitalChartImgCont',
							margin:'4 0 0 0',
							width:42,
							height:42,
							disabled : true,
							listeners:{
								afterrender:function(cmp){
									
								}
							},
							setImageTriggerEvents : function(cmp)
							{
								Ext.get(cmp.el).select('.userDefinedImgDefault').on('mouseenter',function(){
									var isIconEnabled=Ext.getCmp('showIcon').getValue();
									if(isIconEnabled!=null && isIconEnabled==true)
									{
										Ext.get(cmp.el).select('.settingOver').update('<div class="userDefinedImgDefaultOver" style="display:block;padding:5px;"><table border="0px" cellpadding="0px" cellspacing="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><a href="javascript:void(0)" id="customChangeImg"><span style="width:20px;height:20px;display:inline-block" class="iconOneClickImgDefaultChange"></span><br/></a></td></tr></table></div>');
										Ext.get(cmp.el).select('#customChangeImg').on('click',function(){
												var imgUploadWindow = Ext.create('MyDashBoard.view.IconLibrary',{
												from:'digitialChartWidget',
												windowId:'windowId',
												custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser+'/',
												profileName:''
											}).show();
										imgUploadWindow.on('close', function() {
										imgUploadWindow.destroy();
										imgUploadWindow = 'closed';
										});
											},Ext.get('customChangeImg'));
									}
									});
									Ext.get(cmp.el).select('.settingOver').on('mouseleave',function(){
										Ext.get(cmp.el).select('.settingOver').update('');
									});
							}
						},
						
						]
					},
					{
						xtype : 'container',
						margin:'0 0 0 0',
						layout : {
							type : 'hbox',
							//align : 'stretch'
						},
						items : [

						{
							xtype : 'switchfield',
							name: 'useStateColorForFonts',
							id: 'useStateColorForFonts',
							fieldLabel: 'Apply State Color For Fonts:',
							inputValue: 'Yes',
							uncheckedValue:'No',
							margin:'6 0 0 0',
						//	columns: 2,
							width :210,
							labelWidth:150,
							vertical: false,
							checked:false
						}
							]
					}
					]
				});

				/******************************/
				/**popupOptsArr.push(
				{
				   xtype:'fieldset',
				  layout : {
						type : 'hbox'
					},
				   title : 'Font Settings', 
				   collapsible: false,
				   style:{"box-shadow":"none","background":"none"},
				   margin:'20 20 5 20',
				   defaults: {
						labelAlign: 'left',
						labelSeparator:''
					},
				   items: [{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: 'Select Font Family',
								id : 'selectFontFamily',
								name : 'selectFontFamily',
								margin:'10 20 10 10',
								width: 280,
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField','valueField'],
									data: [{'displayField':'Please choose font family','valueField' : '-1'},{'displayField':'Default','valueField' : 'LucidaGrandeRegular'},{'displayField':'Roboto-Regular','valueField' : 'Roboto-Regular'},{'displayField':'Arial','valueField' : 'arial'},{'displayField':'Calibri','valueField' : 'Calibri'}]
								}),
								editable:false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
						},				
						{
							xtype : 'container',
							layout : {
								type : 'hbox'
							},
							items:[{
								xtype: 'container',
								html: 'Select Font Color :',
								cls : 'font_color',
								style: {'color':'#ffffff !important'},
								margin:'10 10 10 10',
								//width: 280,
							},
							{
								xtype: 'colorpicker',
								//value: '993300',
								listeners: {

									select: function(picker, selColor) {
										alert(selColor);
										var fontcolor = selColor;
										console.log(fontcolor);
									}
								}
							}]
						}

					]

				});**/
				/*****************************/
			}

			   this.items =  [{
        xtype: 'form',
			itemId : 'dialConfigForm',
			buttonAlign: 'center',
        defaults: {
            padding: '3',
            margin: 3
        },
        buttons: [
		{
		    text : updateDispBtn,
			id : 'updateDialConfig',
			name : 'updateDialConfig',
            cls: 'buttonNew',
			padding:'0 10 0 10'
        }
			],
        items: popupOptsArr
    }]
		},
		createLayoutForPieCharts :function()
		{
			 this.items = [{
     xtype: 'form',
     itemId: 'dialConfigForm',
     buttonAlign: 'center',
     defaults: {
         padding: '3',
         margin: 10
     },
     buttons: [{
         text: updateDispBtn,
         id: 'updateDialConfig',
         name: 'updateDialConfig',
            cls: 'buttonNew',
			padding:'0 10 0 10'
     }],
     items: [
         {
             xtype: 'container',
             layout: 'hbox',
             defaults: {
                 labelAlign: 'top',
                 margin: '0 10 0px 0px',
				 labelSeparator:''
             },
             items: [{
                 xtype: 'container',
                 defaults: {
                     labelAlign: 'top',
					 labelSeparator:''
                 },
                 items: [{
                     xtype: 'scrollcombo',
                     cls: 'dropdown',
                     fieldLabel: 'Template Name',
                     id: 'pieChartDistributionCombo',
                     name: 'pieChartDistributionCombo',
                     width: 280,
                     store: Ext.create('Ext.data.Store', {
                         fields: ['displayField', 'valueField'],
                         data: []
                     }),
                     scroll: true,
                     editable: false,
                     displayField: 'displayField',
                     valueField: 'valueField',
                     queryMode: 'local'
                 },
				{
                     xtype: 'scrollcombo',
                     cls: 'dropdown',
                     fieldLabel: 'Descriptor',
                     id: 'dialDescriptorCombo',
                     name: 'dialDescriptorCombo',
                     width: 280,
					  margin:'10 0 0 0',
                     store: Ext.create('Ext.data.Store', {
                         fields: ['displayField', 'valueField'],
                         data: []
                     }),
                     scroll: true,
                     editable: false,
                     displayField: 'displayField',
                     valueField: 'valueField',
                     queryMode: 'local'
                  }]
             }, {
                 xtype: 'container',
                 defaults: {
                     labelAlign: 'top',
					 labelSeparator:''
                 },
                 items: [{
                     xtype: 'scrollcombo',
                     cls: 'dropdown',
                     fieldLabel: 'Component Type',
					 margin:'0 0 0 10',
                     id: 'dialCompTypeCombo',
                     name: 'dialCompTypeCombo',
                     width: 280,
                     store: Ext.create('Ext.data.Store', {
                         fields: ['displayField', 'valueField'],
                         data: []
                     }),
                     editable: false,
                     displayField: 'displayField',
                     valueField: 'valueField',
                     queryMode: 'local'
                 }]
             }, {
                 xtype: 'container',
                 defaults: {
                     labelAlign: 'top',
					 labelSeparator:''
                 },
                 items: [{
                     xtype: 'scrollcombo',
                     cls: 'dropdown',
                     id: 'dialComponentCombo',
                     fieldLabel: 'Component',
                     name: 'dialComponentCombo',
                     width: 280,
					  margin:'0 0 0 10',
                     layout: {
                         type: 'hbox',
                         align: 'stretch'
                     },
                     store: Ext.create('Ext.data.Store', {
                         fields: ['displayField', 'valueField'],
                         data: []
                     }),
                     editable: false,
                     displayField: 'displayField',
                     valueField: 'valueField',
                     queryMode: 'local'
                 }]
             }]
         }
     ]
 }]
		},
		setBlockId : function(blockId)
		{
			this.blockId = blockId;
		},
		checkspecialCharacterForMetric : function(dispMVal)
		{
			var splChar =":~!@#$%^&*+={}[]|\\;\"\<>,";
			for(var i=0; i<obj_val.length; i++)
			{
				var check_char = splChar.indexOf(obj_val.charAt(i))
				//Returns value 1 if the special character listed in splChar is found
				if(check_char >= 0)
				{
					return true;
				}
			}
		},
		fireComboSelection : function(comboObj,selectedValue)
		{
			comboObj.setValue(selectedValue);
			comboObj.fireEvent('select',comboObj);
		}
	}
)